/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.Process;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.io.Closeable;
import java.io.IOException;
import java.util.UUID;
import libcore.io.IoUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class MemoryIntArray
implements Parcelable,
Closeable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "MemoryIntArray";
    private static int MAX_SIZE = 1024;
    private int mOwnerPid;
    private boolean mClientWritable;
    private long mMemoryAddr;
    private ParcelFileDescriptor mFd;
    public static Parcelable.Creator<MemoryIntArray> CREATOR;

    private void $$robo$$android_util_MemoryIntArray$__constructor__(int size, boolean clientWritable) throws IOException {
        if (size > 1024) {
            throw new IllegalArgumentException("Max size is 1024");
        }
        this.mOwnerPid = Process.myPid();
        this.mClientWritable = clientWritable;
        String name = UUID.randomUUID().toString();
        this.mFd = ParcelFileDescriptor.fromFd(this.nativeCreate(name, size));
        this.mMemoryAddr = this.nativeOpen(this.mFd.getFd(), true, clientWritable);
    }

    private void $$robo$$android_util_MemoryIntArray$__constructor__(Parcel parcel) throws IOException {
        this.mOwnerPid = parcel.readInt();
        this.mClientWritable = parcel.readInt() == 1;
        this.mFd = (ParcelFileDescriptor)parcel.readParcelable(null);
        if (this.mFd == null) {
            throw new IOException("No backing file descriptor");
        }
        long memoryAddress = parcel.readLong();
        this.mMemoryAddr = this.isOwner() ? memoryAddress : this.nativeOpen(this.mFd.getFd(), false, this.mClientWritable);
    }

    private final boolean $$robo$$android_util_MemoryIntArray$isWritable() {
        this.enforceNotClosed();
        return this.isOwner() || this.mClientWritable;
    }

    private final int $$robo$$android_util_MemoryIntArray$get(int index) throws IOException {
        this.enforceNotClosed();
        this.enforceValidIndex(index);
        return this.nativeGet(this.mFd.getFd(), this.mMemoryAddr, index, this.isOwner());
    }

    private final void $$robo$$android_util_MemoryIntArray$set(int index, int value) throws IOException {
        this.enforceNotClosed();
        this.enforceWritable();
        this.enforceValidIndex(index);
        this.nativeSet(this.mFd.getFd(), this.mMemoryAddr, index, value, this.isOwner());
    }

    private final int $$robo$$android_util_MemoryIntArray$size() throws IOException {
        this.enforceNotClosed();
        return this.nativeSize(this.mFd.getFd());
    }

    private final void $$robo$$android_util_MemoryIntArray$close() throws IOException {
        if (!this.isClosed()) {
            ParcelFileDescriptor pfd = this.mFd;
            this.mFd = null;
            this.nativeClose(pfd.getFd(), this.mMemoryAddr, this.isOwner());
        }
    }

    private final boolean $$robo$$android_util_MemoryIntArray$isClosed() {
        return this.mFd == null;
    }

    private final void $$robo$$android_util_MemoryIntArray$finalize() throws Throwable {
        IoUtils.closeQuietly(this);
        super.finalize();
    }

    private final int $$robo$$android_util_MemoryIntArray$describeContents() {
        return 1;
    }

    private final void $$robo$$android_util_MemoryIntArray$writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.mOwnerPid);
        parcel.writeInt(this.mClientWritable ? 1 : 0);
        parcel.writeParcelable(this.mFd, 0);
        parcel.writeLong(this.mMemoryAddr);
    }

    private final boolean $$robo$$android_util_MemoryIntArray$equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MemoryIntArray other = (MemoryIntArray)obj;
        return !(this.mFd == null ? other.mFd != null : this.mFd.getFd() != other.mFd.getFd());
    }

    private final int $$robo$$android_util_MemoryIntArray$hashCode() {
        return this.mFd != null ? this.mFd.hashCode() : 1;
    }

    private final boolean $$robo$$android_util_MemoryIntArray$isOwner() {
        return this.mOwnerPid == Process.myPid();
    }

    private final void $$robo$$android_util_MemoryIntArray$enforceNotClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("cannot interact with a closed instance");
        }
    }

    private final void $$robo$$android_util_MemoryIntArray$enforceValidIndex(int index) throws IOException {
        int size = this.size();
        if (index < 0 || index > size - 1) {
            throw new IndexOutOfBoundsException(index + " not between 0 and " + (size - 1));
        }
    }

    private final void $$robo$$android_util_MemoryIntArray$enforceWritable() {
        if (!this.isWritable()) {
            throw new UnsupportedOperationException("array is not writable");
        }
    }

    private final int $$robo$$android_util_MemoryIntArray$nativeCreate(String string2, int n) {
        return 0;
    }

    private final long $$robo$$android_util_MemoryIntArray$nativeOpen(int n, boolean bl, boolean bl2) {
        return 0L;
    }

    private final void $$robo$$android_util_MemoryIntArray$nativeClose(int n, long l, boolean bl) {
    }

    private final int $$robo$$android_util_MemoryIntArray$nativeGet(int n, long l, int n2, boolean bl) {
        return 0;
    }

    private final void $$robo$$android_util_MemoryIntArray$nativeSet(int n, long l, int n2, int n3, boolean bl) {
    }

    private final int $$robo$$android_util_MemoryIntArray$nativeSize(int n) {
        return 0;
    }

    private static final int $$robo$$android_util_MemoryIntArray$getMaxSize() {
        return 1024;
    }

    private /* synthetic */ void $$robo$$android_util_MemoryIntArray$__constructor__(Parcel x0, 1 x1) throws IOException {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<MemoryIntArray>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_util_MemoryIntArray_1$__constructor__() {
            }

            private final MemoryIntArray $$robo$$android_util_MemoryIntArray_1$createFromParcel(Parcel parcel) {
                try {
                    return new MemoryIntArray(parcel);
                }
                catch (IOException ioe) {
                    Log.e("MemoryIntArray", "Error unparceling MemoryIntArray");
                    return null;
                }
            }

            private final MemoryIntArray[] $$robo$$android_util_MemoryIntArray_1$newArray(int size) {
                return new MemoryIntArray[size];
            }

            private void __constructor__() {
                this.$$robo$$android_util_MemoryIntArray_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_MemoryIntArray_1$__constructor__(), 0, this);
            }

            @Override
            public MemoryIntArray createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_util_MemoryIntArray_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public MemoryIntArray[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_util_MemoryIntArray_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(int n, boolean bl) throws IOException {
        this.$$robo$$android_util_MemoryIntArray$__constructor__(n, bl);
    }

    public MemoryIntArray(int n, boolean bl) throws IOException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_MemoryIntArray$__constructor__(int boolean ), 0, this, n, bl);
    }

    private void __constructor__(Parcel parcel) throws IOException {
        this.$$robo$$android_util_MemoryIntArray$__constructor__(parcel);
    }

    private MemoryIntArray(Parcel parcel) throws IOException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_MemoryIntArray$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    public boolean isWritable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isWritable", $$robo$$android_util_MemoryIntArray$isWritable(), 0, this);
    }

    public int get(int n) throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("get", $$robo$$android_util_MemoryIntArray$get(int ), 0, this, n);
    }

    public void set(int n, int n2) throws IOException {
        InvokeDynamicSupport.bootstrap("set", $$robo$$android_util_MemoryIntArray$set(int int ), 0, this, n, n2);
    }

    public int size() throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("size", $$robo$$android_util_MemoryIntArray$size(), 0, this);
    }

    @Override
    public void close() throws IOException {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_util_MemoryIntArray$close(), 0, this);
    }

    public boolean isClosed() {
        return (boolean)InvokeDynamicSupport.bootstrap("isClosed", $$robo$$android_util_MemoryIntArray$isClosed(), 0, this);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_util_MemoryIntArray$finalize(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_util_MemoryIntArray$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_util_MemoryIntArray$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_util_MemoryIntArray$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_util_MemoryIntArray$hashCode(), 0, this);
    }

    private boolean isOwner() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOwner", $$robo$$android_util_MemoryIntArray$isOwner(), 0, this);
    }

    private void enforceNotClosed() {
        InvokeDynamicSupport.bootstrap("enforceNotClosed", $$robo$$android_util_MemoryIntArray$enforceNotClosed(), 0, this);
    }

    private void enforceValidIndex(int n) throws IOException {
        InvokeDynamicSupport.bootstrap("enforceValidIndex", $$robo$$android_util_MemoryIntArray$enforceValidIndex(int ), 0, this, n);
    }

    private void enforceWritable() {
        InvokeDynamicSupport.bootstrap("enforceWritable", $$robo$$android_util_MemoryIntArray$enforceWritable(), 0, this);
    }

    private final native /* synthetic */ int $$robo$$nativeCreate$nativeBinding(String var1, int var2);

    private int nativeCreate(String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrap("nativeCreate", $$robo$$android_util_MemoryIntArray$nativeCreate(java.lang.String int ), 1, this, string2, n);
    }

    private final native /* synthetic */ long $$robo$$nativeOpen$nativeBinding(int var1, boolean var2, boolean var3);

    private long nativeOpen(int n, boolean bl, boolean bl2) {
        return (long)InvokeDynamicSupport.bootstrap("nativeOpen", $$robo$$android_util_MemoryIntArray$nativeOpen(int boolean boolean ), 1, this, n, bl, bl2);
    }

    private final native /* synthetic */ void $$robo$$nativeClose$nativeBinding(int var1, long var2, boolean var4);

    private void nativeClose(int n, long l, boolean bl) {
        InvokeDynamicSupport.bootstrap("nativeClose", $$robo$$android_util_MemoryIntArray$nativeClose(int long boolean ), 1, this, n, l, bl);
    }

    private final native /* synthetic */ int $$robo$$nativeGet$nativeBinding(int var1, long var2, int var4, boolean var5);

    private int nativeGet(int n, long l, int n2, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("nativeGet", $$robo$$android_util_MemoryIntArray$nativeGet(int long int boolean ), 1, this, n, l, n2, bl);
    }

    private final native /* synthetic */ void $$robo$$nativeSet$nativeBinding(int var1, long var2, int var4, int var5, boolean var6);

    private void nativeSet(int n, long l, int n2, int n3, boolean bl) {
        InvokeDynamicSupport.bootstrap("nativeSet", $$robo$$android_util_MemoryIntArray$nativeSet(int long int int boolean ), 1, this, n, l, n2, n3, bl);
    }

    private final native /* synthetic */ int $$robo$$nativeSize$nativeBinding(int var1);

    private int nativeSize(int n) {
        return (int)InvokeDynamicSupport.bootstrap("nativeSize", $$robo$$android_util_MemoryIntArray$nativeSize(int ), 1, this, n);
    }

    public static int getMaxSize() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getMaxSize", $$robo$$android_util_MemoryIntArray$getMaxSize(), 0);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) throws IOException {
        this.$$robo$$android_util_MemoryIntArray$__constructor__(parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(MemoryIntArray.class);
    }

    public /* synthetic */ MemoryIntArray() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MemoryIntArray)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

