/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.ContainerHelpers;
import android.util.Log;
import android.util.MapCollections;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import libcore.util.EmptyArray;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class ArrayMap<K, V>
implements Map<K, V> {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean DEBUG = false;
    private static String TAG = "ArrayMap";
    private static int BASE_SIZE = 4;
    private static int CACHE_SIZE = 10;
    static int[] EMPTY_IMMUTABLE_INTS;
    public static ArrayMap EMPTY;
    static Object[] mBaseCache;
    static int mBaseCacheSize;
    static Object[] mTwiceBaseCache;
    static int mTwiceBaseCacheSize;
    boolean mIdentityHashCode;
    int[] mHashes;
    Object[] mArray;
    int mSize;
    MapCollections<K, V> mCollections;

    private final int $$robo$$android_util_ArrayMap$indexOf(Object key, int hash) {
        int end;
        int N = this.mSize;
        if (N == 0) {
            return -1;
        }
        int index = ContainerHelpers.binarySearch(this.mHashes, N, hash);
        if (index < 0) {
            return index;
        }
        if (key.equals(this.mArray[index << 1])) {
            return index;
        }
        for (end = index + 1; end < N && this.mHashes[end] == hash; ++end) {
            if (!key.equals(this.mArray[end << 1])) continue;
            return end;
        }
        for (int i = index - 1; i >= 0 && this.mHashes[i] == hash; --i) {
            if (!key.equals(this.mArray[i << 1])) continue;
            return i;
        }
        return ~end;
    }

    private final int $$robo$$android_util_ArrayMap$indexOfNull() {
        int end;
        int N = this.mSize;
        if (N == 0) {
            return -1;
        }
        int index = ContainerHelpers.binarySearch(this.mHashes, N, 0);
        if (index < 0) {
            return index;
        }
        if (null == this.mArray[index << 1]) {
            return index;
        }
        for (end = index + 1; end < N && this.mHashes[end] == 0; ++end) {
            if (null != this.mArray[end << 1]) continue;
            return end;
        }
        for (int i = index - 1; i >= 0 && this.mHashes[i] == 0; --i) {
            if (null != this.mArray[i << 1]) continue;
            return i;
        }
        return ~end;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private final void $$robo$$android_util_ArrayMap$allocArrays(int size) {
        if (this.mHashes == EMPTY_IMMUTABLE_INTS) {
            throw new UnsupportedOperationException("ArrayMap is immutable");
        }
        if (size == 8) {
            Class<ArrayMap> clazz = ArrayMap.class;
            // MONITORENTER : android.util.ArrayMap.class
            if (mTwiceBaseCache != null) {
                Object[] array2 = mTwiceBaseCache;
                this.mArray = array2;
                mTwiceBaseCache = (Object[])array2[0];
                this.mHashes = (int[])array2[1];
                array2[1] = null;
                array2[0] = null;
                --mTwiceBaseCacheSize;
                // MONITOREXIT : clazz
                return;
            }
            // MONITOREXIT : clazz
        } else if (size == 4) {
            Class<ArrayMap> clazz = ArrayMap.class;
            // MONITORENTER : android.util.ArrayMap.class
            if (mBaseCache != null) {
                Object[] array3 = mBaseCache;
                this.mArray = array3;
                mBaseCache = (Object[])array3[0];
                this.mHashes = (int[])array3[1];
                array3[1] = null;
                array3[0] = null;
                --mBaseCacheSize;
                // MONITOREXIT : clazz
                return;
            }
            // MONITOREXIT : clazz
        }
        this.mHashes = new int[size];
        this.mArray = new Object[size << 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void $$robo$$android_util_ArrayMap$freeArrays(int[] hashes, Object[] array2, int size) {
        if (hashes.length == 8) {
            Class<ArrayMap> clazz = ArrayMap.class;
            synchronized (ArrayMap.class) {
                if (mTwiceBaseCacheSize >= 10) return;
                array2[0] = mTwiceBaseCache;
                array2[1] = hashes;
                for (int i = (size << 1) - 1; i >= 2; --i) {
                    array2[i] = null;
                }
                mTwiceBaseCache = array2;
                ++mTwiceBaseCacheSize;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }
        if (hashes.length != 4) return;
        Class<ArrayMap> clazz = ArrayMap.class;
        synchronized (ArrayMap.class) {
            if (mBaseCacheSize >= 10) return;
            array2[0] = mBaseCache;
            array2[1] = hashes;
            for (int i = (size << 1) - 1; i >= 2; --i) {
                array2[i] = null;
            }
            mBaseCache = array2;
            ++mBaseCacheSize;
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return;
        }
    }

    private void $$robo$$android_util_ArrayMap$__constructor__() {
    }

    private void $$robo$$android_util_ArrayMap$__constructor__(int capacity) {
    }

    private void $$robo$$android_util_ArrayMap$__constructor__(int capacity, boolean identityHashCode) {
        this.mIdentityHashCode = identityHashCode;
        if (capacity < 0) {
            this.mHashes = EMPTY_IMMUTABLE_INTS;
            this.mArray = EmptyArray.OBJECT;
        } else if (capacity == 0) {
            this.mHashes = EmptyArray.INT;
            this.mArray = EmptyArray.OBJECT;
        } else {
            this.allocArrays(capacity);
        }
        this.mSize = 0;
    }

    private void $$robo$$android_util_ArrayMap$__constructor__(ArrayMap<K, V> map) {
        if (map != null) {
            this.putAll(map);
        }
    }

    private final void $$robo$$android_util_ArrayMap$clear() {
        if (this.mSize > 0) {
            ArrayMap.freeArrays(this.mHashes, this.mArray, this.mSize);
            this.mHashes = EmptyArray.INT;
            this.mArray = EmptyArray.OBJECT;
            this.mSize = 0;
        }
    }

    private final void $$robo$$android_util_ArrayMap$erase() {
        if (this.mSize > 0) {
            int N = this.mSize << 1;
            Object[] array2 = this.mArray;
            for (int i = 0; i < N; ++i) {
                array2[i] = null;
            }
            this.mSize = 0;
        }
    }

    private final void $$robo$$android_util_ArrayMap$ensureCapacity(int minimumCapacity) {
        if (this.mHashes.length < minimumCapacity) {
            int[] ohashes = this.mHashes;
            Object[] oarray = this.mArray;
            this.allocArrays(minimumCapacity);
            if (this.mSize > 0) {
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])ohashes, (int)0, (int[])this.mHashes, (int)0, (int)this.mSize);
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)oarray, (int)0, (Object)this.mArray, (int)0, (int)(this.mSize << 1));
            }
            ArrayMap.freeArrays(ohashes, oarray, this.mSize);
        }
    }

    private final boolean $$robo$$android_util_ArrayMap$containsKey(Object key) {
        return this.indexOfKey(key) >= 0;
    }

    private final int $$robo$$android_util_ArrayMap$indexOfKey(Object key) {
        return key == null ? this.indexOfNull() : this.indexOf(key, this.mIdentityHashCode ? System.identityHashCode(key) : key.hashCode());
    }

    private final int $$robo$$android_util_ArrayMap$indexOfValue(Object value) {
        int N = this.mSize * 2;
        Object[] array2 = this.mArray;
        if (value == null) {
            for (int i = 1; i < N; i += 2) {
                if (array2[i] != null) continue;
                return i >> 1;
            }
        } else {
            for (int i = 1; i < N; i += 2) {
                if (!value.equals(array2[i])) continue;
                return i >> 1;
            }
        }
        return -1;
    }

    private final boolean $$robo$$android_util_ArrayMap$containsValue(Object value) {
        return this.indexOfValue(value) >= 0;
    }

    private final V $$robo$$android_util_ArrayMap$get(Object key) {
        int index = this.indexOfKey(key);
        return (V)(index >= 0 ? this.mArray[(index << 1) + 1] : null);
    }

    private final K $$robo$$android_util_ArrayMap$keyAt(int index) {
        return (K)this.mArray[index << 1];
    }

    private final V $$robo$$android_util_ArrayMap$valueAt(int index) {
        return (V)this.mArray[(index << 1) + 1];
    }

    private final V $$robo$$android_util_ArrayMap$setValueAt(int index, V value) {
        index = (index << 1) + 1;
        Object old = this.mArray[index];
        this.mArray[index] = value;
        return (V)old;
    }

    private final boolean $$robo$$android_util_ArrayMap$isEmpty() {
        return this.mSize <= 0;
    }

    private final V $$robo$$android_util_ArrayMap$put(K key, V value) {
        int index;
        int hash;
        if (key == null) {
            hash = 0;
            index = this.indexOfNull();
        } else {
            hash = this.mIdentityHashCode ? System.identityHashCode(key) : key.hashCode();
            index = this.indexOf(key, hash);
        }
        if (index >= 0) {
            index = (index << 1) + 1;
            Object old = this.mArray[index];
            this.mArray[index] = value;
            return (V)old;
        }
        index ^= 0xFFFFFFFF;
        if (this.mSize >= this.mHashes.length) {
            int n = this.mSize >= 8 ? this.mSize + (this.mSize >> 1) : (this.mSize >= 4 ? 8 : 4);
            int[] ohashes = this.mHashes;
            Object[] oarray = this.mArray;
            this.allocArrays(n);
            if (this.mHashes.length > 0) {
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])ohashes, (int)0, (int[])this.mHashes, (int)0, (int)ohashes.length);
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)oarray, (int)0, (Object)this.mArray, (int)0, (int)oarray.length);
            }
            ArrayMap.freeArrays(ohashes, oarray, this.mSize);
        }
        if (index < this.mSize) {
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])this.mHashes, (int)index, (int[])this.mHashes, (int)(index + 1), (int)(this.mSize - index));
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mArray, (int)(index << 1), (Object)this.mArray, (int)(index + 1 << 1), (int)(this.mSize - index << 1));
        }
        this.mHashes[index] = hash;
        this.mArray[index << 1] = key;
        this.mArray[(index << 1) + 1] = value;
        ++this.mSize;
        return null;
    }

    private final void $$robo$$android_util_ArrayMap$append(K key, V value) {
        int hash;
        int index = this.mSize;
        int n = key == null ? 0 : (hash = this.mIdentityHashCode ? System.identityHashCode(key) : key.hashCode());
        if (index >= this.mHashes.length) {
            throw new IllegalStateException("Array is full");
        }
        if (index > 0 && this.mHashes[index - 1] > hash) {
            RuntimeException e = new RuntimeException("here");
            e.fillInStackTrace();
            Log.w("ArrayMap", "New hash " + hash + " is before end of array hash " + this.mHashes[index - 1] + " at index " + index + " key " + key, e);
            this.put(key, value);
            return;
        }
        this.mSize = index + 1;
        this.mHashes[index] = hash;
        this.mArray[index <<= 1] = key;
        this.mArray[index + 1] = value;
    }

    private final void $$robo$$android_util_ArrayMap$validate() {
        int N = this.mSize;
        if (N <= 1) {
            return;
        }
        int basehash = this.mHashes[0];
        int basei = 0;
        for (int i = 1; i < N; ++i) {
            int hash = this.mHashes[i];
            if (hash != basehash) {
                basehash = hash;
                basei = i;
                continue;
            }
            Object cur = this.mArray[i << 1];
            for (int j = i - 1; j >= basei; --j) {
                Object prev = this.mArray[j << 1];
                if (cur == prev) {
                    throw new IllegalArgumentException("Duplicate key in ArrayMap: " + cur);
                }
                if (cur == null || prev == null || !cur.equals(prev)) continue;
                throw new IllegalArgumentException("Duplicate key in ArrayMap: " + cur);
            }
        }
    }

    private final void $$robo$$android_util_ArrayMap$putAll(ArrayMap<? extends K, ? extends V> array2) {
        int N = array2.mSize;
        this.ensureCapacity(this.mSize + N);
        if (this.mSize == 0) {
            if (N > 0) {
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])array2.mHashes, (int)0, (int[])this.mHashes, (int)0, (int)N);
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)array2.mArray, (int)0, (Object)this.mArray, (int)0, (int)(N << 1));
                this.mSize = N;
            }
        } else {
            for (int i = 0; i < N; ++i) {
                this.put(array2.keyAt(i), array2.valueAt(i));
            }
        }
    }

    private final V $$robo$$android_util_ArrayMap$remove(Object key) {
        int index = this.indexOfKey(key);
        if (index >= 0) {
            return this.removeAt(index);
        }
        return null;
    }

    private final V $$robo$$android_util_ArrayMap$removeAt(int index) {
        Object old = this.mArray[(index << 1) + 1];
        if (this.mSize <= 1) {
            ArrayMap.freeArrays(this.mHashes, this.mArray, this.mSize);
            this.mHashes = EmptyArray.INT;
            this.mArray = EmptyArray.OBJECT;
            this.mSize = 0;
        } else if (this.mHashes.length > 8 && this.mSize < this.mHashes.length / 3) {
            int n = this.mSize > 8 ? this.mSize + (this.mSize >> 1) : 8;
            int[] ohashes = this.mHashes;
            Object[] oarray = this.mArray;
            this.allocArrays(n);
            --this.mSize;
            if (index > 0) {
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])ohashes, (int)0, (int[])this.mHashes, (int)0, (int)index);
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)oarray, (int)0, (Object)this.mArray, (int)0, (int)(index << 1));
            }
            if (index < this.mSize) {
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])ohashes, (int)(index + 1), (int[])this.mHashes, (int)index, (int)(this.mSize - index));
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)oarray, (int)(index + 1 << 1), (Object)this.mArray, (int)(index << 1), (int)(this.mSize - index << 1));
            }
        } else {
            --this.mSize;
            if (index < this.mSize) {
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])this.mHashes, (int)(index + 1), (int[])this.mHashes, (int)index, (int)(this.mSize - index));
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mArray, (int)(index + 1 << 1), (Object)this.mArray, (int)(index << 1), (int)(this.mSize - index << 1));
            }
            this.mArray[this.mSize << 1] = null;
            this.mArray[(this.mSize << 1) + 1] = null;
        }
        return (V)old;
    }

    private final int $$robo$$android_util_ArrayMap$size() {
        return this.mSize;
    }

    private final boolean $$robo$$android_util_ArrayMap$equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            if (this.size() != map.size()) {
                return false;
            }
            try {
                for (int i = 0; i < this.mSize; ++i) {
                    K key = this.keyAt(i);
                    V mine = this.valueAt(i);
                    Object theirs = map.get(key);
                    if (!(mine == null ? theirs != null || !map.containsKey(key) : !mine.equals(theirs))) continue;
                    return false;
                }
            }
            catch (NullPointerException ignored) {
                return false;
            }
            catch (ClassCastException ignored) {
                return false;
            }
            return true;
        }
        return false;
    }

    private final int $$robo$$android_util_ArrayMap$hashCode() {
        int[] hashes = this.mHashes;
        Object[] array2 = this.mArray;
        int result = 0;
        int i = 0;
        int v = 1;
        int s = this.mSize;
        while (i < s) {
            Object value = array2[v];
            result += hashes[i] ^ (value == null ? 0 : value.hashCode());
            ++i;
            v += 2;
        }
        return result;
    }

    private final String $$robo$$android_util_ArrayMap$toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder buffer = new StringBuilder(this.mSize * 28);
        buffer.append('{');
        for (int i = 0; i < this.mSize; ++i) {
            K key;
            if (i > 0) {
                buffer.append(", ");
            }
            if ((key = this.keyAt(i)) != this) {
                buffer.append(key);
            } else {
                buffer.append("(this Map)");
            }
            buffer.append('=');
            V value = this.valueAt(i);
            if (value != this) {
                buffer.append(value);
                continue;
            }
            buffer.append("(this Map)");
        }
        buffer.append('}');
        return buffer.toString();
    }

    private final MapCollections<K, V> $$robo$$android_util_ArrayMap$getCollection() {
        if (this.mCollections == null) {
            this.mCollections = new MapCollections<K, V>(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ ArrayMap this$0;

                private void $$robo$$android_util_ArrayMap_1$__constructor__(ArrayMap this$0) {
                }

                private final int $$robo$$android_util_ArrayMap_1$colGetSize() {
                    return this.this$0.mSize;
                }

                private final Object $$robo$$android_util_ArrayMap_1$colGetEntry(int index, int offset) {
                    return this.this$0.mArray[(index << 1) + offset];
                }

                private final int $$robo$$android_util_ArrayMap_1$colIndexOfKey(Object key) {
                    return this.this$0.indexOfKey(key);
                }

                private final int $$robo$$android_util_ArrayMap_1$colIndexOfValue(Object value) {
                    return this.this$0.indexOfValue(value);
                }

                private final Map<K, V> $$robo$$android_util_ArrayMap_1$colGetMap() {
                    return this.this$0;
                }

                private final void $$robo$$android_util_ArrayMap_1$colPut(K key, V value) {
                    this.this$0.put(key, value);
                }

                private final V $$robo$$android_util_ArrayMap_1$colSetValue(int index, V value) {
                    return this.this$0.setValueAt(index, value);
                }

                private final void $$robo$$android_util_ArrayMap_1$colRemoveAt(int index) {
                    this.this$0.removeAt(index);
                }

                private final void $$robo$$android_util_ArrayMap_1$colClear() {
                    this.this$0.clear();
                }

                private void __constructor__(ArrayMap arrayMap) {
                    this.$$robo$$android_util_ArrayMap_1$__constructor__(arrayMap);
                }
                {
                    this.this$0 = arrayMap;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_ArrayMap_1$__constructor__(android.util.ArrayMap ), 0, this, arrayMap);
                }

                @Override
                protected int colGetSize() {
                    return (int)InvokeDynamicSupport.bootstrap("colGetSize", $$robo$$android_util_ArrayMap_1$colGetSize(), 0, this);
                }

                @Override
                protected Object colGetEntry(int n, int n2) {
                    return InvokeDynamicSupport.bootstrap("colGetEntry", $$robo$$android_util_ArrayMap_1$colGetEntry(int int ), 0, this, n, n2);
                }

                @Override
                protected int colIndexOfKey(Object object) {
                    return (int)InvokeDynamicSupport.bootstrap("colIndexOfKey", $$robo$$android_util_ArrayMap_1$colIndexOfKey(java.lang.Object ), 0, this, object);
                }

                @Override
                protected int colIndexOfValue(Object object) {
                    return (int)InvokeDynamicSupport.bootstrap("colIndexOfValue", $$robo$$android_util_ArrayMap_1$colIndexOfValue(java.lang.Object ), 0, this, object);
                }

                @Override
                protected Map<K, V> colGetMap() {
                    return InvokeDynamicSupport.bootstrap("colGetMap", $$robo$$android_util_ArrayMap_1$colGetMap(), 0, this);
                }

                @Override
                protected void colPut(K k, V v) {
                    InvokeDynamicSupport.bootstrap("colPut", $$robo$$android_util_ArrayMap_1$colPut(K V ), 0, this, k, v);
                }

                @Override
                protected V colSetValue(int n, V v) {
                    return InvokeDynamicSupport.bootstrap("colSetValue", $$robo$$android_util_ArrayMap_1$colSetValue(int V ), 0, this, n, v);
                }

                @Override
                protected void colRemoveAt(int n) {
                    InvokeDynamicSupport.bootstrap("colRemoveAt", $$robo$$android_util_ArrayMap_1$colRemoveAt(int ), 0, this, n);
                }

                @Override
                protected void colClear() {
                    InvokeDynamicSupport.bootstrap("colClear", $$robo$$android_util_ArrayMap_1$colClear(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }
        return this.mCollections;
    }

    private final boolean $$robo$$android_util_ArrayMap$containsAll(Collection<?> collection) {
        return MapCollections.containsAllHelper(this, collection);
    }

    private final void $$robo$$android_util_ArrayMap$putAll(Map<? extends K, ? extends V> map) {
        this.ensureCapacity(this.mSize + map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    private final boolean $$robo$$android_util_ArrayMap$removeAll(Collection<?> collection) {
        return MapCollections.removeAllHelper(this, collection);
    }

    private final boolean $$robo$$android_util_ArrayMap$retainAll(Collection<?> collection) {
        return MapCollections.retainAllHelper(this, collection);
    }

    private final Set<Map.Entry<K, V>> $$robo$$android_util_ArrayMap$entrySet() {
        return this.getCollection().getEntrySet();
    }

    private final Set<K> $$robo$$android_util_ArrayMap$keySet() {
        return this.getCollection().getKeySet();
    }

    private final Collection<V> $$robo$$android_util_ArrayMap$values() {
        return this.getCollection().getValues();
    }

    static void __staticInitializer__() {
        EMPTY_IMMUTABLE_INTS = new int[0];
        EMPTY = new ArrayMap(-1);
    }

    int indexOf(Object object, int n) {
        return (int)InvokeDynamicSupport.bootstrap("indexOf", $$robo$$android_util_ArrayMap$indexOf(java.lang.Object int ), 0, this, object, n);
    }

    int indexOfNull() {
        return (int)InvokeDynamicSupport.bootstrap("indexOfNull", $$robo$$android_util_ArrayMap$indexOfNull(), 0, this);
    }

    private void allocArrays(int n) {
        InvokeDynamicSupport.bootstrap("allocArrays", $$robo$$android_util_ArrayMap$allocArrays(int ), 0, this, n);
    }

    private static void freeArrays(int[] nArray, Object[] objectArray, int n) {
        InvokeDynamicSupport.bootstrapStatic("freeArrays", $$robo$$android_util_ArrayMap$freeArrays(int[] java.lang.Object[] int ), 0, (int[])nArray, (Object[])objectArray, (int)n);
    }

    private void __constructor__() {
        this.$$robo$$android_util_ArrayMap$__constructor__();
    }

    public ArrayMap() {
        this(0, false);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_ArrayMap$__constructor__(), 0, this);
    }

    private void __constructor__(int n) {
        this.$$robo$$android_util_ArrayMap$__constructor__(n);
    }

    public ArrayMap(int n) {
        this(n, false);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_ArrayMap$__constructor__(int ), 0, this, n);
    }

    private void __constructor__(int n, boolean bl) {
        this.$$robo$$android_util_ArrayMap$__constructor__(n, bl);
    }

    public ArrayMap(int n, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_ArrayMap$__constructor__(int boolean ), 0, this, n, bl);
    }

    private void __constructor__(ArrayMap<K, V> arrayMap) {
        this.$$robo$$android_util_ArrayMap$__constructor__(arrayMap);
    }

    public ArrayMap(ArrayMap<K, V> arrayMap) {
        this();
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_ArrayMap$__constructor__(android.util.ArrayMap<K, V> ), 0, this, arrayMap);
    }

    @Override
    public void clear() {
        InvokeDynamicSupport.bootstrap("clear", $$robo$$android_util_ArrayMap$clear(), 0, this);
    }

    public void erase() {
        InvokeDynamicSupport.bootstrap("erase", $$robo$$android_util_ArrayMap$erase(), 0, this);
    }

    public void ensureCapacity(int n) {
        InvokeDynamicSupport.bootstrap("ensureCapacity", $$robo$$android_util_ArrayMap$ensureCapacity(int ), 0, this, n);
    }

    @Override
    public boolean containsKey(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("containsKey", $$robo$$android_util_ArrayMap$containsKey(java.lang.Object ), 0, this, object);
    }

    public int indexOfKey(Object object) {
        return (int)InvokeDynamicSupport.bootstrap("indexOfKey", $$robo$$android_util_ArrayMap$indexOfKey(java.lang.Object ), 0, this, object);
    }

    int indexOfValue(Object object) {
        return (int)InvokeDynamicSupport.bootstrap("indexOfValue", $$robo$$android_util_ArrayMap$indexOfValue(java.lang.Object ), 0, this, object);
    }

    @Override
    public boolean containsValue(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("containsValue", $$robo$$android_util_ArrayMap$containsValue(java.lang.Object ), 0, this, object);
    }

    @Override
    public V get(Object object) {
        return (V)InvokeDynamicSupport.bootstrap("get", $$robo$$android_util_ArrayMap$get(java.lang.Object ), 0, this, object);
    }

    public K keyAt(int n) {
        return (K)InvokeDynamicSupport.bootstrap("keyAt", $$robo$$android_util_ArrayMap$keyAt(int ), 0, this, n);
    }

    public V valueAt(int n) {
        return (V)InvokeDynamicSupport.bootstrap("valueAt", $$robo$$android_util_ArrayMap$valueAt(int ), 0, this, n);
    }

    public V setValueAt(int n, V v) {
        return (V)InvokeDynamicSupport.bootstrap("setValueAt", $$robo$$android_util_ArrayMap$setValueAt(int V ), 0, this, n, v);
    }

    @Override
    public boolean isEmpty() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEmpty", $$robo$$android_util_ArrayMap$isEmpty(), 0, this);
    }

    @Override
    public V put(K k, V v) {
        return (V)InvokeDynamicSupport.bootstrap("put", $$robo$$android_util_ArrayMap$put(K V ), 0, this, k, v);
    }

    public void append(K k, V v) {
        InvokeDynamicSupport.bootstrap("append", $$robo$$android_util_ArrayMap$append(K V ), 0, this, k, v);
    }

    public void validate() {
        InvokeDynamicSupport.bootstrap("validate", $$robo$$android_util_ArrayMap$validate(), 0, this);
    }

    @Override
    public void putAll(ArrayMap<? extends K, ? extends V> arrayMap) {
        InvokeDynamicSupport.bootstrap("putAll", $$robo$$android_util_ArrayMap$putAll(android.util.ArrayMap<? extends K, ? extends V> ), 0, this, arrayMap);
    }

    @Override
    public V remove(Object object) {
        return (V)InvokeDynamicSupport.bootstrap("remove", $$robo$$android_util_ArrayMap$remove(java.lang.Object ), 0, this, object);
    }

    public V removeAt(int n) {
        return (V)InvokeDynamicSupport.bootstrap("removeAt", $$robo$$android_util_ArrayMap$removeAt(int ), 0, this, n);
    }

    @Override
    public int size() {
        return (int)InvokeDynamicSupport.bootstrap("size", $$robo$$android_util_ArrayMap$size(), 0, this);
    }

    @Override
    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_util_ArrayMap$equals(java.lang.Object ), 0, this, object);
    }

    @Override
    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_util_ArrayMap$hashCode(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_util_ArrayMap$toString(), 0, this);
    }

    private MapCollections<K, V> getCollection() {
        return InvokeDynamicSupport.bootstrap("getCollection", $$robo$$android_util_ArrayMap$getCollection(), 0, this);
    }

    public boolean containsAll(Collection<?> collection) {
        return (boolean)InvokeDynamicSupport.bootstrap("containsAll", $$robo$$android_util_ArrayMap$containsAll(java.util.Collection<?> ), 0, this, collection);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        InvokeDynamicSupport.bootstrap("putAll", $$robo$$android_util_ArrayMap$putAll(java.util.Map<? extends K, ? extends V> ), 0, this, map);
    }

    public boolean removeAll(Collection<?> collection) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeAll", $$robo$$android_util_ArrayMap$removeAll(java.util.Collection<?> ), 0, this, collection);
    }

    public boolean retainAll(Collection<?> collection) {
        return (boolean)InvokeDynamicSupport.bootstrap("retainAll", $$robo$$android_util_ArrayMap$retainAll(java.util.Collection<?> ), 0, this, collection);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return InvokeDynamicSupport.bootstrap("entrySet", $$robo$$android_util_ArrayMap$entrySet(), 0, this);
    }

    @Override
    public Set<K> keySet() {
        return InvokeDynamicSupport.bootstrap("keySet", $$robo$$android_util_ArrayMap$keySet(), 0, this);
    }

    @Override
    public Collection<V> values() {
        return InvokeDynamicSupport.bootstrap("values", $$robo$$android_util_ArrayMap$values(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(ArrayMap.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ArrayMap)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

