/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.telephony.PhoneNumberUtils;
import android.text.Editable;
import android.text.Selection;
import android.text.TextWatcher;
import com.android.i18n.phonenumbers.AsYouTypeFormatter;
import com.android.i18n.phonenumbers.PhoneNumberUtil;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class PhoneNumberFormattingTextWatcher
implements TextWatcher,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private boolean mSelfChange;
    private boolean mStopFormatting;
    private AsYouTypeFormatter mFormatter;

    private void $$robo$$android_telephony_PhoneNumberFormattingTextWatcher$__constructor__() {
    }

    private void $$robo$$android_telephony_PhoneNumberFormattingTextWatcher$__constructor__(String countryCode) {
        this.mSelfChange = false;
        if (countryCode == null) {
            throw new IllegalArgumentException();
        }
        this.mFormatter = PhoneNumberUtil.getInstance().getAsYouTypeFormatter(countryCode);
    }

    private final void $$robo$$android_telephony_PhoneNumberFormattingTextWatcher$beforeTextChanged(CharSequence s, int start, int count, int after) {
        if (this.mSelfChange || this.mStopFormatting) {
            return;
        }
        if (count > 0 && this.hasSeparator(s, start, count)) {
            this.stopFormatting();
        }
    }

    private final void $$robo$$android_telephony_PhoneNumberFormattingTextWatcher$onTextChanged(CharSequence s, int start, int before, int count) {
        if (this.mSelfChange || this.mStopFormatting) {
            return;
        }
        if (count > 0 && this.hasSeparator(s, start, count)) {
            this.stopFormatting();
        }
    }

    private final synchronized void $$robo$$android_telephony_PhoneNumberFormattingTextWatcher$afterTextChanged(Editable s) {
        if (this.mStopFormatting) {
            this.mStopFormatting = s.length() != 0;
            return;
        }
        if (this.mSelfChange) {
            return;
        }
        String formatted = this.reformat(s, Selection.getSelectionEnd(s));
        if (formatted != null) {
            int rememberedPos = this.mFormatter.getRememberedPosition();
            this.mSelfChange = true;
            s.replace(0, s.length(), formatted, 0, formatted.length());
            if (formatted.equals(s.toString())) {
                Selection.setSelection(s, rememberedPos);
            }
            this.mSelfChange = false;
        }
        PhoneNumberUtils.ttsSpanAsPhoneNumber(s, 0, s.length());
    }

    private final String $$robo$$android_telephony_PhoneNumberFormattingTextWatcher$reformat(CharSequence s, int cursor) {
        int curIndex = cursor - 1;
        String formatted = null;
        this.mFormatter.clear();
        char lastNonSeparator = '\u0000';
        boolean hasCursor = false;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (PhoneNumberUtils.isNonSeparator(c)) {
                if (lastNonSeparator != '\u0000') {
                    formatted = this.getFormattedNumber(lastNonSeparator, hasCursor);
                    hasCursor = false;
                }
                lastNonSeparator = c;
            }
            if (i != curIndex) continue;
            hasCursor = true;
        }
        if (lastNonSeparator != '\u0000') {
            formatted = this.getFormattedNumber(lastNonSeparator, hasCursor);
        }
        return formatted;
    }

    private final String $$robo$$android_telephony_PhoneNumberFormattingTextWatcher$getFormattedNumber(char lastNonSeparator, boolean hasCursor) {
        return hasCursor ? this.mFormatter.inputDigitAndRememberPosition(lastNonSeparator) : this.mFormatter.inputDigit(lastNonSeparator);
    }

    private final void $$robo$$android_telephony_PhoneNumberFormattingTextWatcher$stopFormatting() {
        this.mStopFormatting = true;
        this.mFormatter.clear();
    }

    private final boolean $$robo$$android_telephony_PhoneNumberFormattingTextWatcher$hasSeparator(CharSequence s, int start, int count) {
        for (int i = start; i < start + count; ++i) {
            char c = s.charAt(i);
            if (PhoneNumberUtils.isNonSeparator(c)) continue;
            return true;
        }
        return false;
    }

    private void __constructor__() {
        this.$$robo$$android_telephony_PhoneNumberFormattingTextWatcher$__constructor__();
    }

    public PhoneNumberFormattingTextWatcher() {
        this(Locale.getDefault().getCountry());
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_PhoneNumberFormattingTextWatcher$__constructor__(), 0, this);
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_telephony_PhoneNumberFormattingTextWatcher$__constructor__(string2);
    }

    public PhoneNumberFormattingTextWatcher(String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_PhoneNumberFormattingTextWatcher$__constructor__(java.lang.String ), 0, this, string2);
    }

    @Override
    public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("beforeTextChanged", $$robo$$android_telephony_PhoneNumberFormattingTextWatcher$beforeTextChanged(java.lang.CharSequence int int int ), 0, this, charSequence, n, n2, n3);
    }

    @Override
    public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("onTextChanged", $$robo$$android_telephony_PhoneNumberFormattingTextWatcher$onTextChanged(java.lang.CharSequence int int int ), 0, this, charSequence, n, n2, n3);
    }

    @Override
    public synchronized void afterTextChanged(Editable editable) {
        InvokeDynamicSupport.bootstrap("afterTextChanged", $$robo$$android_telephony_PhoneNumberFormattingTextWatcher$afterTextChanged(android.text.Editable ), 0, this, editable);
    }

    private String reformat(CharSequence charSequence, int n) {
        return InvokeDynamicSupport.bootstrap("reformat", $$robo$$android_telephony_PhoneNumberFormattingTextWatcher$reformat(java.lang.CharSequence int ), 0, this, charSequence, n);
    }

    private String getFormattedNumber(char c, boolean bl) {
        return InvokeDynamicSupport.bootstrap("getFormattedNumber", $$robo$$android_telephony_PhoneNumberFormattingTextWatcher$getFormattedNumber(char boolean ), 0, this, c, bl);
    }

    private void stopFormatting() {
        InvokeDynamicSupport.bootstrap("stopFormatting", $$robo$$android_telephony_PhoneNumberFormattingTextWatcher$stopFormatting(), 0, this);
    }

    private boolean hasSeparator(CharSequence charSequence, int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasSeparator", $$robo$$android_telephony_PhoneNumberFormattingTextWatcher$hasSeparator(java.lang.CharSequence int int ), 0, this, charSequence, n, n2);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PhoneNumberFormattingTextWatcher)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

