/*
 * Decompiled with CFR 0.152.
 */
package android.speech.tts;

import android.speech.tts.PlaybackQueueItem;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingQueue;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AudioPlaybackHandler
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "TTS.AudioPlaybackHandler";
    private static boolean DBG = false;
    private LinkedBlockingQueue<PlaybackQueueItem> mQueue;
    private Thread mHandlerThread;
    private volatile PlaybackQueueItem mCurrentWorkItem;

    private void $$robo$$android_speech_tts_AudioPlaybackHandler$__constructor__() {
        this.mQueue = new LinkedBlockingQueue();
        this.mCurrentWorkItem = null;
        this.mHandlerThread = new Thread((Runnable)new MessageLoop(this), "TTS.AudioPlaybackThread");
    }

    private final void $$robo$$android_speech_tts_AudioPlaybackHandler$start() {
        this.mHandlerThread.start();
    }

    private final void $$robo$$android_speech_tts_AudioPlaybackHandler$stop(PlaybackQueueItem item) {
        if (item == null) {
            return;
        }
        item.stop(-2);
    }

    private final void $$robo$$android_speech_tts_AudioPlaybackHandler$enqueue(PlaybackQueueItem item) {
        try {
            this.mQueue.put(item);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_speech_tts_AudioPlaybackHandler$stopForApp(Object callerIdentity) {
        this.removeWorkItemsFor(callerIdentity);
        PlaybackQueueItem current = this.mCurrentWorkItem;
        if (current != null && current.getCallerIdentity() == callerIdentity) {
            this.stop(current);
        }
    }

    private final void $$robo$$android_speech_tts_AudioPlaybackHandler$stop() {
        this.removeAllMessages();
        this.stop(this.mCurrentWorkItem);
    }

    private final boolean $$robo$$android_speech_tts_AudioPlaybackHandler$isSpeaking() {
        return this.mQueue.peek() != null || this.mCurrentWorkItem != null;
    }

    private final void $$robo$$android_speech_tts_AudioPlaybackHandler$quit() {
        this.removeAllMessages();
        this.stop(this.mCurrentWorkItem);
        this.mHandlerThread.interrupt();
    }

    private final void $$robo$$android_speech_tts_AudioPlaybackHandler$removeAllMessages() {
        this.mQueue.clear();
    }

    private final void $$robo$$android_speech_tts_AudioPlaybackHandler$removeWorkItemsFor(Object callerIdentity) {
        Iterator<PlaybackQueueItem> it = this.mQueue.iterator();
        while (it.hasNext()) {
            PlaybackQueueItem item = it.next();
            if (item.getCallerIdentity() != callerIdentity) continue;
            it.remove();
        }
    }

    private void __constructor__() {
        this.$$robo$$android_speech_tts_AudioPlaybackHandler$__constructor__();
    }

    AudioPlaybackHandler() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_AudioPlaybackHandler$__constructor__(), 0, this);
    }

    public void start() {
        InvokeDynamicSupport.bootstrap("start", $$robo$$android_speech_tts_AudioPlaybackHandler$start(), 0, this);
    }

    private void stop(PlaybackQueueItem playbackQueueItem) {
        InvokeDynamicSupport.bootstrap("stop", $$robo$$android_speech_tts_AudioPlaybackHandler$stop(android.speech.tts.PlaybackQueueItem ), 0, this, playbackQueueItem);
    }

    public void enqueue(PlaybackQueueItem playbackQueueItem) {
        InvokeDynamicSupport.bootstrap("enqueue", $$robo$$android_speech_tts_AudioPlaybackHandler$enqueue(android.speech.tts.PlaybackQueueItem ), 0, this, playbackQueueItem);
    }

    public void stopForApp(Object object) {
        InvokeDynamicSupport.bootstrap("stopForApp", $$robo$$android_speech_tts_AudioPlaybackHandler$stopForApp(java.lang.Object ), 0, this, object);
    }

    public void stop() {
        InvokeDynamicSupport.bootstrap("stop", $$robo$$android_speech_tts_AudioPlaybackHandler$stop(), 0, this);
    }

    public boolean isSpeaking() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSpeaking", $$robo$$android_speech_tts_AudioPlaybackHandler$isSpeaking(), 0, this);
    }

    public void quit() {
        InvokeDynamicSupport.bootstrap("quit", $$robo$$android_speech_tts_AudioPlaybackHandler$quit(), 0, this);
    }

    private void removeAllMessages() {
        InvokeDynamicSupport.bootstrap("removeAllMessages", $$robo$$android_speech_tts_AudioPlaybackHandler$removeAllMessages(), 0, this);
    }

    private void removeWorkItemsFor(Object object) {
        InvokeDynamicSupport.bootstrap("removeWorkItemsFor", $$robo$$android_speech_tts_AudioPlaybackHandler$removeWorkItemsFor(java.lang.Object ), 0, this, object);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AudioPlaybackHandler)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private final class MessageLoop
    implements Runnable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ AudioPlaybackHandler this$0;

        private void $$robo$$android_speech_tts_AudioPlaybackHandler_MessageLoop$__constructor__(AudioPlaybackHandler audioPlaybackHandler) {
        }

        private final void $$robo$$android_speech_tts_AudioPlaybackHandler_MessageLoop$run() {
            while (true) {
                PlaybackQueueItem item = null;
                try {
                    item = (PlaybackQueueItem)this.this$0.mQueue.take();
                }
                catch (InterruptedException ie) {
                    return;
                }
                this.this$0.mCurrentWorkItem = item;
                item.run();
                this.this$0.mCurrentWorkItem = null;
            }
        }

        private /* synthetic */ void $$robo$$android_speech_tts_AudioPlaybackHandler_MessageLoop$__constructor__(AudioPlaybackHandler x0, 1 x1) {
        }

        private void __constructor__(AudioPlaybackHandler audioPlaybackHandler) {
            this.$$robo$$android_speech_tts_AudioPlaybackHandler_MessageLoop$__constructor__(audioPlaybackHandler);
        }

        private MessageLoop(AudioPlaybackHandler audioPlaybackHandler) {
            this.this$0 = audioPlaybackHandler;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_AudioPlaybackHandler_MessageLoop$__constructor__(android.speech.tts.AudioPlaybackHandler ), 0, this, audioPlaybackHandler);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_speech_tts_AudioPlaybackHandler_MessageLoop$run(), 0, this);
        }

        private /* synthetic */ void __constructor__(AudioPlaybackHandler audioPlaybackHandler, 1 var2_2) {
            this.$$robo$$android_speech_tts_AudioPlaybackHandler_MessageLoop$__constructor__(audioPlaybackHandler, var2_2);
        }

        public /* synthetic */ MessageLoop() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MessageLoop)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

