/*
 * Decompiled with CFR 0.152.
 */
package android.service.trust;

import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.service.trust.ITrustAgentService;
import android.service.trust.ITrustAgentServiceCallback;
import android.util.Log;
import android.util.Slog;
import com.google.errorprone.annotations.DoNotMock;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TrustAgentService
extends Service
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private String TAG;
    private static boolean DEBUG = false;
    public static String SERVICE_INTERFACE = "android.service.trust.TrustAgentService";
    public static String TRUST_AGENT_META_DATA = "android.service.trust.trustagent";
    public static int FLAG_GRANT_TRUST_INITIATED_BY_USER = 1;
    public static int FLAG_GRANT_TRUST_DISMISS_KEYGUARD = 2;
    private static int MSG_UNLOCK_ATTEMPT = 1;
    private static int MSG_CONFIGURE = 2;
    private static int MSG_TRUST_TIMEOUT = 3;
    private static int MSG_DEVICE_LOCKED = 4;
    private static int MSG_DEVICE_UNLOCKED = 5;
    private ITrustAgentServiceCallback mCallback;
    private Runnable mPendingGrantTrustTask;
    private boolean mManagingTrust;
    private Object mLock;
    private Handler mHandler;

    private void $$robo$$android_service_trust_TrustAgentService$__constructor__() {
        this.TAG = TrustAgentService.class.getSimpleName() + "[" + this.getClass().getSimpleName() + "]";
        this.mLock = new Object();
        this.mHandler = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ TrustAgentService this$0;

            private void $$robo$$android_service_trust_TrustAgentService_1$__constructor__(TrustAgentService this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final void $$robo$$android_service_trust_TrustAgentService_1$handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        this.this$0.onUnlockAttempt(msg.arg1 != 0);
                        return;
                    }
                    case 2: {
                        ConfigurationData data = (ConfigurationData)msg.obj;
                        boolean result = this.this$0.onConfigure(data.options);
                        if (data.token == null) return;
                        try {
                            Object object = this.this$0.mLock;
                            synchronized (object) {
                                this.this$0.mCallback.onConfigureCompleted(result, data.token);
                                return;
                            }
                        }
                        catch (RemoteException e) {
                            this.this$0.onError("calling onSetTrustAgentFeaturesEnabledCompleted()");
                        }
                        return;
                    }
                    case 3: {
                        this.this$0.onTrustTimeout();
                        return;
                    }
                    case 4: {
                        this.this$0.onDeviceLocked();
                        return;
                    }
                    case 5: {
                        this.this$0.onDeviceUnlocked();
                    }
                }
            }

            private void __constructor__(TrustAgentService trustAgentService) {
                this.$$robo$$android_service_trust_TrustAgentService_1$__constructor__(trustAgentService);
            }
            {
                this.this$0 = trustAgentService;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_trust_TrustAgentService_1$__constructor__(android.service.trust.TrustAgentService ), 0, this, trustAgentService);
            }

            @Override
            public void handleMessage(Message message) {
                InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_service_trust_TrustAgentService_1$handleMessage(android.os.Message ), 0, this, message);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private final void $$robo$$android_service_trust_TrustAgentService$onCreate() {
        super.onCreate();
        ComponentName component = new ComponentName((Context)this, this.getClass());
        try {
            ServiceInfo serviceInfo = this.getPackageManager().getServiceInfo(component, 0);
            if (!"android.permission.BIND_TRUST_AGENT".equals(serviceInfo.permission)) {
                throw new IllegalStateException(component.flattenToShortString() + " is not declared with the permission \"" + "android.permission.BIND_TRUST_AGENT" + "\"");
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e(this.TAG, "Can't get ServiceInfo for " + component.toShortString());
        }
    }

    private final void $$robo$$android_service_trust_TrustAgentService$onUnlockAttempt(boolean successful) {
    }

    private final void $$robo$$android_service_trust_TrustAgentService$onTrustTimeout() {
    }

    private final void $$robo$$android_service_trust_TrustAgentService$onDeviceLocked() {
    }

    private final void $$robo$$android_service_trust_TrustAgentService$onDeviceUnlocked() {
    }

    private final void $$robo$$android_service_trust_TrustAgentService$onError(String msg) {
        Slog.v(this.TAG, "Remote exception while " + msg);
    }

    private final boolean $$robo$$android_service_trust_TrustAgentService$onConfigure(List<PersistableBundle> options) {
        return false;
    }

    @Deprecated
    private final void $$robo$$android_service_trust_TrustAgentService$grantTrust(CharSequence message, long durationMs, boolean initiatedByUser) {
        this.grantTrust(message, durationMs, initiatedByUser ? 1 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_service_trust_TrustAgentService$grantTrust(CharSequence message, long durationMs, int flags) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mManagingTrust) {
                throw new IllegalStateException("Cannot grant trust if agent is not managing trust. Call setManagingTrust(true) first.");
            }
            if (this.mCallback != null) {
                try {
                    this.mCallback.grantTrust(message.toString(), durationMs, flags);
                }
                catch (RemoteException e) {
                    this.onError("calling enableTrust()");
                }
            } else {
                this.mPendingGrantTrustTask = new Runnable(this, message, durationMs, flags){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ CharSequence val$message;
                    /* synthetic */ long val$durationMs;
                    /* synthetic */ int val$flags;
                    /* synthetic */ TrustAgentService this$0;

                    private void $$robo$$android_service_trust_TrustAgentService_2$__constructor__(TrustAgentService this$0, CharSequence charSequence, long l, int n) {
                    }

                    private final void $$robo$$android_service_trust_TrustAgentService_2$run() {
                        this.this$0.grantTrust(this.val$message, this.val$durationMs, this.val$flags);
                    }

                    private void __constructor__(TrustAgentService trustAgentService, CharSequence charSequence, long l, int n) {
                        this.$$robo$$android_service_trust_TrustAgentService_2$__constructor__(trustAgentService, charSequence, l, n);
                    }
                    {
                        this.this$0 = trustAgentService;
                        this.val$message = charSequence;
                        this.val$durationMs = l;
                        this.val$flags = n;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_trust_TrustAgentService_2$__constructor__(android.service.trust.TrustAgentService java.lang.CharSequence long int ), 0, this, trustAgentService, charSequence, l, n);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_service_trust_TrustAgentService_2$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                };
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_service_trust_TrustAgentService$revokeTrust() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPendingGrantTrustTask != null) {
                this.mPendingGrantTrustTask = null;
            }
            if (this.mCallback != null) {
                try {
                    this.mCallback.revokeTrust();
                }
                catch (RemoteException e) {
                    this.onError("calling revokeTrust()");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_service_trust_TrustAgentService$setManagingTrust(boolean managingTrust) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mManagingTrust != managingTrust) {
                this.mManagingTrust = managingTrust;
                if (this.mCallback != null) {
                    try {
                        this.mCallback.setManagingTrust(managingTrust);
                    }
                    catch (RemoteException e) {
                        this.onError("calling setManagingTrust()");
                    }
                }
            }
        }
    }

    private final IBinder $$robo$$android_service_trust_TrustAgentService$onBind(Intent intent) {
        return new TrustAgentServiceWrapper(this);
    }

    private void __constructor__() {
        this.$$robo$$android_service_trust_TrustAgentService$__constructor__();
    }

    public TrustAgentService() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_trust_TrustAgentService$__constructor__(), 0, this);
    }

    @Override
    public void onCreate() {
        InvokeDynamicSupport.bootstrap("onCreate", $$robo$$android_service_trust_TrustAgentService$onCreate(), 0, this);
    }

    public void onUnlockAttempt(boolean bl) {
        InvokeDynamicSupport.bootstrap("onUnlockAttempt", $$robo$$android_service_trust_TrustAgentService$onUnlockAttempt(boolean ), 0, this, bl);
    }

    public void onTrustTimeout() {
        InvokeDynamicSupport.bootstrap("onTrustTimeout", $$robo$$android_service_trust_TrustAgentService$onTrustTimeout(), 0, this);
    }

    public void onDeviceLocked() {
        InvokeDynamicSupport.bootstrap("onDeviceLocked", $$robo$$android_service_trust_TrustAgentService$onDeviceLocked(), 0, this);
    }

    public void onDeviceUnlocked() {
        InvokeDynamicSupport.bootstrap("onDeviceUnlocked", $$robo$$android_service_trust_TrustAgentService$onDeviceUnlocked(), 0, this);
    }

    private void onError(String string2) {
        InvokeDynamicSupport.bootstrap("onError", $$robo$$android_service_trust_TrustAgentService$onError(java.lang.String ), 0, this, string2);
    }

    public boolean onConfigure(List<PersistableBundle> list) {
        return (boolean)InvokeDynamicSupport.bootstrap("onConfigure", $$robo$$android_service_trust_TrustAgentService$onConfigure(java.util.List<android.os.PersistableBundle> ), 0, this, list);
    }

    @Deprecated
    public void grantTrust(CharSequence charSequence, long l, boolean bl) {
        InvokeDynamicSupport.bootstrap("grantTrust", $$robo$$android_service_trust_TrustAgentService$grantTrust(java.lang.CharSequence long boolean ), 0, this, charSequence, l, bl);
    }

    public void grantTrust(CharSequence charSequence, long l, int n) {
        InvokeDynamicSupport.bootstrap("grantTrust", $$robo$$android_service_trust_TrustAgentService$grantTrust(java.lang.CharSequence long int ), 0, this, charSequence, l, n);
    }

    public void revokeTrust() {
        InvokeDynamicSupport.bootstrap("revokeTrust", $$robo$$android_service_trust_TrustAgentService$revokeTrust(), 0, this);
    }

    public void setManagingTrust(boolean bl) {
        InvokeDynamicSupport.bootstrap("setManagingTrust", $$robo$$android_service_trust_TrustAgentService$setManagingTrust(boolean ), 0, this, bl);
    }

    @Override
    public IBinder onBind(Intent intent) {
        return InvokeDynamicSupport.bootstrap("onBind", $$robo$$android_service_trust_TrustAgentService$onBind(android.content.Intent ), 0, this, intent);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TrustAgentService)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private final class TrustAgentServiceWrapper
    extends ITrustAgentService.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ TrustAgentService this$0;

        private void $$robo$$android_service_trust_TrustAgentService_TrustAgentServiceWrapper$__constructor__(TrustAgentService trustAgentService) {
        }

        private final void $$robo$$android_service_trust_TrustAgentService_TrustAgentServiceWrapper$onUnlockAttempt(boolean successful) {
            this.this$0.mHandler.obtainMessage(1, successful ? 1 : 0, 0).sendToTarget();
        }

        private final void $$robo$$android_service_trust_TrustAgentService_TrustAgentServiceWrapper$onTrustTimeout() {
            this.this$0.mHandler.sendEmptyMessage(3);
        }

        private final void $$robo$$android_service_trust_TrustAgentService_TrustAgentServiceWrapper$onConfigure(List<PersistableBundle> args, IBinder token) {
            this.this$0.mHandler.obtainMessage(2, new ConfigurationData(args, token)).sendToTarget();
        }

        private final void $$robo$$android_service_trust_TrustAgentService_TrustAgentServiceWrapper$onDeviceLocked() throws RemoteException {
            this.this$0.mHandler.obtainMessage(4).sendToTarget();
        }

        private final void $$robo$$android_service_trust_TrustAgentService_TrustAgentServiceWrapper$onDeviceUnlocked() throws RemoteException {
            this.this$0.mHandler.obtainMessage(5).sendToTarget();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_service_trust_TrustAgentService_TrustAgentServiceWrapper$setCallback(ITrustAgentServiceCallback callback) {
            Object object = this.this$0.mLock;
            synchronized (object) {
                this.this$0.mCallback = callback;
                if (this.this$0.mManagingTrust) {
                    try {
                        this.this$0.mCallback.setManagingTrust(this.this$0.mManagingTrust);
                    }
                    catch (RemoteException e) {
                        this.this$0.onError("calling setManagingTrust()");
                    }
                }
                if (this.this$0.mPendingGrantTrustTask != null) {
                    this.this$0.mPendingGrantTrustTask.run();
                    this.this$0.mPendingGrantTrustTask = null;
                }
            }
        }

        private /* synthetic */ void $$robo$$android_service_trust_TrustAgentService_TrustAgentServiceWrapper$__constructor__(TrustAgentService x0, 1 x1) {
        }

        private void __constructor__(TrustAgentService trustAgentService) {
            this.$$robo$$android_service_trust_TrustAgentService_TrustAgentServiceWrapper$__constructor__(trustAgentService);
        }

        private TrustAgentServiceWrapper(TrustAgentService trustAgentService) {
            this.this$0 = trustAgentService;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_trust_TrustAgentService_TrustAgentServiceWrapper$__constructor__(android.service.trust.TrustAgentService ), 0, this, trustAgentService);
        }

        @Override
        public void onUnlockAttempt(boolean bl) {
            InvokeDynamicSupport.bootstrap("onUnlockAttempt", $$robo$$android_service_trust_TrustAgentService_TrustAgentServiceWrapper$onUnlockAttempt(boolean ), 0, this, bl);
        }

        @Override
        public void onTrustTimeout() {
            InvokeDynamicSupport.bootstrap("onTrustTimeout", $$robo$$android_service_trust_TrustAgentService_TrustAgentServiceWrapper$onTrustTimeout(), 0, this);
        }

        @Override
        public void onConfigure(List<PersistableBundle> list, IBinder iBinder) {
            InvokeDynamicSupport.bootstrap("onConfigure", $$robo$$android_service_trust_TrustAgentService_TrustAgentServiceWrapper$onConfigure(java.util.List<android.os.PersistableBundle> android.os.IBinder ), 0, this, list, iBinder);
        }

        @Override
        public void onDeviceLocked() throws RemoteException {
            InvokeDynamicSupport.bootstrap("onDeviceLocked", $$robo$$android_service_trust_TrustAgentService_TrustAgentServiceWrapper$onDeviceLocked(), 0, this);
        }

        @Override
        public void onDeviceUnlocked() throws RemoteException {
            InvokeDynamicSupport.bootstrap("onDeviceUnlocked", $$robo$$android_service_trust_TrustAgentService_TrustAgentServiceWrapper$onDeviceUnlocked(), 0, this);
        }

        @Override
        public void setCallback(ITrustAgentServiceCallback iTrustAgentServiceCallback) {
            InvokeDynamicSupport.bootstrap("setCallback", $$robo$$android_service_trust_TrustAgentService_TrustAgentServiceWrapper$setCallback(android.service.trust.ITrustAgentServiceCallback ), 0, this, iTrustAgentServiceCallback);
        }

        private /* synthetic */ void __constructor__(TrustAgentService trustAgentService, 1 var2_2) {
            this.$$robo$$android_service_trust_TrustAgentService_TrustAgentServiceWrapper$__constructor__(trustAgentService, var2_2);
        }

        public /* synthetic */ TrustAgentServiceWrapper() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TrustAgentServiceWrapper)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class ConfigurationData
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        IBinder token;
        List<PersistableBundle> options;

        private void $$robo$$android_service_trust_TrustAgentService_ConfigurationData$__constructor__(List<PersistableBundle> opts, IBinder t) {
            this.options = opts;
            this.token = t;
        }

        private void __constructor__(List<PersistableBundle> list, IBinder iBinder) {
            this.$$robo$$android_service_trust_TrustAgentService_ConfigurationData$__constructor__(list, iBinder);
        }

        ConfigurationData(List<PersistableBundle> list, IBinder iBinder) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_trust_TrustAgentService_ConfigurationData$__constructor__(java.util.List<android.os.PersistableBundle> android.os.IBinder ), 0, this, list, iBinder);
        }

        public /* synthetic */ ConfigurationData() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ConfigurationData)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

