/*
 * Decompiled with CFR 0.152.
 */
package android.service.notification;

import android.app.ActivityManager;
import android.app.NotificationManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.Settings;
import android.service.notification.Condition;
import android.text.TextUtils;
import android.text.format.DateFormat;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Slog;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class ZenModeConfig
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG;
    public static int SOURCE_ANYONE = 0;
    public static int SOURCE_CONTACT = 1;
    public static int SOURCE_STAR = 2;
    public static int MAX_SOURCE = 2;
    private static int DEFAULT_SOURCE = 1;
    public static int[] ALL_DAYS;
    public static int[] WEEKNIGHT_DAYS;
    public static int[] WEEKEND_DAYS;
    public static int[] MINUTE_BUCKETS;
    private static int SECONDS_MS = 1000;
    private static int MINUTES_MS = 60000;
    private static int DAY_MINUTES = 1440;
    private static int ZERO_VALUE_MS = 10000;
    private static boolean DEFAULT_ALLOW_CALLS = true;
    private static boolean DEFAULT_ALLOW_MESSAGES = false;
    private static boolean DEFAULT_ALLOW_REMINDERS = true;
    private static boolean DEFAULT_ALLOW_EVENTS = true;
    private static boolean DEFAULT_ALLOW_REPEAT_CALLERS = false;
    private static boolean DEFAULT_ALLOW_SCREEN_OFF = true;
    private static boolean DEFAULT_ALLOW_SCREEN_ON = true;
    private static int XML_VERSION = 2;
    private static String ZEN_TAG = "zen";
    private static String ZEN_ATT_VERSION = "version";
    private static String ZEN_ATT_USER = "user";
    private static String ALLOW_TAG = "allow";
    private static String ALLOW_ATT_CALLS = "calls";
    private static String ALLOW_ATT_REPEAT_CALLERS = "repeatCallers";
    private static String ALLOW_ATT_MESSAGES = "messages";
    private static String ALLOW_ATT_FROM = "from";
    private static String ALLOW_ATT_CALLS_FROM = "callsFrom";
    private static String ALLOW_ATT_MESSAGES_FROM = "messagesFrom";
    private static String ALLOW_ATT_REMINDERS = "reminders";
    private static String ALLOW_ATT_EVENTS = "events";
    private static String ALLOW_ATT_SCREEN_OFF = "visualScreenOff";
    private static String ALLOW_ATT_SCREEN_ON = "visualScreenOn";
    private static String CONDITION_TAG = "condition";
    private static String CONDITION_ATT_COMPONENT = "component";
    private static String CONDITION_ATT_ID = "id";
    private static String CONDITION_ATT_SUMMARY = "summary";
    private static String CONDITION_ATT_LINE1 = "line1";
    private static String CONDITION_ATT_LINE2 = "line2";
    private static String CONDITION_ATT_ICON = "icon";
    private static String CONDITION_ATT_STATE = "state";
    private static String CONDITION_ATT_FLAGS = "flags";
    private static String MANUAL_TAG = "manual";
    private static String AUTOMATIC_TAG = "automatic";
    private static String RULE_ATT_ID = "ruleId";
    private static String RULE_ATT_ENABLED = "enabled";
    private static String RULE_ATT_SNOOZING = "snoozing";
    private static String RULE_ATT_NAME = "name";
    private static String RULE_ATT_COMPONENT = "component";
    private static String RULE_ATT_ZEN = "zen";
    private static String RULE_ATT_CONDITION_ID = "conditionId";
    private static String RULE_ATT_CREATION_TIME = "creationTime";
    public boolean allowCalls;
    public boolean allowRepeatCallers;
    public boolean allowMessages;
    public boolean allowReminders;
    public boolean allowEvents;
    public int allowCallsFrom;
    public int allowMessagesFrom;
    public int user;
    public boolean allowWhenScreenOff;
    public boolean allowWhenScreenOn;
    public ZenRule manualRule;
    public ArrayMap<String, ZenRule> automaticRules;
    public static Parcelable.Creator<ZenModeConfig> CREATOR;
    public static String SYSTEM_AUTHORITY = "android";
    public static String COUNTDOWN_PATH = "countdown";
    public static String SCHEDULE_PATH = "schedule";
    public static String EVENT_PATH = "event";

    private void $$robo$$android_service_notification_ZenModeConfig$__constructor__() {
        this.allowCalls = true;
        this.allowRepeatCallers = false;
        this.allowMessages = false;
        this.allowReminders = true;
        this.allowEvents = true;
        this.allowCallsFrom = 1;
        this.allowMessagesFrom = 1;
        this.user = 0;
        this.allowWhenScreenOff = true;
        this.allowWhenScreenOn = true;
        this.automaticRules = new ArrayMap();
    }

    private void $$robo$$android_service_notification_ZenModeConfig$__constructor__(Parcel source) {
        this.allowCalls = true;
        this.allowRepeatCallers = false;
        this.allowMessages = false;
        this.allowReminders = true;
        this.allowEvents = true;
        this.allowCallsFrom = 1;
        this.allowMessagesFrom = 1;
        this.user = 0;
        this.allowWhenScreenOff = true;
        this.allowWhenScreenOn = true;
        this.automaticRules = new ArrayMap();
        this.allowCalls = source.readInt() == 1;
        this.allowRepeatCallers = source.readInt() == 1;
        this.allowMessages = source.readInt() == 1;
        this.allowReminders = source.readInt() == 1;
        this.allowEvents = source.readInt() == 1;
        this.allowCallsFrom = source.readInt();
        this.allowMessagesFrom = source.readInt();
        this.user = source.readInt();
        this.manualRule = (ZenRule)source.readParcelable(null);
        int len = source.readInt();
        if (len > 0) {
            String[] ids = new String[len];
            ZenRule[] rules = new ZenRule[len];
            source.readStringArray(ids);
            source.readTypedArray(rules, ZenRule.CREATOR);
            for (int i = 0; i < len; ++i) {
                this.automaticRules.put(ids[i], rules[i]);
            }
        }
        this.allowWhenScreenOff = source.readInt() == 1;
        this.allowWhenScreenOn = source.readInt() == 1;
    }

    private final void $$robo$$android_service_notification_ZenModeConfig$writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.allowCalls ? 1 : 0);
        dest.writeInt(this.allowRepeatCallers ? 1 : 0);
        dest.writeInt(this.allowMessages ? 1 : 0);
        dest.writeInt(this.allowReminders ? 1 : 0);
        dest.writeInt(this.allowEvents ? 1 : 0);
        dest.writeInt(this.allowCallsFrom);
        dest.writeInt(this.allowMessagesFrom);
        dest.writeInt(this.user);
        dest.writeParcelable(this.manualRule, 0);
        if (!this.automaticRules.isEmpty()) {
            int len = this.automaticRules.size();
            String[] ids = new String[len];
            Parcelable[] rules = new ZenRule[len];
            for (int i = 0; i < len; ++i) {
                ids[i] = this.automaticRules.keyAt(i);
                rules[i] = this.automaticRules.valueAt(i);
            }
            dest.writeInt(len);
            dest.writeStringArray(ids);
            dest.writeTypedArray(rules, 0);
        } else {
            dest.writeInt(0);
        }
        dest.writeInt(this.allowWhenScreenOff ? 1 : 0);
        dest.writeInt(this.allowWhenScreenOn ? 1 : 0);
    }

    private final String $$robo$$android_service_notification_ZenModeConfig$toString() {
        return ZenModeConfig.class.getSimpleName() + '[' + "user=" + this.user + ",allowCalls=" + this.allowCalls + ",allowRepeatCallers=" + this.allowRepeatCallers + ",allowMessages=" + this.allowMessages + ",allowCallsFrom=" + ZenModeConfig.sourceToString(this.allowCallsFrom) + ",allowMessagesFrom=" + ZenModeConfig.sourceToString(this.allowMessagesFrom) + ",allowReminders=" + this.allowReminders + ",allowEvents=" + this.allowEvents + ",allowWhenScreenOff=" + this.allowWhenScreenOff + ",allowWhenScreenOn=" + this.allowWhenScreenOn + ",automaticRules=" + this.automaticRules + ",manualRule=" + this.manualRule + ']';
    }

    private final Diff $$robo$$android_service_notification_ZenModeConfig$diff(ZenModeConfig to) {
        Diff d = new Diff();
        if (to == null) {
            return d.addLine("config", "delete");
        }
        if (this.user != to.user) {
            d.addLine("user", this.user, to.user);
        }
        if (this.allowCalls != to.allowCalls) {
            d.addLine("allowCalls", this.allowCalls, to.allowCalls);
        }
        if (this.allowRepeatCallers != to.allowRepeatCallers) {
            d.addLine("allowRepeatCallers", this.allowRepeatCallers, to.allowRepeatCallers);
        }
        if (this.allowMessages != to.allowMessages) {
            d.addLine("allowMessages", this.allowMessages, to.allowMessages);
        }
        if (this.allowCallsFrom != to.allowCallsFrom) {
            d.addLine("allowCallsFrom", this.allowCallsFrom, to.allowCallsFrom);
        }
        if (this.allowMessagesFrom != to.allowMessagesFrom) {
            d.addLine("allowMessagesFrom", this.allowMessagesFrom, to.allowMessagesFrom);
        }
        if (this.allowReminders != to.allowReminders) {
            d.addLine("allowReminders", this.allowReminders, to.allowReminders);
        }
        if (this.allowEvents != to.allowEvents) {
            d.addLine("allowEvents", this.allowEvents, to.allowEvents);
        }
        if (this.allowWhenScreenOff != to.allowWhenScreenOff) {
            d.addLine("allowWhenScreenOff", this.allowWhenScreenOff, to.allowWhenScreenOff);
        }
        if (this.allowWhenScreenOn != to.allowWhenScreenOn) {
            d.addLine("allowWhenScreenOn", this.allowWhenScreenOn, to.allowWhenScreenOn);
        }
        ArraySet allRules = new ArraySet();
        ZenModeConfig.addKeys(allRules, this.automaticRules);
        ZenModeConfig.addKeys(allRules, to.automaticRules);
        int N = allRules.size();
        for (int i = 0; i < N; ++i) {
            String rule = (String)allRules.valueAt(i);
            ZenRule fromRule = this.automaticRules != null ? this.automaticRules.get(rule) : null;
            ZenRule toRule = to.automaticRules != null ? to.automaticRules.get(rule) : null;
            ZenRule.appendDiff(d, "automaticRule[" + rule + "]", fromRule, toRule);
        }
        ZenRule.appendDiff(d, "manualRule", this.manualRule, to.manualRule);
        return d;
    }

    private static final Diff $$robo$$android_service_notification_ZenModeConfig$diff(ZenModeConfig from, ZenModeConfig to) {
        if (from == null) {
            Diff d = new Diff();
            if (to != null) {
                d.addLine("config", "insert");
            }
            return d;
        }
        return from.diff(to);
    }

    private static final <T> void $$robo$$android_service_notification_ZenModeConfig$addKeys(ArraySet<T> set, ArrayMap<T, ?> map) {
        if (map != null) {
            for (int i = 0; i < map.size(); ++i) {
                set.add(map.keyAt(i));
            }
        }
    }

    private final boolean $$robo$$android_service_notification_ZenModeConfig$isValid() {
        if (!ZenModeConfig.isValidManualRule(this.manualRule)) {
            return false;
        }
        int N = this.automaticRules.size();
        for (int i = 0; i < N; ++i) {
            if (ZenModeConfig.isValidAutomaticRule(this.automaticRules.valueAt(i))) continue;
            return false;
        }
        return true;
    }

    private static final boolean $$robo$$android_service_notification_ZenModeConfig$isValidManualRule(ZenRule rule) {
        return rule == null || Settings.Global.isValidZenMode(rule.zenMode) && ZenModeConfig.sameCondition(rule);
    }

    private static final boolean $$robo$$android_service_notification_ZenModeConfig$isValidAutomaticRule(ZenRule rule) {
        return rule != null && !TextUtils.isEmpty(rule.name) && Settings.Global.isValidZenMode(rule.zenMode) && rule.conditionId != null && ZenModeConfig.sameCondition(rule);
    }

    private static final boolean $$robo$$android_service_notification_ZenModeConfig$sameCondition(ZenRule rule) {
        if (rule == null) {
            return false;
        }
        if (rule.conditionId == null) {
            return rule.condition == null;
        }
        return rule.condition == null || rule.conditionId.equals(rule.condition.id);
    }

    private static final int[] $$robo$$android_service_notification_ZenModeConfig$generateMinuteBuckets() {
        int maxHrs = 12;
        int[] buckets = new int[15];
        buckets[0] = 15;
        buckets[1] = 30;
        buckets[2] = 45;
        for (int i = 1; i <= 12; ++i) {
            buckets[2 + i] = 60 * i;
        }
        return buckets;
    }

    private static final String $$robo$$android_service_notification_ZenModeConfig$sourceToString(int source) {
        switch (source) {
            case 0: {
                return "anyone";
            }
            case 1: {
                return "contacts";
            }
            case 2: {
                return "stars";
            }
        }
        return "UNKNOWN";
    }

    private final boolean $$robo$$android_service_notification_ZenModeConfig$equals(Object o) {
        if (!(o instanceof ZenModeConfig)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        ZenModeConfig other = (ZenModeConfig)o;
        return other.allowCalls == this.allowCalls && other.allowRepeatCallers == this.allowRepeatCallers && other.allowMessages == this.allowMessages && other.allowCallsFrom == this.allowCallsFrom && other.allowMessagesFrom == this.allowMessagesFrom && other.allowReminders == this.allowReminders && other.allowEvents == this.allowEvents && other.allowWhenScreenOff == this.allowWhenScreenOff && other.allowWhenScreenOn == this.allowWhenScreenOn && other.user == this.user && Objects.equals(other.automaticRules, this.automaticRules) && Objects.equals(other.manualRule, this.manualRule);
    }

    private final int $$robo$$android_service_notification_ZenModeConfig$hashCode() {
        return Objects.hash(this.allowCalls, this.allowRepeatCallers, this.allowMessages, this.allowCallsFrom, this.allowMessagesFrom, this.allowReminders, this.allowEvents, this.allowWhenScreenOff, this.allowWhenScreenOn, this.user, this.automaticRules, this.manualRule);
    }

    private static final String $$robo$$android_service_notification_ZenModeConfig$toDayList(int[] days) {
        if (days == null || days.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < days.length; ++i) {
            if (i > 0) {
                sb.append('.');
            }
            sb.append(days[i]);
        }
        return sb.toString();
    }

    private static final int[] $$robo$$android_service_notification_ZenModeConfig$tryParseDayList(String dayList, String sep) {
        if (dayList == null) {
            return null;
        }
        String[] tokens = dayList.split(sep);
        if (tokens.length == 0) {
            return null;
        }
        int[] rt = new int[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            int day = ZenModeConfig.tryParseInt(tokens[i], -1);
            if (day == -1) {
                return null;
            }
            rt[i] = day;
        }
        return rt;
    }

    private static final int $$robo$$android_service_notification_ZenModeConfig$tryParseInt(String value, int defValue) {
        if (TextUtils.isEmpty(value)) {
            return defValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defValue;
        }
    }

    private static final long $$robo$$android_service_notification_ZenModeConfig$tryParseLong(String value, long defValue) {
        if (TextUtils.isEmpty(value)) {
            return defValue;
        }
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            return defValue;
        }
    }

    private static final ZenModeConfig $$robo$$android_service_notification_ZenModeConfig$readXml(XmlPullParser parser, Migration migration) throws XmlPullParserException, IOException {
        int type = parser.getEventType();
        if (type != 2) {
            return null;
        }
        String tag = parser.getName();
        if (!"zen".equals(tag)) {
            return null;
        }
        ZenModeConfig rt = new ZenModeConfig();
        int version = ZenModeConfig.safeInt(parser, "version", 2);
        if (version == 1) {
            XmlV1 v1 = XmlV1.readXml(parser);
            return migration.migrate(v1);
        }
        rt.user = ZenModeConfig.safeInt(parser, "user", rt.user);
        while ((type = parser.next()) != 1) {
            tag = parser.getName();
            if (type == 3 && "zen".equals(tag)) {
                return rt;
            }
            if (type != 2) continue;
            if ("allow".equals(tag)) {
                rt.allowCalls = ZenModeConfig.safeBoolean(parser, "calls", false);
                rt.allowRepeatCallers = ZenModeConfig.safeBoolean(parser, "repeatCallers", false);
                rt.allowMessages = ZenModeConfig.safeBoolean(parser, "messages", false);
                rt.allowReminders = ZenModeConfig.safeBoolean(parser, "reminders", true);
                rt.allowEvents = ZenModeConfig.safeBoolean(parser, "events", true);
                int from = ZenModeConfig.safeInt(parser, "from", -1);
                int callsFrom = ZenModeConfig.safeInt(parser, "callsFrom", -1);
                int messagesFrom = ZenModeConfig.safeInt(parser, "messagesFrom", -1);
                if (ZenModeConfig.isValidSource(callsFrom) && ZenModeConfig.isValidSource(messagesFrom)) {
                    rt.allowCallsFrom = callsFrom;
                    rt.allowMessagesFrom = messagesFrom;
                } else if (ZenModeConfig.isValidSource(from)) {
                    Slog.i(TAG, "Migrating existing shared 'from': " + ZenModeConfig.sourceToString(from));
                    rt.allowCallsFrom = from;
                    rt.allowMessagesFrom = from;
                } else {
                    rt.allowCallsFrom = 1;
                    rt.allowMessagesFrom = 1;
                }
                rt.allowWhenScreenOff = ZenModeConfig.safeBoolean(parser, "visualScreenOff", true);
                rt.allowWhenScreenOn = ZenModeConfig.safeBoolean(parser, "visualScreenOn", true);
                continue;
            }
            if ("manual".equals(tag)) {
                rt.manualRule = ZenModeConfig.readRuleXml(parser);
                continue;
            }
            if (!"automatic".equals(tag)) continue;
            String id2 = parser.getAttributeValue(null, "ruleId");
            ZenRule automaticRule = ZenModeConfig.readRuleXml(parser);
            if (id2 == null || automaticRule == null) continue;
            automaticRule.id = id2;
            rt.automaticRules.put(id2, automaticRule);
        }
        throw new IllegalStateException("Failed to reach END_DOCUMENT");
    }

    private final void $$robo$$android_service_notification_ZenModeConfig$writeXml(XmlSerializer out) throws IOException {
        out.startTag(null, "zen");
        out.attribute(null, "version", Integer.toString(2));
        out.attribute(null, "user", Integer.toString(this.user));
        out.startTag(null, "allow");
        out.attribute(null, "calls", Boolean.toString(this.allowCalls));
        out.attribute(null, "repeatCallers", Boolean.toString(this.allowRepeatCallers));
        out.attribute(null, "messages", Boolean.toString(this.allowMessages));
        out.attribute(null, "reminders", Boolean.toString(this.allowReminders));
        out.attribute(null, "events", Boolean.toString(this.allowEvents));
        out.attribute(null, "callsFrom", Integer.toString(this.allowCallsFrom));
        out.attribute(null, "messagesFrom", Integer.toString(this.allowMessagesFrom));
        out.attribute(null, "visualScreenOff", Boolean.toString(this.allowWhenScreenOff));
        out.attribute(null, "visualScreenOn", Boolean.toString(this.allowWhenScreenOn));
        out.endTag(null, "allow");
        if (this.manualRule != null) {
            out.startTag(null, "manual");
            ZenModeConfig.writeRuleXml(this.manualRule, out);
            out.endTag(null, "manual");
        }
        int N = this.automaticRules.size();
        for (int i = 0; i < N; ++i) {
            String id2 = this.automaticRules.keyAt(i);
            ZenRule automaticRule = this.automaticRules.valueAt(i);
            out.startTag(null, "automatic");
            out.attribute(null, "ruleId", id2);
            ZenModeConfig.writeRuleXml(automaticRule, out);
            out.endTag(null, "automatic");
        }
        out.endTag(null, "zen");
    }

    private static final ZenRule $$robo$$android_service_notification_ZenModeConfig$readRuleXml(XmlPullParser parser) {
        ZenRule rt = new ZenRule();
        rt.enabled = ZenModeConfig.safeBoolean(parser, "enabled", true);
        rt.snoozing = ZenModeConfig.safeBoolean(parser, "snoozing", false);
        rt.name = parser.getAttributeValue(null, "name");
        String zen = parser.getAttributeValue(null, "zen");
        rt.zenMode = ZenModeConfig.tryParseZenMode(zen, -1);
        if (rt.zenMode == -1) {
            Slog.w(TAG, "Bad zen mode in rule xml:" + zen);
            return null;
        }
        rt.conditionId = ZenModeConfig.safeUri(parser, "conditionId");
        rt.component = ZenModeConfig.safeComponentName(parser, "component");
        rt.creationTime = ZenModeConfig.safeLong(parser, "creationTime", 0L);
        rt.condition = ZenModeConfig.readConditionXml(parser);
        return rt;
    }

    private static final void $$robo$$android_service_notification_ZenModeConfig$writeRuleXml(ZenRule rule, XmlSerializer out) throws IOException {
        out.attribute(null, "enabled", Boolean.toString(rule.enabled));
        out.attribute(null, "snoozing", Boolean.toString(rule.snoozing));
        if (rule.name != null) {
            out.attribute(null, "name", rule.name);
        }
        out.attribute(null, "zen", Integer.toString(rule.zenMode));
        if (rule.component != null) {
            out.attribute(null, "component", rule.component.flattenToString());
        }
        if (rule.conditionId != null) {
            out.attribute(null, "conditionId", rule.conditionId.toString());
        }
        out.attribute(null, "creationTime", Long.toString(rule.creationTime));
        if (rule.condition != null) {
            ZenModeConfig.writeConditionXml(rule.condition, out);
        }
    }

    private static final Condition $$robo$$android_service_notification_ZenModeConfig$readConditionXml(XmlPullParser parser) {
        Uri id2 = ZenModeConfig.safeUri(parser, "id");
        if (id2 == null) {
            return null;
        }
        String summary = parser.getAttributeValue(null, "summary");
        String line1 = parser.getAttributeValue(null, "line1");
        String line2 = parser.getAttributeValue(null, "line2");
        int icon = ZenModeConfig.safeInt(parser, "icon", -1);
        int state = ZenModeConfig.safeInt(parser, "state", -1);
        int flags = ZenModeConfig.safeInt(parser, "flags", -1);
        try {
            return new Condition(id2, summary, line1, line2, icon, state, flags);
        }
        catch (IllegalArgumentException e) {
            Slog.w(TAG, "Unable to read condition xml", e);
            return null;
        }
    }

    private static final void $$robo$$android_service_notification_ZenModeConfig$writeConditionXml(Condition c, XmlSerializer out) throws IOException {
        out.attribute(null, "id", c.id.toString());
        out.attribute(null, "summary", c.summary);
        out.attribute(null, "line1", c.line1);
        out.attribute(null, "line2", c.line2);
        out.attribute(null, "icon", Integer.toString(c.icon));
        out.attribute(null, "state", Integer.toString(c.state));
        out.attribute(null, "flags", Integer.toString(c.flags));
    }

    private static final boolean $$robo$$android_service_notification_ZenModeConfig$isValidHour(int val) {
        return val >= 0 && val < 24;
    }

    private static final boolean $$robo$$android_service_notification_ZenModeConfig$isValidMinute(int val) {
        return val >= 0 && val < 60;
    }

    private static final boolean $$robo$$android_service_notification_ZenModeConfig$isValidSource(int source) {
        return source >= 0 && source <= 2;
    }

    private static final boolean $$robo$$android_service_notification_ZenModeConfig$safeBoolean(XmlPullParser parser, String att, boolean defValue) {
        String val = parser.getAttributeValue(null, att);
        return ZenModeConfig.safeBoolean(val, defValue);
    }

    private static final boolean $$robo$$android_service_notification_ZenModeConfig$safeBoolean(String val, boolean defValue) {
        if (TextUtils.isEmpty(val)) {
            return defValue;
        }
        return Boolean.valueOf(val);
    }

    private static final int $$robo$$android_service_notification_ZenModeConfig$safeInt(XmlPullParser parser, String att, int defValue) {
        String val = parser.getAttributeValue(null, att);
        return ZenModeConfig.tryParseInt(val, defValue);
    }

    private static final ComponentName $$robo$$android_service_notification_ZenModeConfig$safeComponentName(XmlPullParser parser, String att) {
        String val = parser.getAttributeValue(null, att);
        if (TextUtils.isEmpty(val)) {
            return null;
        }
        return ComponentName.unflattenFromString(val);
    }

    private static final Uri $$robo$$android_service_notification_ZenModeConfig$safeUri(XmlPullParser parser, String att) {
        String val = parser.getAttributeValue(null, att);
        if (TextUtils.isEmpty(val)) {
            return null;
        }
        return Uri.parse(val);
    }

    private static final long $$robo$$android_service_notification_ZenModeConfig$safeLong(XmlPullParser parser, String att, long defValue) {
        String val = parser.getAttributeValue(null, att);
        return ZenModeConfig.tryParseLong(val, defValue);
    }

    private final int $$robo$$android_service_notification_ZenModeConfig$describeContents() {
        return 0;
    }

    private final ZenModeConfig $$robo$$android_service_notification_ZenModeConfig$copy() {
        Parcel parcel = Parcel.obtain();
        try {
            this.writeToParcel(parcel, 0);
            parcel.setDataPosition(0);
            ZenModeConfig zenModeConfig = new ZenModeConfig(parcel);
            return zenModeConfig;
        }
        finally {
            parcel.recycle();
        }
    }

    private final NotificationManager.Policy $$robo$$android_service_notification_ZenModeConfig$toNotificationPolicy() {
        int priorityCategories = 0;
        int priorityCallSenders = 1;
        int priorityMessageSenders = 1;
        if (this.allowCalls) {
            priorityCategories |= 8;
        }
        if (this.allowMessages) {
            priorityCategories |= 4;
        }
        if (this.allowEvents) {
            priorityCategories |= 2;
        }
        if (this.allowReminders) {
            priorityCategories |= 1;
        }
        if (this.allowRepeatCallers) {
            priorityCategories |= 0x10;
        }
        int suppressedVisualEffects = 0;
        if (!this.allowWhenScreenOff) {
            suppressedVisualEffects |= 1;
        }
        if (!this.allowWhenScreenOn) {
            suppressedVisualEffects |= 2;
        }
        priorityCallSenders = ZenModeConfig.sourceToPrioritySenders(this.allowCallsFrom, priorityCallSenders);
        priorityMessageSenders = ZenModeConfig.sourceToPrioritySenders(this.allowMessagesFrom, priorityMessageSenders);
        return new NotificationManager.Policy(priorityCategories, priorityCallSenders, priorityMessageSenders, suppressedVisualEffects);
    }

    private static final int $$robo$$android_service_notification_ZenModeConfig$sourceToPrioritySenders(int source, int def) {
        switch (source) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return def;
    }

    private static final int $$robo$$android_service_notification_ZenModeConfig$prioritySendersToSource(int prioritySenders, int def) {
        switch (prioritySenders) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 0: {
                return 0;
            }
        }
        return def;
    }

    private final void $$robo$$android_service_notification_ZenModeConfig$applyNotificationPolicy(NotificationManager.Policy policy) {
        if (policy == null) {
            return;
        }
        this.allowCalls = (policy.priorityCategories & 8) != 0;
        this.allowMessages = (policy.priorityCategories & 4) != 0;
        this.allowEvents = (policy.priorityCategories & 2) != 0;
        this.allowReminders = (policy.priorityCategories & 1) != 0;
        this.allowRepeatCallers = (policy.priorityCategories & 0x10) != 0;
        this.allowCallsFrom = ZenModeConfig.prioritySendersToSource(policy.priorityCallSenders, this.allowCallsFrom);
        this.allowMessagesFrom = ZenModeConfig.prioritySendersToSource(policy.priorityMessageSenders, this.allowMessagesFrom);
        if (policy.suppressedVisualEffects != -1) {
            this.allowWhenScreenOff = (policy.suppressedVisualEffects & 1) == 0;
            this.allowWhenScreenOn = (policy.suppressedVisualEffects & 2) == 0;
        }
    }

    private static final Condition $$robo$$android_service_notification_ZenModeConfig$toTimeCondition(Context context, int minutesFromNow, int userHandle) {
        return ZenModeConfig.toTimeCondition(context, minutesFromNow, userHandle, false);
    }

    private static final Condition $$robo$$android_service_notification_ZenModeConfig$toTimeCondition(Context context, int minutesFromNow, int userHandle, boolean shortVersion) {
        CallSite now = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        long millis = minutesFromNow == 0 ? 10000L : (long)(minutesFromNow * 60000);
        return ZenModeConfig.toTimeCondition(context, (long)(now + millis), minutesFromNow, userHandle, shortVersion);
    }

    private static final Condition $$robo$$android_service_notification_ZenModeConfig$toTimeCondition(Context context, long time, int minutes, int userHandle, boolean shortVersion) {
        String line2;
        String line1;
        String summary;
        int summaryResId;
        CharSequence formattedTime = ZenModeConfig.getFormattedTime(context, time, userHandle);
        Resources res = context.getResources();
        if (minutes < 60) {
            int num = minutes;
            summaryResId = shortVersion ? 18087964 : 18087963;
            summary = res.getQuantityString(summaryResId, num, num, formattedTime);
            int line1ResId = shortVersion ? 18087968 : 18087967;
            line1 = res.getQuantityString(line1ResId, num, num, formattedTime);
            line2 = res.getString(17040815, formattedTime);
        } else if (minutes < 1440) {
            int num = Math.round((float)minutes / 60.0f);
            summaryResId = shortVersion ? 18087966 : 18087965;
            summary = res.getQuantityString(summaryResId, num, num, formattedTime);
            int line1ResId = shortVersion ? 18087970 : 18087969;
            line1 = res.getQuantityString(line1ResId, num, num, formattedTime);
            line2 = res.getString(17040815, formattedTime);
        } else {
            line1 = line2 = res.getString(17040815, formattedTime);
            summary = line2;
        }
        Uri id2 = ZenModeConfig.toCountdownConditionId(time);
        return new Condition(id2, summary, line1, line2, 0, 1, 1);
    }

    private static final Condition $$robo$$android_service_notification_ZenModeConfig$toNextAlarmCondition(Context context, long now, long alarm, int userHandle) {
        CharSequence formattedTime = ZenModeConfig.getFormattedTime(context, alarm, userHandle);
        Resources res = context.getResources();
        String line1 = res.getString(17040816, formattedTime);
        Uri id2 = ZenModeConfig.toCountdownConditionId(alarm);
        return new Condition(id2, "", line1, "", 0, 1, 1);
    }

    private static final CharSequence $$robo$$android_service_notification_ZenModeConfig$getFormattedTime(Context context, long time, int userHandle) {
        String skeleton = "EEE " + (DateFormat.is24HourFormat(context, userHandle) ? "Hm" : "hma");
        GregorianCalendar now = new GregorianCalendar();
        GregorianCalendar endTime = new GregorianCalendar();
        endTime.setTimeInMillis(time);
        if (now.get(1) == endTime.get(1) && now.get(2) == endTime.get(2) && now.get(5) == endTime.get(5)) {
            skeleton = DateFormat.is24HourFormat(context, userHandle) ? "Hm" : "hma";
        }
        String pattern = DateFormat.getBestDateTimePattern(Locale.getDefault(), skeleton);
        return DateFormat.format((CharSequence)pattern, time);
    }

    private static final Uri $$robo$$android_service_notification_ZenModeConfig$toCountdownConditionId(long time) {
        return new Uri.Builder().scheme("condition").authority("android").appendPath("countdown").appendPath(Long.toString(time)).build();
    }

    private static final long $$robo$$android_service_notification_ZenModeConfig$tryParseCountdownConditionId(Uri conditionId) {
        if (!Condition.isValidId(conditionId, "android")) {
            return 0L;
        }
        if (conditionId.getPathSegments().size() != 2 || !"countdown".equals(conditionId.getPathSegments().get(0))) {
            return 0L;
        }
        try {
            return Long.parseLong(conditionId.getPathSegments().get(1));
        }
        catch (RuntimeException e) {
            Slog.w(TAG, "Error parsing countdown condition: " + conditionId, e);
            return 0L;
        }
    }

    private static final boolean $$robo$$android_service_notification_ZenModeConfig$isValidCountdownConditionId(Uri conditionId) {
        return ZenModeConfig.tryParseCountdownConditionId(conditionId) != 0L;
    }

    private static final Uri $$robo$$android_service_notification_ZenModeConfig$toScheduleConditionId(ScheduleInfo schedule) {
        return new Uri.Builder().scheme("condition").authority("android").appendPath("schedule").appendQueryParameter("days", ZenModeConfig.toDayList(schedule.days)).appendQueryParameter("start", schedule.startHour + "." + schedule.startMinute).appendQueryParameter("end", schedule.endHour + "." + schedule.endMinute).appendQueryParameter("exitAtAlarm", String.valueOf(schedule.exitAtAlarm)).build();
    }

    private static final boolean $$robo$$android_service_notification_ZenModeConfig$isValidScheduleConditionId(Uri conditionId) {
        return ZenModeConfig.tryParseScheduleConditionId(conditionId) != null;
    }

    private static final ScheduleInfo $$robo$$android_service_notification_ZenModeConfig$tryParseScheduleConditionId(Uri conditionId) {
        boolean isSchedule;
        boolean bl = isSchedule = conditionId != null && conditionId.getScheme().equals("condition") && conditionId.getAuthority().equals("android") && conditionId.getPathSegments().size() == 1 && conditionId.getPathSegments().get(0).equals("schedule");
        if (!isSchedule) {
            return null;
        }
        int[] start = ZenModeConfig.tryParseHourAndMinute(conditionId.getQueryParameter("start"));
        int[] end = ZenModeConfig.tryParseHourAndMinute(conditionId.getQueryParameter("end"));
        if (start == null || end == null) {
            return null;
        }
        ScheduleInfo rt = new ScheduleInfo();
        rt.days = ZenModeConfig.tryParseDayList(conditionId.getQueryParameter("days"), "\\.");
        rt.startHour = start[0];
        rt.startMinute = start[1];
        rt.endHour = end[0];
        rt.endMinute = end[1];
        rt.exitAtAlarm = ZenModeConfig.safeBoolean(conditionId.getQueryParameter("exitAtAlarm"), false);
        return rt;
    }

    private static final ComponentName $$robo$$android_service_notification_ZenModeConfig$getScheduleConditionProvider() {
        return new ComponentName("android", "ScheduleConditionProvider");
    }

    private static final Uri $$robo$$android_service_notification_ZenModeConfig$toEventConditionId(EventInfo event) {
        return new Uri.Builder().scheme("condition").authority("android").appendPath("event").appendQueryParameter("userId", Long.toString(event.userId)).appendQueryParameter("calendar", event.calendar != null ? event.calendar : "").appendQueryParameter("reply", Integer.toString(event.reply)).build();
    }

    private static final boolean $$robo$$android_service_notification_ZenModeConfig$isValidEventConditionId(Uri conditionId) {
        return ZenModeConfig.tryParseEventConditionId(conditionId) != null;
    }

    private static final EventInfo $$robo$$android_service_notification_ZenModeConfig$tryParseEventConditionId(Uri conditionId) {
        boolean isEvent;
        boolean bl = isEvent = conditionId != null && conditionId.getScheme().equals("condition") && conditionId.getAuthority().equals("android") && conditionId.getPathSegments().size() == 1 && conditionId.getPathSegments().get(0).equals("event");
        if (!isEvent) {
            return null;
        }
        EventInfo rt = new EventInfo();
        rt.userId = ZenModeConfig.tryParseInt(conditionId.getQueryParameter("userId"), -10000);
        rt.calendar = conditionId.getQueryParameter("calendar");
        if (TextUtils.isEmpty(rt.calendar) || ZenModeConfig.tryParseLong(rt.calendar, -1L) != -1L) {
            rt.calendar = null;
        }
        rt.reply = ZenModeConfig.tryParseInt(conditionId.getQueryParameter("reply"), 0);
        return rt;
    }

    private static final ComponentName $$robo$$android_service_notification_ZenModeConfig$getEventConditionProvider() {
        return new ComponentName("android", "EventConditionProvider");
    }

    private static final int[] $$robo$$android_service_notification_ZenModeConfig$tryParseHourAndMinute(String value) {
        int[] nArray;
        if (TextUtils.isEmpty(value)) {
            return null;
        }
        int i = value.indexOf(46);
        if (i < 1 || i >= value.length() - 1) {
            return null;
        }
        int hour = ZenModeConfig.tryParseInt(value.substring(0, i), -1);
        int minute = ZenModeConfig.tryParseInt(value.substring(i + 1), -1);
        if (ZenModeConfig.isValidHour(hour) && ZenModeConfig.isValidMinute(minute)) {
            int[] nArray2 = new int[2];
            nArray2[0] = hour;
            nArray = nArray2;
            nArray2[1] = minute;
        } else {
            nArray = null;
        }
        return nArray;
    }

    private static final int $$robo$$android_service_notification_ZenModeConfig$tryParseZenMode(String value, int defValue) {
        int rt = ZenModeConfig.tryParseInt(value, defValue);
        return Settings.Global.isValidZenMode(rt) ? rt : defValue;
    }

    private static final String $$robo$$android_service_notification_ZenModeConfig$newRuleId() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    private static final String $$robo$$android_service_notification_ZenModeConfig$getConditionSummary(Context context, ZenModeConfig config, int userHandle, boolean shortVersion) {
        return ZenModeConfig.getConditionLine(context, config, userHandle, false, shortVersion);
    }

    private static final String $$robo$$android_service_notification_ZenModeConfig$getConditionLine(Context context, ZenModeConfig config, int userHandle, boolean useLine1, boolean shortVersion) {
        if (config == null) {
            return "";
        }
        if (config.manualRule != null) {
            Uri id2 = config.manualRule.conditionId;
            if (id2 == null) {
                return context.getString(17040817);
            }
            long time = ZenModeConfig.tryParseCountdownConditionId(id2);
            Condition c = config.manualRule.condition;
            if (time > 0L) {
                CallSite now = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
                long span = time - now;
                c = ZenModeConfig.toTimeCondition(context, time, Math.round((float)span / 60000.0f), userHandle, shortVersion);
            }
            String rt = c == null ? "" : (useLine1 ? c.line1 : c.summary);
            return TextUtils.isEmpty(rt) ? "" : rt;
        }
        String summary = "";
        for (ZenRule automaticRule : config.automaticRules.values()) {
            if (!automaticRule.isAutomaticActive()) continue;
            if (summary.isEmpty()) {
                summary = automaticRule.name;
                continue;
            }
            summary = context.getResources().getString(17040819, summary, automaticRule.name);
        }
        return summary;
    }

    static void __staticInitializer__() {
        TAG = "ZenModeConfig";
        ALL_DAYS = new int[]{1, 2, 3, 4, 5, 6, 7};
        WEEKNIGHT_DAYS = new int[]{1, 2, 3, 4, 5};
        WEEKEND_DAYS = new int[]{6, 7};
        MINUTE_BUCKETS = ZenModeConfig.generateMinuteBuckets();
        CREATOR = new Parcelable.Creator<ZenModeConfig>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_service_notification_ZenModeConfig_1$__constructor__() {
            }

            private final ZenModeConfig $$robo$$android_service_notification_ZenModeConfig_1$createFromParcel(Parcel source) {
                return new ZenModeConfig(source);
            }

            private final ZenModeConfig[] $$robo$$android_service_notification_ZenModeConfig_1$newArray(int size) {
                return new ZenModeConfig[size];
            }

            private void __constructor__() {
                this.$$robo$$android_service_notification_ZenModeConfig_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_notification_ZenModeConfig_1$__constructor__(), 0, this);
            }

            @Override
            public ZenModeConfig createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_service_notification_ZenModeConfig_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public ZenModeConfig[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_service_notification_ZenModeConfig_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_service_notification_ZenModeConfig$__constructor__();
    }

    public ZenModeConfig() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_notification_ZenModeConfig$__constructor__(), 0, this);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_service_notification_ZenModeConfig$__constructor__(parcel);
    }

    public ZenModeConfig(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_notification_ZenModeConfig$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_service_notification_ZenModeConfig$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_service_notification_ZenModeConfig$toString(), 0, this);
    }

    private Diff diff(ZenModeConfig zenModeConfig) {
        return InvokeDynamicSupport.bootstrap("diff", $$robo$$android_service_notification_ZenModeConfig$diff(android.service.notification.ZenModeConfig ), 0, this, zenModeConfig);
    }

    public static Diff diff(ZenModeConfig zenModeConfig, ZenModeConfig zenModeConfig2) {
        return InvokeDynamicSupport.bootstrapStatic("diff", $$robo$$android_service_notification_ZenModeConfig$diff(android.service.notification.ZenModeConfig android.service.notification.ZenModeConfig ), 0, (ZenModeConfig)zenModeConfig, (ZenModeConfig)zenModeConfig2);
    }

    private static <T> void addKeys(ArraySet<T> arraySet, ArrayMap<T, ?> arrayMap) {
        InvokeDynamicSupport.bootstrapStatic("addKeys", $$robo$$android_service_notification_ZenModeConfig$addKeys(android.util.ArraySet<T> android.util.ArrayMap<T, ?> ), 0, arraySet, arrayMap);
    }

    public boolean isValid() {
        return (boolean)InvokeDynamicSupport.bootstrap("isValid", $$robo$$android_service_notification_ZenModeConfig$isValid(), 0, this);
    }

    private static boolean isValidManualRule(ZenRule zenRule) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidManualRule", $$robo$$android_service_notification_ZenModeConfig$isValidManualRule(android.service.notification.ZenModeConfig$ZenRule ), 0, (ZenRule)zenRule);
    }

    private static boolean isValidAutomaticRule(ZenRule zenRule) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidAutomaticRule", $$robo$$android_service_notification_ZenModeConfig$isValidAutomaticRule(android.service.notification.ZenModeConfig$ZenRule ), 0, (ZenRule)zenRule);
    }

    private static boolean sameCondition(ZenRule zenRule) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("sameCondition", $$robo$$android_service_notification_ZenModeConfig$sameCondition(android.service.notification.ZenModeConfig$ZenRule ), 0, (ZenRule)zenRule);
    }

    private static int[] generateMinuteBuckets() {
        return InvokeDynamicSupport.bootstrapStatic("generateMinuteBuckets", $$robo$$android_service_notification_ZenModeConfig$generateMinuteBuckets(), 0);
    }

    public static String sourceToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("sourceToString", $$robo$$android_service_notification_ZenModeConfig$sourceToString(int ), 0, (int)n);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_service_notification_ZenModeConfig$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_service_notification_ZenModeConfig$hashCode(), 0, this);
    }

    private static String toDayList(int[] nArray) {
        return InvokeDynamicSupport.bootstrapStatic("toDayList", $$robo$$android_service_notification_ZenModeConfig$toDayList(int[] ), 0, (int[])nArray);
    }

    private static int[] tryParseDayList(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("tryParseDayList", $$robo$$android_service_notification_ZenModeConfig$tryParseDayList(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    private static int tryParseInt(String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("tryParseInt", $$robo$$android_service_notification_ZenModeConfig$tryParseInt(java.lang.String int ), 0, (String)string2, (int)n);
    }

    private static long tryParseLong(String string2, long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("tryParseLong", $$robo$$android_service_notification_ZenModeConfig$tryParseLong(java.lang.String long ), 0, (String)string2, (long)l);
    }

    public static ZenModeConfig readXml(XmlPullParser xmlPullParser, Migration migration) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("readXml", $$robo$$android_service_notification_ZenModeConfig$readXml(org.xmlpull.v1.XmlPullParser android.service.notification.ZenModeConfig$Migration ), 0, (XmlPullParser)xmlPullParser, (Migration)migration);
    }

    public void writeXml(XmlSerializer xmlSerializer) throws IOException {
        InvokeDynamicSupport.bootstrap("writeXml", $$robo$$android_service_notification_ZenModeConfig$writeXml(org.xmlpull.v1.XmlSerializer ), 0, this, xmlSerializer);
    }

    public static ZenRule readRuleXml(XmlPullParser xmlPullParser) {
        return InvokeDynamicSupport.bootstrapStatic("readRuleXml", $$robo$$android_service_notification_ZenModeConfig$readRuleXml(org.xmlpull.v1.XmlPullParser ), 0, (XmlPullParser)xmlPullParser);
    }

    public static void writeRuleXml(ZenRule zenRule, XmlSerializer xmlSerializer) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("writeRuleXml", $$robo$$android_service_notification_ZenModeConfig$writeRuleXml(android.service.notification.ZenModeConfig$ZenRule org.xmlpull.v1.XmlSerializer ), 0, (ZenRule)zenRule, (XmlSerializer)xmlSerializer);
    }

    public static Condition readConditionXml(XmlPullParser xmlPullParser) {
        return InvokeDynamicSupport.bootstrapStatic("readConditionXml", $$robo$$android_service_notification_ZenModeConfig$readConditionXml(org.xmlpull.v1.XmlPullParser ), 0, (XmlPullParser)xmlPullParser);
    }

    public static void writeConditionXml(Condition condition, XmlSerializer xmlSerializer) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("writeConditionXml", $$robo$$android_service_notification_ZenModeConfig$writeConditionXml(android.service.notification.Condition org.xmlpull.v1.XmlSerializer ), 0, (Condition)condition, (XmlSerializer)xmlSerializer);
    }

    public static boolean isValidHour(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidHour", $$robo$$android_service_notification_ZenModeConfig$isValidHour(int ), 0, (int)n);
    }

    public static boolean isValidMinute(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidMinute", $$robo$$android_service_notification_ZenModeConfig$isValidMinute(int ), 0, (int)n);
    }

    private static boolean isValidSource(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidSource", $$robo$$android_service_notification_ZenModeConfig$isValidSource(int ), 0, (int)n);
    }

    private static boolean safeBoolean(XmlPullParser xmlPullParser, String string2, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("safeBoolean", $$robo$$android_service_notification_ZenModeConfig$safeBoolean(org.xmlpull.v1.XmlPullParser java.lang.String boolean ), 0, (XmlPullParser)xmlPullParser, (String)string2, (boolean)bl);
    }

    private static boolean safeBoolean(String string2, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("safeBoolean", $$robo$$android_service_notification_ZenModeConfig$safeBoolean(java.lang.String boolean ), 0, (String)string2, (boolean)bl);
    }

    private static int safeInt(XmlPullParser xmlPullParser, String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("safeInt", $$robo$$android_service_notification_ZenModeConfig$safeInt(org.xmlpull.v1.XmlPullParser java.lang.String int ), 0, (XmlPullParser)xmlPullParser, (String)string2, (int)n);
    }

    private static ComponentName safeComponentName(XmlPullParser xmlPullParser, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("safeComponentName", $$robo$$android_service_notification_ZenModeConfig$safeComponentName(org.xmlpull.v1.XmlPullParser java.lang.String ), 0, (XmlPullParser)xmlPullParser, (String)string2);
    }

    private static Uri safeUri(XmlPullParser xmlPullParser, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("safeUri", $$robo$$android_service_notification_ZenModeConfig$safeUri(org.xmlpull.v1.XmlPullParser java.lang.String ), 0, (XmlPullParser)xmlPullParser, (String)string2);
    }

    private static long safeLong(XmlPullParser xmlPullParser, String string2, long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("safeLong", $$robo$$android_service_notification_ZenModeConfig$safeLong(org.xmlpull.v1.XmlPullParser java.lang.String long ), 0, (XmlPullParser)xmlPullParser, (String)string2, (long)l);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_service_notification_ZenModeConfig$describeContents(), 0, this);
    }

    public ZenModeConfig copy() {
        return InvokeDynamicSupport.bootstrap("copy", $$robo$$android_service_notification_ZenModeConfig$copy(), 0, this);
    }

    public NotificationManager.Policy toNotificationPolicy() {
        return InvokeDynamicSupport.bootstrap("toNotificationPolicy", $$robo$$android_service_notification_ZenModeConfig$toNotificationPolicy(), 0, this);
    }

    private static int sourceToPrioritySenders(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("sourceToPrioritySenders", $$robo$$android_service_notification_ZenModeConfig$sourceToPrioritySenders(int int ), 0, (int)n, (int)n2);
    }

    private static int prioritySendersToSource(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("prioritySendersToSource", $$robo$$android_service_notification_ZenModeConfig$prioritySendersToSource(int int ), 0, (int)n, (int)n2);
    }

    public void applyNotificationPolicy(NotificationManager.Policy policy) {
        InvokeDynamicSupport.bootstrap("applyNotificationPolicy", $$robo$$android_service_notification_ZenModeConfig$applyNotificationPolicy(android.app.NotificationManager$Policy ), 0, this, policy);
    }

    public static Condition toTimeCondition(Context context, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("toTimeCondition", $$robo$$android_service_notification_ZenModeConfig$toTimeCondition(android.content.Context int int ), 0, (Context)context, (int)n, (int)n2);
    }

    public static Condition toTimeCondition(Context context, int n, int n2, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("toTimeCondition", $$robo$$android_service_notification_ZenModeConfig$toTimeCondition(android.content.Context int int boolean ), 0, (Context)context, (int)n, (int)n2, (boolean)bl);
    }

    public static Condition toTimeCondition(Context context, long l, int n, int n2, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("toTimeCondition", $$robo$$android_service_notification_ZenModeConfig$toTimeCondition(android.content.Context long int int boolean ), 0, (Context)context, (long)l, (int)n, (int)n2, (boolean)bl);
    }

    public static Condition toNextAlarmCondition(Context context, long l, long l2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("toNextAlarmCondition", $$robo$$android_service_notification_ZenModeConfig$toNextAlarmCondition(android.content.Context long long int ), 0, (Context)context, (long)l, (long)l2, (int)n);
    }

    private static CharSequence getFormattedTime(Context context, long l, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getFormattedTime", $$robo$$android_service_notification_ZenModeConfig$getFormattedTime(android.content.Context long int ), 0, (Context)context, (long)l, (int)n);
    }

    public static Uri toCountdownConditionId(long l) {
        return InvokeDynamicSupport.bootstrapStatic("toCountdownConditionId", $$robo$$android_service_notification_ZenModeConfig$toCountdownConditionId(long ), 0, (long)l);
    }

    public static long tryParseCountdownConditionId(Uri uri) {
        return (long)InvokeDynamicSupport.bootstrapStatic("tryParseCountdownConditionId", $$robo$$android_service_notification_ZenModeConfig$tryParseCountdownConditionId(android.net.Uri ), 0, (Uri)uri);
    }

    public static boolean isValidCountdownConditionId(Uri uri) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidCountdownConditionId", $$robo$$android_service_notification_ZenModeConfig$isValidCountdownConditionId(android.net.Uri ), 0, (Uri)uri);
    }

    public static Uri toScheduleConditionId(ScheduleInfo scheduleInfo) {
        return InvokeDynamicSupport.bootstrapStatic("toScheduleConditionId", $$robo$$android_service_notification_ZenModeConfig$toScheduleConditionId(android.service.notification.ZenModeConfig$ScheduleInfo ), 0, (ScheduleInfo)scheduleInfo);
    }

    public static boolean isValidScheduleConditionId(Uri uri) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidScheduleConditionId", $$robo$$android_service_notification_ZenModeConfig$isValidScheduleConditionId(android.net.Uri ), 0, (Uri)uri);
    }

    public static ScheduleInfo tryParseScheduleConditionId(Uri uri) {
        return InvokeDynamicSupport.bootstrapStatic("tryParseScheduleConditionId", $$robo$$android_service_notification_ZenModeConfig$tryParseScheduleConditionId(android.net.Uri ), 0, (Uri)uri);
    }

    public static ComponentName getScheduleConditionProvider() {
        return InvokeDynamicSupport.bootstrapStatic("getScheduleConditionProvider", $$robo$$android_service_notification_ZenModeConfig$getScheduleConditionProvider(), 0);
    }

    public static Uri toEventConditionId(EventInfo eventInfo) {
        return InvokeDynamicSupport.bootstrapStatic("toEventConditionId", $$robo$$android_service_notification_ZenModeConfig$toEventConditionId(android.service.notification.ZenModeConfig$EventInfo ), 0, (EventInfo)eventInfo);
    }

    public static boolean isValidEventConditionId(Uri uri) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidEventConditionId", $$robo$$android_service_notification_ZenModeConfig$isValidEventConditionId(android.net.Uri ), 0, (Uri)uri);
    }

    public static EventInfo tryParseEventConditionId(Uri uri) {
        return InvokeDynamicSupport.bootstrapStatic("tryParseEventConditionId", $$robo$$android_service_notification_ZenModeConfig$tryParseEventConditionId(android.net.Uri ), 0, (Uri)uri);
    }

    public static ComponentName getEventConditionProvider() {
        return InvokeDynamicSupport.bootstrapStatic("getEventConditionProvider", $$robo$$android_service_notification_ZenModeConfig$getEventConditionProvider(), 0);
    }

    private static int[] tryParseHourAndMinute(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("tryParseHourAndMinute", $$robo$$android_service_notification_ZenModeConfig$tryParseHourAndMinute(java.lang.String ), 0, (String)string2);
    }

    private static int tryParseZenMode(String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("tryParseZenMode", $$robo$$android_service_notification_ZenModeConfig$tryParseZenMode(java.lang.String int ), 0, (String)string2, (int)n);
    }

    public static String newRuleId() {
        return InvokeDynamicSupport.bootstrapStatic("newRuleId", $$robo$$android_service_notification_ZenModeConfig$newRuleId(), 0);
    }

    public static String getConditionSummary(Context context, ZenModeConfig zenModeConfig, int n, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("getConditionSummary", $$robo$$android_service_notification_ZenModeConfig$getConditionSummary(android.content.Context android.service.notification.ZenModeConfig int boolean ), 0, (Context)context, (ZenModeConfig)zenModeConfig, (int)n, (boolean)bl);
    }

    private static String getConditionLine(Context context, ZenModeConfig zenModeConfig, int n, boolean bl, boolean bl2) {
        return InvokeDynamicSupport.bootstrapStatic("getConditionLine", $$robo$$android_service_notification_ZenModeConfig$getConditionLine(android.content.Context android.service.notification.ZenModeConfig int boolean boolean ), 0, (Context)context, (ZenModeConfig)zenModeConfig, (int)n, (boolean)bl, (boolean)bl2);
    }

    static {
        RobolectricInternals.classInitializing(ZenModeConfig.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ZenModeConfig)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Diff
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private ArrayList<String> lines;

        private void $$robo$$android_service_notification_ZenModeConfig_Diff$__constructor__() {
            this.lines = new ArrayList();
        }

        private final String $$robo$$android_service_notification_ZenModeConfig_Diff$toString() {
            StringBuilder sb = new StringBuilder("Diff[");
            int N = this.lines.size();
            for (int i = 0; i < N; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(this.lines.get(i));
            }
            return sb.append(']').toString();
        }

        private final Diff $$robo$$android_service_notification_ZenModeConfig_Diff$addLine(String item, String action) {
            this.lines.add(item + ":" + action);
            return this;
        }

        private final Diff $$robo$$android_service_notification_ZenModeConfig_Diff$addLine(String item, String subitem, Object from, Object to) {
            return this.addLine(item + "." + subitem, from, to);
        }

        private final Diff $$robo$$android_service_notification_ZenModeConfig_Diff$addLine(String item, Object from, Object to) {
            return this.addLine(item, from + "->" + to);
        }

        private void __constructor__() {
            this.$$robo$$android_service_notification_ZenModeConfig_Diff$__constructor__();
        }

        public Diff() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_notification_ZenModeConfig_Diff$__constructor__(), 0, this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_service_notification_ZenModeConfig_Diff$toString(), 0, this);
        }

        private Diff addLine(String string2, String string3) {
            return InvokeDynamicSupport.bootstrap("addLine", $$robo$$android_service_notification_ZenModeConfig_Diff$addLine(java.lang.String java.lang.String ), 0, this, string2, string3);
        }

        public Diff addLine(String string2, String string3, Object object, Object object2) {
            return InvokeDynamicSupport.bootstrap("addLine", $$robo$$android_service_notification_ZenModeConfig_Diff$addLine(java.lang.String java.lang.String java.lang.Object java.lang.Object ), 0, this, string2, string3, object, object2);
        }

        public Diff addLine(String string2, Object object, Object object2) {
            return InvokeDynamicSupport.bootstrap("addLine", $$robo$$android_service_notification_ZenModeConfig_Diff$addLine(java.lang.String java.lang.Object java.lang.Object ), 0, this, string2, object, object2);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Diff)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface Migration
    extends InstrumentedInterface {
        public ZenModeConfig migrate(XmlV1 var1);
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class XmlV1
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static String SLEEP_MODE_NIGHTS = "nights";
        public static String SLEEP_MODE_WEEKNIGHTS = "weeknights";
        public static String SLEEP_MODE_DAYS_PREFIX = "days:";
        private static String EXIT_CONDITION_TAG = "exitCondition";
        private static String EXIT_CONDITION_ATT_COMPONENT = "component";
        private static String SLEEP_TAG = "sleep";
        private static String SLEEP_ATT_MODE = "mode";
        private static String SLEEP_ATT_NONE = "none";
        private static String SLEEP_ATT_START_HR = "startHour";
        private static String SLEEP_ATT_START_MIN = "startMin";
        private static String SLEEP_ATT_END_HR = "endHour";
        private static String SLEEP_ATT_END_MIN = "endMin";
        public boolean allowCalls;
        public boolean allowMessages;
        public boolean allowReminders;
        public boolean allowEvents;
        public int allowFrom;
        public String sleepMode;
        public int sleepStartHour;
        public int sleepStartMinute;
        public int sleepEndHour;
        public int sleepEndMinute;
        public boolean sleepNone;
        public ComponentName[] conditionComponents;
        public Uri[] conditionIds;
        public Condition exitCondition;
        public ComponentName exitConditionComponent;

        private void $$robo$$android_service_notification_ZenModeConfig_XmlV1$__constructor__() {
            this.allowReminders = true;
            this.allowEvents = true;
            this.allowFrom = 0;
        }

        private static final boolean $$robo$$android_service_notification_ZenModeConfig_XmlV1$isValidSleepMode(String sleepMode) {
            return sleepMode == null || sleepMode.equals("nights") || sleepMode.equals("weeknights") || XmlV1.tryParseDays(sleepMode) != null;
        }

        private static final int[] $$robo$$android_service_notification_ZenModeConfig_XmlV1$tryParseDays(String sleepMode) {
            if (sleepMode == null) {
                return null;
            }
            if ("nights".equals(sleepMode = sleepMode.trim())) {
                return ALL_DAYS;
            }
            if ("weeknights".equals(sleepMode)) {
                return WEEKNIGHT_DAYS;
            }
            if (!sleepMode.startsWith("days:")) {
                return null;
            }
            if (sleepMode.equals("days:")) {
                return null;
            }
            return ZenModeConfig.tryParseDayList(sleepMode.substring("days:".length()), ",");
        }

        private static final XmlV1 $$robo$$android_service_notification_ZenModeConfig_XmlV1$readXml(XmlPullParser parser) throws XmlPullParserException, IOException {
            int type;
            XmlV1 rt = new XmlV1();
            ArrayList<ComponentName> conditionComponents = new ArrayList<ComponentName>();
            ArrayList<Uri> conditionIds = new ArrayList<Uri>();
            while ((type = parser.next()) != 1) {
                String tag = parser.getName();
                if (type == 3 && "zen".equals(tag)) {
                    if (!conditionComponents.isEmpty()) {
                        rt.conditionComponents = conditionComponents.toArray(new ComponentName[conditionComponents.size()]);
                        rt.conditionIds = conditionIds.toArray(new Uri[conditionIds.size()]);
                    }
                    return rt;
                }
                if (type != 2) continue;
                if ("allow".equals(tag)) {
                    rt.allowCalls = ZenModeConfig.safeBoolean(parser, "calls", false);
                    rt.allowMessages = ZenModeConfig.safeBoolean(parser, "messages", false);
                    rt.allowReminders = ZenModeConfig.safeBoolean(parser, "reminders", true);
                    rt.allowEvents = ZenModeConfig.safeBoolean(parser, "events", true);
                    rt.allowFrom = ZenModeConfig.safeInt(parser, "from", 0);
                    if (rt.allowFrom >= 0 && rt.allowFrom <= 2) continue;
                    throw new IndexOutOfBoundsException("bad source in config:" + rt.allowFrom);
                }
                if ("sleep".equals(tag)) {
                    String mode = parser.getAttributeValue(null, "mode");
                    rt.sleepMode = XmlV1.isValidSleepMode(mode) ? mode : null;
                    rt.sleepNone = ZenModeConfig.safeBoolean(parser, "none", false);
                    int startHour = ZenModeConfig.safeInt(parser, "startHour", 0);
                    int startMinute = ZenModeConfig.safeInt(parser, "startMin", 0);
                    int endHour = ZenModeConfig.safeInt(parser, "endHour", 0);
                    int endMinute = ZenModeConfig.safeInt(parser, "endMin", 0);
                    rt.sleepStartHour = ZenModeConfig.isValidHour(startHour) ? startHour : 0;
                    rt.sleepStartMinute = ZenModeConfig.isValidMinute(startMinute) ? startMinute : 0;
                    rt.sleepEndHour = ZenModeConfig.isValidHour(endHour) ? endHour : 0;
                    rt.sleepEndMinute = ZenModeConfig.isValidMinute(endMinute) ? endMinute : 0;
                    continue;
                }
                if ("condition".equals(tag)) {
                    ComponentName component = ZenModeConfig.safeComponentName(parser, "component");
                    Uri conditionId = ZenModeConfig.safeUri(parser, "id");
                    if (component == null || conditionId == null) continue;
                    conditionComponents.add(component);
                    conditionIds.add(conditionId);
                    continue;
                }
                if (!"exitCondition".equals(tag)) continue;
                rt.exitCondition = ZenModeConfig.readConditionXml(parser);
                if (rt.exitCondition == null) continue;
                rt.exitConditionComponent = ZenModeConfig.safeComponentName(parser, "component");
            }
            throw new IllegalStateException("Failed to reach END_DOCUMENT");
        }

        private void __constructor__() {
            this.$$robo$$android_service_notification_ZenModeConfig_XmlV1$__constructor__();
        }

        public XmlV1() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_notification_ZenModeConfig_XmlV1$__constructor__(), 0, this);
        }

        private static boolean isValidSleepMode(String string2) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidSleepMode", $$robo$$android_service_notification_ZenModeConfig_XmlV1$isValidSleepMode(java.lang.String ), 0, (String)string2);
        }

        public static int[] tryParseDays(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("tryParseDays", $$robo$$android_service_notification_ZenModeConfig_XmlV1$tryParseDays(java.lang.String ), 0, (String)string2);
        }

        public static XmlV1 readXml(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
            return InvokeDynamicSupport.bootstrapStatic("readXml", $$robo$$android_service_notification_ZenModeConfig_XmlV1$readXml(org.xmlpull.v1.XmlPullParser ), 0, (XmlPullParser)xmlPullParser);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (XmlV1)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ZenRule
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public boolean enabled;
        public boolean snoozing;
        public String name;
        public int zenMode;
        public Uri conditionId;
        public Condition condition;
        public ComponentName component;
        public String id;
        public long creationTime;
        public static Parcelable.Creator<ZenRule> CREATOR;

        private void $$robo$$android_service_notification_ZenModeConfig_ZenRule$__constructor__() {
        }

        private void $$robo$$android_service_notification_ZenModeConfig_ZenRule$__constructor__(Parcel source) {
            this.enabled = source.readInt() == 1;
            boolean bl = this.snoozing = source.readInt() == 1;
            if (source.readInt() == 1) {
                this.name = source.readString();
            }
            this.zenMode = source.readInt();
            this.conditionId = (Uri)source.readParcelable(null);
            this.condition = (Condition)source.readParcelable(null);
            this.component = (ComponentName)source.readParcelable(null);
            if (source.readInt() == 1) {
                this.id = source.readString();
            }
            this.creationTime = source.readLong();
        }

        private final int $$robo$$android_service_notification_ZenModeConfig_ZenRule$describeContents() {
            return 0;
        }

        private final void $$robo$$android_service_notification_ZenModeConfig_ZenRule$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.enabled ? 1 : 0);
            dest.writeInt(this.snoozing ? 1 : 0);
            if (this.name != null) {
                dest.writeInt(1);
                dest.writeString(this.name);
            } else {
                dest.writeInt(0);
            }
            dest.writeInt(this.zenMode);
            dest.writeParcelable(this.conditionId, 0);
            dest.writeParcelable(this.condition, 0);
            dest.writeParcelable(this.component, 0);
            if (this.id != null) {
                dest.writeInt(1);
                dest.writeString(this.id);
            } else {
                dest.writeInt(0);
            }
            dest.writeLong(this.creationTime);
        }

        private final String $$robo$$android_service_notification_ZenModeConfig_ZenRule$toString() {
            return ZenRule.class.getSimpleName() + '[' + "enabled=" + this.enabled + ",snoozing=" + this.snoozing + ",name=" + this.name + ",zenMode=" + Settings.Global.zenModeToString(this.zenMode) + ",conditionId=" + this.conditionId + ",condition=" + this.condition + ",component=" + this.component + ",id=" + this.id + ",creationTime=" + this.creationTime + ']';
        }

        private static final void $$robo$$android_service_notification_ZenModeConfig_ZenRule$appendDiff(Diff d, String item, ZenRule from, ZenRule to) {
            if (d == null) {
                return;
            }
            if (from == null) {
                if (to != null) {
                    d.addLine(item, "insert");
                }
                return;
            }
            from.appendDiff(d, item, to);
        }

        private final void $$robo$$android_service_notification_ZenModeConfig_ZenRule$appendDiff(Diff d, String item, ZenRule to) {
            if (to == null) {
                d.addLine(item, "delete");
                return;
            }
            if (this.enabled != to.enabled) {
                d.addLine(item, "enabled", this.enabled, to.enabled);
            }
            if (this.snoozing != to.snoozing) {
                d.addLine(item, "snoozing", this.snoozing, to.snoozing);
            }
            if (!Objects.equals(this.name, to.name)) {
                d.addLine(item, "name", this.name, to.name);
            }
            if (this.zenMode != to.zenMode) {
                d.addLine(item, "zenMode", this.zenMode, to.zenMode);
            }
            if (!Objects.equals(this.conditionId, to.conditionId)) {
                d.addLine(item, "conditionId", this.conditionId, to.conditionId);
            }
            if (!Objects.equals(this.condition, to.condition)) {
                d.addLine(item, "condition", this.condition, to.condition);
            }
            if (!Objects.equals(this.component, to.component)) {
                d.addLine(item, "component", this.component, to.component);
            }
            if (!Objects.equals(this.id, to.id)) {
                d.addLine(item, "id", this.id, to.id);
            }
            if (this.creationTime != to.creationTime) {
                d.addLine(item, "creationTime", this.creationTime, to.creationTime);
            }
        }

        private final boolean $$robo$$android_service_notification_ZenModeConfig_ZenRule$equals(Object o) {
            if (!(o instanceof ZenRule)) {
                return false;
            }
            if (o == this) {
                return true;
            }
            ZenRule other = (ZenRule)o;
            return other.enabled == this.enabled && other.snoozing == this.snoozing && Objects.equals(other.name, this.name) && other.zenMode == this.zenMode && Objects.equals(other.conditionId, this.conditionId) && Objects.equals(other.condition, this.condition) && Objects.equals(other.component, this.component) && Objects.equals(other.id, this.id) && other.creationTime == this.creationTime;
        }

        private final int $$robo$$android_service_notification_ZenModeConfig_ZenRule$hashCode() {
            return Objects.hash(this.enabled, this.snoozing, this.name, this.zenMode, this.conditionId, this.condition, this.component, this.id, this.creationTime);
        }

        private final boolean $$robo$$android_service_notification_ZenModeConfig_ZenRule$isAutomaticActive() {
            return this.enabled && !this.snoozing && this.component != null && this.isTrueOrUnknown();
        }

        private final boolean $$robo$$android_service_notification_ZenModeConfig_ZenRule$isTrueOrUnknown() {
            return this.condition != null && (this.condition.state == 1 || this.condition.state == 2);
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<ZenRule>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_service_notification_ZenModeConfig_ZenRule_1$__constructor__() {
                }

                private final ZenRule $$robo$$android_service_notification_ZenModeConfig_ZenRule_1$createFromParcel(Parcel source) {
                    return new ZenRule(source);
                }

                private final ZenRule[] $$robo$$android_service_notification_ZenModeConfig_ZenRule_1$newArray(int size) {
                    return new ZenRule[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_service_notification_ZenModeConfig_ZenRule_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_notification_ZenModeConfig_ZenRule_1$__constructor__(), 0, this);
                }

                @Override
                public ZenRule createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_service_notification_ZenModeConfig_ZenRule_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public ZenRule[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_service_notification_ZenModeConfig_ZenRule_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__() {
            this.$$robo$$android_service_notification_ZenModeConfig_ZenRule$__constructor__();
        }

        public ZenRule() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_notification_ZenModeConfig_ZenRule$__constructor__(), 0, this);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_service_notification_ZenModeConfig_ZenRule$__constructor__(parcel);
        }

        public ZenRule(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_notification_ZenModeConfig_ZenRule$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_service_notification_ZenModeConfig_ZenRule$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_service_notification_ZenModeConfig_ZenRule$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_service_notification_ZenModeConfig_ZenRule$toString(), 0, this);
        }

        private static void appendDiff(Diff diff, String string2, ZenRule zenRule, ZenRule zenRule2) {
            InvokeDynamicSupport.bootstrapStatic("appendDiff", $$robo$$android_service_notification_ZenModeConfig_ZenRule$appendDiff(android.service.notification.ZenModeConfig$Diff java.lang.String android.service.notification.ZenModeConfig$ZenRule android.service.notification.ZenModeConfig$ZenRule ), 0, (Diff)diff, (String)string2, (ZenRule)zenRule, (ZenRule)zenRule2);
        }

        private void appendDiff(Diff diff, String string2, ZenRule zenRule) {
            InvokeDynamicSupport.bootstrap("appendDiff", $$robo$$android_service_notification_ZenModeConfig_ZenRule$appendDiff(android.service.notification.ZenModeConfig$Diff java.lang.String android.service.notification.ZenModeConfig$ZenRule ), 0, this, diff, string2, zenRule);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_service_notification_ZenModeConfig_ZenRule$equals(java.lang.Object ), 0, this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_service_notification_ZenModeConfig_ZenRule$hashCode(), 0, this);
        }

        public boolean isAutomaticActive() {
            return (boolean)InvokeDynamicSupport.bootstrap("isAutomaticActive", $$robo$$android_service_notification_ZenModeConfig_ZenRule$isAutomaticActive(), 0, this);
        }

        public boolean isTrueOrUnknown() {
            return (boolean)InvokeDynamicSupport.bootstrap("isTrueOrUnknown", $$robo$$android_service_notification_ZenModeConfig_ZenRule$isTrueOrUnknown(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(ZenRule.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ZenRule)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class EventInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int REPLY_ANY_EXCEPT_NO = 0;
        public static int REPLY_YES_OR_MAYBE = 1;
        public static int REPLY_YES = 2;
        public int userId;
        public String calendar;
        public int reply;

        private void $$robo$$android_service_notification_ZenModeConfig_EventInfo$__constructor__() {
            this.userId = -10000;
        }

        private final int $$robo$$android_service_notification_ZenModeConfig_EventInfo$hashCode() {
            return 0;
        }

        private final boolean $$robo$$android_service_notification_ZenModeConfig_EventInfo$equals(Object o) {
            if (!(o instanceof EventInfo)) {
                return false;
            }
            EventInfo other = (EventInfo)o;
            return this.userId == other.userId && Objects.equals(this.calendar, other.calendar) && this.reply == other.reply;
        }

        private final EventInfo $$robo$$android_service_notification_ZenModeConfig_EventInfo$copy() {
            EventInfo rt = new EventInfo();
            rt.userId = this.userId;
            rt.calendar = this.calendar;
            rt.reply = this.reply;
            return rt;
        }

        private static final int $$robo$$android_service_notification_ZenModeConfig_EventInfo$resolveUserId(int userId) {
            return userId == -10000 ? ActivityManager.getCurrentUser() : userId;
        }

        private void __constructor__() {
            this.$$robo$$android_service_notification_ZenModeConfig_EventInfo$__constructor__();
        }

        public EventInfo() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_notification_ZenModeConfig_EventInfo$__constructor__(), 0, this);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_service_notification_ZenModeConfig_EventInfo$hashCode(), 0, this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_service_notification_ZenModeConfig_EventInfo$equals(java.lang.Object ), 0, this, object);
        }

        public EventInfo copy() {
            return InvokeDynamicSupport.bootstrap("copy", $$robo$$android_service_notification_ZenModeConfig_EventInfo$copy(), 0, this);
        }

        public static int resolveUserId(int n) {
            return (int)InvokeDynamicSupport.bootstrapStatic("resolveUserId", $$robo$$android_service_notification_ZenModeConfig_EventInfo$resolveUserId(int ), 0, (int)n);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EventInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ScheduleInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int[] days;
        public int startHour;
        public int startMinute;
        public int endHour;
        public int endMinute;
        public boolean exitAtAlarm;
        public long nextAlarm;

        private void $$robo$$android_service_notification_ZenModeConfig_ScheduleInfo$__constructor__() {
        }

        private final int $$robo$$android_service_notification_ZenModeConfig_ScheduleInfo$hashCode() {
            return 0;
        }

        private final boolean $$robo$$android_service_notification_ZenModeConfig_ScheduleInfo$equals(Object o) {
            if (!(o instanceof ScheduleInfo)) {
                return false;
            }
            ScheduleInfo other = (ScheduleInfo)o;
            return ZenModeConfig.toDayList(this.days).equals(ZenModeConfig.toDayList(other.days)) && this.startHour == other.startHour && this.startMinute == other.startMinute && this.endHour == other.endHour && this.endMinute == other.endMinute && this.exitAtAlarm == other.exitAtAlarm;
        }

        private final ScheduleInfo $$robo$$android_service_notification_ZenModeConfig_ScheduleInfo$copy() {
            ScheduleInfo rt = new ScheduleInfo();
            if (this.days != null) {
                rt.days = new int[this.days.length];
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])this.days, (int)0, (int[])rt.days, (int)0, (int)this.days.length);
            }
            rt.startHour = this.startHour;
            rt.startMinute = this.startMinute;
            rt.endHour = this.endHour;
            rt.endMinute = this.endMinute;
            rt.exitAtAlarm = this.exitAtAlarm;
            rt.nextAlarm = this.nextAlarm;
            return rt;
        }

        private final String $$robo$$android_service_notification_ZenModeConfig_ScheduleInfo$toString() {
            return "ScheduleInfo{days=" + Arrays.toString(this.days) + ", startHour=" + this.startHour + ", startMinute=" + this.startMinute + ", endHour=" + this.endHour + ", endMinute=" + this.endMinute + ", exitAtAlarm=" + this.exitAtAlarm + ", nextAlarm=" + this.nextAlarm + '}';
        }

        private void __constructor__() {
            this.$$robo$$android_service_notification_ZenModeConfig_ScheduleInfo$__constructor__();
        }

        public ScheduleInfo() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_notification_ZenModeConfig_ScheduleInfo$__constructor__(), 0, this);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_service_notification_ZenModeConfig_ScheduleInfo$hashCode(), 0, this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_service_notification_ZenModeConfig_ScheduleInfo$equals(java.lang.Object ), 0, this, object);
        }

        public ScheduleInfo copy() {
            return InvokeDynamicSupport.bootstrap("copy", $$robo$$android_service_notification_ZenModeConfig_ScheduleInfo$copy(), 0, this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_service_notification_ZenModeConfig_ScheduleInfo$toString(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ScheduleInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

