/*
 * Decompiled with CFR 0.152.
 */
package android.service.notification;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.service.notification.Adjustment;
import android.service.notification.IStatusBarNotificationHolder;
import android.service.notification.NotificationListenerService;
import android.service.notification.StatusBarNotification;
import android.util.Log;
import com.android.internal.os.SomeArgs;
import com.google.errorprone.annotations.DoNotMock;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class NotificationRankerService
extends NotificationListenerService
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "NotificationRankers";
    public static String SERVICE_INTERFACE = "android.service.notification.NotificationRankerService";
    public static int REASON_DELEGATE_CLICK = 1;
    public static int REASON_DELEGATE_CANCEL = 2;
    public static int REASON_DELEGATE_CANCEL_ALL = 3;
    public static int REASON_DELEGATE_ERROR = 4;
    public static int REASON_PACKAGE_CHANGED = 5;
    public static int REASON_USER_STOPPED = 6;
    public static int REASON_PACKAGE_BANNED = 7;
    public static int REASON_APP_CANCEL = 8;
    public static int REASON_APP_CANCEL_ALL = 9;
    public static int REASON_LISTENER_CANCEL = 10;
    public static int REASON_LISTENER_CANCEL_ALL = 11;
    public static int REASON_GROUP_SUMMARY_CANCELED = 12;
    public static int REASON_GROUP_OPTIMIZATION = 13;
    public static int REASON_PACKAGE_SUSPENDED = 14;
    public static int REASON_PROFILE_TURNED_OFF = 15;
    public static int REASON_UNAUTOBUNDLED = 16;
    private Handler mHandler;

    private void $$robo$$android_service_notification_NotificationRankerService$__constructor__() {
    }

    private final void $$robo$$android_service_notification_NotificationRankerService$registerAsSystemService(Context context, ComponentName componentName, int currentUser) {
        throw new UnsupportedOperationException("the ranker lifecycle is managed by the system.");
    }

    private final void $$robo$$android_service_notification_NotificationRankerService$unregisterAsSystemService() {
        throw new UnsupportedOperationException("the ranker lifecycle is managed by the system.");
    }

    private final void $$robo$$android_service_notification_NotificationRankerService$attachBaseContext(Context base) {
        super.attachBaseContext(base);
        this.mHandler = new MyHandler(this, this.getContext().getMainLooper());
    }

    private final IBinder $$robo$$android_service_notification_NotificationRankerService$onBind(Intent intent) {
        if (this.mWrapper == null) {
            this.mWrapper = new NotificationRankingServiceWrapper(this);
        }
        return this.mWrapper;
    }

    public abstract Adjustment onNotificationEnqueued(StatusBarNotification var1, int var2, boolean var3);

    private final void $$robo$$android_service_notification_NotificationRankerService$onNotificationVisibilityChanged(String key, long time, boolean visible) {
    }

    private final void $$robo$$android_service_notification_NotificationRankerService$onNotificationClick(String key, long time) {
    }

    private final void $$robo$$android_service_notification_NotificationRankerService$onNotificationActionClick(String key, long time, int actionIndex) {
    }

    private final void $$robo$$android_service_notification_NotificationRankerService$onNotificationRemoved(String key, long time, int reason) {
    }

    private final void $$robo$$android_service_notification_NotificationRankerService$adjustNotification(Adjustment adjustment) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().applyAdjustmentFromRankerService(this.mWrapper, adjustment);
        }
        catch (RemoteException ex) {
            Log.v("NotificationRankers", "Unable to contact notification manager", ex);
        }
    }

    private final void $$robo$$android_service_notification_NotificationRankerService$adjustNotifications(List<Adjustment> adjustments) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().applyAdjustmentsFromRankerService(this.mWrapper, adjustments);
        }
        catch (RemoteException ex) {
            Log.v("NotificationRankers", "Unable to contact notification manager", ex);
        }
    }

    private void __constructor__() {
        this.$$robo$$android_service_notification_NotificationRankerService$__constructor__();
    }

    public NotificationRankerService() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_notification_NotificationRankerService$__constructor__(), 0, this);
    }

    @Override
    public void registerAsSystemService(Context context, ComponentName componentName, int n) {
        InvokeDynamicSupport.bootstrap("registerAsSystemService", $$robo$$android_service_notification_NotificationRankerService$registerAsSystemService(android.content.Context android.content.ComponentName int ), 0, this, context, componentName, n);
    }

    @Override
    public void unregisterAsSystemService() {
        InvokeDynamicSupport.bootstrap("unregisterAsSystemService", $$robo$$android_service_notification_NotificationRankerService$unregisterAsSystemService(), 0, this);
    }

    @Override
    protected void attachBaseContext(Context context) {
        InvokeDynamicSupport.bootstrap("attachBaseContext", $$robo$$android_service_notification_NotificationRankerService$attachBaseContext(android.content.Context ), 0, this, context);
    }

    @Override
    public IBinder onBind(Intent intent) {
        return InvokeDynamicSupport.bootstrap("onBind", $$robo$$android_service_notification_NotificationRankerService$onBind(android.content.Intent ), 0, this, intent);
    }

    public void onNotificationVisibilityChanged(String string2, long l, boolean bl) {
        InvokeDynamicSupport.bootstrap("onNotificationVisibilityChanged", $$robo$$android_service_notification_NotificationRankerService$onNotificationVisibilityChanged(java.lang.String long boolean ), 0, this, string2, l, bl);
    }

    public void onNotificationClick(String string2, long l) {
        InvokeDynamicSupport.bootstrap("onNotificationClick", $$robo$$android_service_notification_NotificationRankerService$onNotificationClick(java.lang.String long ), 0, this, string2, l);
    }

    public void onNotificationActionClick(String string2, long l, int n) {
        InvokeDynamicSupport.bootstrap("onNotificationActionClick", $$robo$$android_service_notification_NotificationRankerService$onNotificationActionClick(java.lang.String long int ), 0, this, string2, l, n);
    }

    public void onNotificationRemoved(String string2, long l, int n) {
        InvokeDynamicSupport.bootstrap("onNotificationRemoved", $$robo$$android_service_notification_NotificationRankerService$onNotificationRemoved(java.lang.String long int ), 0, this, string2, l, n);
    }

    public void adjustNotification(Adjustment adjustment) {
        InvokeDynamicSupport.bootstrap("adjustNotification", $$robo$$android_service_notification_NotificationRankerService$adjustNotification(android.service.notification.Adjustment ), 0, this, adjustment);
    }

    public void adjustNotifications(List<Adjustment> list) {
        InvokeDynamicSupport.bootstrap("adjustNotifications", $$robo$$android_service_notification_NotificationRankerService$adjustNotifications(java.util.List<android.service.notification.Adjustment> ), 0, this, list);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NotificationRankerService)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private final class MyHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int MSG_ON_NOTIFICATION_ENQUEUED = 1;
        public static int MSG_ON_NOTIFICATION_VISIBILITY_CHANGED = 2;
        public static int MSG_ON_NOTIFICATION_CLICK = 3;
        public static int MSG_ON_NOTIFICATION_ACTION_CLICK = 4;
        public static int MSG_ON_NOTIFICATION_REMOVED_REASON = 5;
        /* synthetic */ NotificationRankerService this$0;

        private void $$robo$$android_service_notification_NotificationRankerService_MyHandler$__constructor__(NotificationRankerService notificationRankerService, Looper looper) {
        }

        private final void $$robo$$android_service_notification_NotificationRankerService_MyHandler$handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    StatusBarNotification sbn = (StatusBarNotification)args.arg1;
                    int importance = args.argi1;
                    boolean user = args.argi2 == 1;
                    args.recycle();
                    Adjustment adjustment = this.this$0.onNotificationEnqueued(sbn, importance, user);
                    if (adjustment == null) break;
                    this.this$0.adjustNotification(adjustment);
                    break;
                }
                case 2: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    String key = (String)args.arg1;
                    long time = (Long)args.arg2;
                    boolean visible = args.argi1 == 1;
                    args.recycle();
                    this.this$0.onNotificationVisibilityChanged(key, time, visible);
                    break;
                }
                case 3: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    String key = (String)args.arg1;
                    long time = (Long)args.arg2;
                    args.recycle();
                    this.this$0.onNotificationClick(key, time);
                    break;
                }
                case 4: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    String key = (String)args.arg1;
                    long time = (Long)args.arg2;
                    int actionIndex = args.argi1;
                    args.recycle();
                    this.this$0.onNotificationActionClick(key, time, actionIndex);
                    break;
                }
                case 5: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    String key = (String)args.arg1;
                    long time = (Long)args.arg2;
                    int reason = args.argi1;
                    args.recycle();
                    this.this$0.onNotificationRemoved(key, time, reason);
                }
            }
        }

        private void __constructor__(NotificationRankerService notificationRankerService, Looper looper) {
            this.$$robo$$android_service_notification_NotificationRankerService_MyHandler$__constructor__(notificationRankerService, looper);
        }

        public MyHandler(NotificationRankerService notificationRankerService, Looper looper) {
            this.this$0 = notificationRankerService;
            super(looper, null, false);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_notification_NotificationRankerService_MyHandler$__constructor__(android.service.notification.NotificationRankerService android.os.Looper ), 0, this, notificationRankerService, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_service_notification_NotificationRankerService_MyHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ MyHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MyHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class NotificationRankingServiceWrapper
    extends NotificationListenerService.NotificationListenerWrapper
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ NotificationRankerService this$0;

        private void $$robo$$android_service_notification_NotificationRankerService_NotificationRankingServiceWrapper$__constructor__(NotificationRankerService notificationRankerService) {
        }

        private final void $$robo$$android_service_notification_NotificationRankerService_NotificationRankingServiceWrapper$onNotificationEnqueued(IStatusBarNotificationHolder sbnHolder, int importance, boolean user) {
            StatusBarNotification sbn;
            try {
                sbn = sbnHolder.get();
            }
            catch (RemoteException e) {
                Log.w("NotificationRankers", "onNotificationEnqueued: Error receiving StatusBarNotification", e);
                return;
            }
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = sbn;
            args.argi1 = importance;
            args.argi2 = user ? 1 : 0;
            this.this$0.mHandler.obtainMessage(1, args).sendToTarget();
        }

        private final void $$robo$$android_service_notification_NotificationRankerService_NotificationRankingServiceWrapper$onNotificationVisibilityChanged(String key, long time, boolean visible) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = key;
            args.arg2 = time;
            args.argi1 = visible ? 1 : 0;
            this.this$0.mHandler.obtainMessage(2, args).sendToTarget();
        }

        private final void $$robo$$android_service_notification_NotificationRankerService_NotificationRankingServiceWrapper$onNotificationClick(String key, long time) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = key;
            args.arg2 = time;
            this.this$0.mHandler.obtainMessage(3, args).sendToTarget();
        }

        private final void $$robo$$android_service_notification_NotificationRankerService_NotificationRankingServiceWrapper$onNotificationActionClick(String key, long time, int actionIndex) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = key;
            args.arg2 = time;
            args.argi1 = actionIndex;
            this.this$0.mHandler.obtainMessage(4, args).sendToTarget();
        }

        private final void $$robo$$android_service_notification_NotificationRankerService_NotificationRankingServiceWrapper$onNotificationRemovedReason(String key, long time, int reason) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = key;
            args.arg2 = time;
            args.argi1 = reason;
            this.this$0.mHandler.obtainMessage(5, args).sendToTarget();
        }

        private /* synthetic */ void $$robo$$android_service_notification_NotificationRankerService_NotificationRankingServiceWrapper$__constructor__(NotificationRankerService x0, 1 x1) {
        }

        private void __constructor__(NotificationRankerService notificationRankerService) {
            this.$$robo$$android_service_notification_NotificationRankerService_NotificationRankingServiceWrapper$__constructor__(notificationRankerService);
        }

        private NotificationRankingServiceWrapper(NotificationRankerService notificationRankerService) {
            this.this$0 = notificationRankerService;
            super(notificationRankerService);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_notification_NotificationRankerService_NotificationRankingServiceWrapper$__constructor__(android.service.notification.NotificationRankerService ), 0, this, notificationRankerService);
        }

        @Override
        public void onNotificationEnqueued(IStatusBarNotificationHolder iStatusBarNotificationHolder, int n, boolean bl) {
            InvokeDynamicSupport.bootstrap("onNotificationEnqueued", $$robo$$android_service_notification_NotificationRankerService_NotificationRankingServiceWrapper$onNotificationEnqueued(android.service.notification.IStatusBarNotificationHolder int boolean ), 0, this, iStatusBarNotificationHolder, n, bl);
        }

        @Override
        public void onNotificationVisibilityChanged(String string2, long l, boolean bl) {
            InvokeDynamicSupport.bootstrap("onNotificationVisibilityChanged", $$robo$$android_service_notification_NotificationRankerService_NotificationRankingServiceWrapper$onNotificationVisibilityChanged(java.lang.String long boolean ), 0, this, string2, l, bl);
        }

        @Override
        public void onNotificationClick(String string2, long l) {
            InvokeDynamicSupport.bootstrap("onNotificationClick", $$robo$$android_service_notification_NotificationRankerService_NotificationRankingServiceWrapper$onNotificationClick(java.lang.String long ), 0, this, string2, l);
        }

        @Override
        public void onNotificationActionClick(String string2, long l, int n) {
            InvokeDynamicSupport.bootstrap("onNotificationActionClick", $$robo$$android_service_notification_NotificationRankerService_NotificationRankingServiceWrapper$onNotificationActionClick(java.lang.String long int ), 0, this, string2, l, n);
        }

        @Override
        public void onNotificationRemovedReason(String string2, long l, int n) {
            InvokeDynamicSupport.bootstrap("onNotificationRemovedReason", $$robo$$android_service_notification_NotificationRankerService_NotificationRankingServiceWrapper$onNotificationRemovedReason(java.lang.String long int ), 0, this, string2, l, n);
        }

        private /* synthetic */ void __constructor__(NotificationRankerService notificationRankerService, 1 var2_2) {
            this.$$robo$$android_service_notification_NotificationRankerService_NotificationRankingServiceWrapper$__constructor__(notificationRankerService, var2_2);
        }

        public /* synthetic */ NotificationRankingServiceWrapper() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NotificationRankingServiceWrapper)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

