/*
 * Decompiled with CFR 0.152.
 */
package android.service.dreams;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.provider.Settings;
import android.service.dreams.IDreamManager;
import android.util.Slog;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class Sandman
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "Sandman";
    private static ComponentName SOMNAMBULATOR_COMPONENT;

    private void $$robo$$android_service_dreams_Sandman$__constructor__() {
    }

    private static final boolean $$robo$$android_service_dreams_Sandman$shouldStartDockApp(Context context, Intent intent) {
        ComponentName name = intent.resolveActivity(context.getPackageManager());
        return name != null && !name.equals(SOMNAMBULATOR_COMPONENT);
    }

    private static final void $$robo$$android_service_dreams_Sandman$startDreamByUserRequest(Context context) {
        Sandman.startDream(context, false);
    }

    private static final void $$robo$$android_service_dreams_Sandman$startDreamWhenDockedIfAppropriate(Context context) {
        if (!Sandman.isScreenSaverEnabled(context) || !Sandman.isScreenSaverActivatedOnDock(context)) {
            Slog.i("Sandman", "Dreams currently disabled for docks.");
            return;
        }
        Sandman.startDream(context, true);
    }

    private static final void $$robo$$android_service_dreams_Sandman$startDream(Context context, boolean docked) {
        try {
            IDreamManager dreamManagerService = IDreamManager.Stub.asInterface(ServiceManager.getService("dreams"));
            if (dreamManagerService != null && !dreamManagerService.isDreaming()) {
                if (docked) {
                    Slog.i("Sandman", "Activating dream while docked.");
                    PowerManager powerManager = (PowerManager)context.getSystemService("power");
                    powerManager.wakeUp(SystemClock.uptimeMillis(), "android.service.dreams:DREAM");
                } else {
                    Slog.i("Sandman", "Activating dream by user request.");
                }
                dreamManagerService.dream();
            }
        }
        catch (RemoteException ex) {
            Slog.e("Sandman", "Could not start dream when docked.", ex);
        }
    }

    private static final boolean $$robo$$android_service_dreams_Sandman$isScreenSaverEnabled(Context context) {
        int def = context.getResources().getBoolean(17956971) ? 1 : 0;
        return Settings.Secure.getIntForUser(context.getContentResolver(), "screensaver_enabled", def, -2) != 0;
    }

    private static final boolean $$robo$$android_service_dreams_Sandman$isScreenSaverActivatedOnDock(Context context) {
        int def = context.getResources().getBoolean(17956972) ? 1 : 0;
        return Settings.Secure.getIntForUser(context.getContentResolver(), "screensaver_activate_on_dock", def, -2) != 0;
    }

    static void __staticInitializer__() {
        SOMNAMBULATOR_COMPONENT = new ComponentName("com.android.systemui", "com.android.systemui.Somnambulator");
    }

    private void __constructor__() {
        this.$$robo$$android_service_dreams_Sandman$__constructor__();
    }

    private Sandman() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_dreams_Sandman$__constructor__(), 0, this);
    }

    public static boolean shouldStartDockApp(Context context, Intent intent) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("shouldStartDockApp", $$robo$$android_service_dreams_Sandman$shouldStartDockApp(android.content.Context android.content.Intent ), 0, (Context)context, (Intent)intent);
    }

    public static void startDreamByUserRequest(Context context) {
        InvokeDynamicSupport.bootstrapStatic("startDreamByUserRequest", $$robo$$android_service_dreams_Sandman$startDreamByUserRequest(android.content.Context ), 0, (Context)context);
    }

    public static void startDreamWhenDockedIfAppropriate(Context context) {
        InvokeDynamicSupport.bootstrapStatic("startDreamWhenDockedIfAppropriate", $$robo$$android_service_dreams_Sandman$startDreamWhenDockedIfAppropriate(android.content.Context ), 0, (Context)context);
    }

    private static void startDream(Context context, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("startDream", $$robo$$android_service_dreams_Sandman$startDream(android.content.Context boolean ), 0, (Context)context, (boolean)bl);
    }

    private static boolean isScreenSaverEnabled(Context context) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isScreenSaverEnabled", $$robo$$android_service_dreams_Sandman$isScreenSaverEnabled(android.content.Context ), 0, (Context)context);
    }

    private static boolean isScreenSaverActivatedOnDock(Context context) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isScreenSaverActivatedOnDock", $$robo$$android_service_dreams_Sandman$isScreenSaverActivatedOnDock(android.content.Context ), 0, (Context)context);
    }

    static {
        RobolectricInternals.classInitializing(Sandman.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Sandman)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

