/*
 * Decompiled with CFR 0.152.
 */
package android.security.net.config;

import android.security.net.config.CertificateSource;
import android.util.ArraySet;
import com.android.org.conscrypt.TrustedCertificateIndex;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class KeyStoreCertificateSource
implements CertificateSource,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Object mLock;
    private KeyStore mKeyStore;
    private TrustedCertificateIndex mIndex;
    private Set<X509Certificate> mCertificates;

    private void $$robo$$android_security_net_config_KeyStoreCertificateSource$__constructor__(KeyStore ks) {
        this.mLock = new Object();
        this.mKeyStore = ks;
    }

    private final Set<X509Certificate> $$robo$$android_security_net_config_KeyStoreCertificateSource$getCertificates() {
        this.ensureInitialized();
        return this.mCertificates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_security_net_config_KeyStoreCertificateSource$ensureInitialized() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCertificates != null) {
                return;
            }
            try {
                TrustedCertificateIndex localIndex = new TrustedCertificateIndex();
                ArraySet<X509Certificate> certificates = new ArraySet<X509Certificate>(this.mKeyStore.size());
                Enumeration<String> en = this.mKeyStore.aliases();
                while (en.hasMoreElements()) {
                    String alias = en.nextElement();
                    X509Certificate cert = (X509Certificate)this.mKeyStore.getCertificate(alias);
                    if (cert == null) continue;
                    certificates.add(cert);
                    localIndex.index(cert);
                }
                this.mIndex = localIndex;
                this.mCertificates = certificates;
            }
            catch (KeyStoreException e) {
                throw new RuntimeException("Failed to load certificates from KeyStore", e);
            }
        }
    }

    private final X509Certificate $$robo$$android_security_net_config_KeyStoreCertificateSource$findBySubjectAndPublicKey(X509Certificate cert) {
        this.ensureInitialized();
        TrustAnchor anchor = this.mIndex.findBySubjectAndPublicKey(cert);
        if (anchor == null) {
            return null;
        }
        return anchor.getTrustedCert();
    }

    private final X509Certificate $$robo$$android_security_net_config_KeyStoreCertificateSource$findByIssuerAndSignature(X509Certificate cert) {
        this.ensureInitialized();
        TrustAnchor anchor = this.mIndex.findByIssuerAndSignature(cert);
        if (anchor == null) {
            return null;
        }
        return anchor.getTrustedCert();
    }

    private final Set<X509Certificate> $$robo$$android_security_net_config_KeyStoreCertificateSource$findAllByIssuerAndSignature(X509Certificate cert) {
        this.ensureInitialized();
        Set<TrustAnchor> anchors = this.mIndex.findAllByIssuerAndSignature(cert);
        if (anchors.isEmpty()) {
            return Collections.emptySet();
        }
        ArraySet<X509Certificate> certs = new ArraySet<X509Certificate>(anchors.size());
        for (TrustAnchor anchor : anchors) {
            certs.add(anchor.getTrustedCert());
        }
        return certs;
    }

    private final void $$robo$$android_security_net_config_KeyStoreCertificateSource$handleTrustStorageUpdate() {
    }

    private void __constructor__(KeyStore keyStore) {
        this.$$robo$$android_security_net_config_KeyStoreCertificateSource$__constructor__(keyStore);
    }

    public KeyStoreCertificateSource(KeyStore keyStore) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_net_config_KeyStoreCertificateSource$__constructor__(java.security.KeyStore ), 0, this, keyStore);
    }

    @Override
    public Set<X509Certificate> getCertificates() {
        return InvokeDynamicSupport.bootstrap("getCertificates", $$robo$$android_security_net_config_KeyStoreCertificateSource$getCertificates(), 0, this);
    }

    private void ensureInitialized() {
        InvokeDynamicSupport.bootstrap("ensureInitialized", $$robo$$android_security_net_config_KeyStoreCertificateSource$ensureInitialized(), 0, this);
    }

    @Override
    public X509Certificate findBySubjectAndPublicKey(X509Certificate x509Certificate) {
        return InvokeDynamicSupport.bootstrap("findBySubjectAndPublicKey", $$robo$$android_security_net_config_KeyStoreCertificateSource$findBySubjectAndPublicKey(java.security.cert.X509Certificate ), 0, this, x509Certificate);
    }

    @Override
    public X509Certificate findByIssuerAndSignature(X509Certificate x509Certificate) {
        return InvokeDynamicSupport.bootstrap("findByIssuerAndSignature", $$robo$$android_security_net_config_KeyStoreCertificateSource$findByIssuerAndSignature(java.security.cert.X509Certificate ), 0, this, x509Certificate);
    }

    @Override
    public Set<X509Certificate> findAllByIssuerAndSignature(X509Certificate x509Certificate) {
        return InvokeDynamicSupport.bootstrap("findAllByIssuerAndSignature", $$robo$$android_security_net_config_KeyStoreCertificateSource$findAllByIssuerAndSignature(java.security.cert.X509Certificate ), 0, this, x509Certificate);
    }

    @Override
    public void handleTrustStorageUpdate() {
        InvokeDynamicSupport.bootstrap("handleTrustStorageUpdate", $$robo$$android_security_net_config_KeyStoreCertificateSource$handleTrustStorageUpdate(), 0, this);
    }

    public /* synthetic */ KeyStoreCertificateSource() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KeyStoreCertificateSource)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

