/*
 * Decompiled with CFR 0.152.
 */
package android.security.net.config;

import android.security.net.config.CertificateSource;
import android.util.ArraySet;
import com.android.org.conscrypt.Hex;
import com.android.org.conscrypt.NativeCrypto;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import libcore.io.IoUtils;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class DirectoryCertificateSource
implements CertificateSource,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private File mDir;
    private Object mLock;
    private CertificateFactory mCertFactory;
    private Set<X509Certificate> mCertificates;

    private void $$robo$$android_security_net_config_DirectoryCertificateSource$__constructor__(File caDir) {
        this.mLock = new Object();
        this.mDir = caDir;
        try {
            this.mCertFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new RuntimeException("Failed to obtain X.509 CertificateFactory", e);
        }
    }

    protected abstract boolean isCertMarkedAsRemoved(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Set<X509Certificate> $$robo$$android_security_net_config_DirectoryCertificateSource$getCertificates() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCertificates != null) {
                return this.mCertificates;
            }
            ArraySet<X509Certificate> certs = new ArraySet<X509Certificate>();
            if (this.mDir.isDirectory()) {
                for (String caFile : this.mDir.list()) {
                    X509Certificate cert;
                    if (this.isCertMarkedAsRemoved(caFile) || (cert = this.readCertificate(caFile)) == null) continue;
                    certs.add(cert);
                }
            }
            this.mCertificates = certs;
            return this.mCertificates;
        }
    }

    private final X509Certificate $$robo$$android_security_net_config_DirectoryCertificateSource$findBySubjectAndPublicKey(X509Certificate cert) {
        return this.findCert(cert.getSubjectX500Principal(), new CertSelector(this, cert){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ X509Certificate val$cert;
            /* synthetic */ DirectoryCertificateSource this$0;

            private void $$robo$$android_security_net_config_DirectoryCertificateSource_1$__constructor__(DirectoryCertificateSource this$0, X509Certificate x509Certificate) {
            }

            private final boolean $$robo$$android_security_net_config_DirectoryCertificateSource_1$match(X509Certificate ca) {
                return ca.getPublicKey().equals(this.val$cert.getPublicKey());
            }

            private void __constructor__(DirectoryCertificateSource directoryCertificateSource, X509Certificate x509Certificate) {
                this.$$robo$$android_security_net_config_DirectoryCertificateSource_1$__constructor__(directoryCertificateSource, x509Certificate);
            }
            {
                this.this$0 = directoryCertificateSource;
                this.val$cert = x509Certificate;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_net_config_DirectoryCertificateSource_1$__constructor__(android.security.net.config.DirectoryCertificateSource java.security.cert.X509Certificate ), 0, this, directoryCertificateSource, x509Certificate);
            }

            @Override
            public boolean match(X509Certificate x509Certificate) {
                return (boolean)InvokeDynamicSupport.bootstrap("match", $$robo$$android_security_net_config_DirectoryCertificateSource_1$match(java.security.cert.X509Certificate ), 0, this, x509Certificate);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final X509Certificate $$robo$$android_security_net_config_DirectoryCertificateSource$findByIssuerAndSignature(X509Certificate cert) {
        return this.findCert(cert.getIssuerX500Principal(), new CertSelector(this, cert){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ X509Certificate val$cert;
            /* synthetic */ DirectoryCertificateSource this$0;

            private void $$robo$$android_security_net_config_DirectoryCertificateSource_2$__constructor__(DirectoryCertificateSource this$0, X509Certificate x509Certificate) {
            }

            private final boolean $$robo$$android_security_net_config_DirectoryCertificateSource_2$match(X509Certificate ca) {
                try {
                    this.val$cert.verify(ca.getPublicKey());
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }

            private void __constructor__(DirectoryCertificateSource directoryCertificateSource, X509Certificate x509Certificate) {
                this.$$robo$$android_security_net_config_DirectoryCertificateSource_2$__constructor__(directoryCertificateSource, x509Certificate);
            }
            {
                this.this$0 = directoryCertificateSource;
                this.val$cert = x509Certificate;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_net_config_DirectoryCertificateSource_2$__constructor__(android.security.net.config.DirectoryCertificateSource java.security.cert.X509Certificate ), 0, this, directoryCertificateSource, x509Certificate);
            }

            @Override
            public boolean match(X509Certificate x509Certificate) {
                return (boolean)InvokeDynamicSupport.bootstrap("match", $$robo$$android_security_net_config_DirectoryCertificateSource_2$match(java.security.cert.X509Certificate ), 0, this, x509Certificate);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final Set<X509Certificate> $$robo$$android_security_net_config_DirectoryCertificateSource$findAllByIssuerAndSignature(X509Certificate cert) {
        return this.findCerts(cert.getIssuerX500Principal(), new CertSelector(this, cert){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ X509Certificate val$cert;
            /* synthetic */ DirectoryCertificateSource this$0;

            private void $$robo$$android_security_net_config_DirectoryCertificateSource_3$__constructor__(DirectoryCertificateSource this$0, X509Certificate x509Certificate) {
            }

            private final boolean $$robo$$android_security_net_config_DirectoryCertificateSource_3$match(X509Certificate ca) {
                try {
                    this.val$cert.verify(ca.getPublicKey());
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }

            private void __constructor__(DirectoryCertificateSource directoryCertificateSource, X509Certificate x509Certificate) {
                this.$$robo$$android_security_net_config_DirectoryCertificateSource_3$__constructor__(directoryCertificateSource, x509Certificate);
            }
            {
                this.this$0 = directoryCertificateSource;
                this.val$cert = x509Certificate;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_net_config_DirectoryCertificateSource_3$__constructor__(android.security.net.config.DirectoryCertificateSource java.security.cert.X509Certificate ), 0, this, directoryCertificateSource, x509Certificate);
            }

            @Override
            public boolean match(X509Certificate x509Certificate) {
                return (boolean)InvokeDynamicSupport.bootstrap("match", $$robo$$android_security_net_config_DirectoryCertificateSource_3$match(java.security.cert.X509Certificate ), 0, this, x509Certificate);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_security_net_config_DirectoryCertificateSource$handleTrustStorageUpdate() {
        Object object = this.mLock;
        synchronized (object) {
            this.mCertificates = null;
        }
    }

    private final Set<X509Certificate> $$robo$$android_security_net_config_DirectoryCertificateSource$findCerts(X500Principal subj, CertSelector selector) {
        String fileName;
        String hash = this.getHash(subj);
        Set<X509Certificate> certs = null;
        for (int index = 0; index >= 0 && new File(this.mDir, fileName = hash + "." + index).exists(); ++index) {
            X509Certificate cert;
            if (this.isCertMarkedAsRemoved(fileName) || !subj.equals((cert = this.readCertificate(fileName)).getSubjectX500Principal()) || !selector.match(cert)) continue;
            if (certs == null) {
                certs = new ArraySet<X509Certificate>();
            }
            certs.add(cert);
        }
        return certs != null ? certs : Collections.emptySet();
    }

    private final X509Certificate $$robo$$android_security_net_config_DirectoryCertificateSource$findCert(X500Principal subj, CertSelector selector) {
        String fileName;
        String hash = this.getHash(subj);
        for (int index = 0; index >= 0 && new File(this.mDir, fileName = hash + "." + index).exists(); ++index) {
            X509Certificate cert;
            if (this.isCertMarkedAsRemoved(fileName) || !subj.equals((cert = this.readCertificate(fileName)).getSubjectX500Principal()) || !selector.match(cert)) continue;
            return cert;
        }
        return null;
    }

    private final String $$robo$$android_security_net_config_DirectoryCertificateSource$getHash(X500Principal name) {
        int hash = NativeCrypto.X509_NAME_hash_old(name);
        return Hex.intToHexString(hash, 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final X509Certificate $$robo$$android_security_net_config_DirectoryCertificateSource$readCertificate(String file) {
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(new File(this.mDir, file)));
            X509Certificate x509Certificate = (X509Certificate)this.mCertFactory.generateCertificate(is);
            IoUtils.closeQuietly(is);
            return x509Certificate;
        }
        catch (IOException | CertificateException e) {
            X509Certificate x509Certificate = null;
            return x509Certificate;
        }
        finally {
            IoUtils.closeQuietly(is);
        }
    }

    private void __constructor__(File file) {
        this.$$robo$$android_security_net_config_DirectoryCertificateSource$__constructor__(file);
    }

    protected DirectoryCertificateSource(File file) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_net_config_DirectoryCertificateSource$__constructor__(java.io.File ), 0, this, file);
    }

    @Override
    public Set<X509Certificate> getCertificates() {
        return InvokeDynamicSupport.bootstrap("getCertificates", $$robo$$android_security_net_config_DirectoryCertificateSource$getCertificates(), 0, this);
    }

    @Override
    public X509Certificate findBySubjectAndPublicKey(X509Certificate x509Certificate) {
        return InvokeDynamicSupport.bootstrap("findBySubjectAndPublicKey", $$robo$$android_security_net_config_DirectoryCertificateSource$findBySubjectAndPublicKey(java.security.cert.X509Certificate ), 0, this, x509Certificate);
    }

    @Override
    public X509Certificate findByIssuerAndSignature(X509Certificate x509Certificate) {
        return InvokeDynamicSupport.bootstrap("findByIssuerAndSignature", $$robo$$android_security_net_config_DirectoryCertificateSource$findByIssuerAndSignature(java.security.cert.X509Certificate ), 0, this, x509Certificate);
    }

    @Override
    public Set<X509Certificate> findAllByIssuerAndSignature(X509Certificate x509Certificate) {
        return InvokeDynamicSupport.bootstrap("findAllByIssuerAndSignature", $$robo$$android_security_net_config_DirectoryCertificateSource$findAllByIssuerAndSignature(java.security.cert.X509Certificate ), 0, this, x509Certificate);
    }

    @Override
    public void handleTrustStorageUpdate() {
        InvokeDynamicSupport.bootstrap("handleTrustStorageUpdate", $$robo$$android_security_net_config_DirectoryCertificateSource$handleTrustStorageUpdate(), 0, this);
    }

    private Set<X509Certificate> findCerts(X500Principal x500Principal, CertSelector certSelector) {
        return InvokeDynamicSupport.bootstrap("findCerts", $$robo$$android_security_net_config_DirectoryCertificateSource$findCerts(javax.security.auth.x500.X500Principal android.security.net.config.DirectoryCertificateSource$CertSelector ), 0, this, x500Principal, certSelector);
    }

    private X509Certificate findCert(X500Principal x500Principal, CertSelector certSelector) {
        return InvokeDynamicSupport.bootstrap("findCert", $$robo$$android_security_net_config_DirectoryCertificateSource$findCert(javax.security.auth.x500.X500Principal android.security.net.config.DirectoryCertificateSource$CertSelector ), 0, this, x500Principal, certSelector);
    }

    private String getHash(X500Principal x500Principal) {
        return InvokeDynamicSupport.bootstrap("getHash", $$robo$$android_security_net_config_DirectoryCertificateSource$getHash(javax.security.auth.x500.X500Principal ), 0, this, x500Principal);
    }

    private X509Certificate readCertificate(String string2) {
        return InvokeDynamicSupport.bootstrap("readCertificate", $$robo$$android_security_net_config_DirectoryCertificateSource$readCertificate(java.lang.String ), 0, this, string2);
    }

    public /* synthetic */ DirectoryCertificateSource() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DirectoryCertificateSource)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static interface CertSelector
    extends InstrumentedInterface {
        public boolean match(X509Certificate var1);
    }
}

