/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore;

import android.security.keymaster.KeymasterArguments;
import android.security.keystore.AndroidKeyStoreCipherSpiBase;
import android.security.keystore.AndroidKeyStoreSecretKey;
import android.security.keystore.ArrayUtils;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.crypto.spec.IvParameterSpec;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AndroidKeyStoreUnauthenticatedAESCipherSpi
extends AndroidKeyStoreCipherSpiBase
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int BLOCK_SIZE_BYTES = 16;
    private int mKeymasterBlockMode;
    private int mKeymasterPadding;
    private boolean mIvRequired;
    private byte[] mIv;
    private boolean mIvHasBeenUsed;

    private void $$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi$__constructor__(int keymasterBlockMode, int keymasterPadding, boolean ivRequired) {
        this.mKeymasterBlockMode = keymasterBlockMode;
        this.mKeymasterPadding = keymasterPadding;
        this.mIvRequired = ivRequired;
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi$resetAll() {
        this.mIv = null;
        this.mIvHasBeenUsed = false;
        super.resetAll();
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi$resetWhilePreservingInitState() {
        super.resetWhilePreservingInitState();
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi$initKey(int opmode, Key key) throws InvalidKeyException {
        if (!(key instanceof AndroidKeyStoreSecretKey)) {
            throw new InvalidKeyException("Unsupported key: " + (key != null ? key.getClass().getName() : "null"));
        }
        if (!"AES".equalsIgnoreCase(key.getAlgorithm())) {
            throw new InvalidKeyException("Unsupported key algorithm: " + key.getAlgorithm() + ". Only " + "AES" + " supported");
        }
        this.setKey((AndroidKeyStoreSecretKey)key);
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi$initAlgorithmSpecificParameters() throws InvalidKeyException {
        if (!this.mIvRequired) {
            return;
        }
        if (!this.isEncrypting()) {
            throw new InvalidKeyException("IV required when decrypting. Use IvParameterSpec or AlgorithmParameters to provide it.");
        }
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi$initAlgorithmSpecificParameters(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        if (!this.mIvRequired) {
            if (params != null) {
                throw new InvalidAlgorithmParameterException("Unsupported parameters: " + params);
            }
            return;
        }
        if (params == null) {
            if (!this.isEncrypting()) {
                throw new InvalidAlgorithmParameterException("IvParameterSpec must be provided when decrypting");
            }
            return;
        }
        if (!(params instanceof IvParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Only IvParameterSpec supported");
        }
        this.mIv = ((IvParameterSpec)params).getIV();
        if (this.mIv == null) {
            throw new InvalidAlgorithmParameterException("Null IV in IvParameterSpec");
        }
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi$initAlgorithmSpecificParameters(AlgorithmParameters params) throws InvalidAlgorithmParameterException {
        IvParameterSpec ivSpec;
        if (!this.mIvRequired) {
            if (params != null) {
                throw new InvalidAlgorithmParameterException("Unsupported parameters: " + params);
            }
            return;
        }
        if (params == null) {
            if (!this.isEncrypting()) {
                throw new InvalidAlgorithmParameterException("IV required when decrypting. Use IvParameterSpec or AlgorithmParameters to provide it.");
            }
            return;
        }
        if (!"AES".equalsIgnoreCase(params.getAlgorithm())) {
            throw new InvalidAlgorithmParameterException("Unsupported AlgorithmParameters algorithm: " + params.getAlgorithm() + ". Supported: AES");
        }
        try {
            ivSpec = params.getParameterSpec(IvParameterSpec.class);
        }
        catch (InvalidParameterSpecException e) {
            if (!this.isEncrypting()) {
                throw new InvalidAlgorithmParameterException("IV required when decrypting, but not found in parameters: " + params, e);
            }
            this.mIv = null;
            return;
        }
        this.mIv = ivSpec.getIV();
        if (this.mIv == null) {
            throw new InvalidAlgorithmParameterException("Null IV in AlgorithmParameters");
        }
    }

    private final int $$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi$getAdditionalEntropyAmountForBegin() {
        if (this.mIvRequired && this.mIv == null && this.isEncrypting()) {
            return 16;
        }
        return 0;
    }

    private final int $$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi$getAdditionalEntropyAmountForFinish() {
        return 0;
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi$addAlgorithmSpecificParametersToBegin(KeymasterArguments keymasterArgs) {
        if (this.isEncrypting() && this.mIvRequired && this.mIvHasBeenUsed) {
            throw new IllegalStateException("IV has already been used. Reusing IV in encryption mode violates security best practices.");
        }
        keymasterArgs.addEnum(0x10000002, 32);
        keymasterArgs.addEnum(0x20000004, this.mKeymasterBlockMode);
        keymasterArgs.addEnum(0x20000006, this.mKeymasterPadding);
        if (this.mIvRequired && this.mIv != null) {
            keymasterArgs.addBytes(-1879047191, this.mIv);
        }
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi$loadAlgorithmSpecificParametersFromBeginResult(KeymasterArguments keymasterArgs) {
        this.mIvHasBeenUsed = true;
        byte[] returnedIv = keymasterArgs.getBytes(-1879047191, null);
        if (returnedIv != null && returnedIv.length == 0) {
            returnedIv = null;
        }
        if (this.mIvRequired) {
            if (this.mIv == null) {
                this.mIv = returnedIv;
            } else if (returnedIv != null && !Arrays.equals(returnedIv, this.mIv)) {
                throw new ProviderException("IV in use differs from provided IV");
            }
        } else if (returnedIv != null) {
            throw new ProviderException("IV in use despite IV not being used by this transformation");
        }
    }

    private final int $$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi$engineGetBlockSize() {
        return 16;
    }

    private final int $$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi$engineGetOutputSize(int inputLen) {
        return inputLen + 48;
    }

    private final byte[] $$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi$engineGetIV() {
        return ArrayUtils.cloneIfNotEmpty(this.mIv);
    }

    private final AlgorithmParameters $$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi$engineGetParameters() {
        if (!this.mIvRequired) {
            return null;
        }
        if (this.mIv != null && this.mIv.length > 0) {
            try {
                AlgorithmParameters params = AlgorithmParameters.getInstance("AES");
                params.init(new IvParameterSpec(this.mIv));
                return params;
            }
            catch (NoSuchAlgorithmException e) {
                throw new ProviderException("Failed to obtain AES AlgorithmParameters", e);
            }
            catch (InvalidParameterSpecException e) {
                throw new ProviderException("Failed to initialize AES AlgorithmParameters with an IV", e);
            }
        }
        return null;
    }

    private void __constructor__(int n, int n2, boolean bl) {
        this.$$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi$__constructor__(n, n2, bl);
    }

    AndroidKeyStoreUnauthenticatedAESCipherSpi(int n, int n2, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi$__constructor__(int int boolean ), 0, this, n, n2, bl);
    }

    @Override
    protected void resetAll() {
        InvokeDynamicSupport.bootstrap("resetAll", $$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi$resetAll(), 0, this);
    }

    @Override
    protected void resetWhilePreservingInitState() {
        InvokeDynamicSupport.bootstrap("resetWhilePreservingInitState", $$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi$resetWhilePreservingInitState(), 0, this);
    }

    @Override
    protected void initKey(int n, Key key) throws InvalidKeyException {
        InvokeDynamicSupport.bootstrap("initKey", $$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi$initKey(int java.security.Key ), 0, this, n, key);
    }

    @Override
    protected void initAlgorithmSpecificParameters() throws InvalidKeyException {
        InvokeDynamicSupport.bootstrap("initAlgorithmSpecificParameters", $$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi$initAlgorithmSpecificParameters(), 0, this);
    }

    @Override
    protected void initAlgorithmSpecificParameters(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        InvokeDynamicSupport.bootstrap("initAlgorithmSpecificParameters", $$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi$initAlgorithmSpecificParameters(java.security.spec.AlgorithmParameterSpec ), 0, this, algorithmParameterSpec);
    }

    @Override
    protected void initAlgorithmSpecificParameters(AlgorithmParameters algorithmParameters) throws InvalidAlgorithmParameterException {
        InvokeDynamicSupport.bootstrap("initAlgorithmSpecificParameters", $$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi$initAlgorithmSpecificParameters(java.security.AlgorithmParameters ), 0, this, algorithmParameters);
    }

    @Override
    protected int getAdditionalEntropyAmountForBegin() {
        return (int)InvokeDynamicSupport.bootstrap("getAdditionalEntropyAmountForBegin", $$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi$getAdditionalEntropyAmountForBegin(), 0, this);
    }

    @Override
    protected int getAdditionalEntropyAmountForFinish() {
        return (int)InvokeDynamicSupport.bootstrap("getAdditionalEntropyAmountForFinish", $$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi$getAdditionalEntropyAmountForFinish(), 0, this);
    }

    @Override
    protected void addAlgorithmSpecificParametersToBegin(KeymasterArguments keymasterArguments) {
        InvokeDynamicSupport.bootstrap("addAlgorithmSpecificParametersToBegin", $$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi$addAlgorithmSpecificParametersToBegin(android.security.keymaster.KeymasterArguments ), 0, this, keymasterArguments);
    }

    @Override
    protected void loadAlgorithmSpecificParametersFromBeginResult(KeymasterArguments keymasterArguments) {
        InvokeDynamicSupport.bootstrap("loadAlgorithmSpecificParametersFromBeginResult", $$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi$loadAlgorithmSpecificParametersFromBeginResult(android.security.keymaster.KeymasterArguments ), 0, this, keymasterArguments);
    }

    @Override
    protected int engineGetBlockSize() {
        return (int)InvokeDynamicSupport.bootstrap("engineGetBlockSize", $$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi$engineGetBlockSize(), 0, this);
    }

    @Override
    protected int engineGetOutputSize(int n) {
        return (int)InvokeDynamicSupport.bootstrap("engineGetOutputSize", $$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi$engineGetOutputSize(int ), 0, this, n);
    }

    @Override
    protected byte[] engineGetIV() {
        return InvokeDynamicSupport.bootstrap("engineGetIV", $$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi$engineGetIV(), 0, this);
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return InvokeDynamicSupport.bootstrap("engineGetParameters", $$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi$engineGetParameters(), 0, this);
    }

    public /* synthetic */ AndroidKeyStoreUnauthenticatedAESCipherSpi() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AndroidKeyStoreUnauthenticatedAESCipherSpi)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static abstract class CTR
    extends AndroidKeyStoreUnauthenticatedAESCipherSpi
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi_CTR$__constructor__(int keymasterPadding) {
        }

        private void __constructor__(int n) {
            this.$$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi_CTR$__constructor__(n);
        }

        protected CTR(int n) {
            super(3, n, true);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi_CTR$__constructor__(int ), 0, this, n);
        }

        public /* synthetic */ CTR() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CTR)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        public static class NoPadding
        extends CTR
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi_CTR_NoPadding$__constructor__() {
            }

            private void __constructor__() {
                this.$$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi_CTR_NoPadding$__constructor__();
            }

            public NoPadding() {
                super(1);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi_CTR_NoPadding$__constructor__(), 0, this);
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NoPadding)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    public static abstract class CBC
    extends AndroidKeyStoreUnauthenticatedAESCipherSpi
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi_CBC$__constructor__(int keymasterPadding) {
        }

        private void __constructor__(int n) {
            this.$$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi_CBC$__constructor__(n);
        }

        protected CBC(int n) {
            super(2, n, true);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi_CBC$__constructor__(int ), 0, this, n);
        }

        public /* synthetic */ CBC() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CBC)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        public static class PKCS7Padding
        extends CBC
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi_CBC_PKCS7Padding$__constructor__() {
            }

            private void __constructor__() {
                this.$$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi_CBC_PKCS7Padding$__constructor__();
            }

            public PKCS7Padding() {
                super(64);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi_CBC_PKCS7Padding$__constructor__(), 0, this);
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PKCS7Padding)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        public static class NoPadding
        extends CBC
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi_CBC_NoPadding$__constructor__() {
            }

            private void __constructor__() {
                this.$$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi_CBC_NoPadding$__constructor__();
            }

            public NoPadding() {
                super(1);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi_CBC_NoPadding$__constructor__(), 0, this);
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NoPadding)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    public static abstract class ECB
    extends AndroidKeyStoreUnauthenticatedAESCipherSpi
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi_ECB$__constructor__(int keymasterPadding) {
        }

        private void __constructor__(int n) {
            this.$$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi_ECB$__constructor__(n);
        }

        protected ECB(int n) {
            super(1, n, false);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi_ECB$__constructor__(int ), 0, this, n);
        }

        public /* synthetic */ ECB() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ECB)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        public static class PKCS7Padding
        extends ECB
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi_ECB_PKCS7Padding$__constructor__() {
            }

            private void __constructor__() {
                this.$$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi_ECB_PKCS7Padding$__constructor__();
            }

            public PKCS7Padding() {
                super(64);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi_ECB_PKCS7Padding$__constructor__(), 0, this);
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PKCS7Padding)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        public static class NoPadding
        extends ECB
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi_ECB_NoPadding$__constructor__() {
            }

            private void __constructor__() {
                this.$$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi_ECB_NoPadding$__constructor__();
            }

            public NoPadding() {
                super(1);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStoreUnauthenticatedAESCipherSpi_ECB_NoPadding$__constructor__(), 0, this);
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NoPadding)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }
}

