/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore;

import android.security.keymaster.KeyCharacteristics;
import android.security.keymaster.KeymasterArguments;
import android.security.keystore.AndroidKeyStoreCipherSpiBase;
import android.security.keystore.AndroidKeyStoreKey;
import android.security.keystore.AndroidKeyStorePrivateKey;
import android.security.keystore.AndroidKeyStorePublicKey;
import android.security.keystore.KeyProperties;
import android.security.keystore.KeymasterUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.MGF1ParameterSpec;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class AndroidKeyStoreRSACipherSpi
extends AndroidKeyStoreCipherSpiBase
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private int mKeymasterPadding;
    private int mKeymasterPaddingOverride;
    private int mModulusSizeBytes;

    private void $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi$__constructor__(int keymasterPadding) {
        this.mModulusSizeBytes = -1;
        this.mKeymasterPadding = keymasterPadding;
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi$initKey(int opmode, Key key) throws InvalidKeyException {
        AndroidKeyStoreKey keystoreKey;
        block19: {
            block18: {
                if (key == null) {
                    throw new InvalidKeyException("Unsupported key: null");
                }
                if (!"RSA".equalsIgnoreCase(key.getAlgorithm())) {
                    throw new InvalidKeyException("Unsupported key algorithm: " + key.getAlgorithm() + ". Only " + "RSA" + " supported");
                }
                if (key instanceof AndroidKeyStorePrivateKey) {
                    keystoreKey = (AndroidKeyStoreKey)key;
                } else if (key instanceof AndroidKeyStorePublicKey) {
                    keystoreKey = (AndroidKeyStoreKey)key;
                } else {
                    throw new InvalidKeyException("Unsupported key type: " + key);
                }
                if (!(keystoreKey instanceof PrivateKey)) break block18;
                switch (opmode) {
                    case 2: 
                    case 4: {
                        break block19;
                    }
                    case 1: 
                    case 3: {
                        if (!this.adjustConfigForEncryptingWithPrivateKey()) {
                            throw new InvalidKeyException("RSA private keys cannot be used with " + AndroidKeyStoreRSACipherSpi.opmodeToString(opmode) + " and padding " + KeyProperties.EncryptionPadding.fromKeymaster(this.mKeymasterPadding) + ". Only RSA public keys supported for this mode");
                        }
                        break block19;
                    }
                    default: {
                        throw new InvalidKeyException("RSA private keys cannot be used with opmode: " + opmode);
                    }
                }
            }
            switch (opmode) {
                case 1: 
                case 3: {
                    break;
                }
                case 2: 
                case 4: {
                    throw new InvalidKeyException("RSA public keys cannot be used with " + AndroidKeyStoreRSACipherSpi.opmodeToString(opmode) + " and padding " + KeyProperties.EncryptionPadding.fromKeymaster(this.mKeymasterPadding) + ". Only RSA private keys supported for this opmode.");
                }
                default: {
                    throw new InvalidKeyException("RSA public keys cannot be used with " + AndroidKeyStoreRSACipherSpi.opmodeToString(opmode));
                }
            }
        }
        KeyCharacteristics keyCharacteristics = new KeyCharacteristics();
        int errorCode = this.getKeyStore().getKeyCharacteristics(keystoreKey.getAlias(), null, null, keystoreKey.getUid(), keyCharacteristics);
        if (errorCode != 1) {
            throw this.getKeyStore().getInvalidKeyException(keystoreKey.getAlias(), keystoreKey.getUid(), errorCode);
        }
        long keySizeBits = keyCharacteristics.getUnsignedInt(0x30000003, -1L);
        if (keySizeBits == -1L) {
            throw new InvalidKeyException("Size of key not known");
        }
        if (keySizeBits > Integer.MAX_VALUE) {
            throw new InvalidKeyException("Key too large: " + keySizeBits + " bits");
        }
        this.mModulusSizeBytes = (int)((keySizeBits + 7L) / 8L);
        this.setKey(keystoreKey);
    }

    private final boolean $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi$adjustConfigForEncryptingWithPrivateKey() {
        return false;
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi$resetAll() {
        this.mModulusSizeBytes = -1;
        this.mKeymasterPaddingOverride = -1;
        super.resetAll();
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi$resetWhilePreservingInitState() {
        super.resetWhilePreservingInitState();
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi$addAlgorithmSpecificParametersToBegin(KeymasterArguments keymasterArgs) {
        keymasterArgs.addEnum(0x10000002, 1);
        int keymasterPadding = this.getKeymasterPaddingOverride();
        if (keymasterPadding == -1) {
            keymasterPadding = this.mKeymasterPadding;
        }
        keymasterArgs.addEnum(0x20000006, keymasterPadding);
        int purposeOverride = this.getKeymasterPurposeOverride();
        if (purposeOverride != -1 && (purposeOverride == 2 || purposeOverride == 3)) {
            keymasterArgs.addEnum(0x20000005, 0);
        }
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi$loadAlgorithmSpecificParametersFromBeginResult(KeymasterArguments keymasterArgs) {
    }

    private final int $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi$engineGetBlockSize() {
        return 0;
    }

    private final byte[] $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi$engineGetIV() {
        return null;
    }

    private final int $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi$engineGetOutputSize(int inputLen) {
        return this.getModulusSizeBytes();
    }

    private final int $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi$getModulusSizeBytes() {
        if (this.mModulusSizeBytes == -1) {
            throw new IllegalStateException("Not initialized");
        }
        return this.mModulusSizeBytes;
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi$setKeymasterPaddingOverride(int keymasterPadding) {
        this.mKeymasterPaddingOverride = keymasterPadding;
    }

    private final int $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi$getKeymasterPaddingOverride() {
        return this.mKeymasterPaddingOverride;
    }

    private void __constructor__(int n) {
        this.$$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi$__constructor__(n);
    }

    AndroidKeyStoreRSACipherSpi(int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi$__constructor__(int ), 0, this, n);
    }

    @Override
    protected void initKey(int n, Key key) throws InvalidKeyException {
        InvokeDynamicSupport.bootstrap("initKey", $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi$initKey(int java.security.Key ), 0, this, n, key);
    }

    protected boolean adjustConfigForEncryptingWithPrivateKey() {
        return (boolean)InvokeDynamicSupport.bootstrap("adjustConfigForEncryptingWithPrivateKey", $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi$adjustConfigForEncryptingWithPrivateKey(), 0, this);
    }

    @Override
    protected void resetAll() {
        InvokeDynamicSupport.bootstrap("resetAll", $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi$resetAll(), 0, this);
    }

    @Override
    protected void resetWhilePreservingInitState() {
        InvokeDynamicSupport.bootstrap("resetWhilePreservingInitState", $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi$resetWhilePreservingInitState(), 0, this);
    }

    @Override
    protected void addAlgorithmSpecificParametersToBegin(KeymasterArguments keymasterArguments) {
        InvokeDynamicSupport.bootstrap("addAlgorithmSpecificParametersToBegin", $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi$addAlgorithmSpecificParametersToBegin(android.security.keymaster.KeymasterArguments ), 0, this, keymasterArguments);
    }

    @Override
    protected void loadAlgorithmSpecificParametersFromBeginResult(KeymasterArguments keymasterArguments) {
        InvokeDynamicSupport.bootstrap("loadAlgorithmSpecificParametersFromBeginResult", $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi$loadAlgorithmSpecificParametersFromBeginResult(android.security.keymaster.KeymasterArguments ), 0, this, keymasterArguments);
    }

    @Override
    protected int engineGetBlockSize() {
        return (int)InvokeDynamicSupport.bootstrap("engineGetBlockSize", $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi$engineGetBlockSize(), 0, this);
    }

    @Override
    protected byte[] engineGetIV() {
        return InvokeDynamicSupport.bootstrap("engineGetIV", $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi$engineGetIV(), 0, this);
    }

    @Override
    protected int engineGetOutputSize(int n) {
        return (int)InvokeDynamicSupport.bootstrap("engineGetOutputSize", $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi$engineGetOutputSize(int ), 0, this, n);
    }

    protected int getModulusSizeBytes() {
        return (int)InvokeDynamicSupport.bootstrap("getModulusSizeBytes", $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi$getModulusSizeBytes(), 0, this);
    }

    protected void setKeymasterPaddingOverride(int n) {
        InvokeDynamicSupport.bootstrap("setKeymasterPaddingOverride", $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi$setKeymasterPaddingOverride(int ), 0, this, n);
    }

    protected int getKeymasterPaddingOverride() {
        return (int)InvokeDynamicSupport.bootstrap("getKeymasterPaddingOverride", $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi$getKeymasterPaddingOverride(), 0, this);
    }

    public /* synthetic */ AndroidKeyStoreRSACipherSpi() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AndroidKeyStoreRSACipherSpi)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class OAEPWithSHA512AndMGF1Padding
    extends OAEPWithMGF1Padding
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_OAEPWithSHA512AndMGF1Padding$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_OAEPWithSHA512AndMGF1Padding$__constructor__();
        }

        public OAEPWithSHA512AndMGF1Padding() {
            super(6);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_OAEPWithSHA512AndMGF1Padding$__constructor__(), 0, this);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OAEPWithSHA512AndMGF1Padding)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class OAEPWithSHA384AndMGF1Padding
    extends OAEPWithMGF1Padding
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_OAEPWithSHA384AndMGF1Padding$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_OAEPWithSHA384AndMGF1Padding$__constructor__();
        }

        public OAEPWithSHA384AndMGF1Padding() {
            super(5);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_OAEPWithSHA384AndMGF1Padding$__constructor__(), 0, this);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OAEPWithSHA384AndMGF1Padding)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class OAEPWithSHA256AndMGF1Padding
    extends OAEPWithMGF1Padding
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_OAEPWithSHA256AndMGF1Padding$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_OAEPWithSHA256AndMGF1Padding$__constructor__();
        }

        public OAEPWithSHA256AndMGF1Padding() {
            super(4);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_OAEPWithSHA256AndMGF1Padding$__constructor__(), 0, this);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OAEPWithSHA256AndMGF1Padding)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class OAEPWithSHA224AndMGF1Padding
    extends OAEPWithMGF1Padding
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_OAEPWithSHA224AndMGF1Padding$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_OAEPWithSHA224AndMGF1Padding$__constructor__();
        }

        public OAEPWithSHA224AndMGF1Padding() {
            super(3);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_OAEPWithSHA224AndMGF1Padding$__constructor__(), 0, this);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OAEPWithSHA224AndMGF1Padding)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class OAEPWithSHA1AndMGF1Padding
    extends OAEPWithMGF1Padding
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_OAEPWithSHA1AndMGF1Padding$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_OAEPWithSHA1AndMGF1Padding$__constructor__();
        }

        public OAEPWithSHA1AndMGF1Padding() {
            super(2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_OAEPWithSHA1AndMGF1Padding$__constructor__(), 0, this);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OAEPWithSHA1AndMGF1Padding)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class OAEPWithMGF1Padding
    extends AndroidKeyStoreRSACipherSpi
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static String MGF_ALGORITGM_MGF1 = "MGF1";
        private int mKeymasterDigest;
        private int mDigestOutputSizeBytes;

        private void $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_OAEPWithMGF1Padding$__constructor__(int keymasterDigest) {
            this.mKeymasterDigest = -1;
            this.mKeymasterDigest = keymasterDigest;
            this.mDigestOutputSizeBytes = (KeymasterUtils.getDigestOutputSizeBits(keymasterDigest) + 7) / 8;
        }

        private final void $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_OAEPWithMGF1Padding$initAlgorithmSpecificParameters() throws InvalidKeyException {
        }

        private final void $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_OAEPWithMGF1Padding$initAlgorithmSpecificParameters(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
            int keymasterDigest;
            if (params == null) {
                return;
            }
            if (!(params instanceof OAEPParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Unsupported parameter spec: " + params + ". Only OAEPParameterSpec supported");
            }
            OAEPParameterSpec spec = (OAEPParameterSpec)params;
            if (!"MGF1".equalsIgnoreCase(spec.getMGFAlgorithm())) {
                throw new InvalidAlgorithmParameterException("Unsupported MGF: " + spec.getMGFAlgorithm() + ". Only " + "MGF1" + " supported");
            }
            String jcaDigest = spec.getDigestAlgorithm();
            try {
                keymasterDigest = KeyProperties.Digest.toKeymaster(jcaDigest);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidAlgorithmParameterException("Unsupported digest: " + jcaDigest, e);
            }
            switch (keymasterDigest) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
                default: {
                    throw new InvalidAlgorithmParameterException("Unsupported digest: " + jcaDigest);
                }
            }
            AlgorithmParameterSpec mgfParams = spec.getMGFParameters();
            if (mgfParams == null) {
                throw new InvalidAlgorithmParameterException("MGF parameters must be provided");
            }
            if (!(mgfParams instanceof MGF1ParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Unsupported MGF parameters: " + mgfParams + ". Only MGF1ParameterSpec supported");
            }
            MGF1ParameterSpec mgfSpec = (MGF1ParameterSpec)mgfParams;
            String mgf1JcaDigest = mgfSpec.getDigestAlgorithm();
            if (!"SHA-1".equalsIgnoreCase(mgf1JcaDigest)) {
                throw new InvalidAlgorithmParameterException("Unsupported MGF1 digest: " + mgf1JcaDigest + ". Only " + "SHA-1" + " supported");
            }
            PSource pSource = spec.getPSource();
            if (!(pSource instanceof PSource.PSpecified)) {
                throw new InvalidAlgorithmParameterException("Unsupported source of encoding input P: " + pSource + ". Only pSpecifiedEmpty (PSource.PSpecified.DEFAULT) supported");
            }
            PSource.PSpecified pSourceSpecified = (PSource.PSpecified)pSource;
            byte[] pSourceValue = pSourceSpecified.getValue();
            if (pSourceValue != null && pSourceValue.length > 0) {
                throw new InvalidAlgorithmParameterException("Unsupported source of encoding input P: " + pSource + ". Only pSpecifiedEmpty (PSource.PSpecified.DEFAULT) supported");
            }
            this.mKeymasterDigest = keymasterDigest;
            this.mDigestOutputSizeBytes = (KeymasterUtils.getDigestOutputSizeBits(keymasterDigest) + 7) / 8;
        }

        private final void $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_OAEPWithMGF1Padding$initAlgorithmSpecificParameters(AlgorithmParameters params) throws InvalidAlgorithmParameterException {
            OAEPParameterSpec spec;
            if (params == null) {
                return;
            }
            try {
                spec = params.getParameterSpec(OAEPParameterSpec.class);
            }
            catch (InvalidParameterSpecException e) {
                throw new InvalidAlgorithmParameterException("OAEP parameters required, but not found in parameters: " + params, e);
            }
            if (spec == null) {
                throw new InvalidAlgorithmParameterException("OAEP parameters required, but not provided in parameters: " + params);
            }
            this.initAlgorithmSpecificParameters(spec);
        }

        private final AlgorithmParameters $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_OAEPWithMGF1Padding$engineGetParameters() {
            OAEPParameterSpec spec = new OAEPParameterSpec(KeyProperties.Digest.fromKeymaster(this.mKeymasterDigest), "MGF1", MGF1ParameterSpec.SHA1, PSource.PSpecified.DEFAULT);
            try {
                AlgorithmParameters params = AlgorithmParameters.getInstance("OAEP");
                params.init(spec);
                return params;
            }
            catch (NoSuchAlgorithmException e) {
                throw new ProviderException("Failed to obtain OAEP AlgorithmParameters", e);
            }
            catch (InvalidParameterSpecException e) {
                throw new ProviderException("Failed to initialize OAEP AlgorithmParameters with an IV", e);
            }
        }

        private final void $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_OAEPWithMGF1Padding$addAlgorithmSpecificParametersToBegin(KeymasterArguments keymasterArgs) {
            super.addAlgorithmSpecificParametersToBegin(keymasterArgs);
            keymasterArgs.addEnum(0x20000005, this.mKeymasterDigest);
        }

        private final void $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_OAEPWithMGF1Padding$loadAlgorithmSpecificParametersFromBeginResult(KeymasterArguments keymasterArgs) {
            super.loadAlgorithmSpecificParametersFromBeginResult(keymasterArgs);
        }

        private final int $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_OAEPWithMGF1Padding$getAdditionalEntropyAmountForBegin() {
            return 0;
        }

        private final int $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_OAEPWithMGF1Padding$getAdditionalEntropyAmountForFinish() {
            return this.isEncrypting() ? this.mDigestOutputSizeBytes : 0;
        }

        @Override
        private void __constructor__(int n) {
            this.$$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_OAEPWithMGF1Padding$__constructor__(n);
        }

        OAEPWithMGF1Padding(int n) {
            super(2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_OAEPWithMGF1Padding$__constructor__(int ), 0, this, n);
        }

        @Override
        protected void initAlgorithmSpecificParameters() throws InvalidKeyException {
            InvokeDynamicSupport.bootstrap("initAlgorithmSpecificParameters", $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_OAEPWithMGF1Padding$initAlgorithmSpecificParameters(), 0, this);
        }

        @Override
        protected void initAlgorithmSpecificParameters(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
            InvokeDynamicSupport.bootstrap("initAlgorithmSpecificParameters", $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_OAEPWithMGF1Padding$initAlgorithmSpecificParameters(java.security.spec.AlgorithmParameterSpec ), 0, this, algorithmParameterSpec);
        }

        @Override
        protected void initAlgorithmSpecificParameters(AlgorithmParameters algorithmParameters) throws InvalidAlgorithmParameterException {
            InvokeDynamicSupport.bootstrap("initAlgorithmSpecificParameters", $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_OAEPWithMGF1Padding$initAlgorithmSpecificParameters(java.security.AlgorithmParameters ), 0, this, algorithmParameters);
        }

        @Override
        protected AlgorithmParameters engineGetParameters() {
            return InvokeDynamicSupport.bootstrap("engineGetParameters", $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_OAEPWithMGF1Padding$engineGetParameters(), 0, this);
        }

        @Override
        protected void addAlgorithmSpecificParametersToBegin(KeymasterArguments keymasterArguments) {
            InvokeDynamicSupport.bootstrap("addAlgorithmSpecificParametersToBegin", $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_OAEPWithMGF1Padding$addAlgorithmSpecificParametersToBegin(android.security.keymaster.KeymasterArguments ), 0, this, keymasterArguments);
        }

        @Override
        protected void loadAlgorithmSpecificParametersFromBeginResult(KeymasterArguments keymasterArguments) {
            InvokeDynamicSupport.bootstrap("loadAlgorithmSpecificParametersFromBeginResult", $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_OAEPWithMGF1Padding$loadAlgorithmSpecificParametersFromBeginResult(android.security.keymaster.KeymasterArguments ), 0, this, keymasterArguments);
        }

        @Override
        protected int getAdditionalEntropyAmountForBegin() {
            return (int)InvokeDynamicSupport.bootstrap("getAdditionalEntropyAmountForBegin", $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_OAEPWithMGF1Padding$getAdditionalEntropyAmountForBegin(), 0, this);
        }

        @Override
        protected int getAdditionalEntropyAmountForFinish() {
            return (int)InvokeDynamicSupport.bootstrap("getAdditionalEntropyAmountForFinish", $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_OAEPWithMGF1Padding$getAdditionalEntropyAmountForFinish(), 0, this);
        }

        public /* synthetic */ OAEPWithMGF1Padding() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OAEPWithMGF1Padding)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class PKCS1Padding
    extends AndroidKeyStoreRSACipherSpi
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_PKCS1Padding$__constructor__() {
        }

        private final boolean $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_PKCS1Padding$adjustConfigForEncryptingWithPrivateKey() {
            this.setKeymasterPurposeOverride(2);
            this.setKeymasterPaddingOverride(5);
            return true;
        }

        private final void $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_PKCS1Padding$initAlgorithmSpecificParameters() throws InvalidKeyException {
        }

        private final void $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_PKCS1Padding$initAlgorithmSpecificParameters(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
            if (params != null) {
                throw new InvalidAlgorithmParameterException("Unexpected parameters: " + params + ". No parameters supported");
            }
        }

        private final void $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_PKCS1Padding$initAlgorithmSpecificParameters(AlgorithmParameters params) throws InvalidAlgorithmParameterException {
            if (params != null) {
                throw new InvalidAlgorithmParameterException("Unexpected parameters: " + params + ". No parameters supported");
            }
        }

        private final AlgorithmParameters $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_PKCS1Padding$engineGetParameters() {
            return null;
        }

        private final int $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_PKCS1Padding$getAdditionalEntropyAmountForBegin() {
            return 0;
        }

        private final int $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_PKCS1Padding$getAdditionalEntropyAmountForFinish() {
            return this.isEncrypting() ? this.getModulusSizeBytes() : 0;
        }

        private void __constructor__() {
            this.$$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_PKCS1Padding$__constructor__();
        }

        public PKCS1Padding() {
            super(4);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_PKCS1Padding$__constructor__(), 0, this);
        }

        @Override
        protected boolean adjustConfigForEncryptingWithPrivateKey() {
            return (boolean)InvokeDynamicSupport.bootstrap("adjustConfigForEncryptingWithPrivateKey", $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_PKCS1Padding$adjustConfigForEncryptingWithPrivateKey(), 0, this);
        }

        @Override
        protected void initAlgorithmSpecificParameters() throws InvalidKeyException {
            InvokeDynamicSupport.bootstrap("initAlgorithmSpecificParameters", $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_PKCS1Padding$initAlgorithmSpecificParameters(), 0, this);
        }

        @Override
        protected void initAlgorithmSpecificParameters(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
            InvokeDynamicSupport.bootstrap("initAlgorithmSpecificParameters", $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_PKCS1Padding$initAlgorithmSpecificParameters(java.security.spec.AlgorithmParameterSpec ), 0, this, algorithmParameterSpec);
        }

        @Override
        protected void initAlgorithmSpecificParameters(AlgorithmParameters algorithmParameters) throws InvalidAlgorithmParameterException {
            InvokeDynamicSupport.bootstrap("initAlgorithmSpecificParameters", $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_PKCS1Padding$initAlgorithmSpecificParameters(java.security.AlgorithmParameters ), 0, this, algorithmParameters);
        }

        @Override
        protected AlgorithmParameters engineGetParameters() {
            return InvokeDynamicSupport.bootstrap("engineGetParameters", $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_PKCS1Padding$engineGetParameters(), 0, this);
        }

        @Override
        protected int getAdditionalEntropyAmountForBegin() {
            return (int)InvokeDynamicSupport.bootstrap("getAdditionalEntropyAmountForBegin", $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_PKCS1Padding$getAdditionalEntropyAmountForBegin(), 0, this);
        }

        @Override
        protected int getAdditionalEntropyAmountForFinish() {
            return (int)InvokeDynamicSupport.bootstrap("getAdditionalEntropyAmountForFinish", $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_PKCS1Padding$getAdditionalEntropyAmountForFinish(), 0, this);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PKCS1Padding)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class NoPadding
    extends AndroidKeyStoreRSACipherSpi
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_NoPadding$__constructor__() {
        }

        private final boolean $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_NoPadding$adjustConfigForEncryptingWithPrivateKey() {
            this.setKeymasterPurposeOverride(2);
            return true;
        }

        private final void $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_NoPadding$initAlgorithmSpecificParameters() throws InvalidKeyException {
        }

        private final void $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_NoPadding$initAlgorithmSpecificParameters(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
            if (params != null) {
                throw new InvalidAlgorithmParameterException("Unexpected parameters: " + params + ". No parameters supported");
            }
        }

        private final void $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_NoPadding$initAlgorithmSpecificParameters(AlgorithmParameters params) throws InvalidAlgorithmParameterException {
            if (params != null) {
                throw new InvalidAlgorithmParameterException("Unexpected parameters: " + params + ". No parameters supported");
            }
        }

        private final AlgorithmParameters $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_NoPadding$engineGetParameters() {
            return null;
        }

        private final int $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_NoPadding$getAdditionalEntropyAmountForBegin() {
            return 0;
        }

        private final int $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_NoPadding$getAdditionalEntropyAmountForFinish() {
            return 0;
        }

        private void __constructor__() {
            this.$$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_NoPadding$__constructor__();
        }

        public NoPadding() {
            super(1);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_NoPadding$__constructor__(), 0, this);
        }

        @Override
        protected boolean adjustConfigForEncryptingWithPrivateKey() {
            return (boolean)InvokeDynamicSupport.bootstrap("adjustConfigForEncryptingWithPrivateKey", $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_NoPadding$adjustConfigForEncryptingWithPrivateKey(), 0, this);
        }

        @Override
        protected void initAlgorithmSpecificParameters() throws InvalidKeyException {
            InvokeDynamicSupport.bootstrap("initAlgorithmSpecificParameters", $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_NoPadding$initAlgorithmSpecificParameters(), 0, this);
        }

        @Override
        protected void initAlgorithmSpecificParameters(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
            InvokeDynamicSupport.bootstrap("initAlgorithmSpecificParameters", $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_NoPadding$initAlgorithmSpecificParameters(java.security.spec.AlgorithmParameterSpec ), 0, this, algorithmParameterSpec);
        }

        @Override
        protected void initAlgorithmSpecificParameters(AlgorithmParameters algorithmParameters) throws InvalidAlgorithmParameterException {
            InvokeDynamicSupport.bootstrap("initAlgorithmSpecificParameters", $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_NoPadding$initAlgorithmSpecificParameters(java.security.AlgorithmParameters ), 0, this, algorithmParameters);
        }

        @Override
        protected AlgorithmParameters engineGetParameters() {
            return InvokeDynamicSupport.bootstrap("engineGetParameters", $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_NoPadding$engineGetParameters(), 0, this);
        }

        @Override
        protected int getAdditionalEntropyAmountForBegin() {
            return (int)InvokeDynamicSupport.bootstrap("getAdditionalEntropyAmountForBegin", $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_NoPadding$getAdditionalEntropyAmountForBegin(), 0, this);
        }

        @Override
        protected int getAdditionalEntropyAmountForFinish() {
            return (int)InvokeDynamicSupport.bootstrap("getAdditionalEntropyAmountForFinish", $$robo$$android_security_keystore_AndroidKeyStoreRSACipherSpi_NoPadding$getAdditionalEntropyAmountForFinish(), 0, this);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NoPadding)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

