/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore;

import android.os.IBinder;
import android.security.KeyStore;
import android.security.KeyStoreException;
import android.security.keymaster.KeyCharacteristics;
import android.security.keymaster.KeymasterArguments;
import android.security.keystore.AndroidKeyStoreKey;
import android.security.keystore.AndroidKeyStoreSignatureSpiBase;
import android.security.keystore.KeyStoreCryptoOperationStreamer;
import com.google.errorprone.annotations.DoNotMock;
import java.io.ByteArrayOutputStream;
import java.security.InvalidKeyException;
import libcore.util.EmptyArray;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class AndroidKeyStoreECDSASignatureSpi
extends AndroidKeyStoreSignatureSpiBase
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private int mKeymasterDigest;
    private int mGroupSizeBits;

    private void $$robo$$android_security_keystore_AndroidKeyStoreECDSASignatureSpi$__constructor__(int keymasterDigest) {
        this.mGroupSizeBits = -1;
        this.mKeymasterDigest = keymasterDigest;
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreECDSASignatureSpi$initKey(AndroidKeyStoreKey key) throws InvalidKeyException {
        if (!"EC".equalsIgnoreCase(key.getAlgorithm())) {
            throw new InvalidKeyException("Unsupported key algorithm: " + key.getAlgorithm() + ". Only" + "EC" + " supported");
        }
        KeyCharacteristics keyCharacteristics = new KeyCharacteristics();
        int errorCode = this.getKeyStore().getKeyCharacteristics(key.getAlias(), null, null, key.getUid(), keyCharacteristics);
        if (errorCode != 1) {
            throw this.getKeyStore().getInvalidKeyException(key.getAlias(), key.getUid(), errorCode);
        }
        long keySizeBits = keyCharacteristics.getUnsignedInt(0x30000003, -1L);
        if (keySizeBits == -1L) {
            throw new InvalidKeyException("Size of key not known");
        }
        if (keySizeBits > Integer.MAX_VALUE) {
            throw new InvalidKeyException("Key too large: " + keySizeBits + " bits");
        }
        this.mGroupSizeBits = (int)keySizeBits;
        super.initKey(key);
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreECDSASignatureSpi$resetAll() {
        this.mGroupSizeBits = -1;
        super.resetAll();
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreECDSASignatureSpi$resetWhilePreservingInitState() {
        super.resetWhilePreservingInitState();
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreECDSASignatureSpi$addAlgorithmSpecificParametersToBegin(KeymasterArguments keymasterArgs) {
        keymasterArgs.addEnum(0x10000002, 3);
        keymasterArgs.addEnum(0x20000005, this.mKeymasterDigest);
    }

    private final int $$robo$$android_security_keystore_AndroidKeyStoreECDSASignatureSpi$getAdditionalEntropyAmountForSign() {
        return (this.mGroupSizeBits + 7) / 8;
    }

    private final int $$robo$$android_security_keystore_AndroidKeyStoreECDSASignatureSpi$getGroupSizeBits() {
        if (this.mGroupSizeBits == -1) {
            throw new IllegalStateException("Not initialized");
        }
        return this.mGroupSizeBits;
    }

    private void __constructor__(int n) {
        this.$$robo$$android_security_keystore_AndroidKeyStoreECDSASignatureSpi$__constructor__(n);
    }

    AndroidKeyStoreECDSASignatureSpi(int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStoreECDSASignatureSpi$__constructor__(int ), 0, this, n);
    }

    @Override
    protected void initKey(AndroidKeyStoreKey androidKeyStoreKey) throws InvalidKeyException {
        InvokeDynamicSupport.bootstrap("initKey", $$robo$$android_security_keystore_AndroidKeyStoreECDSASignatureSpi$initKey(android.security.keystore.AndroidKeyStoreKey ), 0, this, androidKeyStoreKey);
    }

    @Override
    protected void resetAll() {
        InvokeDynamicSupport.bootstrap("resetAll", $$robo$$android_security_keystore_AndroidKeyStoreECDSASignatureSpi$resetAll(), 0, this);
    }

    @Override
    protected void resetWhilePreservingInitState() {
        InvokeDynamicSupport.bootstrap("resetWhilePreservingInitState", $$robo$$android_security_keystore_AndroidKeyStoreECDSASignatureSpi$resetWhilePreservingInitState(), 0, this);
    }

    @Override
    protected void addAlgorithmSpecificParametersToBegin(KeymasterArguments keymasterArguments) {
        InvokeDynamicSupport.bootstrap("addAlgorithmSpecificParametersToBegin", $$robo$$android_security_keystore_AndroidKeyStoreECDSASignatureSpi$addAlgorithmSpecificParametersToBegin(android.security.keymaster.KeymasterArguments ), 0, this, keymasterArguments);
    }

    @Override
    protected int getAdditionalEntropyAmountForSign() {
        return (int)InvokeDynamicSupport.bootstrap("getAdditionalEntropyAmountForSign", $$robo$$android_security_keystore_AndroidKeyStoreECDSASignatureSpi$getAdditionalEntropyAmountForSign(), 0, this);
    }

    protected int getGroupSizeBits() {
        return (int)InvokeDynamicSupport.bootstrap("getGroupSizeBits", $$robo$$android_security_keystore_AndroidKeyStoreECDSASignatureSpi$getGroupSizeBits(), 0, this);
    }

    public /* synthetic */ AndroidKeyStoreECDSASignatureSpi() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AndroidKeyStoreECDSASignatureSpi)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class SHA512
    extends AndroidKeyStoreECDSASignatureSpi
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_security_keystore_AndroidKeyStoreECDSASignatureSpi_SHA512$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_security_keystore_AndroidKeyStoreECDSASignatureSpi_SHA512$__constructor__();
        }

        public SHA512() {
            super(6);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStoreECDSASignatureSpi_SHA512$__constructor__(), 0, this);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SHA512)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class SHA384
    extends AndroidKeyStoreECDSASignatureSpi
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_security_keystore_AndroidKeyStoreECDSASignatureSpi_SHA384$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_security_keystore_AndroidKeyStoreECDSASignatureSpi_SHA384$__constructor__();
        }

        public SHA384() {
            super(5);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStoreECDSASignatureSpi_SHA384$__constructor__(), 0, this);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SHA384)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class SHA256
    extends AndroidKeyStoreECDSASignatureSpi
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_security_keystore_AndroidKeyStoreECDSASignatureSpi_SHA256$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_security_keystore_AndroidKeyStoreECDSASignatureSpi_SHA256$__constructor__();
        }

        public SHA256() {
            super(4);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStoreECDSASignatureSpi_SHA256$__constructor__(), 0, this);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SHA256)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class SHA224
    extends AndroidKeyStoreECDSASignatureSpi
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_security_keystore_AndroidKeyStoreECDSASignatureSpi_SHA224$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_security_keystore_AndroidKeyStoreECDSASignatureSpi_SHA224$__constructor__();
        }

        public SHA224() {
            super(3);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStoreECDSASignatureSpi_SHA224$__constructor__(), 0, this);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SHA224)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class SHA1
    extends AndroidKeyStoreECDSASignatureSpi
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_security_keystore_AndroidKeyStoreECDSASignatureSpi_SHA1$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_security_keystore_AndroidKeyStoreECDSASignatureSpi_SHA1$__constructor__();
        }

        public SHA1() {
            super(2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStoreECDSASignatureSpi_SHA1$__constructor__(), 0, this);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SHA1)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class NONE
    extends AndroidKeyStoreECDSASignatureSpi
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_security_keystore_AndroidKeyStoreECDSASignatureSpi_NONE$__constructor__() {
        }

        private final KeyStoreCryptoOperationStreamer $$robo$$android_security_keystore_AndroidKeyStoreECDSASignatureSpi_NONE$createMainDataStreamer(KeyStore keyStore, IBinder operationToken) {
            return new TruncateToFieldSizeMessageStreamer(super.createMainDataStreamer(keyStore, operationToken), this.getGroupSizeBits());
        }

        private void __constructor__() {
            this.$$robo$$android_security_keystore_AndroidKeyStoreECDSASignatureSpi_NONE$__constructor__();
        }

        public NONE() {
            super(0);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStoreECDSASignatureSpi_NONE$__constructor__(), 0, this);
        }

        @Override
        protected KeyStoreCryptoOperationStreamer createMainDataStreamer(KeyStore keyStore, IBinder iBinder) {
            return InvokeDynamicSupport.bootstrap("createMainDataStreamer", $$robo$$android_security_keystore_AndroidKeyStoreECDSASignatureSpi_NONE$createMainDataStreamer(android.security.KeyStore android.os.IBinder ), 0, this, keyStore, iBinder);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NONE)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private static class TruncateToFieldSizeMessageStreamer
        implements KeyStoreCryptoOperationStreamer,
        ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            private KeyStoreCryptoOperationStreamer mDelegate;
            private int mGroupSizeBits;
            private ByteArrayOutputStream mInputBuffer;
            private long mConsumedInputSizeBytes;

            private void $$robo$$android_security_keystore_AndroidKeyStoreECDSASignatureSpi_NONE_TruncateToFieldSizeMessageStreamer$__constructor__(KeyStoreCryptoOperationStreamer delegate, int groupSizeBits) {
                this.mInputBuffer = new ByteArrayOutputStream();
                this.mDelegate = delegate;
                this.mGroupSizeBits = groupSizeBits;
            }

            private final byte[] $$robo$$android_security_keystore_AndroidKeyStoreECDSASignatureSpi_NONE_TruncateToFieldSizeMessageStreamer$update(byte[] input, int inputOffset, int inputLength) throws KeyStoreException {
                if (inputLength > 0) {
                    this.mInputBuffer.write(input, inputOffset, inputLength);
                    this.mConsumedInputSizeBytes += (long)inputLength;
                }
                return EmptyArray.BYTE;
            }

            private final byte[] $$robo$$android_security_keystore_AndroidKeyStoreECDSASignatureSpi_NONE_TruncateToFieldSizeMessageStreamer$doFinal(byte[] input, int inputOffset, int inputLength, byte[] signature, byte[] additionalEntropy) throws KeyStoreException {
                if (inputLength > 0) {
                    this.mConsumedInputSizeBytes += (long)inputLength;
                    this.mInputBuffer.write(input, inputOffset, inputLength);
                }
                byte[] bufferedInput = this.mInputBuffer.toByteArray();
                this.mInputBuffer.reset();
                return this.mDelegate.doFinal(bufferedInput, 0, Math.min(bufferedInput.length, (this.mGroupSizeBits + 7) / 8), signature, additionalEntropy);
            }

            private final long $$robo$$android_security_keystore_AndroidKeyStoreECDSASignatureSpi_NONE_TruncateToFieldSizeMessageStreamer$getConsumedInputSizeBytes() {
                return this.mConsumedInputSizeBytes;
            }

            private final long $$robo$$android_security_keystore_AndroidKeyStoreECDSASignatureSpi_NONE_TruncateToFieldSizeMessageStreamer$getProducedOutputSizeBytes() {
                return this.mDelegate.getProducedOutputSizeBytes();
            }

            private /* synthetic */ void $$robo$$android_security_keystore_AndroidKeyStoreECDSASignatureSpi_NONE_TruncateToFieldSizeMessageStreamer$__constructor__(KeyStoreCryptoOperationStreamer x0, int x1, 1 x2) {
            }

            private void __constructor__(KeyStoreCryptoOperationStreamer keyStoreCryptoOperationStreamer, int n) {
                this.$$robo$$android_security_keystore_AndroidKeyStoreECDSASignatureSpi_NONE_TruncateToFieldSizeMessageStreamer$__constructor__(keyStoreCryptoOperationStreamer, n);
            }

            private TruncateToFieldSizeMessageStreamer(KeyStoreCryptoOperationStreamer keyStoreCryptoOperationStreamer, int n) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStoreECDSASignatureSpi_NONE_TruncateToFieldSizeMessageStreamer$__constructor__(android.security.keystore.KeyStoreCryptoOperationStreamer int ), 0, this, keyStoreCryptoOperationStreamer, n);
            }

            @Override
            public byte[] update(byte[] byArray, int n, int n2) throws KeyStoreException {
                return InvokeDynamicSupport.bootstrap("update", $$robo$$android_security_keystore_AndroidKeyStoreECDSASignatureSpi_NONE_TruncateToFieldSizeMessageStreamer$update(byte[] int int ), 0, this, byArray, n, n2);
            }

            @Override
            public byte[] doFinal(byte[] byArray, int n, int n2, byte[] byArray2, byte[] byArray3) throws KeyStoreException {
                return InvokeDynamicSupport.bootstrap("doFinal", $$robo$$android_security_keystore_AndroidKeyStoreECDSASignatureSpi_NONE_TruncateToFieldSizeMessageStreamer$doFinal(byte[] int int byte[] byte[] ), 0, this, byArray, n, n2, byArray2, byArray3);
            }

            @Override
            public long getConsumedInputSizeBytes() {
                return (long)InvokeDynamicSupport.bootstrap("getConsumedInputSizeBytes", $$robo$$android_security_keystore_AndroidKeyStoreECDSASignatureSpi_NONE_TruncateToFieldSizeMessageStreamer$getConsumedInputSizeBytes(), 0, this);
            }

            @Override
            public long getProducedOutputSizeBytes() {
                return (long)InvokeDynamicSupport.bootstrap("getProducedOutputSizeBytes", $$robo$$android_security_keystore_AndroidKeyStoreECDSASignatureSpi_NONE_TruncateToFieldSizeMessageStreamer$getProducedOutputSizeBytes(), 0, this);
            }

            private /* synthetic */ void __constructor__(KeyStoreCryptoOperationStreamer keyStoreCryptoOperationStreamer, int n, 1 var3_3) {
                this.$$robo$$android_security_keystore_AndroidKeyStoreECDSASignatureSpi_NONE_TruncateToFieldSizeMessageStreamer$__constructor__(keyStoreCryptoOperationStreamer, n, var3_3);
            }

            public /* synthetic */ TruncateToFieldSizeMessageStreamer() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TruncateToFieldSizeMessageStreamer)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }
}

