/*
 * Decompiled with CFR 0.152.
 */
package android.security;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.net.Uri;
import android.os.IBinder;
import android.os.Looper;
import android.os.Process;
import android.os.UserHandle;
import android.security.IKeyChainAliasCallback;
import android.security.IKeyChainService;
import android.security.KeyChainAliasCallback;
import android.security.KeyChainException;
import android.security.KeyStore;
import android.security.keystore.AndroidKeyStorePrivateKey;
import android.security.keystore.AndroidKeyStoreProvider;
import com.android.org.conscrypt.TrustedCertificateStore;
import com.google.errorprone.annotations.DoNotMock;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class KeyChain
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String ACCOUNT_TYPE = "com.android.keychain";
    private static String KEYCHAIN_PACKAGE = "com.android.keychain";
    private static String ACTION_CHOOSER = "com.android.keychain.CHOOSER";
    private static String CERT_INSTALLER_PACKAGE = "com.android.certinstaller";
    public static String EXTRA_RESPONSE = "response";
    public static String EXTRA_URI = "uri";
    public static String EXTRA_ALIAS = "alias";
    public static String EXTRA_SENDER = "sender";
    private static String ACTION_INSTALL = "android.credentials.INSTALL";
    public static String EXTRA_NAME = "name";
    public static String EXTRA_CERTIFICATE = "CERT";
    public static String EXTRA_PKCS12 = "PKCS12";
    public static String ACTION_STORAGE_CHANGED = "android.security.STORAGE_CHANGED";

    private void $$robo$$android_security_KeyChain$__constructor__() {
    }

    private static final Intent $$robo$$android_security_KeyChain$createInstallIntent() {
        Intent intent = new Intent("android.credentials.INSTALL");
        intent.setClassName("com.android.certinstaller", "com.android.certinstaller.CertInstallerMain");
        return intent;
    }

    private static final void $$robo$$android_security_KeyChain$choosePrivateKeyAlias(Activity activity, KeyChainAliasCallback response, String[] keyTypes, Principal[] issuers, String host, int port, String alias) {
        Uri uri = null;
        if (host != null) {
            uri = new Uri.Builder().authority(host + (port != -1 ? ":" + port : "")).build();
        }
        KeyChain.choosePrivateKeyAlias(activity, response, keyTypes, issuers, uri, alias);
    }

    private static final void $$robo$$android_security_KeyChain$choosePrivateKeyAlias(Activity activity, KeyChainAliasCallback response, String[] keyTypes, Principal[] issuers, Uri uri, String alias) {
        if (activity == null) {
            throw new NullPointerException("activity == null");
        }
        if (response == null) {
            throw new NullPointerException("response == null");
        }
        Intent intent = new Intent("com.android.keychain.CHOOSER");
        intent.setPackage("com.android.keychain");
        intent.putExtra("response", new AliasResponse(response));
        intent.putExtra("uri", uri);
        intent.putExtra("alias", alias);
        intent.putExtra("sender", PendingIntent.getActivity(activity, 0, new Intent(), 0));
        activity.startActivity(intent);
    }

    private static final PrivateKey $$robo$$android_security_KeyChain$getPrivateKey(Context context, String alias) throws KeyChainException, InterruptedException {
        if (alias == null) {
            throw new NullPointerException("alias == null");
        }
        try (KeyChainConnection keyChainConnection = KeyChain.bind(context);){
            IKeyChainService keyChainService = keyChainConnection.getService();
            String keyId = keyChainService.requestPrivateKey(alias);
            if (keyId == null) {
                PrivateKey privateKey = null;
                return privateKey;
            }
            AndroidKeyStorePrivateKey androidKeyStorePrivateKey = AndroidKeyStoreProvider.loadAndroidKeyStorePrivateKeyFromKeystore(KeyStore.getInstance(), keyId, -1);
            return androidKeyStorePrivateKey;
        }
    }

    private static final X509Certificate[] $$robo$$android_security_KeyChain$getCertificateChain(Context context, String alias) throws KeyChainException, InterruptedException {
        if (alias == null) {
            throw new NullPointerException("alias == null");
        }
        try (KeyChainConnection keyChainConnection = KeyChain.bind(context);){
            IKeyChainService keyChainService = keyChainConnection.getService();
            byte[] certificateBytes = keyChainService.getCertificate(alias);
            if (certificateBytes == null) {
                X509Certificate[] x509CertificateArray = null;
                return x509CertificateArray;
            }
            X509Certificate leafCert = KeyChain.toCertificate(certificateBytes);
            byte[] certChainBytes = keyChainService.getCaCertificates(alias);
            if (certChainBytes != null && certChainBytes.length != 0) {
                Collection<X509Certificate> chain = KeyChain.toCertificates(certChainBytes);
                ArrayList<X509Certificate> fullChain = new ArrayList<X509Certificate>(chain.size() + 1);
                fullChain.add(leafCert);
                fullChain.addAll(chain);
                X509Certificate[] x509CertificateArray = fullChain.toArray(new X509Certificate[fullChain.size()]);
                return x509CertificateArray;
            }
            TrustedCertificateStore store = new TrustedCertificateStore();
            List<X509Certificate> chain = store.getCertificateChain(leafCert);
            X509Certificate[] x509CertificateArray = chain.toArray(new X509Certificate[chain.size()]);
            return x509CertificateArray;
        }
    }

    private static final boolean $$robo$$android_security_KeyChain$isKeyAlgorithmSupported(String algorithm) {
        String algUpper = algorithm.toUpperCase(Locale.US);
        return "EC".equals(algUpper) || "RSA".equals(algUpper);
    }

    @Deprecated
    private static final boolean $$robo$$android_security_KeyChain$isBoundKeyAlgorithm(String algorithm) {
        if (!KeyChain.isKeyAlgorithmSupported(algorithm)) {
            return false;
        }
        return KeyStore.getInstance().isHardwareBacked(algorithm);
    }

    private static final X509Certificate $$robo$$android_security_KeyChain$toCertificate(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes == null");
        }
        try {
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            Certificate cert = certFactory.generateCertificate(new ByteArrayInputStream(bytes));
            return (X509Certificate)cert;
        }
        catch (CertificateException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static final Collection<X509Certificate> $$robo$$android_security_KeyChain$toCertificates(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes == null");
        }
        try {
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            return certFactory.generateCertificates(new ByteArrayInputStream(bytes));
        }
        catch (CertificateException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static final KeyChainConnection $$robo$$android_security_KeyChain$bind(Context context) throws InterruptedException {
        return KeyChain.bindAsUser(context, Process.myUserHandle());
    }

    private static final KeyChainConnection $$robo$$android_security_KeyChain$bindAsUser(Context context, UserHandle user) throws InterruptedException {
        if (context == null) {
            throw new NullPointerException("context == null");
        }
        KeyChain.ensureNotOnMainThread(context);
        LinkedBlockingQueue q = new LinkedBlockingQueue(1);
        ServiceConnection keyChainServiceConnection = new ServiceConnection(q){
            public transient /* synthetic */ Object __robo_data__;
            volatile boolean mConnectedAtLeastOnce;
            /* synthetic */ BlockingQueue val$q;

            private void $$robo$$android_security_KeyChain_1$__constructor__(BlockingQueue blockingQueue) {
                this.mConnectedAtLeastOnce = false;
            }

            private final void $$robo$$android_security_KeyChain_1$onServiceConnected(ComponentName name, IBinder service) {
                if (!this.mConnectedAtLeastOnce) {
                    this.mConnectedAtLeastOnce = true;
                    try {
                        this.val$q.put(IKeyChainService.Stub.asInterface(service));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }

            private final void $$robo$$android_security_KeyChain_1$onServiceDisconnected(ComponentName name) {
            }

            private void __constructor__(BlockingQueue blockingQueue) {
                this.$$robo$$android_security_KeyChain_1$__constructor__(blockingQueue);
            }
            {
                this.val$q = blockingQueue;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_KeyChain_1$__constructor__(java.util.concurrent.BlockingQueue ), 0, this, blockingQueue);
            }

            @Override
            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$android_security_KeyChain_1$onServiceConnected(android.content.ComponentName android.os.IBinder ), 0, this, componentName, iBinder);
            }

            @Override
            public void onServiceDisconnected(ComponentName componentName) {
                InvokeDynamicSupport.bootstrap("onServiceDisconnected", $$robo$$android_security_KeyChain_1$onServiceDisconnected(android.content.ComponentName ), 0, this, componentName);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        Intent intent = new Intent(IKeyChainService.class.getName());
        ComponentName comp = intent.resolveSystemService(context.getPackageManager(), 0);
        intent.setComponent(comp);
        if (comp == null || !context.bindServiceAsUser(intent, keyChainServiceConnection, 1, user)) {
            throw new AssertionError((Object)"could not bind to KeyChainService");
        }
        return new KeyChainConnection(context, keyChainServiceConnection, (IKeyChainService)q.take());
    }

    private static final void $$robo$$android_security_KeyChain$ensureNotOnMainThread(Context context) {
        Looper looper = Looper.myLooper();
        if (looper != null && looper == context.getMainLooper()) {
            throw new IllegalStateException("calling this from your main thread can lead to deadlock");
        }
    }

    private void __constructor__() {
        this.$$robo$$android_security_KeyChain$__constructor__();
    }

    public KeyChain() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_KeyChain$__constructor__(), 0, this);
    }

    public static Intent createInstallIntent() {
        return InvokeDynamicSupport.bootstrapStatic("createInstallIntent", $$robo$$android_security_KeyChain$createInstallIntent(), 0);
    }

    public static void choosePrivateKeyAlias(Activity activity, KeyChainAliasCallback keyChainAliasCallback, String[] stringArray, Principal[] principalArray, String string2, int n, String string3) {
        InvokeDynamicSupport.bootstrapStatic("choosePrivateKeyAlias", $$robo$$android_security_KeyChain$choosePrivateKeyAlias(android.app.Activity android.security.KeyChainAliasCallback java.lang.String[] java.security.Principal[] java.lang.String int java.lang.String ), 0, (Activity)activity, (KeyChainAliasCallback)keyChainAliasCallback, (String[])stringArray, (Principal[])principalArray, (String)string2, (int)n, (String)string3);
    }

    public static void choosePrivateKeyAlias(Activity activity, KeyChainAliasCallback keyChainAliasCallback, String[] stringArray, Principal[] principalArray, Uri uri, String string2) {
        InvokeDynamicSupport.bootstrapStatic("choosePrivateKeyAlias", $$robo$$android_security_KeyChain$choosePrivateKeyAlias(android.app.Activity android.security.KeyChainAliasCallback java.lang.String[] java.security.Principal[] android.net.Uri java.lang.String ), 0, (Activity)activity, (KeyChainAliasCallback)keyChainAliasCallback, (String[])stringArray, (Principal[])principalArray, (Uri)uri, (String)string2);
    }

    public static PrivateKey getPrivateKey(Context context, String string2) throws KeyChainException, InterruptedException {
        return InvokeDynamicSupport.bootstrapStatic("getPrivateKey", $$robo$$android_security_KeyChain$getPrivateKey(android.content.Context java.lang.String ), 0, (Context)context, (String)string2);
    }

    public static X509Certificate[] getCertificateChain(Context context, String string2) throws KeyChainException, InterruptedException {
        return InvokeDynamicSupport.bootstrapStatic("getCertificateChain", $$robo$$android_security_KeyChain$getCertificateChain(android.content.Context java.lang.String ), 0, (Context)context, (String)string2);
    }

    public static boolean isKeyAlgorithmSupported(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isKeyAlgorithmSupported", $$robo$$android_security_KeyChain$isKeyAlgorithmSupported(java.lang.String ), 0, (String)string2);
    }

    @Deprecated
    public static boolean isBoundKeyAlgorithm(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isBoundKeyAlgorithm", $$robo$$android_security_KeyChain$isBoundKeyAlgorithm(java.lang.String ), 0, (String)string2);
    }

    public static X509Certificate toCertificate(byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("toCertificate", $$robo$$android_security_KeyChain$toCertificate(byte[] ), 0, (byte[])byArray);
    }

    public static Collection<X509Certificate> toCertificates(byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("toCertificates", $$robo$$android_security_KeyChain$toCertificates(byte[] ), 0, (byte[])byArray);
    }

    public static KeyChainConnection bind(Context context) throws InterruptedException {
        return InvokeDynamicSupport.bootstrapStatic("bind", $$robo$$android_security_KeyChain$bind(android.content.Context ), 0, (Context)context);
    }

    public static KeyChainConnection bindAsUser(Context context, UserHandle userHandle) throws InterruptedException {
        return InvokeDynamicSupport.bootstrapStatic("bindAsUser", $$robo$$android_security_KeyChain$bindAsUser(android.content.Context android.os.UserHandle ), 0, (Context)context, (UserHandle)userHandle);
    }

    private static void ensureNotOnMainThread(Context context) {
        InvokeDynamicSupport.bootstrapStatic("ensureNotOnMainThread", $$robo$$android_security_KeyChain$ensureNotOnMainThread(android.content.Context ), 0, (Context)context);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KeyChain)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class KeyChainConnection
    implements Closeable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Context context;
        private ServiceConnection serviceConnection;
        private IKeyChainService service;

        private void $$robo$$android_security_KeyChain_KeyChainConnection$__constructor__(Context context, ServiceConnection serviceConnection, IKeyChainService service) {
            this.context = context;
            this.serviceConnection = serviceConnection;
            this.service = service;
        }

        private final void $$robo$$android_security_KeyChain_KeyChainConnection$close() {
            this.context.unbindService(this.serviceConnection);
        }

        private final IKeyChainService $$robo$$android_security_KeyChain_KeyChainConnection$getService() {
            return this.service;
        }

        private /* synthetic */ void $$robo$$android_security_KeyChain_KeyChainConnection$__constructor__(Context x0, ServiceConnection x1, IKeyChainService x2, 1 x3) {
        }

        private void __constructor__(Context context, ServiceConnection serviceConnection, IKeyChainService iKeyChainService) {
            this.$$robo$$android_security_KeyChain_KeyChainConnection$__constructor__(context, serviceConnection, iKeyChainService);
        }

        private KeyChainConnection(Context context, ServiceConnection serviceConnection, IKeyChainService iKeyChainService) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_KeyChain_KeyChainConnection$__constructor__(android.content.Context android.content.ServiceConnection android.security.IKeyChainService ), 0, this, context, serviceConnection, iKeyChainService);
        }

        @Override
        public void close() {
            InvokeDynamicSupport.bootstrap("close", $$robo$$android_security_KeyChain_KeyChainConnection$close(), 0, this);
        }

        public IKeyChainService getService() {
            return InvokeDynamicSupport.bootstrap("getService", $$robo$$android_security_KeyChain_KeyChainConnection$getService(), 0, this);
        }

        private /* synthetic */ void __constructor__(Context context, ServiceConnection serviceConnection, IKeyChainService iKeyChainService, 1 var4_4) {
            this.$$robo$$android_security_KeyChain_KeyChainConnection$__constructor__(context, serviceConnection, iKeyChainService, var4_4);
        }

        public /* synthetic */ KeyChainConnection() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KeyChainConnection)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class AliasResponse
    extends IKeyChainAliasCallback.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private KeyChainAliasCallback keyChainAliasResponse;

        private void $$robo$$android_security_KeyChain_AliasResponse$__constructor__(KeyChainAliasCallback keyChainAliasResponse) {
            this.keyChainAliasResponse = keyChainAliasResponse;
        }

        private final void $$robo$$android_security_KeyChain_AliasResponse$alias(String alias) {
            this.keyChainAliasResponse.alias(alias);
        }

        private /* synthetic */ void $$robo$$android_security_KeyChain_AliasResponse$__constructor__(KeyChainAliasCallback x0, 1 x1) {
        }

        private void __constructor__(KeyChainAliasCallback keyChainAliasCallback) {
            this.$$robo$$android_security_KeyChain_AliasResponse$__constructor__(keyChainAliasCallback);
        }

        private AliasResponse(KeyChainAliasCallback keyChainAliasCallback) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_KeyChain_AliasResponse$__constructor__(android.security.KeyChainAliasCallback ), 0, this, keyChainAliasCallback);
        }

        @Override
        public void alias(String string2) {
            InvokeDynamicSupport.bootstrap("alias", $$robo$$android_security_KeyChain_AliasResponse$alias(java.lang.String ), 0, this, string2);
        }

        private /* synthetic */ void __constructor__(KeyChainAliasCallback keyChainAliasCallback, 1 var2_2) {
            this.$$robo$$android_security_KeyChain_AliasResponse$__constructor__(keyChainAliasCallback, var2_2);
        }

        public /* synthetic */ AliasResponse() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AliasResponse)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

