/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.content.res.AssetManager;
import android.content.res.Resources;
import android.renderscript.BaseObj;
import android.renderscript.Mesh;
import android.renderscript.RSRuntimeException;
import android.renderscript.RenderScript;
import com.google.errorprone.annotations.DoNotMock;
import java.io.File;
import java.io.InputStream;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class FileA3D
extends BaseObj
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    IndexEntry[] mFileEntries;
    InputStream mInputStream;

    private void $$robo$$android_renderscript_FileA3D$__constructor__(long id2, RenderScript rs, InputStream stream) {
        this.mInputStream = stream;
        this.guard.open("destroy");
    }

    private final void $$robo$$android_renderscript_FileA3D$initEntries() {
        int numFileEntries = this.mRS.nFileA3DGetNumIndexEntries(this.getID(this.mRS));
        if (numFileEntries <= 0) {
            return;
        }
        this.mFileEntries = new IndexEntry[numFileEntries];
        int[] ids = new int[numFileEntries];
        String[] names = new String[numFileEntries];
        this.mRS.nFileA3DGetIndexEntries(this.getID(this.mRS), numFileEntries, ids, names);
        for (int i = 0; i < numFileEntries; ++i) {
            this.mFileEntries[i] = new IndexEntry(this.mRS, i, this.getID(this.mRS), names[i], EntryType.toEntryType(ids[i]));
        }
    }

    private final int $$robo$$android_renderscript_FileA3D$getIndexEntryCount() {
        if (this.mFileEntries == null) {
            return 0;
        }
        return this.mFileEntries.length;
    }

    private final IndexEntry $$robo$$android_renderscript_FileA3D$getIndexEntry(int index) {
        if (this.getIndexEntryCount() == 0 || index < 0 || index >= this.mFileEntries.length) {
            return null;
        }
        return this.mFileEntries[index];
    }

    private static final FileA3D $$robo$$android_renderscript_FileA3D$createFromAsset(RenderScript rs, AssetManager mgr, String path) {
        rs.validate();
        long fileId = rs.nFileA3DCreateFromAsset(mgr, path);
        if (fileId == 0L) {
            throw new RSRuntimeException("Unable to create a3d file from asset " + path);
        }
        FileA3D fa3d = new FileA3D(fileId, rs, null);
        fa3d.initEntries();
        return fa3d;
    }

    private static final FileA3D $$robo$$android_renderscript_FileA3D$createFromFile(RenderScript rs, String path) {
        long fileId = rs.nFileA3DCreateFromFile(path);
        if (fileId == 0L) {
            throw new RSRuntimeException("Unable to create a3d file from " + path);
        }
        FileA3D fa3d = new FileA3D(fileId, rs, null);
        fa3d.initEntries();
        return fa3d;
    }

    private static final FileA3D $$robo$$android_renderscript_FileA3D$createFromFile(RenderScript rs, File path) {
        return FileA3D.createFromFile(rs, path.getAbsolutePath());
    }

    private static final FileA3D $$robo$$android_renderscript_FileA3D$createFromResource(RenderScript rs, Resources res, int id2) {
        rs.validate();
        InputStream is = null;
        try {
            is = res.openRawResource(id2);
        }
        catch (Exception e) {
            throw new RSRuntimeException("Unable to open resource " + id2);
        }
        long fileId = 0L;
        if (!(is instanceof AssetManager.AssetInputStream)) {
            throw new RSRuntimeException("Unsupported asset stream");
        }
        long asset = ((AssetManager.AssetInputStream)is).getNativeAsset();
        fileId = rs.nFileA3DCreateFromAssetStream(asset);
        if (fileId == 0L) {
            throw new RSRuntimeException("Unable to create a3d file from resource " + id2);
        }
        FileA3D fa3d = new FileA3D(fileId, rs, is);
        fa3d.initEntries();
        return fa3d;
    }

    private void __constructor__(long l, RenderScript renderScript, InputStream inputStream) {
        this.$$robo$$android_renderscript_FileA3D$__constructor__(l, renderScript, inputStream);
    }

    FileA3D(long l, RenderScript renderScript, InputStream inputStream) {
        super(l, renderScript);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_renderscript_FileA3D$__constructor__(long android.renderscript.RenderScript java.io.InputStream ), 0, this, l, renderScript, inputStream);
    }

    private void initEntries() {
        InvokeDynamicSupport.bootstrap("initEntries", $$robo$$android_renderscript_FileA3D$initEntries(), 0, this);
    }

    public int getIndexEntryCount() {
        return (int)InvokeDynamicSupport.bootstrap("getIndexEntryCount", $$robo$$android_renderscript_FileA3D$getIndexEntryCount(), 0, this);
    }

    public IndexEntry getIndexEntry(int n) {
        return InvokeDynamicSupport.bootstrap("getIndexEntry", $$robo$$android_renderscript_FileA3D$getIndexEntry(int ), 0, this, n);
    }

    public static FileA3D createFromAsset(RenderScript renderScript, AssetManager assetManager, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("createFromAsset", $$robo$$android_renderscript_FileA3D$createFromAsset(android.renderscript.RenderScript android.content.res.AssetManager java.lang.String ), 0, (RenderScript)renderScript, (AssetManager)assetManager, (String)string2);
    }

    public static FileA3D createFromFile(RenderScript renderScript, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("createFromFile", $$robo$$android_renderscript_FileA3D$createFromFile(android.renderscript.RenderScript java.lang.String ), 0, (RenderScript)renderScript, (String)string2);
    }

    public static FileA3D createFromFile(RenderScript renderScript, File file) {
        return InvokeDynamicSupport.bootstrapStatic("createFromFile", $$robo$$android_renderscript_FileA3D$createFromFile(android.renderscript.RenderScript java.io.File ), 0, (RenderScript)renderScript, (File)file);
    }

    public static FileA3D createFromResource(RenderScript renderScript, Resources resources, int n) {
        return InvokeDynamicSupport.bootstrapStatic("createFromResource", $$robo$$android_renderscript_FileA3D$createFromResource(android.renderscript.RenderScript android.content.res.Resources int ), 0, (RenderScript)renderScript, (Resources)resources, (int)n);
    }

    public /* synthetic */ FileA3D() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FileA3D)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class IndexEntry
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        RenderScript mRS;
        int mIndex;
        long mID;
        String mName;
        EntryType mEntryType;
        BaseObj mLoadedObj;

        private final String $$robo$$android_renderscript_FileA3D_IndexEntry$getName() {
            return this.mName;
        }

        private final EntryType $$robo$$android_renderscript_FileA3D_IndexEntry$getEntryType() {
            return this.mEntryType;
        }

        private final BaseObj $$robo$$android_renderscript_FileA3D_IndexEntry$getObject() {
            this.mRS.validate();
            BaseObj obj = IndexEntry.internalCreate(this.mRS, this);
            return obj;
        }

        private final Mesh $$robo$$android_renderscript_FileA3D_IndexEntry$getMesh() {
            return (Mesh)this.getObject();
        }

        private static final synchronized BaseObj $$robo$$android_renderscript_FileA3D_IndexEntry$internalCreate(RenderScript rs, IndexEntry entry) {
            if (entry.mLoadedObj != null) {
                return entry.mLoadedObj;
            }
            if (entry.mEntryType == EntryType.UNKNOWN) {
                return null;
            }
            long objectID = rs.nFileA3DGetEntryByIndex(entry.mID, entry.mIndex);
            if (objectID == 0L) {
                return null;
            }
            switch (1.$SwitchMap$android$renderscript$FileA3D$EntryType[entry.mEntryType.ordinal()]) {
                case 1: {
                    entry.mLoadedObj = new Mesh(objectID, rs);
                    break;
                }
                default: {
                    throw new RSRuntimeException("Unrecognized object type in file.");
                }
            }
            entry.mLoadedObj.updateFromNative();
            return entry.mLoadedObj;
        }

        private void $$robo$$android_renderscript_FileA3D_IndexEntry$__constructor__(RenderScript rs, int index, long id2, String name, EntryType type) {
            this.mRS = rs;
            this.mIndex = index;
            this.mID = id2;
            this.mName = name;
            this.mEntryType = type;
            this.mLoadedObj = null;
        }

        public String getName() {
            return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_renderscript_FileA3D_IndexEntry$getName(), 0, this);
        }

        public EntryType getEntryType() {
            return InvokeDynamicSupport.bootstrap("getEntryType", $$robo$$android_renderscript_FileA3D_IndexEntry$getEntryType(), 0, this);
        }

        public BaseObj getObject() {
            return InvokeDynamicSupport.bootstrap("getObject", $$robo$$android_renderscript_FileA3D_IndexEntry$getObject(), 0, this);
        }

        public Mesh getMesh() {
            return InvokeDynamicSupport.bootstrap("getMesh", $$robo$$android_renderscript_FileA3D_IndexEntry$getMesh(), 0, this);
        }

        static synchronized BaseObj internalCreate(RenderScript renderScript, IndexEntry indexEntry) {
            return InvokeDynamicSupport.bootstrapStatic("internalCreate", $$robo$$android_renderscript_FileA3D_IndexEntry$internalCreate(android.renderscript.RenderScript android.renderscript.FileA3D$IndexEntry ), 0, (RenderScript)renderScript, (IndexEntry)indexEntry);
        }

        private void __constructor__(RenderScript renderScript, int n, long l, String string2, EntryType entryType) {
            this.$$robo$$android_renderscript_FileA3D_IndexEntry$__constructor__(renderScript, n, l, string2, entryType);
        }

        IndexEntry(RenderScript renderScript, int n, long l, String string2, EntryType entryType) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_renderscript_FileA3D_IndexEntry$__constructor__(android.renderscript.RenderScript int long java.lang.String android.renderscript.FileA3D$EntryType ), 0, this, renderScript, n, l, string2, entryType);
        }

        public /* synthetic */ IndexEntry() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IndexEntry)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class EntryType
    extends Enum<EntryType> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ EntryType UNKNOWN;
        public static /* enum */ EntryType MESH;
        int mID;
        private static /* synthetic */ EntryType[] $VALUES;

        private static final EntryType[] $$robo$$android_renderscript_FileA3D_EntryType$values() {
            return (EntryType[])$VALUES.clone();
        }

        private static final EntryType $$robo$$android_renderscript_FileA3D_EntryType$valueOf(String name) {
            return Enum.valueOf(EntryType.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_renderscript_FileA3D_EntryType$__constructor__(String string2, int n, int id2) {
            this.mID = id2;
        }

        private static final EntryType $$robo$$android_renderscript_FileA3D_EntryType$toEntryType(int intID) {
            return EntryType.values()[intID];
        }

        static void __staticInitializer__() {
            UNKNOWN = new EntryType(0);
            MESH = new EntryType(1);
            $VALUES = new EntryType[]{UNKNOWN, MESH};
        }

        public static EntryType[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_renderscript_FileA3D_EntryType$values(), 0);
        }

        public static EntryType valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_renderscript_FileA3D_EntryType$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n, int n2) {
            this.$$robo$$android_renderscript_FileA3D_EntryType$__constructor__(string2, n, n2);
        }

        private EntryType(int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_renderscript_FileA3D_EntryType$__constructor__(java.lang.String int int ), 0, this, string2, n, n2);
        }

        static EntryType toEntryType(int n) {
            return InvokeDynamicSupport.bootstrapStatic("toEntryType", $$robo$$android_renderscript_FileA3D_EntryType$toEntryType(int ), 0, (int)n);
        }

        static {
            RobolectricInternals.classInitializing(EntryType.class);
        }

        public /* synthetic */ EntryType() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EntryType)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

