/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.ContentProviderClient;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.CursorEntityIterator;
import android.content.Entity;
import android.content.EntityIterator;
import android.content.Intent;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.net.Uri;
import android.os.RemoteException;
import android.provider.BaseColumns;
import android.provider.SyncStateContract;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.invoke.CallSite;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class CalendarContract
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "Calendar";
    public static String ACTION_EVENT_REMINDER = "android.intent.action.EVENT_REMINDER";
    public static String ACTION_HANDLE_CUSTOM_EVENT = "android.provider.calendar.action.HANDLE_CUSTOM_EVENT";
    public static String EXTRA_CUSTOM_APP_URI = "customAppUri";
    public static String EXTRA_EVENT_BEGIN_TIME = "beginTime";
    public static String EXTRA_EVENT_END_TIME = "endTime";
    public static String EXTRA_EVENT_ALL_DAY = "allDay";
    public static String AUTHORITY = "com.android.calendar";
    public static Uri CONTENT_URI;
    public static String CALLER_IS_SYNCADAPTER = "caller_is_syncadapter";
    public static String ACCOUNT_TYPE_LOCAL = "LOCAL";

    private void $$robo$$android_provider_CalendarContract$__constructor__() {
    }

    static void __staticInitializer__() {
        CONTENT_URI = Uri.parse("content://com.android.calendar");
    }

    private void __constructor__() {
        this.$$robo$$android_provider_CalendarContract$__constructor__();
    }

    private CalendarContract() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_CalendarContract$__constructor__(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(CalendarContract.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CalendarContract)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class EventsRawTimes
    implements BaseColumns,
    EventsRawTimesColumns,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_provider_CalendarContract_EventsRawTimes$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_provider_CalendarContract_EventsRawTimes$__constructor__();
        }

        private EventsRawTimes() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_CalendarContract_EventsRawTimes$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EventsRawTimes)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    protected static interface EventsRawTimesColumns
    extends InstrumentedInterface {
        public static final String EVENT_ID = "event_id";
        public static final String DTSTART_2445 = "dtstart2445";
        public static final String DTEND_2445 = "dtend2445";
        public static final String ORIGINAL_INSTANCE_TIME_2445 = "originalInstanceTime2445";
        public static final String LAST_DATE_2445 = "lastDate2445";
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class SyncState
    implements SyncStateContract.Columns,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static String CONTENT_DIRECTORY = "syncstate";
        public static Uri CONTENT_URI;

        private void $$robo$$android_provider_CalendarContract_SyncState$__constructor__() {
        }

        static void __staticInitializer__() {
            CONTENT_URI = Uri.withAppendedPath(CONTENT_URI, "syncstate");
        }

        private void __constructor__() {
            this.$$robo$$android_provider_CalendarContract_SyncState$__constructor__();
        }

        private SyncState() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_CalendarContract_SyncState$__constructor__(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(SyncState.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SyncState)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class ExtendedProperties
    implements BaseColumns,
    ExtendedPropertiesColumns,
    EventsColumns,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static Uri CONTENT_URI;

        private void $$robo$$android_provider_CalendarContract_ExtendedProperties$__constructor__() {
        }

        static void __staticInitializer__() {
            CONTENT_URI = Uri.parse("content://com.android.calendar/extendedproperties");
        }

        private void __constructor__() {
            this.$$robo$$android_provider_CalendarContract_ExtendedProperties$__constructor__();
        }

        private ExtendedProperties() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_CalendarContract_ExtendedProperties$__constructor__(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(ExtendedProperties.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ExtendedProperties)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    protected static interface ExtendedPropertiesColumns
    extends InstrumentedInterface {
        public static final String EVENT_ID = "event_id";
        public static final String NAME = "name";
        public static final String VALUE = "value";
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Colors
    implements ColorsColumns,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static String TABLE_NAME = "Colors";
        public static Uri CONTENT_URI;

        private void $$robo$$android_provider_CalendarContract_Colors$__constructor__() {
        }

        static void __staticInitializer__() {
            CONTENT_URI = Uri.parse("content://com.android.calendar/colors");
        }

        private void __constructor__() {
            this.$$robo$$android_provider_CalendarContract_Colors$__constructor__();
        }

        private Colors() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_CalendarContract_Colors$__constructor__(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(Colors.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Colors)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    protected static interface ColorsColumns
    extends SyncStateContract.Columns,
    InstrumentedInterface {
        public static final String COLOR_TYPE = "color_type";
        public static final int TYPE_CALENDAR = 0;
        public static final int TYPE_EVENT = 1;
        public static final String COLOR_KEY = "color_index";
        public static final String COLOR = "color";
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class CalendarAlerts
    implements BaseColumns,
    CalendarAlertsColumns,
    EventsColumns,
    CalendarColumns,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static String TABLE_NAME = "CalendarAlerts";
        public static Uri CONTENT_URI;
        private static String WHERE_ALARM_EXISTS = "event_id=? AND begin=? AND alarmTime=?";
        private static String WHERE_FINDNEXTALARMTIME = "alarmTime>=?";
        private static String SORT_ORDER_ALARMTIME_ASC = "alarmTime ASC";
        private static String WHERE_RESCHEDULE_MISSED_ALARMS = "state=0 AND alarmTime<? AND alarmTime>? AND end>=?";
        public static Uri CONTENT_URI_BY_INSTANCE;
        private static boolean DEBUG = false;

        private void $$robo$$android_provider_CalendarContract_CalendarAlerts$__constructor__() {
        }

        private static final Uri $$robo$$android_provider_CalendarContract_CalendarAlerts$insert(ContentResolver cr, long eventId, long begin, long end, long alarmTime, int minutes) {
            ContentValues values = new ContentValues();
            values.put("event_id", eventId);
            values.put("begin", begin);
            values.put("end", end);
            values.put("alarmTime", alarmTime);
            CallSite currentTime = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
            values.put("creationTime", (long)currentTime);
            values.put("receivedTime", 0);
            values.put("notifyTime", 0);
            values.put("state", 0);
            values.put("minutes", minutes);
            return cr.insert(CONTENT_URI, values);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final long $$robo$$android_provider_CalendarContract_CalendarAlerts$findNextAlarmTime(ContentResolver cr, long millis) {
            String selection = "alarmTime>=" + millis;
            String[] projection = new String[]{"alarmTime"};
            long alarmTime = -1L;
            try (Cursor cursor = cr.query(CONTENT_URI, projection, "alarmTime>=?", new String[]{Long.toString(millis)}, "alarmTime ASC");){
                if (cursor != null && cursor.moveToFirst()) {
                    alarmTime = cursor.getLong(0);
                }
            }
            return alarmTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final void $$robo$$android_provider_CalendarContract_CalendarAlerts$rescheduleMissedAlarms(ContentResolver cr, Context context, AlarmManager manager) {
            CallSite now = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
            reference var5_4 = now - 86400000L;
            String[] projection = new String[]{"alarmTime"};
            Cursor cursor = cr.query(CONTENT_URI, projection, "state=0 AND alarmTime<? AND alarmTime>? AND end>=?", new String[]{Long.toString((long)now), Long.toString((long)var5_4), Long.toString((long)now)}, "alarmTime ASC");
            if (cursor == null) {
                return;
            }
            try {
                long alarmTime = -1L;
                while (cursor.moveToNext()) {
                    long newAlarmTime = cursor.getLong(0);
                    if (alarmTime == newAlarmTime) continue;
                    CalendarAlerts.scheduleAlarm(context, manager, newAlarmTime);
                    alarmTime = newAlarmTime;
                }
            }
            finally {
                cursor.close();
            }
        }

        private static final void $$robo$$android_provider_CalendarContract_CalendarAlerts$scheduleAlarm(Context context, AlarmManager manager, long alarmTime) {
            if (manager == null) {
                manager = (AlarmManager)context.getSystemService("alarm");
            }
            Intent intent = new Intent("android.intent.action.EVENT_REMINDER");
            intent.setData(ContentUris.withAppendedId(CONTENT_URI, alarmTime));
            intent.putExtra("alarmTime", alarmTime);
            PendingIntent pi = PendingIntent.getBroadcast(context, 0, intent, 0);
            manager.setExactAndAllowWhileIdle(0, alarmTime, pi);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final boolean $$robo$$android_provider_CalendarContract_CalendarAlerts$alarmExists(ContentResolver cr, long eventId, long begin, long alarmTime) {
            String[] projection = new String[]{"alarmTime"};
            boolean found = false;
            try (Cursor cursor = cr.query(CONTENT_URI, projection, "event_id=? AND begin=? AND alarmTime=?", new String[]{Long.toString(eventId), Long.toString(begin), Long.toString(alarmTime)}, null);){
                if (cursor != null && cursor.getCount() > 0) {
                    found = true;
                }
            }
            return found;
        }

        static void __staticInitializer__() {
            CONTENT_URI = Uri.parse("content://com.android.calendar/calendar_alerts");
            CONTENT_URI_BY_INSTANCE = Uri.parse("content://com.android.calendar/calendar_alerts/by_instance");
        }

        private void __constructor__() {
            this.$$robo$$android_provider_CalendarContract_CalendarAlerts$__constructor__();
        }

        private CalendarAlerts() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_CalendarContract_CalendarAlerts$__constructor__(), 0, this);
        }

        public static Uri insert(ContentResolver contentResolver, long l, long l2, long l3, long l4, int n) {
            return InvokeDynamicSupport.bootstrapStatic("insert", $$robo$$android_provider_CalendarContract_CalendarAlerts$insert(android.content.ContentResolver long long long long int ), 0, (ContentResolver)contentResolver, (long)l, (long)l2, (long)l3, (long)l4, (int)n);
        }

        public static long findNextAlarmTime(ContentResolver contentResolver, long l) {
            return (long)InvokeDynamicSupport.bootstrapStatic("findNextAlarmTime", $$robo$$android_provider_CalendarContract_CalendarAlerts$findNextAlarmTime(android.content.ContentResolver long ), 0, (ContentResolver)contentResolver, (long)l);
        }

        public static void rescheduleMissedAlarms(ContentResolver contentResolver, Context context, AlarmManager alarmManager) {
            InvokeDynamicSupport.bootstrapStatic("rescheduleMissedAlarms", $$robo$$android_provider_CalendarContract_CalendarAlerts$rescheduleMissedAlarms(android.content.ContentResolver android.content.Context android.app.AlarmManager ), 0, (ContentResolver)contentResolver, (Context)context, (AlarmManager)alarmManager);
        }

        public static void scheduleAlarm(Context context, AlarmManager alarmManager, long l) {
            InvokeDynamicSupport.bootstrapStatic("scheduleAlarm", $$robo$$android_provider_CalendarContract_CalendarAlerts$scheduleAlarm(android.content.Context android.app.AlarmManager long ), 0, (Context)context, (AlarmManager)alarmManager, (long)l);
        }

        public static boolean alarmExists(ContentResolver contentResolver, long l, long l2, long l3) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("alarmExists", $$robo$$android_provider_CalendarContract_CalendarAlerts$alarmExists(android.content.ContentResolver long long long ), 0, (ContentResolver)contentResolver, (long)l, (long)l2, (long)l3);
        }

        static {
            RobolectricInternals.classInitializing(CalendarAlerts.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CalendarAlerts)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    protected static interface CalendarAlertsColumns
    extends InstrumentedInterface {
        public static final String EVENT_ID = "event_id";
        public static final String BEGIN = "begin";
        public static final String END = "end";
        public static final String ALARM_TIME = "alarmTime";
        public static final String CREATION_TIME = "creationTime";
        public static final String RECEIVED_TIME = "receivedTime";
        public static final String NOTIFY_TIME = "notifyTime";
        public static final String STATE = "state";
        public static final int STATE_SCHEDULED = 0;
        public static final int STATE_FIRED = 1;
        public static final int STATE_DISMISSED = 2;
        public static final String MINUTES = "minutes";
        public static final String DEFAULT_SORT_ORDER = "begin ASC,title ASC";
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Reminders
    implements BaseColumns,
    RemindersColumns,
    EventsColumns,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static String REMINDERS_WHERE = "event_id=?";
        public static Uri CONTENT_URI;

        private void $$robo$$android_provider_CalendarContract_Reminders$__constructor__() {
        }

        private static final Cursor $$robo$$android_provider_CalendarContract_Reminders$query(ContentResolver cr, long eventId, String[] projection) {
            String[] remArgs = new String[]{Long.toString(eventId)};
            return cr.query(CONTENT_URI, projection, "event_id=?", remArgs, null);
        }

        static void __staticInitializer__() {
            CONTENT_URI = Uri.parse("content://com.android.calendar/reminders");
        }

        private void __constructor__() {
            this.$$robo$$android_provider_CalendarContract_Reminders$__constructor__();
        }

        private Reminders() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_CalendarContract_Reminders$__constructor__(), 0, this);
        }

        public static Cursor query(ContentResolver contentResolver, long l, String[] stringArray) {
            return InvokeDynamicSupport.bootstrapStatic("query", $$robo$$android_provider_CalendarContract_Reminders$query(android.content.ContentResolver long java.lang.String[] ), 0, (ContentResolver)contentResolver, (long)l, (String[])stringArray);
        }

        static {
            RobolectricInternals.classInitializing(Reminders.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Reminders)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    protected static interface RemindersColumns
    extends InstrumentedInterface {
        public static final String EVENT_ID = "event_id";
        public static final String MINUTES = "minutes";
        public static final int MINUTES_DEFAULT = -1;
        public static final String METHOD = "method";
        public static final int METHOD_DEFAULT = 0;
        public static final int METHOD_ALERT = 1;
        public static final int METHOD_EMAIL = 2;
        public static final int METHOD_SMS = 3;
        public static final int METHOD_ALARM = 4;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class EventDays
    implements EventDaysColumns,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static Uri CONTENT_URI;
        private static String SELECTION = "selected=1";

        private void $$robo$$android_provider_CalendarContract_EventDays$__constructor__() {
        }

        private static final Cursor $$robo$$android_provider_CalendarContract_EventDays$query(ContentResolver cr, int startDay, int numDays, String[] projection) {
            if (numDays < 1) {
                return null;
            }
            int endDay = startDay + numDays - 1;
            Uri.Builder builder = CONTENT_URI.buildUpon();
            ContentUris.appendId(builder, startDay);
            ContentUris.appendId(builder, endDay);
            return cr.query(builder.build(), projection, "selected=1", null, "startDay");
        }

        static void __staticInitializer__() {
            CONTENT_URI = Uri.parse("content://com.android.calendar/instances/groupbyday");
        }

        private void __constructor__() {
            this.$$robo$$android_provider_CalendarContract_EventDays$__constructor__();
        }

        private EventDays() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_CalendarContract_EventDays$__constructor__(), 0, this);
        }

        public static Cursor query(ContentResolver contentResolver, int n, int n2, String[] stringArray) {
            return InvokeDynamicSupport.bootstrapStatic("query", $$robo$$android_provider_CalendarContract_EventDays$query(android.content.ContentResolver int int java.lang.String[] ), 0, (ContentResolver)contentResolver, (int)n, (int)n2, (String[])stringArray);
        }

        static {
            RobolectricInternals.classInitializing(EventDays.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EventDays)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    protected static interface EventDaysColumns
    extends InstrumentedInterface {
        public static final String STARTDAY = "startDay";
        public static final String ENDDAY = "endDay";
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class CalendarMetaData
    implements CalendarMetaDataColumns,
    BaseColumns,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_provider_CalendarContract_CalendarMetaData$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_provider_CalendarContract_CalendarMetaData$__constructor__();
        }

        private CalendarMetaData() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_CalendarContract_CalendarMetaData$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CalendarMetaData)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    protected static interface CalendarMetaDataColumns
    extends InstrumentedInterface {
        public static final String LOCAL_TIMEZONE = "localTimezone";
        public static final String MIN_INSTANCE = "minInstance";
        public static final String MAX_INSTANCE = "maxInstance";
        public static final String MIN_EVENTDAYS = "minEventDays";
        public static final String MAX_EVENTDAYS = "maxEventDays";
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class CalendarCache
    implements CalendarCacheColumns,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static Uri URI;
        public static String KEY_TIMEZONE_TYPE = "timezoneType";
        public static String KEY_TIMEZONE_INSTANCES = "timezoneInstances";
        public static String KEY_TIMEZONE_INSTANCES_PREVIOUS = "timezoneInstancesPrevious";
        public static String TIMEZONE_TYPE_AUTO = "auto";
        public static String TIMEZONE_TYPE_HOME = "home";

        private void $$robo$$android_provider_CalendarContract_CalendarCache$__constructor__() {
        }

        static void __staticInitializer__() {
            URI = Uri.parse("content://com.android.calendar/properties");
        }

        private void __constructor__() {
            this.$$robo$$android_provider_CalendarContract_CalendarCache$__constructor__();
        }

        private CalendarCache() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_CalendarContract_CalendarCache$__constructor__(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(CalendarCache.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CalendarCache)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    protected static interface CalendarCacheColumns
    extends InstrumentedInterface {
        public static final String KEY = "key";
        public static final String VALUE = "value";
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Instances
    implements BaseColumns,
    EventsColumns,
    CalendarColumns,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static String WHERE_CALENDARS_SELECTED = "visible=?";
        private static String[] WHERE_CALENDARS_ARGS;
        public static Uri CONTENT_URI;
        public static Uri CONTENT_BY_DAY_URI;
        public static Uri CONTENT_SEARCH_URI;
        public static Uri CONTENT_SEARCH_BY_DAY_URI;
        private static String DEFAULT_SORT_ORDER = "begin ASC";
        public static String BEGIN = "begin";
        public static String END = "end";
        public static String EVENT_ID = "event_id";
        public static String START_DAY = "startDay";
        public static String END_DAY = "endDay";
        public static String START_MINUTE = "startMinute";
        public static String END_MINUTE = "endMinute";

        private void $$robo$$android_provider_CalendarContract_Instances$__constructor__() {
        }

        private static final Cursor $$robo$$android_provider_CalendarContract_Instances$query(ContentResolver cr, String[] projection, long begin, long end) {
            Uri.Builder builder = CONTENT_URI.buildUpon();
            ContentUris.appendId(builder, begin);
            ContentUris.appendId(builder, end);
            return cr.query(builder.build(), projection, "visible=?", WHERE_CALENDARS_ARGS, "begin ASC");
        }

        private static final Cursor $$robo$$android_provider_CalendarContract_Instances$query(ContentResolver cr, String[] projection, long begin, long end, String searchQuery) {
            Uri.Builder builder = CONTENT_SEARCH_URI.buildUpon();
            ContentUris.appendId(builder, begin);
            ContentUris.appendId(builder, end);
            builder = builder.appendPath(searchQuery);
            return cr.query(builder.build(), projection, "visible=?", WHERE_CALENDARS_ARGS, "begin ASC");
        }

        static void __staticInitializer__() {
            WHERE_CALENDARS_ARGS = new String[]{"1"};
            CONTENT_URI = Uri.parse("content://com.android.calendar/instances/when");
            CONTENT_BY_DAY_URI = Uri.parse("content://com.android.calendar/instances/whenbyday");
            CONTENT_SEARCH_URI = Uri.parse("content://com.android.calendar/instances/search");
            CONTENT_SEARCH_BY_DAY_URI = Uri.parse("content://com.android.calendar/instances/searchbyday");
        }

        private void __constructor__() {
            this.$$robo$$android_provider_CalendarContract_Instances$__constructor__();
        }

        private Instances() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_CalendarContract_Instances$__constructor__(), 0, this);
        }

        public static Cursor query(ContentResolver contentResolver, String[] stringArray, long l, long l2) {
            return InvokeDynamicSupport.bootstrapStatic("query", $$robo$$android_provider_CalendarContract_Instances$query(android.content.ContentResolver java.lang.String[] long long ), 0, (ContentResolver)contentResolver, (String[])stringArray, (long)l, (long)l2);
        }

        public static Cursor query(ContentResolver contentResolver, String[] stringArray, long l, long l2, String string2) {
            return InvokeDynamicSupport.bootstrapStatic("query", $$robo$$android_provider_CalendarContract_Instances$query(android.content.ContentResolver java.lang.String[] long long java.lang.String ), 0, (ContentResolver)contentResolver, (String[])stringArray, (long)l, (long)l2, (String)string2);
        }

        static {
            RobolectricInternals.classInitializing(Instances.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Instances)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Events
    implements BaseColumns,
    SyncColumns,
    EventsColumns,
    CalendarColumns,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static Uri CONTENT_URI;
        public static Uri CONTENT_EXCEPTION_URI;
        private static String DEFAULT_SORT_ORDER = "";
        public static String[] PROVIDER_WRITABLE_COLUMNS;
        public static String[] SYNC_WRITABLE_COLUMNS;

        private void $$robo$$android_provider_CalendarContract_Events$__constructor__() {
        }

        static void __staticInitializer__() {
            CONTENT_URI = Uri.parse("content://com.android.calendar/events");
            CONTENT_EXCEPTION_URI = Uri.parse("content://com.android.calendar/exception");
            PROVIDER_WRITABLE_COLUMNS = new String[]{"account_name", "account_type", "cal_sync1", "cal_sync2", "cal_sync3", "cal_sync4", "cal_sync5", "cal_sync6", "cal_sync7", "cal_sync8", "cal_sync9", "cal_sync10", "allowedReminders", "allowedAttendeeTypes", "allowedAvailability", "calendar_access_level", "calendar_color", "calendar_timezone", "canModifyTimeZone", "canOrganizerRespond", "calendar_displayName", "canPartiallyUpdate", "sync_events", "visible"};
            SYNC_WRITABLE_COLUMNS = new String[]{"_sync_id", "dirty", "mutators", "sync_data1", "sync_data2", "sync_data3", "sync_data4", "sync_data5", "sync_data6", "sync_data7", "sync_data8", "sync_data9", "sync_data10"};
        }

        private void __constructor__() {
            this.$$robo$$android_provider_CalendarContract_Events$__constructor__();
        }

        private Events() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_CalendarContract_Events$__constructor__(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(Events.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Events)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class EventsEntity
    implements BaseColumns,
    SyncColumns,
    EventsColumns,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static Uri CONTENT_URI;

        private void $$robo$$android_provider_CalendarContract_EventsEntity$__constructor__() {
        }

        private static final EntityIterator $$robo$$android_provider_CalendarContract_EventsEntity$newEntityIterator(Cursor cursor, ContentResolver resolver) {
            return new EntityIteratorImpl(cursor, resolver);
        }

        private static final EntityIterator $$robo$$android_provider_CalendarContract_EventsEntity$newEntityIterator(Cursor cursor, ContentProviderClient provider) {
            return new EntityIteratorImpl(cursor, provider);
        }

        static void __staticInitializer__() {
            CONTENT_URI = Uri.parse("content://com.android.calendar/event_entities");
        }

        private void __constructor__() {
            this.$$robo$$android_provider_CalendarContract_EventsEntity$__constructor__();
        }

        private EventsEntity() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_CalendarContract_EventsEntity$__constructor__(), 0, this);
        }

        public static EntityIterator newEntityIterator(Cursor cursor, ContentResolver contentResolver) {
            return InvokeDynamicSupport.bootstrapStatic("newEntityIterator", $$robo$$android_provider_CalendarContract_EventsEntity$newEntityIterator(android.database.Cursor android.content.ContentResolver ), 0, (Cursor)cursor, (ContentResolver)contentResolver);
        }

        public static EntityIterator newEntityIterator(Cursor cursor, ContentProviderClient contentProviderClient) {
            return InvokeDynamicSupport.bootstrapStatic("newEntityIterator", $$robo$$android_provider_CalendarContract_EventsEntity$newEntityIterator(android.database.Cursor android.content.ContentProviderClient ), 0, (Cursor)cursor, (ContentProviderClient)contentProviderClient);
        }

        static {
            RobolectricInternals.classInitializing(EventsEntity.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EventsEntity)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private static class EntityIteratorImpl
        extends CursorEntityIterator
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            private ContentResolver mResolver;
            private ContentProviderClient mProvider;
            private static String[] REMINDERS_PROJECTION;
            private static int COLUMN_MINUTES = 0;
            private static int COLUMN_METHOD = 1;
            private static String[] ATTENDEES_PROJECTION;
            private static int COLUMN_ATTENDEE_NAME = 0;
            private static int COLUMN_ATTENDEE_EMAIL = 1;
            private static int COLUMN_ATTENDEE_RELATIONSHIP = 2;
            private static int COLUMN_ATTENDEE_TYPE = 3;
            private static int COLUMN_ATTENDEE_STATUS = 4;
            private static int COLUMN_ATTENDEE_IDENTITY = 5;
            private static int COLUMN_ATTENDEE_ID_NAMESPACE = 6;
            private static String[] EXTENDED_PROJECTION;
            private static int COLUMN_ID = 0;
            private static int COLUMN_NAME = 1;
            private static int COLUMN_VALUE = 2;
            private static String WHERE_EVENT_ID = "event_id=?";

            private void $$robo$$android_provider_CalendarContract_EventsEntity_EntityIteratorImpl$__constructor__(Cursor cursor, ContentResolver resolver) {
                this.mResolver = resolver;
                this.mProvider = null;
            }

            private void $$robo$$android_provider_CalendarContract_EventsEntity_EntityIteratorImpl$__constructor__(Cursor cursor, ContentProviderClient provider) {
                this.mResolver = null;
                this.mProvider = provider;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final Entity $$robo$$android_provider_CalendarContract_EventsEntity_EntityIteratorImpl$getEntityAndIncrementCursor(Cursor cursor) throws RemoteException {
                long eventId = cursor.getLong(cursor.getColumnIndexOrThrow("_id"));
                ContentValues cv = new ContentValues();
                cv.put("_id", eventId);
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, cv, "calendar_id");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "title");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "description");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "eventLocation");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, cv, "eventStatus");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, cv, "selfAttendeeStatus");
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, cv, "dtstart");
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, cv, "dtend");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "duration");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "eventTimezone");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "eventEndTimezone");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "allDay");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, cv, "accessLevel");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, cv, "availability");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, cv, "eventColor");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "eventColor_index");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "hasAlarm");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "hasExtendedProperties");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "rrule");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "rdate");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "exrule");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "exdate");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "original_sync_id");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "original_id");
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, cv, "originalInstanceTime");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, cv, "originalAllDay");
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, cv, "lastDate");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, cv, "hasAttendeeData");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, cv, "guestsCanInviteOthers");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, cv, "guestsCanModify");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, cv, "guestsCanSeeGuests");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "customAppPackage");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "customAppUri");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "uid2445");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "organizer");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "isOrganizer");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "_sync_id");
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, cv, "dirty");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "mutators");
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, cv, "lastSynced");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, cv, "deleted");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "sync_data1");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "sync_data2");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "sync_data3");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "sync_data4");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "sync_data5");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "sync_data6");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "sync_data7");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "sync_data8");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "sync_data9");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "sync_data10");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "cal_sync1");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "cal_sync2");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "cal_sync3");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "cal_sync4");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "cal_sync5");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "cal_sync6");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "cal_sync7");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "cal_sync8");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "cal_sync9");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "cal_sync10");
                Entity entity = new Entity(cv);
                try (Cursor subCursor = this.mResolver != null ? this.mResolver.query(Reminders.CONTENT_URI, REMINDERS_PROJECTION, "event_id=?", new String[]{Long.toString(eventId)}, null) : this.mProvider.query(Reminders.CONTENT_URI, REMINDERS_PROJECTION, "event_id=?", new String[]{Long.toString(eventId)}, null);){
                    while (subCursor.moveToNext()) {
                        ContentValues reminderValues = new ContentValues();
                        reminderValues.put("minutes", subCursor.getInt(0));
                        reminderValues.put("method", subCursor.getInt(1));
                        entity.addSubValue(Reminders.CONTENT_URI, reminderValues);
                    }
                }
                subCursor = this.mResolver != null ? this.mResolver.query(Attendees.CONTENT_URI, ATTENDEES_PROJECTION, "event_id=?", new String[]{Long.toString(eventId)}, null) : this.mProvider.query(Attendees.CONTENT_URI, ATTENDEES_PROJECTION, "event_id=?", new String[]{Long.toString(eventId)}, null);
                try {
                    while (subCursor.moveToNext()) {
                        ContentValues attendeeValues = new ContentValues();
                        attendeeValues.put("attendeeName", subCursor.getString(0));
                        attendeeValues.put("attendeeEmail", subCursor.getString(1));
                        attendeeValues.put("attendeeRelationship", subCursor.getInt(2));
                        attendeeValues.put("attendeeType", subCursor.getInt(3));
                        attendeeValues.put("attendeeStatus", subCursor.getInt(4));
                        attendeeValues.put("attendeeIdentity", subCursor.getString(5));
                        attendeeValues.put("attendeeIdNamespace", subCursor.getString(6));
                        entity.addSubValue(Attendees.CONTENT_URI, attendeeValues);
                    }
                }
                finally {
                    subCursor.close();
                }
                subCursor = this.mResolver != null ? this.mResolver.query(ExtendedProperties.CONTENT_URI, EXTENDED_PROJECTION, "event_id=?", new String[]{Long.toString(eventId)}, null) : this.mProvider.query(ExtendedProperties.CONTENT_URI, EXTENDED_PROJECTION, "event_id=?", new String[]{Long.toString(eventId)}, null);
                try {
                    while (subCursor.moveToNext()) {
                        ContentValues extendedValues = new ContentValues();
                        extendedValues.put("_id", subCursor.getString(0));
                        extendedValues.put("name", subCursor.getString(1));
                        extendedValues.put("value", subCursor.getString(2));
                        entity.addSubValue(ExtendedProperties.CONTENT_URI, extendedValues);
                    }
                }
                finally {
                    subCursor.close();
                }
                cursor.moveToNext();
                return entity;
            }

            static void __staticInitializer__() {
                REMINDERS_PROJECTION = new String[]{"minutes", "method"};
                ATTENDEES_PROJECTION = new String[]{"attendeeName", "attendeeEmail", "attendeeRelationship", "attendeeType", "attendeeStatus", "attendeeIdentity", "attendeeIdNamespace"};
                EXTENDED_PROJECTION = new String[]{"_id", "name", "value"};
            }

            private void __constructor__(Cursor cursor, ContentResolver contentResolver) {
                this.$$robo$$android_provider_CalendarContract_EventsEntity_EntityIteratorImpl$__constructor__(cursor, contentResolver);
            }

            public EntityIteratorImpl(Cursor cursor, ContentResolver contentResolver) {
                super(cursor);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_CalendarContract_EventsEntity_EntityIteratorImpl$__constructor__(android.database.Cursor android.content.ContentResolver ), 0, this, cursor, contentResolver);
            }

            private void __constructor__(Cursor cursor, ContentProviderClient contentProviderClient) {
                this.$$robo$$android_provider_CalendarContract_EventsEntity_EntityIteratorImpl$__constructor__(cursor, contentProviderClient);
            }

            public EntityIteratorImpl(Cursor cursor, ContentProviderClient contentProviderClient) {
                super(cursor);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_CalendarContract_EventsEntity_EntityIteratorImpl$__constructor__(android.database.Cursor android.content.ContentProviderClient ), 0, this, cursor, contentProviderClient);
            }

            @Override
            public Entity getEntityAndIncrementCursor(Cursor cursor) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getEntityAndIncrementCursor", $$robo$$android_provider_CalendarContract_EventsEntity_EntityIteratorImpl$getEntityAndIncrementCursor(android.database.Cursor ), 0, this, cursor);
            }

            static {
                RobolectricInternals.classInitializing(EntityIteratorImpl.class);
            }

            public /* synthetic */ EntityIteratorImpl() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EntityIteratorImpl)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    protected static interface EventsColumns
    extends InstrumentedInterface {
        public static final String CALENDAR_ID = "calendar_id";
        public static final String TITLE = "title";
        public static final String DESCRIPTION = "description";
        public static final String EVENT_LOCATION = "eventLocation";
        public static final String EVENT_COLOR = "eventColor";
        public static final String EVENT_COLOR_KEY = "eventColor_index";
        public static final String DISPLAY_COLOR = "displayColor";
        public static final String STATUS = "eventStatus";
        public static final int STATUS_TENTATIVE = 0;
        public static final int STATUS_CONFIRMED = 1;
        public static final int STATUS_CANCELED = 2;
        public static final String SELF_ATTENDEE_STATUS = "selfAttendeeStatus";
        public static final String SYNC_DATA1 = "sync_data1";
        public static final String SYNC_DATA2 = "sync_data2";
        public static final String SYNC_DATA3 = "sync_data3";
        public static final String SYNC_DATA4 = "sync_data4";
        public static final String SYNC_DATA5 = "sync_data5";
        public static final String SYNC_DATA6 = "sync_data6";
        public static final String SYNC_DATA7 = "sync_data7";
        public static final String SYNC_DATA8 = "sync_data8";
        public static final String SYNC_DATA9 = "sync_data9";
        public static final String SYNC_DATA10 = "sync_data10";
        public static final String LAST_SYNCED = "lastSynced";
        public static final String DTSTART = "dtstart";
        public static final String DTEND = "dtend";
        public static final String DURATION = "duration";
        public static final String EVENT_TIMEZONE = "eventTimezone";
        public static final String EVENT_END_TIMEZONE = "eventEndTimezone";
        public static final String ALL_DAY = "allDay";
        public static final String ACCESS_LEVEL = "accessLevel";
        public static final int ACCESS_DEFAULT = 0;
        public static final int ACCESS_CONFIDENTIAL = 1;
        public static final int ACCESS_PRIVATE = 2;
        public static final int ACCESS_PUBLIC = 3;
        public static final String AVAILABILITY = "availability";
        public static final int AVAILABILITY_BUSY = 0;
        public static final int AVAILABILITY_FREE = 1;
        public static final int AVAILABILITY_TENTATIVE = 2;
        public static final String HAS_ALARM = "hasAlarm";
        public static final String HAS_EXTENDED_PROPERTIES = "hasExtendedProperties";
        public static final String RRULE = "rrule";
        public static final String RDATE = "rdate";
        public static final String EXRULE = "exrule";
        public static final String EXDATE = "exdate";
        public static final String ORIGINAL_ID = "original_id";
        public static final String ORIGINAL_SYNC_ID = "original_sync_id";
        public static final String ORIGINAL_INSTANCE_TIME = "originalInstanceTime";
        public static final String ORIGINAL_ALL_DAY = "originalAllDay";
        public static final String LAST_DATE = "lastDate";
        public static final String HAS_ATTENDEE_DATA = "hasAttendeeData";
        public static final String GUESTS_CAN_MODIFY = "guestsCanModify";
        public static final String GUESTS_CAN_INVITE_OTHERS = "guestsCanInviteOthers";
        public static final String GUESTS_CAN_SEE_GUESTS = "guestsCanSeeGuests";
        public static final String ORGANIZER = "organizer";
        public static final String IS_ORGANIZER = "isOrganizer";
        public static final String CAN_INVITE_OTHERS = "canInviteOthers";
        public static final String CUSTOM_APP_PACKAGE = "customAppPackage";
        public static final String CUSTOM_APP_URI = "customAppUri";
        public static final String UID_2445 = "uid2445";
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Attendees
    implements BaseColumns,
    AttendeesColumns,
    EventsColumns,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static Uri CONTENT_URI;
        private static String ATTENDEES_WHERE = "event_id=?";

        private void $$robo$$android_provider_CalendarContract_Attendees$__constructor__() {
        }

        private static final Cursor $$robo$$android_provider_CalendarContract_Attendees$query(ContentResolver cr, long eventId, String[] projection) {
            String[] attArgs = new String[]{Long.toString(eventId)};
            return cr.query(CONTENT_URI, projection, "event_id=?", attArgs, null);
        }

        static void __staticInitializer__() {
            CONTENT_URI = Uri.parse("content://com.android.calendar/attendees");
        }

        private void __constructor__() {
            this.$$robo$$android_provider_CalendarContract_Attendees$__constructor__();
        }

        private Attendees() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_CalendarContract_Attendees$__constructor__(), 0, this);
        }

        public static Cursor query(ContentResolver contentResolver, long l, String[] stringArray) {
            return InvokeDynamicSupport.bootstrapStatic("query", $$robo$$android_provider_CalendarContract_Attendees$query(android.content.ContentResolver long java.lang.String[] ), 0, (ContentResolver)contentResolver, (long)l, (String[])stringArray);
        }

        static {
            RobolectricInternals.classInitializing(Attendees.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Attendees)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    protected static interface AttendeesColumns
    extends InstrumentedInterface {
        public static final String EVENT_ID = "event_id";
        public static final String ATTENDEE_NAME = "attendeeName";
        public static final String ATTENDEE_EMAIL = "attendeeEmail";
        public static final String ATTENDEE_RELATIONSHIP = "attendeeRelationship";
        public static final int RELATIONSHIP_NONE = 0;
        public static final int RELATIONSHIP_ATTENDEE = 1;
        public static final int RELATIONSHIP_ORGANIZER = 2;
        public static final int RELATIONSHIP_PERFORMER = 3;
        public static final int RELATIONSHIP_SPEAKER = 4;
        public static final String ATTENDEE_TYPE = "attendeeType";
        public static final int TYPE_NONE = 0;
        public static final int TYPE_REQUIRED = 1;
        public static final int TYPE_OPTIONAL = 2;
        public static final int TYPE_RESOURCE = 3;
        public static final String ATTENDEE_STATUS = "attendeeStatus";
        public static final int ATTENDEE_STATUS_NONE = 0;
        public static final int ATTENDEE_STATUS_ACCEPTED = 1;
        public static final int ATTENDEE_STATUS_DECLINED = 2;
        public static final int ATTENDEE_STATUS_INVITED = 3;
        public static final int ATTENDEE_STATUS_TENTATIVE = 4;
        public static final String ATTENDEE_IDENTITY = "attendeeIdentity";
        public static final String ATTENDEE_ID_NAMESPACE = "attendeeIdNamespace";
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Calendars
    implements BaseColumns,
    SyncColumns,
    CalendarColumns,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static Uri CONTENT_URI;
        public static String DEFAULT_SORT_ORDER = "calendar_displayName";
        public static String NAME = "name";
        public static String CALENDAR_LOCATION = "calendar_location";
        public static String[] SYNC_WRITABLE_COLUMNS;

        private void $$robo$$android_provider_CalendarContract_Calendars$__constructor__() {
        }

        static void __staticInitializer__() {
            CONTENT_URI = Uri.parse("content://com.android.calendar/calendars");
            SYNC_WRITABLE_COLUMNS = new String[]{"account_name", "account_type", "_sync_id", "dirty", "mutators", "ownerAccount", "maxReminders", "allowedReminders", "canModifyTimeZone", "canOrganizerRespond", "canPartiallyUpdate", "calendar_location", "calendar_timezone", "calendar_access_level", "deleted", "cal_sync1", "cal_sync2", "cal_sync3", "cal_sync4", "cal_sync5", "cal_sync6", "cal_sync7", "cal_sync8", "cal_sync9", "cal_sync10"};
        }

        private void __constructor__() {
            this.$$robo$$android_provider_CalendarContract_Calendars$__constructor__();
        }

        private Calendars() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_CalendarContract_Calendars$__constructor__(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(Calendars.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Calendars)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class CalendarEntity
    implements BaseColumns,
    SyncColumns,
    CalendarColumns,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static Uri CONTENT_URI;

        private void $$robo$$android_provider_CalendarContract_CalendarEntity$__constructor__() {
        }

        private static final EntityIterator $$robo$$android_provider_CalendarContract_CalendarEntity$newEntityIterator(Cursor cursor) {
            return new EntityIteratorImpl(cursor);
        }

        static void __staticInitializer__() {
            CONTENT_URI = Uri.parse("content://com.android.calendar/calendar_entities");
        }

        private void __constructor__() {
            this.$$robo$$android_provider_CalendarContract_CalendarEntity$__constructor__();
        }

        private CalendarEntity() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_CalendarContract_CalendarEntity$__constructor__(), 0, this);
        }

        public static EntityIterator newEntityIterator(Cursor cursor) {
            return InvokeDynamicSupport.bootstrapStatic("newEntityIterator", $$robo$$android_provider_CalendarContract_CalendarEntity$newEntityIterator(android.database.Cursor ), 0, (Cursor)cursor);
        }

        static {
            RobolectricInternals.classInitializing(CalendarEntity.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CalendarEntity)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private static class EntityIteratorImpl
        extends CursorEntityIterator
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_provider_CalendarContract_CalendarEntity_EntityIteratorImpl$__constructor__(Cursor cursor) {
            }

            private final Entity $$robo$$android_provider_CalendarContract_CalendarEntity_EntityIteratorImpl$getEntityAndIncrementCursor(Cursor cursor) throws RemoteException {
                long calendarId = cursor.getLong(cursor.getColumnIndexOrThrow("_id"));
                ContentValues cv = new ContentValues();
                cv.put("_id", calendarId);
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "account_name");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "account_type");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "_sync_id");
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, cv, "dirty");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "mutators");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "cal_sync1");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "cal_sync2");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "cal_sync3");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "cal_sync4");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "cal_sync5");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "cal_sync6");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "cal_sync7");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "cal_sync8");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "cal_sync9");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "cal_sync10");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "name");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "calendar_displayName");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, cv, "calendar_color");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "calendar_color_index");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, cv, "calendar_access_level");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, cv, "visible");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, cv, "sync_events");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "calendar_location");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "calendar_timezone");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "ownerAccount");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, cv, "canOrganizerRespond");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, cv, "canModifyTimeZone");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, cv, "maxReminders");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, cv, "canPartiallyUpdate");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "allowedReminders");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, cv, "deleted");
                Entity entity = new Entity(cv);
                cursor.moveToNext();
                return entity;
            }

            private void __constructor__(Cursor cursor) {
                this.$$robo$$android_provider_CalendarContract_CalendarEntity_EntityIteratorImpl$__constructor__(cursor);
            }

            public EntityIteratorImpl(Cursor cursor) {
                super(cursor);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_CalendarContract_CalendarEntity_EntityIteratorImpl$__constructor__(android.database.Cursor ), 0, this, cursor);
            }

            @Override
            public Entity getEntityAndIncrementCursor(Cursor cursor) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getEntityAndIncrementCursor", $$robo$$android_provider_CalendarContract_CalendarEntity_EntityIteratorImpl$getEntityAndIncrementCursor(android.database.Cursor ), 0, this, cursor);
            }

            public /* synthetic */ EntityIteratorImpl() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EntityIteratorImpl)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    protected static interface CalendarColumns
    extends InstrumentedInterface {
        public static final String CALENDAR_COLOR = "calendar_color";
        public static final String CALENDAR_COLOR_KEY = "calendar_color_index";
        public static final String CALENDAR_DISPLAY_NAME = "calendar_displayName";
        public static final String CALENDAR_ACCESS_LEVEL = "calendar_access_level";
        public static final int CAL_ACCESS_NONE = 0;
        public static final int CAL_ACCESS_FREEBUSY = 100;
        public static final int CAL_ACCESS_READ = 200;
        public static final int CAL_ACCESS_RESPOND = 300;
        public static final int CAL_ACCESS_OVERRIDE = 400;
        public static final int CAL_ACCESS_CONTRIBUTOR = 500;
        public static final int CAL_ACCESS_EDITOR = 600;
        public static final int CAL_ACCESS_OWNER = 700;
        public static final int CAL_ACCESS_ROOT = 800;
        public static final String VISIBLE = "visible";
        public static final String CALENDAR_TIME_ZONE = "calendar_timezone";
        public static final String SYNC_EVENTS = "sync_events";
        public static final String OWNER_ACCOUNT = "ownerAccount";
        public static final String CAN_ORGANIZER_RESPOND = "canOrganizerRespond";
        public static final String CAN_MODIFY_TIME_ZONE = "canModifyTimeZone";
        public static final String MAX_REMINDERS = "maxReminders";
        public static final String ALLOWED_REMINDERS = "allowedReminders";
        public static final String ALLOWED_AVAILABILITY = "allowedAvailability";
        public static final String ALLOWED_ATTENDEE_TYPES = "allowedAttendeeTypes";
        public static final String IS_PRIMARY = "isPrimary";
    }

    protected static interface SyncColumns
    extends CalendarSyncColumns,
    InstrumentedInterface {
        public static final String ACCOUNT_NAME = "account_name";
        public static final String ACCOUNT_TYPE = "account_type";
        public static final String _SYNC_ID = "_sync_id";
        public static final String DIRTY = "dirty";
        public static final String MUTATORS = "mutators";
        public static final String DELETED = "deleted";
        public static final String CAN_PARTIALLY_UPDATE = "canPartiallyUpdate";
    }

    protected static interface CalendarSyncColumns
    extends InstrumentedInterface {
        public static final String CAL_SYNC1 = "cal_sync1";
        public static final String CAL_SYNC2 = "cal_sync2";
        public static final String CAL_SYNC3 = "cal_sync3";
        public static final String CAL_SYNC4 = "cal_sync4";
        public static final String CAL_SYNC5 = "cal_sync5";
        public static final String CAL_SYNC6 = "cal_sync6";
        public static final String CAL_SYNC7 = "cal_sync7";
        public static final String CAL_SYNC8 = "cal_sync8";
        public static final String CAL_SYNC9 = "cal_sync9";
        public static final String CAL_SYNC10 = "cal_sync10";
    }
}

