/*
 * Decompiled with CFR 0.152.
 */
package android.print;

import android.app.Activity;
import android.app.Application;
import android.content.ComponentName;
import android.content.Context;
import android.content.IntentSender;
import android.graphics.drawable.Icon;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.Handler;
import android.os.ICancellationSignal;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.print.ILayoutResultCallback;
import android.print.IPrintDocumentAdapter;
import android.print.IPrintDocumentAdapterObserver;
import android.print.IPrintJobStateChangeListener;
import android.print.IPrintManager;
import android.print.IPrintServicesChangeListener;
import android.print.IWriteResultCallback;
import android.print.PageRange;
import android.print.PrintAttributes;
import android.print.PrintDocumentAdapter;
import android.print.PrintDocumentInfo;
import android.print.PrintJob;
import android.print.PrintJobId;
import android.print.PrintJobInfo;
import android.print.PrinterDiscoverySession;
import android.print.PrinterId;
import android.printservice.PrintServiceInfo;
import android.printservice.recommendation.IRecommendationsChangeListener;
import android.printservice.recommendation.RecommendationInfo;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Log;
import com.android.internal.os.SomeArgs;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import libcore.io.IoUtils;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class PrintManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "PrintManager";
    private static boolean DEBUG = false;
    private static int MSG_NOTIFY_PRINT_JOB_STATE_CHANGED = 1;
    private static int MSG_NOTIFY_PRINT_SERVICES_CHANGED = 2;
    private static int MSG_NOTIFY_PRINT_SERVICE_RECOMMENDATIONS_CHANGED = 3;
    public static String PRINT_SPOOLER_PACKAGE_NAME = "com.android.printspooler";
    public static int ENABLED_SERVICES = 1;
    public static int DISABLED_SERVICES = 2;
    public static int ALL_SERVICES = 3;
    public static String ACTION_PRINT_DIALOG = "android.print.PRINT_DIALOG";
    public static String EXTRA_PRINT_DIALOG_INTENT = "android.print.intent.extra.EXTRA_PRINT_DIALOG_INTENT";
    public static String EXTRA_PRINT_JOB = "android.print.intent.extra.EXTRA_PRINT_JOB";
    public static String EXTRA_PRINT_DOCUMENT_ADAPTER = "android.print.intent.extra.EXTRA_PRINT_DOCUMENT_ADAPTER";
    public static int APP_ID_ANY = -2;
    private Context mContext;
    private IPrintManager mService;
    private int mUserId;
    private int mAppId;
    private Handler mHandler;
    private Map<PrintJobStateChangeListener, PrintJobStateChangeListenerWrapper> mPrintJobStateChangeListeners;
    private Map<PrintServicesChangeListener, PrintServicesChangeListenerWrapper> mPrintServicesChangeListeners;
    private Map<PrintServiceRecommendationsChangeListener, PrintServiceRecommendationsChangeListenerWrapper> mPrintServiceRecommendationsChangeListeners;

    private void $$robo$$android_print_PrintManager$__constructor__(Context context, IPrintManager service, int userId, int appId) {
        this.mContext = context;
        this.mService = service;
        this.mUserId = userId;
        this.mAppId = appId;
        this.mHandler = new ShadowedObject(this, context.getMainLooper(), null, false){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ PrintManager this$0;

            private void $$robo$$android_print_PrintManager_1$__constructor__(PrintManager this$0, Looper looper, Handler.Callback callback, boolean async) {
            }

            private final void $$robo$$android_print_PrintManager_1$handleMessage(Message message) {
                switch (message.what) {
                    case 1: {
                        SomeArgs args = (SomeArgs)message.obj;
                        PrintJobStateChangeListenerWrapper wrapper = (PrintJobStateChangeListenerWrapper)args.arg1;
                        PrintJobStateChangeListener listener = wrapper.getListener();
                        if (listener != null) {
                            PrintJobId printJobId = (PrintJobId)args.arg2;
                            listener.onPrintJobStateChanged(printJobId);
                        }
                        args.recycle();
                        break;
                    }
                    case 2: {
                        PrintServicesChangeListenerWrapper wrapper = (PrintServicesChangeListenerWrapper)message.obj;
                        PrintServicesChangeListener listener = wrapper.getListener();
                        if (listener == null) break;
                        listener.onPrintServicesChanged();
                        break;
                    }
                    case 3: {
                        PrintServiceRecommendationsChangeListenerWrapper wrapper = (PrintServiceRecommendationsChangeListenerWrapper)message.obj;
                        PrintServiceRecommendationsChangeListener listener = wrapper.getListener();
                        if (listener == null) break;
                        listener.onPrintServiceRecommendationsChanged();
                    }
                }
            }

            private void __constructor__(PrintManager printManager, Looper looper, Handler.Callback callback, boolean bl) {
                this.$$robo$$android_print_PrintManager_1$__constructor__(printManager, looper, callback, bl);
            }
            {
                this.this$0 = printManager;
                super(looper, callback, bl);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_print_PrintManager_1$__constructor__(android.print.PrintManager android.os.Looper android.os.Handler$Callback boolean ), 0, this, printManager, looper, callback, bl);
            }

            @Override
            public void handleMessage(Message message) {
                InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_print_PrintManager_1$handleMessage(android.os.Message ), 0, this, message);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private final PrintManager $$robo$$android_print_PrintManager$getGlobalPrintManagerForUser(int userId) {
        if (this.mService == null) {
            Log.w("PrintManager", "Feature android.software.print not available");
            return null;
        }
        return new PrintManager(this.mContext, this.mService, userId, -2);
    }

    private final PrintJobInfo $$robo$$android_print_PrintManager$getPrintJobInfo(PrintJobId printJobId) {
        try {
            return this.mService.getPrintJobInfo(printJobId, this.mAppId, this.mUserId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_print_PrintManager$addPrintJobStateChangeListener(PrintJobStateChangeListener listener) {
        if (this.mService == null) {
            Log.w("PrintManager", "Feature android.software.print not available");
            return;
        }
        if (this.mPrintJobStateChangeListeners == null) {
            this.mPrintJobStateChangeListeners = new ArrayMap<PrintJobStateChangeListener, PrintJobStateChangeListenerWrapper>();
        }
        PrintJobStateChangeListenerWrapper wrappedListener = new PrintJobStateChangeListenerWrapper(listener, this.mHandler);
        try {
            this.mService.addPrintJobStateChangeListener(wrappedListener, this.mAppId, this.mUserId);
            this.mPrintJobStateChangeListeners.put(listener, wrappedListener);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_print_PrintManager$removePrintJobStateChangeListener(PrintJobStateChangeListener listener) {
        if (this.mService == null) {
            Log.w("PrintManager", "Feature android.software.print not available");
            return;
        }
        if (this.mPrintJobStateChangeListeners == null) {
            return;
        }
        PrintJobStateChangeListenerWrapper wrappedListener = this.mPrintJobStateChangeListeners.remove(listener);
        if (wrappedListener == null) {
            return;
        }
        if (this.mPrintJobStateChangeListeners.isEmpty()) {
            this.mPrintJobStateChangeListeners = null;
        }
        wrappedListener.destroy();
        try {
            this.mService.removePrintJobStateChangeListener(wrappedListener, this.mUserId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final PrintJob $$robo$$android_print_PrintManager$getPrintJob(PrintJobId printJobId) {
        if (this.mService == null) {
            Log.w("PrintManager", "Feature android.software.print not available");
            return null;
        }
        try {
            PrintJobInfo printJob = this.mService.getPrintJobInfo(printJobId, this.mAppId, this.mUserId);
            if (printJob != null) {
                return new PrintJob(printJob, this);
            }
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
        return null;
    }

    private final Icon $$robo$$android_print_PrintManager$getCustomPrinterIcon(PrinterId printerId) {
        if (this.mService == null) {
            Log.w("PrintManager", "Feature android.software.print not available");
            return null;
        }
        try {
            return this.mService.getCustomPrinterIcon(printerId, this.mUserId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final List<PrintJob> $$robo$$android_print_PrintManager$getPrintJobs() {
        if (this.mService == null) {
            Log.w("PrintManager", "Feature android.software.print not available");
            return Collections.emptyList();
        }
        try {
            List<PrintJobInfo> printJobInfos = this.mService.getPrintJobInfos(this.mAppId, this.mUserId);
            if (printJobInfos == null) {
                return Collections.emptyList();
            }
            int printJobCount = printJobInfos.size();
            ArrayList<PrintJob> printJobs = new ArrayList<PrintJob>(printJobCount);
            for (int i = 0; i < printJobCount; ++i) {
                printJobs.add(new PrintJob(printJobInfos.get(i), this));
            }
            return printJobs;
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_print_PrintManager$cancelPrintJob(PrintJobId printJobId) {
        if (this.mService == null) {
            Log.w("PrintManager", "Feature android.software.print not available");
            return;
        }
        try {
            this.mService.cancelPrintJob(printJobId, this.mAppId, this.mUserId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_print_PrintManager$restartPrintJob(PrintJobId printJobId) {
        if (this.mService == null) {
            Log.w("PrintManager", "Feature android.software.print not available");
            return;
        }
        try {
            this.mService.restartPrintJob(printJobId, this.mAppId, this.mUserId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final PrintJob $$robo$$android_print_PrintManager$print(String printJobName, PrintDocumentAdapter documentAdapter, PrintAttributes attributes) {
        if (this.mService == null) {
            Log.w("PrintManager", "Feature android.software.print not available");
            return null;
        }
        if (!(this.mContext instanceof Activity)) {
            throw new IllegalStateException("Can print only from an activity");
        }
        if (TextUtils.isEmpty(printJobName)) {
            throw new IllegalArgumentException("printJobName cannot be empty");
        }
        if (documentAdapter == null) {
            throw new IllegalArgumentException("documentAdapter cannot be null");
        }
        PrintDocumentAdapterDelegate delegate = new PrintDocumentAdapterDelegate((Activity)this.mContext, documentAdapter);
        try {
            Bundle result = this.mService.print(printJobName, delegate, attributes, this.mContext.getPackageName(), this.mAppId, this.mUserId);
            if (result != null) {
                PrintJobInfo printJob = (PrintJobInfo)result.getParcelable("android.print.intent.extra.EXTRA_PRINT_JOB");
                IntentSender intent = (IntentSender)result.getParcelable("android.print.intent.extra.EXTRA_PRINT_DIALOG_INTENT");
                if (printJob == null || intent == null) {
                    return null;
                }
                try {
                    this.mContext.startIntentSender(intent, null, 0, 0, 0);
                    return new PrintJob(printJob, this);
                }
                catch (IntentSender.SendIntentException sie) {
                    Log.e("PrintManager", "Couldn't start print job config activity.", sie);
                }
            }
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
        return null;
    }

    private final void $$robo$$android_print_PrintManager$addPrintServicesChangeListener(PrintServicesChangeListener listener) {
        Preconditions.checkNotNull(listener);
        if (this.mService == null) {
            Log.w("PrintManager", "Feature android.software.print not available");
            return;
        }
        if (this.mPrintServicesChangeListeners == null) {
            this.mPrintServicesChangeListeners = new ArrayMap<PrintServicesChangeListener, PrintServicesChangeListenerWrapper>();
        }
        PrintServicesChangeListenerWrapper wrappedListener = new PrintServicesChangeListenerWrapper(listener, this.mHandler);
        try {
            this.mService.addPrintServicesChangeListener(wrappedListener, this.mUserId);
            this.mPrintServicesChangeListeners.put(listener, wrappedListener);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_print_PrintManager$removePrintServicesChangeListener(PrintServicesChangeListener listener) {
        Preconditions.checkNotNull(listener);
        if (this.mService == null) {
            Log.w("PrintManager", "Feature android.software.print not available");
            return;
        }
        if (this.mPrintServicesChangeListeners == null) {
            return;
        }
        PrintServicesChangeListenerWrapper wrappedListener = this.mPrintServicesChangeListeners.remove(listener);
        if (wrappedListener == null) {
            return;
        }
        if (this.mPrintServicesChangeListeners.isEmpty()) {
            this.mPrintServicesChangeListeners = null;
        }
        wrappedListener.destroy();
        try {
            this.mService.removePrintServicesChangeListener(wrappedListener, this.mUserId);
        }
        catch (RemoteException re) {
            Log.e("PrintManager", "Error removing print services change listener", re);
        }
    }

    private final List<PrintServiceInfo> $$robo$$android_print_PrintManager$getPrintServices(int selectionFlags) {
        Preconditions.checkFlagsArgument(selectionFlags, 3);
        try {
            List<PrintServiceInfo> services = this.mService.getPrintServices(selectionFlags, this.mUserId);
            if (services != null) {
                return services;
            }
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
        return Collections.emptyList();
    }

    private final void $$robo$$android_print_PrintManager$addPrintServiceRecommendationsChangeListener(PrintServiceRecommendationsChangeListener listener) {
        Preconditions.checkNotNull(listener);
        if (this.mService == null) {
            Log.w("PrintManager", "Feature android.software.print not available");
            return;
        }
        if (this.mPrintServiceRecommendationsChangeListeners == null) {
            this.mPrintServiceRecommendationsChangeListeners = new ArrayMap<PrintServiceRecommendationsChangeListener, PrintServiceRecommendationsChangeListenerWrapper>();
        }
        PrintServiceRecommendationsChangeListenerWrapper wrappedListener = new PrintServiceRecommendationsChangeListenerWrapper(listener, this.mHandler);
        try {
            this.mService.addPrintServiceRecommendationsChangeListener(wrappedListener, this.mUserId);
            this.mPrintServiceRecommendationsChangeListeners.put(listener, wrappedListener);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_print_PrintManager$removePrintServiceRecommendationsChangeListener(PrintServiceRecommendationsChangeListener listener) {
        Preconditions.checkNotNull(listener);
        if (this.mService == null) {
            Log.w("PrintManager", "Feature android.software.print not available");
            return;
        }
        if (this.mPrintServiceRecommendationsChangeListeners == null) {
            return;
        }
        PrintServiceRecommendationsChangeListenerWrapper wrappedListener = this.mPrintServiceRecommendationsChangeListeners.remove(listener);
        if (wrappedListener == null) {
            return;
        }
        if (this.mPrintServiceRecommendationsChangeListeners.isEmpty()) {
            this.mPrintServiceRecommendationsChangeListeners = null;
        }
        wrappedListener.destroy();
        try {
            this.mService.removePrintServiceRecommendationsChangeListener(wrappedListener, this.mUserId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final List<RecommendationInfo> $$robo$$android_print_PrintManager$getPrintServiceRecommendations() {
        try {
            List<RecommendationInfo> recommendations = this.mService.getPrintServiceRecommendations(this.mUserId);
            if (recommendations != null) {
                return recommendations;
            }
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
        return Collections.emptyList();
    }

    private final PrinterDiscoverySession $$robo$$android_print_PrintManager$createPrinterDiscoverySession() {
        if (this.mService == null) {
            Log.w("PrintManager", "Feature android.software.print not available");
            return null;
        }
        return new PrinterDiscoverySession(this.mService, this.mContext, this.mUserId);
    }

    private final void $$robo$$android_print_PrintManager$setPrintServiceEnabled(ComponentName service, boolean isEnabled) {
        if (this.mService == null) {
            Log.w("PrintManager", "Feature android.software.print not available");
            return;
        }
        try {
            this.mService.setPrintServiceEnabled(service, isEnabled, this.mUserId);
        }
        catch (RemoteException re) {
            Log.e("PrintManager", "Error enabling or disabling " + service, re);
        }
    }

    private void __constructor__(Context context, IPrintManager iPrintManager, int n, int n2) {
        this.$$robo$$android_print_PrintManager$__constructor__(context, iPrintManager, n, n2);
    }

    public PrintManager(Context context, IPrintManager iPrintManager, int n, int n2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_print_PrintManager$__constructor__(android.content.Context android.print.IPrintManager int int ), 0, this, context, iPrintManager, n, n2);
    }

    public PrintManager getGlobalPrintManagerForUser(int n) {
        return InvokeDynamicSupport.bootstrap("getGlobalPrintManagerForUser", $$robo$$android_print_PrintManager$getGlobalPrintManagerForUser(int ), 0, this, n);
    }

    PrintJobInfo getPrintJobInfo(PrintJobId printJobId) {
        return InvokeDynamicSupport.bootstrap("getPrintJobInfo", $$robo$$android_print_PrintManager$getPrintJobInfo(android.print.PrintJobId ), 0, this, printJobId);
    }

    public void addPrintJobStateChangeListener(PrintJobStateChangeListener printJobStateChangeListener) {
        InvokeDynamicSupport.bootstrap("addPrintJobStateChangeListener", $$robo$$android_print_PrintManager$addPrintJobStateChangeListener(android.print.PrintManager$PrintJobStateChangeListener ), 0, this, printJobStateChangeListener);
    }

    public void removePrintJobStateChangeListener(PrintJobStateChangeListener printJobStateChangeListener) {
        InvokeDynamicSupport.bootstrap("removePrintJobStateChangeListener", $$robo$$android_print_PrintManager$removePrintJobStateChangeListener(android.print.PrintManager$PrintJobStateChangeListener ), 0, this, printJobStateChangeListener);
    }

    public PrintJob getPrintJob(PrintJobId printJobId) {
        return InvokeDynamicSupport.bootstrap("getPrintJob", $$robo$$android_print_PrintManager$getPrintJob(android.print.PrintJobId ), 0, this, printJobId);
    }

    public Icon getCustomPrinterIcon(PrinterId printerId) {
        return InvokeDynamicSupport.bootstrap("getCustomPrinterIcon", $$robo$$android_print_PrintManager$getCustomPrinterIcon(android.print.PrinterId ), 0, this, printerId);
    }

    public List<PrintJob> getPrintJobs() {
        return InvokeDynamicSupport.bootstrap("getPrintJobs", $$robo$$android_print_PrintManager$getPrintJobs(), 0, this);
    }

    void cancelPrintJob(PrintJobId printJobId) {
        InvokeDynamicSupport.bootstrap("cancelPrintJob", $$robo$$android_print_PrintManager$cancelPrintJob(android.print.PrintJobId ), 0, this, printJobId);
    }

    void restartPrintJob(PrintJobId printJobId) {
        InvokeDynamicSupport.bootstrap("restartPrintJob", $$robo$$android_print_PrintManager$restartPrintJob(android.print.PrintJobId ), 0, this, printJobId);
    }

    public PrintJob print(String string2, PrintDocumentAdapter printDocumentAdapter, PrintAttributes printAttributes) {
        return InvokeDynamicSupport.bootstrap("print", $$robo$$android_print_PrintManager$print(java.lang.String android.print.PrintDocumentAdapter android.print.PrintAttributes ), 0, this, string2, printDocumentAdapter, printAttributes);
    }

    void addPrintServicesChangeListener(PrintServicesChangeListener printServicesChangeListener) {
        InvokeDynamicSupport.bootstrap("addPrintServicesChangeListener", $$robo$$android_print_PrintManager$addPrintServicesChangeListener(android.print.PrintManager$PrintServicesChangeListener ), 0, this, printServicesChangeListener);
    }

    void removePrintServicesChangeListener(PrintServicesChangeListener printServicesChangeListener) {
        InvokeDynamicSupport.bootstrap("removePrintServicesChangeListener", $$robo$$android_print_PrintManager$removePrintServicesChangeListener(android.print.PrintManager$PrintServicesChangeListener ), 0, this, printServicesChangeListener);
    }

    public List<PrintServiceInfo> getPrintServices(int n) {
        return InvokeDynamicSupport.bootstrap("getPrintServices", $$robo$$android_print_PrintManager$getPrintServices(int ), 0, this, n);
    }

    void addPrintServiceRecommendationsChangeListener(PrintServiceRecommendationsChangeListener printServiceRecommendationsChangeListener) {
        InvokeDynamicSupport.bootstrap("addPrintServiceRecommendationsChangeListener", $$robo$$android_print_PrintManager$addPrintServiceRecommendationsChangeListener(android.print.PrintManager$PrintServiceRecommendationsChangeListener ), 0, this, printServiceRecommendationsChangeListener);
    }

    void removePrintServiceRecommendationsChangeListener(PrintServiceRecommendationsChangeListener printServiceRecommendationsChangeListener) {
        InvokeDynamicSupport.bootstrap("removePrintServiceRecommendationsChangeListener", $$robo$$android_print_PrintManager$removePrintServiceRecommendationsChangeListener(android.print.PrintManager$PrintServiceRecommendationsChangeListener ), 0, this, printServiceRecommendationsChangeListener);
    }

    public List<RecommendationInfo> getPrintServiceRecommendations() {
        return InvokeDynamicSupport.bootstrap("getPrintServiceRecommendations", $$robo$$android_print_PrintManager$getPrintServiceRecommendations(), 0, this);
    }

    public PrinterDiscoverySession createPrinterDiscoverySession() {
        return InvokeDynamicSupport.bootstrap("createPrinterDiscoverySession", $$robo$$android_print_PrintManager$createPrinterDiscoverySession(), 0, this);
    }

    public void setPrintServiceEnabled(ComponentName componentName, boolean bl) {
        InvokeDynamicSupport.bootstrap("setPrintServiceEnabled", $$robo$$android_print_PrintManager$setPrintServiceEnabled(android.content.ComponentName boolean ), 0, this, componentName, bl);
    }

    public /* synthetic */ PrintManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PrintManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class PrintServiceRecommendationsChangeListenerWrapper
    extends IRecommendationsChangeListener.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private WeakReference<PrintServiceRecommendationsChangeListener> mWeakListener;
        private WeakReference<Handler> mWeakHandler;

        private void $$robo$$android_print_PrintManager_PrintServiceRecommendationsChangeListenerWrapper$__constructor__(PrintServiceRecommendationsChangeListener listener, Handler handler) {
            this.mWeakListener = new WeakReference<PrintServiceRecommendationsChangeListener>(listener);
            this.mWeakHandler = new WeakReference<Handler>(handler);
        }

        private final void $$robo$$android_print_PrintManager_PrintServiceRecommendationsChangeListenerWrapper$onRecommendationsChanged() {
            Handler handler = (Handler)this.mWeakHandler.get();
            PrintServiceRecommendationsChangeListener listener = (PrintServiceRecommendationsChangeListener)this.mWeakListener.get();
            if (handler != null && listener != null) {
                handler.obtainMessage(3, this).sendToTarget();
            }
        }

        private final void $$robo$$android_print_PrintManager_PrintServiceRecommendationsChangeListenerWrapper$destroy() {
            this.mWeakListener.clear();
        }

        private final PrintServiceRecommendationsChangeListener $$robo$$android_print_PrintManager_PrintServiceRecommendationsChangeListenerWrapper$getListener() {
            return (PrintServiceRecommendationsChangeListener)this.mWeakListener.get();
        }

        private void __constructor__(PrintServiceRecommendationsChangeListener printServiceRecommendationsChangeListener, Handler handler) {
            this.$$robo$$android_print_PrintManager_PrintServiceRecommendationsChangeListenerWrapper$__constructor__(printServiceRecommendationsChangeListener, handler);
        }

        public PrintServiceRecommendationsChangeListenerWrapper(PrintServiceRecommendationsChangeListener printServiceRecommendationsChangeListener, Handler handler) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_print_PrintManager_PrintServiceRecommendationsChangeListenerWrapper$__constructor__(android.print.PrintManager$PrintServiceRecommendationsChangeListener android.os.Handler ), 0, this, printServiceRecommendationsChangeListener, handler);
        }

        @Override
        public void onRecommendationsChanged() {
            InvokeDynamicSupport.bootstrap("onRecommendationsChanged", $$robo$$android_print_PrintManager_PrintServiceRecommendationsChangeListenerWrapper$onRecommendationsChanged(), 0, this);
        }

        public void destroy() {
            InvokeDynamicSupport.bootstrap("destroy", $$robo$$android_print_PrintManager_PrintServiceRecommendationsChangeListenerWrapper$destroy(), 0, this);
        }

        public PrintServiceRecommendationsChangeListener getListener() {
            return InvokeDynamicSupport.bootstrap("getListener", $$robo$$android_print_PrintManager_PrintServiceRecommendationsChangeListenerWrapper$getListener(), 0, this);
        }

        public /* synthetic */ PrintServiceRecommendationsChangeListenerWrapper() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PrintServiceRecommendationsChangeListenerWrapper)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class PrintServicesChangeListenerWrapper
    extends IPrintServicesChangeListener.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private WeakReference<PrintServicesChangeListener> mWeakListener;
        private WeakReference<Handler> mWeakHandler;

        private void $$robo$$android_print_PrintManager_PrintServicesChangeListenerWrapper$__constructor__(PrintServicesChangeListener listener, Handler handler) {
            this.mWeakListener = new WeakReference<PrintServicesChangeListener>(listener);
            this.mWeakHandler = new WeakReference<Handler>(handler);
        }

        private final void $$robo$$android_print_PrintManager_PrintServicesChangeListenerWrapper$onPrintServicesChanged() {
            Handler handler = (Handler)this.mWeakHandler.get();
            PrintServicesChangeListener listener = (PrintServicesChangeListener)this.mWeakListener.get();
            if (handler != null && listener != null) {
                handler.obtainMessage(2, this).sendToTarget();
            }
        }

        private final void $$robo$$android_print_PrintManager_PrintServicesChangeListenerWrapper$destroy() {
            this.mWeakListener.clear();
        }

        private final PrintServicesChangeListener $$robo$$android_print_PrintManager_PrintServicesChangeListenerWrapper$getListener() {
            return (PrintServicesChangeListener)this.mWeakListener.get();
        }

        private void __constructor__(PrintServicesChangeListener printServicesChangeListener, Handler handler) {
            this.$$robo$$android_print_PrintManager_PrintServicesChangeListenerWrapper$__constructor__(printServicesChangeListener, handler);
        }

        public PrintServicesChangeListenerWrapper(PrintServicesChangeListener printServicesChangeListener, Handler handler) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_print_PrintManager_PrintServicesChangeListenerWrapper$__constructor__(android.print.PrintManager$PrintServicesChangeListener android.os.Handler ), 0, this, printServicesChangeListener, handler);
        }

        @Override
        public void onPrintServicesChanged() {
            InvokeDynamicSupport.bootstrap("onPrintServicesChanged", $$robo$$android_print_PrintManager_PrintServicesChangeListenerWrapper$onPrintServicesChanged(), 0, this);
        }

        public void destroy() {
            InvokeDynamicSupport.bootstrap("destroy", $$robo$$android_print_PrintManager_PrintServicesChangeListenerWrapper$destroy(), 0, this);
        }

        public PrintServicesChangeListener getListener() {
            return InvokeDynamicSupport.bootstrap("getListener", $$robo$$android_print_PrintManager_PrintServicesChangeListenerWrapper$getListener(), 0, this);
        }

        public /* synthetic */ PrintServicesChangeListenerWrapper() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PrintServicesChangeListenerWrapper)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class PrintJobStateChangeListenerWrapper
    extends IPrintJobStateChangeListener.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private WeakReference<PrintJobStateChangeListener> mWeakListener;
        private WeakReference<Handler> mWeakHandler;

        private void $$robo$$android_print_PrintManager_PrintJobStateChangeListenerWrapper$__constructor__(PrintJobStateChangeListener listener, Handler handler) {
            this.mWeakListener = new WeakReference<PrintJobStateChangeListener>(listener);
            this.mWeakHandler = new WeakReference<Handler>(handler);
        }

        private final void $$robo$$android_print_PrintManager_PrintJobStateChangeListenerWrapper$onPrintJobStateChanged(PrintJobId printJobId) {
            Handler handler = (Handler)this.mWeakHandler.get();
            PrintJobStateChangeListener listener = (PrintJobStateChangeListener)this.mWeakListener.get();
            if (handler != null && listener != null) {
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = this;
                args.arg2 = printJobId;
                handler.obtainMessage(1, args).sendToTarget();
            }
        }

        private final void $$robo$$android_print_PrintManager_PrintJobStateChangeListenerWrapper$destroy() {
            this.mWeakListener.clear();
        }

        private final PrintJobStateChangeListener $$robo$$android_print_PrintManager_PrintJobStateChangeListenerWrapper$getListener() {
            return (PrintJobStateChangeListener)this.mWeakListener.get();
        }

        private void __constructor__(PrintJobStateChangeListener printJobStateChangeListener, Handler handler) {
            this.$$robo$$android_print_PrintManager_PrintJobStateChangeListenerWrapper$__constructor__(printJobStateChangeListener, handler);
        }

        public PrintJobStateChangeListenerWrapper(PrintJobStateChangeListener printJobStateChangeListener, Handler handler) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_print_PrintManager_PrintJobStateChangeListenerWrapper$__constructor__(android.print.PrintManager$PrintJobStateChangeListener android.os.Handler ), 0, this, printJobStateChangeListener, handler);
        }

        @Override
        public void onPrintJobStateChanged(PrintJobId printJobId) {
            InvokeDynamicSupport.bootstrap("onPrintJobStateChanged", $$robo$$android_print_PrintManager_PrintJobStateChangeListenerWrapper$onPrintJobStateChanged(android.print.PrintJobId ), 0, this, printJobId);
        }

        public void destroy() {
            InvokeDynamicSupport.bootstrap("destroy", $$robo$$android_print_PrintManager_PrintJobStateChangeListenerWrapper$destroy(), 0, this);
        }

        public PrintJobStateChangeListener getListener() {
            return InvokeDynamicSupport.bootstrap("getListener", $$robo$$android_print_PrintManager_PrintJobStateChangeListenerWrapper$getListener(), 0, this);
        }

        public /* synthetic */ PrintJobStateChangeListenerWrapper() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PrintJobStateChangeListenerWrapper)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class PrintDocumentAdapterDelegate
    extends IPrintDocumentAdapter.Stub
    implements Application.ActivityLifecycleCallbacks,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Object mLock;
        private Activity mActivity;
        private PrintDocumentAdapter mDocumentAdapter;
        private Handler mHandler;
        private IPrintDocumentAdapterObserver mObserver;
        private DestroyableCallback mPendingCallback;

        private void $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate$__constructor__(Activity activity, PrintDocumentAdapter documentAdapter) {
            this.mLock = new Object();
            if (activity.isFinishing()) {
                throw new IllegalStateException("Cannot start printing for finishing activity");
            }
            this.mActivity = activity;
            this.mDocumentAdapter = documentAdapter;
            this.mHandler = new MyHandler(this, this.mActivity.getMainLooper());
            this.mActivity.getApplication().registerActivityLifecycleCallbacks(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate$setObserver(IPrintDocumentAdapterObserver observer) {
            boolean destroyed;
            Object object = this.mLock;
            synchronized (object) {
                this.mObserver = observer;
                destroyed = this.isDestroyedLocked();
            }
            if (destroyed && observer != null) {
                try {
                    observer.onDestroy();
                }
                catch (RemoteException re) {
                    Log.e("PrintManager", "Error announcing destroyed state", re);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate$start() {
            Object object = this.mLock;
            synchronized (object) {
                if (!this.isDestroyedLocked()) {
                    this.mHandler.obtainMessage(1, this.mDocumentAdapter).sendToTarget();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate$layout(PrintAttributes oldAttributes, PrintAttributes newAttributes, ILayoutResultCallback callback, Bundle metadata, int sequence) {
            ICancellationSignal cancellationTransport = CancellationSignal.createTransport();
            try {
                callback.onLayoutStarted(cancellationTransport, sequence);
            }
            catch (RemoteException re) {
                Log.e("PrintManager", "Error notifying for layout start", re);
                return;
            }
            Object object = this.mLock;
            synchronized (object) {
                if (this.isDestroyedLocked()) {
                    return;
                }
                CancellationSignal cancellationSignal = CancellationSignal.fromTransport(cancellationTransport);
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = this.mDocumentAdapter;
                args.arg2 = oldAttributes;
                args.arg3 = newAttributes;
                args.arg4 = cancellationSignal;
                args.arg5 = new MyLayoutResultCallback(this, callback, sequence);
                args.arg6 = metadata;
                this.mHandler.obtainMessage(2, args).sendToTarget();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate$write(PageRange[] pages, ParcelFileDescriptor fd, IWriteResultCallback callback, int sequence) {
            ICancellationSignal cancellationTransport = CancellationSignal.createTransport();
            try {
                callback.onWriteStarted(cancellationTransport, sequence);
            }
            catch (RemoteException re) {
                Log.e("PrintManager", "Error notifying for write start", re);
                return;
            }
            Object object = this.mLock;
            synchronized (object) {
                if (this.isDestroyedLocked()) {
                    return;
                }
                CancellationSignal cancellationSignal = CancellationSignal.fromTransport(cancellationTransport);
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = this.mDocumentAdapter;
                args.arg2 = pages;
                args.arg3 = fd;
                args.arg4 = cancellationSignal;
                args.arg5 = new MyWriteResultCallback(this, callback, fd, sequence);
                this.mHandler.obtainMessage(3, args).sendToTarget();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate$finish() {
            Object object = this.mLock;
            synchronized (object) {
                if (!this.isDestroyedLocked()) {
                    this.mHandler.obtainMessage(4, this.mDocumentAdapter).sendToTarget();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate$kill(String reason) {
            Object object = this.mLock;
            synchronized (object) {
                if (!this.isDestroyedLocked()) {
                    this.mHandler.obtainMessage(5, reason).sendToTarget();
                }
            }
        }

        private final void $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate$onActivityPaused(Activity activity) {
        }

        private final void $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate$onActivityCreated(Activity activity, Bundle savedInstanceState) {
        }

        private final void $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate$onActivityStarted(Activity activity) {
        }

        private final void $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate$onActivityResumed(Activity activity) {
        }

        private final void $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate$onActivityStopped(Activity activity) {
        }

        private final void $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate$onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate$onActivityDestroyed(Activity activity) {
            IPrintDocumentAdapterObserver observer = null;
            Object object = this.mLock;
            synchronized (object) {
                if (activity == this.mActivity) {
                    observer = this.mObserver;
                    this.destroyLocked();
                }
            }
            if (observer != null) {
                try {
                    observer.onDestroy();
                }
                catch (RemoteException re) {
                    Log.e("PrintManager", "Error announcing destroyed state", re);
                }
            }
        }

        private final boolean $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate$isDestroyedLocked() {
            return this.mActivity == null;
        }

        private final void $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate$destroyLocked() {
            this.mActivity.getApplication().unregisterActivityLifecycleCallbacks(this);
            this.mActivity = null;
            this.mDocumentAdapter = null;
            this.mHandler.removeMessages(1);
            this.mHandler.removeMessages(2);
            this.mHandler.removeMessages(3);
            this.mHandler.removeMessages(4);
            this.mHandler = null;
            this.mObserver = null;
            if (this.mPendingCallback != null) {
                this.mPendingCallback.destroy();
                this.mPendingCallback = null;
            }
        }

        private void __constructor__(Activity activity, PrintDocumentAdapter printDocumentAdapter) {
            this.$$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate$__constructor__(activity, printDocumentAdapter);
        }

        public PrintDocumentAdapterDelegate(Activity activity, PrintDocumentAdapter printDocumentAdapter) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate$__constructor__(android.app.Activity android.print.PrintDocumentAdapter ), 0, this, activity, printDocumentAdapter);
        }

        @Override
        public void setObserver(IPrintDocumentAdapterObserver iPrintDocumentAdapterObserver) {
            InvokeDynamicSupport.bootstrap("setObserver", $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate$setObserver(android.print.IPrintDocumentAdapterObserver ), 0, this, iPrintDocumentAdapterObserver);
        }

        @Override
        public void start() {
            InvokeDynamicSupport.bootstrap("start", $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate$start(), 0, this);
        }

        @Override
        public void layout(PrintAttributes printAttributes, PrintAttributes printAttributes2, ILayoutResultCallback iLayoutResultCallback, Bundle bundle, int n) {
            InvokeDynamicSupport.bootstrap("layout", $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate$layout(android.print.PrintAttributes android.print.PrintAttributes android.print.ILayoutResultCallback android.os.Bundle int ), 0, this, printAttributes, printAttributes2, iLayoutResultCallback, bundle, n);
        }

        @Override
        public void write(PageRange[] pageRangeArray, ParcelFileDescriptor parcelFileDescriptor, IWriteResultCallback iWriteResultCallback, int n) {
            InvokeDynamicSupport.bootstrap("write", $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate$write(android.print.PageRange[] android.os.ParcelFileDescriptor android.print.IWriteResultCallback int ), 0, this, pageRangeArray, parcelFileDescriptor, iWriteResultCallback, n);
        }

        @Override
        public void finish() {
            InvokeDynamicSupport.bootstrap("finish", $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate$finish(), 0, this);
        }

        @Override
        public void kill(String string2) {
            InvokeDynamicSupport.bootstrap("kill", $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate$kill(java.lang.String ), 0, this, string2);
        }

        @Override
        public void onActivityPaused(Activity activity) {
            InvokeDynamicSupport.bootstrap("onActivityPaused", $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate$onActivityPaused(android.app.Activity ), 0, this, activity);
        }

        @Override
        public void onActivityCreated(Activity activity, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onActivityCreated", $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate$onActivityCreated(android.app.Activity android.os.Bundle ), 0, this, activity, bundle);
        }

        @Override
        public void onActivityStarted(Activity activity) {
            InvokeDynamicSupport.bootstrap("onActivityStarted", $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate$onActivityStarted(android.app.Activity ), 0, this, activity);
        }

        @Override
        public void onActivityResumed(Activity activity) {
            InvokeDynamicSupport.bootstrap("onActivityResumed", $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate$onActivityResumed(android.app.Activity ), 0, this, activity);
        }

        @Override
        public void onActivityStopped(Activity activity) {
            InvokeDynamicSupport.bootstrap("onActivityStopped", $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate$onActivityStopped(android.app.Activity ), 0, this, activity);
        }

        @Override
        public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onActivitySaveInstanceState", $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate$onActivitySaveInstanceState(android.app.Activity android.os.Bundle ), 0, this, activity, bundle);
        }

        @Override
        public void onActivityDestroyed(Activity activity) {
            InvokeDynamicSupport.bootstrap("onActivityDestroyed", $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate$onActivityDestroyed(android.app.Activity ), 0, this, activity);
        }

        private boolean isDestroyedLocked() {
            return (boolean)InvokeDynamicSupport.bootstrap("isDestroyedLocked", $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate$isDestroyedLocked(), 0, this);
        }

        private void destroyLocked() {
            InvokeDynamicSupport.bootstrap("destroyLocked", $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate$destroyLocked(), 0, this);
        }

        public /* synthetic */ PrintDocumentAdapterDelegate() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PrintDocumentAdapterDelegate)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
        private final class MyWriteResultCallback
        extends PrintDocumentAdapter.WriteResultCallback
        implements DestroyableCallback,
        ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            private ParcelFileDescriptor mFd;
            private IWriteResultCallback mCallback;
            private int mSequence;
            /* synthetic */ PrintDocumentAdapterDelegate this$0;

            private void $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate_MyWriteResultCallback$__constructor__(PrintDocumentAdapterDelegate printDocumentAdapterDelegate, IWriteResultCallback callback, ParcelFileDescriptor fd, int sequence) {
                this.mFd = fd;
                this.mSequence = sequence;
                this.mCallback = callback;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate_MyWriteResultCallback$onWriteFinished(PageRange[] pages) {
                IWriteResultCallback callback;
                Object object = this.this$0.mLock;
                synchronized (object) {
                    callback = this.mCallback;
                }
                if (callback == null) {
                    Log.e("PrintManager", "PrintDocumentAdapter is destroyed. Did you finish the printing activity before print completion or did you invoke a callback after finish?");
                    return;
                }
                try {
                    if (pages == null) {
                        throw new IllegalArgumentException("pages cannot be null");
                    }
                    if (pages.length == 0) {
                        throw new IllegalArgumentException("pages cannot be empty");
                    }
                    try {
                        callback.onWriteFinished(pages, this.mSequence);
                    }
                    catch (RemoteException re) {
                        Log.e("PrintManager", "Error calling onWriteFinished", re);
                    }
                }
                finally {
                    this.destroy();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate_MyWriteResultCallback$onWriteFailed(CharSequence error) {
                IWriteResultCallback callback;
                Object object = this.this$0.mLock;
                synchronized (object) {
                    callback = this.mCallback;
                }
                if (callback == null) {
                    Log.e("PrintManager", "PrintDocumentAdapter is destroyed. Did you finish the printing activity before print completion or did you invoke a callback after finish?");
                    return;
                }
                try {
                    callback.onWriteFailed(error, this.mSequence);
                }
                catch (RemoteException re) {
                    Log.e("PrintManager", "Error calling onWriteFailed", re);
                }
                finally {
                    this.destroy();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate_MyWriteResultCallback$onWriteCancelled() {
                IWriteResultCallback callback;
                Object object = this.this$0.mLock;
                synchronized (object) {
                    callback = this.mCallback;
                }
                if (callback == null) {
                    Log.e("PrintManager", "PrintDocumentAdapter is destroyed. Did you finish the printing activity before print completion or did you invoke a callback after finish?");
                    return;
                }
                try {
                    callback.onWriteCanceled(this.mSequence);
                }
                catch (RemoteException re) {
                    Log.e("PrintManager", "Error calling onWriteCanceled", re);
                }
                finally {
                    this.destroy();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate_MyWriteResultCallback$destroy() {
                Object object = this.this$0.mLock;
                synchronized (object) {
                    IoUtils.closeQuietly(this.mFd);
                    this.mCallback = null;
                    this.mFd = null;
                    this.this$0.mPendingCallback = null;
                }
            }

            private void __constructor__(PrintDocumentAdapterDelegate printDocumentAdapterDelegate, IWriteResultCallback iWriteResultCallback, ParcelFileDescriptor parcelFileDescriptor, int n) {
                this.$$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate_MyWriteResultCallback$__constructor__(printDocumentAdapterDelegate, iWriteResultCallback, parcelFileDescriptor, n);
            }

            public MyWriteResultCallback(PrintDocumentAdapterDelegate printDocumentAdapterDelegate, IWriteResultCallback iWriteResultCallback, ParcelFileDescriptor parcelFileDescriptor, int n) {
                this.this$0 = printDocumentAdapterDelegate;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate_MyWriteResultCallback$__constructor__(android.print.PrintManager$PrintDocumentAdapterDelegate android.print.IWriteResultCallback android.os.ParcelFileDescriptor int ), 0, this, printDocumentAdapterDelegate, iWriteResultCallback, parcelFileDescriptor, n);
            }

            @Override
            public void onWriteFinished(PageRange[] pageRangeArray) {
                InvokeDynamicSupport.bootstrap("onWriteFinished", $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate_MyWriteResultCallback$onWriteFinished(android.print.PageRange[] ), 0, this, pageRangeArray);
            }

            @Override
            public void onWriteFailed(CharSequence charSequence) {
                InvokeDynamicSupport.bootstrap("onWriteFailed", $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate_MyWriteResultCallback$onWriteFailed(java.lang.CharSequence ), 0, this, charSequence);
            }

            @Override
            public void onWriteCancelled() {
                InvokeDynamicSupport.bootstrap("onWriteCancelled", $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate_MyWriteResultCallback$onWriteCancelled(), 0, this);
            }

            @Override
            public void destroy() {
                InvokeDynamicSupport.bootstrap("destroy", $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate_MyWriteResultCallback$destroy(), 0, this);
            }

            public /* synthetic */ MyWriteResultCallback() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MyWriteResultCallback)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
        private final class MyLayoutResultCallback
        extends PrintDocumentAdapter.LayoutResultCallback
        implements DestroyableCallback,
        ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            private ILayoutResultCallback mCallback;
            private int mSequence;
            /* synthetic */ PrintDocumentAdapterDelegate this$0;

            private void $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate_MyLayoutResultCallback$__constructor__(PrintDocumentAdapterDelegate printDocumentAdapterDelegate, ILayoutResultCallback callback, int sequence) {
                this.mCallback = callback;
                this.mSequence = sequence;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate_MyLayoutResultCallback$onLayoutFinished(PrintDocumentInfo info, boolean changed) {
                ILayoutResultCallback callback;
                Object object = this.this$0.mLock;
                synchronized (object) {
                    callback = this.mCallback;
                }
                if (callback == null) {
                    Log.e("PrintManager", "PrintDocumentAdapter is destroyed. Did you finish the printing activity before print completion or did you invoke a callback after finish?");
                    return;
                }
                try {
                    if (info == null) {
                        throw new NullPointerException("document info cannot be null");
                    }
                    try {
                        callback.onLayoutFinished(info, changed, this.mSequence);
                    }
                    catch (RemoteException re) {
                        Log.e("PrintManager", "Error calling onLayoutFinished", re);
                    }
                }
                finally {
                    this.destroy();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate_MyLayoutResultCallback$onLayoutFailed(CharSequence error) {
                ILayoutResultCallback callback;
                Object object = this.this$0.mLock;
                synchronized (object) {
                    callback = this.mCallback;
                }
                if (callback == null) {
                    Log.e("PrintManager", "PrintDocumentAdapter is destroyed. Did you finish the printing activity before print completion or did you invoke a callback after finish?");
                    return;
                }
                try {
                    callback.onLayoutFailed(error, this.mSequence);
                }
                catch (RemoteException re) {
                    Log.e("PrintManager", "Error calling onLayoutFailed", re);
                }
                finally {
                    this.destroy();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate_MyLayoutResultCallback$onLayoutCancelled() {
                ILayoutResultCallback callback;
                Object object = this.this$0.mLock;
                synchronized (object) {
                    callback = this.mCallback;
                }
                if (callback == null) {
                    Log.e("PrintManager", "PrintDocumentAdapter is destroyed. Did you finish the printing activity before print completion or did you invoke a callback after finish?");
                    return;
                }
                try {
                    callback.onLayoutCanceled(this.mSequence);
                }
                catch (RemoteException re) {
                    Log.e("PrintManager", "Error calling onLayoutFailed", re);
                }
                finally {
                    this.destroy();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate_MyLayoutResultCallback$destroy() {
                Object object = this.this$0.mLock;
                synchronized (object) {
                    this.mCallback = null;
                    this.this$0.mPendingCallback = null;
                }
            }

            private void __constructor__(PrintDocumentAdapterDelegate printDocumentAdapterDelegate, ILayoutResultCallback iLayoutResultCallback, int n) {
                this.$$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate_MyLayoutResultCallback$__constructor__(printDocumentAdapterDelegate, iLayoutResultCallback, n);
            }

            public MyLayoutResultCallback(PrintDocumentAdapterDelegate printDocumentAdapterDelegate, ILayoutResultCallback iLayoutResultCallback, int n) {
                this.this$0 = printDocumentAdapterDelegate;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate_MyLayoutResultCallback$__constructor__(android.print.PrintManager$PrintDocumentAdapterDelegate android.print.ILayoutResultCallback int ), 0, this, printDocumentAdapterDelegate, iLayoutResultCallback, n);
            }

            @Override
            public void onLayoutFinished(PrintDocumentInfo printDocumentInfo, boolean bl) {
                InvokeDynamicSupport.bootstrap("onLayoutFinished", $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate_MyLayoutResultCallback$onLayoutFinished(android.print.PrintDocumentInfo boolean ), 0, this, printDocumentInfo, bl);
            }

            @Override
            public void onLayoutFailed(CharSequence charSequence) {
                InvokeDynamicSupport.bootstrap("onLayoutFailed", $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate_MyLayoutResultCallback$onLayoutFailed(java.lang.CharSequence ), 0, this, charSequence);
            }

            @Override
            public void onLayoutCancelled() {
                InvokeDynamicSupport.bootstrap("onLayoutCancelled", $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate_MyLayoutResultCallback$onLayoutCancelled(), 0, this);
            }

            @Override
            public void destroy() {
                InvokeDynamicSupport.bootstrap("destroy", $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate_MyLayoutResultCallback$destroy(), 0, this);
            }

            public /* synthetic */ MyLayoutResultCallback() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MyLayoutResultCallback)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        private static interface DestroyableCallback
        extends InstrumentedInterface {
            public void destroy();
        }

        @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
        private final class MyHandler
        extends Handler
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            public static int MSG_ON_START = 1;
            public static int MSG_ON_LAYOUT = 2;
            public static int MSG_ON_WRITE = 3;
            public static int MSG_ON_FINISH = 4;
            public static int MSG_ON_KILL = 5;
            /* synthetic */ PrintDocumentAdapterDelegate this$0;

            private void $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate_MyHandler$__constructor__(PrintDocumentAdapterDelegate printDocumentAdapterDelegate, Looper looper) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate_MyHandler$handleMessage(Message message) {
                switch (message.what) {
                    case 1: {
                        ((PrintDocumentAdapter)message.obj).onStart();
                        break;
                    }
                    case 2: {
                        SomeArgs args = (SomeArgs)message.obj;
                        PrintDocumentAdapter adapter = (PrintDocumentAdapter)args.arg1;
                        PrintAttributes oldAttributes = (PrintAttributes)args.arg2;
                        PrintAttributes newAttributes = (PrintAttributes)args.arg3;
                        CancellationSignal cancellation = (CancellationSignal)args.arg4;
                        PrintDocumentAdapter.LayoutResultCallback callback = (PrintDocumentAdapter.LayoutResultCallback)args.arg5;
                        Bundle metadata = (Bundle)args.arg6;
                        args.recycle();
                        adapter.onLayout(oldAttributes, newAttributes, cancellation, callback, metadata);
                        break;
                    }
                    case 3: {
                        SomeArgs args = (SomeArgs)message.obj;
                        PrintDocumentAdapter adapter = (PrintDocumentAdapter)args.arg1;
                        PageRange[] pages = (PageRange[])args.arg2;
                        ParcelFileDescriptor fd = (ParcelFileDescriptor)args.arg3;
                        CancellationSignal cancellation = (CancellationSignal)args.arg4;
                        PrintDocumentAdapter.WriteResultCallback callback = (PrintDocumentAdapter.WriteResultCallback)args.arg5;
                        args.recycle();
                        adapter.onWrite(pages, fd, cancellation, callback);
                        break;
                    }
                    case 4: {
                        ((PrintDocumentAdapter)message.obj).onFinish();
                        Object args = this.this$0.mLock;
                        synchronized (args) {
                            this.this$0.destroyLocked();
                            break;
                        }
                    }
                    case 5: {
                        String reason = (String)message.obj;
                        throw new RuntimeException(reason);
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown message: " + message.what);
                    }
                }
            }

            private void __constructor__(PrintDocumentAdapterDelegate printDocumentAdapterDelegate, Looper looper) {
                this.$$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate_MyHandler$__constructor__(printDocumentAdapterDelegate, looper);
            }

            public MyHandler(PrintDocumentAdapterDelegate printDocumentAdapterDelegate, Looper looper) {
                this.this$0 = printDocumentAdapterDelegate;
                super(looper, null, true);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate_MyHandler$__constructor__(android.print.PrintManager$PrintDocumentAdapterDelegate android.os.Looper ), 0, this, printDocumentAdapterDelegate, looper);
            }

            @Override
            public void handleMessage(Message message) {
                InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_print_PrintManager_PrintDocumentAdapterDelegate_MyHandler$handleMessage(android.os.Message ), 0, this, message);
            }

            public /* synthetic */ MyHandler() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MyHandler)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    public static interface PrintServiceRecommendationsChangeListener
    extends InstrumentedInterface {
        public void onPrintServiceRecommendationsChanged();
    }

    public static interface PrintServicesChangeListener
    extends InstrumentedInterface {
        public void onPrintServicesChanged();
    }

    public static interface PrintJobStateChangeListener
    extends InstrumentedInterface {
        public void onPrintJobStateChanged(PrintJobId var1);
    }
}

