/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.XmlResourceParser;
import android.os.Bundle;
import android.preference.Preference;
import android.preference.PreferenceFragment;
import android.preference.PreferenceInflater;
import android.preference.PreferenceScreen;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class PreferenceManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "PreferenceManager";
    public static String METADATA_KEY_PREFERENCES = "android.preference";
    public static String KEY_HAS_SET_DEFAULT_VALUES = "_has_set_default_values";
    private Activity mActivity;
    private PreferenceFragment mFragment;
    private Context mContext;
    private long mNextId;
    private int mNextRequestCode;
    private SharedPreferences mSharedPreferences;
    private SharedPreferences.Editor mEditor;
    private boolean mNoCommit;
    private String mSharedPreferencesName;
    private int mSharedPreferencesMode;
    private static int STORAGE_DEFAULT = 0;
    private static int STORAGE_DEVICE_PROTECTED = 1;
    private static int STORAGE_CREDENTIAL_PROTECTED = 2;
    private int mStorage;
    private PreferenceScreen mPreferenceScreen;
    private List<OnActivityResultListener> mActivityResultListeners;
    private List<OnActivityStopListener> mActivityStopListeners;
    private List<OnActivityDestroyListener> mActivityDestroyListeners;
    private List<DialogInterface> mPreferencesScreens;
    private OnPreferenceTreeClickListener mOnPreferenceTreeClickListener;

    private void $$robo$$android_preference_PreferenceManager$__constructor__(Activity activity, int firstRequestCode) {
        this.mNextId = 0L;
        this.mStorage = 0;
        this.mActivity = activity;
        this.mNextRequestCode = firstRequestCode;
        this.init(activity);
    }

    private void $$robo$$android_preference_PreferenceManager$__constructor__(Context context) {
        this.mNextId = 0L;
        this.mStorage = 0;
        this.init(context);
    }

    private final void $$robo$$android_preference_PreferenceManager$init(Context context) {
        this.mContext = context;
        this.setSharedPreferencesName(PreferenceManager.getDefaultSharedPreferencesName(context));
    }

    private final void $$robo$$android_preference_PreferenceManager$setFragment(PreferenceFragment fragment) {
        this.mFragment = fragment;
    }

    private final PreferenceFragment $$robo$$android_preference_PreferenceManager$getFragment() {
        return this.mFragment;
    }

    private final List<ResolveInfo> $$robo$$android_preference_PreferenceManager$queryIntentActivities(Intent queryIntent) {
        return this.mContext.getPackageManager().queryIntentActivities(queryIntent, 128);
    }

    private final PreferenceScreen $$robo$$android_preference_PreferenceManager$inflateFromIntent(Intent queryIntent, PreferenceScreen rootPreferences) {
        List<ResolveInfo> activities = this.queryIntentActivities(queryIntent);
        HashSet<String> inflatedRes = new HashSet<String>();
        for (int i = activities.size() - 1; i >= 0; --i) {
            Context context;
            String uniqueResId;
            ActivityInfo activityInfo = activities.get((int)i).activityInfo;
            Bundle metaData = activityInfo.metaData;
            if (metaData == null || !metaData.containsKey("android.preference") || inflatedRes.contains(uniqueResId = activityInfo.packageName + ":" + activityInfo.metaData.getInt("android.preference"))) continue;
            inflatedRes.add(uniqueResId);
            try {
                context = this.mContext.createPackageContext(activityInfo.packageName, 0);
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.w("PreferenceManager", "Could not create context for " + activityInfo.packageName + ": " + Log.getStackTraceString(e));
                continue;
            }
            PreferenceInflater inflater = new PreferenceInflater(context, this);
            XmlResourceParser parser = activityInfo.loadXmlMetaData(context.getPackageManager(), "android.preference");
            rootPreferences = (PreferenceScreen)inflater.inflate(parser, rootPreferences, true);
            parser.close();
        }
        rootPreferences.onAttachedToHierarchy(this);
        return rootPreferences;
    }

    private final PreferenceScreen $$robo$$android_preference_PreferenceManager$inflateFromResource(Context context, int resId, PreferenceScreen rootPreferences) {
        this.setNoCommit(true);
        PreferenceInflater inflater = new PreferenceInflater(context, this);
        rootPreferences = (PreferenceScreen)inflater.inflate(resId, rootPreferences, true);
        rootPreferences.onAttachedToHierarchy(this);
        this.setNoCommit(false);
        return rootPreferences;
    }

    private final PreferenceScreen $$robo$$android_preference_PreferenceManager$createPreferenceScreen(Context context) {
        PreferenceScreen preferenceScreen = new PreferenceScreen(context, null);
        preferenceScreen.onAttachedToHierarchy(this);
        return preferenceScreen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long $$robo$$android_preference_PreferenceManager$getNextId() {
        PreferenceManager preferenceManager = this;
        synchronized (preferenceManager) {
            return this.mNextId++;
        }
    }

    private final String $$robo$$android_preference_PreferenceManager$getSharedPreferencesName() {
        return this.mSharedPreferencesName;
    }

    private final void $$robo$$android_preference_PreferenceManager$setSharedPreferencesName(String sharedPreferencesName) {
        this.mSharedPreferencesName = sharedPreferencesName;
        this.mSharedPreferences = null;
    }

    private final int $$robo$$android_preference_PreferenceManager$getSharedPreferencesMode() {
        return this.mSharedPreferencesMode;
    }

    private final void $$robo$$android_preference_PreferenceManager$setSharedPreferencesMode(int sharedPreferencesMode) {
        this.mSharedPreferencesMode = sharedPreferencesMode;
        this.mSharedPreferences = null;
    }

    private final void $$robo$$android_preference_PreferenceManager$setStorageDefault() {
        this.mStorage = 0;
        this.mSharedPreferences = null;
    }

    private final void $$robo$$android_preference_PreferenceManager$setStorageDeviceProtected() {
        this.mStorage = 1;
        this.mSharedPreferences = null;
    }

    @Deprecated
    private final void $$robo$$android_preference_PreferenceManager$setStorageDeviceEncrypted() {
        this.setStorageDeviceProtected();
    }

    private final void $$robo$$android_preference_PreferenceManager$setStorageCredentialProtected() {
        this.mStorage = 2;
        this.mSharedPreferences = null;
    }

    @Deprecated
    private final void $$robo$$android_preference_PreferenceManager$setStorageCredentialEncrypted() {
        this.setStorageCredentialProtected();
    }

    private final boolean $$robo$$android_preference_PreferenceManager$isStorageDefault() {
        return this.mStorage == 0;
    }

    private final boolean $$robo$$android_preference_PreferenceManager$isStorageDeviceProtected() {
        return this.mStorage == 1;
    }

    private final boolean $$robo$$android_preference_PreferenceManager$isStorageCredentialProtected() {
        return this.mStorage == 2;
    }

    private final SharedPreferences $$robo$$android_preference_PreferenceManager$getSharedPreferences() {
        if (this.mSharedPreferences == null) {
            Context storageContext;
            switch (this.mStorage) {
                case 1: {
                    storageContext = this.mContext.createDeviceProtectedStorageContext();
                    break;
                }
                case 2: {
                    storageContext = this.mContext.createCredentialProtectedStorageContext();
                    break;
                }
                default: {
                    storageContext = this.mContext;
                }
            }
            this.mSharedPreferences = storageContext.getSharedPreferences(this.mSharedPreferencesName, this.mSharedPreferencesMode);
        }
        return this.mSharedPreferences;
    }

    private static final SharedPreferences $$robo$$android_preference_PreferenceManager$getDefaultSharedPreferences(Context context) {
        return context.getSharedPreferences(PreferenceManager.getDefaultSharedPreferencesName(context), PreferenceManager.getDefaultSharedPreferencesMode());
    }

    private static final String $$robo$$android_preference_PreferenceManager$getDefaultSharedPreferencesName(Context context) {
        return context.getPackageName() + "_preferences";
    }

    private static final int $$robo$$android_preference_PreferenceManager$getDefaultSharedPreferencesMode() {
        return 0;
    }

    private final PreferenceScreen $$robo$$android_preference_PreferenceManager$getPreferenceScreen() {
        return this.mPreferenceScreen;
    }

    private final boolean $$robo$$android_preference_PreferenceManager$setPreferences(PreferenceScreen preferenceScreen) {
        if (preferenceScreen != this.mPreferenceScreen) {
            this.mPreferenceScreen = preferenceScreen;
            return true;
        }
        return false;
    }

    private final Preference $$robo$$android_preference_PreferenceManager$findPreference(CharSequence key) {
        if (this.mPreferenceScreen == null) {
            return null;
        }
        return this.mPreferenceScreen.findPreference(key);
    }

    private static final void $$robo$$android_preference_PreferenceManager$setDefaultValues(Context context, int resId, boolean readAgain) {
        PreferenceManager.setDefaultValues(context, PreferenceManager.getDefaultSharedPreferencesName(context), PreferenceManager.getDefaultSharedPreferencesMode(), resId, readAgain);
    }

    private static final void $$robo$$android_preference_PreferenceManager$setDefaultValues(Context context, String sharedPreferencesName, int sharedPreferencesMode, int resId, boolean readAgain) {
        SharedPreferences defaultValueSp = context.getSharedPreferences("_has_set_default_values", 0);
        if (readAgain || !defaultValueSp.getBoolean("_has_set_default_values", false)) {
            PreferenceManager pm = new PreferenceManager(context);
            pm.setSharedPreferencesName(sharedPreferencesName);
            pm.setSharedPreferencesMode(sharedPreferencesMode);
            pm.inflateFromResource(context, resId, null);
            SharedPreferences.Editor editor = defaultValueSp.edit().putBoolean("_has_set_default_values", true);
            try {
                editor.apply();
            }
            catch (AbstractMethodError unused) {
                editor.commit();
            }
        }
    }

    private final SharedPreferences.Editor $$robo$$android_preference_PreferenceManager$getEditor() {
        if (this.mNoCommit) {
            if (this.mEditor == null) {
                this.mEditor = this.getSharedPreferences().edit();
            }
            return this.mEditor;
        }
        return this.getSharedPreferences().edit();
    }

    private final boolean $$robo$$android_preference_PreferenceManager$shouldCommit() {
        return !this.mNoCommit;
    }

    private final void $$robo$$android_preference_PreferenceManager$setNoCommit(boolean noCommit) {
        if (!noCommit && this.mEditor != null) {
            try {
                this.mEditor.apply();
            }
            catch (AbstractMethodError unused) {
                this.mEditor.commit();
            }
        }
        this.mNoCommit = noCommit;
    }

    private final Activity $$robo$$android_preference_PreferenceManager$getActivity() {
        return this.mActivity;
    }

    private final Context $$robo$$android_preference_PreferenceManager$getContext() {
        return this.mContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_preference_PreferenceManager$registerOnActivityResultListener(OnActivityResultListener listener) {
        PreferenceManager preferenceManager = this;
        synchronized (preferenceManager) {
            if (this.mActivityResultListeners == null) {
                this.mActivityResultListeners = new ArrayList<OnActivityResultListener>();
            }
            if (!this.mActivityResultListeners.contains(listener)) {
                this.mActivityResultListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_preference_PreferenceManager$unregisterOnActivityResultListener(OnActivityResultListener listener) {
        PreferenceManager preferenceManager = this;
        synchronized (preferenceManager) {
            if (this.mActivityResultListeners != null) {
                this.mActivityResultListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_preference_PreferenceManager$dispatchActivityResult(int requestCode, int resultCode, Intent data) {
        ArrayList<OnActivityResultListener> list;
        PreferenceManager preferenceManager = this;
        synchronized (preferenceManager) {
            if (this.mActivityResultListeners == null) {
                return;
            }
            list = new ArrayList<OnActivityResultListener>(this.mActivityResultListeners);
        }
        int N = list.size();
        for (int i = 0; i < N && !((OnActivityResultListener)list.get(i)).onActivityResult(requestCode, resultCode, data); ++i) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_preference_PreferenceManager$registerOnActivityStopListener(OnActivityStopListener listener) {
        PreferenceManager preferenceManager = this;
        synchronized (preferenceManager) {
            if (this.mActivityStopListeners == null) {
                this.mActivityStopListeners = new ArrayList<OnActivityStopListener>();
            }
            if (!this.mActivityStopListeners.contains(listener)) {
                this.mActivityStopListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_preference_PreferenceManager$unregisterOnActivityStopListener(OnActivityStopListener listener) {
        PreferenceManager preferenceManager = this;
        synchronized (preferenceManager) {
            if (this.mActivityStopListeners != null) {
                this.mActivityStopListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_preference_PreferenceManager$dispatchActivityStop() {
        ArrayList<OnActivityStopListener> list;
        PreferenceManager preferenceManager = this;
        synchronized (preferenceManager) {
            if (this.mActivityStopListeners == null) {
                return;
            }
            list = new ArrayList<OnActivityStopListener>(this.mActivityStopListeners);
        }
        int N = list.size();
        for (int i = 0; i < N; ++i) {
            ((OnActivityStopListener)list.get(i)).onActivityStop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_preference_PreferenceManager$registerOnActivityDestroyListener(OnActivityDestroyListener listener) {
        PreferenceManager preferenceManager = this;
        synchronized (preferenceManager) {
            if (this.mActivityDestroyListeners == null) {
                this.mActivityDestroyListeners = new ArrayList<OnActivityDestroyListener>();
            }
            if (!this.mActivityDestroyListeners.contains(listener)) {
                this.mActivityDestroyListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_preference_PreferenceManager$unregisterOnActivityDestroyListener(OnActivityDestroyListener listener) {
        PreferenceManager preferenceManager = this;
        synchronized (preferenceManager) {
            if (this.mActivityDestroyListeners != null) {
                this.mActivityDestroyListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_preference_PreferenceManager$dispatchActivityDestroy() {
        ArrayList<OnActivityDestroyListener> list = null;
        PreferenceManager preferenceManager = this;
        synchronized (preferenceManager) {
            if (this.mActivityDestroyListeners != null) {
                list = new ArrayList<OnActivityDestroyListener>(this.mActivityDestroyListeners);
            }
        }
        if (list != null) {
            int N = list.size();
            for (int i = 0; i < N; ++i) {
                ((OnActivityDestroyListener)list.get(i)).onActivityDestroy();
            }
        }
        this.dismissAllScreens();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_preference_PreferenceManager$getNextRequestCode() {
        PreferenceManager preferenceManager = this;
        synchronized (preferenceManager) {
            return this.mNextRequestCode++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_preference_PreferenceManager$addPreferencesScreen(DialogInterface screen) {
        PreferenceManager preferenceManager = this;
        synchronized (preferenceManager) {
            if (this.mPreferencesScreens == null) {
                this.mPreferencesScreens = new ArrayList<DialogInterface>();
            }
            this.mPreferencesScreens.add(screen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_preference_PreferenceManager$removePreferencesScreen(DialogInterface screen) {
        PreferenceManager preferenceManager = this;
        synchronized (preferenceManager) {
            if (this.mPreferencesScreens == null) {
                return;
            }
            this.mPreferencesScreens.remove(screen);
        }
    }

    private final void $$robo$$android_preference_PreferenceManager$dispatchNewIntent(Intent intent) {
        this.dismissAllScreens();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_preference_PreferenceManager$dismissAllScreens() {
        ArrayList<DialogInterface> screensToDismiss;
        PreferenceManager preferenceManager = this;
        synchronized (preferenceManager) {
            if (this.mPreferencesScreens == null) {
                return;
            }
            screensToDismiss = new ArrayList<DialogInterface>(this.mPreferencesScreens);
            this.mPreferencesScreens.clear();
        }
        for (int i = screensToDismiss.size() - 1; i >= 0; --i) {
            screensToDismiss.get(i).dismiss();
        }
    }

    private final void $$robo$$android_preference_PreferenceManager$setOnPreferenceTreeClickListener(OnPreferenceTreeClickListener listener) {
        this.mOnPreferenceTreeClickListener = listener;
    }

    private final OnPreferenceTreeClickListener $$robo$$android_preference_PreferenceManager$getOnPreferenceTreeClickListener() {
        return this.mOnPreferenceTreeClickListener;
    }

    private void __constructor__(Activity activity, int n) {
        this.$$robo$$android_preference_PreferenceManager$__constructor__(activity, n);
    }

    public PreferenceManager(Activity activity, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_preference_PreferenceManager$__constructor__(android.app.Activity int ), 0, this, activity, n);
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_preference_PreferenceManager$__constructor__(context);
    }

    PreferenceManager(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_preference_PreferenceManager$__constructor__(android.content.Context ), 0, this, context);
    }

    private void init(Context context) {
        InvokeDynamicSupport.bootstrap("init", $$robo$$android_preference_PreferenceManager$init(android.content.Context ), 0, this, context);
    }

    void setFragment(PreferenceFragment preferenceFragment) {
        InvokeDynamicSupport.bootstrap("setFragment", $$robo$$android_preference_PreferenceManager$setFragment(android.preference.PreferenceFragment ), 0, this, preferenceFragment);
    }

    PreferenceFragment getFragment() {
        return InvokeDynamicSupport.bootstrap("getFragment", $$robo$$android_preference_PreferenceManager$getFragment(), 0, this);
    }

    private List<ResolveInfo> queryIntentActivities(Intent intent) {
        return InvokeDynamicSupport.bootstrap("queryIntentActivities", $$robo$$android_preference_PreferenceManager$queryIntentActivities(android.content.Intent ), 0, this, intent);
    }

    PreferenceScreen inflateFromIntent(Intent intent, PreferenceScreen preferenceScreen) {
        return InvokeDynamicSupport.bootstrap("inflateFromIntent", $$robo$$android_preference_PreferenceManager$inflateFromIntent(android.content.Intent android.preference.PreferenceScreen ), 0, this, intent, preferenceScreen);
    }

    public PreferenceScreen inflateFromResource(Context context, int n, PreferenceScreen preferenceScreen) {
        return InvokeDynamicSupport.bootstrap("inflateFromResource", $$robo$$android_preference_PreferenceManager$inflateFromResource(android.content.Context int android.preference.PreferenceScreen ), 0, this, context, n, preferenceScreen);
    }

    public PreferenceScreen createPreferenceScreen(Context context) {
        return InvokeDynamicSupport.bootstrap("createPreferenceScreen", $$robo$$android_preference_PreferenceManager$createPreferenceScreen(android.content.Context ), 0, this, context);
    }

    long getNextId() {
        return (long)InvokeDynamicSupport.bootstrap("getNextId", $$robo$$android_preference_PreferenceManager$getNextId(), 0, this);
    }

    public String getSharedPreferencesName() {
        return InvokeDynamicSupport.bootstrap("getSharedPreferencesName", $$robo$$android_preference_PreferenceManager$getSharedPreferencesName(), 0, this);
    }

    public void setSharedPreferencesName(String string2) {
        InvokeDynamicSupport.bootstrap("setSharedPreferencesName", $$robo$$android_preference_PreferenceManager$setSharedPreferencesName(java.lang.String ), 0, this, string2);
    }

    public int getSharedPreferencesMode() {
        return (int)InvokeDynamicSupport.bootstrap("getSharedPreferencesMode", $$robo$$android_preference_PreferenceManager$getSharedPreferencesMode(), 0, this);
    }

    public void setSharedPreferencesMode(int n) {
        InvokeDynamicSupport.bootstrap("setSharedPreferencesMode", $$robo$$android_preference_PreferenceManager$setSharedPreferencesMode(int ), 0, this, n);
    }

    public void setStorageDefault() {
        InvokeDynamicSupport.bootstrap("setStorageDefault", $$robo$$android_preference_PreferenceManager$setStorageDefault(), 0, this);
    }

    public void setStorageDeviceProtected() {
        InvokeDynamicSupport.bootstrap("setStorageDeviceProtected", $$robo$$android_preference_PreferenceManager$setStorageDeviceProtected(), 0, this);
    }

    @Deprecated
    public void setStorageDeviceEncrypted() {
        InvokeDynamicSupport.bootstrap("setStorageDeviceEncrypted", $$robo$$android_preference_PreferenceManager$setStorageDeviceEncrypted(), 0, this);
    }

    public void setStorageCredentialProtected() {
        InvokeDynamicSupport.bootstrap("setStorageCredentialProtected", $$robo$$android_preference_PreferenceManager$setStorageCredentialProtected(), 0, this);
    }

    @Deprecated
    public void setStorageCredentialEncrypted() {
        InvokeDynamicSupport.bootstrap("setStorageCredentialEncrypted", $$robo$$android_preference_PreferenceManager$setStorageCredentialEncrypted(), 0, this);
    }

    public boolean isStorageDefault() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStorageDefault", $$robo$$android_preference_PreferenceManager$isStorageDefault(), 0, this);
    }

    public boolean isStorageDeviceProtected() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStorageDeviceProtected", $$robo$$android_preference_PreferenceManager$isStorageDeviceProtected(), 0, this);
    }

    public boolean isStorageCredentialProtected() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStorageCredentialProtected", $$robo$$android_preference_PreferenceManager$isStorageCredentialProtected(), 0, this);
    }

    public SharedPreferences getSharedPreferences() {
        return InvokeDynamicSupport.bootstrap("getSharedPreferences", $$robo$$android_preference_PreferenceManager$getSharedPreferences(), 0, this);
    }

    public static SharedPreferences getDefaultSharedPreferences(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultSharedPreferences", $$robo$$android_preference_PreferenceManager$getDefaultSharedPreferences(android.content.Context ), 0, (Context)context);
    }

    public static String getDefaultSharedPreferencesName(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultSharedPreferencesName", $$robo$$android_preference_PreferenceManager$getDefaultSharedPreferencesName(android.content.Context ), 0, (Context)context);
    }

    private static int getDefaultSharedPreferencesMode() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getDefaultSharedPreferencesMode", $$robo$$android_preference_PreferenceManager$getDefaultSharedPreferencesMode(), 0);
    }

    PreferenceScreen getPreferenceScreen() {
        return InvokeDynamicSupport.bootstrap("getPreferenceScreen", $$robo$$android_preference_PreferenceManager$getPreferenceScreen(), 0, this);
    }

    boolean setPreferences(PreferenceScreen preferenceScreen) {
        return (boolean)InvokeDynamicSupport.bootstrap("setPreferences", $$robo$$android_preference_PreferenceManager$setPreferences(android.preference.PreferenceScreen ), 0, this, preferenceScreen);
    }

    public Preference findPreference(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("findPreference", $$robo$$android_preference_PreferenceManager$findPreference(java.lang.CharSequence ), 0, this, charSequence);
    }

    public static void setDefaultValues(Context context, int n, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("setDefaultValues", $$robo$$android_preference_PreferenceManager$setDefaultValues(android.content.Context int boolean ), 0, (Context)context, (int)n, (boolean)bl);
    }

    public static void setDefaultValues(Context context, String string2, int n, int n2, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("setDefaultValues", $$robo$$android_preference_PreferenceManager$setDefaultValues(android.content.Context java.lang.String int int boolean ), 0, (Context)context, (String)string2, (int)n, (int)n2, (boolean)bl);
    }

    SharedPreferences.Editor getEditor() {
        return InvokeDynamicSupport.bootstrap("getEditor", $$robo$$android_preference_PreferenceManager$getEditor(), 0, this);
    }

    boolean shouldCommit() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldCommit", $$robo$$android_preference_PreferenceManager$shouldCommit(), 0, this);
    }

    private void setNoCommit(boolean bl) {
        InvokeDynamicSupport.bootstrap("setNoCommit", $$robo$$android_preference_PreferenceManager$setNoCommit(boolean ), 0, this, bl);
    }

    Activity getActivity() {
        return InvokeDynamicSupport.bootstrap("getActivity", $$robo$$android_preference_PreferenceManager$getActivity(), 0, this);
    }

    Context getContext() {
        return InvokeDynamicSupport.bootstrap("getContext", $$robo$$android_preference_PreferenceManager$getContext(), 0, this);
    }

    void registerOnActivityResultListener(OnActivityResultListener onActivityResultListener) {
        InvokeDynamicSupport.bootstrap("registerOnActivityResultListener", $$robo$$android_preference_PreferenceManager$registerOnActivityResultListener(android.preference.PreferenceManager$OnActivityResultListener ), 0, this, onActivityResultListener);
    }

    void unregisterOnActivityResultListener(OnActivityResultListener onActivityResultListener) {
        InvokeDynamicSupport.bootstrap("unregisterOnActivityResultListener", $$robo$$android_preference_PreferenceManager$unregisterOnActivityResultListener(android.preference.PreferenceManager$OnActivityResultListener ), 0, this, onActivityResultListener);
    }

    void dispatchActivityResult(int n, int n2, Intent intent) {
        InvokeDynamicSupport.bootstrap("dispatchActivityResult", $$robo$$android_preference_PreferenceManager$dispatchActivityResult(int int android.content.Intent ), 0, this, n, n2, intent);
    }

    public void registerOnActivityStopListener(OnActivityStopListener onActivityStopListener) {
        InvokeDynamicSupport.bootstrap("registerOnActivityStopListener", $$robo$$android_preference_PreferenceManager$registerOnActivityStopListener(android.preference.PreferenceManager$OnActivityStopListener ), 0, this, onActivityStopListener);
    }

    public void unregisterOnActivityStopListener(OnActivityStopListener onActivityStopListener) {
        InvokeDynamicSupport.bootstrap("unregisterOnActivityStopListener", $$robo$$android_preference_PreferenceManager$unregisterOnActivityStopListener(android.preference.PreferenceManager$OnActivityStopListener ), 0, this, onActivityStopListener);
    }

    void dispatchActivityStop() {
        InvokeDynamicSupport.bootstrap("dispatchActivityStop", $$robo$$android_preference_PreferenceManager$dispatchActivityStop(), 0, this);
    }

    void registerOnActivityDestroyListener(OnActivityDestroyListener onActivityDestroyListener) {
        InvokeDynamicSupport.bootstrap("registerOnActivityDestroyListener", $$robo$$android_preference_PreferenceManager$registerOnActivityDestroyListener(android.preference.PreferenceManager$OnActivityDestroyListener ), 0, this, onActivityDestroyListener);
    }

    void unregisterOnActivityDestroyListener(OnActivityDestroyListener onActivityDestroyListener) {
        InvokeDynamicSupport.bootstrap("unregisterOnActivityDestroyListener", $$robo$$android_preference_PreferenceManager$unregisterOnActivityDestroyListener(android.preference.PreferenceManager$OnActivityDestroyListener ), 0, this, onActivityDestroyListener);
    }

    void dispatchActivityDestroy() {
        InvokeDynamicSupport.bootstrap("dispatchActivityDestroy", $$robo$$android_preference_PreferenceManager$dispatchActivityDestroy(), 0, this);
    }

    int getNextRequestCode() {
        return (int)InvokeDynamicSupport.bootstrap("getNextRequestCode", $$robo$$android_preference_PreferenceManager$getNextRequestCode(), 0, this);
    }

    void addPreferencesScreen(DialogInterface dialogInterface) {
        InvokeDynamicSupport.bootstrap("addPreferencesScreen", $$robo$$android_preference_PreferenceManager$addPreferencesScreen(android.content.DialogInterface ), 0, this, dialogInterface);
    }

    void removePreferencesScreen(DialogInterface dialogInterface) {
        InvokeDynamicSupport.bootstrap("removePreferencesScreen", $$robo$$android_preference_PreferenceManager$removePreferencesScreen(android.content.DialogInterface ), 0, this, dialogInterface);
    }

    void dispatchNewIntent(Intent intent) {
        InvokeDynamicSupport.bootstrap("dispatchNewIntent", $$robo$$android_preference_PreferenceManager$dispatchNewIntent(android.content.Intent ), 0, this, intent);
    }

    private void dismissAllScreens() {
        InvokeDynamicSupport.bootstrap("dismissAllScreens", $$robo$$android_preference_PreferenceManager$dismissAllScreens(), 0, this);
    }

    void setOnPreferenceTreeClickListener(OnPreferenceTreeClickListener onPreferenceTreeClickListener) {
        InvokeDynamicSupport.bootstrap("setOnPreferenceTreeClickListener", $$robo$$android_preference_PreferenceManager$setOnPreferenceTreeClickListener(android.preference.PreferenceManager$OnPreferenceTreeClickListener ), 0, this, onPreferenceTreeClickListener);
    }

    OnPreferenceTreeClickListener getOnPreferenceTreeClickListener() {
        return InvokeDynamicSupport.bootstrap("getOnPreferenceTreeClickListener", $$robo$$android_preference_PreferenceManager$getOnPreferenceTreeClickListener(), 0, this);
    }

    public /* synthetic */ PreferenceManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PreferenceManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface OnActivityDestroyListener
    extends InstrumentedInterface {
        public void onActivityDestroy();
    }

    public static interface OnActivityStopListener
    extends InstrumentedInterface {
        public void onActivityStop();
    }

    public static interface OnActivityResultListener
    extends InstrumentedInterface {
        public boolean onActivityResult(int var1, int var2, Intent var3);
    }

    public static interface OnPreferenceTreeClickListener
    extends InstrumentedInterface {
        public boolean onPreferenceTreeClick(PreferenceScreen var1, Preference var2);
    }
}

