/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.preference.Preference;
import android.preference.PreferenceGroup;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class PreferenceGroupAdapter
extends BaseAdapter
implements Preference.OnPreferenceChangeInternalListener,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "PreferenceGroupAdapter";
    private PreferenceGroup mPreferenceGroup;
    private List<Preference> mPreferenceList;
    private ArrayList<PreferenceLayout> mPreferenceLayouts;
    private PreferenceLayout mTempPreferenceLayout;
    private boolean mHasReturnedViewTypeCount;
    private volatile boolean mIsSyncing;
    private Handler mHandler;
    private Runnable mSyncRunnable;
    private int mHighlightedPosition;
    private Drawable mHighlightedDrawable;
    private static ViewGroup.LayoutParams sWrapperLayoutParams;

    private void $$robo$$android_preference_PreferenceGroupAdapter$__constructor__(PreferenceGroup preferenceGroup) {
        this.mTempPreferenceLayout = new PreferenceLayout();
        this.mHasReturnedViewTypeCount = false;
        this.mIsSyncing = false;
        this.mHandler = new Handler();
        this.mSyncRunnable = new Runnable(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ PreferenceGroupAdapter this$0;

            private void $$robo$$android_preference_PreferenceGroupAdapter_1$__constructor__(PreferenceGroupAdapter this$0) {
            }

            private final void $$robo$$android_preference_PreferenceGroupAdapter_1$run() {
                this.this$0.syncMyPreferences();
            }

            private void __constructor__(PreferenceGroupAdapter preferenceGroupAdapter) {
                this.$$robo$$android_preference_PreferenceGroupAdapter_1$__constructor__(preferenceGroupAdapter);
            }
            {
                this.this$0 = preferenceGroupAdapter;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_preference_PreferenceGroupAdapter_1$__constructor__(android.preference.PreferenceGroupAdapter ), 0, this, preferenceGroupAdapter);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_preference_PreferenceGroupAdapter_1$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mHighlightedPosition = -1;
        this.mPreferenceGroup = preferenceGroup;
        this.mPreferenceGroup.setOnPreferenceChangeInternalListener(this);
        this.mPreferenceList = new ArrayList<Preference>();
        this.mPreferenceLayouts = new ArrayList();
        this.syncMyPreferences();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_preference_PreferenceGroupAdapter$syncMyPreferences() {
        PreferenceGroupAdapter preferenceGroupAdapter = this;
        synchronized (preferenceGroupAdapter) {
            if (this.mIsSyncing) {
                return;
            }
            this.mIsSyncing = true;
        }
        ArrayList<Preference> newPreferenceList = new ArrayList<Preference>(this.mPreferenceList.size());
        this.flattenPreferenceGroup(newPreferenceList, this.mPreferenceGroup);
        this.mPreferenceList = newPreferenceList;
        this.notifyDataSetChanged();
        PreferenceGroupAdapter preferenceGroupAdapter2 = this;
        synchronized (preferenceGroupAdapter2) {
            this.mIsSyncing = false;
            this.notifyAll();
        }
    }

    private final void $$robo$$android_preference_PreferenceGroupAdapter$flattenPreferenceGroup(List<Preference> preferences, PreferenceGroup group) {
        group.sortPreferences();
        int groupSize = group.getPreferenceCount();
        for (int i = 0; i < groupSize; ++i) {
            PreferenceGroup preferenceAsGroup;
            Preference preference = group.getPreference(i);
            preferences.add(preference);
            if (!this.mHasReturnedViewTypeCount && preference.canRecycleLayout()) {
                this.addPreferenceClassName(preference);
            }
            if (preference instanceof PreferenceGroup && (preferenceAsGroup = (PreferenceGroup)preference).isOnSameScreenAsChildren()) {
                this.flattenPreferenceGroup(preferences, preferenceAsGroup);
            }
            preference.setOnPreferenceChangeInternalListener(this);
        }
    }

    private final PreferenceLayout $$robo$$android_preference_PreferenceGroupAdapter$createPreferenceLayout(Preference preference, PreferenceLayout in) {
        PreferenceLayout pl = in != null ? in : new PreferenceLayout();
        pl.name = preference.getClass().getName();
        pl.resId = preference.getLayoutResource();
        pl.widgetResId = preference.getWidgetLayoutResource();
        return pl;
    }

    private final void $$robo$$android_preference_PreferenceGroupAdapter$addPreferenceClassName(Preference preference) {
        PreferenceLayout pl = this.createPreferenceLayout(preference, null);
        int insertPos = Collections.binarySearch(this.mPreferenceLayouts, pl);
        if (insertPos < 0) {
            insertPos = insertPos * -1 - 1;
            this.mPreferenceLayouts.add(insertPos, pl);
        }
    }

    private final int $$robo$$android_preference_PreferenceGroupAdapter$getCount() {
        return this.mPreferenceList.size();
    }

    private final Preference $$robo$$android_preference_PreferenceGroupAdapter$getItem(int position) {
        if (position < 0 || position >= this.getCount()) {
            return null;
        }
        return this.mPreferenceList.get(position);
    }

    private final long $$robo$$android_preference_PreferenceGroupAdapter$getItemId(int position) {
        if (position < 0 || position >= this.getCount()) {
            return Long.MIN_VALUE;
        }
        return ((Preference)this.getItem(position)).getId();
    }

    private final void $$robo$$android_preference_PreferenceGroupAdapter$setHighlighted(int position) {
        this.mHighlightedPosition = position;
    }

    private final void $$robo$$android_preference_PreferenceGroupAdapter$setHighlightedDrawable(Drawable drawable2) {
        this.mHighlightedDrawable = drawable2;
    }

    private final View $$robo$$android_preference_PreferenceGroupAdapter$getView(int position, View convertView, ViewGroup parent) {
        Object preference = this.getItem(position);
        this.mTempPreferenceLayout = this.createPreferenceLayout((Preference)preference, this.mTempPreferenceLayout);
        if (Collections.binarySearch(this.mPreferenceLayouts, this.mTempPreferenceLayout) < 0 || this.getItemViewType(position) == this.getHighlightItemViewType()) {
            convertView = null;
        }
        View result = ((Preference)preference).getView(convertView, parent);
        if (position == this.mHighlightedPosition && this.mHighlightedDrawable != null) {
            FrameLayout wrapper = new FrameLayout(parent.getContext());
            wrapper.setLayoutParams(sWrapperLayoutParams);
            wrapper.setBackgroundDrawable(this.mHighlightedDrawable);
            wrapper.addView(result);
            result = wrapper;
        }
        return result;
    }

    private final boolean $$robo$$android_preference_PreferenceGroupAdapter$isEnabled(int position) {
        if (position < 0 || position >= this.getCount()) {
            return true;
        }
        return ((Preference)this.getItem(position)).isSelectable();
    }

    private final boolean $$robo$$android_preference_PreferenceGroupAdapter$areAllItemsEnabled() {
        return false;
    }

    private final void $$robo$$android_preference_PreferenceGroupAdapter$onPreferenceChange(Preference preference) {
        this.notifyDataSetChanged();
    }

    private final void $$robo$$android_preference_PreferenceGroupAdapter$onPreferenceHierarchyChange(Preference preference) {
        this.mHandler.removeCallbacks(this.mSyncRunnable);
        this.mHandler.post(this.mSyncRunnable);
    }

    private final boolean $$robo$$android_preference_PreferenceGroupAdapter$hasStableIds() {
        return true;
    }

    private final int $$robo$$android_preference_PreferenceGroupAdapter$getHighlightItemViewType() {
        return this.getViewTypeCount() - 1;
    }

    private final int $$robo$$android_preference_PreferenceGroupAdapter$getItemViewType(int position) {
        Object preference;
        if (position == this.mHighlightedPosition) {
            return this.getHighlightItemViewType();
        }
        if (!this.mHasReturnedViewTypeCount) {
            this.mHasReturnedViewTypeCount = true;
        }
        if (!((Preference)(preference = this.getItem(position))).canRecycleLayout()) {
            return -1;
        }
        this.mTempPreferenceLayout = this.createPreferenceLayout((Preference)preference, this.mTempPreferenceLayout);
        int viewType = Collections.binarySearch(this.mPreferenceLayouts, this.mTempPreferenceLayout);
        if (viewType < 0) {
            return -1;
        }
        return viewType;
    }

    private final int $$robo$$android_preference_PreferenceGroupAdapter$getViewTypeCount() {
        if (!this.mHasReturnedViewTypeCount) {
            this.mHasReturnedViewTypeCount = true;
        }
        return Math.max(1, this.mPreferenceLayouts.size()) + 1;
    }

    static void __staticInitializer__() {
        sWrapperLayoutParams = new ViewGroup.LayoutParams(-1, -2);
    }

    private void __constructor__(PreferenceGroup preferenceGroup) {
        this.$$robo$$android_preference_PreferenceGroupAdapter$__constructor__(preferenceGroup);
    }

    public PreferenceGroupAdapter(PreferenceGroup preferenceGroup) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_preference_PreferenceGroupAdapter$__constructor__(android.preference.PreferenceGroup ), 0, this, preferenceGroup);
    }

    private void syncMyPreferences() {
        InvokeDynamicSupport.bootstrap("syncMyPreferences", $$robo$$android_preference_PreferenceGroupAdapter$syncMyPreferences(), 0, this);
    }

    private void flattenPreferenceGroup(List<Preference> list, PreferenceGroup preferenceGroup) {
        InvokeDynamicSupport.bootstrap("flattenPreferenceGroup", $$robo$$android_preference_PreferenceGroupAdapter$flattenPreferenceGroup(java.util.List<android.preference.Preference> android.preference.PreferenceGroup ), 0, this, list, preferenceGroup);
    }

    private PreferenceLayout createPreferenceLayout(Preference preference, PreferenceLayout preferenceLayout) {
        return InvokeDynamicSupport.bootstrap("createPreferenceLayout", $$robo$$android_preference_PreferenceGroupAdapter$createPreferenceLayout(android.preference.Preference android.preference.PreferenceGroupAdapter$PreferenceLayout ), 0, this, preference, preferenceLayout);
    }

    private void addPreferenceClassName(Preference preference) {
        InvokeDynamicSupport.bootstrap("addPreferenceClassName", $$robo$$android_preference_PreferenceGroupAdapter$addPreferenceClassName(android.preference.Preference ), 0, this, preference);
    }

    @Override
    public int getCount() {
        return (int)InvokeDynamicSupport.bootstrap("getCount", $$robo$$android_preference_PreferenceGroupAdapter$getCount(), 0, this);
    }

    @Override
    public Preference getItem(int n) {
        return InvokeDynamicSupport.bootstrap("getItem", $$robo$$android_preference_PreferenceGroupAdapter$getItem(int ), 0, this, n);
    }

    @Override
    public long getItemId(int n) {
        return (long)InvokeDynamicSupport.bootstrap("getItemId", $$robo$$android_preference_PreferenceGroupAdapter$getItemId(int ), 0, this, n);
    }

    public void setHighlighted(int n) {
        InvokeDynamicSupport.bootstrap("setHighlighted", $$robo$$android_preference_PreferenceGroupAdapter$setHighlighted(int ), 0, this, n);
    }

    public void setHighlightedDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setHighlightedDrawable", $$robo$$android_preference_PreferenceGroupAdapter$setHighlightedDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    @Override
    public View getView(int n, View view, ViewGroup viewGroup) {
        return InvokeDynamicSupport.bootstrap("getView", $$robo$$android_preference_PreferenceGroupAdapter$getView(int android.view.View android.view.ViewGroup ), 0, this, n, view, viewGroup);
    }

    @Override
    public boolean isEnabled(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_preference_PreferenceGroupAdapter$isEnabled(int ), 0, this, n);
    }

    @Override
    public boolean areAllItemsEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("areAllItemsEnabled", $$robo$$android_preference_PreferenceGroupAdapter$areAllItemsEnabled(), 0, this);
    }

    @Override
    public void onPreferenceChange(Preference preference) {
        InvokeDynamicSupport.bootstrap("onPreferenceChange", $$robo$$android_preference_PreferenceGroupAdapter$onPreferenceChange(android.preference.Preference ), 0, this, preference);
    }

    @Override
    public void onPreferenceHierarchyChange(Preference preference) {
        InvokeDynamicSupport.bootstrap("onPreferenceHierarchyChange", $$robo$$android_preference_PreferenceGroupAdapter$onPreferenceHierarchyChange(android.preference.Preference ), 0, this, preference);
    }

    @Override
    public boolean hasStableIds() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasStableIds", $$robo$$android_preference_PreferenceGroupAdapter$hasStableIds(), 0, this);
    }

    private int getHighlightItemViewType() {
        return (int)InvokeDynamicSupport.bootstrap("getHighlightItemViewType", $$robo$$android_preference_PreferenceGroupAdapter$getHighlightItemViewType(), 0, this);
    }

    @Override
    public int getItemViewType(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getItemViewType", $$robo$$android_preference_PreferenceGroupAdapter$getItemViewType(int ), 0, this, n);
    }

    @Override
    public int getViewTypeCount() {
        return (int)InvokeDynamicSupport.bootstrap("getViewTypeCount", $$robo$$android_preference_PreferenceGroupAdapter$getViewTypeCount(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(PreferenceGroupAdapter.class);
    }

    public /* synthetic */ PreferenceGroupAdapter() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PreferenceGroupAdapter)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class PreferenceLayout
    implements Comparable<PreferenceLayout> {
        public transient /* synthetic */ Object __robo_data__;
        private int resId;
        private int widgetResId;
        private String name;

        private void $$robo$$android_preference_PreferenceGroupAdapter_PreferenceLayout$__constructor__() {
        }

        private final int $$robo$$android_preference_PreferenceGroupAdapter_PreferenceLayout$compareTo(PreferenceLayout other) {
            int compareNames = this.name.compareTo(other.name);
            if (compareNames == 0) {
                if (this.resId == other.resId) {
                    if (this.widgetResId == other.widgetResId) {
                        return 0;
                    }
                    return this.widgetResId - other.widgetResId;
                }
                return this.resId - other.resId;
            }
            return compareNames;
        }

        private /* synthetic */ void $$robo$$android_preference_PreferenceGroupAdapter_PreferenceLayout$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_preference_PreferenceGroupAdapter_PreferenceLayout$__constructor__();
        }

        private PreferenceLayout() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_preference_PreferenceGroupAdapter_PreferenceLayout$__constructor__(), 0, this);
        }

        @Override
        public int compareTo(PreferenceLayout preferenceLayout) {
            return (int)InvokeDynamicSupport.bootstrap("compareTo", $$robo$$android_preference_PreferenceGroupAdapter_PreferenceLayout$compareTo(android.preference.PreferenceGroupAdapter$PreferenceLayout ), 0, this, preferenceLayout);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_preference_PreferenceGroupAdapter_PreferenceLayout$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PreferenceLayout)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

