/*
 * Decompiled with CFR 0.152.
 */
package android.os.storage;

import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import android.os.storage.DiskInfo;
import android.os.storage.StorageManager;
import android.os.storage.StorageVolume;
import android.provider.DocumentsContract;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.DebugUtils;
import android.util.SparseArray;
import android.util.SparseIntArray;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.Preconditions;
import java.io.CharArrayWriter;
import java.io.File;
import java.util.Comparator;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class VolumeInfo
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String ACTION_VOLUME_STATE_CHANGED = "android.os.storage.action.VOLUME_STATE_CHANGED";
    public static String EXTRA_VOLUME_ID = "android.os.storage.extra.VOLUME_ID";
    public static String EXTRA_VOLUME_STATE = "android.os.storage.extra.VOLUME_STATE";
    public static String ID_PRIVATE_INTERNAL = "private";
    public static String ID_EMULATED_INTERNAL = "emulated";
    public static int TYPE_PUBLIC = 0;
    public static int TYPE_PRIVATE = 1;
    public static int TYPE_EMULATED = 2;
    public static int TYPE_ASEC = 3;
    public static int TYPE_OBB = 4;
    public static int STATE_UNMOUNTED = 0;
    public static int STATE_CHECKING = 1;
    public static int STATE_MOUNTED = 2;
    public static int STATE_MOUNTED_READ_ONLY = 3;
    public static int STATE_FORMATTING = 4;
    public static int STATE_EJECTING = 5;
    public static int STATE_UNMOUNTABLE = 6;
    public static int STATE_REMOVED = 7;
    public static int STATE_BAD_REMOVAL = 8;
    public static int MOUNT_FLAG_PRIMARY = 1;
    public static int MOUNT_FLAG_VISIBLE = 2;
    private static SparseArray<String> sStateToEnvironment;
    private static ArrayMap<String, String> sEnvironmentToBroadcast;
    private static SparseIntArray sStateToDescrip;
    private static Comparator<VolumeInfo> sDescriptionComparator;
    public String id;
    public int type;
    public DiskInfo disk;
    public String partGuid;
    public int mountFlags;
    public int mountUserId;
    public int state;
    public String fsType;
    public String fsUuid;
    public String fsLabel;
    public String path;
    public String internalPath;
    private static String DOCUMENT_AUTHORITY = "com.android.externalstorage.documents";
    private static String DOCUMENT_ROOT_PRIMARY_EMULATED = "primary";
    public static Parcelable.Creator<VolumeInfo> CREATOR;

    private void $$robo$$android_os_storage_VolumeInfo$__constructor__(String id2, int type, DiskInfo disk, String partGuid) {
        this.mountFlags = 0;
        this.mountUserId = -1;
        this.state = 0;
        this.id = Preconditions.checkNotNull(id2);
        this.type = type;
        this.disk = disk;
        this.partGuid = partGuid;
    }

    private void $$robo$$android_os_storage_VolumeInfo$__constructor__(Parcel parcel) {
        this.mountFlags = 0;
        this.mountUserId = -1;
        this.state = 0;
        this.id = parcel.readString();
        this.type = parcel.readInt();
        this.disk = parcel.readInt() != 0 ? DiskInfo.CREATOR.createFromParcel(parcel) : null;
        this.partGuid = parcel.readString();
        this.mountFlags = parcel.readInt();
        this.mountUserId = parcel.readInt();
        this.state = parcel.readInt();
        this.fsType = parcel.readString();
        this.fsUuid = parcel.readString();
        this.fsLabel = parcel.readString();
        this.path = parcel.readString();
        this.internalPath = parcel.readString();
    }

    private static final String $$robo$$android_os_storage_VolumeInfo$getEnvironmentForState(int state) {
        String envState = sStateToEnvironment.get(state);
        if (envState != null) {
            return envState;
        }
        return "unknown";
    }

    private static final String $$robo$$android_os_storage_VolumeInfo$getBroadcastForEnvironment(String envState) {
        return sEnvironmentToBroadcast.get(envState);
    }

    private static final String $$robo$$android_os_storage_VolumeInfo$getBroadcastForState(int state) {
        return VolumeInfo.getBroadcastForEnvironment(VolumeInfo.getEnvironmentForState(state));
    }

    private static final Comparator<VolumeInfo> $$robo$$android_os_storage_VolumeInfo$getDescriptionComparator() {
        return sDescriptionComparator;
    }

    private final String $$robo$$android_os_storage_VolumeInfo$getId() {
        return this.id;
    }

    private final DiskInfo $$robo$$android_os_storage_VolumeInfo$getDisk() {
        return this.disk;
    }

    private final String $$robo$$android_os_storage_VolumeInfo$getDiskId() {
        return this.disk != null ? this.disk.id : null;
    }

    private final int $$robo$$android_os_storage_VolumeInfo$getType() {
        return this.type;
    }

    private final int $$robo$$android_os_storage_VolumeInfo$getState() {
        return this.state;
    }

    private final int $$robo$$android_os_storage_VolumeInfo$getStateDescription() {
        return sStateToDescrip.get(this.state, 0);
    }

    private final String $$robo$$android_os_storage_VolumeInfo$getFsUuid() {
        return this.fsUuid;
    }

    private final int $$robo$$android_os_storage_VolumeInfo$getMountUserId() {
        return this.mountUserId;
    }

    private final String $$robo$$android_os_storage_VolumeInfo$getDescription() {
        if ("private".equals(this.id) || "emulated".equals(this.id)) {
            return Resources.getSystem().getString(17040571);
        }
        if (!TextUtils.isEmpty(this.fsLabel)) {
            return this.fsLabel;
        }
        return null;
    }

    private final boolean $$robo$$android_os_storage_VolumeInfo$isMountedReadable() {
        return this.state == 2 || this.state == 3;
    }

    private final boolean $$robo$$android_os_storage_VolumeInfo$isMountedWritable() {
        return this.state == 2;
    }

    private final boolean $$robo$$android_os_storage_VolumeInfo$isPrimary() {
        return (this.mountFlags & 1) != 0;
    }

    private final boolean $$robo$$android_os_storage_VolumeInfo$isPrimaryPhysical() {
        return this.isPrimary() && this.getType() == 0;
    }

    private final boolean $$robo$$android_os_storage_VolumeInfo$isVisible() {
        return (this.mountFlags & 2) != 0;
    }

    private final boolean $$robo$$android_os_storage_VolumeInfo$isVisibleForRead(int userId) {
        if (this.type == 0) {
            if (this.isPrimary() && this.mountUserId != userId) {
                return false;
            }
            return this.isVisible();
        }
        if (this.type == 2) {
            return this.isVisible();
        }
        return false;
    }

    private final boolean $$robo$$android_os_storage_VolumeInfo$isVisibleForWrite(int userId) {
        if (this.type == 0 && this.mountUserId == userId) {
            return this.isVisible();
        }
        if (this.type == 2) {
            return this.isVisible();
        }
        return false;
    }

    private final File $$robo$$android_os_storage_VolumeInfo$getPath() {
        return this.path != null ? new File(this.path) : null;
    }

    private final File $$robo$$android_os_storage_VolumeInfo$getInternalPath() {
        return this.internalPath != null ? new File(this.internalPath) : null;
    }

    private final File $$robo$$android_os_storage_VolumeInfo$getPathForUser(int userId) {
        if (this.path == null) {
            return null;
        }
        if (this.type == 0) {
            return new File(this.path);
        }
        if (this.type == 2) {
            return new File(this.path, Integer.toString(userId));
        }
        return null;
    }

    private final File $$robo$$android_os_storage_VolumeInfo$getInternalPathForUser(int userId) {
        if (this.type == 0) {
            return new File(this.path.replace("/storage/", "/mnt/media_rw/"));
        }
        return this.getPathForUser(userId);
    }

    private final StorageVolume $$robo$$android_os_storage_VolumeInfo$buildStorageVolume(Context context, int userId, boolean reportUnmounted) {
        boolean removable;
        boolean emulated;
        StorageManager storage = context.getSystemService(StorageManager.class);
        boolean allowMassStorage = false;
        String envState = reportUnmounted ? "unmounted" : VolumeInfo.getEnvironmentForState(this.state);
        File userPath = this.getPathForUser(userId);
        if (userPath == null) {
            userPath = new File("/dev/null");
        }
        String description = null;
        String derivedFsUuid = this.fsUuid;
        long mtpReserveSize = 0L;
        long maxFileSize = 0L;
        int mtpStorageId = 0;
        if (this.type == 2) {
            emulated = true;
            VolumeInfo privateVol = storage.findPrivateForEmulated(this);
            if (privateVol != null) {
                description = storage.getBestVolumeDescription(privateVol);
                derivedFsUuid = privateVol.fsUuid;
            }
            if (this.isPrimary()) {
                mtpStorageId = 65537;
            }
            mtpReserveSize = storage.getStorageLowBytes(userPath);
            removable = !"emulated".equals(this.id);
        } else if (this.type == 0) {
            emulated = false;
            removable = true;
            description = storage.getBestVolumeDescription(this);
            mtpStorageId = this.isPrimary() ? 65537 : VolumeInfo.buildStableMtpStorageId(this.fsUuid);
            if ("vfat".equals(this.fsType)) {
                maxFileSize = 0xFFFFFFFFL;
            }
        } else {
            throw new IllegalStateException("Unexpected volume type " + this.type);
        }
        if (description == null) {
            description = context.getString(17039374);
        }
        return new StorageVolume(this.id, mtpStorageId, userPath, description, this.isPrimary(), removable, emulated, mtpReserveSize, false, maxFileSize, new UserHandle(userId), derivedFsUuid, envState);
    }

    private static final int $$robo$$android_os_storage_VolumeInfo$buildStableMtpStorageId(String fsUuid) {
        if (TextUtils.isEmpty(fsUuid)) {
            return 0;
        }
        int hash = 0;
        for (int i = 0; i < fsUuid.length(); ++i) {
            hash = 31 * hash + fsUuid.charAt(i);
        }
        if ((hash = (hash ^ hash << 16) & 0xFFFF0000) == 0) {
            hash = 131072;
        }
        if (hash == 65536) {
            hash = 131072;
        }
        if (hash == -65536) {
            hash = -131072;
        }
        return hash | 1;
    }

    private final Intent $$robo$$android_os_storage_VolumeInfo$buildBrowseIntent() {
        Uri uri;
        if (this.type == 0) {
            uri = DocumentsContract.buildRootUri("com.android.externalstorage.documents", this.fsUuid);
        } else if (this.type == 2 && this.isPrimary()) {
            uri = DocumentsContract.buildRootUri("com.android.externalstorage.documents", "primary");
        } else {
            return null;
        }
        Intent intent = new Intent("android.provider.action.BROWSE");
        intent.addCategory("android.intent.category.DEFAULT");
        intent.setData(uri);
        intent.putExtra("android.content.extra.SHOW_ADVANCED", this.isPrimary());
        intent.putExtra("android.content.extra.FANCY", true);
        intent.putExtra("android.content.extra.SHOW_FILESIZE", true);
        return intent;
    }

    private final String $$robo$$android_os_storage_VolumeInfo$toString() {
        CharArrayWriter writer = new CharArrayWriter();
        this.dump(new IndentingPrintWriter(writer, "    ", 80));
        return writer.toString();
    }

    private final void $$robo$$android_os_storage_VolumeInfo$dump(IndentingPrintWriter pw) {
        pw.println("VolumeInfo{" + this.id + "}:");
        pw.increaseIndent();
        pw.printPair("type", DebugUtils.valueToString(this.getClass(), "TYPE_", this.type));
        pw.printPair("diskId", this.getDiskId());
        pw.printPair("partGuid", this.partGuid);
        pw.printPair("mountFlags", DebugUtils.flagsToString(this.getClass(), "MOUNT_FLAG_", this.mountFlags));
        pw.printPair("mountUserId", this.mountUserId);
        pw.printPair("state", DebugUtils.valueToString(this.getClass(), "STATE_", this.state));
        pw.println();
        pw.printPair("fsType", this.fsType);
        pw.printPair("fsUuid", this.fsUuid);
        pw.printPair("fsLabel", this.fsLabel);
        pw.println();
        pw.printPair("path", this.path);
        pw.printPair("internalPath", this.internalPath);
        pw.decreaseIndent();
        pw.println();
    }

    private final VolumeInfo $$robo$$android_os_storage_VolumeInfo$clone() {
        Parcel temp = Parcel.obtain();
        try {
            this.writeToParcel(temp, 0);
            temp.setDataPosition(0);
            VolumeInfo volumeInfo = CREATOR.createFromParcel(temp);
            return volumeInfo;
        }
        finally {
            temp.recycle();
        }
    }

    private final boolean $$robo$$android_os_storage_VolumeInfo$equals(Object o) {
        if (o instanceof VolumeInfo) {
            return Objects.equals(this.id, ((VolumeInfo)o).id);
        }
        return false;
    }

    private final int $$robo$$android_os_storage_VolumeInfo$hashCode() {
        return this.id.hashCode();
    }

    private final int $$robo$$android_os_storage_VolumeInfo$describeContents() {
        return 0;
    }

    private final void $$robo$$android_os_storage_VolumeInfo$writeToParcel(Parcel parcel, int flags) {
        parcel.writeString(this.id);
        parcel.writeInt(this.type);
        if (this.disk != null) {
            parcel.writeInt(1);
            this.disk.writeToParcel(parcel, flags);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeString(this.partGuid);
        parcel.writeInt(this.mountFlags);
        parcel.writeInt(this.mountUserId);
        parcel.writeInt(this.state);
        parcel.writeString(this.fsType);
        parcel.writeString(this.fsUuid);
        parcel.writeString(this.fsLabel);
        parcel.writeString(this.path);
        parcel.writeString(this.internalPath);
    }

    static void __staticInitializer__() {
        sStateToEnvironment = new SparseArray();
        sEnvironmentToBroadcast = new ArrayMap();
        sStateToDescrip = new SparseIntArray();
        sDescriptionComparator = new Comparator<VolumeInfo>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_os_storage_VolumeInfo_1$__constructor__() {
            }

            private final int $$robo$$android_os_storage_VolumeInfo_1$compare(VolumeInfo lhs, VolumeInfo rhs) {
                if ("private".equals(lhs.getId())) {
                    return -1;
                }
                if (lhs.getDescription() == null) {
                    return 1;
                }
                if (rhs.getDescription() == null) {
                    return -1;
                }
                return lhs.getDescription().compareTo(rhs.getDescription());
            }

            private void __constructor__() {
                this.$$robo$$android_os_storage_VolumeInfo_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_storage_VolumeInfo_1$__constructor__(), 0, this);
            }

            @Override
            public int compare(VolumeInfo volumeInfo, VolumeInfo volumeInfo2) {
                return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$android_os_storage_VolumeInfo_1$compare(android.os.storage.VolumeInfo android.os.storage.VolumeInfo ), 0, this, volumeInfo, volumeInfo2);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        sStateToEnvironment.put(0, "unmounted");
        sStateToEnvironment.put(1, "checking");
        sStateToEnvironment.put(2, "mounted");
        sStateToEnvironment.put(3, "mounted_ro");
        sStateToEnvironment.put(4, "unmounted");
        sStateToEnvironment.put(5, "ejecting");
        sStateToEnvironment.put(6, "unmountable");
        sStateToEnvironment.put(7, "removed");
        sStateToEnvironment.put(8, "bad_removal");
        sEnvironmentToBroadcast.put("unmounted", "android.intent.action.MEDIA_UNMOUNTED");
        sEnvironmentToBroadcast.put("checking", "android.intent.action.MEDIA_CHECKING");
        sEnvironmentToBroadcast.put("mounted", "android.intent.action.MEDIA_MOUNTED");
        sEnvironmentToBroadcast.put("mounted_ro", "android.intent.action.MEDIA_MOUNTED");
        sEnvironmentToBroadcast.put("ejecting", "android.intent.action.MEDIA_EJECT");
        sEnvironmentToBroadcast.put("unmountable", "android.intent.action.MEDIA_UNMOUNTABLE");
        sEnvironmentToBroadcast.put("removed", "android.intent.action.MEDIA_REMOVED");
        sEnvironmentToBroadcast.put("bad_removal", "android.intent.action.MEDIA_BAD_REMOVAL");
        sStateToDescrip.put(0, 17040445);
        sStateToDescrip.put(1, 17040446);
        sStateToDescrip.put(2, 17040447);
        sStateToDescrip.put(3, 0x1040440);
        sStateToDescrip.put(4, 17040453);
        sStateToDescrip.put(5, 0x1040444);
        sStateToDescrip.put(6, 17040450);
        sStateToDescrip.put(7, 17040444);
        sStateToDescrip.put(8, 0x1040441);
        CREATOR = new Parcelable.Creator<VolumeInfo>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_os_storage_VolumeInfo_2$__constructor__() {
            }

            private final VolumeInfo $$robo$$android_os_storage_VolumeInfo_2$createFromParcel(Parcel in) {
                return new VolumeInfo(in);
            }

            private final VolumeInfo[] $$robo$$android_os_storage_VolumeInfo_2$newArray(int size) {
                return new VolumeInfo[size];
            }

            private void __constructor__() {
                this.$$robo$$android_os_storage_VolumeInfo_2$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_storage_VolumeInfo_2$__constructor__(), 0, this);
            }

            @Override
            public VolumeInfo createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_os_storage_VolumeInfo_2$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public VolumeInfo[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_os_storage_VolumeInfo_2$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(String string2, int n, DiskInfo diskInfo, String string3) {
        this.$$robo$$android_os_storage_VolumeInfo$__constructor__(string2, n, diskInfo, string3);
    }

    public VolumeInfo(String string2, int n, DiskInfo diskInfo, String string3) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_storage_VolumeInfo$__constructor__(java.lang.String int android.os.storage.DiskInfo java.lang.String ), 0, this, string2, n, diskInfo, string3);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_os_storage_VolumeInfo$__constructor__(parcel);
    }

    public VolumeInfo(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_storage_VolumeInfo$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    public static String getEnvironmentForState(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getEnvironmentForState", $$robo$$android_os_storage_VolumeInfo$getEnvironmentForState(int ), 0, (int)n);
    }

    public static String getBroadcastForEnvironment(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getBroadcastForEnvironment", $$robo$$android_os_storage_VolumeInfo$getBroadcastForEnvironment(java.lang.String ), 0, (String)string2);
    }

    public static String getBroadcastForState(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getBroadcastForState", $$robo$$android_os_storage_VolumeInfo$getBroadcastForState(int ), 0, (int)n);
    }

    public static Comparator<VolumeInfo> getDescriptionComparator() {
        return InvokeDynamicSupport.bootstrapStatic("getDescriptionComparator", $$robo$$android_os_storage_VolumeInfo$getDescriptionComparator(), 0);
    }

    public String getId() {
        return InvokeDynamicSupport.bootstrap("getId", $$robo$$android_os_storage_VolumeInfo$getId(), 0, this);
    }

    public DiskInfo getDisk() {
        return InvokeDynamicSupport.bootstrap("getDisk", $$robo$$android_os_storage_VolumeInfo$getDisk(), 0, this);
    }

    public String getDiskId() {
        return InvokeDynamicSupport.bootstrap("getDiskId", $$robo$$android_os_storage_VolumeInfo$getDiskId(), 0, this);
    }

    public int getType() {
        return (int)InvokeDynamicSupport.bootstrap("getType", $$robo$$android_os_storage_VolumeInfo$getType(), 0, this);
    }

    public int getState() {
        return (int)InvokeDynamicSupport.bootstrap("getState", $$robo$$android_os_storage_VolumeInfo$getState(), 0, this);
    }

    public int getStateDescription() {
        return (int)InvokeDynamicSupport.bootstrap("getStateDescription", $$robo$$android_os_storage_VolumeInfo$getStateDescription(), 0, this);
    }

    public String getFsUuid() {
        return InvokeDynamicSupport.bootstrap("getFsUuid", $$robo$$android_os_storage_VolumeInfo$getFsUuid(), 0, this);
    }

    public int getMountUserId() {
        return (int)InvokeDynamicSupport.bootstrap("getMountUserId", $$robo$$android_os_storage_VolumeInfo$getMountUserId(), 0, this);
    }

    public String getDescription() {
        return InvokeDynamicSupport.bootstrap("getDescription", $$robo$$android_os_storage_VolumeInfo$getDescription(), 0, this);
    }

    public boolean isMountedReadable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMountedReadable", $$robo$$android_os_storage_VolumeInfo$isMountedReadable(), 0, this);
    }

    public boolean isMountedWritable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMountedWritable", $$robo$$android_os_storage_VolumeInfo$isMountedWritable(), 0, this);
    }

    public boolean isPrimary() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPrimary", $$robo$$android_os_storage_VolumeInfo$isPrimary(), 0, this);
    }

    public boolean isPrimaryPhysical() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPrimaryPhysical", $$robo$$android_os_storage_VolumeInfo$isPrimaryPhysical(), 0, this);
    }

    public boolean isVisible() {
        return (boolean)InvokeDynamicSupport.bootstrap("isVisible", $$robo$$android_os_storage_VolumeInfo$isVisible(), 0, this);
    }

    public boolean isVisibleForRead(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isVisibleForRead", $$robo$$android_os_storage_VolumeInfo$isVisibleForRead(int ), 0, this, n);
    }

    public boolean isVisibleForWrite(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isVisibleForWrite", $$robo$$android_os_storage_VolumeInfo$isVisibleForWrite(int ), 0, this, n);
    }

    public File getPath() {
        return InvokeDynamicSupport.bootstrap("getPath", $$robo$$android_os_storage_VolumeInfo$getPath(), 0, this);
    }

    public File getInternalPath() {
        return InvokeDynamicSupport.bootstrap("getInternalPath", $$robo$$android_os_storage_VolumeInfo$getInternalPath(), 0, this);
    }

    public File getPathForUser(int n) {
        return InvokeDynamicSupport.bootstrap("getPathForUser", $$robo$$android_os_storage_VolumeInfo$getPathForUser(int ), 0, this, n);
    }

    public File getInternalPathForUser(int n) {
        return InvokeDynamicSupport.bootstrap("getInternalPathForUser", $$robo$$android_os_storage_VolumeInfo$getInternalPathForUser(int ), 0, this, n);
    }

    public StorageVolume buildStorageVolume(Context context, int n, boolean bl) {
        return InvokeDynamicSupport.bootstrap("buildStorageVolume", $$robo$$android_os_storage_VolumeInfo$buildStorageVolume(android.content.Context int boolean ), 0, this, context, n, bl);
    }

    public static int buildStableMtpStorageId(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("buildStableMtpStorageId", $$robo$$android_os_storage_VolumeInfo$buildStableMtpStorageId(java.lang.String ), 0, (String)string2);
    }

    public Intent buildBrowseIntent() {
        return InvokeDynamicSupport.bootstrap("buildBrowseIntent", $$robo$$android_os_storage_VolumeInfo$buildBrowseIntent(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_os_storage_VolumeInfo$toString(), 0, this);
    }

    public void dump(IndentingPrintWriter indentingPrintWriter) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_os_storage_VolumeInfo$dump(com.android.internal.util.IndentingPrintWriter ), 0, this, indentingPrintWriter);
    }

    public VolumeInfo clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_os_storage_VolumeInfo$clone(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_os_storage_VolumeInfo$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_os_storage_VolumeInfo$hashCode(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_os_storage_VolumeInfo$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_os_storage_VolumeInfo$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    static {
        RobolectricInternals.classInitializing(VolumeInfo.class);
    }

    public /* synthetic */ VolumeInfo() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VolumeInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

