/*
 * Decompiled with CFR 0.152.
 */
package android.os.storage;

import android.content.Context;
import android.content.Intent;
import android.os.Environment;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.io.CharArrayWriter;
import java.io.File;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class StorageVolume
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private String mId;
    private int mStorageId;
    private File mPath;
    private String mDescription;
    private boolean mPrimary;
    private boolean mRemovable;
    private boolean mEmulated;
    private long mMtpReserveSize;
    private boolean mAllowMassStorage;
    private long mMaxFileSize;
    private UserHandle mOwner;
    private String mFsUuid;
    private String mState;
    public static String EXTRA_STORAGE_VOLUME = "android.os.storage.extra.STORAGE_VOLUME";
    public static String EXTRA_DIRECTORY_NAME = "android.os.storage.extra.DIRECTORY_NAME";
    private static String ACTION_OPEN_EXTERNAL_DIRECTORY = "android.os.storage.action.OPEN_EXTERNAL_DIRECTORY";
    public static int STORAGE_ID_INVALID = 0;
    public static int STORAGE_ID_PRIMARY = 65537;
    public static Parcelable.Creator<StorageVolume> CREATOR;

    private void $$robo$$android_os_storage_StorageVolume$__constructor__(String id2, int storageId, File path, String description, boolean primary, boolean removable, boolean emulated, long mtpReserveSize, boolean allowMassStorage, long maxFileSize, UserHandle owner, String fsUuid, String state) {
        this.mId = Preconditions.checkNotNull(id2);
        this.mStorageId = storageId;
        this.mPath = Preconditions.checkNotNull(path);
        this.mDescription = Preconditions.checkNotNull(description);
        this.mPrimary = primary;
        this.mRemovable = removable;
        this.mEmulated = emulated;
        this.mMtpReserveSize = mtpReserveSize;
        this.mAllowMassStorage = allowMassStorage;
        this.mMaxFileSize = maxFileSize;
        this.mOwner = Preconditions.checkNotNull(owner);
        this.mFsUuid = fsUuid;
        this.mState = Preconditions.checkNotNull(state);
    }

    private void $$robo$$android_os_storage_StorageVolume$__constructor__(Parcel in) {
        this.mId = in.readString();
        this.mStorageId = in.readInt();
        this.mPath = new File(in.readString());
        this.mDescription = in.readString();
        this.mPrimary = in.readInt() != 0;
        this.mRemovable = in.readInt() != 0;
        this.mEmulated = in.readInt() != 0;
        this.mMtpReserveSize = in.readLong();
        this.mAllowMassStorage = in.readInt() != 0;
        this.mMaxFileSize = in.readLong();
        this.mOwner = (UserHandle)in.readParcelable(null);
        this.mFsUuid = in.readString();
        this.mState = in.readString();
    }

    private final String $$robo$$android_os_storage_StorageVolume$getId() {
        return this.mId;
    }

    private final String $$robo$$android_os_storage_StorageVolume$getPath() {
        return this.mPath.toString();
    }

    private final File $$robo$$android_os_storage_StorageVolume$getPathFile() {
        return this.mPath;
    }

    private final String $$robo$$android_os_storage_StorageVolume$getDescription(Context context) {
        return this.mDescription;
    }

    private final boolean $$robo$$android_os_storage_StorageVolume$isPrimary() {
        return this.mPrimary;
    }

    private final boolean $$robo$$android_os_storage_StorageVolume$isRemovable() {
        return this.mRemovable;
    }

    private final boolean $$robo$$android_os_storage_StorageVolume$isEmulated() {
        return this.mEmulated;
    }

    private final int $$robo$$android_os_storage_StorageVolume$getStorageId() {
        return this.mStorageId;
    }

    private final int $$robo$$android_os_storage_StorageVolume$getMtpReserveSpace() {
        return (int)(this.mMtpReserveSize / 0x100000L);
    }

    private final boolean $$robo$$android_os_storage_StorageVolume$allowMassStorage() {
        return this.mAllowMassStorage;
    }

    private final long $$robo$$android_os_storage_StorageVolume$getMaxFileSize() {
        return this.mMaxFileSize;
    }

    private final UserHandle $$robo$$android_os_storage_StorageVolume$getOwner() {
        return this.mOwner;
    }

    private final String $$robo$$android_os_storage_StorageVolume$getUuid() {
        return this.mFsUuid;
    }

    private final int $$robo$$android_os_storage_StorageVolume$getFatVolumeId() {
        if (this.mFsUuid == null || this.mFsUuid.length() != 9) {
            return -1;
        }
        try {
            return (int)Long.parseLong(this.mFsUuid.replace("-", ""), 16);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private final String $$robo$$android_os_storage_StorageVolume$getUserLabel() {
        return this.mDescription;
    }

    private final String $$robo$$android_os_storage_StorageVolume$getState() {
        return this.mState;
    }

    private final Intent $$robo$$android_os_storage_StorageVolume$createAccessIntent(String directoryName) {
        if (this.isPrimary() && directoryName == null || directoryName != null && !Environment.isStandardDirectory(directoryName)) {
            return null;
        }
        Intent intent = new Intent("android.os.storage.action.OPEN_EXTERNAL_DIRECTORY");
        intent.putExtra("android.os.storage.extra.STORAGE_VOLUME", this);
        intent.putExtra("android.os.storage.extra.DIRECTORY_NAME", directoryName);
        return intent;
    }

    private final boolean $$robo$$android_os_storage_StorageVolume$equals(Object obj) {
        if (obj instanceof StorageVolume && this.mPath != null) {
            StorageVolume volume = (StorageVolume)obj;
            return this.mPath.equals(volume.mPath);
        }
        return false;
    }

    private final int $$robo$$android_os_storage_StorageVolume$hashCode() {
        return this.mPath.hashCode();
    }

    private final String $$robo$$android_os_storage_StorageVolume$toString() {
        StringBuilder buffer = new StringBuilder("StorageVolume: ").append(this.mDescription);
        if (this.mFsUuid != null) {
            buffer.append(" (").append(this.mFsUuid).append(")");
        }
        return buffer.toString();
    }

    private final String $$robo$$android_os_storage_StorageVolume$dump() {
        CharArrayWriter writer = new CharArrayWriter();
        this.dump(new IndentingPrintWriter(writer, "    ", 80));
        return writer.toString();
    }

    private final void $$robo$$android_os_storage_StorageVolume$dump(IndentingPrintWriter pw) {
        pw.println("StorageVolume:");
        pw.increaseIndent();
        pw.printPair("mId", this.mId);
        pw.printPair("mStorageId", this.mStorageId);
        pw.printPair("mPath", this.mPath);
        pw.printPair("mDescription", this.mDescription);
        pw.printPair("mPrimary", this.mPrimary);
        pw.printPair("mRemovable", this.mRemovable);
        pw.printPair("mEmulated", this.mEmulated);
        pw.printPair("mMtpReserveSize", this.mMtpReserveSize);
        pw.printPair("mAllowMassStorage", this.mAllowMassStorage);
        pw.printPair("mMaxFileSize", this.mMaxFileSize);
        pw.printPair("mOwner", this.mOwner);
        pw.printPair("mFsUuid", this.mFsUuid);
        pw.printPair("mState", this.mState);
        pw.decreaseIndent();
    }

    private final int $$robo$$android_os_storage_StorageVolume$describeContents() {
        return 0;
    }

    private final void $$robo$$android_os_storage_StorageVolume$writeToParcel(Parcel parcel, int flags) {
        parcel.writeString(this.mId);
        parcel.writeInt(this.mStorageId);
        parcel.writeString(this.mPath.toString());
        parcel.writeString(this.mDescription);
        parcel.writeInt(this.mPrimary ? 1 : 0);
        parcel.writeInt(this.mRemovable ? 1 : 0);
        parcel.writeInt(this.mEmulated ? 1 : 0);
        parcel.writeLong(this.mMtpReserveSize);
        parcel.writeInt(this.mAllowMassStorage ? 1 : 0);
        parcel.writeLong(this.mMaxFileSize);
        parcel.writeParcelable(this.mOwner, flags);
        parcel.writeString(this.mFsUuid);
        parcel.writeString(this.mState);
    }

    private /* synthetic */ void $$robo$$android_os_storage_StorageVolume$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<StorageVolume>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_os_storage_StorageVolume_1$__constructor__() {
            }

            private final StorageVolume $$robo$$android_os_storage_StorageVolume_1$createFromParcel(Parcel in) {
                return new StorageVolume(in);
            }

            private final StorageVolume[] $$robo$$android_os_storage_StorageVolume_1$newArray(int size) {
                return new StorageVolume[size];
            }

            private void __constructor__() {
                this.$$robo$$android_os_storage_StorageVolume_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_storage_StorageVolume_1$__constructor__(), 0, this);
            }

            @Override
            public StorageVolume createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_os_storage_StorageVolume_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public StorageVolume[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_os_storage_StorageVolume_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(String string2, int n, File file, String string3, boolean bl, boolean bl2, boolean bl3, long l, boolean bl4, long l2, UserHandle userHandle, String string4, String string5) {
        this.$$robo$$android_os_storage_StorageVolume$__constructor__(string2, n, file, string3, bl, bl2, bl3, l, bl4, l2, userHandle, string4, string5);
    }

    public StorageVolume(String string2, int n, File file, String string3, boolean bl, boolean bl2, boolean bl3, long l, boolean bl4, long l2, UserHandle userHandle, String string4, String string5) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_storage_StorageVolume$__constructor__(java.lang.String int java.io.File java.lang.String boolean boolean boolean long boolean long android.os.UserHandle java.lang.String java.lang.String ), 0, this, string2, n, file, string3, bl, bl2, bl3, l, bl4, l2, userHandle, string4, string5);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_os_storage_StorageVolume$__constructor__(parcel);
    }

    private StorageVolume(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_storage_StorageVolume$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    public String getId() {
        return InvokeDynamicSupport.bootstrap("getId", $$robo$$android_os_storage_StorageVolume$getId(), 0, this);
    }

    public String getPath() {
        return InvokeDynamicSupport.bootstrap("getPath", $$robo$$android_os_storage_StorageVolume$getPath(), 0, this);
    }

    public File getPathFile() {
        return InvokeDynamicSupport.bootstrap("getPathFile", $$robo$$android_os_storage_StorageVolume$getPathFile(), 0, this);
    }

    public String getDescription(Context context) {
        return InvokeDynamicSupport.bootstrap("getDescription", $$robo$$android_os_storage_StorageVolume$getDescription(android.content.Context ), 0, this, context);
    }

    public boolean isPrimary() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPrimary", $$robo$$android_os_storage_StorageVolume$isPrimary(), 0, this);
    }

    public boolean isRemovable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRemovable", $$robo$$android_os_storage_StorageVolume$isRemovable(), 0, this);
    }

    public boolean isEmulated() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEmulated", $$robo$$android_os_storage_StorageVolume$isEmulated(), 0, this);
    }

    public int getStorageId() {
        return (int)InvokeDynamicSupport.bootstrap("getStorageId", $$robo$$android_os_storage_StorageVolume$getStorageId(), 0, this);
    }

    public int getMtpReserveSpace() {
        return (int)InvokeDynamicSupport.bootstrap("getMtpReserveSpace", $$robo$$android_os_storage_StorageVolume$getMtpReserveSpace(), 0, this);
    }

    public boolean allowMassStorage() {
        return (boolean)InvokeDynamicSupport.bootstrap("allowMassStorage", $$robo$$android_os_storage_StorageVolume$allowMassStorage(), 0, this);
    }

    public long getMaxFileSize() {
        return (long)InvokeDynamicSupport.bootstrap("getMaxFileSize", $$robo$$android_os_storage_StorageVolume$getMaxFileSize(), 0, this);
    }

    public UserHandle getOwner() {
        return InvokeDynamicSupport.bootstrap("getOwner", $$robo$$android_os_storage_StorageVolume$getOwner(), 0, this);
    }

    public String getUuid() {
        return InvokeDynamicSupport.bootstrap("getUuid", $$robo$$android_os_storage_StorageVolume$getUuid(), 0, this);
    }

    public int getFatVolumeId() {
        return (int)InvokeDynamicSupport.bootstrap("getFatVolumeId", $$robo$$android_os_storage_StorageVolume$getFatVolumeId(), 0, this);
    }

    public String getUserLabel() {
        return InvokeDynamicSupport.bootstrap("getUserLabel", $$robo$$android_os_storage_StorageVolume$getUserLabel(), 0, this);
    }

    public String getState() {
        return InvokeDynamicSupport.bootstrap("getState", $$robo$$android_os_storage_StorageVolume$getState(), 0, this);
    }

    public Intent createAccessIntent(String string2) {
        return InvokeDynamicSupport.bootstrap("createAccessIntent", $$robo$$android_os_storage_StorageVolume$createAccessIntent(java.lang.String ), 0, this, string2);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_os_storage_StorageVolume$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_os_storage_StorageVolume$hashCode(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_os_storage_StorageVolume$toString(), 0, this);
    }

    public String dump() {
        return InvokeDynamicSupport.bootstrap("dump", $$robo$$android_os_storage_StorageVolume$dump(), 0, this);
    }

    public void dump(IndentingPrintWriter indentingPrintWriter) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_os_storage_StorageVolume$dump(com.android.internal.util.IndentingPrintWriter ), 0, this, indentingPrintWriter);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_os_storage_StorageVolume$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_os_storage_StorageVolume$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_os_storage_StorageVolume$__constructor__(parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(StorageVolume.class);
    }

    public /* synthetic */ StorageVolume() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StorageVolume)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

