/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Process;
import com.google.errorprone.annotations.DoNotMock;
import java.io.PrintWriter;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class UserHandle
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int PER_USER_RANGE = 100000;
    public static int USER_ALL = -1;
    public static UserHandle ALL;
    public static int USER_CURRENT = -2;
    public static UserHandle CURRENT;
    public static int USER_CURRENT_OR_SELF = -3;
    public static UserHandle CURRENT_OR_SELF;
    public static int USER_NULL = -10000;
    public static int USER_OWNER = 0;
    public static UserHandle OWNER;
    public static int USER_SYSTEM = 0;
    public static int USER_SERIAL_SYSTEM = 0;
    public static UserHandle SYSTEM;
    public static boolean MU_ENABLED = true;
    int mHandle;
    public static Parcelable.Creator<UserHandle> CREATOR;

    private static final boolean $$robo$$android_os_UserHandle$isSameUser(int uid1, int uid2) {
        return UserHandle.getUserId(uid1) == UserHandle.getUserId(uid2);
    }

    private static final boolean $$robo$$android_os_UserHandle$isSameApp(int uid1, int uid2) {
        return UserHandle.getAppId(uid1) == UserHandle.getAppId(uid2);
    }

    private static final boolean $$robo$$android_os_UserHandle$isIsolated(int uid) {
        if (uid > 0) {
            int appId = UserHandle.getAppId(uid);
            return appId >= 99000 && appId <= 99999;
        }
        return false;
    }

    private static final boolean $$robo$$android_os_UserHandle$isApp(int uid) {
        if (uid > 0) {
            int appId = UserHandle.getAppId(uid);
            return appId >= 10000 && appId <= 19999;
        }
        return false;
    }

    private static final UserHandle $$robo$$android_os_UserHandle$getUserHandleForUid(int uid) {
        return UserHandle.of(UserHandle.getUserId(uid));
    }

    private static final int $$robo$$android_os_UserHandle$getUserId(int uid) {
        return uid / 100000;
    }

    private static final int $$robo$$android_os_UserHandle$getCallingUserId() {
        return UserHandle.getUserId(Binder.getCallingUid());
    }

    private static final UserHandle $$robo$$android_os_UserHandle$of(int userId) {
        return userId == 0 ? SYSTEM : new UserHandle(userId);
    }

    private static final int $$robo$$android_os_UserHandle$getUid(int userId, int appId) {
        return userId * 100000 + appId % 100000;
    }

    private static final int $$robo$$android_os_UserHandle$getAppId(int uid) {
        return uid % 100000;
    }

    private static final int $$robo$$android_os_UserHandle$getUserGid(int userId) {
        return UserHandle.getUid(userId, 9997);
    }

    private static final int $$robo$$android_os_UserHandle$getSharedAppGid(int id2) {
        return 50000 + id2 % 100000 - 10000;
    }

    private static final int $$robo$$android_os_UserHandle$getAppIdFromSharedAppGid(int gid) {
        int appId = UserHandle.getAppId(gid) + 10000 - 50000;
        if (appId < 0 || appId >= 50000) {
            return -1;
        }
        return appId;
    }

    private static final void $$robo$$android_os_UserHandle$formatUid(StringBuilder sb, int uid) {
        if (uid < 10000) {
            sb.append(uid);
        } else {
            sb.append('u');
            sb.append(UserHandle.getUserId(uid));
            int appId = UserHandle.getAppId(uid);
            if (appId >= 99000 && appId <= 99999) {
                sb.append('i');
                sb.append(appId - 99000);
            } else if (appId >= 10000) {
                sb.append('a');
                sb.append(appId - 10000);
            } else {
                sb.append('s');
                sb.append(appId);
            }
        }
    }

    private static final String $$robo$$android_os_UserHandle$formatUid(int uid) {
        StringBuilder sb = new StringBuilder();
        UserHandle.formatUid(sb, uid);
        return sb.toString();
    }

    private static final void $$robo$$android_os_UserHandle$formatUid(PrintWriter pw, int uid) {
        if (uid < 10000) {
            pw.print(uid);
        } else {
            pw.print('u');
            pw.print(UserHandle.getUserId(uid));
            int appId = UserHandle.getAppId(uid);
            if (appId >= 99000 && appId <= 99999) {
                pw.print('i');
                pw.print(appId - 99000);
            } else if (appId >= 10000) {
                pw.print('a');
                pw.print(appId - 10000);
            } else {
                pw.print('s');
                pw.print(appId);
            }
        }
    }

    private static final int $$robo$$android_os_UserHandle$parseUserArg(String arg) {
        int userId;
        if ("all".equals(arg)) {
            userId = -1;
        } else if ("current".equals(arg) || "cur".equals(arg)) {
            userId = -2;
        } else {
            try {
                userId = Integer.parseInt(arg);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Bad user number: " + arg);
            }
        }
        return userId;
    }

    private static final int $$robo$$android_os_UserHandle$myUserId() {
        return UserHandle.getUserId(Process.myUid());
    }

    private final boolean $$robo$$android_os_UserHandle$isOwner() {
        return this.equals(OWNER);
    }

    private final boolean $$robo$$android_os_UserHandle$isSystem() {
        return this.equals(SYSTEM);
    }

    private void $$robo$$android_os_UserHandle$__constructor__(int h) {
        this.mHandle = h;
    }

    private final int $$robo$$android_os_UserHandle$getIdentifier() {
        return this.mHandle;
    }

    private final String $$robo$$android_os_UserHandle$toString() {
        return "UserHandle{" + this.mHandle + "}";
    }

    private final boolean $$robo$$android_os_UserHandle$equals(Object obj) {
        try {
            if (obj != null) {
                UserHandle other = (UserHandle)obj;
                return this.mHandle == other.mHandle;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return false;
    }

    private final int $$robo$$android_os_UserHandle$hashCode() {
        return this.mHandle;
    }

    private final int $$robo$$android_os_UserHandle$describeContents() {
        return 0;
    }

    private final void $$robo$$android_os_UserHandle$writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mHandle);
    }

    private static final void $$robo$$android_os_UserHandle$writeToParcel(UserHandle h, Parcel out) {
        if (h != null) {
            h.writeToParcel(out, 0);
        } else {
            out.writeInt(-10000);
        }
    }

    private static final UserHandle $$robo$$android_os_UserHandle$readFromParcel(Parcel in) {
        int h = in.readInt();
        return h != -10000 ? new UserHandle(h) : null;
    }

    private void $$robo$$android_os_UserHandle$__constructor__(Parcel in) {
        this.mHandle = in.readInt();
    }

    static void __staticInitializer__() {
        ALL = new UserHandle(-1);
        CURRENT = new UserHandle(-2);
        CURRENT_OR_SELF = new UserHandle(-3);
        OWNER = new UserHandle(0);
        SYSTEM = new UserHandle(0);
        CREATOR = new Parcelable.Creator<UserHandle>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_os_UserHandle_1$__constructor__() {
            }

            private final UserHandle $$robo$$android_os_UserHandle_1$createFromParcel(Parcel in) {
                return new UserHandle(in);
            }

            private final UserHandle[] $$robo$$android_os_UserHandle_1$newArray(int size) {
                return new UserHandle[size];
            }

            private void __constructor__() {
                this.$$robo$$android_os_UserHandle_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_UserHandle_1$__constructor__(), 0, this);
            }

            @Override
            public UserHandle createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_os_UserHandle_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public UserHandle[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_os_UserHandle_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    public static boolean isSameUser(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSameUser", $$robo$$android_os_UserHandle$isSameUser(int int ), 0, (int)n, (int)n2);
    }

    public static boolean isSameApp(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSameApp", $$robo$$android_os_UserHandle$isSameApp(int int ), 0, (int)n, (int)n2);
    }

    public static boolean isIsolated(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isIsolated", $$robo$$android_os_UserHandle$isIsolated(int ), 0, (int)n);
    }

    public static boolean isApp(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isApp", $$robo$$android_os_UserHandle$isApp(int ), 0, (int)n);
    }

    public static UserHandle getUserHandleForUid(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getUserHandleForUid", $$robo$$android_os_UserHandle$getUserHandleForUid(int ), 0, (int)n);
    }

    public static int getUserId(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getUserId", $$robo$$android_os_UserHandle$getUserId(int ), 0, (int)n);
    }

    public static int getCallingUserId() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getCallingUserId", $$robo$$android_os_UserHandle$getCallingUserId(), 0);
    }

    public static UserHandle of(int n) {
        return InvokeDynamicSupport.bootstrapStatic("of", $$robo$$android_os_UserHandle$of(int ), 0, (int)n);
    }

    public static int getUid(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getUid", $$robo$$android_os_UserHandle$getUid(int int ), 0, (int)n, (int)n2);
    }

    public static int getAppId(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getAppId", $$robo$$android_os_UserHandle$getAppId(int ), 0, (int)n);
    }

    public static int getUserGid(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getUserGid", $$robo$$android_os_UserHandle$getUserGid(int ), 0, (int)n);
    }

    public static int getSharedAppGid(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getSharedAppGid", $$robo$$android_os_UserHandle$getSharedAppGid(int ), 0, (int)n);
    }

    public static int getAppIdFromSharedAppGid(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getAppIdFromSharedAppGid", $$robo$$android_os_UserHandle$getAppIdFromSharedAppGid(int ), 0, (int)n);
    }

    public static void formatUid(StringBuilder stringBuilder, int n) {
        InvokeDynamicSupport.bootstrapStatic("formatUid", $$robo$$android_os_UserHandle$formatUid(java.lang.StringBuilder int ), 0, (StringBuilder)stringBuilder, (int)n);
    }

    public static String formatUid(int n) {
        return InvokeDynamicSupport.bootstrapStatic("formatUid", $$robo$$android_os_UserHandle$formatUid(int ), 0, (int)n);
    }

    public static void formatUid(PrintWriter printWriter, int n) {
        InvokeDynamicSupport.bootstrapStatic("formatUid", $$robo$$android_os_UserHandle$formatUid(java.io.PrintWriter int ), 0, (PrintWriter)printWriter, (int)n);
    }

    public static int parseUserArg(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("parseUserArg", $$robo$$android_os_UserHandle$parseUserArg(java.lang.String ), 0, (String)string2);
    }

    public static int myUserId() {
        return (int)InvokeDynamicSupport.bootstrapStatic("myUserId", $$robo$$android_os_UserHandle$myUserId(), 0);
    }

    public boolean isOwner() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOwner", $$robo$$android_os_UserHandle$isOwner(), 0, this);
    }

    public boolean isSystem() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSystem", $$robo$$android_os_UserHandle$isSystem(), 0, this);
    }

    private void __constructor__(int n) {
        this.$$robo$$android_os_UserHandle$__constructor__(n);
    }

    public UserHandle(int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_UserHandle$__constructor__(int ), 0, this, n);
    }

    public int getIdentifier() {
        return (int)InvokeDynamicSupport.bootstrap("getIdentifier", $$robo$$android_os_UserHandle$getIdentifier(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_os_UserHandle$toString(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_os_UserHandle$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_os_UserHandle$hashCode(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_os_UserHandle$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_os_UserHandle$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public static void writeToParcel(UserHandle userHandle, Parcel parcel) {
        InvokeDynamicSupport.bootstrapStatic("writeToParcel", $$robo$$android_os_UserHandle$writeToParcel(android.os.UserHandle android.os.Parcel ), 0, (UserHandle)userHandle, (Parcel)parcel);
    }

    public static UserHandle readFromParcel(Parcel parcel) {
        return InvokeDynamicSupport.bootstrapStatic("readFromParcel", $$robo$$android_os_UserHandle$readFromParcel(android.os.Parcel ), 0, (Parcel)parcel);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_os_UserHandle$__constructor__(parcel);
    }

    public UserHandle(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_UserHandle$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    static {
        RobolectricInternals.classInitializing(UserHandle.class);
    }

    public /* synthetic */ UserHandle() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UserHandle)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

