/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.IBinder;
import android.os.IServiceManager;
import android.os.RemoteException;
import android.os.ServiceManagerNative;
import android.util.Log;
import com.android.internal.os.BinderInternal;
import com.google.errorprone.annotations.DoNotMock;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class ServiceManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "ServiceManager";
    private static IServiceManager sServiceManager;
    private static HashMap<String, IBinder> sCache;

    private void $$robo$$android_os_ServiceManager$__constructor__() {
    }

    private static final IServiceManager $$robo$$android_os_ServiceManager$getIServiceManager() {
        if (sServiceManager != null) {
            return sServiceManager;
        }
        sServiceManager = ServiceManagerNative.asInterface(BinderInternal.getContextObject());
        return sServiceManager;
    }

    private static final IBinder $$robo$$android_os_ServiceManager$getService(String name) {
        try {
            IBinder service = sCache.get(name);
            if (service != null) {
                return service;
            }
            return ServiceManager.getIServiceManager().getService(name);
        }
        catch (RemoteException e) {
            Log.e("ServiceManager", "error in getService", e);
            return null;
        }
    }

    private static final void $$robo$$android_os_ServiceManager$addService(String name, IBinder service) {
        try {
            ServiceManager.getIServiceManager().addService(name, service, false);
        }
        catch (RemoteException e) {
            Log.e("ServiceManager", "error in addService", e);
        }
    }

    private static final void $$robo$$android_os_ServiceManager$addService(String name, IBinder service, boolean allowIsolated) {
        try {
            ServiceManager.getIServiceManager().addService(name, service, allowIsolated);
        }
        catch (RemoteException e) {
            Log.e("ServiceManager", "error in addService", e);
        }
    }

    private static final IBinder $$robo$$android_os_ServiceManager$checkService(String name) {
        try {
            IBinder service = sCache.get(name);
            if (service != null) {
                return service;
            }
            return ServiceManager.getIServiceManager().checkService(name);
        }
        catch (RemoteException e) {
            Log.e("ServiceManager", "error in checkService", e);
            return null;
        }
    }

    private static final String[] $$robo$$android_os_ServiceManager$listServices() {
        try {
            return ServiceManager.getIServiceManager().listServices();
        }
        catch (RemoteException e) {
            Log.e("ServiceManager", "error in listServices", e);
            return null;
        }
    }

    private static final void $$robo$$android_os_ServiceManager$initServiceCache(Map<String, IBinder> cache) {
        if (sCache.size() != 0) {
            throw new IllegalStateException("setServiceCache may only be called once");
        }
        sCache.putAll(cache);
    }

    static void __staticInitializer__() {
        sCache = new HashMap();
    }

    private void __constructor__() {
        this.$$robo$$android_os_ServiceManager$__constructor__();
    }

    public ServiceManager() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_ServiceManager$__constructor__(), 0, this);
    }

    private static IServiceManager getIServiceManager() {
        return InvokeDynamicSupport.bootstrapStatic("getIServiceManager", $$robo$$android_os_ServiceManager$getIServiceManager(), 0);
    }

    public static IBinder getService(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getService", $$robo$$android_os_ServiceManager$getService(java.lang.String ), 0, (String)string2);
    }

    public static void addService(String string2, IBinder iBinder) {
        InvokeDynamicSupport.bootstrapStatic("addService", $$robo$$android_os_ServiceManager$addService(java.lang.String android.os.IBinder ), 0, (String)string2, (IBinder)iBinder);
    }

    public static void addService(String string2, IBinder iBinder, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("addService", $$robo$$android_os_ServiceManager$addService(java.lang.String android.os.IBinder boolean ), 0, (String)string2, (IBinder)iBinder, (boolean)bl);
    }

    public static IBinder checkService(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("checkService", $$robo$$android_os_ServiceManager$checkService(java.lang.String ), 0, (String)string2);
    }

    public static String[] listServices() {
        return InvokeDynamicSupport.bootstrapStatic("listServices", $$robo$$android_os_ServiceManager$listServices(), 0);
    }

    public static void initServiceCache(Map<String, IBinder> map) {
        InvokeDynamicSupport.bootstrapStatic("initServiceCache", $$robo$$android_os_ServiceManager$initServiceCache(java.util.Map<java.lang.String, android.os.IBinder> ), 0, map);
    }

    static {
        RobolectricInternals.classInitializing(ServiceManager.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ServiceManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

