/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.util.Log;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class MemoryFile
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG;
    private static int PROT_READ = 1;
    private static int PROT_WRITE = 2;
    private FileDescriptor mFD;
    private long mAddress;
    private int mLength;
    private boolean mAllowPurging;

    private static final FileDescriptor $$robo$$android_os_MemoryFile$native_open(String string2, int n) throws IOException {
        return null;
    }

    private static final long $$robo$$android_os_MemoryFile$native_mmap(FileDescriptor fileDescriptor, int n, int n2) throws IOException {
        return 0L;
    }

    private static final void $$robo$$android_os_MemoryFile$native_munmap(long l, int n) throws IOException {
    }

    private static final void $$robo$$android_os_MemoryFile$native_close(FileDescriptor fileDescriptor) {
    }

    private static final int $$robo$$android_os_MemoryFile$native_read(FileDescriptor fileDescriptor, long l, byte[] byArray, int n, int n2, int n3, boolean bl) throws IOException {
        return 0;
    }

    private static final void $$robo$$android_os_MemoryFile$native_write(FileDescriptor fileDescriptor, long l, byte[] byArray, int n, int n2, int n3, boolean bl) throws IOException {
    }

    private static final void $$robo$$android_os_MemoryFile$native_pin(FileDescriptor fileDescriptor, boolean bl) throws IOException {
    }

    private static final int $$robo$$android_os_MemoryFile$native_get_size(FileDescriptor fileDescriptor) throws IOException {
        return 0;
    }

    private void $$robo$$android_os_MemoryFile$__constructor__(String name, int length) throws IOException {
        this.mAllowPurging = false;
        this.mLength = length;
        if (length < 0) {
            throw new IOException("Invalid length: " + length);
        }
        this.mFD = MemoryFile.native_open(name, length);
        this.mAddress = length > 0 ? MemoryFile.native_mmap(this.mFD, length, 3) : 0L;
    }

    private final void $$robo$$android_os_MemoryFile$close() {
        this.deactivate();
        if (!this.isClosed()) {
            MemoryFile.native_close(this.mFD);
        }
    }

    private final void $$robo$$android_os_MemoryFile$deactivate() {
        if (!this.isDeactivated()) {
            try {
                MemoryFile.native_munmap(this.mAddress, this.mLength);
                this.mAddress = 0L;
            }
            catch (IOException ex) {
                Log.e(TAG, ex.toString());
            }
        }
    }

    private final boolean $$robo$$android_os_MemoryFile$isDeactivated() {
        return this.mAddress == 0L;
    }

    private final boolean $$robo$$android_os_MemoryFile$isClosed() {
        return !this.mFD.valid();
    }

    private final void $$robo$$android_os_MemoryFile$finalize() {
        if (!this.isClosed()) {
            Log.e(TAG, "MemoryFile.finalize() called while ashmem still open");
            this.close();
        }
    }

    private final int $$robo$$android_os_MemoryFile$length() {
        return this.mLength;
    }

    private final boolean $$robo$$android_os_MemoryFile$isPurgingAllowed() {
        return this.mAllowPurging;
    }

    private final synchronized boolean $$robo$$android_os_MemoryFile$allowPurging(boolean allowPurging) throws IOException {
        boolean oldValue = this.mAllowPurging;
        if (oldValue != allowPurging) {
            MemoryFile.native_pin(this.mFD, !allowPurging);
            this.mAllowPurging = allowPurging;
        }
        return oldValue;
    }

    private final InputStream $$robo$$android_os_MemoryFile$getInputStream() {
        return new MemoryInputStream(this);
    }

    private final OutputStream $$robo$$android_os_MemoryFile$getOutputStream() {
        return new MemoryOutputStream(this);
    }

    private final int $$robo$$android_os_MemoryFile$readBytes(byte[] buffer, int srcOffset, int destOffset, int count) throws IOException {
        if (this.isDeactivated()) {
            throw new IOException("Can't read from deactivated memory file.");
        }
        if (destOffset < 0 || destOffset > buffer.length || count < 0 || count > buffer.length - destOffset || srcOffset < 0 || srcOffset > this.mLength || count > this.mLength - srcOffset) {
            throw new IndexOutOfBoundsException();
        }
        return MemoryFile.native_read(this.mFD, this.mAddress, buffer, srcOffset, destOffset, count, this.mAllowPurging);
    }

    private final void $$robo$$android_os_MemoryFile$writeBytes(byte[] buffer, int srcOffset, int destOffset, int count) throws IOException {
        if (this.isDeactivated()) {
            throw new IOException("Can't write to deactivated memory file.");
        }
        if (srcOffset < 0 || srcOffset > buffer.length || count < 0 || count > buffer.length - srcOffset || destOffset < 0 || destOffset > this.mLength || count > this.mLength - destOffset) {
            throw new IndexOutOfBoundsException();
        }
        MemoryFile.native_write(this.mFD, this.mAddress, buffer, srcOffset, destOffset, count, this.mAllowPurging);
    }

    private final FileDescriptor $$robo$$android_os_MemoryFile$getFileDescriptor() throws IOException {
        return this.mFD;
    }

    private static final int $$robo$$android_os_MemoryFile$getSize(FileDescriptor fd) throws IOException {
        return MemoryFile.native_get_size(fd);
    }

    static void __staticInitializer__() {
        TAG = "MemoryFile";
    }

    private static final native /* synthetic */ FileDescriptor $$robo$$native_open$nativeBinding(String var0, int var1) throws IOException;

    private static FileDescriptor native_open(String string2, int n) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("native_open", $$robo$$android_os_MemoryFile$native_open(java.lang.String int ), 1, (String)string2, (int)n);
    }

    private static final native /* synthetic */ long $$robo$$native_mmap$nativeBinding(FileDescriptor var0, int var1, int var2) throws IOException;

    private static long native_mmap(FileDescriptor fileDescriptor, int n, int n2) throws IOException {
        return (long)InvokeDynamicSupport.bootstrapStatic("native_mmap", $$robo$$android_os_MemoryFile$native_mmap(java.io.FileDescriptor int int ), 1, (FileDescriptor)fileDescriptor, (int)n, (int)n2);
    }

    private static final native /* synthetic */ void $$robo$$native_munmap$nativeBinding(long var0, int var2) throws IOException;

    private static void native_munmap(long l, int n) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("native_munmap", $$robo$$android_os_MemoryFile$native_munmap(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ void $$robo$$native_close$nativeBinding(FileDescriptor var0);

    private static void native_close(FileDescriptor fileDescriptor) {
        InvokeDynamicSupport.bootstrapStatic("native_close", $$robo$$android_os_MemoryFile$native_close(java.io.FileDescriptor ), 1, (FileDescriptor)fileDescriptor);
    }

    private static final native /* synthetic */ int $$robo$$native_read$nativeBinding(FileDescriptor var0, long var1, byte[] var3, int var4, int var5, int var6, boolean var7) throws IOException;

    private static int native_read(FileDescriptor fileDescriptor, long l, byte[] byArray, int n, int n2, int n3, boolean bl) throws IOException {
        return (int)InvokeDynamicSupport.bootstrapStatic("native_read", $$robo$$android_os_MemoryFile$native_read(java.io.FileDescriptor long byte[] int int int boolean ), 1, (FileDescriptor)fileDescriptor, (long)l, (byte[])byArray, (int)n, (int)n2, (int)n3, (boolean)bl);
    }

    private static final native /* synthetic */ void $$robo$$native_write$nativeBinding(FileDescriptor var0, long var1, byte[] var3, int var4, int var5, int var6, boolean var7) throws IOException;

    private static void native_write(FileDescriptor fileDescriptor, long l, byte[] byArray, int n, int n2, int n3, boolean bl) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("native_write", $$robo$$android_os_MemoryFile$native_write(java.io.FileDescriptor long byte[] int int int boolean ), 1, (FileDescriptor)fileDescriptor, (long)l, (byte[])byArray, (int)n, (int)n2, (int)n3, (boolean)bl);
    }

    private static final native /* synthetic */ void $$robo$$native_pin$nativeBinding(FileDescriptor var0, boolean var1) throws IOException;

    private static void native_pin(FileDescriptor fileDescriptor, boolean bl) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("native_pin", $$robo$$android_os_MemoryFile$native_pin(java.io.FileDescriptor boolean ), 1, (FileDescriptor)fileDescriptor, (boolean)bl);
    }

    private static final native /* synthetic */ int $$robo$$native_get_size$nativeBinding(FileDescriptor var0) throws IOException;

    private static int native_get_size(FileDescriptor fileDescriptor) throws IOException {
        return (int)InvokeDynamicSupport.bootstrapStatic("native_get_size", $$robo$$android_os_MemoryFile$native_get_size(java.io.FileDescriptor ), 1, (FileDescriptor)fileDescriptor);
    }

    private void __constructor__(String string2, int n) throws IOException {
        this.$$robo$$android_os_MemoryFile$__constructor__(string2, n);
    }

    public MemoryFile(String string2, int n) throws IOException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_MemoryFile$__constructor__(java.lang.String int ), 0, this, string2, n);
    }

    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_os_MemoryFile$close(), 0, this);
    }

    void deactivate() {
        InvokeDynamicSupport.bootstrap("deactivate", $$robo$$android_os_MemoryFile$deactivate(), 0, this);
    }

    private boolean isDeactivated() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDeactivated", $$robo$$android_os_MemoryFile$isDeactivated(), 0, this);
    }

    private boolean isClosed() {
        return (boolean)InvokeDynamicSupport.bootstrap("isClosed", $$robo$$android_os_MemoryFile$isClosed(), 0, this);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_os_MemoryFile$finalize(), 0, this);
    }

    public int length() {
        return (int)InvokeDynamicSupport.bootstrap("length", $$robo$$android_os_MemoryFile$length(), 0, this);
    }

    public boolean isPurgingAllowed() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPurgingAllowed", $$robo$$android_os_MemoryFile$isPurgingAllowed(), 0, this);
    }

    public synchronized boolean allowPurging(boolean bl) throws IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("allowPurging", $$robo$$android_os_MemoryFile$allowPurging(boolean ), 0, this, bl);
    }

    public InputStream getInputStream() {
        return InvokeDynamicSupport.bootstrap("getInputStream", $$robo$$android_os_MemoryFile$getInputStream(), 0, this);
    }

    public OutputStream getOutputStream() {
        return InvokeDynamicSupport.bootstrap("getOutputStream", $$robo$$android_os_MemoryFile$getOutputStream(), 0, this);
    }

    public int readBytes(byte[] byArray, int n, int n2, int n3) throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("readBytes", $$robo$$android_os_MemoryFile$readBytes(byte[] int int int ), 0, this, byArray, n, n2, n3);
    }

    public void writeBytes(byte[] byArray, int n, int n2, int n3) throws IOException {
        InvokeDynamicSupport.bootstrap("writeBytes", $$robo$$android_os_MemoryFile$writeBytes(byte[] int int int ), 0, this, byArray, n, n2, n3);
    }

    public FileDescriptor getFileDescriptor() throws IOException {
        return InvokeDynamicSupport.bootstrap("getFileDescriptor", $$robo$$android_os_MemoryFile$getFileDescriptor(), 0, this);
    }

    public static int getSize(FileDescriptor fileDescriptor) throws IOException {
        return (int)InvokeDynamicSupport.bootstrapStatic("getSize", $$robo$$android_os_MemoryFile$getSize(java.io.FileDescriptor ), 0, (FileDescriptor)fileDescriptor);
    }

    static {
        RobolectricInternals.classInitializing(MemoryFile.class);
    }

    public /* synthetic */ MemoryFile() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MemoryFile)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class MemoryOutputStream
    extends OutputStream
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mOffset;
        private byte[] mSingleByte;
        /* synthetic */ MemoryFile this$0;

        private void $$robo$$android_os_MemoryFile_MemoryOutputStream$__constructor__(MemoryFile memoryFile) {
            this.mOffset = 0;
        }

        private final void $$robo$$android_os_MemoryFile_MemoryOutputStream$write(byte[] buffer, int offset, int count) throws IOException {
            this.this$0.writeBytes(buffer, offset, this.mOffset, count);
            this.mOffset += count;
        }

        private final void $$robo$$android_os_MemoryFile_MemoryOutputStream$write(int oneByte) throws IOException {
            if (this.mSingleByte == null) {
                this.mSingleByte = new byte[1];
            }
            this.mSingleByte[0] = (byte)oneByte;
            this.write(this.mSingleByte, 0, 1);
        }

        private /* synthetic */ void $$robo$$android_os_MemoryFile_MemoryOutputStream$__constructor__(MemoryFile x0, 1 x1) {
        }

        private void __constructor__(MemoryFile memoryFile) {
            this.$$robo$$android_os_MemoryFile_MemoryOutputStream$__constructor__(memoryFile);
        }

        private MemoryOutputStream(MemoryFile memoryFile) {
            this.this$0 = memoryFile;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_MemoryFile_MemoryOutputStream$__constructor__(android.os.MemoryFile ), 0, this, memoryFile);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            InvokeDynamicSupport.bootstrap("write", $$robo$$android_os_MemoryFile_MemoryOutputStream$write(byte[] int int ), 0, this, byArray, n, n2);
        }

        @Override
        public void write(int n) throws IOException {
            InvokeDynamicSupport.bootstrap("write", $$robo$$android_os_MemoryFile_MemoryOutputStream$write(int ), 0, this, n);
        }

        private /* synthetic */ void __constructor__(MemoryFile memoryFile, 1 var2_2) {
            this.$$robo$$android_os_MemoryFile_MemoryOutputStream$__constructor__(memoryFile, var2_2);
        }

        public /* synthetic */ MemoryOutputStream() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MemoryOutputStream)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class MemoryInputStream
    extends InputStream
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mMark;
        private int mOffset;
        private byte[] mSingleByte;
        /* synthetic */ MemoryFile this$0;

        private void $$robo$$android_os_MemoryFile_MemoryInputStream$__constructor__(MemoryFile memoryFile) {
            this.mMark = 0;
            this.mOffset = 0;
        }

        private final int $$robo$$android_os_MemoryFile_MemoryInputStream$available() throws IOException {
            if (this.mOffset >= this.this$0.mLength) {
                return 0;
            }
            return this.this$0.mLength - this.mOffset;
        }

        private final boolean $$robo$$android_os_MemoryFile_MemoryInputStream$markSupported() {
            return true;
        }

        private final void $$robo$$android_os_MemoryFile_MemoryInputStream$mark(int readlimit) {
            this.mMark = this.mOffset;
        }

        private final void $$robo$$android_os_MemoryFile_MemoryInputStream$reset() throws IOException {
            this.mOffset = this.mMark;
        }

        private final int $$robo$$android_os_MemoryFile_MemoryInputStream$read() throws IOException {
            int result;
            if (this.mSingleByte == null) {
                this.mSingleByte = new byte[1];
            }
            if ((result = this.read(this.mSingleByte, 0, 1)) != 1) {
                return -1;
            }
            return this.mSingleByte[0];
        }

        private final int $$robo$$android_os_MemoryFile_MemoryInputStream$read(byte[] buffer, int offset, int count) throws IOException {
            if (offset < 0 || count < 0 || offset + count > buffer.length) {
                throw new IndexOutOfBoundsException();
            }
            if ((count = Math.min(count, this.available())) < 1) {
                return -1;
            }
            int result = this.this$0.readBytes(buffer, this.mOffset, offset, count);
            if (result > 0) {
                this.mOffset += result;
            }
            return result;
        }

        private final long $$robo$$android_os_MemoryFile_MemoryInputStream$skip(long n) throws IOException {
            if ((long)this.mOffset + n > (long)this.this$0.mLength) {
                n = this.this$0.mLength - this.mOffset;
            }
            this.mOffset = (int)((long)this.mOffset + n);
            return n;
        }

        private /* synthetic */ void $$robo$$android_os_MemoryFile_MemoryInputStream$__constructor__(MemoryFile x0, 1 x1) {
        }

        private void __constructor__(MemoryFile memoryFile) {
            this.$$robo$$android_os_MemoryFile_MemoryInputStream$__constructor__(memoryFile);
        }

        private MemoryInputStream(MemoryFile memoryFile) {
            this.this$0 = memoryFile;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_MemoryFile_MemoryInputStream$__constructor__(android.os.MemoryFile ), 0, this, memoryFile);
        }

        @Override
        public int available() throws IOException {
            return (int)InvokeDynamicSupport.bootstrap("available", $$robo$$android_os_MemoryFile_MemoryInputStream$available(), 0, this);
        }

        @Override
        public boolean markSupported() {
            return (boolean)InvokeDynamicSupport.bootstrap("markSupported", $$robo$$android_os_MemoryFile_MemoryInputStream$markSupported(), 0, this);
        }

        @Override
        public void mark(int n) {
            InvokeDynamicSupport.bootstrap("mark", $$robo$$android_os_MemoryFile_MemoryInputStream$mark(int ), 0, this, n);
        }

        @Override
        public void reset() throws IOException {
            InvokeDynamicSupport.bootstrap("reset", $$robo$$android_os_MemoryFile_MemoryInputStream$reset(), 0, this);
        }

        @Override
        public int read() throws IOException {
            return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$android_os_MemoryFile_MemoryInputStream$read(), 0, this);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$android_os_MemoryFile_MemoryInputStream$read(byte[] int int ), 0, this, byArray, n, n2);
        }

        @Override
        public long skip(long l) throws IOException {
            return (long)InvokeDynamicSupport.bootstrap("skip", $$robo$$android_os_MemoryFile_MemoryInputStream$skip(long ), 0, this, l);
        }

        private /* synthetic */ void __constructor__(MemoryFile memoryFile, 1 var2_2) {
            this.$$robo$$android_os_MemoryFile_MemoryInputStream$__constructor__(memoryFile, var2_2);
        }

        public /* synthetic */ MemoryInputStream() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MemoryInputStream)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

