/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.system.ErrnoException;
import android.system.Os;
import android.system.StructStat;
import android.text.TextUtils;
import android.util.Log;
import android.util.Slog;
import android.webkit.MimeTypeMap;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import libcore.util.EmptyArray;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class FileUtils
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "FileUtils";
    public static int S_IRWXU = 448;
    public static int S_IRUSR = 256;
    public static int S_IWUSR = 128;
    public static int S_IXUSR = 64;
    public static int S_IRWXG = 56;
    public static int S_IRGRP = 32;
    public static int S_IWGRP = 16;
    public static int S_IXGRP = 8;
    public static int S_IRWXO = 7;
    public static int S_IROTH = 4;
    public static int S_IWOTH = 2;
    public static int S_IXOTH = 1;
    private static File[] EMPTY;

    private void $$robo$$android_os_FileUtils$__constructor__() {
    }

    private static final int $$robo$$android_os_FileUtils$setPermissions(File path, int mode, int uid, int gid) {
        return FileUtils.setPermissions(path.getAbsolutePath(), mode, uid, gid);
    }

    private static final int $$robo$$android_os_FileUtils$setPermissions(String path, int mode, int uid, int gid) {
        try {
            Os.chmod(path, mode);
        }
        catch (ErrnoException e) {
            Slog.w("FileUtils", "Failed to chmod(" + path + "): " + e);
            return e.errno;
        }
        if (uid >= 0 || gid >= 0) {
            try {
                Os.chown(path, uid, gid);
            }
            catch (ErrnoException e) {
                Slog.w("FileUtils", "Failed to chown(" + path + "): " + e);
                return e.errno;
            }
        }
        return 0;
    }

    private static final int $$robo$$android_os_FileUtils$setPermissions(FileDescriptor fd, int mode, int uid, int gid) {
        try {
            Os.fchmod(fd, mode);
        }
        catch (ErrnoException e) {
            Slog.w("FileUtils", "Failed to fchmod(): " + e);
            return e.errno;
        }
        if (uid >= 0 || gid >= 0) {
            try {
                Os.fchown(fd, uid, gid);
            }
            catch (ErrnoException e) {
                Slog.w("FileUtils", "Failed to fchown(): " + e);
                return e.errno;
            }
        }
        return 0;
    }

    private static final void $$robo$$android_os_FileUtils$copyPermissions(File from, File to) throws IOException {
        try {
            StructStat stat = Os.stat(from.getAbsolutePath());
            Os.chmod(to.getAbsolutePath(), stat.st_mode);
            Os.chown(to.getAbsolutePath(), stat.st_uid, stat.st_gid);
        }
        catch (ErrnoException e) {
            throw e.rethrowAsIOException();
        }
    }

    private static final int $$robo$$android_os_FileUtils$getUid(String path) {
        try {
            return Os.stat((String)path).st_uid;
        }
        catch (ErrnoException e) {
            return -1;
        }
    }

    private static final boolean $$robo$$android_os_FileUtils$sync(FileOutputStream stream) {
        try {
            if (stream != null) {
                stream.getFD().sync();
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Deprecated
    private static final boolean $$robo$$android_os_FileUtils$copyFile(File srcFile, File destFile) {
        try {
            FileUtils.copyFileOrThrow(srcFile, destFile);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static final void $$robo$$android_os_FileUtils$copyFileOrThrow(File srcFile, File destFile) throws IOException {
        try (FileInputStream in = new FileInputStream(srcFile);){
            FileUtils.copyToFileOrThrow(in, destFile);
        }
    }

    @Deprecated
    private static final boolean $$robo$$android_os_FileUtils$copyToFile(InputStream inputStream, File destFile) {
        try {
            FileUtils.copyToFileOrThrow(inputStream, destFile);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_os_FileUtils$copyToFileOrThrow(InputStream inputStream, File destFile) throws IOException {
        if (destFile.exists()) {
            destFile.delete();
        }
        FileOutputStream out = new FileOutputStream(destFile);
        try {
            int bytesRead;
            byte[] buffer = new byte[4096];
            while ((bytesRead = inputStream.read(buffer)) >= 0) {
                out.write(buffer, 0, bytesRead);
            }
        }
        finally {
            out.flush();
            try {
                out.getFD().sync();
            }
            catch (IOException iOException) {}
            out.close();
        }
    }

    private static final boolean $$robo$$android_os_FileUtils$isFilenameSafe(File file) {
        return NoImagePreloadHolder.SAFE_FILENAME_PATTERN.matcher(file.getPath()).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String $$robo$$android_os_FileUtils$readTextFile(File file, int max, String ellipsis) throws IOException {
        FileInputStream input = new FileInputStream(file);
        BufferedInputStream bis = new BufferedInputStream(input);
        try {
            int len;
            long size = file.length();
            if (max > 0 || size > 0L && max == 0) {
                byte[] data;
                int length;
                if (size > 0L && (max == 0 || size < (long)max)) {
                    max = (int)size;
                }
                if ((length = bis.read(data = new byte[max + 1])) <= 0) {
                    String string2 = "";
                    return string2;
                }
                if (length <= max) {
                    String string3 = new String(data, 0, length);
                    return string3;
                }
                if (ellipsis == null) {
                    String string4 = new String(data, 0, max);
                    return string4;
                }
                String string5 = new String(data, 0, max) + ellipsis;
                return string5;
            }
            if (max < 0) {
                String string6;
                int len2;
                boolean rolled = false;
                byte[] last = null;
                byte[] data = null;
                do {
                    if (last != null) {
                        rolled = true;
                    }
                    byte[] tmp = last;
                    last = data;
                    data = tmp;
                    if (data != null) continue;
                    data = new byte[-max];
                } while ((len2 = bis.read(data)) == data.length);
                if (last == null && len2 <= 0) {
                    string6 = "";
                    return string6;
                }
                if (last == null) {
                    string6 = new String(data, 0, len2);
                    return string6;
                }
                if (len2 > 0) {
                    rolled = true;
                    InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])last, (int)len2, (byte[])last, (int)0, (int)(last.length - len2));
                    InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])data, (int)0, (byte[])last, (int)(last.length - len2), (int)len2);
                }
                if (ellipsis == null || !rolled) {
                    string6 = new String(last);
                    return string6;
                }
                string6 = ellipsis + new String(last);
                return string6;
            }
            ByteArrayOutputStream contents = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            do {
                if ((len = bis.read(data)) <= 0) continue;
                contents.write(data, 0, len);
            } while (len == data.length);
            String string7 = contents.toString();
            return string7;
        }
        finally {
            bis.close();
            ((InputStream)input).close();
        }
    }

    private static final void $$robo$$android_os_FileUtils$stringToFile(File file, String string2) throws IOException {
        FileUtils.stringToFile(file.getAbsolutePath(), string2);
    }

    private static final void $$robo$$android_os_FileUtils$stringToFile(String filename, String string2) throws IOException {
        try (FileWriter out = new FileWriter(filename);){
            out.write(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final long $$robo$$android_os_FileUtils$checksumCrc32(File file) throws FileNotFoundException, IOException {
        CRC32 checkSummer = new CRC32();
        FilterInputStream cis = null;
        try {
            cis = new CheckedInputStream(new FileInputStream(file), checkSummer);
            byte[] buf = new byte[128];
            while (cis.read(buf) >= 0) {
            }
            long l = checkSummer.getValue();
            return l;
        }
        finally {
            if (cis != null) {
                try {
                    cis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static final boolean $$robo$$android_os_FileUtils$deleteOlderFiles(File dir, int minCount, long minAge) {
        if (minCount < 0 || minAge < 0L) {
            throw new IllegalArgumentException("Constraints must be positive or 0");
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return false;
        }
        Arrays.sort(files, new Comparator<File>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_os_FileUtils_1$__constructor__() {
            }

            private final int $$robo$$android_os_FileUtils_1$compare(File lhs, File rhs) {
                return (int)(rhs.lastModified() - lhs.lastModified());
            }

            private void __constructor__() {
                this.$$robo$$android_os_FileUtils_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_FileUtils_1$__constructor__(), 0, this);
            }

            @Override
            public int compare(File file, File file2) {
                return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$android_os_FileUtils_1$compare(java.io.File java.io.File ), 0, this, file, file2);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        boolean deleted = false;
        for (int i = minCount; i < files.length; ++i) {
            File file = files[i];
            reference var8_7 = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System") - file.lastModified();
            if (var8_7 <= minAge || !file.delete()) continue;
            Log.d("FileUtils", "Deleted old file " + file);
            deleted = true;
        }
        return deleted;
    }

    private static final boolean $$robo$$android_os_FileUtils$contains(File[] dirs, File file) {
        for (File dir : dirs) {
            if (!FileUtils.contains(dir, file)) continue;
            return true;
        }
        return false;
    }

    private static final boolean $$robo$$android_os_FileUtils$contains(File dir, File file) {
        String filePath;
        if (dir == null || file == null) {
            return false;
        }
        String dirPath = dir.getAbsolutePath();
        if (dirPath.equals(filePath = file.getAbsolutePath())) {
            return true;
        }
        if (!dirPath.endsWith("/")) {
            dirPath = dirPath + "/";
        }
        return filePath.startsWith(dirPath);
    }

    private static final boolean $$robo$$android_os_FileUtils$deleteContentsAndDir(File dir) {
        if (FileUtils.deleteContents(dir)) {
            return dir.delete();
        }
        return false;
    }

    private static final boolean $$robo$$android_os_FileUtils$deleteContents(File dir) {
        File[] files = dir.listFiles();
        boolean success = true;
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    success &= FileUtils.deleteContents(file);
                }
                if (file.delete()) continue;
                Log.w("FileUtils", "Failed to delete " + file);
                success = false;
            }
        }
        return success;
    }

    private static final boolean $$robo$$android_os_FileUtils$isValidExtFilenameChar(char c) {
        switch (c) {
            case '\u0000': 
            case '/': {
                return false;
            }
        }
        return true;
    }

    private static final boolean $$robo$$android_os_FileUtils$isValidExtFilename(String name) {
        return name != null && name.equals(FileUtils.buildValidExtFilename(name));
    }

    private static final String $$robo$$android_os_FileUtils$buildValidExtFilename(String name) {
        if (TextUtils.isEmpty(name) || ".".equals(name) || "..".equals(name)) {
            return "(invalid)";
        }
        StringBuilder res = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (FileUtils.isValidExtFilenameChar(c)) {
                res.append(c);
                continue;
            }
            res.append('_');
        }
        FileUtils.trimFilename(res, 255);
        return res.toString();
    }

    private static final boolean $$robo$$android_os_FileUtils$isValidFatFilenameChar(char c) {
        if ('\u0000' <= c && c <= '\u001f') {
            return false;
        }
        switch (c) {
            case '\"': 
            case '*': 
            case '/': 
            case ':': 
            case '<': 
            case '>': 
            case '?': 
            case '\\': 
            case '|': 
            case '\u007f': {
                return false;
            }
        }
        return true;
    }

    private static final boolean $$robo$$android_os_FileUtils$isValidFatFilename(String name) {
        return name != null && name.equals(FileUtils.buildValidFatFilename(name));
    }

    private static final String $$robo$$android_os_FileUtils$buildValidFatFilename(String name) {
        if (TextUtils.isEmpty(name) || ".".equals(name) || "..".equals(name)) {
            return "(invalid)";
        }
        StringBuilder res = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (FileUtils.isValidFatFilenameChar(c)) {
                res.append(c);
                continue;
            }
            res.append('_');
        }
        FileUtils.trimFilename(res, 255);
        return res.toString();
    }

    private static final String $$robo$$android_os_FileUtils$trimFilename(String str, int maxBytes) {
        StringBuilder res = new StringBuilder(str);
        FileUtils.trimFilename(res, maxBytes);
        return res.toString();
    }

    private static final void $$robo$$android_os_FileUtils$trimFilename(StringBuilder res, int maxBytes) {
        byte[] raw2 = res.toString().getBytes(StandardCharsets.UTF_8);
        if (raw2.length > maxBytes) {
            maxBytes -= 3;
            while (raw2.length > maxBytes) {
                res.deleteCharAt(res.length() / 2);
                raw2 = res.toString().getBytes(StandardCharsets.UTF_8);
            }
            res.insert(res.length() / 2, "...");
        }
    }

    private static final String $$robo$$android_os_FileUtils$rewriteAfterRename(File beforeDir, File afterDir, String path) {
        if (path == null) {
            return null;
        }
        File result = FileUtils.rewriteAfterRename(beforeDir, afterDir, new File(path));
        return result != null ? result.getAbsolutePath() : null;
    }

    private static final String[] $$robo$$android_os_FileUtils$rewriteAfterRename(File beforeDir, File afterDir, String[] paths) {
        if (paths == null) {
            return null;
        }
        String[] result = new String[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            result[i] = FileUtils.rewriteAfterRename(beforeDir, afterDir, paths[i]);
        }
        return result;
    }

    private static final File $$robo$$android_os_FileUtils$rewriteAfterRename(File beforeDir, File afterDir, File file) {
        if (file == null || beforeDir == null || afterDir == null) {
            return null;
        }
        if (FileUtils.contains(beforeDir, file)) {
            String splice = file.getAbsolutePath().substring(beforeDir.getAbsolutePath().length());
            return new File(afterDir, splice);
        }
        return null;
    }

    private static final File $$robo$$android_os_FileUtils$buildUniqueFile(File parent, String mimeType, String displayName) throws FileNotFoundException {
        String[] parts = FileUtils.splitFileName(mimeType, displayName);
        String name = parts[0];
        String ext = parts[1];
        File file = FileUtils.buildFile(parent, name, ext);
        int n = 0;
        while (file.exists()) {
            if (n++ >= 32) {
                throw new FileNotFoundException("Failed to create unique file");
            }
            file = FileUtils.buildFile(parent, name + " (" + n + ")", ext);
        }
        return file;
    }

    private static final String[] $$robo$$android_os_FileUtils$splitFileName(String mimeType, String displayName) {
        String ext;
        String name;
        if ("vnd.android.document/directory".equals(mimeType)) {
            name = displayName;
            ext = null;
        } else {
            String mimeTypeFromExt;
            int lastDot = displayName.lastIndexOf(46);
            if (lastDot >= 0) {
                name = displayName.substring(0, lastDot);
                ext = displayName.substring(lastDot + 1);
                mimeTypeFromExt = MimeTypeMap.getSingleton().getMimeTypeFromExtension(ext.toLowerCase());
            } else {
                name = displayName;
                ext = null;
                mimeTypeFromExt = null;
            }
            if (mimeTypeFromExt == null) {
                mimeTypeFromExt = "application/octet-stream";
            }
            String extFromMimeType = MimeTypeMap.getSingleton().getExtensionFromMimeType(mimeType);
            if (!Objects.equals(mimeType, mimeTypeFromExt) && !Objects.equals(ext, extFromMimeType)) {
                name = displayName;
                ext = extFromMimeType;
            }
        }
        if (ext == null) {
            ext = "";
        }
        return new String[]{name, ext};
    }

    private static final File $$robo$$android_os_FileUtils$buildFile(File parent, String name, String ext) {
        if (TextUtils.isEmpty(ext)) {
            return new File(parent, name);
        }
        return new File(parent, name + "." + ext);
    }

    private static final String[] $$robo$$android_os_FileUtils$listOrEmpty(File dir) {
        if (dir == null) {
            return EmptyArray.STRING;
        }
        String[] res = dir.list();
        if (res != null) {
            return res;
        }
        return EmptyArray.STRING;
    }

    private static final File[] $$robo$$android_os_FileUtils$listFilesOrEmpty(File dir) {
        if (dir == null) {
            return EMPTY;
        }
        File[] res = dir.listFiles();
        if (res != null) {
            return res;
        }
        return EMPTY;
    }

    private static final File[] $$robo$$android_os_FileUtils$listFilesOrEmpty(File dir, FilenameFilter filter) {
        if (dir == null) {
            return EMPTY;
        }
        File[] res = dir.listFiles(filter);
        if (res != null) {
            return res;
        }
        return EMPTY;
    }

    private static final File $$robo$$android_os_FileUtils$newFileOrNull(String path) {
        return path != null ? new File(path) : null;
    }

    static void __staticInitializer__() {
        EMPTY = new File[0];
    }

    private void __constructor__() {
        this.$$robo$$android_os_FileUtils$__constructor__();
    }

    public FileUtils() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_FileUtils$__constructor__(), 0, this);
    }

    public static int setPermissions(File file, int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("setPermissions", $$robo$$android_os_FileUtils$setPermissions(java.io.File int int int ), 0, (File)file, (int)n, (int)n2, (int)n3);
    }

    public static int setPermissions(String string2, int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("setPermissions", $$robo$$android_os_FileUtils$setPermissions(java.lang.String int int int ), 0, (String)string2, (int)n, (int)n2, (int)n3);
    }

    public static int setPermissions(FileDescriptor fileDescriptor, int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("setPermissions", $$robo$$android_os_FileUtils$setPermissions(java.io.FileDescriptor int int int ), 0, (FileDescriptor)fileDescriptor, (int)n, (int)n2, (int)n3);
    }

    public static void copyPermissions(File file, File file2) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("copyPermissions", $$robo$$android_os_FileUtils$copyPermissions(java.io.File java.io.File ), 0, (File)file, (File)file2);
    }

    public static int getUid(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getUid", $$robo$$android_os_FileUtils$getUid(java.lang.String ), 0, (String)string2);
    }

    public static boolean sync(FileOutputStream fileOutputStream) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("sync", $$robo$$android_os_FileUtils$sync(java.io.FileOutputStream ), 0, (FileOutputStream)fileOutputStream);
    }

    @Deprecated
    public static boolean copyFile(File file, File file2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("copyFile", $$robo$$android_os_FileUtils$copyFile(java.io.File java.io.File ), 0, (File)file, (File)file2);
    }

    public static void copyFileOrThrow(File file, File file2) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("copyFileOrThrow", $$robo$$android_os_FileUtils$copyFileOrThrow(java.io.File java.io.File ), 0, (File)file, (File)file2);
    }

    @Deprecated
    public static boolean copyToFile(InputStream inputStream, File file) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("copyToFile", $$robo$$android_os_FileUtils$copyToFile(java.io.InputStream java.io.File ), 0, (InputStream)inputStream, (File)file);
    }

    public static void copyToFileOrThrow(InputStream inputStream, File file) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("copyToFileOrThrow", $$robo$$android_os_FileUtils$copyToFileOrThrow(java.io.InputStream java.io.File ), 0, (InputStream)inputStream, (File)file);
    }

    public static boolean isFilenameSafe(File file) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isFilenameSafe", $$robo$$android_os_FileUtils$isFilenameSafe(java.io.File ), 0, (File)file);
    }

    public static String readTextFile(File file, int n, String string2) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("readTextFile", $$robo$$android_os_FileUtils$readTextFile(java.io.File int java.lang.String ), 0, (File)file, (int)n, (String)string2);
    }

    public static void stringToFile(File file, String string2) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("stringToFile", $$robo$$android_os_FileUtils$stringToFile(java.io.File java.lang.String ), 0, (File)file, (String)string2);
    }

    public static void stringToFile(String string2, String string3) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("stringToFile", $$robo$$android_os_FileUtils$stringToFile(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public static long checksumCrc32(File file) throws FileNotFoundException, IOException {
        return (long)InvokeDynamicSupport.bootstrapStatic("checksumCrc32", $$robo$$android_os_FileUtils$checksumCrc32(java.io.File ), 0, (File)file);
    }

    public static boolean deleteOlderFiles(File file, int n, long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("deleteOlderFiles", $$robo$$android_os_FileUtils$deleteOlderFiles(java.io.File int long ), 0, (File)file, (int)n, (long)l);
    }

    public static boolean contains(File[] fileArray, File file) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("contains", $$robo$$android_os_FileUtils$contains(java.io.File[] java.io.File ), 0, (File[])fileArray, (File)file);
    }

    public static boolean contains(File file, File file2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("contains", $$robo$$android_os_FileUtils$contains(java.io.File java.io.File ), 0, (File)file, (File)file2);
    }

    public static boolean deleteContentsAndDir(File file) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("deleteContentsAndDir", $$robo$$android_os_FileUtils$deleteContentsAndDir(java.io.File ), 0, (File)file);
    }

    public static boolean deleteContents(File file) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("deleteContents", $$robo$$android_os_FileUtils$deleteContents(java.io.File ), 0, (File)file);
    }

    private static boolean isValidExtFilenameChar(char c) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidExtFilenameChar", $$robo$$android_os_FileUtils$isValidExtFilenameChar(char ), 0, (char)c);
    }

    public static boolean isValidExtFilename(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidExtFilename", $$robo$$android_os_FileUtils$isValidExtFilename(java.lang.String ), 0, (String)string2);
    }

    public static String buildValidExtFilename(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("buildValidExtFilename", $$robo$$android_os_FileUtils$buildValidExtFilename(java.lang.String ), 0, (String)string2);
    }

    private static boolean isValidFatFilenameChar(char c) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidFatFilenameChar", $$robo$$android_os_FileUtils$isValidFatFilenameChar(char ), 0, (char)c);
    }

    public static boolean isValidFatFilename(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidFatFilename", $$robo$$android_os_FileUtils$isValidFatFilename(java.lang.String ), 0, (String)string2);
    }

    public static String buildValidFatFilename(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("buildValidFatFilename", $$robo$$android_os_FileUtils$buildValidFatFilename(java.lang.String ), 0, (String)string2);
    }

    public static String trimFilename(String string2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("trimFilename", $$robo$$android_os_FileUtils$trimFilename(java.lang.String int ), 0, (String)string2, (int)n);
    }

    private static void trimFilename(StringBuilder stringBuilder, int n) {
        InvokeDynamicSupport.bootstrapStatic("trimFilename", $$robo$$android_os_FileUtils$trimFilename(java.lang.StringBuilder int ), 0, (StringBuilder)stringBuilder, (int)n);
    }

    public static String rewriteAfterRename(File file, File file2, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("rewriteAfterRename", $$robo$$android_os_FileUtils$rewriteAfterRename(java.io.File java.io.File java.lang.String ), 0, (File)file, (File)file2, (String)string2);
    }

    public static String[] rewriteAfterRename(File file, File file2, String[] stringArray) {
        return InvokeDynamicSupport.bootstrapStatic("rewriteAfterRename", $$robo$$android_os_FileUtils$rewriteAfterRename(java.io.File java.io.File java.lang.String[] ), 0, (File)file, (File)file2, (String[])stringArray);
    }

    public static File rewriteAfterRename(File file, File file2, File file3) {
        return InvokeDynamicSupport.bootstrapStatic("rewriteAfterRename", $$robo$$android_os_FileUtils$rewriteAfterRename(java.io.File java.io.File java.io.File ), 0, (File)file, (File)file2, (File)file3);
    }

    public static File buildUniqueFile(File file, String string2, String string3) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrapStatic("buildUniqueFile", $$robo$$android_os_FileUtils$buildUniqueFile(java.io.File java.lang.String java.lang.String ), 0, (File)file, (String)string2, (String)string3);
    }

    public static String[] splitFileName(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("splitFileName", $$robo$$android_os_FileUtils$splitFileName(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    private static File buildFile(File file, String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("buildFile", $$robo$$android_os_FileUtils$buildFile(java.io.File java.lang.String java.lang.String ), 0, (File)file, (String)string2, (String)string3);
    }

    public static String[] listOrEmpty(File file) {
        return InvokeDynamicSupport.bootstrapStatic("listOrEmpty", $$robo$$android_os_FileUtils$listOrEmpty(java.io.File ), 0, (File)file);
    }

    public static File[] listFilesOrEmpty(File file) {
        return InvokeDynamicSupport.bootstrapStatic("listFilesOrEmpty", $$robo$$android_os_FileUtils$listFilesOrEmpty(java.io.File ), 0, (File)file);
    }

    public static File[] listFilesOrEmpty(File file, FilenameFilter filenameFilter) {
        return InvokeDynamicSupport.bootstrapStatic("listFilesOrEmpty", $$robo$$android_os_FileUtils$listFilesOrEmpty(java.io.File java.io.FilenameFilter ), 0, (File)file, (FilenameFilter)filenameFilter);
    }

    public static File newFileOrNull(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("newFileOrNull", $$robo$$android_os_FileUtils$newFileOrNull(java.lang.String ), 0, (String)string2);
    }

    static {
        RobolectricInternals.classInitializing(FileUtils.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FileUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class NoImagePreloadHolder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static Pattern SAFE_FILENAME_PATTERN;

        private void $$robo$$android_os_FileUtils_NoImagePreloadHolder$__constructor__() {
        }

        static void __staticInitializer__() {
            SAFE_FILENAME_PATTERN = Pattern.compile("[\\w%+,./=_-]+");
        }

        private void __constructor__() {
            this.$$robo$$android_os_FileUtils_NoImagePreloadHolder$__constructor__();
        }

        private NoImagePreloadHolder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_FileUtils_NoImagePreloadHolder$__constructor__(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(NoImagePreloadHolder.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NoImagePreloadHolder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

