/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.ParcelFileDescriptor;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.Arrays;
import libcore.io.IoBridge;
import libcore.io.IoUtils;
import libcore.io.Memory;
import libcore.io.Streams;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class FileBridge
extends Thread
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "FileBridge";
    private static int MSG_LENGTH = 8;
    private static int CMD_WRITE = 1;
    private static int CMD_FSYNC = 2;
    private static int CMD_CLOSE = 3;
    private FileDescriptor mTarget;
    private FileDescriptor mServer;
    private FileDescriptor mClient;
    private volatile boolean mClosed;

    private void $$robo$$android_os_FileBridge$__constructor__() {
        this.mServer = new FileDescriptor();
        this.mClient = new FileDescriptor();
        try {
            Os.socketpair(OsConstants.AF_UNIX, OsConstants.SOCK_STREAM, 0, this.mServer, this.mClient);
        }
        catch (ErrnoException e) {
            throw new RuntimeException("Failed to create bridge");
        }
    }

    private final boolean $$robo$$android_os_FileBridge$isClosed() {
        return this.mClosed;
    }

    private final void $$robo$$android_os_FileBridge$forceClose() {
        IoUtils.closeQuietly(this.mTarget);
        IoUtils.closeQuietly(this.mServer);
        IoUtils.closeQuietly(this.mClient);
        this.mClosed = true;
    }

    private final void $$robo$$android_os_FileBridge$setTargetFile(FileDescriptor target) {
        this.mTarget = target;
    }

    private final FileDescriptor $$robo$$android_os_FileBridge$getClientSocket() {
        return this.mClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_os_FileBridge$run() {
        byte[] temp = new byte[8192];
        try {
            while (IoBridge.read(this.mServer, temp, 0, 8) == 8) {
                int cmd = Memory.peekInt(temp, 0, ByteOrder.BIG_ENDIAN);
                if (cmd == 1) {
                    int n;
                    for (int len = Memory.peekInt(temp, 4, ByteOrder.BIG_ENDIAN); len > 0; len -= n) {
                        n = IoBridge.read(this.mServer, temp, 0, Math.min(temp.length, len));
                        if (n == -1) {
                            throw new IOException("Unexpected EOF; still expected " + len + " bytes");
                        }
                        IoBridge.write(this.mTarget, temp, 0, n);
                    }
                    continue;
                }
                if (cmd == 2) {
                    Os.fsync(this.mTarget);
                    IoBridge.write(this.mServer, temp, 0, 8);
                    continue;
                }
                if (cmd != 3) continue;
                Os.fsync(this.mTarget);
                Os.close(this.mTarget);
                this.mClosed = true;
                IoBridge.write(this.mServer, temp, 0, 8);
                break;
            }
        }
        catch (ErrnoException | IOException e) {
            Log.wtf("FileBridge", "Failed during bridge", e);
        }
        finally {
            this.forceClose();
        }
    }

    private void __constructor__() {
        this.$$robo$$android_os_FileBridge$__constructor__();
    }

    public FileBridge() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_FileBridge$__constructor__(), 0, this);
    }

    public boolean isClosed() {
        return (boolean)InvokeDynamicSupport.bootstrap("isClosed", $$robo$$android_os_FileBridge$isClosed(), 0, this);
    }

    public void forceClose() {
        InvokeDynamicSupport.bootstrap("forceClose", $$robo$$android_os_FileBridge$forceClose(), 0, this);
    }

    public void setTargetFile(FileDescriptor fileDescriptor) {
        InvokeDynamicSupport.bootstrap("setTargetFile", $$robo$$android_os_FileBridge$setTargetFile(java.io.FileDescriptor ), 0, this, fileDescriptor);
    }

    public FileDescriptor getClientSocket() {
        return InvokeDynamicSupport.bootstrap("getClientSocket", $$robo$$android_os_FileBridge$getClientSocket(), 0, this);
    }

    @Override
    public void run() {
        InvokeDynamicSupport.bootstrap("run", $$robo$$android_os_FileBridge$run(), 0, this);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FileBridge)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class FileBridgeOutputStream
    extends OutputStream
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private ParcelFileDescriptor mClientPfd;
        private FileDescriptor mClient;
        private byte[] mTemp;

        private void $$robo$$android_os_FileBridge_FileBridgeOutputStream$__constructor__(ParcelFileDescriptor clientPfd) {
            this.mTemp = new byte[8];
            this.mClientPfd = clientPfd;
            this.mClient = clientPfd.getFileDescriptor();
        }

        private void $$robo$$android_os_FileBridge_FileBridgeOutputStream$__constructor__(FileDescriptor client) {
            this.mTemp = new byte[8];
            this.mClientPfd = null;
            this.mClient = client;
        }

        private final void $$robo$$android_os_FileBridge_FileBridgeOutputStream$close() throws IOException {
            try {
                this.writeCommandAndBlock(3, "close()");
            }
            finally {
                IoBridge.closeAndSignalBlockedThreads(this.mClient);
                IoUtils.closeQuietly(this.mClientPfd);
            }
        }

        private final void $$robo$$android_os_FileBridge_FileBridgeOutputStream$fsync() throws IOException {
            this.writeCommandAndBlock(2, "fsync()");
        }

        private final void $$robo$$android_os_FileBridge_FileBridgeOutputStream$writeCommandAndBlock(int cmd, String cmdString) throws IOException {
            Memory.pokeInt(this.mTemp, 0, cmd, ByteOrder.BIG_ENDIAN);
            IoBridge.write(this.mClient, this.mTemp, 0, 8);
            if (IoBridge.read(this.mClient, this.mTemp, 0, 8) == 8 && Memory.peekInt(this.mTemp, 0, ByteOrder.BIG_ENDIAN) == cmd) {
                return;
            }
            throw new IOException("Failed to execute " + cmdString + " across bridge");
        }

        private final void $$robo$$android_os_FileBridge_FileBridgeOutputStream$write(byte[] buffer, int byteOffset, int byteCount) throws IOException {
            Arrays.checkOffsetAndCount((int)buffer.length, (int)byteOffset, (int)byteCount);
            Memory.pokeInt(this.mTemp, 0, 1, ByteOrder.BIG_ENDIAN);
            Memory.pokeInt(this.mTemp, 4, byteCount, ByteOrder.BIG_ENDIAN);
            IoBridge.write(this.mClient, this.mTemp, 0, 8);
            IoBridge.write(this.mClient, buffer, byteOffset, byteCount);
        }

        private final void $$robo$$android_os_FileBridge_FileBridgeOutputStream$write(int oneByte) throws IOException {
            Streams.writeSingleByte(this, oneByte);
        }

        private void __constructor__(ParcelFileDescriptor parcelFileDescriptor) {
            this.$$robo$$android_os_FileBridge_FileBridgeOutputStream$__constructor__(parcelFileDescriptor);
        }

        public FileBridgeOutputStream(ParcelFileDescriptor parcelFileDescriptor) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_FileBridge_FileBridgeOutputStream$__constructor__(android.os.ParcelFileDescriptor ), 0, this, parcelFileDescriptor);
        }

        private void __constructor__(FileDescriptor fileDescriptor) {
            this.$$robo$$android_os_FileBridge_FileBridgeOutputStream$__constructor__(fileDescriptor);
        }

        public FileBridgeOutputStream(FileDescriptor fileDescriptor) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_FileBridge_FileBridgeOutputStream$__constructor__(java.io.FileDescriptor ), 0, this, fileDescriptor);
        }

        @Override
        public void close() throws IOException {
            InvokeDynamicSupport.bootstrap("close", $$robo$$android_os_FileBridge_FileBridgeOutputStream$close(), 0, this);
        }

        public void fsync() throws IOException {
            InvokeDynamicSupport.bootstrap("fsync", $$robo$$android_os_FileBridge_FileBridgeOutputStream$fsync(), 0, this);
        }

        private void writeCommandAndBlock(int n, String string2) throws IOException {
            InvokeDynamicSupport.bootstrap("writeCommandAndBlock", $$robo$$android_os_FileBridge_FileBridgeOutputStream$writeCommandAndBlock(int java.lang.String ), 0, this, n, string2);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            InvokeDynamicSupport.bootstrap("write", $$robo$$android_os_FileBridge_FileBridgeOutputStream$write(byte[] int int ), 0, this, byArray, n, n2);
        }

        @Override
        public void write(int n) throws IOException {
            InvokeDynamicSupport.bootstrap("write", $$robo$$android_os_FileBridge_FileBridgeOutputStream$write(int ), 0, this, n);
        }

        public /* synthetic */ FileBridgeOutputStream() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FileBridgeOutputStream)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

