/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class WifiP2pWfdInfo
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "WifiP2pWfdInfo";
    private boolean mWfdEnabled;
    private int mDeviceInfo;
    public static int WFD_SOURCE = 0;
    public static int PRIMARY_SINK = 1;
    public static int SECONDARY_SINK = 2;
    public static int SOURCE_OR_PRIMARY_SINK = 3;
    private static int DEVICE_TYPE = 3;
    private static int COUPLED_SINK_SUPPORT_AT_SOURCE = 4;
    private static int COUPLED_SINK_SUPPORT_AT_SINK = 8;
    private static int SESSION_AVAILABLE = 48;
    private static int SESSION_AVAILABLE_BIT1 = 16;
    private static int SESSION_AVAILABLE_BIT2 = 32;
    private int mCtrlPort;
    private int mMaxThroughput;
    public static Parcelable.Creator<WifiP2pWfdInfo> CREATOR;

    private void $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo$__constructor__() {
    }

    private void $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo$__constructor__(int devInfo, int ctrlPort, int maxTput) {
        this.mWfdEnabled = true;
        this.mDeviceInfo = devInfo;
        this.mCtrlPort = ctrlPort;
        this.mMaxThroughput = maxTput;
    }

    private final boolean $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo$isWfdEnabled() {
        return this.mWfdEnabled;
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo$setWfdEnabled(boolean enabled) {
        this.mWfdEnabled = enabled;
    }

    private final int $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo$getDeviceType() {
        return this.mDeviceInfo & 3;
    }

    private final boolean $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo$setDeviceType(int deviceType) {
        if (deviceType >= 0 && deviceType <= 3) {
            this.mDeviceInfo &= 0xFFFFFFFC;
            this.mDeviceInfo |= deviceType;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo$isCoupledSinkSupportedAtSource() {
        return (this.mDeviceInfo & 8) != 0;
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo$setCoupledSinkSupportAtSource(boolean enabled) {
        this.mDeviceInfo = enabled ? (this.mDeviceInfo |= 8) : (this.mDeviceInfo &= 0xFFFFFFF7);
    }

    private final boolean $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo$isCoupledSinkSupportedAtSink() {
        return (this.mDeviceInfo & 8) != 0;
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo$setCoupledSinkSupportAtSink(boolean enabled) {
        this.mDeviceInfo = enabled ? (this.mDeviceInfo |= 8) : (this.mDeviceInfo &= 0xFFFFFFF7);
    }

    private final boolean $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo$isSessionAvailable() {
        return (this.mDeviceInfo & 0x30) != 0;
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo$setSessionAvailable(boolean enabled) {
        if (enabled) {
            this.mDeviceInfo |= 0x10;
            this.mDeviceInfo &= 0xFFFFFFDF;
        } else {
            this.mDeviceInfo &= 0xFFFFFFCF;
        }
    }

    private final int $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo$getControlPort() {
        return this.mCtrlPort;
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo$setControlPort(int port) {
        this.mCtrlPort = port;
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo$setMaxThroughput(int maxThroughput) {
        this.mMaxThroughput = maxThroughput;
    }

    private final int $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo$getMaxThroughput() {
        return this.mMaxThroughput;
    }

    private final String $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo$getDeviceInfoHex() {
        return String.format(Locale.US, "%04x%04x%04x%04x", 6, this.mDeviceInfo, this.mCtrlPort, this.mMaxThroughput);
    }

    private final String $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo$toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("WFD enabled: ").append(this.mWfdEnabled);
        sbuf.append("WFD DeviceInfo: ").append(this.mDeviceInfo);
        sbuf.append("\n WFD CtrlPort: ").append(this.mCtrlPort);
        sbuf.append("\n WFD MaxThroughput: ").append(this.mMaxThroughput);
        return sbuf.toString();
    }

    private final int $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo$describeContents() {
        return 0;
    }

    private void $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo$__constructor__(WifiP2pWfdInfo source) {
        if (source != null) {
            this.mWfdEnabled = source.mWfdEnabled;
            this.mDeviceInfo = source.mDeviceInfo;
            this.mCtrlPort = source.mCtrlPort;
            this.mMaxThroughput = source.mMaxThroughput;
        }
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo$writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mWfdEnabled ? 1 : 0);
        dest.writeInt(this.mDeviceInfo);
        dest.writeInt(this.mCtrlPort);
        dest.writeInt(this.mMaxThroughput);
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo$readFromParcel(Parcel in) {
        this.mWfdEnabled = in.readInt() == 1;
        this.mDeviceInfo = in.readInt();
        this.mCtrlPort = in.readInt();
        this.mMaxThroughput = in.readInt();
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<WifiP2pWfdInfo>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo_1$__constructor__() {
            }

            private final WifiP2pWfdInfo $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo_1$createFromParcel(Parcel in) {
                WifiP2pWfdInfo device = new WifiP2pWfdInfo();
                device.readFromParcel(in);
                return device;
            }

            private final WifiP2pWfdInfo[] $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo_1$newArray(int size) {
                return new WifiP2pWfdInfo[size];
            }

            private void __constructor__() {
                this.$$robo$$android_net_wifi_p2p_WifiP2pWfdInfo_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo_1$__constructor__(), 0, this);
            }

            @Override
            public WifiP2pWfdInfo createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public WifiP2pWfdInfo[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_net_wifi_p2p_WifiP2pWfdInfo$__constructor__();
    }

    public WifiP2pWfdInfo() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo$__constructor__(), 0, this);
    }

    private void __constructor__(int n, int n2, int n3) {
        this.$$robo$$android_net_wifi_p2p_WifiP2pWfdInfo$__constructor__(n, n2, n3);
    }

    public WifiP2pWfdInfo(int n, int n2, int n3) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo$__constructor__(int int int ), 0, this, n, n2, n3);
    }

    public boolean isWfdEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isWfdEnabled", $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo$isWfdEnabled(), 0, this);
    }

    public void setWfdEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setWfdEnabled", $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo$setWfdEnabled(boolean ), 0, this, bl);
    }

    public int getDeviceType() {
        return (int)InvokeDynamicSupport.bootstrap("getDeviceType", $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo$getDeviceType(), 0, this);
    }

    public boolean setDeviceType(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("setDeviceType", $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo$setDeviceType(int ), 0, this, n);
    }

    public boolean isCoupledSinkSupportedAtSource() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCoupledSinkSupportedAtSource", $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo$isCoupledSinkSupportedAtSource(), 0, this);
    }

    public void setCoupledSinkSupportAtSource(boolean bl) {
        InvokeDynamicSupport.bootstrap("setCoupledSinkSupportAtSource", $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo$setCoupledSinkSupportAtSource(boolean ), 0, this, bl);
    }

    public boolean isCoupledSinkSupportedAtSink() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCoupledSinkSupportedAtSink", $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo$isCoupledSinkSupportedAtSink(), 0, this);
    }

    public void setCoupledSinkSupportAtSink(boolean bl) {
        InvokeDynamicSupport.bootstrap("setCoupledSinkSupportAtSink", $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo$setCoupledSinkSupportAtSink(boolean ), 0, this, bl);
    }

    public boolean isSessionAvailable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSessionAvailable", $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo$isSessionAvailable(), 0, this);
    }

    public void setSessionAvailable(boolean bl) {
        InvokeDynamicSupport.bootstrap("setSessionAvailable", $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo$setSessionAvailable(boolean ), 0, this, bl);
    }

    public int getControlPort() {
        return (int)InvokeDynamicSupport.bootstrap("getControlPort", $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo$getControlPort(), 0, this);
    }

    public void setControlPort(int n) {
        InvokeDynamicSupport.bootstrap("setControlPort", $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo$setControlPort(int ), 0, this, n);
    }

    public void setMaxThroughput(int n) {
        InvokeDynamicSupport.bootstrap("setMaxThroughput", $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo$setMaxThroughput(int ), 0, this, n);
    }

    public int getMaxThroughput() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxThroughput", $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo$getMaxThroughput(), 0, this);
    }

    public String getDeviceInfoHex() {
        return InvokeDynamicSupport.bootstrap("getDeviceInfoHex", $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo$getDeviceInfoHex(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo$toString(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo$describeContents(), 0, this);
    }

    private void __constructor__(WifiP2pWfdInfo wifiP2pWfdInfo) {
        this.$$robo$$android_net_wifi_p2p_WifiP2pWfdInfo$__constructor__(wifiP2pWfdInfo);
    }

    public WifiP2pWfdInfo(WifiP2pWfdInfo wifiP2pWfdInfo) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo$__constructor__(android.net.wifi.p2p.WifiP2pWfdInfo ), 0, this, wifiP2pWfdInfo);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public void readFromParcel(Parcel parcel) {
        InvokeDynamicSupport.bootstrap("readFromParcel", $$robo$$android_net_wifi_p2p_WifiP2pWfdInfo$readFromParcel(android.os.Parcel ), 0, this, parcel);
    }

    static {
        RobolectricInternals.classInitializing(WifiP2pWfdInfo.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WifiP2pWfdInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

