/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p;

import android.net.wifi.p2p.WifiP2pDevice;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class WifiP2pDeviceList
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private HashMap<String, WifiP2pDevice> mDevices;
    public static Parcelable.Creator<WifiP2pDeviceList> CREATOR;

    private void $$robo$$android_net_wifi_p2p_WifiP2pDeviceList$__constructor__() {
        this.mDevices = new HashMap();
    }

    private void $$robo$$android_net_wifi_p2p_WifiP2pDeviceList$__constructor__(WifiP2pDeviceList source) {
        this.mDevices = new HashMap();
        if (source != null) {
            for (WifiP2pDevice d : source.getDeviceList()) {
                this.mDevices.put(d.deviceAddress, new WifiP2pDevice(d));
            }
        }
    }

    private void $$robo$$android_net_wifi_p2p_WifiP2pDeviceList$__constructor__(ArrayList<WifiP2pDevice> devices) {
        this.mDevices = new HashMap();
        for (WifiP2pDevice device : devices) {
            if (device.deviceAddress == null) continue;
            this.mDevices.put(device.deviceAddress, new WifiP2pDevice(device));
        }
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pDeviceList$validateDevice(WifiP2pDevice device) {
        if (device == null) {
            throw new IllegalArgumentException("Null device");
        }
        if (TextUtils.isEmpty(device.deviceAddress)) {
            throw new IllegalArgumentException("Empty deviceAddress");
        }
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pDeviceList$validateDeviceAddress(String deviceAddress) {
        if (TextUtils.isEmpty(deviceAddress)) {
            throw new IllegalArgumentException("Empty deviceAddress");
        }
    }

    private final boolean $$robo$$android_net_wifi_p2p_WifiP2pDeviceList$clear() {
        if (this.mDevices.isEmpty()) {
            return false;
        }
        this.mDevices.clear();
        return true;
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pDeviceList$update(WifiP2pDevice device) {
        this.updateSupplicantDetails(device);
        this.mDevices.get((Object)device.deviceAddress).status = device.status;
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pDeviceList$updateSupplicantDetails(WifiP2pDevice device) {
        this.validateDevice(device);
        WifiP2pDevice d = this.mDevices.get(device.deviceAddress);
        if (d != null) {
            d.deviceName = device.deviceName;
            d.primaryDeviceType = device.primaryDeviceType;
            d.secondaryDeviceType = device.secondaryDeviceType;
            d.wpsConfigMethodsSupported = device.wpsConfigMethodsSupported;
            d.deviceCapability = device.deviceCapability;
            d.groupCapability = device.groupCapability;
            d.wfdInfo = device.wfdInfo;
            return;
        }
        this.mDevices.put(device.deviceAddress, device);
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pDeviceList$updateGroupCapability(String deviceAddress, int groupCapab) {
        this.validateDeviceAddress(deviceAddress);
        WifiP2pDevice d = this.mDevices.get(deviceAddress);
        if (d != null) {
            d.groupCapability = groupCapab;
        }
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pDeviceList$updateStatus(String deviceAddress, int status) {
        this.validateDeviceAddress(deviceAddress);
        WifiP2pDevice d = this.mDevices.get(deviceAddress);
        if (d != null) {
            d.status = status;
        }
    }

    private final WifiP2pDevice $$robo$$android_net_wifi_p2p_WifiP2pDeviceList$get(String deviceAddress) {
        this.validateDeviceAddress(deviceAddress);
        return this.mDevices.get(deviceAddress);
    }

    private final boolean $$robo$$android_net_wifi_p2p_WifiP2pDeviceList$remove(WifiP2pDevice device) {
        this.validateDevice(device);
        return this.mDevices.remove(device.deviceAddress) != null;
    }

    private final WifiP2pDevice $$robo$$android_net_wifi_p2p_WifiP2pDeviceList$remove(String deviceAddress) {
        this.validateDeviceAddress(deviceAddress);
        return this.mDevices.remove(deviceAddress);
    }

    private final boolean $$robo$$android_net_wifi_p2p_WifiP2pDeviceList$remove(WifiP2pDeviceList list) {
        boolean ret = false;
        for (WifiP2pDevice d : list.mDevices.values()) {
            if (!this.remove(d)) continue;
            ret = true;
        }
        return ret;
    }

    private final Collection<WifiP2pDevice> $$robo$$android_net_wifi_p2p_WifiP2pDeviceList$getDeviceList() {
        return Collections.unmodifiableCollection(this.mDevices.values());
    }

    private final boolean $$robo$$android_net_wifi_p2p_WifiP2pDeviceList$isGroupOwner(String deviceAddress) {
        this.validateDeviceAddress(deviceAddress);
        WifiP2pDevice device = this.mDevices.get(deviceAddress);
        if (device == null) {
            throw new IllegalArgumentException("Device not found " + deviceAddress);
        }
        return device.isGroupOwner();
    }

    private final String $$robo$$android_net_wifi_p2p_WifiP2pDeviceList$toString() {
        StringBuffer sbuf = new StringBuffer();
        for (WifiP2pDevice device : this.mDevices.values()) {
            sbuf.append("\n").append(device);
        }
        return sbuf.toString();
    }

    private final int $$robo$$android_net_wifi_p2p_WifiP2pDeviceList$describeContents() {
        return 0;
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pDeviceList$writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mDevices.size());
        for (WifiP2pDevice device : this.mDevices.values()) {
            dest.writeParcelable(device, flags);
        }
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<WifiP2pDeviceList>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_net_wifi_p2p_WifiP2pDeviceList_1$__constructor__() {
            }

            private final WifiP2pDeviceList $$robo$$android_net_wifi_p2p_WifiP2pDeviceList_1$createFromParcel(Parcel in) {
                WifiP2pDeviceList deviceList = new WifiP2pDeviceList();
                int deviceCount = in.readInt();
                for (int i = 0; i < deviceCount; ++i) {
                    deviceList.update((WifiP2pDevice)in.readParcelable(null));
                }
                return deviceList;
            }

            private final WifiP2pDeviceList[] $$robo$$android_net_wifi_p2p_WifiP2pDeviceList_1$newArray(int size) {
                return new WifiP2pDeviceList[size];
            }

            private void __constructor__() {
                this.$$robo$$android_net_wifi_p2p_WifiP2pDeviceList_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_p2p_WifiP2pDeviceList_1$__constructor__(), 0, this);
            }

            @Override
            public WifiP2pDeviceList createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_p2p_WifiP2pDeviceList_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public WifiP2pDeviceList[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_p2p_WifiP2pDeviceList_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_net_wifi_p2p_WifiP2pDeviceList$__constructor__();
    }

    public WifiP2pDeviceList() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_p2p_WifiP2pDeviceList$__constructor__(), 0, this);
    }

    private void __constructor__(WifiP2pDeviceList wifiP2pDeviceList) {
        this.$$robo$$android_net_wifi_p2p_WifiP2pDeviceList$__constructor__(wifiP2pDeviceList);
    }

    public WifiP2pDeviceList(WifiP2pDeviceList wifiP2pDeviceList) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_p2p_WifiP2pDeviceList$__constructor__(android.net.wifi.p2p.WifiP2pDeviceList ), 0, this, wifiP2pDeviceList);
    }

    private void __constructor__(ArrayList<WifiP2pDevice> arrayList) {
        this.$$robo$$android_net_wifi_p2p_WifiP2pDeviceList$__constructor__(arrayList);
    }

    public WifiP2pDeviceList(ArrayList<WifiP2pDevice> arrayList) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_p2p_WifiP2pDeviceList$__constructor__(java.util.ArrayList<android.net.wifi.p2p.WifiP2pDevice> ), 0, this, arrayList);
    }

    private void validateDevice(WifiP2pDevice wifiP2pDevice) {
        InvokeDynamicSupport.bootstrap("validateDevice", $$robo$$android_net_wifi_p2p_WifiP2pDeviceList$validateDevice(android.net.wifi.p2p.WifiP2pDevice ), 0, this, wifiP2pDevice);
    }

    private void validateDeviceAddress(String string2) {
        InvokeDynamicSupport.bootstrap("validateDeviceAddress", $$robo$$android_net_wifi_p2p_WifiP2pDeviceList$validateDeviceAddress(java.lang.String ), 0, this, string2);
    }

    public boolean clear() {
        return (boolean)InvokeDynamicSupport.bootstrap("clear", $$robo$$android_net_wifi_p2p_WifiP2pDeviceList$clear(), 0, this);
    }

    public void update(WifiP2pDevice wifiP2pDevice) {
        InvokeDynamicSupport.bootstrap("update", $$robo$$android_net_wifi_p2p_WifiP2pDeviceList$update(android.net.wifi.p2p.WifiP2pDevice ), 0, this, wifiP2pDevice);
    }

    public void updateSupplicantDetails(WifiP2pDevice wifiP2pDevice) {
        InvokeDynamicSupport.bootstrap("updateSupplicantDetails", $$robo$$android_net_wifi_p2p_WifiP2pDeviceList$updateSupplicantDetails(android.net.wifi.p2p.WifiP2pDevice ), 0, this, wifiP2pDevice);
    }

    public void updateGroupCapability(String string2, int n) {
        InvokeDynamicSupport.bootstrap("updateGroupCapability", $$robo$$android_net_wifi_p2p_WifiP2pDeviceList$updateGroupCapability(java.lang.String int ), 0, this, string2, n);
    }

    public void updateStatus(String string2, int n) {
        InvokeDynamicSupport.bootstrap("updateStatus", $$robo$$android_net_wifi_p2p_WifiP2pDeviceList$updateStatus(java.lang.String int ), 0, this, string2, n);
    }

    public WifiP2pDevice get(String string2) {
        return InvokeDynamicSupport.bootstrap("get", $$robo$$android_net_wifi_p2p_WifiP2pDeviceList$get(java.lang.String ), 0, this, string2);
    }

    public boolean remove(WifiP2pDevice wifiP2pDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("remove", $$robo$$android_net_wifi_p2p_WifiP2pDeviceList$remove(android.net.wifi.p2p.WifiP2pDevice ), 0, this, wifiP2pDevice);
    }

    public WifiP2pDevice remove(String string2) {
        return InvokeDynamicSupport.bootstrap("remove", $$robo$$android_net_wifi_p2p_WifiP2pDeviceList$remove(java.lang.String ), 0, this, string2);
    }

    public boolean remove(WifiP2pDeviceList wifiP2pDeviceList) {
        return (boolean)InvokeDynamicSupport.bootstrap("remove", $$robo$$android_net_wifi_p2p_WifiP2pDeviceList$remove(android.net.wifi.p2p.WifiP2pDeviceList ), 0, this, wifiP2pDeviceList);
    }

    public Collection<WifiP2pDevice> getDeviceList() {
        return InvokeDynamicSupport.bootstrap("getDeviceList", $$robo$$android_net_wifi_p2p_WifiP2pDeviceList$getDeviceList(), 0, this);
    }

    public boolean isGroupOwner(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isGroupOwner", $$robo$$android_net_wifi_p2p_WifiP2pDeviceList$isGroupOwner(java.lang.String ), 0, this, string2);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_wifi_p2p_WifiP2pDeviceList$toString(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_p2p_WifiP2pDeviceList$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_p2p_WifiP2pDeviceList$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    static {
        RobolectricInternals.classInitializing(WifiP2pDeviceList.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WifiP2pDeviceList)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

