/*
 * Decompiled with CFR 0.152.
 */
package android.net.util;

import android.system.OsConstants;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class IpUtils
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;

    private void $$robo$$android_net_util_IpUtils$__constructor__() {
    }

    private static final int $$robo$$android_net_util_IpUtils$intAbs(short v) {
        return v & 0xFFFF;
    }

    private static final int $$robo$$android_net_util_IpUtils$checksum(ByteBuffer buf, int seed, int start, int end) {
        int sum = seed;
        int bufPosition = buf.position();
        buf.position(start);
        ShortBuffer shortBuf = buf.asShortBuffer();
        buf.position(bufPosition);
        int numShorts = (end - start) / 2;
        for (int i = 0; i < numShorts; ++i) {
            sum += IpUtils.intAbs(shortBuf.get(i));
        }
        if (end != (start += numShorts * 2)) {
            short b = buf.get(start);
            if (b < 0) {
                b = (short)(b + 256);
            }
            sum += b * 256;
        }
        sum = (sum >> 16 & 0xFFFF) + (sum & 0xFFFF);
        sum = sum + (sum >> 16 & 0xFFFF) & 0xFFFF;
        int negated = ~sum;
        return IpUtils.intAbs((short)negated);
    }

    private static final int $$robo$$android_net_util_IpUtils$pseudoChecksumIPv4(ByteBuffer buf, int headerOffset, int protocol, int transportLen) {
        int partial = protocol + transportLen;
        partial += IpUtils.intAbs(buf.getShort(headerOffset + 12));
        partial += IpUtils.intAbs(buf.getShort(headerOffset + 14));
        partial += IpUtils.intAbs(buf.getShort(headerOffset + 16));
        return partial += IpUtils.intAbs(buf.getShort(headerOffset + 18));
    }

    private static final int $$robo$$android_net_util_IpUtils$pseudoChecksumIPv6(ByteBuffer buf, int headerOffset, int protocol, int transportLen) {
        int partial = protocol + transportLen;
        for (int offset = 8; offset < 40; offset += 2) {
            partial += IpUtils.intAbs(buf.getShort(headerOffset + offset));
        }
        return partial;
    }

    private static final byte $$robo$$android_net_util_IpUtils$ipversion(ByteBuffer buf, int headerOffset) {
        return (byte)((buf.get(headerOffset) & 0xFFFFFFF0) >> 4);
    }

    private static final short $$robo$$android_net_util_IpUtils$ipChecksum(ByteBuffer buf, int headerOffset) {
        byte ihl = (byte)(buf.get(headerOffset) & 0xF);
        return (short)IpUtils.checksum(buf, 0, headerOffset, headerOffset + ihl * 4);
    }

    private static final short $$robo$$android_net_util_IpUtils$transportChecksum(ByteBuffer buf, int protocol, int ipOffset, int transportOffset, int transportLen) {
        int sum;
        if (transportLen < 0) {
            throw new IllegalArgumentException("Transport length < 0: " + transportLen);
        }
        byte ver = IpUtils.ipversion(buf, ipOffset);
        if (ver == 4) {
            sum = IpUtils.pseudoChecksumIPv4(buf, ipOffset, protocol, transportLen);
        } else if (ver == 6) {
            sum = IpUtils.pseudoChecksumIPv6(buf, ipOffset, protocol, transportLen);
        } else {
            throw new UnsupportedOperationException("Checksum must be IPv4 or IPv6");
        }
        sum = IpUtils.checksum(buf, sum, transportOffset, transportOffset + transportLen);
        if (protocol == OsConstants.IPPROTO_UDP && sum == 0) {
            sum = -1;
        }
        return (short)sum;
    }

    private static final short $$robo$$android_net_util_IpUtils$udpChecksum(ByteBuffer buf, int ipOffset, int transportOffset) {
        int transportLen = IpUtils.intAbs(buf.getShort(transportOffset + 4));
        return IpUtils.transportChecksum(buf, OsConstants.IPPROTO_UDP, ipOffset, transportOffset, transportLen);
    }

    private static final short $$robo$$android_net_util_IpUtils$tcpChecksum(ByteBuffer buf, int ipOffset, int transportOffset, int transportLen) {
        return IpUtils.transportChecksum(buf, OsConstants.IPPROTO_TCP, ipOffset, transportOffset, transportLen);
    }

    private static final String $$robo$$android_net_util_IpUtils$addressAndPortToString(InetAddress address, int port) {
        return String.format(address instanceof Inet6Address ? "[%s]:%d" : "%s:%d", address.getHostAddress(), port);
    }

    private static final boolean $$robo$$android_net_util_IpUtils$isValidUdpOrTcpPort(int port) {
        return port > 0 && port < 65536;
    }

    private void __constructor__() {
        this.$$robo$$android_net_util_IpUtils$__constructor__();
    }

    public IpUtils() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_util_IpUtils$__constructor__(), 0, this);
    }

    private static int intAbs(short s) {
        return (int)InvokeDynamicSupport.bootstrapStatic("intAbs", $$robo$$android_net_util_IpUtils$intAbs(short ), 0, (short)s);
    }

    private static int checksum(ByteBuffer byteBuffer, int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("checksum", $$robo$$android_net_util_IpUtils$checksum(java.nio.ByteBuffer int int int ), 0, (ByteBuffer)byteBuffer, (int)n, (int)n2, (int)n3);
    }

    private static int pseudoChecksumIPv4(ByteBuffer byteBuffer, int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("pseudoChecksumIPv4", $$robo$$android_net_util_IpUtils$pseudoChecksumIPv4(java.nio.ByteBuffer int int int ), 0, (ByteBuffer)byteBuffer, (int)n, (int)n2, (int)n3);
    }

    private static int pseudoChecksumIPv6(ByteBuffer byteBuffer, int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("pseudoChecksumIPv6", $$robo$$android_net_util_IpUtils$pseudoChecksumIPv6(java.nio.ByteBuffer int int int ), 0, (ByteBuffer)byteBuffer, (int)n, (int)n2, (int)n3);
    }

    private static byte ipversion(ByteBuffer byteBuffer, int n) {
        return (byte)InvokeDynamicSupport.bootstrapStatic("ipversion", $$robo$$android_net_util_IpUtils$ipversion(java.nio.ByteBuffer int ), 0, (ByteBuffer)byteBuffer, (int)n);
    }

    public static short ipChecksum(ByteBuffer byteBuffer, int n) {
        return (short)InvokeDynamicSupport.bootstrapStatic("ipChecksum", $$robo$$android_net_util_IpUtils$ipChecksum(java.nio.ByteBuffer int ), 0, (ByteBuffer)byteBuffer, (int)n);
    }

    private static short transportChecksum(ByteBuffer byteBuffer, int n, int n2, int n3, int n4) {
        return (short)InvokeDynamicSupport.bootstrapStatic("transportChecksum", $$robo$$android_net_util_IpUtils$transportChecksum(java.nio.ByteBuffer int int int int ), 0, (ByteBuffer)byteBuffer, (int)n, (int)n2, (int)n3, (int)n4);
    }

    public static short udpChecksum(ByteBuffer byteBuffer, int n, int n2) {
        return (short)InvokeDynamicSupport.bootstrapStatic("udpChecksum", $$robo$$android_net_util_IpUtils$udpChecksum(java.nio.ByteBuffer int int ), 0, (ByteBuffer)byteBuffer, (int)n, (int)n2);
    }

    public static short tcpChecksum(ByteBuffer byteBuffer, int n, int n2, int n3) {
        return (short)InvokeDynamicSupport.bootstrapStatic("tcpChecksum", $$robo$$android_net_util_IpUtils$tcpChecksum(java.nio.ByteBuffer int int int ), 0, (ByteBuffer)byteBuffer, (int)n, (int)n2, (int)n3);
    }

    public static String addressAndPortToString(InetAddress inetAddress, int n) {
        return InvokeDynamicSupport.bootstrapStatic("addressAndPortToString", $$robo$$android_net_util_IpUtils$addressAndPortToString(java.net.InetAddress int ), 0, (InetAddress)inetAddress, (int)n);
    }

    public static boolean isValidUdpOrTcpPort(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidUdpOrTcpPort", $$robo$$android_net_util_IpUtils$isValidUdpOrTcpPort(int ), 0, (int)n);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IpUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

