/*
 * Decompiled with CFR 0.152.
 */
package android.net.ip;

import android.content.Context;
import android.net.LinkProperties;
import android.net.RouteInfo;
import android.net.metrics.IpReachabilityEvent;
import android.net.netlink.NetlinkConstants;
import android.net.netlink.NetlinkErrorMessage;
import android.net.netlink.NetlinkMessage;
import android.net.netlink.NetlinkSocket;
import android.net.netlink.RtNetlinkNeighborMessage;
import android.net.netlink.StructNdMsg;
import android.os.PowerManager;
import android.os.SystemClock;
import android.system.ErrnoException;
import android.system.NetlinkSocketAddress;
import android.system.OsConstants;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.google.errorprone.annotations.DoNotMock;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class IpReachabilityMonitor
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "IpReachabilityMonitor";
    private static boolean DBG = false;
    private static boolean VDBG = false;
    private Object mLock;
    private PowerManager.WakeLock mWakeLock;
    private String mInterfaceName;
    private int mInterfaceIndex;
    private Callback mCallback;
    private NetlinkSocketObserver mNetlinkSocketObserver;
    private Thread mObserverThread;
    @GuardedBy(value="mLock")
    private LinkProperties mLinkProperties;
    @GuardedBy(value="mLock")
    private Map<InetAddress, Short> mIpWatchList;
    @GuardedBy(value="mLock")
    private int mIpWatchListVersion;
    @GuardedBy(value="mLock")
    private boolean mRunning;

    private static final int $$robo$$android_net_ip_IpReachabilityMonitor$probeNeighbor(int ifIndex, InetAddress ip) {
        String msgSnippet = "probing ip=" + ip.getHostAddress() + "%" + ifIndex;
        byte[] msg = RtNetlinkNeighborMessage.newNewNeighborMessage(1, ip, (short)16, ifIndex, null);
        int errno = -OsConstants.EPROTO;
        try (NetlinkSocket nlSocket = new NetlinkSocket(OsConstants.NETLINK_ROUTE);){
            long IO_TIMEOUT = 300L;
            nlSocket.connectToKernel();
            nlSocket.sendMessage(msg, 0, msg.length, 300L);
            ByteBuffer bytes = nlSocket.recvMessage(300L);
            NetlinkMessage response = NetlinkMessage.parse(bytes);
            if (response != null && response instanceof NetlinkErrorMessage && ((NetlinkErrorMessage)response).getNlMsgError() != null) {
                errno = ((NetlinkErrorMessage)response).getNlMsgError().error;
                if (errno != 0) {
                    Log.e("IpReachabilityMonitor", "Error " + msgSnippet + ", errmsg=" + response.toString());
                }
            } else {
                String errmsg;
                if (response == null) {
                    bytes.position(0);
                    errmsg = "raw bytes: " + NetlinkConstants.hexify(bytes);
                } else {
                    errmsg = response.toString();
                }
                Log.e("IpReachabilityMonitor", "Error " + msgSnippet + ", errmsg=" + errmsg);
            }
        }
        catch (ErrnoException e) {
            Log.e("IpReachabilityMonitor", "Error " + msgSnippet, e);
            errno = -e.errno;
        }
        catch (InterruptedIOException e) {
            Log.e("IpReachabilityMonitor", "Error " + msgSnippet, e);
            errno = -OsConstants.ETIMEDOUT;
        }
        catch (SocketException e) {
            Log.e("IpReachabilityMonitor", "Error " + msgSnippet, e);
            errno = -OsConstants.EIO;
        }
        return errno;
    }

    private void $$robo$$android_net_ip_IpReachabilityMonitor$__constructor__(Context context, String ifName, Callback callback) throws IllegalArgumentException {
        this.mLock = new Object();
        this.mLinkProperties = new LinkProperties();
        this.mIpWatchList = new HashMap<InetAddress, Short>();
        this.mInterfaceName = ifName;
        int ifIndex = -1;
        try {
            NetworkInterface netIf = NetworkInterface.getByName(ifName);
            this.mInterfaceIndex = netIf.getIndex();
        }
        catch (NullPointerException | SocketException e) {
            throw new IllegalArgumentException("invalid interface '" + ifName + "': ", e);
        }
        this.mWakeLock = ((PowerManager)context.getSystemService("power")).newWakeLock(1, "IpReachabilityMonitor." + this.mInterfaceName);
        this.mCallback = callback;
        this.mNetlinkSocketObserver = new NetlinkSocketObserver(this);
        this.mObserverThread = new Thread(this.mNetlinkSocketObserver);
        this.mObserverThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_ip_IpReachabilityMonitor$stop() {
        Object object = this.mLock;
        synchronized (object) {
            this.mRunning = false;
        }
        this.clearLinkProperties();
        this.mNetlinkSocketObserver.clearNetlinkSocket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$android_net_ip_IpReachabilityMonitor$describeWatchList() {
        String delimiter = ", ";
        StringBuilder sb = new StringBuilder();
        Object object = this.mLock;
        synchronized (object) {
            sb.append("iface{" + this.mInterfaceName + "/" + this.mInterfaceIndex + "}, ");
            sb.append("v{" + this.mIpWatchListVersion + "}, ");
            sb.append("ntable=[");
            boolean firstTime = true;
            for (Map.Entry<InetAddress, Short> entry : this.mIpWatchList.entrySet()) {
                if (firstTime) {
                    firstTime = false;
                } else {
                    sb.append(", ");
                }
                sb.append(entry.getKey().getHostAddress() + "/" + StructNdMsg.stringForNudState(entry.getValue()));
            }
            sb.append("]");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_net_ip_IpReachabilityMonitor$isWatching(InetAddress ip) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mRunning && this.mIpWatchList.containsKey(ip);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_net_ip_IpReachabilityMonitor$stillRunning() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mRunning;
        }
    }

    private static final boolean $$robo$$android_net_ip_IpReachabilityMonitor$isOnLink(List<RouteInfo> routes, InetAddress ip) {
        for (RouteInfo route : routes) {
            if (route.hasGateway() || !route.matches(ip)) continue;
            return true;
        }
        return false;
    }

    private final short $$robo$$android_net_ip_IpReachabilityMonitor$getNeighborStateLocked(InetAddress ip) {
        if (this.mIpWatchList.containsKey(ip)) {
            return this.mIpWatchList.get(ip);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_ip_IpReachabilityMonitor$updateLinkProperties(LinkProperties lp) {
        if (!this.mInterfaceName.equals(lp.getInterfaceName())) {
            Log.wtf("IpReachabilityMonitor", "requested LinkProperties interface '" + lp.getInterfaceName() + "' does not match: " + this.mInterfaceName);
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mLinkProperties = new LinkProperties(lp);
            HashMap<InetAddress, Short> newIpWatchList = new HashMap<InetAddress, Short>();
            List<RouteInfo> routes = this.mLinkProperties.getRoutes();
            for (RouteInfo route : routes) {
                InetAddress gw;
                if (!route.hasGateway() || !IpReachabilityMonitor.isOnLink(routes, gw = route.getGateway())) continue;
                newIpWatchList.put(gw, this.getNeighborStateLocked(gw));
            }
            for (InetAddress nameserver : lp.getDnsServers()) {
                if (!IpReachabilityMonitor.isOnLink(routes, nameserver)) continue;
                newIpWatchList.put(nameserver, this.getNeighborStateLocked(nameserver));
            }
            this.mIpWatchList = newIpWatchList;
            ++this.mIpWatchListVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_ip_IpReachabilityMonitor$clearLinkProperties() {
        Object object = this.mLock;
        synchronized (object) {
            this.mLinkProperties.clear();
            this.mIpWatchList.clear();
            ++this.mIpWatchListVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_ip_IpReachabilityMonitor$handleNeighborLost(String msg) {
        LinkProperties.ProvisioningChange delta;
        InetAddress ip = null;
        Object object = this.mLock;
        synchronized (object) {
            LinkProperties whatIfLp = new LinkProperties(this.mLinkProperties);
            for (Map.Entry<InetAddress, Short> entry : this.mIpWatchList.entrySet()) {
                if (entry.getValue() != 32) continue;
                ip = entry.getKey();
                for (RouteInfo route : this.mLinkProperties.getRoutes()) {
                    if (!ip.equals(route.getGateway())) continue;
                    whatIfLp.removeRoute(route);
                }
                whatIfLp.removeDnsServer(ip);
            }
            delta = LinkProperties.compareProvisioning(this.mLinkProperties, whatIfLp);
        }
        if (delta == LinkProperties.ProvisioningChange.LOST_PROVISIONING) {
            IpReachabilityEvent.logProvisioningLost(this.mInterfaceName);
            String logMsg = "FAILURE: LOST_PROVISIONING, " + msg;
            Log.w("IpReachabilityMonitor", logMsg);
            if (this.mCallback != null) {
                this.mCallback.notifyLost(ip, logMsg);
            }
        } else {
            IpReachabilityEvent.logNudFailed(this.mInterfaceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_ip_IpReachabilityMonitor$probeAll() {
        HashSet<InetAddress> ipProbeList = new HashSet<InetAddress>();
        Iterator iterator = this.mLock;
        synchronized (iterator) {
            ipProbeList.addAll(this.mIpWatchList.keySet());
        }
        if (!ipProbeList.isEmpty() && this.stillRunning()) {
            this.mWakeLock.acquire(this.getProbeWakeLockDuration());
        }
        for (InetAddress target : ipProbeList) {
            if (!this.stillRunning()) break;
            int returnValue = IpReachabilityMonitor.probeNeighbor(this.mInterfaceIndex, target);
            IpReachabilityEvent.logProbeEvent(this.mInterfaceName, returnValue);
        }
    }

    private final long $$robo$$android_net_ip_IpReachabilityMonitor$getProbeWakeLockDuration() {
        long numUnicastProbes = 3L;
        long retransTimeMs = 1000L;
        long gracePeriodMs = 500L;
        return 3500L;
    }

    private static int probeNeighbor(int n, InetAddress inetAddress) {
        return (int)InvokeDynamicSupport.bootstrapStatic("probeNeighbor", $$robo$$android_net_ip_IpReachabilityMonitor$probeNeighbor(int java.net.InetAddress ), 0, (int)n, (InetAddress)inetAddress);
    }

    private void __constructor__(Context context, String string2, Callback callback) throws IllegalArgumentException {
        this.$$robo$$android_net_ip_IpReachabilityMonitor$__constructor__(context, string2, callback);
    }

    public IpReachabilityMonitor(Context context, String string2, Callback callback) throws IllegalArgumentException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ip_IpReachabilityMonitor$__constructor__(android.content.Context java.lang.String android.net.ip.IpReachabilityMonitor$Callback ), 0, this, context, string2, callback);
    }

    public void stop() {
        InvokeDynamicSupport.bootstrap("stop", $$robo$$android_net_ip_IpReachabilityMonitor$stop(), 0, this);
    }

    private String describeWatchList() {
        return InvokeDynamicSupport.bootstrap("describeWatchList", $$robo$$android_net_ip_IpReachabilityMonitor$describeWatchList(), 0, this);
    }

    private boolean isWatching(InetAddress inetAddress) {
        return (boolean)InvokeDynamicSupport.bootstrap("isWatching", $$robo$$android_net_ip_IpReachabilityMonitor$isWatching(java.net.InetAddress ), 0, this, inetAddress);
    }

    private boolean stillRunning() {
        return (boolean)InvokeDynamicSupport.bootstrap("stillRunning", $$robo$$android_net_ip_IpReachabilityMonitor$stillRunning(), 0, this);
    }

    private static boolean isOnLink(List<RouteInfo> list, InetAddress inetAddress) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isOnLink", $$robo$$android_net_ip_IpReachabilityMonitor$isOnLink(java.util.List<android.net.RouteInfo> java.net.InetAddress ), 0, list, (InetAddress)inetAddress);
    }

    private short getNeighborStateLocked(InetAddress inetAddress) {
        return (short)InvokeDynamicSupport.bootstrap("getNeighborStateLocked", $$robo$$android_net_ip_IpReachabilityMonitor$getNeighborStateLocked(java.net.InetAddress ), 0, this, inetAddress);
    }

    public void updateLinkProperties(LinkProperties linkProperties) {
        InvokeDynamicSupport.bootstrap("updateLinkProperties", $$robo$$android_net_ip_IpReachabilityMonitor$updateLinkProperties(android.net.LinkProperties ), 0, this, linkProperties);
    }

    public void clearLinkProperties() {
        InvokeDynamicSupport.bootstrap("clearLinkProperties", $$robo$$android_net_ip_IpReachabilityMonitor$clearLinkProperties(), 0, this);
    }

    private void handleNeighborLost(String string2) {
        InvokeDynamicSupport.bootstrap("handleNeighborLost", $$robo$$android_net_ip_IpReachabilityMonitor$handleNeighborLost(java.lang.String ), 0, this, string2);
    }

    public void probeAll() {
        InvokeDynamicSupport.bootstrap("probeAll", $$robo$$android_net_ip_IpReachabilityMonitor$probeAll(), 0, this);
    }

    private long getProbeWakeLockDuration() {
        return (long)InvokeDynamicSupport.bootstrap("getProbeWakeLockDuration", $$robo$$android_net_ip_IpReachabilityMonitor$getProbeWakeLockDuration(), 0, this);
    }

    public /* synthetic */ IpReachabilityMonitor() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IpReachabilityMonitor)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private final class NetlinkSocketObserver
    implements Runnable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private NetlinkSocket mSocket;
        /* synthetic */ IpReachabilityMonitor this$0;

        private void $$robo$$android_net_ip_IpReachabilityMonitor_NetlinkSocketObserver$__constructor__(IpReachabilityMonitor ipReachabilityMonitor) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_net_ip_IpReachabilityMonitor_NetlinkSocketObserver$run() {
            Object object = this.this$0.mLock;
            synchronized (object) {
                this.this$0.mRunning = true;
            }
            try {
                this.setupNetlinkSocket();
            }
            catch (ErrnoException | SocketException e) {
                Log.e("IpReachabilityMonitor", "Failed to suitably initialize a netlink socket", e);
                Object object2 = this.this$0.mLock;
                synchronized (object2) {
                    this.this$0.mRunning = false;
                }
            }
            while (this.this$0.stillRunning()) {
                ByteBuffer byteBuffer;
                try {
                    byteBuffer = this.recvKernelReply();
                }
                catch (ErrnoException e) {
                    if (!this.this$0.stillRunning()) break;
                    Log.w("IpReachabilityMonitor", "ErrnoException: ", e);
                    break;
                }
                long whenMs = SystemClock.elapsedRealtime();
                if (byteBuffer == null) continue;
                this.parseNetlinkMessageBuffer(byteBuffer, whenMs);
            }
            this.clearNetlinkSocket();
            Object object3 = this.this$0.mLock;
            synchronized (object3) {
                this.this$0.mRunning = false;
            }
        }

        private final void $$robo$$android_net_ip_IpReachabilityMonitor_NetlinkSocketObserver$clearNetlinkSocket() {
            if (this.mSocket != null) {
                this.mSocket.close();
            }
        }

        private final void $$robo$$android_net_ip_IpReachabilityMonitor_NetlinkSocketObserver$setupNetlinkSocket() throws ErrnoException, SocketException {
            this.clearNetlinkSocket();
            this.mSocket = new NetlinkSocket(OsConstants.NETLINK_ROUTE);
            NetlinkSocketAddress listenAddr = new NetlinkSocketAddress(0, OsConstants.RTMGRP_NEIGH);
            this.mSocket.bind(listenAddr);
        }

        private final ByteBuffer $$robo$$android_net_ip_IpReachabilityMonitor_NetlinkSocketObserver$recvKernelReply() throws ErrnoException {
            block3: {
                try {
                    return this.mSocket.recvMessage(0L);
                }
                catch (InterruptedIOException interruptedIOException) {
                }
                catch (ErrnoException e) {
                    if (e.errno == OsConstants.EAGAIN) break block3;
                    throw e;
                }
            }
            return null;
        }

        private final void $$robo$$android_net_ip_IpReachabilityMonitor_NetlinkSocketObserver$parseNetlinkMessageBuffer(ByteBuffer byteBuffer, long whenMs) {
            while (byteBuffer.remaining() > 0) {
                int position = byteBuffer.position();
                NetlinkMessage nlMsg = NetlinkMessage.parse(byteBuffer);
                if (nlMsg == null || nlMsg.getHeader() == null) {
                    byteBuffer.position(position);
                    Log.e("IpReachabilityMonitor", "unparsable netlink msg: " + NetlinkConstants.hexify(byteBuffer));
                    break;
                }
                int srcPortId = nlMsg.getHeader().nlmsg_pid;
                if (srcPortId != 0) {
                    Log.e("IpReachabilityMonitor", "non-kernel source portId: " + (long)(srcPortId & 0xFFFFFFFF));
                    break;
                }
                if (nlMsg instanceof NetlinkErrorMessage) {
                    Log.e("IpReachabilityMonitor", "netlink error: " + nlMsg);
                    continue;
                }
                if (!(nlMsg instanceof RtNetlinkNeighborMessage)) continue;
                this.evaluateRtNetlinkNeighborMessage((RtNetlinkNeighborMessage)nlMsg, whenMs);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_net_ip_IpReachabilityMonitor_NetlinkSocketObserver$evaluateRtNetlinkNeighborMessage(RtNetlinkNeighborMessage neighMsg, long whenMs) {
            StructNdMsg ndMsg = neighMsg.getNdHeader();
            if (ndMsg == null || ndMsg.ndm_ifindex != this.this$0.mInterfaceIndex) {
                return;
            }
            InetAddress destination = neighMsg.getDestination();
            if (!this.this$0.isWatching(destination)) {
                return;
            }
            short msgType = neighMsg.getHeader().nlmsg_type;
            short nudState = ndMsg.ndm_state;
            String eventMsg = "NeighborEvent{elapsedMs=" + whenMs + ", " + destination.getHostAddress() + ", [" + NetlinkConstants.hexify(neighMsg.getLinkLayerAddress()) + "], " + NetlinkConstants.stringForNlMsgType(msgType) + ", " + StructNdMsg.stringForNudState(nudState) + "}";
            Object object = this.this$0.mLock;
            synchronized (object) {
                if (this.this$0.mIpWatchList.containsKey(destination)) {
                    short value = msgType == 29 ? (short)0 : nudState;
                    this.this$0.mIpWatchList.put(destination, value);
                }
            }
            if (nudState == 32) {
                Log.w("IpReachabilityMonitor", "ALERT: " + eventMsg);
                this.this$0.handleNeighborLost(eventMsg);
            }
        }

        private /* synthetic */ void $$robo$$android_net_ip_IpReachabilityMonitor_NetlinkSocketObserver$__constructor__(IpReachabilityMonitor x0, 1 x1) {
        }

        private void __constructor__(IpReachabilityMonitor ipReachabilityMonitor) {
            this.$$robo$$android_net_ip_IpReachabilityMonitor_NetlinkSocketObserver$__constructor__(ipReachabilityMonitor);
        }

        private NetlinkSocketObserver(IpReachabilityMonitor ipReachabilityMonitor) {
            this.this$0 = ipReachabilityMonitor;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ip_IpReachabilityMonitor_NetlinkSocketObserver$__constructor__(android.net.ip.IpReachabilityMonitor ), 0, this, ipReachabilityMonitor);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_net_ip_IpReachabilityMonitor_NetlinkSocketObserver$run(), 0, this);
        }

        private void clearNetlinkSocket() {
            InvokeDynamicSupport.bootstrap("clearNetlinkSocket", $$robo$$android_net_ip_IpReachabilityMonitor_NetlinkSocketObserver$clearNetlinkSocket(), 0, this);
        }

        private void setupNetlinkSocket() throws ErrnoException, SocketException {
            InvokeDynamicSupport.bootstrap("setupNetlinkSocket", $$robo$$android_net_ip_IpReachabilityMonitor_NetlinkSocketObserver$setupNetlinkSocket(), 0, this);
        }

        private ByteBuffer recvKernelReply() throws ErrnoException {
            return InvokeDynamicSupport.bootstrap("recvKernelReply", $$robo$$android_net_ip_IpReachabilityMonitor_NetlinkSocketObserver$recvKernelReply(), 0, this);
        }

        private void parseNetlinkMessageBuffer(ByteBuffer byteBuffer, long l) {
            InvokeDynamicSupport.bootstrap("parseNetlinkMessageBuffer", $$robo$$android_net_ip_IpReachabilityMonitor_NetlinkSocketObserver$parseNetlinkMessageBuffer(java.nio.ByteBuffer long ), 0, this, byteBuffer, l);
        }

        private void evaluateRtNetlinkNeighborMessage(RtNetlinkNeighborMessage rtNetlinkNeighborMessage, long l) {
            InvokeDynamicSupport.bootstrap("evaluateRtNetlinkNeighborMessage", $$robo$$android_net_ip_IpReachabilityMonitor_NetlinkSocketObserver$evaluateRtNetlinkNeighborMessage(android.net.netlink.RtNetlinkNeighborMessage long ), 0, this, rtNetlinkNeighborMessage, l);
        }

        private /* synthetic */ void __constructor__(IpReachabilityMonitor ipReachabilityMonitor, 1 var2_2) {
            this.$$robo$$android_net_ip_IpReachabilityMonitor_NetlinkSocketObserver$__constructor__(ipReachabilityMonitor, var2_2);
        }

        public /* synthetic */ NetlinkSocketObserver() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetlinkSocketObserver)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface Callback
    extends InstrumentedInterface {
        public void notifyLost(InetAddress var1, String var2);
    }
}

