/*
 * Decompiled with CFR 0.152.
 */
package android.net.dhcp;

import android.net.dhcp.DhcpPacket;
import java.net.Inet4Address;
import java.nio.ByteBuffer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DhcpAckPacket
extends DhcpPacket
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Inet4Address mSrcIp;

    private void $$robo$$android_net_dhcp_DhcpAckPacket$__constructor__(int transId, short secs, boolean broadcast, Inet4Address serverAddress, Inet4Address clientIp, Inet4Address yourIp, byte[] clientMac) {
        this.mBroadcast = broadcast;
        this.mSrcIp = serverAddress;
    }

    private final String $$robo$$android_net_dhcp_DhcpAckPacket$toString() {
        String s = super.toString();
        String dnsServers = " DNS servers: ";
        for (Inet4Address dnsServer : this.mDnsServers) {
            dnsServers = dnsServers + dnsServer.toString() + " ";
        }
        return s + " ACK: your new IP " + this.mYourIp + ", netmask " + this.mSubnetMask + ", gateways " + this.mGateways + dnsServers + ", lease time " + this.mLeaseTime;
    }

    private final ByteBuffer $$robo$$android_net_dhcp_DhcpAckPacket$buildPacket(int encap, short destUdp, short srcUdp) {
        ByteBuffer result = ByteBuffer.allocate(1500);
        Inet4Address destIp = this.mBroadcast ? INADDR_BROADCAST : this.mYourIp;
        Inet4Address srcIp = this.mBroadcast ? INADDR_ANY : this.mSrcIp;
        this.fillInPacket(encap, destIp, srcIp, destUdp, srcUdp, result, (byte)2, this.mBroadcast);
        result.flip();
        return result;
    }

    private final void $$robo$$android_net_dhcp_DhcpAckPacket$finishPacket(ByteBuffer buffer) {
        DhcpAckPacket.addTlv(buffer, (byte)53, (byte)5);
        DhcpAckPacket.addTlv(buffer, (byte)54, this.mServerIdentifier);
        DhcpAckPacket.addTlv(buffer, (byte)51, this.mLeaseTime);
        if (this.mLeaseTime != null) {
            DhcpAckPacket.addTlv(buffer, (byte)58, this.mLeaseTime / 2);
        }
        DhcpAckPacket.addTlv(buffer, (byte)1, this.mSubnetMask);
        DhcpAckPacket.addTlv(buffer, (byte)3, this.mGateways);
        DhcpAckPacket.addTlv(buffer, (byte)15, this.mDomainName);
        DhcpAckPacket.addTlv(buffer, (byte)28, this.mBroadcastAddress);
        DhcpAckPacket.addTlv(buffer, (byte)6, this.mDnsServers);
        DhcpAckPacket.addTlvEnd(buffer);
    }

    private static final int $$robo$$android_net_dhcp_DhcpAckPacket$getInt(Integer v) {
        if (v == null) {
            return 0;
        }
        return v;
    }

    private void __constructor__(int n, short s, boolean bl, Inet4Address inet4Address, Inet4Address inet4Address2, Inet4Address inet4Address3, byte[] byArray) {
        this.$$robo$$android_net_dhcp_DhcpAckPacket$__constructor__(n, s, bl, inet4Address, inet4Address2, inet4Address3, byArray);
    }

    DhcpAckPacket(int n, short s, boolean bl, Inet4Address inet4Address, Inet4Address inet4Address2, Inet4Address inet4Address3, byte[] byArray) {
        super(n, s, inet4Address2, inet4Address3, inet4Address, INADDR_ANY, byArray, bl);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_dhcp_DhcpAckPacket$__constructor__(int short boolean java.net.Inet4Address java.net.Inet4Address java.net.Inet4Address byte[] ), 0, this, n, s, bl, inet4Address, inet4Address2, inet4Address3, byArray);
    }

    @Override
    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_dhcp_DhcpAckPacket$toString(), 0, this);
    }

    @Override
    public ByteBuffer buildPacket(int n, short s, short s2) {
        return InvokeDynamicSupport.bootstrap("buildPacket", $$robo$$android_net_dhcp_DhcpAckPacket$buildPacket(int short short ), 0, this, n, s, s2);
    }

    @Override
    void finishPacket(ByteBuffer byteBuffer) {
        InvokeDynamicSupport.bootstrap("finishPacket", $$robo$$android_net_dhcp_DhcpAckPacket$finishPacket(java.nio.ByteBuffer ), 0, this, byteBuffer);
    }

    private static int getInt(Integer n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getInt", $$robo$$android_net_dhcp_DhcpAckPacket$getInt(java.lang.Integer ), 0, (Integer)n);
    }

    public /* synthetic */ DhcpAckPacket() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DhcpAckPacket)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

