/*
 * Decompiled with CFR 0.152.
 */
package android.net.apf;

import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.HashMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ApfGenerator
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String DROP_LABEL = "__DROP__";
    public static String PASS_LABEL = "__PASS__";
    public static int MEMORY_SLOTS = 16;
    public static int IPV4_HEADER_SIZE_MEMORY_SLOT = 13;
    public static int PACKET_SIZE_MEMORY_SLOT = 14;
    public static int FILTER_AGE_MEMORY_SLOT = 15;
    public static int FIRST_PREFILLED_MEMORY_SLOT = 13;
    public static int LAST_PREFILLED_MEMORY_SLOT = 15;
    private ArrayList<Instruction> mInstructions;
    private HashMap<String, Instruction> mLabels;
    private Instruction mDropLabel;
    private Instruction mPassLabel;
    private boolean mGenerated;

    private void $$robo$$android_net_apf_ApfGenerator$__constructor__() {
        this.mInstructions = new ArrayList();
        this.mLabels = new HashMap();
        this.mDropLabel = new Instruction(this, Opcodes.LABEL);
        this.mPassLabel = new Instruction(this, Opcodes.LABEL);
    }

    private final boolean $$robo$$android_net_apf_ApfGenerator$setApfVersion(int version) {
        return version == 2;
    }

    private final void $$robo$$android_net_apf_ApfGenerator$addInstruction(Instruction instruction) {
        if (this.mGenerated) {
            throw new IllegalStateException("Program already generated");
        }
        this.mInstructions.add(instruction);
    }

    private final ApfGenerator $$robo$$android_net_apf_ApfGenerator$defineLabel(String name) throws IllegalInstructionException {
        Instruction instruction = new Instruction(this, Opcodes.LABEL);
        instruction.setLabel(name);
        this.addInstruction(instruction);
        return this;
    }

    private final ApfGenerator $$robo$$android_net_apf_ApfGenerator$addJump(String target) {
        Instruction instruction = new Instruction(this, Opcodes.JMP);
        instruction.setTargetLabel(target);
        this.addInstruction(instruction);
        return this;
    }

    private final ApfGenerator $$robo$$android_net_apf_ApfGenerator$addLoad8(Register register, int offset) {
        Instruction instruction = new Instruction(this, Opcodes.LDB, register);
        instruction.setUnsignedImm(offset);
        this.addInstruction(instruction);
        return this;
    }

    private final ApfGenerator $$robo$$android_net_apf_ApfGenerator$addLoad16(Register register, int offset) {
        Instruction instruction = new Instruction(this, Opcodes.LDH, register);
        instruction.setUnsignedImm(offset);
        this.addInstruction(instruction);
        return this;
    }

    private final ApfGenerator $$robo$$android_net_apf_ApfGenerator$addLoad32(Register register, int offset) {
        Instruction instruction = new Instruction(this, Opcodes.LDW, register);
        instruction.setUnsignedImm(offset);
        this.addInstruction(instruction);
        return this;
    }

    private final ApfGenerator $$robo$$android_net_apf_ApfGenerator$addLoad8Indexed(Register register, int offset) {
        Instruction instruction = new Instruction(this, Opcodes.LDBX, register);
        instruction.setUnsignedImm(offset);
        this.addInstruction(instruction);
        return this;
    }

    private final ApfGenerator $$robo$$android_net_apf_ApfGenerator$addLoad16Indexed(Register register, int offset) {
        Instruction instruction = new Instruction(this, Opcodes.LDHX, register);
        instruction.setUnsignedImm(offset);
        this.addInstruction(instruction);
        return this;
    }

    private final ApfGenerator $$robo$$android_net_apf_ApfGenerator$addLoad32Indexed(Register register, int offset) {
        Instruction instruction = new Instruction(this, Opcodes.LDWX, register);
        instruction.setUnsignedImm(offset);
        this.addInstruction(instruction);
        return this;
    }

    private final ApfGenerator $$robo$$android_net_apf_ApfGenerator$addAdd(int value) {
        Instruction instruction = new Instruction(this, Opcodes.ADD);
        instruction.setSignedImm(value);
        this.addInstruction(instruction);
        return this;
    }

    private final ApfGenerator $$robo$$android_net_apf_ApfGenerator$addMul(int value) {
        Instruction instruction = new Instruction(this, Opcodes.MUL);
        instruction.setSignedImm(value);
        this.addInstruction(instruction);
        return this;
    }

    private final ApfGenerator $$robo$$android_net_apf_ApfGenerator$addDiv(int value) {
        Instruction instruction = new Instruction(this, Opcodes.DIV);
        instruction.setSignedImm(value);
        this.addInstruction(instruction);
        return this;
    }

    private final ApfGenerator $$robo$$android_net_apf_ApfGenerator$addAnd(int value) {
        Instruction instruction = new Instruction(this, Opcodes.AND);
        instruction.setUnsignedImm(value);
        this.addInstruction(instruction);
        return this;
    }

    private final ApfGenerator $$robo$$android_net_apf_ApfGenerator$addOr(int value) {
        Instruction instruction = new Instruction(this, Opcodes.OR);
        instruction.setUnsignedImm(value);
        this.addInstruction(instruction);
        return this;
    }

    private final ApfGenerator $$robo$$android_net_apf_ApfGenerator$addLeftShift(int value) {
        Instruction instruction = new Instruction(this, Opcodes.SH);
        instruction.setSignedImm(value);
        this.addInstruction(instruction);
        return this;
    }

    private final ApfGenerator $$robo$$android_net_apf_ApfGenerator$addRightShift(int value) {
        Instruction instruction = new Instruction(this, Opcodes.SH);
        instruction.setSignedImm(-value);
        this.addInstruction(instruction);
        return this;
    }

    private final ApfGenerator $$robo$$android_net_apf_ApfGenerator$addAddR1() {
        Instruction instruction = new Instruction(this, Opcodes.ADD, Register.R1);
        this.addInstruction(instruction);
        return this;
    }

    private final ApfGenerator $$robo$$android_net_apf_ApfGenerator$addMulR1() {
        Instruction instruction = new Instruction(this, Opcodes.MUL, Register.R1);
        this.addInstruction(instruction);
        return this;
    }

    private final ApfGenerator $$robo$$android_net_apf_ApfGenerator$addDivR1() {
        Instruction instruction = new Instruction(this, Opcodes.DIV, Register.R1);
        this.addInstruction(instruction);
        return this;
    }

    private final ApfGenerator $$robo$$android_net_apf_ApfGenerator$addAndR1() {
        Instruction instruction = new Instruction(this, Opcodes.AND, Register.R1);
        this.addInstruction(instruction);
        return this;
    }

    private final ApfGenerator $$robo$$android_net_apf_ApfGenerator$addOrR1() {
        Instruction instruction = new Instruction(this, Opcodes.OR, Register.R1);
        this.addInstruction(instruction);
        return this;
    }

    private final ApfGenerator $$robo$$android_net_apf_ApfGenerator$addLeftShiftR1() {
        Instruction instruction = new Instruction(this, Opcodes.SH, Register.R1);
        this.addInstruction(instruction);
        return this;
    }

    private final ApfGenerator $$robo$$android_net_apf_ApfGenerator$addLoadImmediate(Register register, int value) {
        Instruction instruction = new Instruction(this, Opcodes.LI, register);
        instruction.setSignedImm(value);
        this.addInstruction(instruction);
        return this;
    }

    private final ApfGenerator $$robo$$android_net_apf_ApfGenerator$addJumpIfR0Equals(int value, String target) {
        Instruction instruction = new Instruction(this, Opcodes.JEQ);
        instruction.setUnsignedImm(value);
        instruction.setTargetLabel(target);
        this.addInstruction(instruction);
        return this;
    }

    private final ApfGenerator $$robo$$android_net_apf_ApfGenerator$addJumpIfR0NotEquals(int value, String target) {
        Instruction instruction = new Instruction(this, Opcodes.JNE);
        instruction.setUnsignedImm(value);
        instruction.setTargetLabel(target);
        this.addInstruction(instruction);
        return this;
    }

    private final ApfGenerator $$robo$$android_net_apf_ApfGenerator$addJumpIfR0GreaterThan(int value, String target) {
        Instruction instruction = new Instruction(this, Opcodes.JGT);
        instruction.setUnsignedImm(value);
        instruction.setTargetLabel(target);
        this.addInstruction(instruction);
        return this;
    }

    private final ApfGenerator $$robo$$android_net_apf_ApfGenerator$addJumpIfR0LessThan(int value, String target) {
        Instruction instruction = new Instruction(this, Opcodes.JLT);
        instruction.setUnsignedImm(value);
        instruction.setTargetLabel(target);
        this.addInstruction(instruction);
        return this;
    }

    private final ApfGenerator $$robo$$android_net_apf_ApfGenerator$addJumpIfR0AnyBitsSet(int value, String target) {
        Instruction instruction = new Instruction(this, Opcodes.JSET);
        instruction.setUnsignedImm(value);
        instruction.setTargetLabel(target);
        this.addInstruction(instruction);
        return this;
    }

    private final ApfGenerator $$robo$$android_net_apf_ApfGenerator$addJumpIfR0EqualsR1(String target) {
        Instruction instruction = new Instruction(this, Opcodes.JEQ, Register.R1);
        instruction.setTargetLabel(target);
        this.addInstruction(instruction);
        return this;
    }

    private final ApfGenerator $$robo$$android_net_apf_ApfGenerator$addJumpIfR0NotEqualsR1(String target) {
        Instruction instruction = new Instruction(this, Opcodes.JNE, Register.R1);
        instruction.setTargetLabel(target);
        this.addInstruction(instruction);
        return this;
    }

    private final ApfGenerator $$robo$$android_net_apf_ApfGenerator$addJumpIfR0GreaterThanR1(String target) {
        Instruction instruction = new Instruction(this, Opcodes.JGT, Register.R1);
        instruction.setTargetLabel(target);
        this.addInstruction(instruction);
        return this;
    }

    private final ApfGenerator $$robo$$android_net_apf_ApfGenerator$addJumpIfR0LessThanR1(String target) {
        Instruction instruction = new Instruction(this, Opcodes.JLT, Register.R1);
        instruction.setTargetLabel(target);
        this.addInstruction(instruction);
        return this;
    }

    private final ApfGenerator $$robo$$android_net_apf_ApfGenerator$addJumpIfR0AnyBitsSetR1(String target) {
        Instruction instruction = new Instruction(this, Opcodes.JSET, Register.R1);
        instruction.setTargetLabel(target);
        this.addInstruction(instruction);
        return this;
    }

    private final ApfGenerator $$robo$$android_net_apf_ApfGenerator$addJumpIfBytesNotEqual(Register register, byte[] bytes, String target) throws IllegalInstructionException {
        if (register == Register.R1) {
            throw new IllegalInstructionException("JNEBS fails with R1");
        }
        Instruction instruction = new Instruction(this, Opcodes.JNEBS, register);
        instruction.setUnsignedImm(bytes.length);
        instruction.setTargetLabel(target);
        instruction.setCompareBytes(bytes);
        this.addInstruction(instruction);
        return this;
    }

    private final ApfGenerator $$robo$$android_net_apf_ApfGenerator$addLoadFromMemory(Register register, int slot) throws IllegalInstructionException {
        if (slot < 0 || slot > 15) {
            throw new IllegalInstructionException("illegal memory slot number: " + slot);
        }
        Instruction instruction = new Instruction(this, Opcodes.EXT, register);
        instruction.setUnsignedImm(ExtendedOpcodes.LDM.value + slot);
        this.addInstruction(instruction);
        return this;
    }

    private final ApfGenerator $$robo$$android_net_apf_ApfGenerator$addStoreToMemory(Register register, int slot) throws IllegalInstructionException {
        if (slot < 0 || slot > 15) {
            throw new IllegalInstructionException("illegal memory slot number: " + slot);
        }
        Instruction instruction = new Instruction(this, Opcodes.EXT, register);
        instruction.setUnsignedImm(ExtendedOpcodes.STM.value + slot);
        this.addInstruction(instruction);
        return this;
    }

    private final ApfGenerator $$robo$$android_net_apf_ApfGenerator$addNot(Register register) {
        Instruction instruction = new Instruction(this, Opcodes.EXT, register);
        instruction.setUnsignedImm(ExtendedOpcodes.NOT.value);
        this.addInstruction(instruction);
        return this;
    }

    private final ApfGenerator $$robo$$android_net_apf_ApfGenerator$addNeg(Register register) {
        Instruction instruction = new Instruction(this, Opcodes.EXT, register);
        instruction.setUnsignedImm(ExtendedOpcodes.NEG.value);
        this.addInstruction(instruction);
        return this;
    }

    private final ApfGenerator $$robo$$android_net_apf_ApfGenerator$addSwap() {
        Instruction instruction = new Instruction(this, Opcodes.EXT);
        instruction.setUnsignedImm(ExtendedOpcodes.SWAP.value);
        this.addInstruction(instruction);
        return this;
    }

    private final ApfGenerator $$robo$$android_net_apf_ApfGenerator$addMove(Register register) {
        Instruction instruction = new Instruction(this, Opcodes.EXT, register);
        instruction.setUnsignedImm(ExtendedOpcodes.MOVE.value);
        this.addInstruction(instruction);
        return this;
    }

    private final int $$robo$$android_net_apf_ApfGenerator$updateInstructionOffsets() {
        int offset = 0;
        for (Instruction instruction : this.mInstructions) {
            instruction.offset = offset;
            offset += instruction.size();
        }
        return offset;
    }

    private final int $$robo$$android_net_apf_ApfGenerator$programLengthOverEstimate() {
        return this.updateInstructionOffsets();
    }

    private final byte[] $$robo$$android_net_apf_ApfGenerator$generate() throws IllegalInstructionException {
        int total_size;
        boolean shrunk;
        if (this.mGenerated) {
            throw new IllegalStateException("Can only generate() once!");
        }
        this.mGenerated = true;
        int iterations_remaining = 10;
        do {
            total_size = this.updateInstructionOffsets();
            this.mDropLabel.offset = total_size + 1;
            this.mPassLabel.offset = total_size;
            if (iterations_remaining-- == 0) break;
            shrunk = false;
            for (Instruction instruction : this.mInstructions) {
                if (!instruction.shrink()) continue;
                shrunk = true;
            }
        } while (shrunk);
        byte[] bytecode = new byte[total_size];
        for (Instruction instruction : this.mInstructions) {
            instruction.generate(bytecode);
        }
        return bytecode;
    }

    private void __constructor__() {
        this.$$robo$$android_net_apf_ApfGenerator$__constructor__();
    }

    public ApfGenerator() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_apf_ApfGenerator$__constructor__(), 0, this);
    }

    public boolean setApfVersion(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("setApfVersion", $$robo$$android_net_apf_ApfGenerator$setApfVersion(int ), 0, this, n);
    }

    private void addInstruction(Instruction instruction) {
        InvokeDynamicSupport.bootstrap("addInstruction", $$robo$$android_net_apf_ApfGenerator$addInstruction(android.net.apf.ApfGenerator$Instruction ), 0, this, instruction);
    }

    public ApfGenerator defineLabel(String string2) throws IllegalInstructionException {
        return InvokeDynamicSupport.bootstrap("defineLabel", $$robo$$android_net_apf_ApfGenerator$defineLabel(java.lang.String ), 0, this, string2);
    }

    public ApfGenerator addJump(String string2) {
        return InvokeDynamicSupport.bootstrap("addJump", $$robo$$android_net_apf_ApfGenerator$addJump(java.lang.String ), 0, this, string2);
    }

    public ApfGenerator addLoad8(Register register, int n) {
        return InvokeDynamicSupport.bootstrap("addLoad8", $$robo$$android_net_apf_ApfGenerator$addLoad8(android.net.apf.ApfGenerator$Register int ), 0, this, register, n);
    }

    public ApfGenerator addLoad16(Register register, int n) {
        return InvokeDynamicSupport.bootstrap("addLoad16", $$robo$$android_net_apf_ApfGenerator$addLoad16(android.net.apf.ApfGenerator$Register int ), 0, this, register, n);
    }

    public ApfGenerator addLoad32(Register register, int n) {
        return InvokeDynamicSupport.bootstrap("addLoad32", $$robo$$android_net_apf_ApfGenerator$addLoad32(android.net.apf.ApfGenerator$Register int ), 0, this, register, n);
    }

    public ApfGenerator addLoad8Indexed(Register register, int n) {
        return InvokeDynamicSupport.bootstrap("addLoad8Indexed", $$robo$$android_net_apf_ApfGenerator$addLoad8Indexed(android.net.apf.ApfGenerator$Register int ), 0, this, register, n);
    }

    public ApfGenerator addLoad16Indexed(Register register, int n) {
        return InvokeDynamicSupport.bootstrap("addLoad16Indexed", $$robo$$android_net_apf_ApfGenerator$addLoad16Indexed(android.net.apf.ApfGenerator$Register int ), 0, this, register, n);
    }

    public ApfGenerator addLoad32Indexed(Register register, int n) {
        return InvokeDynamicSupport.bootstrap("addLoad32Indexed", $$robo$$android_net_apf_ApfGenerator$addLoad32Indexed(android.net.apf.ApfGenerator$Register int ), 0, this, register, n);
    }

    public ApfGenerator addAdd(int n) {
        return InvokeDynamicSupport.bootstrap("addAdd", $$robo$$android_net_apf_ApfGenerator$addAdd(int ), 0, this, n);
    }

    public ApfGenerator addMul(int n) {
        return InvokeDynamicSupport.bootstrap("addMul", $$robo$$android_net_apf_ApfGenerator$addMul(int ), 0, this, n);
    }

    public ApfGenerator addDiv(int n) {
        return InvokeDynamicSupport.bootstrap("addDiv", $$robo$$android_net_apf_ApfGenerator$addDiv(int ), 0, this, n);
    }

    public ApfGenerator addAnd(int n) {
        return InvokeDynamicSupport.bootstrap("addAnd", $$robo$$android_net_apf_ApfGenerator$addAnd(int ), 0, this, n);
    }

    public ApfGenerator addOr(int n) {
        return InvokeDynamicSupport.bootstrap("addOr", $$robo$$android_net_apf_ApfGenerator$addOr(int ), 0, this, n);
    }

    public ApfGenerator addLeftShift(int n) {
        return InvokeDynamicSupport.bootstrap("addLeftShift", $$robo$$android_net_apf_ApfGenerator$addLeftShift(int ), 0, this, n);
    }

    public ApfGenerator addRightShift(int n) {
        return InvokeDynamicSupport.bootstrap("addRightShift", $$robo$$android_net_apf_ApfGenerator$addRightShift(int ), 0, this, n);
    }

    public ApfGenerator addAddR1() {
        return InvokeDynamicSupport.bootstrap("addAddR1", $$robo$$android_net_apf_ApfGenerator$addAddR1(), 0, this);
    }

    public ApfGenerator addMulR1() {
        return InvokeDynamicSupport.bootstrap("addMulR1", $$robo$$android_net_apf_ApfGenerator$addMulR1(), 0, this);
    }

    public ApfGenerator addDivR1() {
        return InvokeDynamicSupport.bootstrap("addDivR1", $$robo$$android_net_apf_ApfGenerator$addDivR1(), 0, this);
    }

    public ApfGenerator addAndR1() {
        return InvokeDynamicSupport.bootstrap("addAndR1", $$robo$$android_net_apf_ApfGenerator$addAndR1(), 0, this);
    }

    public ApfGenerator addOrR1() {
        return InvokeDynamicSupport.bootstrap("addOrR1", $$robo$$android_net_apf_ApfGenerator$addOrR1(), 0, this);
    }

    public ApfGenerator addLeftShiftR1() {
        return InvokeDynamicSupport.bootstrap("addLeftShiftR1", $$robo$$android_net_apf_ApfGenerator$addLeftShiftR1(), 0, this);
    }

    public ApfGenerator addLoadImmediate(Register register, int n) {
        return InvokeDynamicSupport.bootstrap("addLoadImmediate", $$robo$$android_net_apf_ApfGenerator$addLoadImmediate(android.net.apf.ApfGenerator$Register int ), 0, this, register, n);
    }

    public ApfGenerator addJumpIfR0Equals(int n, String string2) {
        return InvokeDynamicSupport.bootstrap("addJumpIfR0Equals", $$robo$$android_net_apf_ApfGenerator$addJumpIfR0Equals(int java.lang.String ), 0, this, n, string2);
    }

    public ApfGenerator addJumpIfR0NotEquals(int n, String string2) {
        return InvokeDynamicSupport.bootstrap("addJumpIfR0NotEquals", $$robo$$android_net_apf_ApfGenerator$addJumpIfR0NotEquals(int java.lang.String ), 0, this, n, string2);
    }

    public ApfGenerator addJumpIfR0GreaterThan(int n, String string2) {
        return InvokeDynamicSupport.bootstrap("addJumpIfR0GreaterThan", $$robo$$android_net_apf_ApfGenerator$addJumpIfR0GreaterThan(int java.lang.String ), 0, this, n, string2);
    }

    public ApfGenerator addJumpIfR0LessThan(int n, String string2) {
        return InvokeDynamicSupport.bootstrap("addJumpIfR0LessThan", $$robo$$android_net_apf_ApfGenerator$addJumpIfR0LessThan(int java.lang.String ), 0, this, n, string2);
    }

    public ApfGenerator addJumpIfR0AnyBitsSet(int n, String string2) {
        return InvokeDynamicSupport.bootstrap("addJumpIfR0AnyBitsSet", $$robo$$android_net_apf_ApfGenerator$addJumpIfR0AnyBitsSet(int java.lang.String ), 0, this, n, string2);
    }

    public ApfGenerator addJumpIfR0EqualsR1(String string2) {
        return InvokeDynamicSupport.bootstrap("addJumpIfR0EqualsR1", $$robo$$android_net_apf_ApfGenerator$addJumpIfR0EqualsR1(java.lang.String ), 0, this, string2);
    }

    public ApfGenerator addJumpIfR0NotEqualsR1(String string2) {
        return InvokeDynamicSupport.bootstrap("addJumpIfR0NotEqualsR1", $$robo$$android_net_apf_ApfGenerator$addJumpIfR0NotEqualsR1(java.lang.String ), 0, this, string2);
    }

    public ApfGenerator addJumpIfR0GreaterThanR1(String string2) {
        return InvokeDynamicSupport.bootstrap("addJumpIfR0GreaterThanR1", $$robo$$android_net_apf_ApfGenerator$addJumpIfR0GreaterThanR1(java.lang.String ), 0, this, string2);
    }

    public ApfGenerator addJumpIfR0LessThanR1(String string2) {
        return InvokeDynamicSupport.bootstrap("addJumpIfR0LessThanR1", $$robo$$android_net_apf_ApfGenerator$addJumpIfR0LessThanR1(java.lang.String ), 0, this, string2);
    }

    public ApfGenerator addJumpIfR0AnyBitsSetR1(String string2) {
        return InvokeDynamicSupport.bootstrap("addJumpIfR0AnyBitsSetR1", $$robo$$android_net_apf_ApfGenerator$addJumpIfR0AnyBitsSetR1(java.lang.String ), 0, this, string2);
    }

    public ApfGenerator addJumpIfBytesNotEqual(Register register, byte[] byArray, String string2) throws IllegalInstructionException {
        return InvokeDynamicSupport.bootstrap("addJumpIfBytesNotEqual", $$robo$$android_net_apf_ApfGenerator$addJumpIfBytesNotEqual(android.net.apf.ApfGenerator$Register byte[] java.lang.String ), 0, this, register, byArray, string2);
    }

    public ApfGenerator addLoadFromMemory(Register register, int n) throws IllegalInstructionException {
        return InvokeDynamicSupport.bootstrap("addLoadFromMemory", $$robo$$android_net_apf_ApfGenerator$addLoadFromMemory(android.net.apf.ApfGenerator$Register int ), 0, this, register, n);
    }

    public ApfGenerator addStoreToMemory(Register register, int n) throws IllegalInstructionException {
        return InvokeDynamicSupport.bootstrap("addStoreToMemory", $$robo$$android_net_apf_ApfGenerator$addStoreToMemory(android.net.apf.ApfGenerator$Register int ), 0, this, register, n);
    }

    public ApfGenerator addNot(Register register) {
        return InvokeDynamicSupport.bootstrap("addNot", $$robo$$android_net_apf_ApfGenerator$addNot(android.net.apf.ApfGenerator$Register ), 0, this, register);
    }

    public ApfGenerator addNeg(Register register) {
        return InvokeDynamicSupport.bootstrap("addNeg", $$robo$$android_net_apf_ApfGenerator$addNeg(android.net.apf.ApfGenerator$Register ), 0, this, register);
    }

    public ApfGenerator addSwap() {
        return InvokeDynamicSupport.bootstrap("addSwap", $$robo$$android_net_apf_ApfGenerator$addSwap(), 0, this);
    }

    public ApfGenerator addMove(Register register) {
        return InvokeDynamicSupport.bootstrap("addMove", $$robo$$android_net_apf_ApfGenerator$addMove(android.net.apf.ApfGenerator$Register ), 0, this, register);
    }

    private int updateInstructionOffsets() {
        return (int)InvokeDynamicSupport.bootstrap("updateInstructionOffsets", $$robo$$android_net_apf_ApfGenerator$updateInstructionOffsets(), 0, this);
    }

    public int programLengthOverEstimate() {
        return (int)InvokeDynamicSupport.bootstrap("programLengthOverEstimate", $$robo$$android_net_apf_ApfGenerator$programLengthOverEstimate(), 0, this);
    }

    public byte[] generate() throws IllegalInstructionException {
        return InvokeDynamicSupport.bootstrap("generate", $$robo$$android_net_apf_ApfGenerator$generate(), 0, this);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ApfGenerator)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class Instruction
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private byte mOpcode;
        private byte mRegister;
        private boolean mHasImm;
        private byte mImmSize;
        private boolean mImmSigned;
        private int mImm;
        private byte mTargetLabelSize;
        private String mTargetLabel;
        private String mLabel;
        private byte[] mCompareBytes;
        int offset;
        /* synthetic */ ApfGenerator this$0;

        private void $$robo$$android_net_apf_ApfGenerator_Instruction$__constructor__(ApfGenerator apfGenerator, Opcodes opcode, Register register) {
            this.mOpcode = (byte)opcode.value;
            this.mRegister = (byte)register.value;
        }

        private void $$robo$$android_net_apf_ApfGenerator_Instruction$__constructor__(ApfGenerator apfGenerator, Opcodes opcode) {
        }

        private final void $$robo$$android_net_apf_ApfGenerator_Instruction$setImm(int imm, boolean signed) {
            this.mHasImm = true;
            this.mImm = imm;
            this.mImmSigned = signed;
            this.mImmSize = this.calculateImmSize(imm, signed);
        }

        private final void $$robo$$android_net_apf_ApfGenerator_Instruction$setUnsignedImm(int imm) {
            this.setImm(imm, false);
        }

        private final void $$robo$$android_net_apf_ApfGenerator_Instruction$setSignedImm(int imm) {
            this.setImm(imm, true);
        }

        private final void $$robo$$android_net_apf_ApfGenerator_Instruction$setLabel(String label) throws IllegalInstructionException {
            if (this.this$0.mLabels.containsKey(label)) {
                throw new IllegalInstructionException("duplicate label " + label);
            }
            if (this.mOpcode != Opcodes.LABEL.value) {
                throw new IllegalStateException("adding label to non-label instruction");
            }
            this.mLabel = label;
            this.this$0.mLabels.put(label, this);
        }

        private final void $$robo$$android_net_apf_ApfGenerator_Instruction$setTargetLabel(String label) {
            this.mTargetLabel = label;
            this.mTargetLabelSize = (byte)4;
        }

        private final void $$robo$$android_net_apf_ApfGenerator_Instruction$setCompareBytes(byte[] bytes) {
            if (this.mOpcode != Opcodes.JNEBS.value) {
                throw new IllegalStateException("adding compare bytes to non-JNEBS instruction");
            }
            this.mCompareBytes = bytes;
        }

        private final int $$robo$$android_net_apf_ApfGenerator_Instruction$size() {
            if (this.mOpcode == Opcodes.LABEL.value) {
                return 0;
            }
            int size = 1;
            if (this.mHasImm) {
                size += this.generatedImmSize();
            }
            if (this.mTargetLabel != null) {
                size += this.generatedImmSize();
            }
            if (this.mCompareBytes != null) {
                size += this.mCompareBytes.length;
            }
            return size;
        }

        private final boolean $$robo$$android_net_apf_ApfGenerator_Instruction$shrink() throws IllegalInstructionException {
            if (this.mTargetLabel == null) {
                return false;
            }
            int oldSize = this.size();
            byte oldTargetLabelSize = this.mTargetLabelSize;
            this.mTargetLabelSize = this.calculateImmSize(this.calculateTargetLabelOffset(), false);
            if (this.mTargetLabelSize > oldTargetLabelSize) {
                throw new IllegalStateException("instruction grew");
            }
            return this.size() < oldSize;
        }

        private final byte $$robo$$android_net_apf_ApfGenerator_Instruction$generateImmSizeField() {
            byte immSize = this.generatedImmSize();
            return immSize == 4 ? (byte)3 : (byte)immSize;
        }

        private final byte $$robo$$android_net_apf_ApfGenerator_Instruction$generateInstructionByte() {
            byte sizeField = this.generateImmSizeField();
            return (byte)(this.mOpcode << 3 | sizeField << 1 | this.mRegister);
        }

        private final int $$robo$$android_net_apf_ApfGenerator_Instruction$writeValue(int value, byte[] bytecode, int writingOffset) {
            for (int i = this.generatedImmSize() - 1; i >= 0; --i) {
                bytecode[writingOffset++] = (byte)(value >> i * 8 & 0xFF);
            }
            return writingOffset;
        }

        private final void $$robo$$android_net_apf_ApfGenerator_Instruction$generate(byte[] bytecode) throws IllegalInstructionException {
            if (this.mOpcode == Opcodes.LABEL.value) {
                return;
            }
            int writingOffset = this.offset;
            bytecode[writingOffset++] = this.generateInstructionByte();
            if (this.mTargetLabel != null) {
                writingOffset = this.writeValue(this.calculateTargetLabelOffset(), bytecode, writingOffset);
            }
            if (this.mHasImm) {
                writingOffset = this.writeValue(this.mImm, bytecode, writingOffset);
            }
            if (this.mCompareBytes != null) {
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])this.mCompareBytes, (int)0, (byte[])bytecode, (int)writingOffset, (int)this.mCompareBytes.length);
                writingOffset += this.mCompareBytes.length;
            }
            if (writingOffset - this.offset != this.size()) {
                throw new IllegalStateException("wrote " + (writingOffset - this.offset) + " but should have written " + this.size());
            }
        }

        private final byte $$robo$$android_net_apf_ApfGenerator_Instruction$generatedImmSize() {
            return this.mImmSize > this.mTargetLabelSize ? this.mImmSize : this.mTargetLabelSize;
        }

        private final int $$robo$$android_net_apf_ApfGenerator_Instruction$calculateTargetLabelOffset() throws IllegalInstructionException {
            Instruction targetLabelInstruction = this.mTargetLabel == "__DROP__" ? this.this$0.mDropLabel : (this.mTargetLabel == "__PASS__" ? this.this$0.mPassLabel : (Instruction)this.this$0.mLabels.get(this.mTargetLabel));
            if (targetLabelInstruction == null) {
                throw new IllegalInstructionException("label not found: " + this.mTargetLabel);
            }
            int targetLabelOffset = targetLabelInstruction.offset - (this.offset + this.size());
            if (targetLabelOffset < 0) {
                throw new IllegalInstructionException("backward branches disallowed; label: " + this.mTargetLabel);
            }
            return targetLabelOffset;
        }

        private final byte $$robo$$android_net_apf_ApfGenerator_Instruction$calculateImmSize(int imm, boolean signed) {
            if (imm == 0) {
                return 0;
            }
            if (signed && imm >= -128 && imm <= 127 || !signed && imm >= 0 && imm <= 255) {
                return 1;
            }
            if (signed && imm >= Short.MIN_VALUE && imm <= Short.MAX_VALUE || !signed && imm >= 0 && imm <= 65535) {
                return 2;
            }
            return 4;
        }

        private void __constructor__(ApfGenerator apfGenerator, Opcodes opcodes, Register register) {
            this.$$robo$$android_net_apf_ApfGenerator_Instruction$__constructor__(apfGenerator, opcodes, register);
        }

        Instruction(ApfGenerator apfGenerator, Opcodes opcodes, Register register) {
            this.this$0 = apfGenerator;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_apf_ApfGenerator_Instruction$__constructor__(android.net.apf.ApfGenerator android.net.apf.ApfGenerator$Opcodes android.net.apf.ApfGenerator$Register ), 0, this, apfGenerator, opcodes, register);
        }

        private void __constructor__(ApfGenerator apfGenerator, Opcodes opcodes) {
            this.$$robo$$android_net_apf_ApfGenerator_Instruction$__constructor__(apfGenerator, opcodes);
        }

        Instruction(ApfGenerator apfGenerator, Opcodes opcodes) {
            this(apfGenerator, opcodes, Register.R0);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_apf_ApfGenerator_Instruction$__constructor__(android.net.apf.ApfGenerator android.net.apf.ApfGenerator$Opcodes ), 0, this, apfGenerator, opcodes);
        }

        void setImm(int n, boolean bl) {
            InvokeDynamicSupport.bootstrap("setImm", $$robo$$android_net_apf_ApfGenerator_Instruction$setImm(int boolean ), 0, this, n, bl);
        }

        void setUnsignedImm(int n) {
            InvokeDynamicSupport.bootstrap("setUnsignedImm", $$robo$$android_net_apf_ApfGenerator_Instruction$setUnsignedImm(int ), 0, this, n);
        }

        void setSignedImm(int n) {
            InvokeDynamicSupport.bootstrap("setSignedImm", $$robo$$android_net_apf_ApfGenerator_Instruction$setSignedImm(int ), 0, this, n);
        }

        void setLabel(String string2) throws IllegalInstructionException {
            InvokeDynamicSupport.bootstrap("setLabel", $$robo$$android_net_apf_ApfGenerator_Instruction$setLabel(java.lang.String ), 0, this, string2);
        }

        void setTargetLabel(String string2) {
            InvokeDynamicSupport.bootstrap("setTargetLabel", $$robo$$android_net_apf_ApfGenerator_Instruction$setTargetLabel(java.lang.String ), 0, this, string2);
        }

        void setCompareBytes(byte[] byArray) {
            InvokeDynamicSupport.bootstrap("setCompareBytes", $$robo$$android_net_apf_ApfGenerator_Instruction$setCompareBytes(byte[] ), 0, this, byArray);
        }

        int size() {
            return (int)InvokeDynamicSupport.bootstrap("size", $$robo$$android_net_apf_ApfGenerator_Instruction$size(), 0, this);
        }

        boolean shrink() throws IllegalInstructionException {
            return (boolean)InvokeDynamicSupport.bootstrap("shrink", $$robo$$android_net_apf_ApfGenerator_Instruction$shrink(), 0, this);
        }

        private byte generateImmSizeField() {
            return (byte)InvokeDynamicSupport.bootstrap("generateImmSizeField", $$robo$$android_net_apf_ApfGenerator_Instruction$generateImmSizeField(), 0, this);
        }

        private byte generateInstructionByte() {
            return (byte)InvokeDynamicSupport.bootstrap("generateInstructionByte", $$robo$$android_net_apf_ApfGenerator_Instruction$generateInstructionByte(), 0, this);
        }

        private int writeValue(int n, byte[] byArray, int n2) {
            return (int)InvokeDynamicSupport.bootstrap("writeValue", $$robo$$android_net_apf_ApfGenerator_Instruction$writeValue(int byte[] int ), 0, this, n, byArray, n2);
        }

        void generate(byte[] byArray) throws IllegalInstructionException {
            InvokeDynamicSupport.bootstrap("generate", $$robo$$android_net_apf_ApfGenerator_Instruction$generate(byte[] ), 0, this, byArray);
        }

        private byte generatedImmSize() {
            return (byte)InvokeDynamicSupport.bootstrap("generatedImmSize", $$robo$$android_net_apf_ApfGenerator_Instruction$generatedImmSize(), 0, this);
        }

        private int calculateTargetLabelOffset() throws IllegalInstructionException {
            return (int)InvokeDynamicSupport.bootstrap("calculateTargetLabelOffset", $$robo$$android_net_apf_ApfGenerator_Instruction$calculateTargetLabelOffset(), 0, this);
        }

        private byte calculateImmSize(int n, boolean bl) {
            return (byte)InvokeDynamicSupport.bootstrap("calculateImmSize", $$robo$$android_net_apf_ApfGenerator_Instruction$calculateImmSize(int boolean ), 0, this, n, bl);
        }

        public /* synthetic */ Instruction() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Instruction)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Register
    extends Enum<Register> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ Register R0;
        public static /* enum */ Register R1;
        int value;
        private static /* synthetic */ Register[] $VALUES;

        private static final Register[] $$robo$$android_net_apf_ApfGenerator_Register$values() {
            return (Register[])$VALUES.clone();
        }

        private static final Register $$robo$$android_net_apf_ApfGenerator_Register$valueOf(String name) {
            return Enum.valueOf(Register.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_net_apf_ApfGenerator_Register$__constructor__(String string2, int n, int value) {
            this.value = value;
        }

        static void __staticInitializer__() {
            R0 = new Register(0);
            R1 = new Register(1);
            $VALUES = new Register[]{R0, R1};
        }

        public static Register[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_net_apf_ApfGenerator_Register$values(), 0);
        }

        public static Register valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_net_apf_ApfGenerator_Register$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n, int n2) {
            this.$$robo$$android_net_apf_ApfGenerator_Register$__constructor__(string2, n, n2);
        }

        private Register(int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_apf_ApfGenerator_Register$__constructor__(java.lang.String int int ), 0, this, string2, n, n2);
        }

        static {
            RobolectricInternals.classInitializing(Register.class);
        }

        public /* synthetic */ Register() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Register)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class ExtendedOpcodes
    extends Enum<ExtendedOpcodes> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ ExtendedOpcodes LDM;
        public static /* enum */ ExtendedOpcodes STM;
        public static /* enum */ ExtendedOpcodes NOT;
        public static /* enum */ ExtendedOpcodes NEG;
        public static /* enum */ ExtendedOpcodes SWAP;
        public static /* enum */ ExtendedOpcodes MOVE;
        int value;
        private static /* synthetic */ ExtendedOpcodes[] $VALUES;

        private static final ExtendedOpcodes[] $$robo$$android_net_apf_ApfGenerator_ExtendedOpcodes$values() {
            return (ExtendedOpcodes[])$VALUES.clone();
        }

        private static final ExtendedOpcodes $$robo$$android_net_apf_ApfGenerator_ExtendedOpcodes$valueOf(String name) {
            return Enum.valueOf(ExtendedOpcodes.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_net_apf_ApfGenerator_ExtendedOpcodes$__constructor__(String string2, int n, int value) {
            this.value = value;
        }

        static void __staticInitializer__() {
            LDM = new ExtendedOpcodes(0);
            STM = new ExtendedOpcodes(16);
            NOT = new ExtendedOpcodes(32);
            NEG = new ExtendedOpcodes(33);
            SWAP = new ExtendedOpcodes(34);
            MOVE = new ExtendedOpcodes(35);
            $VALUES = new ExtendedOpcodes[]{LDM, STM, NOT, NEG, SWAP, MOVE};
        }

        public static ExtendedOpcodes[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_net_apf_ApfGenerator_ExtendedOpcodes$values(), 0);
        }

        public static ExtendedOpcodes valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_net_apf_ApfGenerator_ExtendedOpcodes$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n, int n2) {
            this.$$robo$$android_net_apf_ApfGenerator_ExtendedOpcodes$__constructor__(string2, n, n2);
        }

        private ExtendedOpcodes(int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_apf_ApfGenerator_ExtendedOpcodes$__constructor__(java.lang.String int int ), 0, this, string2, n, n2);
        }

        static {
            RobolectricInternals.classInitializing(ExtendedOpcodes.class);
        }

        public /* synthetic */ ExtendedOpcodes() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ExtendedOpcodes)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class Opcodes
    extends Enum<Opcodes> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ Opcodes LABEL;
        public static /* enum */ Opcodes LDB;
        public static /* enum */ Opcodes LDH;
        public static /* enum */ Opcodes LDW;
        public static /* enum */ Opcodes LDBX;
        public static /* enum */ Opcodes LDHX;
        public static /* enum */ Opcodes LDWX;
        public static /* enum */ Opcodes ADD;
        public static /* enum */ Opcodes MUL;
        public static /* enum */ Opcodes DIV;
        public static /* enum */ Opcodes AND;
        public static /* enum */ Opcodes OR;
        public static /* enum */ Opcodes SH;
        public static /* enum */ Opcodes LI;
        public static /* enum */ Opcodes JMP;
        public static /* enum */ Opcodes JEQ;
        public static /* enum */ Opcodes JNE;
        public static /* enum */ Opcodes JGT;
        public static /* enum */ Opcodes JLT;
        public static /* enum */ Opcodes JSET;
        public static /* enum */ Opcodes JNEBS;
        public static /* enum */ Opcodes EXT;
        int value;
        private static /* synthetic */ Opcodes[] $VALUES;

        private static final Opcodes[] $$robo$$android_net_apf_ApfGenerator_Opcodes$values() {
            return (Opcodes[])$VALUES.clone();
        }

        private static final Opcodes $$robo$$android_net_apf_ApfGenerator_Opcodes$valueOf(String name) {
            return Enum.valueOf(Opcodes.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_net_apf_ApfGenerator_Opcodes$__constructor__(String string2, int n, int value) {
            this.value = value;
        }

        static void __staticInitializer__() {
            LABEL = new Opcodes(-1);
            LDB = new Opcodes(1);
            LDH = new Opcodes(2);
            LDW = new Opcodes(3);
            LDBX = new Opcodes(4);
            LDHX = new Opcodes(5);
            LDWX = new Opcodes(6);
            ADD = new Opcodes(7);
            MUL = new Opcodes(8);
            DIV = new Opcodes(9);
            AND = new Opcodes(10);
            OR = new Opcodes(11);
            SH = new Opcodes(12);
            LI = new Opcodes(13);
            JMP = new Opcodes(14);
            JEQ = new Opcodes(15);
            JNE = new Opcodes(16);
            JGT = new Opcodes(17);
            JLT = new Opcodes(18);
            JSET = new Opcodes(19);
            JNEBS = new Opcodes(20);
            EXT = new Opcodes(21);
            $VALUES = new Opcodes[]{LABEL, LDB, LDH, LDW, LDBX, LDHX, LDWX, ADD, MUL, DIV, AND, OR, SH, LI, JMP, JEQ, JNE, JGT, JLT, JSET, JNEBS, EXT};
        }

        public static Opcodes[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_net_apf_ApfGenerator_Opcodes$values(), 0);
        }

        public static Opcodes valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_net_apf_ApfGenerator_Opcodes$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n, int n2) {
            this.$$robo$$android_net_apf_ApfGenerator_Opcodes$__constructor__(string2, n, n2);
        }

        private Opcodes(int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_apf_ApfGenerator_Opcodes$__constructor__(java.lang.String int int ), 0, this, string2, n, n2);
        }

        static {
            RobolectricInternals.classInitializing(Opcodes.class);
        }

        public /* synthetic */ Opcodes() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Opcodes)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class IllegalInstructionException
    extends Exception
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_net_apf_ApfGenerator_IllegalInstructionException$__constructor__(String msg) {
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_net_apf_ApfGenerator_IllegalInstructionException$__constructor__(string2);
        }

        IllegalInstructionException(String string2) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_apf_ApfGenerator_IllegalInstructionException$__constructor__(java.lang.String ), 0, this, string2);
        }

        public /* synthetic */ IllegalInstructionException() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IllegalInstructionException)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

