/*
 * Decompiled with CFR 0.152.
 */
package android.net.apf;

import android.net.LinkProperties;
import android.net.NetworkUtils;
import android.net.apf.ApfCapabilities;
import android.net.apf.ApfGenerator;
import android.net.ip.IpManager;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.PacketSocketAddress;
import android.util.Log;
import android.util.Pair;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.HexDump;
import com.android.internal.util.IndentingPrintWriter;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import libcore.io.IoBridge;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ApfFilter
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "ApfFilter";
    private static boolean DBG = true;
    private static boolean VDBG = false;
    private static int ETH_HEADER_LEN = 14;
    private static int ETH_DEST_ADDR_OFFSET = 0;
    private static int ETH_ETHERTYPE_OFFSET = 12;
    private static byte[] ETH_BROADCAST_MAC_ADDRESS;
    private static int IPV4_FRAGMENT_OFFSET_OFFSET = 20;
    private static int IPV4_FRAGMENT_OFFSET_MASK = 8191;
    private static int IPV4_PROTOCOL_OFFSET = 23;
    private static int IPV4_DEST_ADDR_OFFSET = 30;
    private static int IPV6_NEXT_HEADER_OFFSET = 20;
    private static int IPV6_SRC_ADDR_OFFSET = 22;
    private static int IPV6_DEST_ADDR_OFFSET = 38;
    private static int IPV6_HEADER_LEN = 40;
    private static byte[] IPV6_ALL_NODES_ADDRESS;
    private static int ICMP6_TYPE_OFFSET = 54;
    private static int ICMP6_NEIGHBOR_ANNOUNCEMENT = 136;
    private static int UDP_DESTINATION_PORT_OFFSET = 16;
    private static int UDP_HEADER_LEN = 8;
    private static int DHCP_CLIENT_PORT = 68;
    private static int DHCP_CLIENT_MAC_OFFSET = 50;
    private static int ARP_HEADER_OFFSET;
    private static byte[] ARP_IPV4_REQUEST_HEADER;
    private static int ARP_TARGET_IP_ADDRESS_OFFSET;
    private ApfCapabilities mApfCapabilities;
    private IpManager.Callback mIpManagerCallback;
    private NetworkInterface mNetworkInterface;
    byte[] mHardwareAddress;
    ReceiveThread mReceiveThread;
    @GuardedBy(value="this")
    private long mUniqueCounter;
    @GuardedBy(value="this")
    private boolean mMulticastFilter;
    @GuardedBy(value="this")
    private byte[] mIPv4Address;
    private static int MAX_RAS = 10;
    @GuardedBy(value="this")
    private ArrayList<Ra> mRas;
    private static long MAX_PROGRAM_LIFETIME_WORTH_REFRESHING = 30L;
    private static int FRACTION_OF_LIFETIME_TO_FILTER = 6;
    @GuardedBy(value="this")
    private long mLastTimeInstalledProgram;
    @GuardedBy(value="this")
    private long mLastInstalledProgramMinLifetime;
    @GuardedBy(value="this")
    private byte[] mLastInstalledProgram;
    @GuardedBy(value="this")
    private int mNumProgramUpdates;

    private void $$robo$$android_net_apf_ApfFilter$__constructor__(ApfCapabilities apfCapabilities, NetworkInterface networkInterface, IpManager.Callback ipManagerCallback, boolean multicastFilter) {
        this.mRas = new ArrayList();
        this.mApfCapabilities = apfCapabilities;
        this.mIpManagerCallback = ipManagerCallback;
        this.mNetworkInterface = networkInterface;
        this.mMulticastFilter = multicastFilter;
        this.maybeStartFilter();
    }

    private final void $$robo$$android_net_apf_ApfFilter$log(String s) {
        Log.d("ApfFilter", "(" + this.mNetworkInterface.getName() + "): " + s);
    }

    @GuardedBy(value="this")
    private final long $$robo$$android_net_apf_ApfFilter$getUniqueNumberLocked() {
        return this.mUniqueCounter++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_apf_ApfFilter$maybeStartFilter() {
        FileDescriptor socket;
        try {
            this.mHardwareAddress = this.mNetworkInterface.getHardwareAddress();
            ApfFilter apfFilter = this;
            synchronized (apfFilter) {
                this.installNewProgramLocked();
            }
            socket = Os.socket(OsConstants.AF_PACKET, OsConstants.SOCK_RAW, OsConstants.ETH_P_IPV6);
            PacketSocketAddress addr = new PacketSocketAddress((short)OsConstants.ETH_P_IPV6, this.mNetworkInterface.getIndex());
            Os.bind(socket, addr);
            NetworkUtils.attachRaFilter(socket, this.mApfCapabilities.apfPacketFormat);
        }
        catch (ErrnoException | SocketException e) {
            Log.e("ApfFilter", "Error starting filter", e);
            return;
        }
        this.mReceiveThread = new ReceiveThread(this, socket);
        this.mReceiveThread.start();
    }

    private static final long $$robo$$android_net_apf_ApfFilter$curTime() {
        return (long)(InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System") / 1000L);
    }

    @GuardedBy(value="this")
    private final void $$robo$$android_net_apf_ApfFilter$generateArpFilterLocked(ApfGenerator gen) throws ApfGenerator.IllegalInstructionException {
        if (this.mIPv4Address != null) {
            gen.addLoadImmediate(ApfGenerator.Register.R0, ARP_HEADER_OFFSET);
            gen.addJumpIfBytesNotEqual(ApfGenerator.Register.R0, ARP_IPV4_REQUEST_HEADER, "__PASS__");
            gen.addLoadImmediate(ApfGenerator.Register.R0, ARP_TARGET_IP_ADDRESS_OFFSET);
            gen.addJumpIfBytesNotEqual(ApfGenerator.Register.R0, this.mIPv4Address, "__DROP__");
        }
        gen.addJump("__PASS__");
    }

    @GuardedBy(value="this")
    private final void $$robo$$android_net_apf_ApfFilter$generateIPv4FilterLocked(ApfGenerator gen) throws ApfGenerator.IllegalInstructionException {
        if (this.mMulticastFilter) {
            gen.addLoad8(ApfGenerator.Register.R0, 30);
            gen.addAnd(240);
            gen.addJumpIfR0Equals(224, "__DROP__");
            gen.addLoadImmediate(ApfGenerator.Register.R0, 0);
            gen.addJumpIfBytesNotEqual(ApfGenerator.Register.R0, ETH_BROADCAST_MAC_ADDRESS, "__PASS__");
            gen.addLoad8(ApfGenerator.Register.R0, 23);
            gen.addJumpIfR0NotEquals(OsConstants.IPPROTO_UDP, "__DROP__");
            gen.addLoad16(ApfGenerator.Register.R0, 20);
            gen.addJumpIfR0AnyBitsSet(8191, "__DROP__");
            gen.addLoadFromMemory(ApfGenerator.Register.R1, 13);
            gen.addLoad16Indexed(ApfGenerator.Register.R0, 16);
            gen.addJumpIfR0NotEquals(68, "__DROP__");
            gen.addLoadImmediate(ApfGenerator.Register.R0, 50);
            gen.addAddR1();
            gen.addJumpIfBytesNotEqual(ApfGenerator.Register.R0, this.mHardwareAddress, "__DROP__");
        }
        gen.addJump("__PASS__");
    }

    @GuardedBy(value="this")
    private final void $$robo$$android_net_apf_ApfFilter$generateIPv6FilterLocked(ApfGenerator gen) throws ApfGenerator.IllegalInstructionException {
        gen.addLoad8(ApfGenerator.Register.R0, 20);
        if (this.mMulticastFilter) {
            String skipIpv6MulticastFilterLabel = "skipIPv6MulticastFilter";
            gen.addJumpIfR0Equals(OsConstants.IPPROTO_ICMPV6, skipIpv6MulticastFilterLabel);
            gen.addLoad8(ApfGenerator.Register.R0, 38);
            gen.addJumpIfR0Equals(255, "__DROP__");
            gen.addJump("__PASS__");
            gen.defineLabel(skipIpv6MulticastFilterLabel);
        } else {
            gen.addJumpIfR0NotEquals(OsConstants.IPPROTO_ICMPV6, "__PASS__");
        }
        String skipUnsolicitedMulticastNALabel = "skipUnsolicitedMulticastNA";
        gen.addLoad8(ApfGenerator.Register.R0, 54);
        gen.addJumpIfR0NotEquals(136, skipUnsolicitedMulticastNALabel);
        gen.addLoadImmediate(ApfGenerator.Register.R0, 38);
        gen.addJumpIfBytesNotEqual(ApfGenerator.Register.R0, IPV6_ALL_NODES_ADDRESS, skipUnsolicitedMulticastNALabel);
        gen.addJump("__DROP__");
        gen.defineLabel(skipUnsolicitedMulticastNALabel);
    }

    @GuardedBy(value="this")
    private final ApfGenerator $$robo$$android_net_apf_ApfFilter$beginProgramLocked() throws ApfGenerator.IllegalInstructionException {
        ApfGenerator gen = new ApfGenerator();
        gen.setApfVersion(this.mApfCapabilities.apfVersionSupported);
        String skipArpFiltersLabel = "skipArpFilters";
        gen.addLoad16(ApfGenerator.Register.R0, 12);
        gen.addJumpIfR0NotEquals(OsConstants.ETH_P_ARP, skipArpFiltersLabel);
        this.generateArpFilterLocked(gen);
        gen.defineLabel(skipArpFiltersLabel);
        String skipIPv4FiltersLabel = "skipIPv4Filters";
        gen.addJumpIfR0NotEquals(OsConstants.ETH_P_IP, skipIPv4FiltersLabel);
        this.generateIPv4FilterLocked(gen);
        gen.defineLabel(skipIPv4FiltersLabel);
        String ipv6FilterLabel = "IPv6Filters";
        gen.addJumpIfR0Equals(OsConstants.ETH_P_IPV6, ipv6FilterLabel);
        gen.addLoadImmediate(ApfGenerator.Register.R0, 0);
        gen.addJumpIfBytesNotEqual(ApfGenerator.Register.R0, ETH_BROADCAST_MAC_ADDRESS, "__PASS__");
        gen.addJump("__DROP__");
        gen.defineLabel(ipv6FilterLabel);
        this.generateIPv6FilterLocked(gen);
        return gen;
    }

    @GuardedBy(value="this")
    private final void $$robo$$android_net_apf_ApfFilter$installNewProgramLocked() {
        byte[] program;
        this.purgeExpiredRasLocked();
        long programMinLifetime = Long.MAX_VALUE;
        try {
            ApfGenerator gen = this.beginProgramLocked();
            ArrayList<Ra> rasToFilter = new ArrayList<Ra>();
            for (Ra ra : this.mRas) {
                ra.generateFilterLocked(gen);
                if (gen.programLengthOverEstimate() > this.mApfCapabilities.maximumApfProgramSize) break;
                rasToFilter.add(ra);
            }
            gen = this.beginProgramLocked();
            for (Ra ra : rasToFilter) {
                programMinLifetime = Math.min(programMinLifetime, ra.generateFilterLocked(gen));
            }
            program = gen.generate();
        }
        catch (ApfGenerator.IllegalInstructionException e) {
            Log.e("ApfFilter", "Program failed to generate: ", e);
            return;
        }
        this.mLastTimeInstalledProgram = ApfFilter.curTime();
        this.mLastInstalledProgramMinLifetime = programMinLifetime;
        this.mLastInstalledProgram = program;
        ++this.mNumProgramUpdates;
        this.mIpManagerCallback.installPacketFilter(program);
    }

    @GuardedBy(value="this")
    private final void $$robo$$android_net_apf_ApfFilter$maybeInstallNewProgramLocked() {
        if (this.mRas.size() == 0) {
            return;
        }
        long expiry = this.mLastTimeInstalledProgram + this.mLastInstalledProgramMinLifetime;
        if (expiry < ApfFilter.curTime() + 30L) {
            this.installNewProgramLocked();
        }
    }

    private final void $$robo$$android_net_apf_ApfFilter$hexDump(String msg, byte[] packet, int length) {
        this.log(msg + HexDump.toHexString(packet, 0, length, false));
    }

    @GuardedBy(value="this")
    private final void $$robo$$android_net_apf_ApfFilter$purgeExpiredRasLocked() {
        int i = 0;
        while (i < this.mRas.size()) {
            if (this.mRas.get(i).isExpired()) {
                this.log("Expiring " + this.mRas.get(i));
                this.mRas.remove(i);
                continue;
            }
            ++i;
        }
    }

    private final synchronized void $$robo$$android_net_apf_ApfFilter$processRa(byte[] packet, int length) {
        Ra ra;
        for (int i = 0; i < this.mRas.size(); ++i) {
            Ra ra2 = this.mRas.get(i);
            if (!ra2.matches(packet, length)) continue;
            ra2.mLastSeen = ApfFilter.curTime();
            ra2.mMinLifetime = ra2.minLifetime(packet, length);
            ++ra2.seenCount;
            this.mRas.add(0, this.mRas.remove(i));
            this.maybeInstallNewProgramLocked();
            return;
        }
        this.purgeExpiredRasLocked();
        if (this.mRas.size() >= 10) {
            return;
        }
        try {
            ra = new Ra(this, packet, length);
        }
        catch (Exception e) {
            Log.e("ApfFilter", "Error parsing RA: " + e);
            return;
        }
        if (ra.isExpired()) {
            return;
        }
        this.log("Adding " + ra);
        this.mRas.add(ra);
        this.installNewProgramLocked();
    }

    private static final ApfFilter $$robo$$android_net_apf_ApfFilter$maybeCreate(ApfCapabilities apfCapabilities, NetworkInterface networkInterface, IpManager.Callback ipManagerCallback, boolean multicastFilter) {
        if (apfCapabilities == null || networkInterface == null) {
            return null;
        }
        if (apfCapabilities.apfVersionSupported == 0) {
            return null;
        }
        if (apfCapabilities.maximumApfProgramSize < 512) {
            Log.e("ApfFilter", "Unacceptably small APF limit: " + apfCapabilities.maximumApfProgramSize);
            return null;
        }
        if (apfCapabilities.apfPacketFormat != OsConstants.ARPHRD_ETHER) {
            return null;
        }
        if (!new ApfGenerator().setApfVersion(apfCapabilities.apfVersionSupported)) {
            Log.e("ApfFilter", "Unsupported APF version: " + apfCapabilities.apfVersionSupported);
            return null;
        }
        return new ApfFilter(apfCapabilities, networkInterface, ipManagerCallback, multicastFilter);
    }

    private final synchronized void $$robo$$android_net_apf_ApfFilter$shutdown() {
        if (this.mReceiveThread != null) {
            this.log("shutting down");
            this.mReceiveThread.halt();
            this.mReceiveThread = null;
        }
        this.mRas.clear();
    }

    private final synchronized void $$robo$$android_net_apf_ApfFilter$setMulticastFilter(boolean enabled) {
        if (this.mMulticastFilter != enabled) {
            this.mMulticastFilter = enabled;
            this.installNewProgramLocked();
        }
    }

    private static final byte[] $$robo$$android_net_apf_ApfFilter$findIPv4Address(LinkProperties lp) {
        byte[] ipv4Address = null;
        for (InetAddress inetAddr : lp.getAddresses()) {
            byte[] addr = inetAddr.getAddress();
            if (addr.length != 4) continue;
            if (ipv4Address != null && !Arrays.equals(ipv4Address, addr)) {
                return null;
            }
            ipv4Address = addr;
        }
        return ipv4Address;
    }

    private final synchronized void $$robo$$android_net_apf_ApfFilter$setLinkProperties(LinkProperties lp) {
        byte[] ipv4Address = ApfFilter.findIPv4Address(lp);
        if (Arrays.equals(ipv4Address, this.mIPv4Address)) {
            return;
        }
        this.mIPv4Address = ipv4Address;
        this.installNewProgramLocked();
    }

    private final synchronized void $$robo$$android_net_apf_ApfFilter$dump(IndentingPrintWriter pw) {
        pw.println("Capabilities: " + this.mApfCapabilities);
        pw.println("Receive thread: " + (this.mReceiveThread != null ? "RUNNING" : "STOPPED"));
        pw.println("Multicast: " + (this.mMulticastFilter ? "DROP" : "ALLOW"));
        try {
            pw.println("IPv4 address: " + InetAddress.getByAddress(this.mIPv4Address).getHostAddress());
        }
        catch (NullPointerException | UnknownHostException exception) {
            // empty catch block
        }
        if (this.mLastTimeInstalledProgram == 0L) {
            pw.println("No program installed.");
            return;
        }
        pw.println("Program updates: " + this.mNumProgramUpdates);
        pw.println(String.format("Last program length %d, installed %ds ago, lifetime %ds", this.mLastInstalledProgram.length, ApfFilter.curTime() - this.mLastTimeInstalledProgram, this.mLastInstalledProgramMinLifetime));
        pw.println("RA filters:");
        pw.increaseIndent();
        for (Ra ra : this.mRas) {
            pw.println(ra);
            pw.increaseIndent();
            pw.println(String.format("Seen: %d, last %ds ago", ra.seenCount, ApfFilter.curTime() - ra.mLastSeen));
            pw.println("Last match:");
            pw.increaseIndent();
            pw.println(ra.getLastMatchingPacket());
            pw.decreaseIndent();
            pw.decreaseIndent();
        }
        pw.decreaseIndent();
        pw.println("Last program:");
        pw.increaseIndent();
        pw.println(HexDump.toHexString(this.mLastInstalledProgram, false));
        pw.decreaseIndent();
    }

    static void __staticInitializer__() {
        ETH_BROADCAST_MAC_ADDRESS = new byte[]{-1, -1, -1, -1, -1, -1};
        IPV6_ALL_NODES_ADDRESS = new byte[]{-1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
        ARP_HEADER_OFFSET = 14;
        ARP_IPV4_REQUEST_HEADER = new byte[]{0, 1, 8, 0, 6, 4, 0, 1};
        ARP_TARGET_IP_ADDRESS_OFFSET = 38;
    }

    private void __constructor__(ApfCapabilities apfCapabilities, NetworkInterface networkInterface, IpManager.Callback callback, boolean bl) {
        this.$$robo$$android_net_apf_ApfFilter$__constructor__(apfCapabilities, networkInterface, callback, bl);
    }

    ApfFilter(ApfCapabilities apfCapabilities, NetworkInterface networkInterface, IpManager.Callback callback, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_apf_ApfFilter$__constructor__(android.net.apf.ApfCapabilities java.net.NetworkInterface android.net.ip.IpManager$Callback boolean ), 0, this, apfCapabilities, networkInterface, callback, bl);
    }

    private void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$android_net_apf_ApfFilter$log(java.lang.String ), 0, this, string2);
    }

    private long getUniqueNumberLocked() {
        return (long)InvokeDynamicSupport.bootstrap("getUniqueNumberLocked", $$robo$$android_net_apf_ApfFilter$getUniqueNumberLocked(), 0, this);
    }

    void maybeStartFilter() {
        InvokeDynamicSupport.bootstrap("maybeStartFilter", $$robo$$android_net_apf_ApfFilter$maybeStartFilter(), 0, this);
    }

    private static long curTime() {
        return (long)InvokeDynamicSupport.bootstrapStatic("curTime", $$robo$$android_net_apf_ApfFilter$curTime(), 0);
    }

    private void generateArpFilterLocked(ApfGenerator apfGenerator) throws ApfGenerator.IllegalInstructionException {
        InvokeDynamicSupport.bootstrap("generateArpFilterLocked", $$robo$$android_net_apf_ApfFilter$generateArpFilterLocked(android.net.apf.ApfGenerator ), 0, this, apfGenerator);
    }

    private void generateIPv4FilterLocked(ApfGenerator apfGenerator) throws ApfGenerator.IllegalInstructionException {
        InvokeDynamicSupport.bootstrap("generateIPv4FilterLocked", $$robo$$android_net_apf_ApfFilter$generateIPv4FilterLocked(android.net.apf.ApfGenerator ), 0, this, apfGenerator);
    }

    private void generateIPv6FilterLocked(ApfGenerator apfGenerator) throws ApfGenerator.IllegalInstructionException {
        InvokeDynamicSupport.bootstrap("generateIPv6FilterLocked", $$robo$$android_net_apf_ApfFilter$generateIPv6FilterLocked(android.net.apf.ApfGenerator ), 0, this, apfGenerator);
    }

    private ApfGenerator beginProgramLocked() throws ApfGenerator.IllegalInstructionException {
        return InvokeDynamicSupport.bootstrap("beginProgramLocked", $$robo$$android_net_apf_ApfFilter$beginProgramLocked(), 0, this);
    }

    void installNewProgramLocked() {
        InvokeDynamicSupport.bootstrap("installNewProgramLocked", $$robo$$android_net_apf_ApfFilter$installNewProgramLocked(), 0, this);
    }

    private void maybeInstallNewProgramLocked() {
        InvokeDynamicSupport.bootstrap("maybeInstallNewProgramLocked", $$robo$$android_net_apf_ApfFilter$maybeInstallNewProgramLocked(), 0, this);
    }

    private void hexDump(String string2, byte[] byArray, int n) {
        InvokeDynamicSupport.bootstrap("hexDump", $$robo$$android_net_apf_ApfFilter$hexDump(java.lang.String byte[] int ), 0, this, string2, byArray, n);
    }

    private void purgeExpiredRasLocked() {
        InvokeDynamicSupport.bootstrap("purgeExpiredRasLocked", $$robo$$android_net_apf_ApfFilter$purgeExpiredRasLocked(), 0, this);
    }

    private synchronized void processRa(byte[] byArray, int n) {
        InvokeDynamicSupport.bootstrap("processRa", $$robo$$android_net_apf_ApfFilter$processRa(byte[] int ), 0, this, byArray, n);
    }

    public static ApfFilter maybeCreate(ApfCapabilities apfCapabilities, NetworkInterface networkInterface, IpManager.Callback callback, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("maybeCreate", $$robo$$android_net_apf_ApfFilter$maybeCreate(android.net.apf.ApfCapabilities java.net.NetworkInterface android.net.ip.IpManager$Callback boolean ), 0, (ApfCapabilities)apfCapabilities, (NetworkInterface)networkInterface, (IpManager.Callback)callback, (boolean)bl);
    }

    public synchronized void shutdown() {
        InvokeDynamicSupport.bootstrap("shutdown", $$robo$$android_net_apf_ApfFilter$shutdown(), 0, this);
    }

    public synchronized void setMulticastFilter(boolean bl) {
        InvokeDynamicSupport.bootstrap("setMulticastFilter", $$robo$$android_net_apf_ApfFilter$setMulticastFilter(boolean ), 0, this, bl);
    }

    private static byte[] findIPv4Address(LinkProperties linkProperties) {
        return InvokeDynamicSupport.bootstrapStatic("findIPv4Address", $$robo$$android_net_apf_ApfFilter$findIPv4Address(android.net.LinkProperties ), 0, (LinkProperties)linkProperties);
    }

    public synchronized void setLinkProperties(LinkProperties linkProperties) {
        InvokeDynamicSupport.bootstrap("setLinkProperties", $$robo$$android_net_apf_ApfFilter$setLinkProperties(android.net.LinkProperties ), 0, this, linkProperties);
    }

    public synchronized void dump(IndentingPrintWriter indentingPrintWriter) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_net_apf_ApfFilter$dump(com.android.internal.util.IndentingPrintWriter ), 0, this, indentingPrintWriter);
    }

    static {
        RobolectricInternals.classInitializing(ApfFilter.class);
    }

    public /* synthetic */ ApfFilter() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ApfFilter)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class Ra
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int ICMP6_RA_HEADER_LEN = 16;
        private static int ICMP6_RA_CHECKSUM_OFFSET = 56;
        private static int ICMP6_RA_CHECKSUM_LEN = 2;
        private static int ICMP6_RA_OPTION_OFFSET = 70;
        private static int ICMP6_RA_ROUTER_LIFETIME_OFFSET = 60;
        private static int ICMP6_RA_ROUTER_LIFETIME_LEN = 2;
        private static int ICMP6_PREFIX_OPTION_TYPE = 3;
        private static int ICMP6_PREFIX_OPTION_LEN = 32;
        private static int ICMP6_PREFIX_OPTION_VALID_LIFETIME_OFFSET = 4;
        private static int ICMP6_PREFIX_OPTION_VALID_LIFETIME_LEN = 4;
        private static int ICMP6_PREFIX_OPTION_PREFERRED_LIFETIME_OFFSET = 8;
        private static int ICMP6_PREFIX_OPTION_PREFERRED_LIFETIME_LEN = 4;
        private static int ICMP6_RDNSS_OPTION_TYPE = 25;
        private static int ICMP6_DNSSL_OPTION_TYPE = 31;
        private static int ICMP6_ROUTE_INFO_OPTION_TYPE = 24;
        private static int ICMP6_4_BYTE_LIFETIME_OFFSET = 4;
        private static int ICMP6_4_BYTE_LIFETIME_LEN = 4;
        private ByteBuffer mPacket;
        private ArrayList<Pair<Integer, Integer>> mNonLifetimes;
        long mMinLifetime;
        long mLastSeen;
        private ArrayList<Integer> mPrefixOptionOffsets;
        private ArrayList<Integer> mRdnssOptionOffsets;
        int seenCount;
        /* synthetic */ ApfFilter this$0;

        private final String $$robo$$android_net_apf_ApfFilter_Ra$getLastMatchingPacket() {
            return HexDump.toHexString(this.mPacket.array(), 0, this.mPacket.capacity(), false);
        }

        private final String $$robo$$android_net_apf_ApfFilter_Ra$IPv6AddresstoString(int pos) {
            try {
                byte[] array2 = this.mPacket.array();
                if (pos < 0 || pos + 16 > array2.length || pos + 16 < pos) {
                    return "???";
                }
                byte[] addressBytes = Arrays.copyOfRange(array2, pos, pos + 16);
                Inet6Address address = (Inet6Address)InetAddress.getByAddress(addressBytes);
                return ((InetAddress)address).getHostAddress();
            }
            catch (UnsupportedOperationException e) {
                return "???";
            }
            catch (ClassCastException | UnknownHostException e) {
                return "???";
            }
        }

        private final int $$robo$$android_net_apf_ApfFilter_Ra$uint8(byte b) {
            return b & 0xFF;
        }

        private final int $$robo$$android_net_apf_ApfFilter_Ra$uint16(short s) {
            return s & 0xFFFF;
        }

        private final long $$robo$$android_net_apf_ApfFilter_Ra$uint32(int s) {
            return s & 0xFFFFFFFF;
        }

        private final void $$robo$$android_net_apf_ApfFilter_Ra$prefixOptionToString(StringBuffer sb, int offset) {
            String prefix = this.IPv6AddresstoString(offset + 16);
            int length = this.uint8(this.mPacket.get(offset + 2));
            long valid = this.mPacket.getInt(offset + 4);
            long preferred = this.mPacket.getInt(offset + 8);
            sb.append(String.format("%s/%d %ds/%ds ", prefix, length, valid, preferred));
        }

        private final void $$robo$$android_net_apf_ApfFilter_Ra$rdnssOptionToString(StringBuffer sb, int offset) {
            int optLen = this.uint8(this.mPacket.get(offset + 1)) * 8;
            if (optLen < 24) {
                return;
            }
            long lifetime = this.uint32(this.mPacket.getInt(offset + 4));
            int numServers = (optLen - 8) / 16;
            sb.append("DNS ").append(lifetime).append("s");
            for (int server = 0; server < numServers; ++server) {
                sb.append(" ").append(this.IPv6AddresstoString(offset + 8 + 16 * server));
            }
        }

        private final String $$robo$$android_net_apf_ApfFilter_Ra$toString() {
            try {
                StringBuffer sb = new StringBuffer();
                sb.append(String.format("RA %s -> %s %ds ", this.IPv6AddresstoString(22), this.IPv6AddresstoString(38), this.uint16(this.mPacket.getShort(60))));
                for (int i : this.mPrefixOptionOffsets) {
                    this.prefixOptionToString(sb, i);
                }
                for (int i : this.mRdnssOptionOffsets) {
                    this.rdnssOptionToString(sb, i);
                }
                return sb.toString();
            }
            catch (IndexOutOfBoundsException | BufferUnderflowException e) {
                return "<Malformed RA>";
            }
        }

        private final int $$robo$$android_net_apf_ApfFilter_Ra$addNonLifetime(int lastNonLifetimeStart, int lifetimeOffset, int lifetimeLength) {
            this.mNonLifetimes.add(new Pair<Integer, Integer>(lastNonLifetimeStart, (lifetimeOffset += this.mPacket.position()) - lastNonLifetimeStart));
            return lifetimeOffset + lifetimeLength;
        }

        private void $$robo$$android_net_apf_ApfFilter_Ra$__constructor__(ApfFilter apfFilter, byte[] packet, int length) {
            this.mNonLifetimes = new ArrayList();
            this.mPrefixOptionOffsets = new ArrayList();
            this.mRdnssOptionOffsets = new ArrayList();
            this.seenCount = 0;
            this.mPacket = ByteBuffer.allocate(length).put(ByteBuffer.wrap(packet, 0, length));
            this.mPacket.clear();
            this.mLastSeen = ApfFilter.curTime();
            int lastNonLifetimeStart = this.addNonLifetime(0, 56, 2);
            lastNonLifetimeStart = this.addNonLifetime(lastNonLifetimeStart, 60, 2);
            this.mPacket.position(70);
            while (this.mPacket.hasRemaining()) {
                int optionType = this.mPacket.get(this.mPacket.position()) & 0xFF;
                int optionLength = (this.mPacket.get(this.mPacket.position() + 1) & 0xFF) * 8;
                switch (optionType) {
                    case 3: {
                        lastNonLifetimeStart = this.addNonLifetime(lastNonLifetimeStart, 4, 4);
                        lastNonLifetimeStart = this.addNonLifetime(lastNonLifetimeStart, 8, 4);
                        this.mPrefixOptionOffsets.add(this.mPacket.position());
                        break;
                    }
                    case 25: {
                        this.mRdnssOptionOffsets.add(this.mPacket.position());
                    }
                    case 24: 
                    case 31: {
                        lastNonLifetimeStart = this.addNonLifetime(lastNonLifetimeStart, 4, 4);
                        break;
                    }
                }
                if (optionLength <= 0) {
                    throw new IllegalArgumentException(String.format("Invalid option length opt=%d len=%d", optionType, optionLength));
                }
                this.mPacket.position(this.mPacket.position() + optionLength);
            }
            this.addNonLifetime(lastNonLifetimeStart, 0, 0);
            this.mMinLifetime = this.minLifetime(packet, length);
        }

        private final boolean $$robo$$android_net_apf_ApfFilter_Ra$matches(byte[] packet, int length) {
            if (length != this.mPacket.capacity()) {
                return false;
            }
            byte[] referencePacket = this.mPacket.array();
            for (Pair<Integer, Integer> nonLifetime : this.mNonLifetimes) {
                for (int i = ((Integer)nonLifetime.first).intValue(); i < (Integer)nonLifetime.first + (Integer)nonLifetime.second; ++i) {
                    if (packet[i] == referencePacket[i]) continue;
                    return false;
                }
            }
            return true;
        }

        private final long $$robo$$android_net_apf_ApfFilter_Ra$minLifetime(byte[] packet, int length) {
            long minLifetime = Long.MAX_VALUE;
            ByteBuffer byteBuffer = ByteBuffer.wrap(packet);
            int i = 0;
            while (i + 1 < this.mNonLifetimes.size()) {
                int offset = (Integer)this.mNonLifetimes.get((int)i).first + (Integer)this.mNonLifetimes.get((int)i).second;
                if (offset != 56) {
                    int lifetimeLength = (Integer)this.mNonLifetimes.get((int)(i + 1)).first - offset;
                    switch (lifetimeLength) {
                        case 2: {
                            long val = byteBuffer.getShort(offset);
                            break;
                        }
                        case 4: {
                            long val = byteBuffer.getInt(offset);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("bogus lifetime size " + length);
                        }
                    }
                    minLifetime = Math.min(minLifetime, val &= (1L << lifetimeLength * 8) - 1L);
                }
                ++i;
            }
            return minLifetime;
        }

        private final long $$robo$$android_net_apf_ApfFilter_Ra$currentLifetime() {
            return this.mMinLifetime - (ApfFilter.curTime() - this.mLastSeen);
        }

        private final boolean $$robo$$android_net_apf_ApfFilter_Ra$isExpired() {
            return this.currentLifetime() <= 0L;
        }

        @GuardedBy(value="ApfFilter.this")
        private final long $$robo$$android_net_apf_ApfFilter_Ra$generateFilterLocked(ApfGenerator gen) throws ApfGenerator.IllegalInstructionException {
            String nextFilterLabel = "Ra" + this.this$0.getUniqueNumberLocked();
            gen.addLoadFromMemory(ApfGenerator.Register.R0, 14);
            gen.addJumpIfR0NotEquals(this.mPacket.capacity(), nextFilterLabel);
            int filterLifetime = (int)(this.currentLifetime() / 6L);
            gen.addLoadFromMemory(ApfGenerator.Register.R0, 15);
            gen.addJumpIfR0GreaterThan(filterLifetime, nextFilterLabel);
            for (int i = 0; i < this.mNonLifetimes.size(); ++i) {
                Pair<Integer, Integer> nonLifetime = this.mNonLifetimes.get(i);
                if ((Integer)nonLifetime.second != 0) {
                    gen.addLoadImmediate(ApfGenerator.Register.R0, (Integer)nonLifetime.first);
                    gen.addJumpIfBytesNotEqual(ApfGenerator.Register.R0, Arrays.copyOfRange(this.mPacket.array(), (int)((Integer)nonLifetime.first), (Integer)nonLifetime.first + (Integer)nonLifetime.second), nextFilterLabel);
                }
                if (i + 1 >= this.mNonLifetimes.size()) continue;
                Pair<Integer, Integer> nextNonLifetime = this.mNonLifetimes.get(i + 1);
                int offset = (Integer)nonLifetime.first + (Integer)nonLifetime.second;
                if (offset == 56) continue;
                int length = (Integer)nextNonLifetime.first - offset;
                switch (length) {
                    case 4: {
                        gen.addLoad32(ApfGenerator.Register.R0, offset);
                        break;
                    }
                    case 2: {
                        gen.addLoad16(ApfGenerator.Register.R0, offset);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("bogus lifetime size " + length);
                    }
                }
                gen.addJumpIfR0LessThan(filterLifetime, nextFilterLabel);
            }
            gen.addJump("__DROP__");
            gen.defineLabel(nextFilterLabel);
            return filterLifetime;
        }

        String getLastMatchingPacket() {
            return InvokeDynamicSupport.bootstrap("getLastMatchingPacket", $$robo$$android_net_apf_ApfFilter_Ra$getLastMatchingPacket(), 0, this);
        }

        private String IPv6AddresstoString(int n) {
            return InvokeDynamicSupport.bootstrap("IPv6AddresstoString", $$robo$$android_net_apf_ApfFilter_Ra$IPv6AddresstoString(int ), 0, this, n);
        }

        private int uint8(byte by) {
            return (int)InvokeDynamicSupport.bootstrap("uint8", $$robo$$android_net_apf_ApfFilter_Ra$uint8(byte ), 0, this, by);
        }

        private int uint16(short s) {
            return (int)InvokeDynamicSupport.bootstrap("uint16", $$robo$$android_net_apf_ApfFilter_Ra$uint16(short ), 0, this, s);
        }

        private long uint32(int n) {
            return (long)InvokeDynamicSupport.bootstrap("uint32", $$robo$$android_net_apf_ApfFilter_Ra$uint32(int ), 0, this, n);
        }

        private void prefixOptionToString(StringBuffer stringBuffer, int n) {
            InvokeDynamicSupport.bootstrap("prefixOptionToString", $$robo$$android_net_apf_ApfFilter_Ra$prefixOptionToString(java.lang.StringBuffer int ), 0, this, stringBuffer, n);
        }

        private void rdnssOptionToString(StringBuffer stringBuffer, int n) {
            InvokeDynamicSupport.bootstrap("rdnssOptionToString", $$robo$$android_net_apf_ApfFilter_Ra$rdnssOptionToString(java.lang.StringBuffer int ), 0, this, stringBuffer, n);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_apf_ApfFilter_Ra$toString(), 0, this);
        }

        private int addNonLifetime(int n, int n2, int n3) {
            return (int)InvokeDynamicSupport.bootstrap("addNonLifetime", $$robo$$android_net_apf_ApfFilter_Ra$addNonLifetime(int int int ), 0, this, n, n2, n3);
        }

        private void __constructor__(ApfFilter apfFilter, byte[] byArray, int n) {
            this.$$robo$$android_net_apf_ApfFilter_Ra$__constructor__(apfFilter, byArray, n);
        }

        Ra(ApfFilter apfFilter, byte[] byArray, int n) {
            this.this$0 = apfFilter;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_apf_ApfFilter_Ra$__constructor__(android.net.apf.ApfFilter byte[] int ), 0, this, apfFilter, byArray, n);
        }

        boolean matches(byte[] byArray, int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("matches", $$robo$$android_net_apf_ApfFilter_Ra$matches(byte[] int ), 0, this, byArray, n);
        }

        long minLifetime(byte[] byArray, int n) {
            return (long)InvokeDynamicSupport.bootstrap("minLifetime", $$robo$$android_net_apf_ApfFilter_Ra$minLifetime(byte[] int ), 0, this, byArray, n);
        }

        long currentLifetime() {
            return (long)InvokeDynamicSupport.bootstrap("currentLifetime", $$robo$$android_net_apf_ApfFilter_Ra$currentLifetime(), 0, this);
        }

        boolean isExpired() {
            return (boolean)InvokeDynamicSupport.bootstrap("isExpired", $$robo$$android_net_apf_ApfFilter_Ra$isExpired(), 0, this);
        }

        long generateFilterLocked(ApfGenerator apfGenerator) throws ApfGenerator.IllegalInstructionException {
            return (long)InvokeDynamicSupport.bootstrap("generateFilterLocked", $$robo$$android_net_apf_ApfFilter_Ra$generateFilterLocked(android.net.apf.ApfGenerator ), 0, this, apfGenerator);
        }

        public /* synthetic */ Ra() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Ra)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class ReceiveThread
    extends Thread
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private byte[] mPacket;
        private FileDescriptor mSocket;
        private volatile boolean mStopped;
        /* synthetic */ ApfFilter this$0;

        private void $$robo$$android_net_apf_ApfFilter_ReceiveThread$__constructor__(ApfFilter this$0, FileDescriptor socket) {
            this.mPacket = new byte[1514];
            this.mSocket = socket;
        }

        private final void $$robo$$android_net_apf_ApfFilter_ReceiveThread$halt() {
            this.mStopped = true;
            try {
                IoBridge.closeAndSignalBlockedThreads(this.mSocket);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private final void $$robo$$android_net_apf_ApfFilter_ReceiveThread$run() {
            this.this$0.log("begin monitoring");
            while (!this.mStopped) {
                try {
                    int length = Os.read(this.mSocket, this.mPacket, 0, this.mPacket.length);
                    this.this$0.processRa(this.mPacket, length);
                }
                catch (ErrnoException | IOException e) {
                    if (this.mStopped) continue;
                    Log.e("ApfFilter", "Read error", e);
                }
            }
        }

        private void __constructor__(ApfFilter apfFilter, FileDescriptor fileDescriptor) {
            this.$$robo$$android_net_apf_ApfFilter_ReceiveThread$__constructor__(apfFilter, fileDescriptor);
        }

        public ReceiveThread(ApfFilter apfFilter, FileDescriptor fileDescriptor) {
            this.this$0 = apfFilter;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_apf_ApfFilter_ReceiveThread$__constructor__(android.net.apf.ApfFilter java.io.FileDescriptor ), 0, this, apfFilter, fileDescriptor);
        }

        public void halt() {
            InvokeDynamicSupport.bootstrap("halt", $$robo$$android_net_apf_ApfFilter_ReceiveThread$halt(), 0, this);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_net_apf_ApfFilter_ReceiveThread$run(), 0, this);
        }

        public /* synthetic */ ReceiveThread() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ReceiveThread)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

