/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.os.SystemClock;
import android.util.Log;
import java.lang.invoke.CallSite;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SntpClient
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "SntpClient";
    private static boolean DBG = true;
    private static int REFERENCE_TIME_OFFSET = 16;
    private static int ORIGINATE_TIME_OFFSET = 24;
    private static int RECEIVE_TIME_OFFSET = 32;
    private static int TRANSMIT_TIME_OFFSET = 40;
    private static int NTP_PACKET_SIZE = 48;
    private static int NTP_PORT = 123;
    private static int NTP_MODE_CLIENT = 3;
    private static int NTP_MODE_SERVER = 4;
    private static int NTP_MODE_BROADCAST = 5;
    private static int NTP_VERSION = 3;
    private static int NTP_LEAP_NOSYNC = 3;
    private static int NTP_STRATUM_DEATH = 0;
    private static int NTP_STRATUM_MAX = 15;
    private static long OFFSET_1900_TO_1970 = 2208988800L;
    private long mNtpTime;
    private long mNtpTimeReference;
    private long mRoundTripTime;

    private void $$robo$$android_net_SntpClient$__constructor__() {
    }

    private final boolean $$robo$$android_net_SntpClient$requestTime(String host, int timeout) {
        InetAddress address = null;
        try {
            address = InetAddress.getByName(host);
        }
        catch (Exception e) {
            Log.d("SntpClient", "request time failed: " + e);
            return false;
        }
        return this.requestTime(address, 123, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_net_SntpClient$requestTime(InetAddress address, int port, int timeout) {
        try (DatagramSocket socket = null;){
            socket = new DatagramSocket();
            socket.setSoTimeout(timeout);
            byte[] buffer = new byte[48];
            DatagramPacket request = new DatagramPacket(buffer, buffer.length, address, port);
            buffer[0] = 27;
            CallSite requestTime = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
            long requestTicks = SystemClock.elapsedRealtime();
            this.writeTimeStamp(buffer, 40, (long)requestTime);
            socket.send(request);
            DatagramPacket response = new DatagramPacket(buffer, buffer.length);
            socket.receive(response);
            long responseTicks = SystemClock.elapsedRealtime();
            reference var14_13 = requestTime + (responseTicks - requestTicks);
            byte leap = (byte)(buffer[0] >> 6 & 3);
            byte mode = (byte)(buffer[0] & 7);
            int stratum = buffer[1] & 0xFF;
            long originateTime = this.readTimeStamp(buffer, 24);
            long receiveTime = this.readTimeStamp(buffer, 32);
            long transmitTime = this.readTimeStamp(buffer, 40);
            SntpClient.checkValidServerReply(leap, mode, stratum, transmitTime);
            long roundTripTime = responseTicks - requestTicks - (transmitTime - receiveTime);
            long clockOffset = (receiveTime - originateTime + (transmitTime - var14_13)) / 2L;
            Log.d("SntpClient", "round trip: " + roundTripTime + "ms, clock offset: " + clockOffset + "ms");
            this.mNtpTime = (long)(var14_13 + clockOffset);
            this.mNtpTimeReference = responseTicks;
            this.mRoundTripTime = roundTripTime;
        }
        return true;
    }

    private final long $$robo$$android_net_SntpClient$getNtpTime() {
        return this.mNtpTime;
    }

    private final long $$robo$$android_net_SntpClient$getNtpTimeReference() {
        return this.mNtpTimeReference;
    }

    private final long $$robo$$android_net_SntpClient$getRoundTripTime() {
        return this.mRoundTripTime;
    }

    private static final void $$robo$$android_net_SntpClient$checkValidServerReply(byte leap, byte mode, int stratum, long transmitTime) throws InvalidServerReplyException {
        if (leap == 3) {
            throw new InvalidServerReplyException("unsynchronized server");
        }
        if (mode != 4 && mode != 5) {
            throw new InvalidServerReplyException("untrusted mode: " + mode);
        }
        if (stratum == 0 || stratum > 15) {
            throw new InvalidServerReplyException("untrusted stratum: " + stratum);
        }
        if (transmitTime == 0L) {
            throw new InvalidServerReplyException("zero transmitTime");
        }
    }

    private final long $$robo$$android_net_SntpClient$read32(byte[] buffer, int offset) {
        int b0 = buffer[offset];
        int b1 = buffer[offset + 1];
        int b2 = buffer[offset + 2];
        int b3 = buffer[offset + 3];
        int i0 = (b0 & 0x80) == 128 ? (b0 & 0x7F) + 128 : b0;
        int i1 = (b1 & 0x80) == 128 ? (b1 & 0x7F) + 128 : b1;
        int i2 = (b2 & 0x80) == 128 ? (b2 & 0x7F) + 128 : b2;
        int i3 = (b3 & 0x80) == 128 ? (b3 & 0x7F) + 128 : b3;
        return ((long)i0 << 24) + ((long)i1 << 16) + ((long)i2 << 8) + (long)i3;
    }

    private final long $$robo$$android_net_SntpClient$readTimeStamp(byte[] buffer, int offset) {
        long seconds = this.read32(buffer, offset);
        long fraction2 = this.read32(buffer, offset + 4);
        if (seconds == 0L && fraction2 == 0L) {
            return 0L;
        }
        return (seconds - 2208988800L) * 1000L + fraction2 * 1000L / 0x100000000L;
    }

    private final void $$robo$$android_net_SntpClient$writeTimeStamp(byte[] buffer, int offset, long time) {
        if (time == 0L) {
            Arrays.fill(buffer, offset, offset + 8, (byte)0);
            return;
        }
        long seconds = time / 1000L;
        long milliseconds = time - seconds * 1000L;
        buffer[offset++] = (byte)((seconds += 2208988800L) >> 24);
        buffer[offset++] = (byte)(seconds >> 16);
        buffer[offset++] = (byte)(seconds >> 8);
        buffer[offset++] = (byte)(seconds >> 0);
        long fraction2 = milliseconds * 0x100000000L / 1000L;
        buffer[offset++] = (byte)(fraction2 >> 24);
        buffer[offset++] = (byte)(fraction2 >> 16);
        buffer[offset++] = (byte)(fraction2 >> 8);
        buffer[offset++] = (byte)(Math.random() * 255.0);
    }

    private void __constructor__() {
        this.$$robo$$android_net_SntpClient$__constructor__();
    }

    public SntpClient() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_SntpClient$__constructor__(), 0, this);
    }

    public boolean requestTime(String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("requestTime", $$robo$$android_net_SntpClient$requestTime(java.lang.String int ), 0, this, string2, n);
    }

    public boolean requestTime(InetAddress inetAddress, int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("requestTime", $$robo$$android_net_SntpClient$requestTime(java.net.InetAddress int int ), 0, this, inetAddress, n, n2);
    }

    public long getNtpTime() {
        return (long)InvokeDynamicSupport.bootstrap("getNtpTime", $$robo$$android_net_SntpClient$getNtpTime(), 0, this);
    }

    public long getNtpTimeReference() {
        return (long)InvokeDynamicSupport.bootstrap("getNtpTimeReference", $$robo$$android_net_SntpClient$getNtpTimeReference(), 0, this);
    }

    public long getRoundTripTime() {
        return (long)InvokeDynamicSupport.bootstrap("getRoundTripTime", $$robo$$android_net_SntpClient$getRoundTripTime(), 0, this);
    }

    private static void checkValidServerReply(byte by, byte by2, int n, long l) throws InvalidServerReplyException {
        InvokeDynamicSupport.bootstrapStatic("checkValidServerReply", $$robo$$android_net_SntpClient$checkValidServerReply(byte byte int long ), 0, (byte)by, (byte)by2, (int)n, (long)l);
    }

    private long read32(byte[] byArray, int n) {
        return (long)InvokeDynamicSupport.bootstrap("read32", $$robo$$android_net_SntpClient$read32(byte[] int ), 0, this, byArray, n);
    }

    private long readTimeStamp(byte[] byArray, int n) {
        return (long)InvokeDynamicSupport.bootstrap("readTimeStamp", $$robo$$android_net_SntpClient$readTimeStamp(byte[] int ), 0, this, byArray, n);
    }

    private void writeTimeStamp(byte[] byArray, int n, long l) {
        InvokeDynamicSupport.bootstrap("writeTimeStamp", $$robo$$android_net_SntpClient$writeTimeStamp(byte[] int long ), 0, this, byArray, n, l);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SntpClient)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class InvalidServerReplyException
    extends Exception
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_net_SntpClient_InvalidServerReplyException$__constructor__(String message) {
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_net_SntpClient_InvalidServerReplyException$__constructor__(string2);
        }

        public InvalidServerReplyException(String string2) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_SntpClient_InvalidServerReplyException$__constructor__(java.lang.String ), 0, this, string2);
        }

        public /* synthetic */ InvalidServerReplyException() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InvalidServerReplyException)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

