/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.app.PendingIntent;
import android.net.ConnectivityMetricsEvent;
import android.net.IConnectivityMetricsLogger;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ConnectivityMetricsLogger
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG;
    private static boolean DBG = true;
    public static String CONNECTIVITY_METRICS_LOGGER_SERVICE = "connectivity_metrics_logger";
    public static int COMPONENT_TAG_CONNECTIVITY = 0;
    public static int COMPONENT_TAG_BLUETOOTH = 1;
    public static int COMPONENT_TAG_WIFI = 2;
    public static int COMPONENT_TAG_TELECOM = 3;
    public static int COMPONENT_TAG_TELEPHONY = 4;
    public static int NUMBER_OF_COMPONENTS = 5;
    public static int TAG_SKIPPED_EVENTS = -1;
    public static String DATA_KEY_EVENTS_COUNT = "count";
    private IConnectivityMetricsLogger mService;
    private long mServiceUnblockedTimestampMillis;
    private int mNumSkippedEvents;

    private void $$robo$$android_net_ConnectivityMetricsLogger$__constructor__() {
        this.mServiceUnblockedTimestampMillis = 0L;
        this.mNumSkippedEvents = 0;
        this.mService = IConnectivityMetricsLogger.Stub.asInterface(ServiceManager.getService("connectivity_metrics_logger"));
    }

    private final void $$robo$$android_net_ConnectivityMetricsLogger$logEvent(long timestamp, int componentTag, int eventTag, Parcelable data) {
        if (this.mService == null) {
            Log.d(TAG, "logEvent(" + componentTag + "," + eventTag + ") Service not ready");
            return;
        }
        if (this.mServiceUnblockedTimestampMillis > 0L && InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System") < this.mServiceUnblockedTimestampMillis) {
            ++this.mNumSkippedEvents;
            return;
        }
        ConnectivityMetricsEvent skippedEventsEvent = null;
        if (this.mNumSkippedEvents > 0) {
            Bundle b = new Bundle();
            b.putInt("count", this.mNumSkippedEvents);
            skippedEventsEvent = new ConnectivityMetricsEvent(this.mServiceUnblockedTimestampMillis, componentTag, -1, b);
            this.mServiceUnblockedTimestampMillis = 0L;
        }
        ConnectivityMetricsEvent event = new ConnectivityMetricsEvent(timestamp, componentTag, eventTag, data);
        try {
            long result = skippedEventsEvent == null ? this.mService.logEvent(event) : this.mService.logEvents(new ConnectivityMetricsEvent[]{skippedEventsEvent, event});
            if (result == 0L) {
                this.mNumSkippedEvents = 0;
            } else {
                ++this.mNumSkippedEvents;
                if (result > 0L) {
                    this.mServiceUnblockedTimestampMillis = result;
                }
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error logging event " + e.getMessage());
        }
    }

    private final ConnectivityMetricsEvent[] $$robo$$android_net_ConnectivityMetricsLogger$getEvents(ConnectivityMetricsEvent.Reference reference) {
        try {
            return this.mService.getEvents(reference);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "IConnectivityMetricsLogger.getEvents: " + ex);
            return null;
        }
    }

    private final boolean $$robo$$android_net_ConnectivityMetricsLogger$register(PendingIntent newEventsIntent) {
        try {
            return this.mService.register(newEventsIntent);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "IConnectivityMetricsLogger.register: " + ex);
            return false;
        }
    }

    private final boolean $$robo$$android_net_ConnectivityMetricsLogger$unregister(PendingIntent newEventsIntent) {
        try {
            this.mService.unregister(newEventsIntent);
        }
        catch (RemoteException ex) {
            Log.e(TAG, "IConnectivityMetricsLogger.unregister: " + ex);
            return false;
        }
        return true;
    }

    static void __staticInitializer__() {
        TAG = "ConnectivityMetricsLogger";
    }

    private void __constructor__() {
        this.$$robo$$android_net_ConnectivityMetricsLogger$__constructor__();
    }

    public ConnectivityMetricsLogger() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ConnectivityMetricsLogger$__constructor__(), 0, this);
    }

    public void logEvent(long l, int n, int n2, Parcelable parcelable) {
        InvokeDynamicSupport.bootstrap("logEvent", $$robo$$android_net_ConnectivityMetricsLogger$logEvent(long int int android.os.Parcelable ), 0, this, l, n, n2, parcelable);
    }

    public ConnectivityMetricsEvent[] getEvents(ConnectivityMetricsEvent.Reference reference) {
        return InvokeDynamicSupport.bootstrap("getEvents", $$robo$$android_net_ConnectivityMetricsLogger$getEvents(android.net.ConnectivityMetricsEvent$Reference ), 0, this, reference);
    }

    public boolean register(PendingIntent pendingIntent) {
        return (boolean)InvokeDynamicSupport.bootstrap("register", $$robo$$android_net_ConnectivityMetricsLogger$register(android.app.PendingIntent ), 0, this, pendingIntent);
    }

    public boolean unregister(PendingIntent pendingIntent) {
        return (boolean)InvokeDynamicSupport.bootstrap("unregister", $$robo$$android_net_ConnectivityMetricsLogger$unregister(android.app.PendingIntent ), 0, this, pendingIntent);
    }

    static {
        RobolectricInternals.classInitializing(ConnectivityMetricsLogger.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ConnectivityMetricsLogger)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

