/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.text.TextUtils;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class TvContentRating
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String DELIMITER = "/";
    private String mDomain;
    private String mRatingSystem;
    private String mRating;
    private String[] mSubRatings;
    private int mHashCode;
    public static TvContentRating UNRATED;

    private static final TvContentRating $$robo$$android_media_tv_TvContentRating$createRating(String domain, String ratingSystem, String rating, String ... subRatings) {
        if (TextUtils.isEmpty(domain)) {
            throw new IllegalArgumentException("domain cannot be empty");
        }
        if (TextUtils.isEmpty(ratingSystem)) {
            throw new IllegalArgumentException("ratingSystem cannot be empty");
        }
        if (TextUtils.isEmpty(rating)) {
            throw new IllegalArgumentException("rating cannot be empty");
        }
        return new TvContentRating(domain, ratingSystem, rating, subRatings);
    }

    private static final TvContentRating $$robo$$android_media_tv_TvContentRating$unflattenFromString(String ratingString) {
        if (TextUtils.isEmpty(ratingString)) {
            throw new IllegalArgumentException("ratingString cannot be empty");
        }
        String[] strs = ratingString.split("/");
        if (strs.length < 3) {
            throw new IllegalArgumentException("Invalid rating string: " + ratingString);
        }
        if (strs.length > 3) {
            String[] subRatings = new String[strs.length - 3];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)strs, (int)3, (Object)subRatings, (int)0, (int)subRatings.length);
            return new TvContentRating(strs[0], strs[1], strs[2], subRatings);
        }
        return new TvContentRating(strs[0], strs[1], strs[2], null);
    }

    private void $$robo$$android_media_tv_TvContentRating$__constructor__(String domain, String ratingSystem, String rating, String[] subRatings) {
        this.mDomain = domain;
        this.mRatingSystem = ratingSystem;
        this.mRating = rating;
        if (subRatings == null || subRatings.length == 0) {
            this.mSubRatings = null;
        } else {
            Arrays.sort(subRatings);
            this.mSubRatings = subRatings;
        }
        this.mHashCode = 31 * Objects.hash(this.mDomain, this.mRating) + Arrays.hashCode(this.mSubRatings);
    }

    private final String $$robo$$android_media_tv_TvContentRating$getDomain() {
        return this.mDomain;
    }

    private final String $$robo$$android_media_tv_TvContentRating$getRatingSystem() {
        return this.mRatingSystem;
    }

    private final String $$robo$$android_media_tv_TvContentRating$getMainRating() {
        return this.mRating;
    }

    private final List<String> $$robo$$android_media_tv_TvContentRating$getSubRatings() {
        if (this.mSubRatings == null) {
            return null;
        }
        return Collections.unmodifiableList(Arrays.asList(this.mSubRatings));
    }

    private final String $$robo$$android_media_tv_TvContentRating$flattenToString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.mDomain);
        builder.append("/");
        builder.append(this.mRatingSystem);
        builder.append("/");
        builder.append(this.mRating);
        if (this.mSubRatings != null) {
            for (String subRating : this.mSubRatings) {
                builder.append("/");
                builder.append(subRating);
            }
        }
        return builder.toString();
    }

    private final boolean $$robo$$android_media_tv_TvContentRating$contains(TvContentRating rating) {
        Preconditions.checkNotNull(rating);
        if (!rating.getMainRating().equals(this.mRating)) {
            return false;
        }
        if (!(rating.getDomain().equals(this.mDomain) && rating.getRatingSystem().equals(this.mRatingSystem) && rating.getMainRating().equals(this.mRating))) {
            return false;
        }
        List<String> subRatings = this.getSubRatings();
        List<String> subRatingsOther = rating.getSubRatings();
        if (subRatings == null && subRatingsOther == null) {
            return true;
        }
        if (subRatings == null && subRatingsOther != null) {
            return false;
        }
        if (subRatings != null && subRatingsOther == null) {
            return true;
        }
        return subRatings.containsAll(subRatingsOther);
    }

    private final boolean $$robo$$android_media_tv_TvContentRating$equals(Object obj) {
        if (!(obj instanceof TvContentRating)) {
            return false;
        }
        TvContentRating other = (TvContentRating)obj;
        if (this.mHashCode != other.mHashCode) {
            return false;
        }
        if (!TextUtils.equals(this.mDomain, other.mDomain)) {
            return false;
        }
        if (!TextUtils.equals(this.mRatingSystem, other.mRatingSystem)) {
            return false;
        }
        if (!TextUtils.equals(this.mRating, other.mRating)) {
            return false;
        }
        return Arrays.equals(this.mSubRatings, other.mSubRatings);
    }

    private final int $$robo$$android_media_tv_TvContentRating$hashCode() {
        return this.mHashCode;
    }

    static void __staticInitializer__() {
        UNRATED = new TvContentRating("null", "null", "null", null);
    }

    public static TvContentRating createRating(String string2, String string3, String string4, String ... stringArray) {
        return InvokeDynamicSupport.bootstrapStatic("createRating", $$robo$$android_media_tv_TvContentRating$createRating(java.lang.String java.lang.String java.lang.String java.lang.String[] ), 0, (String)string2, (String)string3, (String)string4, (String[])stringArray);
    }

    public static TvContentRating unflattenFromString(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("unflattenFromString", $$robo$$android_media_tv_TvContentRating$unflattenFromString(java.lang.String ), 0, (String)string2);
    }

    private void __constructor__(String string2, String string3, String string4, String[] stringArray) {
        this.$$robo$$android_media_tv_TvContentRating$__constructor__(string2, string3, string4, stringArray);
    }

    private TvContentRating(String string2, String string3, String string4, String[] stringArray) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_tv_TvContentRating$__constructor__(java.lang.String java.lang.String java.lang.String java.lang.String[] ), 0, this, string2, string3, string4, stringArray);
    }

    public String getDomain() {
        return InvokeDynamicSupport.bootstrap("getDomain", $$robo$$android_media_tv_TvContentRating$getDomain(), 0, this);
    }

    public String getRatingSystem() {
        return InvokeDynamicSupport.bootstrap("getRatingSystem", $$robo$$android_media_tv_TvContentRating$getRatingSystem(), 0, this);
    }

    public String getMainRating() {
        return InvokeDynamicSupport.bootstrap("getMainRating", $$robo$$android_media_tv_TvContentRating$getMainRating(), 0, this);
    }

    public List<String> getSubRatings() {
        return InvokeDynamicSupport.bootstrap("getSubRatings", $$robo$$android_media_tv_TvContentRating$getSubRatings(), 0, this);
    }

    public String flattenToString() {
        return InvokeDynamicSupport.bootstrap("flattenToString", $$robo$$android_media_tv_TvContentRating$flattenToString(), 0, this);
    }

    public boolean contains(TvContentRating tvContentRating) {
        return (boolean)InvokeDynamicSupport.bootstrap("contains", $$robo$$android_media_tv_TvContentRating$contains(android.media.tv.TvContentRating ), 0, this, tvContentRating);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_media_tv_TvContentRating$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_media_tv_TvContentRating$hashCode(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(TvContentRating.class);
    }

    public /* synthetic */ TvContentRating() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TvContentRating)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

