/*
 * Decompiled with CFR 0.152.
 */
package android.media.soundtrigger;

import android.content.Context;
import android.hardware.soundtrigger.SoundTrigger;
import android.media.soundtrigger.SoundTriggerDetector;
import android.os.Handler;
import android.os.ParcelUuid;
import android.os.RemoteException;
import com.android.internal.app.ISoundTriggerService;
import com.google.errorprone.annotations.DoNotMock;
import java.util.HashMap;
import java.util.UUID;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class SoundTriggerManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean DBG = false;
    private static String TAG = "SoundTriggerManager";
    private Context mContext;
    private ISoundTriggerService mSoundTriggerService;
    private HashMap<UUID, SoundTriggerDetector> mReceiverInstanceMap;

    private void $$robo$$android_media_soundtrigger_SoundTriggerManager$__constructor__(Context context, ISoundTriggerService soundTriggerService) {
        this.mSoundTriggerService = soundTriggerService;
        this.mContext = context;
        this.mReceiverInstanceMap = new HashMap();
    }

    private final void $$robo$$android_media_soundtrigger_SoundTriggerManager$updateModel(Model model) {
        try {
            this.mSoundTriggerService.updateSoundModel(model.getGenericSoundModel());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final Model $$robo$$android_media_soundtrigger_SoundTriggerManager$getModel(UUID soundModelId) {
        try {
            return new Model(this.mSoundTriggerService.getSoundModel(new ParcelUuid(soundModelId)));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_media_soundtrigger_SoundTriggerManager$deleteModel(UUID soundModelId) {
        try {
            this.mSoundTriggerService.deleteSoundModel(new ParcelUuid(soundModelId));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final SoundTriggerDetector $$robo$$android_media_soundtrigger_SoundTriggerManager$createSoundTriggerDetector(UUID soundModelId, SoundTriggerDetector.Callback callback, Handler handler) {
        if (soundModelId == null) {
            return null;
        }
        SoundTriggerDetector oldInstance = this.mReceiverInstanceMap.get(soundModelId);
        if (oldInstance != null) {
            // empty if block
        }
        SoundTriggerDetector newInstance = new SoundTriggerDetector(this.mSoundTriggerService, soundModelId, callback, handler);
        this.mReceiverInstanceMap.put(soundModelId, newInstance);
        return newInstance;
    }

    private void __constructor__(Context context, ISoundTriggerService iSoundTriggerService) {
        this.$$robo$$android_media_soundtrigger_SoundTriggerManager$__constructor__(context, iSoundTriggerService);
    }

    public SoundTriggerManager(Context context, ISoundTriggerService iSoundTriggerService) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_soundtrigger_SoundTriggerManager$__constructor__(android.content.Context com.android.internal.app.ISoundTriggerService ), 0, this, context, iSoundTriggerService);
    }

    public void updateModel(Model model) {
        InvokeDynamicSupport.bootstrap("updateModel", $$robo$$android_media_soundtrigger_SoundTriggerManager$updateModel(android.media.soundtrigger.SoundTriggerManager$Model ), 0, this, model);
    }

    public Model getModel(UUID uUID) {
        return InvokeDynamicSupport.bootstrap("getModel", $$robo$$android_media_soundtrigger_SoundTriggerManager$getModel(java.util.UUID ), 0, this, uUID);
    }

    public void deleteModel(UUID uUID) {
        InvokeDynamicSupport.bootstrap("deleteModel", $$robo$$android_media_soundtrigger_SoundTriggerManager$deleteModel(java.util.UUID ), 0, this, uUID);
    }

    public SoundTriggerDetector createSoundTriggerDetector(UUID uUID, SoundTriggerDetector.Callback callback, Handler handler) {
        return InvokeDynamicSupport.bootstrap("createSoundTriggerDetector", $$robo$$android_media_soundtrigger_SoundTriggerManager$createSoundTriggerDetector(java.util.UUID android.media.soundtrigger.SoundTriggerDetector$Callback android.os.Handler ), 0, this, uUID, callback, handler);
    }

    public /* synthetic */ SoundTriggerManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SoundTriggerManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Model
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private SoundTrigger.GenericSoundModel mGenericSoundModel;

        private void $$robo$$android_media_soundtrigger_SoundTriggerManager_Model$__constructor__(SoundTrigger.GenericSoundModel soundTriggerModel) {
            this.mGenericSoundModel = soundTriggerModel;
        }

        private static final Model $$robo$$android_media_soundtrigger_SoundTriggerManager_Model$create(UUID modelUuid, UUID vendorUuid, byte[] data) {
            return new Model(new SoundTrigger.GenericSoundModel(modelUuid, vendorUuid, data));
        }

        private final UUID $$robo$$android_media_soundtrigger_SoundTriggerManager_Model$getModelUuid() {
            return this.mGenericSoundModel.uuid;
        }

        private final UUID $$robo$$android_media_soundtrigger_SoundTriggerManager_Model$getVendorUuid() {
            return this.mGenericSoundModel.vendorUuid;
        }

        private final byte[] $$robo$$android_media_soundtrigger_SoundTriggerManager_Model$getModelData() {
            return this.mGenericSoundModel.data;
        }

        private final SoundTrigger.GenericSoundModel $$robo$$android_media_soundtrigger_SoundTriggerManager_Model$getGenericSoundModel() {
            return this.mGenericSoundModel;
        }

        private void __constructor__(SoundTrigger.GenericSoundModel genericSoundModel) {
            this.$$robo$$android_media_soundtrigger_SoundTriggerManager_Model$__constructor__(genericSoundModel);
        }

        Model(SoundTrigger.GenericSoundModel genericSoundModel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_soundtrigger_SoundTriggerManager_Model$__constructor__(android.hardware.soundtrigger.SoundTrigger$GenericSoundModel ), 0, this, genericSoundModel);
        }

        public static Model create(UUID uUID, UUID uUID2, byte[] byArray) {
            return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$android_media_soundtrigger_SoundTriggerManager_Model$create(java.util.UUID java.util.UUID byte[] ), 0, (UUID)uUID, (UUID)uUID2, (byte[])byArray);
        }

        public UUID getModelUuid() {
            return InvokeDynamicSupport.bootstrap("getModelUuid", $$robo$$android_media_soundtrigger_SoundTriggerManager_Model$getModelUuid(), 0, this);
        }

        public UUID getVendorUuid() {
            return InvokeDynamicSupport.bootstrap("getVendorUuid", $$robo$$android_media_soundtrigger_SoundTriggerManager_Model$getVendorUuid(), 0, this);
        }

        public byte[] getModelData() {
            return InvokeDynamicSupport.bootstrap("getModelData", $$robo$$android_media_soundtrigger_SoundTriggerManager_Model$getModelData(), 0, this);
        }

        SoundTrigger.GenericSoundModel getGenericSoundModel() {
            return InvokeDynamicSupport.bootstrap("getGenericSoundModel", $$robo$$android_media_soundtrigger_SoundTriggerManager_Model$getGenericSoundModel(), 0, this);
        }

        public /* synthetic */ Model() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Model)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

