/*
 * Decompiled with CFR 0.152.
 */
package android.media.midi;

import android.media.midi.IMidiDeviceServer;
import android.media.midi.MidiPortImpl;
import android.media.midi.MidiReceiver;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.CloseGuard;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import libcore.io.IoUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class MidiInputPort
extends MidiReceiver
implements Closeable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "MidiInputPort";
    private IMidiDeviceServer mDeviceServer;
    private IBinder mToken;
    private int mPortNumber;
    private ParcelFileDescriptor mParcelFileDescriptor;
    private FileOutputStream mOutputStream;
    private CloseGuard mGuard;
    private boolean mIsClosed;
    private byte[] mBuffer;

    private void $$robo$$android_media_midi_MidiInputPort$__constructor__(IMidiDeviceServer server, IBinder token, ParcelFileDescriptor pfd, int portNumber) {
        this.mGuard = CloseGuard.get();
        this.mBuffer = new byte[1024];
        this.mDeviceServer = server;
        this.mToken = token;
        this.mParcelFileDescriptor = pfd;
        this.mPortNumber = portNumber;
        this.mOutputStream = new FileOutputStream(pfd.getFileDescriptor());
        this.mGuard.open("close");
    }

    private void $$robo$$android_media_midi_MidiInputPort$__constructor__(ParcelFileDescriptor pfd, int portNumber) {
    }

    private final int $$robo$$android_media_midi_MidiInputPort$getPortNumber() {
        return this.mPortNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_midi_MidiInputPort$onSend(byte[] msg, int offset, int count, long timestamp) throws IOException {
        if (offset < 0 || count < 0 || offset + count > msg.length) {
            throw new IllegalArgumentException("offset or count out of range");
        }
        if (count > 1015) {
            throw new IllegalArgumentException("count exceeds max message size");
        }
        byte[] byArray = this.mBuffer;
        synchronized (this.mBuffer) {
            if (this.mOutputStream == null) {
                throw new IOException("MidiInputPort is closed");
            }
            int length = MidiPortImpl.packData(msg, offset, count, timestamp, this.mBuffer);
            this.mOutputStream.write(this.mBuffer, 0, length);
            // ** MonitorExit[var6_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_midi_MidiInputPort$onFlush() throws IOException {
        byte[] byArray = this.mBuffer;
        synchronized (this.mBuffer) {
            if (this.mOutputStream == null) {
                throw new IOException("MidiInputPort is closed");
            }
            int length = MidiPortImpl.packFlush(this.mBuffer);
            this.mOutputStream.write(this.mBuffer, 0, length);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ParcelFileDescriptor $$robo$$android_media_midi_MidiInputPort$claimFileDescriptor() {
        CloseGuard closeGuard = this.mGuard;
        synchronized (closeGuard) {
            byte[] byArray = this.mBuffer;
            synchronized (this.mBuffer) {
                ParcelFileDescriptor pfd = this.mParcelFileDescriptor;
                if (pfd == null) {
                    // ** MonitorExit[var3_2] (shouldn't be in output)
                    return null;
                }
                IoUtils.closeQuietly(this.mOutputStream);
                this.mParcelFileDescriptor = null;
                this.mOutputStream = null;
                // ** MonitorExit[var3_2] (shouldn't be in output)
                this.mIsClosed = true;
                return pfd;
            }
        }
    }

    private final IBinder $$robo$$android_media_midi_MidiInputPort$getToken() {
        return this.mToken;
    }

    private final IMidiDeviceServer $$robo$$android_media_midi_MidiInputPort$getDeviceServer() {
        return this.mDeviceServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_midi_MidiInputPort$close() throws IOException {
        CloseGuard closeGuard = this.mGuard;
        synchronized (closeGuard) {
            if (this.mIsClosed) {
                return;
            }
            this.mGuard.close();
            byte[] byArray = this.mBuffer;
            synchronized (this.mBuffer) {
                if (this.mParcelFileDescriptor != null) {
                    this.mParcelFileDescriptor.close();
                    this.mParcelFileDescriptor = null;
                }
                if (this.mOutputStream != null) {
                    this.mOutputStream.close();
                    this.mOutputStream = null;
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                if (this.mDeviceServer != null) {
                    try {
                        this.mDeviceServer.closePort(this.mToken);
                    }
                    catch (RemoteException e) {
                        Log.e("MidiInputPort", "RemoteException in MidiInputPort.close()");
                    }
                }
                this.mIsClosed = true;
            }
        }
    }

    private final void $$robo$$android_media_midi_MidiInputPort$finalize() throws Throwable {
        try {
            this.mGuard.warnIfOpen();
            this.mDeviceServer = null;
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private void __constructor__(IMidiDeviceServer iMidiDeviceServer, IBinder iBinder, ParcelFileDescriptor parcelFileDescriptor, int n) {
        this.$$robo$$android_media_midi_MidiInputPort$__constructor__(iMidiDeviceServer, iBinder, parcelFileDescriptor, n);
    }

    MidiInputPort(IMidiDeviceServer iMidiDeviceServer, IBinder iBinder, ParcelFileDescriptor parcelFileDescriptor, int n) {
        super(1015);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_midi_MidiInputPort$__constructor__(android.media.midi.IMidiDeviceServer android.os.IBinder android.os.ParcelFileDescriptor int ), 0, this, iMidiDeviceServer, iBinder, parcelFileDescriptor, n);
    }

    private void __constructor__(ParcelFileDescriptor parcelFileDescriptor, int n) {
        this.$$robo$$android_media_midi_MidiInputPort$__constructor__(parcelFileDescriptor, n);
    }

    MidiInputPort(ParcelFileDescriptor parcelFileDescriptor, int n) {
        this(null, null, parcelFileDescriptor, n);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_midi_MidiInputPort$__constructor__(android.os.ParcelFileDescriptor int ), 0, this, parcelFileDescriptor, n);
    }

    public int getPortNumber() {
        return (int)InvokeDynamicSupport.bootstrap("getPortNumber", $$robo$$android_media_midi_MidiInputPort$getPortNumber(), 0, this);
    }

    @Override
    public void onSend(byte[] byArray, int n, int n2, long l) throws IOException {
        InvokeDynamicSupport.bootstrap("onSend", $$robo$$android_media_midi_MidiInputPort$onSend(byte[] int int long ), 0, this, byArray, n, n2, l);
    }

    @Override
    public void onFlush() throws IOException {
        InvokeDynamicSupport.bootstrap("onFlush", $$robo$$android_media_midi_MidiInputPort$onFlush(), 0, this);
    }

    ParcelFileDescriptor claimFileDescriptor() {
        return InvokeDynamicSupport.bootstrap("claimFileDescriptor", $$robo$$android_media_midi_MidiInputPort$claimFileDescriptor(), 0, this);
    }

    IBinder getToken() {
        return InvokeDynamicSupport.bootstrap("getToken", $$robo$$android_media_midi_MidiInputPort$getToken(), 0, this);
    }

    IMidiDeviceServer getDeviceServer() {
        return InvokeDynamicSupport.bootstrap("getDeviceServer", $$robo$$android_media_midi_MidiInputPort$getDeviceServer(), 0, this);
    }

    @Override
    public void close() throws IOException {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_media_midi_MidiInputPort$close(), 0, this);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_media_midi_MidiInputPort$finalize(), 0, this);
    }

    public /* synthetic */ MidiInputPort() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MidiInputPort)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

