/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiofx;

import android.app.ActivityThread;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.UUID;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AudioEffect
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "AudioEffect-JAVA";
    public static UUID EFFECT_TYPE_ENV_REVERB;
    public static UUID EFFECT_TYPE_PRESET_REVERB;
    public static UUID EFFECT_TYPE_EQUALIZER;
    public static UUID EFFECT_TYPE_BASS_BOOST;
    public static UUID EFFECT_TYPE_VIRTUALIZER;
    public static UUID EFFECT_TYPE_AGC;
    public static UUID EFFECT_TYPE_AEC;
    public static UUID EFFECT_TYPE_NS;
    public static UUID EFFECT_TYPE_LOUDNESS_ENHANCER;
    public static UUID EFFECT_TYPE_NULL;
    public static int STATE_UNINITIALIZED = 0;
    public static int STATE_INITIALIZED = 1;
    public static int NATIVE_EVENT_CONTROL_STATUS = 0;
    public static int NATIVE_EVENT_ENABLED_STATUS = 1;
    public static int NATIVE_EVENT_PARAMETER_CHANGED = 2;
    public static int SUCCESS = 0;
    public static int ERROR = -1;
    public static int ALREADY_EXISTS = -2;
    public static int ERROR_NO_INIT = -3;
    public static int ERROR_BAD_VALUE = -4;
    public static int ERROR_INVALID_OPERATION = -5;
    public static int ERROR_NO_MEMORY = -6;
    public static int ERROR_DEAD_OBJECT = -7;
    public static String EFFECT_INSERT = "Insert";
    public static String EFFECT_AUXILIARY = "Auxiliary";
    public static String EFFECT_PRE_PROCESSING = "Pre Processing";
    private int mState;
    private Object mStateLock;
    private int mId;
    private long mNativeAudioEffect;
    private long mJniData;
    private Descriptor mDescriptor;
    private OnEnableStatusChangeListener mEnableStatusChangeListener;
    private OnControlStatusChangeListener mControlChangeStatusListener;
    private OnParameterChangeListener mParameterChangeListener;
    public Object mListenerLock;
    public NativeEventHandler mNativeEventHandler;
    public static String ACTION_DISPLAY_AUDIO_EFFECT_CONTROL_PANEL = "android.media.action.DISPLAY_AUDIO_EFFECT_CONTROL_PANEL";
    public static String ACTION_OPEN_AUDIO_EFFECT_CONTROL_SESSION = "android.media.action.OPEN_AUDIO_EFFECT_CONTROL_SESSION";
    public static String ACTION_CLOSE_AUDIO_EFFECT_CONTROL_SESSION = "android.media.action.CLOSE_AUDIO_EFFECT_CONTROL_SESSION";
    public static String EXTRA_AUDIO_SESSION = "android.media.extra.AUDIO_SESSION";
    public static String EXTRA_PACKAGE_NAME = "android.media.extra.PACKAGE_NAME";
    public static String EXTRA_CONTENT_TYPE = "android.media.extra.CONTENT_TYPE";
    public static int CONTENT_TYPE_MUSIC = 0;
    public static int CONTENT_TYPE_MOVIE = 1;
    public static int CONTENT_TYPE_GAME = 2;
    public static int CONTENT_TYPE_VOICE = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void $$robo$$android_media_audiofx_AudioEffect$__constructor__(UUID type, UUID uuid, int priority, int audioSession) throws IllegalArgumentException, UnsupportedOperationException, RuntimeException {
        this.mState = 0;
        this.mStateLock = new Object();
        this.mEnableStatusChangeListener = null;
        this.mControlChangeStatusListener = null;
        this.mParameterChangeListener = null;
        this.mListenerLock = new Object();
        this.mNativeEventHandler = null;
        int[] id2 = new int[1];
        Object[] desc = new Descriptor[1];
        int initResult = this.native_setup(new WeakReference<AudioEffect>(this), type.toString(), uuid.toString(), priority, audioSession, id2, desc, ActivityThread.currentOpPackageName());
        if (initResult != 0 && initResult != -2) {
            Log.e("AudioEffect-JAVA", "Error code " + initResult + " when initializing AudioEffect.");
            switch (initResult) {
                case -4: {
                    throw new IllegalArgumentException("Effect type: " + type + " not supported.");
                }
                case -5: {
                    throw new UnsupportedOperationException("Effect library not loaded");
                }
            }
            throw new RuntimeException("Cannot initialize effect engine for type: " + type + " Error: " + initResult);
        }
        this.mId = id2[0];
        this.mDescriptor = desc[0];
        Object object = this.mStateLock;
        synchronized (object) {
            this.mState = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_audiofx_AudioEffect$release() {
        Object object = this.mStateLock;
        synchronized (object) {
            this.native_release();
            this.mState = 0;
        }
    }

    private final void $$robo$$android_media_audiofx_AudioEffect$finalize() {
        this.native_finalize();
    }

    private final Descriptor $$robo$$android_media_audiofx_AudioEffect$getDescriptor() throws IllegalStateException {
        this.checkState("getDescriptor()");
        return this.mDescriptor;
    }

    private static final Descriptor[] $$robo$$android_media_audiofx_AudioEffect$queryEffects() {
        return (Descriptor[])AudioEffect.native_query_effects();
    }

    private static final Descriptor[] $$robo$$android_media_audiofx_AudioEffect$queryPreProcessings(int audioSession) {
        return (Descriptor[])AudioEffect.native_query_pre_processing(audioSession);
    }

    private static final boolean $$robo$$android_media_audiofx_AudioEffect$isEffectTypeAvailable(UUID type) {
        Descriptor[] desc = AudioEffect.queryEffects();
        if (desc == null) {
            return false;
        }
        for (int i = 0; i < desc.length; ++i) {
            if (!desc[i].type.equals(type)) continue;
            return true;
        }
        return false;
    }

    private final int $$robo$$android_media_audiofx_AudioEffect$setEnabled(boolean enabled) throws IllegalStateException {
        this.checkState("setEnabled()");
        return this.native_setEnabled(enabled);
    }

    private final int $$robo$$android_media_audiofx_AudioEffect$setParameter(byte[] param, byte[] value) throws IllegalStateException {
        this.checkState("setParameter()");
        return this.native_setParameter(param.length, param, value.length, value);
    }

    private final int $$robo$$android_media_audiofx_AudioEffect$setParameter(int param, int value) throws IllegalStateException {
        byte[] p = AudioEffect.intToByteArray(param);
        byte[] v = AudioEffect.intToByteArray(value);
        return this.setParameter(p, v);
    }

    private final int $$robo$$android_media_audiofx_AudioEffect$setParameter(int param, short value) throws IllegalStateException {
        byte[] p = AudioEffect.intToByteArray(param);
        byte[] v = AudioEffect.shortToByteArray(value);
        return this.setParameter(p, v);
    }

    private final int $$robo$$android_media_audiofx_AudioEffect$setParameter(int param, byte[] value) throws IllegalStateException {
        byte[] p = AudioEffect.intToByteArray(param);
        return this.setParameter(p, value);
    }

    private final int $$robo$$android_media_audiofx_AudioEffect$setParameter(int[] param, int[] value) throws IllegalStateException {
        if (param.length > 2 || value.length > 2) {
            return -4;
        }
        byte[] p = AudioEffect.intToByteArray(param[0]);
        if (param.length > 1) {
            byte[] p2 = AudioEffect.intToByteArray(param[1]);
            p = AudioEffect.concatArrays(p, p2);
        }
        byte[] v = AudioEffect.intToByteArray(value[0]);
        if (value.length > 1) {
            byte[] v2 = AudioEffect.intToByteArray(value[1]);
            v = AudioEffect.concatArrays(v, v2);
        }
        return this.setParameter(p, v);
    }

    private final int $$robo$$android_media_audiofx_AudioEffect$setParameter(int[] param, short[] value) throws IllegalStateException {
        if (param.length > 2 || value.length > 2) {
            return -4;
        }
        byte[] p = AudioEffect.intToByteArray(param[0]);
        if (param.length > 1) {
            byte[] p2 = AudioEffect.intToByteArray(param[1]);
            p = AudioEffect.concatArrays(p, p2);
        }
        byte[] v = AudioEffect.shortToByteArray(value[0]);
        if (value.length > 1) {
            byte[] v2 = AudioEffect.shortToByteArray(value[1]);
            v = AudioEffect.concatArrays(v, v2);
        }
        return this.setParameter(p, v);
    }

    private final int $$robo$$android_media_audiofx_AudioEffect$setParameter(int[] param, byte[] value) throws IllegalStateException {
        if (param.length > 2) {
            return -4;
        }
        byte[] p = AudioEffect.intToByteArray(param[0]);
        if (param.length > 1) {
            byte[] p2 = AudioEffect.intToByteArray(param[1]);
            p = AudioEffect.concatArrays(p, p2);
        }
        return this.setParameter(p, value);
    }

    private final int $$robo$$android_media_audiofx_AudioEffect$getParameter(byte[] param, byte[] value) throws IllegalStateException {
        this.checkState("getParameter()");
        return this.native_getParameter(param.length, param, value.length, value);
    }

    private final int $$robo$$android_media_audiofx_AudioEffect$getParameter(int param, byte[] value) throws IllegalStateException {
        byte[] p = AudioEffect.intToByteArray(param);
        return this.getParameter(p, value);
    }

    private final int $$robo$$android_media_audiofx_AudioEffect$getParameter(int param, int[] value) throws IllegalStateException {
        byte[] v;
        if (value.length > 2) {
            return -4;
        }
        byte[] p = AudioEffect.intToByteArray(param);
        int status = this.getParameter(p, v = new byte[value.length * 4]);
        if (status == 4 || status == 8) {
            value[0] = AudioEffect.byteArrayToInt(v);
            if (status == 8) {
                value[1] = AudioEffect.byteArrayToInt(v, 4);
            }
            status /= 4;
        } else {
            status = -1;
        }
        return status;
    }

    private final int $$robo$$android_media_audiofx_AudioEffect$getParameter(int param, short[] value) throws IllegalStateException {
        byte[] v;
        if (value.length > 2) {
            return -4;
        }
        byte[] p = AudioEffect.intToByteArray(param);
        int status = this.getParameter(p, v = new byte[value.length * 2]);
        if (status == 2 || status == 4) {
            value[0] = AudioEffect.byteArrayToShort(v);
            if (status == 4) {
                value[1] = AudioEffect.byteArrayToShort(v, 2);
            }
            status /= 2;
        } else {
            status = -1;
        }
        return status;
    }

    private final int $$robo$$android_media_audiofx_AudioEffect$getParameter(int[] param, int[] value) throws IllegalStateException {
        byte[] v;
        int status;
        if (param.length > 2 || value.length > 2) {
            return -4;
        }
        byte[] p = AudioEffect.intToByteArray(param[0]);
        if (param.length > 1) {
            byte[] p2 = AudioEffect.intToByteArray(param[1]);
            p = AudioEffect.concatArrays(p, p2);
        }
        if ((status = this.getParameter(p, v = new byte[value.length * 4])) == 4 || status == 8) {
            value[0] = AudioEffect.byteArrayToInt(v);
            if (status == 8) {
                value[1] = AudioEffect.byteArrayToInt(v, 4);
            }
            status /= 4;
        } else {
            status = -1;
        }
        return status;
    }

    private final int $$robo$$android_media_audiofx_AudioEffect$getParameter(int[] param, short[] value) throws IllegalStateException {
        byte[] v;
        int status;
        if (param.length > 2 || value.length > 2) {
            return -4;
        }
        byte[] p = AudioEffect.intToByteArray(param[0]);
        if (param.length > 1) {
            byte[] p2 = AudioEffect.intToByteArray(param[1]);
            p = AudioEffect.concatArrays(p, p2);
        }
        if ((status = this.getParameter(p, v = new byte[value.length * 2])) == 2 || status == 4) {
            value[0] = AudioEffect.byteArrayToShort(v);
            if (status == 4) {
                value[1] = AudioEffect.byteArrayToShort(v, 2);
            }
            status /= 2;
        } else {
            status = -1;
        }
        return status;
    }

    private final int $$robo$$android_media_audiofx_AudioEffect$getParameter(int[] param, byte[] value) throws IllegalStateException {
        if (param.length > 2) {
            return -4;
        }
        byte[] p = AudioEffect.intToByteArray(param[0]);
        if (param.length > 1) {
            byte[] p2 = AudioEffect.intToByteArray(param[1]);
            p = AudioEffect.concatArrays(p, p2);
        }
        return this.getParameter(p, value);
    }

    private final int $$robo$$android_media_audiofx_AudioEffect$command(int cmdCode, byte[] command, byte[] reply) throws IllegalStateException {
        this.checkState("command()");
        return this.native_command(cmdCode, command.length, command, reply.length, reply);
    }

    private final int $$robo$$android_media_audiofx_AudioEffect$getId() throws IllegalStateException {
        this.checkState("getId()");
        return this.mId;
    }

    private final boolean $$robo$$android_media_audiofx_AudioEffect$getEnabled() throws IllegalStateException {
        this.checkState("getEnabled()");
        return this.native_getEnabled();
    }

    private final boolean $$robo$$android_media_audiofx_AudioEffect$hasControl() throws IllegalStateException {
        this.checkState("hasControl()");
        return this.native_hasControl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_audiofx_AudioEffect$setEnableStatusListener(OnEnableStatusChangeListener listener) {
        Object object = this.mListenerLock;
        synchronized (object) {
            this.mEnableStatusChangeListener = listener;
        }
        if (listener != null && this.mNativeEventHandler == null) {
            this.createNativeEventHandler();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_audiofx_AudioEffect$setControlStatusListener(OnControlStatusChangeListener listener) {
        Object object = this.mListenerLock;
        synchronized (object) {
            this.mControlChangeStatusListener = listener;
        }
        if (listener != null && this.mNativeEventHandler == null) {
            this.createNativeEventHandler();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_audiofx_AudioEffect$setParameterListener(OnParameterChangeListener listener) {
        Object object = this.mListenerLock;
        synchronized (object) {
            this.mParameterChangeListener = listener;
        }
        if (listener != null && this.mNativeEventHandler == null) {
            this.createNativeEventHandler();
        }
    }

    private final void $$robo$$android_media_audiofx_AudioEffect$createNativeEventHandler() {
        Looper looper = Looper.myLooper();
        this.mNativeEventHandler = looper != null ? new NativeEventHandler(this, this, looper) : ((looper = Looper.getMainLooper()) != null ? new NativeEventHandler(this, this, looper) : null);
    }

    private static final void $$robo$$android_media_audiofx_AudioEffect$postEventFromNative(Object effect_ref, int what, int arg1, int arg2, Object obj) {
        AudioEffect effect = (AudioEffect)((WeakReference)effect_ref).get();
        if (effect == null) {
            return;
        }
        if (effect.mNativeEventHandler != null) {
            Message m = effect.mNativeEventHandler.obtainMessage(what, arg1, arg2, obj);
            effect.mNativeEventHandler.sendMessage(m);
        }
    }

    private static final void $$robo$$android_media_audiofx_AudioEffect$native_init() {
    }

    private final int $$robo$$android_media_audiofx_AudioEffect$native_setup(Object object, String string2, String string3, int n, int n2, int[] nArray, Object[] objectArray, String string4) {
        return 0;
    }

    private final void $$robo$$android_media_audiofx_AudioEffect$native_finalize() {
    }

    private final void $$robo$$android_media_audiofx_AudioEffect$native_release() {
    }

    private final int $$robo$$android_media_audiofx_AudioEffect$native_setEnabled(boolean bl) {
        return 0;
    }

    private final boolean $$robo$$android_media_audiofx_AudioEffect$native_getEnabled() {
        return false;
    }

    private final boolean $$robo$$android_media_audiofx_AudioEffect$native_hasControl() {
        return false;
    }

    private final int $$robo$$android_media_audiofx_AudioEffect$native_setParameter(int n, byte[] byArray, int n2, byte[] byArray2) {
        return 0;
    }

    private final int $$robo$$android_media_audiofx_AudioEffect$native_getParameter(int n, byte[] byArray, int n2, byte[] byArray2) {
        return 0;
    }

    private final int $$robo$$android_media_audiofx_AudioEffect$native_command(int n, int n2, byte[] byArray, int n3, byte[] byArray2) {
        return 0;
    }

    private static final Object[] $$robo$$android_media_audiofx_AudioEffect$native_query_effects() {
        return null;
    }

    private static final Object[] $$robo$$android_media_audiofx_AudioEffect$native_query_pre_processing(int n) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_audiofx_AudioEffect$checkState(String methodName) throws IllegalStateException {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mState != 1) {
                throw new IllegalStateException(methodName + " called on uninitialized AudioEffect.");
            }
        }
    }

    private final void $$robo$$android_media_audiofx_AudioEffect$checkStatus(int status) {
        if (AudioEffect.isError(status)) {
            switch (status) {
                case -4: {
                    throw new IllegalArgumentException("AudioEffect: bad parameter value");
                }
                case -5: {
                    throw new UnsupportedOperationException("AudioEffect: invalid parameter operation");
                }
            }
            throw new RuntimeException("AudioEffect: set/get parameter error");
        }
    }

    private static final boolean $$robo$$android_media_audiofx_AudioEffect$isError(int status) {
        return status < 0;
    }

    private static final int $$robo$$android_media_audiofx_AudioEffect$byteArrayToInt(byte[] valueBuf) {
        return AudioEffect.byteArrayToInt(valueBuf, 0);
    }

    private static final int $$robo$$android_media_audiofx_AudioEffect$byteArrayToInt(byte[] valueBuf, int offset) {
        ByteBuffer converter = ByteBuffer.wrap(valueBuf);
        converter.order(ByteOrder.nativeOrder());
        return converter.getInt(offset);
    }

    private static final byte[] $$robo$$android_media_audiofx_AudioEffect$intToByteArray(int value) {
        ByteBuffer converter = ByteBuffer.allocate(4);
        converter.order(ByteOrder.nativeOrder());
        converter.putInt(value);
        return converter.array();
    }

    private static final short $$robo$$android_media_audiofx_AudioEffect$byteArrayToShort(byte[] valueBuf) {
        return AudioEffect.byteArrayToShort(valueBuf, 0);
    }

    private static final short $$robo$$android_media_audiofx_AudioEffect$byteArrayToShort(byte[] valueBuf, int offset) {
        ByteBuffer converter = ByteBuffer.wrap(valueBuf);
        converter.order(ByteOrder.nativeOrder());
        return converter.getShort(offset);
    }

    private static final byte[] $$robo$$android_media_audiofx_AudioEffect$shortToByteArray(short value) {
        ByteBuffer converter = ByteBuffer.allocate(2);
        converter.order(ByteOrder.nativeOrder());
        short sValue = value;
        converter.putShort(sValue);
        return converter.array();
    }

    private static final byte[] $$robo$$android_media_audiofx_AudioEffect$concatArrays(byte[] ... arrays) {
        int len = 0;
        for (byte[] a : arrays) {
            len += a.length;
        }
        byte[] b = new byte[len];
        int offs = 0;
        for (byte[] a : arrays) {
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])a, (int)0, (byte[])b, (int)offs, (int)a.length);
            offs += a.length;
        }
        return b;
    }

    static void __staticInitializer__() {
        InvokeDynamicSupport.bootstrapIntrinsic("loadLibrary", "java.lang.System", (String)"audioeffect_jni");
        AudioEffect.native_init();
        EFFECT_TYPE_ENV_REVERB = UUID.fromString("c2e5d5f0-94bd-4763-9cac-4e234d06839e");
        EFFECT_TYPE_PRESET_REVERB = UUID.fromString("47382d60-ddd8-11db-bf3a-0002a5d5c51b");
        EFFECT_TYPE_EQUALIZER = UUID.fromString("0bed4300-ddd6-11db-8f34-0002a5d5c51b");
        EFFECT_TYPE_BASS_BOOST = UUID.fromString("0634f220-ddd4-11db-a0fc-0002a5d5c51b");
        EFFECT_TYPE_VIRTUALIZER = UUID.fromString("37cc2c00-dddd-11db-8577-0002a5d5c51b");
        EFFECT_TYPE_AGC = UUID.fromString("0a8abfe0-654c-11e0-ba26-0002a5d5c51b");
        EFFECT_TYPE_AEC = UUID.fromString("7b491460-8d4d-11e0-bd61-0002a5d5c51b");
        EFFECT_TYPE_NS = UUID.fromString("58b4b260-8e06-11e0-aa8e-0002a5d5c51b");
        EFFECT_TYPE_LOUDNESS_ENHANCER = UUID.fromString("fe3199be-aed0-413f-87bb-11260eb63cf1");
        EFFECT_TYPE_NULL = UUID.fromString("ec7178ec-e5e1-4432-a3f4-4657e6795210");
    }

    private void __constructor__(UUID uUID, UUID uUID2, int n, int n2) throws IllegalArgumentException, UnsupportedOperationException, RuntimeException {
        this.$$robo$$android_media_audiofx_AudioEffect$__constructor__(uUID, uUID2, n, n2);
    }

    public AudioEffect(UUID uUID, UUID uUID2, int n, int n2) throws IllegalArgumentException, UnsupportedOperationException, RuntimeException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiofx_AudioEffect$__constructor__(java.util.UUID java.util.UUID int int ), 0, this, uUID, uUID2, n, n2);
    }

    public void release() {
        InvokeDynamicSupport.bootstrap("release", $$robo$$android_media_audiofx_AudioEffect$release(), 0, this);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_media_audiofx_AudioEffect$finalize(), 0, this);
    }

    public Descriptor getDescriptor() throws IllegalStateException {
        return InvokeDynamicSupport.bootstrap("getDescriptor", $$robo$$android_media_audiofx_AudioEffect$getDescriptor(), 0, this);
    }

    public static Descriptor[] queryEffects() {
        return InvokeDynamicSupport.bootstrapStatic("queryEffects", $$robo$$android_media_audiofx_AudioEffect$queryEffects(), 0);
    }

    public static Descriptor[] queryPreProcessings(int n) {
        return InvokeDynamicSupport.bootstrapStatic("queryPreProcessings", $$robo$$android_media_audiofx_AudioEffect$queryPreProcessings(int ), 0, (int)n);
    }

    public static boolean isEffectTypeAvailable(UUID uUID) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isEffectTypeAvailable", $$robo$$android_media_audiofx_AudioEffect$isEffectTypeAvailable(java.util.UUID ), 0, (UUID)uUID);
    }

    public int setEnabled(boolean bl) throws IllegalStateException {
        return (int)InvokeDynamicSupport.bootstrap("setEnabled", $$robo$$android_media_audiofx_AudioEffect$setEnabled(boolean ), 0, this, bl);
    }

    public int setParameter(byte[] byArray, byte[] byArray2) throws IllegalStateException {
        return (int)InvokeDynamicSupport.bootstrap("setParameter", $$robo$$android_media_audiofx_AudioEffect$setParameter(byte[] byte[] ), 0, this, byArray, byArray2);
    }

    public int setParameter(int n, int n2) throws IllegalStateException {
        return (int)InvokeDynamicSupport.bootstrap("setParameter", $$robo$$android_media_audiofx_AudioEffect$setParameter(int int ), 0, this, n, n2);
    }

    public int setParameter(int n, short s) throws IllegalStateException {
        return (int)InvokeDynamicSupport.bootstrap("setParameter", $$robo$$android_media_audiofx_AudioEffect$setParameter(int short ), 0, this, n, s);
    }

    public int setParameter(int n, byte[] byArray) throws IllegalStateException {
        return (int)InvokeDynamicSupport.bootstrap("setParameter", $$robo$$android_media_audiofx_AudioEffect$setParameter(int byte[] ), 0, this, n, byArray);
    }

    public int setParameter(int[] nArray, int[] nArray2) throws IllegalStateException {
        return (int)InvokeDynamicSupport.bootstrap("setParameter", $$robo$$android_media_audiofx_AudioEffect$setParameter(int[] int[] ), 0, this, nArray, nArray2);
    }

    public int setParameter(int[] nArray, short[] sArray) throws IllegalStateException {
        return (int)InvokeDynamicSupport.bootstrap("setParameter", $$robo$$android_media_audiofx_AudioEffect$setParameter(int[] short[] ), 0, this, nArray, sArray);
    }

    public int setParameter(int[] nArray, byte[] byArray) throws IllegalStateException {
        return (int)InvokeDynamicSupport.bootstrap("setParameter", $$robo$$android_media_audiofx_AudioEffect$setParameter(int[] byte[] ), 0, this, nArray, byArray);
    }

    public int getParameter(byte[] byArray, byte[] byArray2) throws IllegalStateException {
        return (int)InvokeDynamicSupport.bootstrap("getParameter", $$robo$$android_media_audiofx_AudioEffect$getParameter(byte[] byte[] ), 0, this, byArray, byArray2);
    }

    public int getParameter(int n, byte[] byArray) throws IllegalStateException {
        return (int)InvokeDynamicSupport.bootstrap("getParameter", $$robo$$android_media_audiofx_AudioEffect$getParameter(int byte[] ), 0, this, n, byArray);
    }

    public int getParameter(int n, int[] nArray) throws IllegalStateException {
        return (int)InvokeDynamicSupport.bootstrap("getParameter", $$robo$$android_media_audiofx_AudioEffect$getParameter(int int[] ), 0, this, n, nArray);
    }

    public int getParameter(int n, short[] sArray) throws IllegalStateException {
        return (int)InvokeDynamicSupport.bootstrap("getParameter", $$robo$$android_media_audiofx_AudioEffect$getParameter(int short[] ), 0, this, n, sArray);
    }

    public int getParameter(int[] nArray, int[] nArray2) throws IllegalStateException {
        return (int)InvokeDynamicSupport.bootstrap("getParameter", $$robo$$android_media_audiofx_AudioEffect$getParameter(int[] int[] ), 0, this, nArray, nArray2);
    }

    public int getParameter(int[] nArray, short[] sArray) throws IllegalStateException {
        return (int)InvokeDynamicSupport.bootstrap("getParameter", $$robo$$android_media_audiofx_AudioEffect$getParameter(int[] short[] ), 0, this, nArray, sArray);
    }

    public int getParameter(int[] nArray, byte[] byArray) throws IllegalStateException {
        return (int)InvokeDynamicSupport.bootstrap("getParameter", $$robo$$android_media_audiofx_AudioEffect$getParameter(int[] byte[] ), 0, this, nArray, byArray);
    }

    public int command(int n, byte[] byArray, byte[] byArray2) throws IllegalStateException {
        return (int)InvokeDynamicSupport.bootstrap("command", $$robo$$android_media_audiofx_AudioEffect$command(int byte[] byte[] ), 0, this, n, byArray, byArray2);
    }

    public int getId() throws IllegalStateException {
        return (int)InvokeDynamicSupport.bootstrap("getId", $$robo$$android_media_audiofx_AudioEffect$getId(), 0, this);
    }

    public boolean getEnabled() throws IllegalStateException {
        return (boolean)InvokeDynamicSupport.bootstrap("getEnabled", $$robo$$android_media_audiofx_AudioEffect$getEnabled(), 0, this);
    }

    public boolean hasControl() throws IllegalStateException {
        return (boolean)InvokeDynamicSupport.bootstrap("hasControl", $$robo$$android_media_audiofx_AudioEffect$hasControl(), 0, this);
    }

    public void setEnableStatusListener(OnEnableStatusChangeListener onEnableStatusChangeListener) {
        InvokeDynamicSupport.bootstrap("setEnableStatusListener", $$robo$$android_media_audiofx_AudioEffect$setEnableStatusListener(android.media.audiofx.AudioEffect$OnEnableStatusChangeListener ), 0, this, onEnableStatusChangeListener);
    }

    public void setControlStatusListener(OnControlStatusChangeListener onControlStatusChangeListener) {
        InvokeDynamicSupport.bootstrap("setControlStatusListener", $$robo$$android_media_audiofx_AudioEffect$setControlStatusListener(android.media.audiofx.AudioEffect$OnControlStatusChangeListener ), 0, this, onControlStatusChangeListener);
    }

    public void setParameterListener(OnParameterChangeListener onParameterChangeListener) {
        InvokeDynamicSupport.bootstrap("setParameterListener", $$robo$$android_media_audiofx_AudioEffect$setParameterListener(android.media.audiofx.AudioEffect$OnParameterChangeListener ), 0, this, onParameterChangeListener);
    }

    private void createNativeEventHandler() {
        InvokeDynamicSupport.bootstrap("createNativeEventHandler", $$robo$$android_media_audiofx_AudioEffect$createNativeEventHandler(), 0, this);
    }

    private static void postEventFromNative(Object object, int n, int n2, int n3, Object object2) {
        InvokeDynamicSupport.bootstrapStatic("postEventFromNative", $$robo$$android_media_audiofx_AudioEffect$postEventFromNative(java.lang.Object int int int java.lang.Object ), 0, (Object)object, (int)n, (int)n2, (int)n3, (Object)object2);
    }

    private static final native /* synthetic */ void $$robo$$native_init$nativeBinding();

    private static void native_init() {
        InvokeDynamicSupport.bootstrapStatic("native_init", $$robo$$android_media_audiofx_AudioEffect$native_init(), 1);
    }

    private final native /* synthetic */ int $$robo$$native_setup$nativeBinding(Object var1, String var2, String var3, int var4, int var5, int[] var6, Object[] var7, String var8);

    private int native_setup(Object object, String string2, String string3, int n, int n2, int[] nArray, Object[] objectArray, String string4) {
        return (int)InvokeDynamicSupport.bootstrap("native_setup", $$robo$$android_media_audiofx_AudioEffect$native_setup(java.lang.Object java.lang.String java.lang.String int int int[] java.lang.Object[] java.lang.String ), 1, this, object, string2, string3, n, n2, nArray, objectArray, string4);
    }

    private final native /* synthetic */ void $$robo$$native_finalize$nativeBinding();

    private void native_finalize() {
        InvokeDynamicSupport.bootstrap("native_finalize", $$robo$$android_media_audiofx_AudioEffect$native_finalize(), 1, this);
    }

    private final native /* synthetic */ void $$robo$$native_release$nativeBinding();

    private void native_release() {
        InvokeDynamicSupport.bootstrap("native_release", $$robo$$android_media_audiofx_AudioEffect$native_release(), 1, this);
    }

    private final native /* synthetic */ int $$robo$$native_setEnabled$nativeBinding(boolean var1);

    private int native_setEnabled(boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("native_setEnabled", $$robo$$android_media_audiofx_AudioEffect$native_setEnabled(boolean ), 1, this, bl);
    }

    private final native /* synthetic */ boolean $$robo$$native_getEnabled$nativeBinding();

    private boolean native_getEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("native_getEnabled", $$robo$$android_media_audiofx_AudioEffect$native_getEnabled(), 1, this);
    }

    private final native /* synthetic */ boolean $$robo$$native_hasControl$nativeBinding();

    private boolean native_hasControl() {
        return (boolean)InvokeDynamicSupport.bootstrap("native_hasControl", $$robo$$android_media_audiofx_AudioEffect$native_hasControl(), 1, this);
    }

    private final native /* synthetic */ int $$robo$$native_setParameter$nativeBinding(int var1, byte[] var2, int var3, byte[] var4);

    private int native_setParameter(int n, byte[] byArray, int n2, byte[] byArray2) {
        return (int)InvokeDynamicSupport.bootstrap("native_setParameter", $$robo$$android_media_audiofx_AudioEffect$native_setParameter(int byte[] int byte[] ), 1, this, n, byArray, n2, byArray2);
    }

    private final native /* synthetic */ int $$robo$$native_getParameter$nativeBinding(int var1, byte[] var2, int var3, byte[] var4);

    private int native_getParameter(int n, byte[] byArray, int n2, byte[] byArray2) {
        return (int)InvokeDynamicSupport.bootstrap("native_getParameter", $$robo$$android_media_audiofx_AudioEffect$native_getParameter(int byte[] int byte[] ), 1, this, n, byArray, n2, byArray2);
    }

    private final native /* synthetic */ int $$robo$$native_command$nativeBinding(int var1, int var2, byte[] var3, int var4, byte[] var5);

    private int native_command(int n, int n2, byte[] byArray, int n3, byte[] byArray2) {
        return (int)InvokeDynamicSupport.bootstrap("native_command", $$robo$$android_media_audiofx_AudioEffect$native_command(int int byte[] int byte[] ), 1, this, n, n2, byArray, n3, byArray2);
    }

    private static final native /* synthetic */ Object[] $$robo$$native_query_effects$nativeBinding();

    private static Object[] native_query_effects() {
        return InvokeDynamicSupport.bootstrapStatic("native_query_effects", $$robo$$android_media_audiofx_AudioEffect$native_query_effects(), 1);
    }

    private static final native /* synthetic */ Object[] $$robo$$native_query_pre_processing$nativeBinding(int var0);

    private static Object[] native_query_pre_processing(int n) {
        return InvokeDynamicSupport.bootstrapStatic("native_query_pre_processing", $$robo$$android_media_audiofx_AudioEffect$native_query_pre_processing(int ), 1, (int)n);
    }

    public void checkState(String string2) throws IllegalStateException {
        InvokeDynamicSupport.bootstrap("checkState", $$robo$$android_media_audiofx_AudioEffect$checkState(java.lang.String ), 0, this, string2);
    }

    public void checkStatus(int n) {
        InvokeDynamicSupport.bootstrap("checkStatus", $$robo$$android_media_audiofx_AudioEffect$checkStatus(int ), 0, this, n);
    }

    public static boolean isError(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isError", $$robo$$android_media_audiofx_AudioEffect$isError(int ), 0, (int)n);
    }

    public static int byteArrayToInt(byte[] byArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("byteArrayToInt", $$robo$$android_media_audiofx_AudioEffect$byteArrayToInt(byte[] ), 0, (byte[])byArray);
    }

    public static int byteArrayToInt(byte[] byArray, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("byteArrayToInt", $$robo$$android_media_audiofx_AudioEffect$byteArrayToInt(byte[] int ), 0, (byte[])byArray, (int)n);
    }

    public static byte[] intToByteArray(int n) {
        return InvokeDynamicSupport.bootstrapStatic("intToByteArray", $$robo$$android_media_audiofx_AudioEffect$intToByteArray(int ), 0, (int)n);
    }

    public static short byteArrayToShort(byte[] byArray) {
        return (short)InvokeDynamicSupport.bootstrapStatic("byteArrayToShort", $$robo$$android_media_audiofx_AudioEffect$byteArrayToShort(byte[] ), 0, (byte[])byArray);
    }

    public static short byteArrayToShort(byte[] byArray, int n) {
        return (short)InvokeDynamicSupport.bootstrapStatic("byteArrayToShort", $$robo$$android_media_audiofx_AudioEffect$byteArrayToShort(byte[] int ), 0, (byte[])byArray, (int)n);
    }

    public static byte[] shortToByteArray(short s) {
        return InvokeDynamicSupport.bootstrapStatic("shortToByteArray", $$robo$$android_media_audiofx_AudioEffect$shortToByteArray(short ), 0, (short)s);
    }

    public static byte[] concatArrays(byte[] ... byArray) {
        return InvokeDynamicSupport.bootstrapStatic("concatArrays", $$robo$$android_media_audiofx_AudioEffect$concatArrays(byte[][] ), 0, (byte[][])byArray);
    }

    static {
        RobolectricInternals.classInitializing(AudioEffect.class);
    }

    public /* synthetic */ AudioEffect() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AudioEffect)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class NativeEventHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private AudioEffect mAudioEffect;
        /* synthetic */ AudioEffect this$0;

        private void $$robo$$android_media_audiofx_AudioEffect_NativeEventHandler$__constructor__(AudioEffect audioEffect, AudioEffect ae, Looper looper) {
            this.mAudioEffect = ae;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_audiofx_AudioEffect_NativeEventHandler$handleMessage(Message msg) {
            if (this.mAudioEffect == null) {
                return;
            }
            switch (msg.what) {
                case 1: {
                    OnEnableStatusChangeListener enableStatusChangeListener = null;
                    Object object = this.this$0.mListenerLock;
                    synchronized (object) {
                        enableStatusChangeListener = this.mAudioEffect.mEnableStatusChangeListener;
                    }
                    if (enableStatusChangeListener == null) break;
                    enableStatusChangeListener.onEnableStatusChange(this.mAudioEffect, msg.arg1 != 0);
                    break;
                }
                case 0: {
                    OnControlStatusChangeListener controlStatusChangeListener = null;
                    Object object = this.this$0.mListenerLock;
                    synchronized (object) {
                        controlStatusChangeListener = this.mAudioEffect.mControlChangeStatusListener;
                    }
                    if (controlStatusChangeListener == null) break;
                    controlStatusChangeListener.onControlStatusChange(this.mAudioEffect, msg.arg1 != 0);
                    break;
                }
                case 2: {
                    OnParameterChangeListener parameterChangeListener = null;
                    Object object = this.this$0.mListenerLock;
                    synchronized (object) {
                        parameterChangeListener = this.mAudioEffect.mParameterChangeListener;
                    }
                    if (parameterChangeListener == null) break;
                    int vOffset = msg.arg1;
                    byte[] p = (byte[])msg.obj;
                    int status = AudioEffect.byteArrayToInt(p, 0);
                    int psize = AudioEffect.byteArrayToInt(p, 4);
                    int vsize = AudioEffect.byteArrayToInt(p, 8);
                    byte[] param = new byte[psize];
                    byte[] value = new byte[vsize];
                    InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])p, (int)12, (byte[])param, (int)0, (int)psize);
                    InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])p, (int)vOffset, (byte[])value, (int)0, (int)vsize);
                    parameterChangeListener.onParameterChange(this.mAudioEffect, status, param, value);
                    break;
                }
                default: {
                    Log.e("AudioEffect-JAVA", "handleMessage() Unknown event type: " + msg.what);
                }
            }
        }

        private void __constructor__(AudioEffect audioEffect, AudioEffect audioEffect2, Looper looper) {
            this.$$robo$$android_media_audiofx_AudioEffect_NativeEventHandler$__constructor__(audioEffect, audioEffect2, looper);
        }

        public NativeEventHandler(AudioEffect audioEffect, AudioEffect audioEffect2, Looper looper) {
            this.this$0 = audioEffect;
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiofx_AudioEffect_NativeEventHandler$__constructor__(android.media.audiofx.AudioEffect android.media.audiofx.AudioEffect android.os.Looper ), 0, this, audioEffect, audioEffect2, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_media_audiofx_AudioEffect_NativeEventHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ NativeEventHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NativeEventHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnParameterChangeListener
    extends InstrumentedInterface {
        public void onParameterChange(AudioEffect var1, int var2, byte[] var3, byte[] var4);
    }

    public static interface OnControlStatusChangeListener
    extends InstrumentedInterface {
        public void onControlStatusChange(AudioEffect var1, boolean var2);
    }

    public static interface OnEnableStatusChangeListener
    extends InstrumentedInterface {
        public void onEnableStatusChange(AudioEffect var1, boolean var2);
    }

    public static class Descriptor
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public UUID type;
        public UUID uuid;
        public String connectMode;
        public String name;
        public String implementor;

        private void $$robo$$android_media_audiofx_AudioEffect_Descriptor$__constructor__() {
        }

        private void $$robo$$android_media_audiofx_AudioEffect_Descriptor$__constructor__(String type, String uuid, String connectMode, String name, String implementor) {
            this.type = UUID.fromString(type);
            this.uuid = UUID.fromString(uuid);
            this.connectMode = connectMode;
            this.name = name;
            this.implementor = implementor;
        }

        private void __constructor__() {
            this.$$robo$$android_media_audiofx_AudioEffect_Descriptor$__constructor__();
        }

        public Descriptor() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiofx_AudioEffect_Descriptor$__constructor__(), 0, this);
        }

        private void __constructor__(String string2, String string3, String string4, String string5, String string6) {
            this.$$robo$$android_media_audiofx_AudioEffect_Descriptor$__constructor__(string2, string3, string4, string5, string6);
        }

        public Descriptor(String string2, String string3, String string4, String string5, String string6) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiofx_AudioEffect_Descriptor$__constructor__(java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String ), 0, this, string2, string3, string4, string5, string6);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Descriptor)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

