/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.graphics.Canvas;
import android.media.MediaFormat;
import android.media.MediaTimeProvider;
import android.media.SubtitleData;
import android.os.Handler;
import android.util.Log;
import android.util.LongSparseArray;
import android.util.Pair;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class SubtitleTrack
implements MediaTimeProvider.OnMediaTimeListener,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "SubtitleTrack";
    private long mLastUpdateTimeMs;
    private long mLastTimeMs;
    private Runnable mRunnable;
    protected LongSparseArray<Run> mRunsByEndTime;
    protected LongSparseArray<Run> mRunsByID;
    protected CueList mCues;
    protected Vector<Cue> mActiveCues;
    protected boolean mVisible;
    public boolean DEBUG;
    protected Handler mHandler;
    private MediaFormat mFormat;
    private long mNextScheduledTimeMs;
    protected MediaTimeProvider mTimeProvider;

    private void $$robo$$android_media_SubtitleTrack$__constructor__(MediaFormat format) {
        this.mRunsByEndTime = new LongSparseArray();
        this.mRunsByID = new LongSparseArray();
        this.mActiveCues = new Vector();
        this.DEBUG = false;
        this.mHandler = new Handler();
        this.mNextScheduledTimeMs = -1L;
        this.mFormat = format;
        this.mCues = new CueList();
        this.clearActiveCues();
        this.mLastTimeMs = -1L;
    }

    private final MediaFormat $$robo$$android_media_SubtitleTrack$getFormat() {
        return this.mFormat;
    }

    private final void $$robo$$android_media_SubtitleTrack$onData(SubtitleData data) {
        long runID = data.getStartTimeUs() + 1L;
        this.onData(data.getData(), true, runID);
        this.setRunDiscardTimeMs(runID, (data.getStartTimeUs() + data.getDurationUs()) / 1000L);
    }

    public abstract void onData(byte[] var1, boolean var2, long var3);

    public abstract RenderingWidget getRenderingWidget();

    public abstract void updateView(Vector<Cue> var1);

    private final synchronized void $$robo$$android_media_SubtitleTrack$updateActiveCues(boolean rebuild, long timeMs) {
        if (rebuild || this.mLastUpdateTimeMs > timeMs) {
            this.clearActiveCues();
        }
        Iterator<Pair<Long, Cue>> it = this.mCues.entriesBetween(this.mLastUpdateTimeMs, timeMs).iterator();
        while (it.hasNext()) {
            Pair<Long, Cue> event = it.next();
            Cue cue = (Cue)event.second;
            if (cue.mEndTimeMs == (Long)event.first) {
                if (this.DEBUG) {
                    Log.v("SubtitleTrack", "Removing " + cue);
                }
                this.mActiveCues.remove(cue);
                if (cue.mRunID != 0L) continue;
                it.remove();
                continue;
            }
            if (cue.mStartTimeMs == (Long)event.first) {
                if (this.DEBUG) {
                    Log.v("SubtitleTrack", "Adding " + cue);
                }
                if (cue.mInnerTimesMs != null) {
                    cue.onTime(timeMs);
                }
                this.mActiveCues.add(cue);
                continue;
            }
            if (cue.mInnerTimesMs == null) continue;
            cue.onTime(timeMs);
        }
        while (this.mRunsByEndTime.size() > 0 && this.mRunsByEndTime.keyAt(0) <= timeMs) {
            this.removeRunsByEndTimeIndex(0);
        }
        this.mLastUpdateTimeMs = timeMs;
    }

    private final void $$robo$$android_media_SubtitleTrack$removeRunsByEndTimeIndex(int ix) {
        Run run = this.mRunsByEndTime.valueAt(ix);
        while (run != null) {
            Cue cue = run.mFirstCue;
            while (cue != null) {
                this.mCues.remove(cue);
                Cue nextCue = cue.mNextInRun;
                cue.mNextInRun = null;
                cue = nextCue;
            }
            this.mRunsByID.remove(run.mRunID);
            Run nextRun = run.mNextRunAtEndTimeMs;
            run.mPrevRunAtEndTimeMs = null;
            run.mNextRunAtEndTimeMs = null;
            run = nextRun;
        }
        this.mRunsByEndTime.removeAt(ix);
    }

    private final void $$robo$$android_media_SubtitleTrack$finalize() throws Throwable {
        int size = this.mRunsByEndTime.size();
        for (int ix = size - 1; ix >= 0; --ix) {
            this.removeRunsByEndTimeIndex(ix);
        }
        super.finalize();
    }

    private final synchronized void $$robo$$android_media_SubtitleTrack$takeTime(long timeMs) {
        this.mLastTimeMs = timeMs;
    }

    private final synchronized void $$robo$$android_media_SubtitleTrack$clearActiveCues() {
        if (this.DEBUG) {
            Log.v("SubtitleTrack", "Clearing " + this.mActiveCues.size() + " active cues");
        }
        this.mActiveCues.clear();
        this.mLastUpdateTimeMs = -1L;
    }

    private final void $$robo$$android_media_SubtitleTrack$scheduleTimedEvents() {
        if (this.mTimeProvider != null) {
            this.mNextScheduledTimeMs = this.mCues.nextTimeAfter(this.mLastTimeMs);
            if (this.DEBUG) {
                Log.d("SubtitleTrack", "sched @" + this.mNextScheduledTimeMs + " after " + this.mLastTimeMs);
            }
            this.mTimeProvider.notifyAt(this.mNextScheduledTimeMs >= 0L ? this.mNextScheduledTimeMs * 1000L : -1L, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_SubtitleTrack$onTimedEvent(long timeUs) {
        if (this.DEBUG) {
            Log.d("SubtitleTrack", "onTimedEvent " + timeUs);
        }
        SubtitleTrack subtitleTrack = this;
        synchronized (subtitleTrack) {
            long timeMs = timeUs / 1000L;
            this.updateActiveCues(false, timeMs);
            this.takeTime(timeMs);
        }
        this.updateView(this.mActiveCues);
        this.scheduleTimedEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_SubtitleTrack$onSeek(long timeUs) {
        if (this.DEBUG) {
            Log.d("SubtitleTrack", "onSeek " + timeUs);
        }
        SubtitleTrack subtitleTrack = this;
        synchronized (subtitleTrack) {
            long timeMs = timeUs / 1000L;
            this.updateActiveCues(true, timeMs);
            this.takeTime(timeMs);
        }
        this.updateView(this.mActiveCues);
        this.scheduleTimedEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_SubtitleTrack$onStop() {
        SubtitleTrack subtitleTrack = this;
        synchronized (subtitleTrack) {
            if (this.DEBUG) {
                Log.d("SubtitleTrack", "onStop");
            }
            this.clearActiveCues();
            this.mLastTimeMs = -1L;
        }
        this.updateView(this.mActiveCues);
        this.mNextScheduledTimeMs = -1L;
        this.mTimeProvider.notifyAt(-1L, this);
    }

    private final void $$robo$$android_media_SubtitleTrack$show() {
        if (this.mVisible) {
            return;
        }
        this.mVisible = true;
        RenderingWidget renderingWidget = this.getRenderingWidget();
        if (renderingWidget != null) {
            renderingWidget.setVisible(true);
        }
        if (this.mTimeProvider != null) {
            this.mTimeProvider.scheduleUpdate(this);
        }
    }

    private final void $$robo$$android_media_SubtitleTrack$hide() {
        RenderingWidget renderingWidget;
        if (!this.mVisible) {
            return;
        }
        if (this.mTimeProvider != null) {
            this.mTimeProvider.cancelNotifications(this);
        }
        if ((renderingWidget = this.getRenderingWidget()) != null) {
            renderingWidget.setVisible(false);
        }
        this.mVisible = false;
    }

    private final synchronized boolean $$robo$$android_media_SubtitleTrack$addCue(Cue cue) {
        this.mCues.add(cue);
        if (cue.mRunID != 0L) {
            Run run = this.mRunsByID.get(cue.mRunID);
            if (run == null) {
                run = new Run();
                this.mRunsByID.put(cue.mRunID, run);
                run.mEndTimeMs = cue.mEndTimeMs;
            } else if (run.mEndTimeMs < cue.mEndTimeMs) {
                run.mEndTimeMs = cue.mEndTimeMs;
            }
            cue.mNextInRun = run.mFirstCue;
            run.mFirstCue = cue;
        }
        long nowMs = -1L;
        if (this.mTimeProvider != null) {
            try {
                nowMs = this.mTimeProvider.getCurrentTimeUs(false, true) / 1000L;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        if (this.DEBUG) {
            Log.v("SubtitleTrack", "mVisible=" + this.mVisible + ", " + cue.mStartTimeMs + " <= " + nowMs + ", " + cue.mEndTimeMs + " >= " + this.mLastTimeMs);
        }
        if (this.mVisible && cue.mStartTimeMs <= nowMs && cue.mEndTimeMs >= this.mLastTimeMs) {
            if (this.mRunnable != null) {
                this.mHandler.removeCallbacks(this.mRunnable);
            }
            SubtitleTrack track = this;
            long thenMs = nowMs;
            this.mRunnable = new Runnable(this, track, thenMs){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ SubtitleTrack val$track;
                /* synthetic */ long val$thenMs;
                /* synthetic */ SubtitleTrack this$0;

                private void $$robo$$android_media_SubtitleTrack_1$__constructor__(SubtitleTrack this$0, SubtitleTrack subtitleTrack, long l) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private final void $$robo$$android_media_SubtitleTrack_1$run() {
                    SubtitleTrack subtitleTrack = this.val$track;
                    synchronized (subtitleTrack) {
                        this.this$0.mRunnable = null;
                        this.this$0.updateActiveCues(true, this.val$thenMs);
                        this.this$0.updateView(this.this$0.mActiveCues);
                    }
                }

                private void __constructor__(SubtitleTrack subtitleTrack, SubtitleTrack subtitleTrack2, long l) {
                    this.$$robo$$android_media_SubtitleTrack_1$__constructor__(subtitleTrack, subtitleTrack2, l);
                }
                {
                    this.this$0 = subtitleTrack;
                    this.val$track = subtitleTrack2;
                    this.val$thenMs = l;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_SubtitleTrack_1$__constructor__(android.media.SubtitleTrack android.media.SubtitleTrack long ), 0, this, subtitleTrack, subtitleTrack2, l);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_SubtitleTrack_1$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            if (this.mHandler.postDelayed(this.mRunnable, 10L)) {
                if (this.DEBUG) {
                    Log.v("SubtitleTrack", "scheduling update");
                }
            } else if (this.DEBUG) {
                Log.w("SubtitleTrack", "failed to schedule subtitle view update");
            }
            return true;
        }
        if (this.mVisible && cue.mEndTimeMs >= this.mLastTimeMs && (cue.mStartTimeMs < this.mNextScheduledTimeMs || this.mNextScheduledTimeMs < 0L)) {
            this.scheduleTimedEvents();
        }
        return false;
    }

    private final synchronized void $$robo$$android_media_SubtitleTrack$setTimeProvider(MediaTimeProvider timeProvider) {
        if (this.mTimeProvider == timeProvider) {
            return;
        }
        if (this.mTimeProvider != null) {
            this.mTimeProvider.cancelNotifications(this);
        }
        this.mTimeProvider = timeProvider;
        if (this.mTimeProvider != null) {
            this.mTimeProvider.scheduleUpdate(this);
        }
    }

    private final void $$robo$$android_media_SubtitleTrack$finishedRun(long runID) {
        Run run;
        if (runID != 0L && runID != -1L && (run = this.mRunsByID.get(runID)) != null) {
            run.storeByEndTimeMs(this.mRunsByEndTime);
        }
    }

    private final void $$robo$$android_media_SubtitleTrack$setRunDiscardTimeMs(long runID, long timeMs) {
        Run run;
        if (runID != 0L && runID != -1L && (run = this.mRunsByID.get(runID)) != null) {
            run.mEndTimeMs = timeMs;
            run.storeByEndTimeMs(this.mRunsByEndTime);
        }
    }

    private final int $$robo$$android_media_SubtitleTrack$getTrackType() {
        return this.getRenderingWidget() == null ? 3 : 4;
    }

    private void __constructor__(MediaFormat mediaFormat) {
        this.$$robo$$android_media_SubtitleTrack$__constructor__(mediaFormat);
    }

    public SubtitleTrack(MediaFormat mediaFormat) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_SubtitleTrack$__constructor__(android.media.MediaFormat ), 0, this, mediaFormat);
    }

    public MediaFormat getFormat() {
        return InvokeDynamicSupport.bootstrap("getFormat", $$robo$$android_media_SubtitleTrack$getFormat(), 0, this);
    }

    protected void onData(SubtitleData subtitleData) {
        InvokeDynamicSupport.bootstrap("onData", $$robo$$android_media_SubtitleTrack$onData(android.media.SubtitleData ), 0, this, subtitleData);
    }

    protected synchronized void updateActiveCues(boolean bl, long l) {
        InvokeDynamicSupport.bootstrap("updateActiveCues", $$robo$$android_media_SubtitleTrack$updateActiveCues(boolean long ), 0, this, bl, l);
    }

    private void removeRunsByEndTimeIndex(int n) {
        InvokeDynamicSupport.bootstrap("removeRunsByEndTimeIndex", $$robo$$android_media_SubtitleTrack$removeRunsByEndTimeIndex(int ), 0, this, n);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_media_SubtitleTrack$finalize(), 0, this);
    }

    private synchronized void takeTime(long l) {
        InvokeDynamicSupport.bootstrap("takeTime", $$robo$$android_media_SubtitleTrack$takeTime(long ), 0, this, l);
    }

    protected synchronized void clearActiveCues() {
        InvokeDynamicSupport.bootstrap("clearActiveCues", $$robo$$android_media_SubtitleTrack$clearActiveCues(), 0, this);
    }

    protected void scheduleTimedEvents() {
        InvokeDynamicSupport.bootstrap("scheduleTimedEvents", $$robo$$android_media_SubtitleTrack$scheduleTimedEvents(), 0, this);
    }

    @Override
    public void onTimedEvent(long l) {
        InvokeDynamicSupport.bootstrap("onTimedEvent", $$robo$$android_media_SubtitleTrack$onTimedEvent(long ), 0, this, l);
    }

    @Override
    public void onSeek(long l) {
        InvokeDynamicSupport.bootstrap("onSeek", $$robo$$android_media_SubtitleTrack$onSeek(long ), 0, this, l);
    }

    @Override
    public void onStop() {
        InvokeDynamicSupport.bootstrap("onStop", $$robo$$android_media_SubtitleTrack$onStop(), 0, this);
    }

    public void show() {
        InvokeDynamicSupport.bootstrap("show", $$robo$$android_media_SubtitleTrack$show(), 0, this);
    }

    public void hide() {
        InvokeDynamicSupport.bootstrap("hide", $$robo$$android_media_SubtitleTrack$hide(), 0, this);
    }

    protected synchronized boolean addCue(Cue cue) {
        return (boolean)InvokeDynamicSupport.bootstrap("addCue", $$robo$$android_media_SubtitleTrack$addCue(android.media.SubtitleTrack$Cue ), 0, this, cue);
    }

    public synchronized void setTimeProvider(MediaTimeProvider mediaTimeProvider) {
        InvokeDynamicSupport.bootstrap("setTimeProvider", $$robo$$android_media_SubtitleTrack$setTimeProvider(android.media.MediaTimeProvider ), 0, this, mediaTimeProvider);
    }

    protected void finishedRun(long l) {
        InvokeDynamicSupport.bootstrap("finishedRun", $$robo$$android_media_SubtitleTrack$finishedRun(long ), 0, this, l);
    }

    public void setRunDiscardTimeMs(long l, long l2) {
        InvokeDynamicSupport.bootstrap("setRunDiscardTimeMs", $$robo$$android_media_SubtitleTrack$setRunDiscardTimeMs(long long ), 0, this, l, l2);
    }

    public int getTrackType() {
        return (int)InvokeDynamicSupport.bootstrap("getTrackType", $$robo$$android_media_SubtitleTrack$getTrackType(), 0, this);
    }

    public /* synthetic */ SubtitleTrack() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SubtitleTrack)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface RenderingWidget
    extends InstrumentedInterface {
        public void setOnChangedListener(OnChangedListener var1);

        public void setSize(int var1, int var2);

        public void setVisible(boolean var1);

        public void draw(Canvas var1);

        public void onAttachedToWindow();

        public void onDetachedFromWindow();

        public static interface OnChangedListener
        extends InstrumentedInterface {
            public void onChanged(RenderingWidget var1);
        }
    }

    private static class Run
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public Cue mFirstCue;
        public Run mNextRunAtEndTimeMs;
        public Run mPrevRunAtEndTimeMs;
        public long mEndTimeMs;
        public long mRunID;
        private long mStoredEndTimeMs;
        static /* synthetic */ boolean $assertionsDisabled;

        private void $$robo$$android_media_SubtitleTrack_Run$__constructor__() {
            this.mEndTimeMs = -1L;
            this.mRunID = 0L;
            this.mStoredEndTimeMs = -1L;
        }

        private final void $$robo$$android_media_SubtitleTrack_Run$storeByEndTimeMs(LongSparseArray<Run> runsByEndTime) {
            int ix = runsByEndTime.indexOfKey(this.mStoredEndTimeMs);
            if (ix >= 0) {
                if (this.mPrevRunAtEndTimeMs == null) {
                    if (!$assertionsDisabled && this != runsByEndTime.valueAt(ix)) {
                        throw new AssertionError();
                    }
                    if (this.mNextRunAtEndTimeMs == null) {
                        runsByEndTime.removeAt(ix);
                    } else {
                        runsByEndTime.setValueAt(ix, this.mNextRunAtEndTimeMs);
                    }
                }
                this.removeAtEndTimeMs();
            }
            if (this.mEndTimeMs >= 0L) {
                this.mPrevRunAtEndTimeMs = null;
                this.mNextRunAtEndTimeMs = runsByEndTime.get(this.mEndTimeMs);
                if (this.mNextRunAtEndTimeMs != null) {
                    this.mNextRunAtEndTimeMs.mPrevRunAtEndTimeMs = this;
                }
                runsByEndTime.put(this.mEndTimeMs, this);
                this.mStoredEndTimeMs = this.mEndTimeMs;
            }
        }

        private final void $$robo$$android_media_SubtitleTrack_Run$removeAtEndTimeMs() {
            Run prev = this.mPrevRunAtEndTimeMs;
            if (this.mPrevRunAtEndTimeMs != null) {
                this.mPrevRunAtEndTimeMs.mNextRunAtEndTimeMs = this.mNextRunAtEndTimeMs;
                this.mPrevRunAtEndTimeMs = null;
            }
            if (this.mNextRunAtEndTimeMs != null) {
                this.mNextRunAtEndTimeMs.mPrevRunAtEndTimeMs = prev;
                this.mNextRunAtEndTimeMs = null;
            }
        }

        private /* synthetic */ void $$robo$$android_media_SubtitleTrack_Run$__constructor__(1 x0) {
        }

        static void __staticInitializer__() {
            $assertionsDisabled = !SubtitleTrack.class.desiredAssertionStatus();
        }

        private void __constructor__() {
            this.$$robo$$android_media_SubtitleTrack_Run$__constructor__();
        }

        private Run() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_SubtitleTrack_Run$__constructor__(), 0, this);
        }

        public void storeByEndTimeMs(LongSparseArray<Run> longSparseArray) {
            InvokeDynamicSupport.bootstrap("storeByEndTimeMs", $$robo$$android_media_SubtitleTrack_Run$storeByEndTimeMs(android.util.LongSparseArray<android.media.SubtitleTrack$Run> ), 0, this, longSparseArray);
        }

        public void removeAtEndTimeMs() {
            InvokeDynamicSupport.bootstrap("removeAtEndTimeMs", $$robo$$android_media_SubtitleTrack_Run$removeAtEndTimeMs(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_media_SubtitleTrack_Run$__constructor__(var1_1);
        }

        static {
            RobolectricInternals.classInitializing(Run.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Run)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Cue
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public long mStartTimeMs;
        public long mEndTimeMs;
        public long[] mInnerTimesMs;
        public long mRunID;
        public Cue mNextInRun;

        private void $$robo$$android_media_SubtitleTrack_Cue$__constructor__() {
        }

        private final void $$robo$$android_media_SubtitleTrack_Cue$onTime(long timeMs) {
        }

        private void __constructor__() {
            this.$$robo$$android_media_SubtitleTrack_Cue$__constructor__();
        }

        public Cue() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_SubtitleTrack_Cue$__constructor__(), 0, this);
        }

        public void onTime(long l) {
            InvokeDynamicSupport.bootstrap("onTime", $$robo$$android_media_SubtitleTrack_Cue$onTime(long ), 0, this, l);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Cue)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class CueList
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static String TAG = "CueList";
        private SortedMap<Long, Vector<Cue>> mCues;
        public boolean DEBUG;

        private final boolean $$robo$$android_media_SubtitleTrack_CueList$addEvent(Cue cue, long timeMs) {
            Vector<Cue> cues = (Vector<Cue>)this.mCues.get(timeMs);
            if (cues == null) {
                cues = new Vector<Cue>(2);
                this.mCues.put(timeMs, cues);
            } else if (cues.contains(cue)) {
                return false;
            }
            cues.add(cue);
            return true;
        }

        private final void $$robo$$android_media_SubtitleTrack_CueList$removeEvent(Cue cue, long timeMs) {
            Vector cues = (Vector)this.mCues.get(timeMs);
            if (cues != null) {
                cues.remove(cue);
                if (cues.size() == 0) {
                    this.mCues.remove(timeMs);
                }
            }
        }

        private final void $$robo$$android_media_SubtitleTrack_CueList$add(Cue cue) {
            if (cue.mStartTimeMs >= cue.mEndTimeMs) {
                return;
            }
            if (!this.addEvent(cue, cue.mStartTimeMs)) {
                return;
            }
            long lastTimeMs = cue.mStartTimeMs;
            if (cue.mInnerTimesMs != null) {
                for (long timeMs : cue.mInnerTimesMs) {
                    if (timeMs <= lastTimeMs || timeMs >= cue.mEndTimeMs) continue;
                    this.addEvent(cue, timeMs);
                    lastTimeMs = timeMs;
                }
            }
            this.addEvent(cue, cue.mEndTimeMs);
        }

        private final void $$robo$$android_media_SubtitleTrack_CueList$remove(Cue cue) {
            this.removeEvent(cue, cue.mStartTimeMs);
            if (cue.mInnerTimesMs != null) {
                for (long timeMs : cue.mInnerTimesMs) {
                    this.removeEvent(cue, timeMs);
                }
            }
            this.removeEvent(cue, cue.mEndTimeMs);
        }

        private final Iterable<Pair<Long, Cue>> $$robo$$android_media_SubtitleTrack_CueList$entriesBetween(long lastTimeMs, long timeMs) {
            return new Iterable<Pair<Long, Cue>>(this, lastTimeMs, timeMs){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ long val$lastTimeMs;
                /* synthetic */ long val$timeMs;
                /* synthetic */ CueList this$0;

                private void $$robo$$android_media_SubtitleTrack_CueList_1$__constructor__(CueList this$0, long l, long l2) {
                }

                private final Iterator<Pair<Long, Cue>> $$robo$$android_media_SubtitleTrack_CueList_1$iterator() {
                    if (this.this$0.DEBUG) {
                        Log.d("CueList", "slice (" + this.val$lastTimeMs + ", " + this.val$timeMs + "]=");
                    }
                    try {
                        return new EntryIterator(this.this$0, this.this$0.mCues.subMap(this.val$lastTimeMs + 1L, this.val$timeMs + 1L));
                    }
                    catch (IllegalArgumentException e) {
                        return new EntryIterator(this.this$0, null);
                    }
                }

                private void __constructor__(CueList cueList, long l, long l2) {
                    this.$$robo$$android_media_SubtitleTrack_CueList_1$__constructor__(cueList, l, l2);
                }
                {
                    this.this$0 = cueList;
                    this.val$lastTimeMs = l;
                    this.val$timeMs = l2;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_SubtitleTrack_CueList_1$__constructor__(android.media.SubtitleTrack$CueList long long ), 0, this, cueList, l, l2);
                }

                @Override
                public Iterator<Pair<Long, Cue>> iterator() {
                    return InvokeDynamicSupport.bootstrap("iterator", $$robo$$android_media_SubtitleTrack_CueList_1$iterator(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private final long $$robo$$android_media_SubtitleTrack_CueList$nextTimeAfter(long timeMs) {
            SortedMap<Long, Vector<Cue>> tail = null;
            try {
                tail = this.mCues.tailMap(timeMs + 1L);
                if (tail != null) {
                    return tail.firstKey();
                }
                return -1L;
            }
            catch (IllegalArgumentException e) {
                return -1L;
            }
            catch (NoSuchElementException e) {
                return -1L;
            }
        }

        private void $$robo$$android_media_SubtitleTrack_CueList$__constructor__() {
            this.DEBUG = false;
            this.mCues = new TreeMap<Long, Vector<Cue>>();
        }

        private boolean addEvent(Cue cue, long l) {
            return (boolean)InvokeDynamicSupport.bootstrap("addEvent", $$robo$$android_media_SubtitleTrack_CueList$addEvent(android.media.SubtitleTrack$Cue long ), 0, this, cue, l);
        }

        private void removeEvent(Cue cue, long l) {
            InvokeDynamicSupport.bootstrap("removeEvent", $$robo$$android_media_SubtitleTrack_CueList$removeEvent(android.media.SubtitleTrack$Cue long ), 0, this, cue, l);
        }

        public void add(Cue cue) {
            InvokeDynamicSupport.bootstrap("add", $$robo$$android_media_SubtitleTrack_CueList$add(android.media.SubtitleTrack$Cue ), 0, this, cue);
        }

        public void remove(Cue cue) {
            InvokeDynamicSupport.bootstrap("remove", $$robo$$android_media_SubtitleTrack_CueList$remove(android.media.SubtitleTrack$Cue ), 0, this, cue);
        }

        public Iterable<Pair<Long, Cue>> entriesBetween(long l, long l2) {
            return InvokeDynamicSupport.bootstrap("entriesBetween", $$robo$$android_media_SubtitleTrack_CueList$entriesBetween(long long ), 0, this, l, l2);
        }

        public long nextTimeAfter(long l) {
            return (long)InvokeDynamicSupport.bootstrap("nextTimeAfter", $$robo$$android_media_SubtitleTrack_CueList$nextTimeAfter(long ), 0, this, l);
        }

        private void __constructor__() {
            this.$$robo$$android_media_SubtitleTrack_CueList$__constructor__();
        }

        CueList() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_SubtitleTrack_CueList$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CueList)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        public class EntryIterator
        implements Iterator<Pair<Long, Cue>> {
            public transient /* synthetic */ Object __robo_data__;
            private long mCurrentTimeMs;
            private Iterator<Cue> mListIterator;
            private boolean mDone;
            private SortedMap<Long, Vector<Cue>> mRemainingCues;
            private Iterator<Cue> mLastListIterator;
            private Pair<Long, Cue> mLastEntry;
            /* synthetic */ CueList this$0;

            private final boolean $$robo$$android_media_SubtitleTrack_CueList_EntryIterator$hasNext() {
                return !this.mDone;
            }

            private final Pair<Long, Cue> $$robo$$android_media_SubtitleTrack_CueList_EntryIterator$next() {
                if (this.mDone) {
                    throw new NoSuchElementException("");
                }
                this.mLastEntry = new Pair<Long, Cue>(this.mCurrentTimeMs, this.mListIterator.next());
                this.mLastListIterator = this.mListIterator;
                if (!this.mListIterator.hasNext()) {
                    this.nextKey();
                }
                return this.mLastEntry;
            }

            private final void $$robo$$android_media_SubtitleTrack_CueList_EntryIterator$remove() {
                if (this.mLastListIterator == null || ((Cue)this.mLastEntry.second).mEndTimeMs != (Long)this.mLastEntry.first) {
                    throw new IllegalStateException("");
                }
                this.mLastListIterator.remove();
                this.mLastListIterator = null;
                if (((Vector)this.this$0.mCues.get(this.mLastEntry.first)).size() == 0) {
                    this.this$0.mCues.remove(this.mLastEntry.first);
                }
                Cue cue = (Cue)this.mLastEntry.second;
                this.this$0.removeEvent(cue, cue.mStartTimeMs);
                if (cue.mInnerTimesMs != null) {
                    for (long timeMs : cue.mInnerTimesMs) {
                        this.this$0.removeEvent(cue, timeMs);
                    }
                }
            }

            private void $$robo$$android_media_SubtitleTrack_CueList_EntryIterator$__constructor__(CueList this$0, SortedMap<Long, Vector<Cue>> cues) {
                if (this$0.DEBUG) {
                    Log.v("CueList", cues + "");
                }
                this.mRemainingCues = cues;
                this.mLastListIterator = null;
                this.nextKey();
            }

            private final void $$robo$$android_media_SubtitleTrack_CueList_EntryIterator$nextKey() {
                do {
                    try {
                        if (this.mRemainingCues == null) {
                            throw new NoSuchElementException("");
                        }
                        this.mCurrentTimeMs = this.mRemainingCues.firstKey();
                        this.mListIterator = ((Vector)this.mRemainingCues.get(this.mCurrentTimeMs)).iterator();
                        try {
                            this.mRemainingCues = this.mRemainingCues.tailMap(this.mCurrentTimeMs + 1L);
                        }
                        catch (IllegalArgumentException e) {
                            this.mRemainingCues = null;
                        }
                        this.mDone = false;
                    }
                    catch (NoSuchElementException e) {
                        this.mDone = true;
                        this.mRemainingCues = null;
                        this.mListIterator = null;
                        return;
                    }
                } while (!this.mListIterator.hasNext());
            }

            @Override
            public boolean hasNext() {
                return (boolean)InvokeDynamicSupport.bootstrap("hasNext", $$robo$$android_media_SubtitleTrack_CueList_EntryIterator$hasNext(), 0, this);
            }

            @Override
            public Pair<Long, Cue> next() {
                return InvokeDynamicSupport.bootstrap("next", $$robo$$android_media_SubtitleTrack_CueList_EntryIterator$next(), 0, this);
            }

            @Override
            public void remove() {
                InvokeDynamicSupport.bootstrap("remove", $$robo$$android_media_SubtitleTrack_CueList_EntryIterator$remove(), 0, this);
            }

            private void __constructor__(CueList cueList, SortedMap<Long, Vector<Cue>> sortedMap) {
                this.$$robo$$android_media_SubtitleTrack_CueList_EntryIterator$__constructor__(cueList, sortedMap);
            }

            public EntryIterator(CueList cueList, SortedMap<Long, Vector<Cue>> sortedMap) {
                this.this$0 = cueList;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_SubtitleTrack_CueList_EntryIterator$__constructor__(android.media.SubtitleTrack$CueList java.util.SortedMap<java.lang.Long, java.util.Vector<android.media.SubtitleTrack$Cue>> ), 0, this, cueList, sortedMap);
            }

            private void nextKey() {
                InvokeDynamicSupport.bootstrap("nextKey", $$robo$$android_media_SubtitleTrack_CueList_EntryIterator$nextKey(), 0, this);
            }

            public /* synthetic */ EntryIterator() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EntryIterator)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }
}

