/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.content.res.Resources;
import android.database.Cursor;
import android.media.AudioAttributes;
import android.media.AudioManager;
import android.media.IRingtonePlayer;
import android.media.MediaPlayer;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Binder;
import android.os.RemoteException;
import android.util.Log;
import java.io.IOException;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Ringtone
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "Ringtone";
    private static boolean LOGD = true;
    private static String[] MEDIA_COLUMNS;
    private static String MEDIA_SELECTION = "mime_type LIKE 'audio/%' OR mime_type IN ('application/ogg', 'application/x-flac')";
    private static ArrayList<Ringtone> sActiveRingtones;
    private Context mContext;
    private AudioManager mAudioManager;
    private boolean mAllowRemote;
    private IRingtonePlayer mRemotePlayer;
    private Binder mRemoteToken;
    private MediaPlayer mLocalPlayer;
    private MyOnCompletionListener mCompletionListener;
    private Uri mUri;
    private String mTitle;
    private AudioAttributes mAudioAttributes;
    private boolean mIsLooping;
    private float mVolume;
    private Object mPlaybackSettingsLock;

    private void $$robo$$android_media_Ringtone$__constructor__(Context context, boolean allowRemote) {
        this.mCompletionListener = new MyOnCompletionListener(this);
        this.mAudioAttributes = new AudioAttributes.Builder().setUsage(6).setContentType(4).build();
        this.mIsLooping = false;
        this.mVolume = 1.0f;
        this.mPlaybackSettingsLock = new Object();
        this.mContext = context;
        this.mAudioManager = (AudioManager)this.mContext.getSystemService("audio");
        this.mAllowRemote = allowRemote;
        this.mRemotePlayer = allowRemote ? this.mAudioManager.getRingtonePlayer() : null;
        this.mRemoteToken = allowRemote ? new Binder() : null;
    }

    @Deprecated
    private final void $$robo$$android_media_Ringtone$setStreamType(int streamType) {
        this.setAudioAttributes(new AudioAttributes.Builder().setInternalLegacyStreamType(streamType).build());
    }

    @Deprecated
    private final int $$robo$$android_media_Ringtone$getStreamType() {
        return AudioAttributes.toLegacyStreamType(this.mAudioAttributes);
    }

    private final void $$robo$$android_media_Ringtone$setAudioAttributes(AudioAttributes attributes) throws IllegalArgumentException {
        if (attributes == null) {
            throw new IllegalArgumentException("Invalid null AudioAttributes for Ringtone");
        }
        this.mAudioAttributes = attributes;
        this.setUri(this.mUri);
    }

    private final AudioAttributes $$robo$$android_media_Ringtone$getAudioAttributes() {
        return this.mAudioAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_Ringtone$setLooping(boolean looping) {
        Object object = this.mPlaybackSettingsLock;
        synchronized (object) {
            this.mIsLooping = looping;
            this.applyPlaybackProperties_sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_Ringtone$setVolume(float volume) {
        Object object = this.mPlaybackSettingsLock;
        synchronized (object) {
            if (volume < 0.0f) {
                volume = 0.0f;
            }
            if (volume > 1.0f) {
                volume = 1.0f;
            }
            this.mVolume = volume;
            this.applyPlaybackProperties_sync();
        }
    }

    private final void $$robo$$android_media_Ringtone$applyPlaybackProperties_sync() {
        if (this.mLocalPlayer != null) {
            this.mLocalPlayer.setVolume(this.mVolume);
            this.mLocalPlayer.setLooping(this.mIsLooping);
        } else if (this.mAllowRemote && this.mRemotePlayer != null) {
            try {
                this.mRemotePlayer.setPlaybackProperties(this.mRemoteToken, this.mVolume, this.mIsLooping);
            }
            catch (RemoteException e) {
                Log.w("Ringtone", "Problem setting playback properties: ", e);
            }
        } else {
            Log.w("Ringtone", "Neither local nor remote player available when applying playback properties");
        }
    }

    private final String $$robo$$android_media_Ringtone$getTitle(Context context) {
        if (this.mTitle != null) {
            return this.mTitle;
        }
        this.mTitle = Ringtone.getTitle(context, this.mUri, true, this.mAllowRemote);
        return this.mTitle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String $$robo$$android_media_Ringtone$getTitle(Context context, Uri uri, boolean followSettingsUri, boolean allowRemote) {
        ContentResolver res = context.getContentResolver();
        String title = null;
        if (uri != null) {
            String authority = uri.getAuthority();
            if ("settings".equals(authority)) {
                if (followSettingsUri) {
                    Uri actualUri = RingtoneManager.getActualDefaultRingtoneUri(context, RingtoneManager.getDefaultType(uri));
                    String actualTitle = Ringtone.getTitle(context, actualUri, false, allowRemote);
                    title = context.getString(17040332, actualTitle);
                }
            } else {
                Cursor cursor = null;
                try {
                    String mediaSelection;
                    if ("media".equals(authority) && (cursor = res.query(uri, MEDIA_COLUMNS, mediaSelection = allowRemote ? null : "mime_type LIKE 'audio/%' OR mime_type IN ('application/ogg', 'application/x-flac')", null, null)) != null && cursor.getCount() == 1) {
                        cursor.moveToFirst();
                        String string2 = cursor.getString(2);
                        return string2;
                    }
                }
                catch (SecurityException e) {
                    IRingtonePlayer mRemotePlayer = null;
                    if (allowRemote) {
                        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
                        mRemotePlayer = audioManager.getRingtonePlayer();
                    }
                    if (mRemotePlayer != null) {
                        try {
                            title = mRemotePlayer.getTitle(uri);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                    cursor = null;
                }
                if (title == null) {
                    title = uri.getLastPathSegment();
                }
            }
        }
        if (title == null && (title = context.getString(17040335)) == null) {
            title = "";
        }
        return title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_Ringtone$setUri(Uri uri) {
        block8: {
            this.destroyLocalPlayer();
            this.mUri = uri;
            if (this.mUri == null) {
                return;
            }
            this.mLocalPlayer = new MediaPlayer();
            try {
                this.mLocalPlayer.setDataSource(this.mContext, this.mUri);
                this.mLocalPlayer.setAudioAttributes(this.mAudioAttributes);
                Object object = this.mPlaybackSettingsLock;
                synchronized (object) {
                    this.applyPlaybackProperties_sync();
                }
                this.mLocalPlayer.prepare();
            }
            catch (IOException | SecurityException e) {
                this.destroyLocalPlayer();
                if (this.mAllowRemote) break block8;
                Log.w("Ringtone", "Remote playback not allowed: " + e);
            }
        }
        if (this.mLocalPlayer != null) {
            Log.d("Ringtone", "Successfully created local player");
        } else {
            Log.d("Ringtone", "Problem opening; delegating to remote player");
        }
    }

    private final Uri $$robo$$android_media_Ringtone$getUri() {
        return this.mUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_Ringtone$play() {
        block11: {
            if (this.mLocalPlayer != null) {
                if (this.mAudioManager.getStreamVolume(AudioAttributes.toLegacyStreamType(this.mAudioAttributes)) != 0) {
                    this.startLocalPlayer();
                }
            } else {
                if (this.mAllowRemote && this.mRemotePlayer != null) {
                    float volume;
                    boolean looping;
                    Uri canonicalUri = this.mUri.getCanonicalUri();
                    Object object = this.mPlaybackSettingsLock;
                    synchronized (object) {
                        looping = this.mIsLooping;
                        volume = this.mVolume;
                    }
                    try {
                        this.mRemotePlayer.play(this.mRemoteToken, canonicalUri, this.mAudioAttributes, volume, looping);
                    }
                    catch (RemoteException e) {
                        if (!this.playFallbackRingtone()) {
                            Log.w("Ringtone", "Problem playing ringtone: " + e);
                        }
                        break block11;
                    }
                }
                if (!this.playFallbackRingtone()) {
                    Log.w("Ringtone", "Neither local nor remote playback available");
                }
            }
        }
    }

    private final void $$robo$$android_media_Ringtone$stop() {
        if (this.mLocalPlayer != null) {
            this.destroyLocalPlayer();
        } else if (this.mAllowRemote && this.mRemotePlayer != null) {
            try {
                this.mRemotePlayer.stop(this.mRemoteToken);
            }
            catch (RemoteException e) {
                Log.w("Ringtone", "Problem stopping ringtone: " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_Ringtone$destroyLocalPlayer() {
        if (this.mLocalPlayer != null) {
            this.mLocalPlayer.reset();
            this.mLocalPlayer.release();
            this.mLocalPlayer = null;
            ArrayList<Ringtone> arrayList = sActiveRingtones;
            synchronized (arrayList) {
                sActiveRingtones.remove(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_Ringtone$startLocalPlayer() {
        if (this.mLocalPlayer == null) {
            return;
        }
        ArrayList<Ringtone> arrayList = sActiveRingtones;
        synchronized (arrayList) {
            sActiveRingtones.add(this);
        }
        this.mLocalPlayer.setOnCompletionListener(this.mCompletionListener);
        this.mLocalPlayer.start();
    }

    private final boolean $$robo$$android_media_Ringtone$isPlaying() {
        if (this.mLocalPlayer != null) {
            return this.mLocalPlayer.isPlaying();
        }
        if (this.mAllowRemote && this.mRemotePlayer != null) {
            try {
                return this.mRemotePlayer.isPlaying(this.mRemoteToken);
            }
            catch (RemoteException e) {
                Log.w("Ringtone", "Problem checking ringtone: " + e);
                return false;
            }
        }
        Log.w("Ringtone", "Neither local nor remote playback available");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_media_Ringtone$playFallbackRingtone() {
        if (this.mAudioManager.getStreamVolume(AudioAttributes.toLegacyStreamType(this.mAudioAttributes)) != 0) {
            int ringtoneType = RingtoneManager.getDefaultType(this.mUri);
            if (ringtoneType == -1 || RingtoneManager.getActualDefaultRingtoneUri(this.mContext, ringtoneType) != null) {
                try {
                    AssetFileDescriptor afd = this.mContext.getResources().openRawResourceFd(0x1100005);
                    if (afd != null) {
                        this.mLocalPlayer = new MediaPlayer();
                        if (afd.getDeclaredLength() < 0L) {
                            this.mLocalPlayer.setDataSource(afd.getFileDescriptor());
                        } else {
                            this.mLocalPlayer.setDataSource(afd.getFileDescriptor(), afd.getStartOffset(), afd.getDeclaredLength());
                        }
                        this.mLocalPlayer.setAudioAttributes(this.mAudioAttributes);
                        Object object = this.mPlaybackSettingsLock;
                        synchronized (object) {
                            this.applyPlaybackProperties_sync();
                        }
                        this.mLocalPlayer.prepare();
                        this.startLocalPlayer();
                        afd.close();
                        return true;
                    }
                    Log.e("Ringtone", "Could not load fallback ringtone");
                }
                catch (IOException ioe) {
                    this.destroyLocalPlayer();
                    Log.e("Ringtone", "Failed to open fallback ringtone");
                }
                catch (Resources.NotFoundException nfe) {
                    Log.e("Ringtone", "Fallback ringtone does not exist");
                }
            } else {
                Log.w("Ringtone", "not playing fallback for " + this.mUri);
            }
        }
        return false;
    }

    private final void $$robo$$android_media_Ringtone$setTitle(String title) {
        this.mTitle = title;
    }

    private final void $$robo$$android_media_Ringtone$finalize() {
        if (this.mLocalPlayer != null) {
            this.mLocalPlayer.release();
        }
    }

    static void __staticInitializer__() {
        MEDIA_COLUMNS = new String[]{"_id", "_data", "title"};
        sActiveRingtones = new ArrayList();
    }

    private void __constructor__(Context context, boolean bl) {
        this.$$robo$$android_media_Ringtone$__constructor__(context, bl);
    }

    public Ringtone(Context context, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_Ringtone$__constructor__(android.content.Context boolean ), 0, this, context, bl);
    }

    @Deprecated
    public void setStreamType(int n) {
        InvokeDynamicSupport.bootstrap("setStreamType", $$robo$$android_media_Ringtone$setStreamType(int ), 0, this, n);
    }

    @Deprecated
    public int getStreamType() {
        return (int)InvokeDynamicSupport.bootstrap("getStreamType", $$robo$$android_media_Ringtone$getStreamType(), 0, this);
    }

    public void setAudioAttributes(AudioAttributes audioAttributes) throws IllegalArgumentException {
        InvokeDynamicSupport.bootstrap("setAudioAttributes", $$robo$$android_media_Ringtone$setAudioAttributes(android.media.AudioAttributes ), 0, this, audioAttributes);
    }

    public AudioAttributes getAudioAttributes() {
        return InvokeDynamicSupport.bootstrap("getAudioAttributes", $$robo$$android_media_Ringtone$getAudioAttributes(), 0, this);
    }

    public void setLooping(boolean bl) {
        InvokeDynamicSupport.bootstrap("setLooping", $$robo$$android_media_Ringtone$setLooping(boolean ), 0, this, bl);
    }

    public void setVolume(float f) {
        InvokeDynamicSupport.bootstrap("setVolume", $$robo$$android_media_Ringtone$setVolume(float ), 0, this, f);
    }

    private void applyPlaybackProperties_sync() {
        InvokeDynamicSupport.bootstrap("applyPlaybackProperties_sync", $$robo$$android_media_Ringtone$applyPlaybackProperties_sync(), 0, this);
    }

    public String getTitle(Context context) {
        return InvokeDynamicSupport.bootstrap("getTitle", $$robo$$android_media_Ringtone$getTitle(android.content.Context ), 0, this, context);
    }

    public static String getTitle(Context context, Uri uri, boolean bl, boolean bl2) {
        return InvokeDynamicSupport.bootstrapStatic("getTitle", $$robo$$android_media_Ringtone$getTitle(android.content.Context android.net.Uri boolean boolean ), 0, (Context)context, (Uri)uri, (boolean)bl, (boolean)bl2);
    }

    public void setUri(Uri uri) {
        InvokeDynamicSupport.bootstrap("setUri", $$robo$$android_media_Ringtone$setUri(android.net.Uri ), 0, this, uri);
    }

    public Uri getUri() {
        return InvokeDynamicSupport.bootstrap("getUri", $$robo$$android_media_Ringtone$getUri(), 0, this);
    }

    public void play() {
        InvokeDynamicSupport.bootstrap("play", $$robo$$android_media_Ringtone$play(), 0, this);
    }

    public void stop() {
        InvokeDynamicSupport.bootstrap("stop", $$robo$$android_media_Ringtone$stop(), 0, this);
    }

    private void destroyLocalPlayer() {
        InvokeDynamicSupport.bootstrap("destroyLocalPlayer", $$robo$$android_media_Ringtone$destroyLocalPlayer(), 0, this);
    }

    private void startLocalPlayer() {
        InvokeDynamicSupport.bootstrap("startLocalPlayer", $$robo$$android_media_Ringtone$startLocalPlayer(), 0, this);
    }

    public boolean isPlaying() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPlaying", $$robo$$android_media_Ringtone$isPlaying(), 0, this);
    }

    private boolean playFallbackRingtone() {
        return (boolean)InvokeDynamicSupport.bootstrap("playFallbackRingtone", $$robo$$android_media_Ringtone$playFallbackRingtone(), 0, this);
    }

    void setTitle(String string2) {
        InvokeDynamicSupport.bootstrap("setTitle", $$robo$$android_media_Ringtone$setTitle(java.lang.String ), 0, this, string2);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_media_Ringtone$finalize(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(Ringtone.class);
    }

    public /* synthetic */ Ringtone() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Ringtone)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class MyOnCompletionListener
    implements MediaPlayer.OnCompletionListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ Ringtone this$0;

        private void $$robo$$android_media_Ringtone_MyOnCompletionListener$__constructor__(Ringtone this$0) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_Ringtone_MyOnCompletionListener$onCompletion(MediaPlayer mp) {
            ArrayList arrayList = sActiveRingtones;
            synchronized (arrayList) {
                sActiveRingtones.remove(this.this$0);
            }
        }

        private void __constructor__(Ringtone ringtone) {
            this.$$robo$$android_media_Ringtone_MyOnCompletionListener$__constructor__(ringtone);
        }

        MyOnCompletionListener(Ringtone ringtone) {
            this.this$0 = ringtone;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_Ringtone_MyOnCompletionListener$__constructor__(android.media.Ringtone ), 0, this, ringtone);
        }

        @Override
        public void onCompletion(MediaPlayer mediaPlayer) {
            InvokeDynamicSupport.bootstrap("onCompletion", $$robo$$android_media_Ringtone_MyOnCompletionListener$onCompletion(android.media.MediaPlayer ), 0, this, mediaPlayer);
        }

        public /* synthetic */ MyOnCompletionListener() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MyOnCompletionListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

