/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.res.AssetManager;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.Log;
import android.util.Pair;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import libcore.io.IoUtils;
import libcore.io.Streams;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ExifInterface
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "ExifInterface";
    private static boolean DEBUG = false;
    public static String TAG_ARTIST = "Artist";
    public static String TAG_BITS_PER_SAMPLE = "BitsPerSample";
    public static String TAG_COMPRESSION = "Compression";
    public static String TAG_COPYRIGHT = "Copyright";
    public static String TAG_DATETIME = "DateTime";
    public static String TAG_IMAGE_DESCRIPTION = "ImageDescription";
    public static String TAG_IMAGE_LENGTH = "ImageLength";
    public static String TAG_IMAGE_WIDTH = "ImageWidth";
    public static String TAG_JPEG_INTERCHANGE_FORMAT = "JPEGInterchangeFormat";
    public static String TAG_JPEG_INTERCHANGE_FORMAT_LENGTH = "JPEGInterchangeFormatLength";
    public static String TAG_MAKE = "Make";
    public static String TAG_MODEL = "Model";
    public static String TAG_ORIENTATION = "Orientation";
    public static String TAG_PHOTOMETRIC_INTERPRETATION = "PhotometricInterpretation";
    public static String TAG_PLANAR_CONFIGURATION = "PlanarConfiguration";
    public static String TAG_PRIMARY_CHROMATICITIES = "PrimaryChromaticities";
    public static String TAG_REFERENCE_BLACK_WHITE = "ReferenceBlackWhite";
    public static String TAG_RESOLUTION_UNIT = "ResolutionUnit";
    public static String TAG_ROWS_PER_STRIP = "RowsPerStrip";
    public static String TAG_SAMPLES_PER_PIXEL = "SamplesPerPixel";
    public static String TAG_SOFTWARE = "Software";
    public static String TAG_STRIP_BYTE_COUNTS = "StripByteCounts";
    public static String TAG_STRIP_OFFSETS = "StripOffsets";
    public static String TAG_TRANSFER_FUNCTION = "TransferFunction";
    public static String TAG_WHITE_POINT = "WhitePoint";
    public static String TAG_X_RESOLUTION = "XResolution";
    public static String TAG_Y_CB_CR_COEFFICIENTS = "YCbCrCoefficients";
    public static String TAG_Y_CB_CR_POSITIONING = "YCbCrPositioning";
    public static String TAG_Y_CB_CR_SUB_SAMPLING = "YCbCrSubSampling";
    public static String TAG_Y_RESOLUTION = "YResolution";
    public static String TAG_APERTURE_VALUE = "ApertureValue";
    public static String TAG_BRIGHTNESS_VALUE = "BrightnessValue";
    public static String TAG_CFA_PATTERN = "CFAPattern";
    public static String TAG_COLOR_SPACE = "ColorSpace";
    public static String TAG_COMPONENTS_CONFIGURATION = "ComponentsConfiguration";
    public static String TAG_COMPRESSED_BITS_PER_PIXEL = "CompressedBitsPerPixel";
    public static String TAG_CONTRAST = "Contrast";
    public static String TAG_CUSTOM_RENDERED = "CustomRendered";
    public static String TAG_DATETIME_DIGITIZED = "DateTimeDigitized";
    public static String TAG_DATETIME_ORIGINAL = "DateTimeOriginal";
    public static String TAG_DEVICE_SETTING_DESCRIPTION = "DeviceSettingDescription";
    public static String TAG_DIGITAL_ZOOM_RATIO = "DigitalZoomRatio";
    public static String TAG_EXIF_VERSION = "ExifVersion";
    public static String TAG_EXPOSURE_BIAS_VALUE = "ExposureBiasValue";
    public static String TAG_EXPOSURE_INDEX = "ExposureIndex";
    public static String TAG_EXPOSURE_MODE = "ExposureMode";
    public static String TAG_EXPOSURE_PROGRAM = "ExposureProgram";
    public static String TAG_EXPOSURE_TIME = "ExposureTime";
    public static String TAG_F_NUMBER = "FNumber";
    @Deprecated
    public static String TAG_APERTURE = "FNumber";
    public static String TAG_FILE_SOURCE = "FileSource";
    public static String TAG_FLASH = "Flash";
    public static String TAG_FLASH_ENERGY = "FlashEnergy";
    public static String TAG_FLASHPIX_VERSION = "FlashpixVersion";
    public static String TAG_FOCAL_LENGTH = "FocalLength";
    public static String TAG_FOCAL_LENGTH_IN_35MM_FILM = "FocalLengthIn35mmFilm";
    public static String TAG_FOCAL_PLANE_RESOLUTION_UNIT = "FocalPlaneResolutionUnit";
    public static String TAG_FOCAL_PLANE_X_RESOLUTION = "FocalPlaneXResolution";
    public static String TAG_FOCAL_PLANE_Y_RESOLUTION = "FocalPlaneYResolution";
    public static String TAG_GAIN_CONTROL = "GainControl";
    public static String TAG_ISO_SPEED_RATINGS = "ISOSpeedRatings";
    @Deprecated
    public static String TAG_ISO = "ISOSpeedRatings";
    public static String TAG_IMAGE_UNIQUE_ID = "ImageUniqueID";
    public static String TAG_LIGHT_SOURCE = "LightSource";
    public static String TAG_MAKER_NOTE = "MakerNote";
    public static String TAG_MAX_APERTURE_VALUE = "MaxApertureValue";
    public static String TAG_METERING_MODE = "MeteringMode";
    public static String TAG_OECF = "OECF";
    public static String TAG_PIXEL_X_DIMENSION = "PixelXDimension";
    public static String TAG_PIXEL_Y_DIMENSION = "PixelYDimension";
    public static String TAG_RELATED_SOUND_FILE = "RelatedSoundFile";
    public static String TAG_SATURATION = "Saturation";
    public static String TAG_SCENE_CAPTURE_TYPE = "SceneCaptureType";
    public static String TAG_SCENE_TYPE = "SceneType";
    public static String TAG_SENSING_METHOD = "SensingMethod";
    public static String TAG_SHARPNESS = "Sharpness";
    public static String TAG_SHUTTER_SPEED_VALUE = "ShutterSpeedValue";
    public static String TAG_SPATIAL_FREQUENCY_RESPONSE = "SpatialFrequencyResponse";
    public static String TAG_SPECTRAL_SENSITIVITY = "SpectralSensitivity";
    public static String TAG_SUBSEC_TIME = "SubSecTime";
    public static String TAG_SUBSEC_TIME_DIG = "SubSecTimeDigitized";
    public static String TAG_SUBSEC_TIME_DIGITIZED = "SubSecTimeDigitized";
    public static String TAG_SUBSEC_TIME_ORIG = "SubSecTimeOriginal";
    public static String TAG_SUBSEC_TIME_ORIGINAL = "SubSecTimeOriginal";
    public static String TAG_SUBJECT_AREA = "SubjectArea";
    public static String TAG_SUBJECT_DISTANCE = "SubjectDistance";
    public static String TAG_SUBJECT_DISTANCE_RANGE = "SubjectDistanceRange";
    public static String TAG_SUBJECT_LOCATION = "SubjectLocation";
    public static String TAG_USER_COMMENT = "UserComment";
    public static String TAG_WHITE_BALANCE = "WhiteBalance";
    public static String TAG_GPS_ALTITUDE = "GPSAltitude";
    public static String TAG_GPS_ALTITUDE_REF = "GPSAltitudeRef";
    public static String TAG_GPS_AREA_INFORMATION = "GPSAreaInformation";
    public static String TAG_GPS_DOP = "GPSDOP";
    public static String TAG_GPS_DATESTAMP = "GPSDateStamp";
    public static String TAG_GPS_DEST_BEARING = "GPSDestBearing";
    public static String TAG_GPS_DEST_BEARING_REF = "GPSDestBearingRef";
    public static String TAG_GPS_DEST_DISTANCE = "GPSDestDistance";
    public static String TAG_GPS_DEST_DISTANCE_REF = "GPSDestDistanceRef";
    public static String TAG_GPS_DEST_LATITUDE = "GPSDestLatitude";
    public static String TAG_GPS_DEST_LATITUDE_REF = "GPSDestLatitudeRef";
    public static String TAG_GPS_DEST_LONGITUDE = "GPSDestLongitude";
    public static String TAG_GPS_DEST_LONGITUDE_REF = "GPSDestLongitudeRef";
    public static String TAG_GPS_DIFFERENTIAL = "GPSDifferential";
    public static String TAG_GPS_IMG_DIRECTION = "GPSImgDirection";
    public static String TAG_GPS_IMG_DIRECTION_REF = "GPSImgDirectionRef";
    public static String TAG_GPS_LATITUDE = "GPSLatitude";
    public static String TAG_GPS_LATITUDE_REF = "GPSLatitudeRef";
    public static String TAG_GPS_LONGITUDE = "GPSLongitude";
    public static String TAG_GPS_LONGITUDE_REF = "GPSLongitudeRef";
    public static String TAG_GPS_MAP_DATUM = "GPSMapDatum";
    public static String TAG_GPS_MEASURE_MODE = "GPSMeasureMode";
    public static String TAG_GPS_PROCESSING_METHOD = "GPSProcessingMethod";
    public static String TAG_GPS_SATELLITES = "GPSSatellites";
    public static String TAG_GPS_SPEED = "GPSSpeed";
    public static String TAG_GPS_SPEED_REF = "GPSSpeedRef";
    public static String TAG_GPS_STATUS = "GPSStatus";
    public static String TAG_GPS_TIMESTAMP = "GPSTimeStamp";
    public static String TAG_GPS_TRACK = "GPSTrack";
    public static String TAG_GPS_TRACK_REF = "GPSTrackRef";
    public static String TAG_GPS_VERSION_ID = "GPSVersionID";
    public static String TAG_INTEROPERABILITY_INDEX = "InteroperabilityIndex";
    public static String TAG_THUMBNAIL_IMAGE_LENGTH = "ThumbnailImageLength";
    public static String TAG_THUMBNAIL_IMAGE_WIDTH = "ThumbnailImageWidth";
    private static String TAG_EXIF_IFD_POINTER = "ExifIFDPointer";
    private static String TAG_GPS_INFO_IFD_POINTER = "GPSInfoIFDPointer";
    private static String TAG_INTEROPERABILITY_IFD_POINTER = "InteroperabilityIFDPointer";
    private static String TAG_HAS_THUMBNAIL = "HasThumbnail";
    private static String TAG_THUMBNAIL_OFFSET = "ThumbnailOffset";
    private static String TAG_THUMBNAIL_LENGTH = "ThumbnailLength";
    private static String TAG_THUMBNAIL_DATA = "ThumbnailData";
    public static int ORIENTATION_UNDEFINED = 0;
    public static int ORIENTATION_NORMAL = 1;
    public static int ORIENTATION_FLIP_HORIZONTAL = 2;
    public static int ORIENTATION_ROTATE_180 = 3;
    public static int ORIENTATION_FLIP_VERTICAL = 4;
    public static int ORIENTATION_TRANSPOSE = 5;
    public static int ORIENTATION_ROTATE_90 = 6;
    public static int ORIENTATION_TRANSVERSE = 7;
    public static int ORIENTATION_ROTATE_270 = 8;
    public static int WHITEBALANCE_AUTO = 0;
    public static int WHITEBALANCE_MANUAL = 1;
    private static byte[] JPEG_SIGNATURE;
    private static int JPEG_SIGNATURE_SIZE = 3;
    private static SimpleDateFormat sFormatter;
    private static short BYTE_ALIGN_II = 18761;
    private static short BYTE_ALIGN_MM = 19789;
    private static int IFD_FORMAT_BYTE = 1;
    private static int IFD_FORMAT_STRING = 2;
    private static int IFD_FORMAT_USHORT = 3;
    private static int IFD_FORMAT_ULONG = 4;
    private static int IFD_FORMAT_URATIONAL = 5;
    private static int IFD_FORMAT_SBYTE = 6;
    private static int IFD_FORMAT_UNDEFINED = 7;
    private static int IFD_FORMAT_SSHORT = 8;
    private static int IFD_FORMAT_SLONG = 9;
    private static int IFD_FORMAT_SRATIONAL = 10;
    private static int IFD_FORMAT_SINGLE = 11;
    private static int IFD_FORMAT_DOUBLE = 12;
    private static String[] IFD_FORMAT_NAMES;
    private static int[] IFD_FORMAT_BYTES_PER_FORMAT;
    private static byte[] EXIF_ASCII_PREFIX;
    private static ExifTag[] IFD_TIFF_TAGS;
    private static ExifTag[] IFD_EXIF_TAGS;
    private static ExifTag[] IFD_GPS_TAGS;
    private static ExifTag[] IFD_INTEROPERABILITY_TAGS;
    private static ExifTag[] IFD_THUMBNAIL_TAGS;
    private static int IFD_TIFF_HINT = 0;
    private static int IFD_EXIF_HINT = 1;
    private static int IFD_GPS_HINT = 2;
    private static int IFD_INTEROPERABILITY_HINT = 3;
    private static int IFD_THUMBNAIL_HINT = 4;
    private static ExifTag[][] EXIF_TAGS;
    private static ExifTag[] IFD_POINTER_TAGS;
    private static int[] IFD_POINTER_TAG_HINTS;
    private static ExifTag JPEG_INTERCHANGE_FORMAT_TAG;
    private static ExifTag JPEG_INTERCHANGE_FORMAT_LENGTH_TAG;
    private static HashMap[] sExifTagMapsForReading;
    private static HashMap[] sExifTagMapsForWriting;
    private static HashSet<String> sTagSetForCompatibility;
    private static Charset ASCII;
    private static byte[] IDENTIFIER_EXIF_APP1;
    private static byte MARKER = -1;
    private static byte MARKER_SOI = -40;
    private static byte MARKER_SOF0 = -64;
    private static byte MARKER_SOF1 = -63;
    private static byte MARKER_SOF2 = -62;
    private static byte MARKER_SOF3 = -61;
    private static byte MARKER_SOF5 = -59;
    private static byte MARKER_SOF6 = -58;
    private static byte MARKER_SOF7 = -57;
    private static byte MARKER_SOF9 = -55;
    private static byte MARKER_SOF10 = -54;
    private static byte MARKER_SOF11 = -53;
    private static byte MARKER_SOF13 = -51;
    private static byte MARKER_SOF14 = -50;
    private static byte MARKER_SOF15 = -49;
    private static byte MARKER_SOS = -38;
    private static byte MARKER_APP1 = -31;
    private static byte MARKER_COM = -2;
    private static byte MARKER_EOI = -39;
    private String mFilename;
    private FileDescriptor mSeekableFileDescriptor;
    private AssetManager.AssetInputStream mAssetInputStream;
    private boolean mIsInputStream;
    private boolean mIsRaw;
    private HashMap[] mAttributes;
    private ByteOrder mExifByteOrder;
    private boolean mHasThumbnail;
    private int mThumbnailOffset;
    private int mThumbnailLength;
    private byte[] mThumbnailBytes;
    private static Pattern sNonZeroTimePattern;
    private static Pattern sGpsTimestampPattern;

    private void $$robo$$android_media_ExifInterface$__constructor__(String filename) throws IOException {
        this.mAttributes = new HashMap[EXIF_TAGS.length];
        this.mExifByteOrder = ByteOrder.BIG_ENDIAN;
        if (filename == null) {
            throw new IllegalArgumentException("filename cannot be null");
        }
        FileInputStream in = null;
        this.mAssetInputStream = null;
        this.mFilename = filename;
        this.mIsInputStream = false;
        try {
            in = new FileInputStream(filename);
            this.mSeekableFileDescriptor = ExifInterface.isSeekableFD(in.getFD()) ? in.getFD() : null;
            this.loadAttributes(in);
        }
        catch (Throwable throwable) {
            IoUtils.closeQuietly(in);
            throw throwable;
        }
        IoUtils.closeQuietly(in);
    }

    private void $$robo$$android_media_ExifInterface$__constructor__(FileDescriptor fileDescriptor) throws IOException {
        this.mAttributes = new HashMap[EXIF_TAGS.length];
        this.mExifByteOrder = ByteOrder.BIG_ENDIAN;
        if (fileDescriptor == null) {
            throw new IllegalArgumentException("fileDescriptor cannot be null");
        }
        this.mAssetInputStream = null;
        this.mFilename = null;
        if (ExifInterface.isSeekableFD(fileDescriptor)) {
            this.mSeekableFileDescriptor = fileDescriptor;
            try {
                fileDescriptor = Os.dup(fileDescriptor);
            }
            catch (ErrnoException e) {
                throw e.rethrowAsIOException();
            }
        } else {
            this.mSeekableFileDescriptor = null;
        }
        this.mIsInputStream = false;
        FileInputStream in = null;
        try {
            in = new FileInputStream(fileDescriptor);
            this.loadAttributes(in);
        }
        catch (Throwable throwable) {
            IoUtils.closeQuietly(in);
            throw throwable;
        }
        IoUtils.closeQuietly(in);
    }

    private void $$robo$$android_media_ExifInterface$__constructor__(InputStream inputStream) throws IOException {
        this.mAttributes = new HashMap[EXIF_TAGS.length];
        this.mExifByteOrder = ByteOrder.BIG_ENDIAN;
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream cannot be null");
        }
        this.mFilename = null;
        if (inputStream instanceof AssetManager.AssetInputStream) {
            this.mAssetInputStream = (AssetManager.AssetInputStream)inputStream;
            this.mSeekableFileDescriptor = null;
        } else if (inputStream instanceof FileInputStream && ExifInterface.isSeekableFD(((FileInputStream)inputStream).getFD())) {
            this.mAssetInputStream = null;
            this.mSeekableFileDescriptor = ((FileInputStream)inputStream).getFD();
        } else {
            this.mAssetInputStream = null;
            this.mSeekableFileDescriptor = null;
        }
        this.mIsInputStream = true;
        this.loadAttributes(inputStream);
    }

    private final ExifAttribute $$robo$$android_media_ExifInterface$getExifAttribute(String tag) {
        for (int i = 0; i < EXIF_TAGS.length; ++i) {
            Object value = this.mAttributes[i].get(tag);
            if (value == null) continue;
            return (ExifAttribute)value;
        }
        return null;
    }

    private final String $$robo$$android_media_ExifInterface$getAttribute(String tag) {
        ExifAttribute attribute = this.getExifAttribute(tag);
        if (attribute != null) {
            if (!sTagSetForCompatibility.contains(tag)) {
                return attribute.getStringValue(this.mExifByteOrder);
            }
            if (tag.equals("GPSTimeStamp")) {
                if (attribute.format != 5 && attribute.format != 10) {
                    return null;
                }
                Rational[] array2 = (Rational[])attribute.getValue(this.mExifByteOrder);
                if (array2.length != 3) {
                    return null;
                }
                return String.format("%02d:%02d:%02d", (int)((float)array2[0].numerator / (float)array2[0].denominator), (int)((float)array2[1].numerator / (float)array2[1].denominator), (int)((float)array2[2].numerator / (float)array2[2].denominator));
            }
            try {
                return Double.toString(attribute.getDoubleValue(this.mExifByteOrder));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    private final int $$robo$$android_media_ExifInterface$getAttributeInt(String tag, int defaultValue) {
        ExifAttribute exifAttribute = this.getExifAttribute(tag);
        if (exifAttribute == null) {
            return defaultValue;
        }
        try {
            return exifAttribute.getIntValue(this.mExifByteOrder);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private final double $$robo$$android_media_ExifInterface$getAttributeDouble(String tag, double defaultValue) {
        ExifAttribute exifAttribute = this.getExifAttribute(tag);
        if (exifAttribute == null) {
            return defaultValue;
        }
        try {
            return exifAttribute.getDoubleValue(this.mExifByteOrder);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private final void $$robo$$android_media_ExifInterface$setAttribute(String tag, String value) {
        if (value != null && sTagSetForCompatibility.contains(tag)) {
            if (tag.equals("GPSTimeStamp")) {
                Matcher m = sGpsTimestampPattern.matcher(value);
                if (!m.find()) {
                    Log.w("ExifInterface", "Invalid value for " + tag + " : " + value);
                    return;
                }
                value = Integer.parseInt(m.group(1)) + "/1," + Integer.parseInt(m.group(2)) + "/1," + Integer.parseInt(m.group(3)) + "/1";
            } else {
                try {
                    double doubleValue = Double.parseDouble(value);
                    value = (long)(doubleValue * 10000.0) + "/10000";
                }
                catch (NumberFormatException e) {
                    Log.w("ExifInterface", "Invalid value for " + tag + " : " + value);
                    return;
                }
            }
        }
        block12: for (int i = 0; i < EXIF_TAGS.length; ++i) {
            int dataFormat;
            Object obj;
            if (i == 4 && !this.mHasThumbnail || (obj = sExifTagMapsForWriting[i].get(tag)) == null) continue;
            if (value == null) {
                this.mAttributes[i].remove(tag);
                continue;
            }
            ExifTag exifTag = (ExifTag)obj;
            Pair<Integer, Integer> guess = ExifInterface.guessDataFormat(value);
            if (exifTag.primaryFormat == (Integer)guess.first || exifTag.primaryFormat == (Integer)guess.second) {
                dataFormat = exifTag.primaryFormat;
            } else if (exifTag.secondaryFormat != -1 && (exifTag.secondaryFormat == (Integer)guess.first || exifTag.secondaryFormat == (Integer)guess.second)) {
                dataFormat = exifTag.secondaryFormat;
            } else if (exifTag.primaryFormat == 1 || exifTag.primaryFormat == 7 || exifTag.primaryFormat == 2) {
                dataFormat = exifTag.primaryFormat;
            } else {
                Log.w("ExifInterface", "Given tag (" + tag + ") value didn't match with one of expected formats: " + IFD_FORMAT_NAMES[exifTag.primaryFormat] + (exifTag.secondaryFormat == -1 ? "" : ", " + IFD_FORMAT_NAMES[exifTag.secondaryFormat]) + " (guess: " + IFD_FORMAT_NAMES[(Integer)guess.first] + ((Integer)guess.second == -1 ? "" : ", " + IFD_FORMAT_NAMES[(Integer)guess.second]) + ")");
                continue;
            }
            switch (dataFormat) {
                case 1: {
                    this.mAttributes[i].put(tag, ExifAttribute.createByte(value));
                    continue block12;
                }
                case 2: 
                case 7: {
                    this.mAttributes[i].put(tag, ExifAttribute.createString(value));
                    continue block12;
                }
                case 3: {
                    int j;
                    String[] values = value.split(",");
                    int[] intArray = new int[values.length];
                    for (j = 0; j < values.length; ++j) {
                        intArray[j] = Integer.parseInt(values[j]);
                    }
                    this.mAttributes[i].put(tag, ExifAttribute.createUShort(intArray, this.mExifByteOrder));
                    continue block12;
                }
                case 9: {
                    int j;
                    String[] values = value.split(",");
                    int[] intArray = new int[values.length];
                    for (j = 0; j < values.length; ++j) {
                        intArray[j] = Integer.parseInt(values[j]);
                    }
                    this.mAttributes[i].put(tag, ExifAttribute.createSLong(intArray, this.mExifByteOrder));
                    continue block12;
                }
                case 4: {
                    int j;
                    String[] values = value.split(",");
                    long[] longArray = new long[values.length];
                    for (j = 0; j < values.length; ++j) {
                        longArray[j] = Long.parseLong(values[j]);
                    }
                    this.mAttributes[i].put(tag, ExifAttribute.createULong(longArray, this.mExifByteOrder));
                    continue block12;
                }
                case 5: {
                    String[] numbers;
                    int j;
                    String[] values = value.split(",");
                    Rational[] rationalArray = new Rational[values.length];
                    for (j = 0; j < values.length; ++j) {
                        numbers = values[j].split("/");
                        rationalArray[j] = new Rational(Long.parseLong(numbers[0]), Long.parseLong(numbers[1]));
                    }
                    this.mAttributes[i].put(tag, ExifAttribute.createURational(rationalArray, this.mExifByteOrder));
                    continue block12;
                }
                case 10: {
                    String[] numbers;
                    int j;
                    String[] values = value.split(",");
                    Rational[] rationalArray = new Rational[values.length];
                    for (j = 0; j < values.length; ++j) {
                        numbers = values[j].split("/");
                        rationalArray[j] = new Rational(Long.parseLong(numbers[0]), Long.parseLong(numbers[1]));
                    }
                    this.mAttributes[i].put(tag, ExifAttribute.createSRational(rationalArray, this.mExifByteOrder));
                    continue block12;
                }
                case 12: {
                    int j;
                    String[] values = value.split(",");
                    double[] doubleArray = new double[values.length];
                    for (j = 0; j < values.length; ++j) {
                        doubleArray[j] = Double.parseDouble(values[j]);
                    }
                    this.mAttributes[i].put(tag, ExifAttribute.createDouble(doubleArray, this.mExifByteOrder));
                    continue block12;
                }
                default: {
                    Log.w("ExifInterface", "Data format isn't one of expected formats: " + dataFormat);
                    continue block12;
                }
            }
        }
    }

    private final boolean $$robo$$android_media_ExifInterface$updateAttribute(String tag, ExifAttribute value) {
        boolean updated = false;
        for (int i = 0; i < EXIF_TAGS.length; ++i) {
            if (!this.mAttributes[i].containsKey(tag)) continue;
            this.mAttributes[i].put(tag, value);
            updated = true;
        }
        return updated;
    }

    private final void $$robo$$android_media_ExifInterface$removeAttribute(String tag) {
        for (int i = 0; i < EXIF_TAGS.length; ++i) {
            this.mAttributes[i].remove(tag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_ExifInterface$loadAttributes(InputStream in) throws IOException {
        try {
            for (int i = 0; i < EXIF_TAGS.length; ++i) {
                this.mAttributes[i] = new HashMap();
            }
            if (this.mAssetInputStream != null) {
                long asset = this.mAssetInputStream.getNativeAsset();
                if (this.handleRawResult(ExifInterface.nativeGetRawAttributesFromAsset(asset))) {
                    return;
                }
            } else if (this.mSeekableFileDescriptor != null ? this.handleRawResult(ExifInterface.nativeGetRawAttributesFromFileDescriptor(this.mSeekableFileDescriptor)) : !ExifInterface.isJpegInputStream((BufferedInputStream)(in = new BufferedInputStream(in, 3))) && this.handleRawResult(ExifInterface.nativeGetRawAttributesFromInputStream(in))) {
                return;
            }
            this.getJpegAttributes(in);
        }
        catch (IOException e) {
            Log.w("ExifInterface", "Invalid image: ExifInterface got an unsupported image format file(ExifInterface supports JPEG and some RAW image formats only) or a corrupted JPEG file to ExifInterface.", e);
        }
        finally {
            this.addDefaultValuesForCompatibility();
        }
    }

    private static final boolean $$robo$$android_media_ExifInterface$isJpegInputStream(BufferedInputStream in) throws IOException {
        in.mark(3);
        byte[] signatureBytes = new byte[3];
        if (in.read(signatureBytes) != 3) {
            throw new EOFException();
        }
        boolean isJpeg = Arrays.equals(JPEG_SIGNATURE, signatureBytes);
        in.reset();
        return isJpeg;
    }

    private final boolean $$robo$$android_media_ExifInterface$handleRawResult(HashMap map) {
        if (map == null) {
            return false;
        }
        this.mIsRaw = true;
        String value = (String)map.remove("HasThumbnail");
        this.mHasThumbnail = value != null && value.equalsIgnoreCase("true");
        value = (String)map.remove("ThumbnailOffset");
        if (value != null) {
            this.mThumbnailOffset = Integer.parseInt(value);
        }
        if ((value = (String)map.remove("ThumbnailLength")) != null) {
            this.mThumbnailLength = Integer.parseInt(value);
        }
        this.mThumbnailBytes = (byte[])map.remove("ThumbnailData");
        for (Map.Entry entry : map.entrySet()) {
            this.setAttribute((String)entry.getKey(), (String)entry.getValue());
        }
        return true;
    }

    private static final boolean $$robo$$android_media_ExifInterface$isSeekableFD(FileDescriptor fd) throws IOException {
        try {
            Os.lseek(fd, 0L, OsConstants.SEEK_CUR);
            return true;
        }
        catch (ErrnoException e) {
            return false;
        }
    }

    private final void $$robo$$android_media_ExifInterface$printAttributes() {
        for (int i = 0; i < this.mAttributes.length; ++i) {
            Log.d("ExifInterface", "The size of tag group[" + i + "]: " + this.mAttributes[i].size());
            for (Map.Entry entry : this.mAttributes[i].entrySet()) {
                ExifAttribute tagValue = (ExifAttribute)entry.getValue();
                Log.d("ExifInterface", "tagName: " + entry.getKey() + ", tagType: " + tagValue.toString() + ", tagValue: '" + tagValue.getStringValue(this.mExifByteOrder) + "'");
            }
        }
    }

    private final void $$robo$$android_media_ExifInterface$saveAttributes() throws IOException {
        if (this.mIsRaw) {
            throw new UnsupportedOperationException("ExifInterface does not support saving attributes on RAW formats.");
        }
        if (this.mIsInputStream || this.mSeekableFileDescriptor == null && this.mFilename == null) {
            throw new UnsupportedOperationException("ExifInterface does not support saving attributes for the current input.");
        }
        this.mThumbnailBytes = this.getThumbnail();
        FileInputStream in = null;
        FileOutputStream out = null;
        File tempFile = null;
        try {
            if (this.mFilename != null) {
                File originalFile = new File(this.mFilename);
                tempFile = new File(this.mFilename + ".tmp");
                if (!originalFile.renameTo(tempFile)) {
                    throw new IOException("Could'nt rename to " + tempFile.getAbsolutePath());
                }
            } else if (this.mSeekableFileDescriptor != null) {
                tempFile = File.createTempFile("temp", "jpg");
                Os.lseek(this.mSeekableFileDescriptor, 0L, OsConstants.SEEK_SET);
                in = new FileInputStream(this.mSeekableFileDescriptor);
                out = new FileOutputStream(tempFile);
                Streams.copy(in, out);
            }
        }
        catch (ErrnoException e) {
            throw e.rethrowAsIOException();
        }
        finally {
            IoUtils.closeQuietly(in);
            IoUtils.closeQuietly(out);
        }
        in = null;
        out = null;
        try {
            in = new FileInputStream(tempFile);
            if (this.mFilename != null) {
                out = new FileOutputStream(this.mFilename);
            } else if (this.mSeekableFileDescriptor != null) {
                Os.lseek(this.mSeekableFileDescriptor, 0L, OsConstants.SEEK_SET);
                out = new FileOutputStream(this.mSeekableFileDescriptor);
            }
            this.saveJpegAttributes(in, out);
        }
        catch (ErrnoException e) {
            try {
                throw e.rethrowAsIOException();
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(in);
                IoUtils.closeQuietly(out);
                tempFile.delete();
                throw throwable;
            }
        }
        IoUtils.closeQuietly(in);
        IoUtils.closeQuietly(out);
        tempFile.delete();
        this.mThumbnailBytes = null;
    }

    private final boolean $$robo$$android_media_ExifInterface$hasThumbnail() {
        return this.mHasThumbnail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] $$robo$$android_media_ExifInterface$getThumbnail() {
        block13: {
            byte[] byArray;
            FileInputStream in;
            block12: {
                if (!this.mHasThumbnail) {
                    return null;
                }
                if (this.mThumbnailBytes != null) {
                    return this.mThumbnailBytes;
                }
                in = null;
                if (this.mAssetInputStream == null) break block12;
                byte[] byArray2 = ExifInterface.nativeGetThumbnailFromAsset(this.mAssetInputStream.getNativeAsset(), this.mThumbnailOffset, this.mThumbnailLength);
                IoUtils.closeQuietly(in);
                return byArray2;
            }
            try {
                if (this.mFilename != null) {
                    in = new FileInputStream(this.mFilename);
                } else if (this.mSeekableFileDescriptor != null) {
                    FileDescriptor fileDescriptor = Os.dup(this.mSeekableFileDescriptor);
                    Os.lseek(fileDescriptor, 0L, OsConstants.SEEK_SET);
                    in = new FileInputStream(fileDescriptor);
                }
                if (in == null) {
                    throw new FileNotFoundException();
                }
                if (in.skip(this.mThumbnailOffset) != (long)this.mThumbnailOffset) {
                    throw new IOException("Corrupted image");
                }
                byte[] buffer = new byte[this.mThumbnailLength];
                if (in.read(buffer) != this.mThumbnailLength) {
                    throw new IOException("Corrupted image");
                }
                byArray = buffer;
            }
            catch (ErrnoException | IOException exception) {
                IoUtils.closeQuietly(in);
                break block13;
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(in);
                throw throwable;
            }
            IoUtils.closeQuietly(in);
            return byArray;
        }
        return null;
    }

    private final long[] $$robo$$android_media_ExifInterface$getThumbnailRange() {
        if (!this.mHasThumbnail) {
            return null;
        }
        long[] range = new long[]{this.mThumbnailOffset, this.mThumbnailLength};
        return range;
    }

    private final boolean $$robo$$android_media_ExifInterface$getLatLong(float[] output) {
        String latValue = this.getAttribute("GPSLatitude");
        String latRef = this.getAttribute("GPSLatitudeRef");
        String lngValue = this.getAttribute("GPSLongitude");
        String lngRef = this.getAttribute("GPSLongitudeRef");
        if (latValue != null && latRef != null && lngValue != null && lngRef != null) {
            try {
                output[0] = ExifInterface.convertRationalLatLonToFloat(latValue, latRef);
                output[1] = ExifInterface.convertRationalLatLonToFloat(lngValue, lngRef);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }

    private final double $$robo$$android_media_ExifInterface$getAltitude(double defaultValue) {
        double altitude = this.getAttributeDouble("GPSAltitude", -1.0);
        int ref = this.getAttributeInt("GPSAltitudeRef", -1);
        if (altitude >= 0.0 && ref >= 0) {
            return altitude * (double)(ref == 1 ? -1 : 1);
        }
        return defaultValue;
    }

    private final long $$robo$$android_media_ExifInterface$getDateTime() {
        String dateTimeString = this.getAttribute("DateTime");
        if (dateTimeString == null || !sNonZeroTimePattern.matcher(dateTimeString).matches()) {
            return -1L;
        }
        ParsePosition pos = new ParsePosition(0);
        try {
            Date datetime = sFormatter.parse(dateTimeString, pos);
            if (datetime == null) {
                return -1L;
            }
            long msecs = datetime.getTime();
            String subSecs = this.getAttribute("SubSecTime");
            if (subSecs != null) {
                try {
                    long sub;
                    for (sub = Long.valueOf(subSecs).longValue(); sub > 1000L; sub /= 10L) {
                    }
                    msecs += sub;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return msecs;
        }
        catch (IllegalArgumentException e) {
            return -1L;
        }
    }

    private final long $$robo$$android_media_ExifInterface$getGpsDateTime() {
        String date = this.getAttribute("GPSDateStamp");
        String time = this.getAttribute("GPSTimeStamp");
        if (date == null || time == null || !sNonZeroTimePattern.matcher(date).matches() && !sNonZeroTimePattern.matcher(time).matches()) {
            return -1L;
        }
        String dateTimeString = date + ' ' + time;
        ParsePosition pos = new ParsePosition(0);
        try {
            Date datetime = sFormatter.parse(dateTimeString, pos);
            if (datetime == null) {
                return -1L;
            }
            return datetime.getTime();
        }
        catch (IllegalArgumentException e) {
            return -1L;
        }
    }

    private static final float $$robo$$android_media_ExifInterface$convertRationalLatLonToFloat(String rationalString, String ref) {
        try {
            String[] parts = rationalString.split(",");
            String[] pair = parts[0].split("/");
            double degrees = Double.parseDouble(pair[0].trim()) / Double.parseDouble(pair[1].trim());
            pair = parts[1].split("/");
            double minutes = Double.parseDouble(pair[0].trim()) / Double.parseDouble(pair[1].trim());
            pair = parts[2].split("/");
            double seconds = Double.parseDouble(pair[0].trim()) / Double.parseDouble(pair[1].trim());
            double result = degrees + minutes / 60.0 + seconds / 3600.0;
            if (ref.equals("S") || ref.equals("W")) {
                return (float)(-result);
            }
            return (float)result;
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            throw new IllegalArgumentException();
        }
    }

    private final void $$robo$$android_media_ExifInterface$getJpegAttributes(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int bytesRead = 0;
        byte marker = dataInputStream.readByte();
        if (marker != -1) {
            throw new IOException("Invalid marker: " + Integer.toHexString(marker & 0xFF));
        }
        ++bytesRead;
        if (dataInputStream.readByte() != -40) {
            throw new IOException("Invalid marker: " + Integer.toHexString(marker & 0xFF));
        }
        ++bytesRead;
        while (true) {
            if ((marker = dataInputStream.readByte()) != -1) {
                throw new IOException("Invalid marker:" + Integer.toHexString(marker & 0xFF));
            }
            ++bytesRead;
            marker = dataInputStream.readByte();
            ++bytesRead;
            if (marker == -39 || marker == -38) break;
            int length = dataInputStream.readUnsignedShort() - 2;
            bytesRead += 2;
            if (length < 0) {
                throw new IOException("Invalid length");
            }
            switch (marker) {
                case -31: {
                    if (length < 6) break;
                    byte[] identifier = new byte[6];
                    if (inputStream.read(identifier) != 6) {
                        throw new IOException("Invalid exif");
                    }
                    bytesRead += 6;
                    length -= 6;
                    if (!Arrays.equals(identifier, IDENTIFIER_EXIF_APP1)) break;
                    if (length <= 0) {
                        throw new IOException("Invalid exif");
                    }
                    byte[] bytes = new byte[length];
                    if (dataInputStream.read(bytes) != length) {
                        throw new IOException("Invalid exif");
                    }
                    this.readExifSegment(bytes, bytesRead);
                    bytesRead += length;
                    length = 0;
                    break;
                }
                case -2: {
                    byte[] bytes = new byte[length];
                    if (dataInputStream.read(bytes) != length) {
                        throw new IOException("Invalid exif");
                    }
                    length = 0;
                    if (this.getAttribute("UserComment") != null) break;
                    this.mAttributes[1].put("UserComment", ExifAttribute.createString(new String(bytes, ASCII)));
                    break;
                }
                case -64: 
                case -63: 
                case -62: 
                case -61: 
                case -59: 
                case -58: 
                case -57: 
                case -55: 
                case -54: 
                case -53: 
                case -51: 
                case -50: 
                case -49: {
                    if (dataInputStream.skipBytes(1) != 1) {
                        throw new IOException("Invalid SOFx");
                    }
                    this.mAttributes[0].put("ImageLength", ExifAttribute.createULong(dataInputStream.readUnsignedShort(), this.mExifByteOrder));
                    this.mAttributes[0].put("ImageWidth", ExifAttribute.createULong(dataInputStream.readUnsignedShort(), this.mExifByteOrder));
                    length -= 5;
                    break;
                }
            }
            if (length < 0) {
                throw new IOException("Invalid length");
            }
            if (dataInputStream.skipBytes(length) != length) {
                throw new IOException("Invalid JPEG segment");
            }
            bytesRead += length;
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void $$robo$$android_media_ExifInterface$saveJpegAttributes(InputStream inputStream, OutputStream outputStream) throws IOException {
        dataInputStream = new DataInputStream(inputStream);
        dataOutputStream = new ByteOrderAwarenessDataOutputStream(outputStream, ByteOrder.BIG_ENDIAN);
        if (dataInputStream.readByte() != -1) {
            throw new IOException("Invalid marker");
        }
        dataOutputStream.writeByte(-1);
        if (dataInputStream.readByte() != -40) {
            throw new IOException("Invalid marker");
        }
        dataOutputStream.writeByte(-40);
        dataOutputStream.writeByte(-1);
        dataOutputStream.writeByte(-31);
        this.writeExifSegment(dataOutputStream, 6);
        bytes = new byte[4096];
        block4: while (true) {
            if ((marker = dataInputStream.readByte()) != -1) {
                throw new IOException("Invalid marker");
            }
            marker = dataInputStream.readByte();
            switch (marker) {
                case -31: {
                    length = dataInputStream.readUnsignedShort() - 2;
                    if (length < 0) {
                        throw new IOException("Invalid length");
                    }
                    identifier = new byte[6];
                    if (length >= 6) {
                        if (dataInputStream.read(identifier) != 6) {
                            throw new IOException("Invalid exif");
                        }
                        if (Arrays.equals(identifier, ExifInterface.IDENTIFIER_EXIF_APP1)) {
                            if (dataInputStream.skip(length - 6) == (long)(length - 6)) continue block4;
                            throw new IOException("Invalid length");
                        }
                    }
                    dataOutputStream.writeByte(-1);
                    dataOutputStream.writeByte(marker);
                    dataOutputStream.writeUnsignedShort(length + 2);
                    if (length >= 6) {
                        length -= 6;
                        dataOutputStream.write(identifier);
                    }
                    while (true) {
                        if (length <= 0 || (read = dataInputStream.read(bytes, 0, Math.min(length, bytes.length))) < 0) continue block4;
                        dataOutputStream.write(bytes, 0, read);
                        length -= read;
                    }
                }
                case -39: 
                case -38: {
                    dataOutputStream.writeByte(-1);
                    dataOutputStream.writeByte(marker);
                    Streams.copy(dataInputStream, dataOutputStream);
                    return;
                }
            }
            dataOutputStream.writeByte(-1);
            dataOutputStream.writeByte(marker);
            length = dataInputStream.readUnsignedShort();
            dataOutputStream.writeUnsignedShort(length);
            if ((length -= 2) < 0) {
                throw new IOException("Invalid length");
            }
            while (true) {
                if (length > 0 && (read = dataInputStream.read(bytes, 0, Math.min(length, bytes.length))) >= 0) ** break;
                continue block4;
                dataOutputStream.write(bytes, 0, read);
                length -= read;
            }
            break;
        }
    }

    private final void $$robo$$android_media_ExifInterface$readExifSegment(byte[] exifBytes, int exifOffsetFromBeginning) throws IOException {
        ByteOrderAwarenessDataInputStream dataInputStream = new ByteOrderAwarenessDataInputStream(exifBytes);
        short byteOrder = dataInputStream.readShort();
        switch (byteOrder) {
            case 18761: {
                this.mExifByteOrder = ByteOrder.LITTLE_ENDIAN;
                break;
            }
            case 19789: {
                this.mExifByteOrder = ByteOrder.BIG_ENDIAN;
                break;
            }
            default: {
                throw new IOException("Invalid byte order: " + Integer.toHexString(byteOrder));
            }
        }
        dataInputStream.setByteOrder(this.mExifByteOrder);
        int startCode = dataInputStream.readUnsignedShort();
        if (startCode != 42) {
            throw new IOException("Invalid exif start: " + Integer.toHexString(startCode));
        }
        long firstIfdOffset = dataInputStream.readUnsignedInt();
        if (firstIfdOffset < 8L || firstIfdOffset >= (long)exifBytes.length) {
            throw new IOException("Invalid first Ifd offset: " + firstIfdOffset);
        }
        if ((firstIfdOffset -= 8L) > 0L && dataInputStream.skip(firstIfdOffset) != firstIfdOffset) {
            throw new IOException("Couldn't jump to first Ifd: " + firstIfdOffset);
        }
        this.readImageFileDirectory(dataInputStream, 0);
        String jpegInterchangeFormatString = this.getAttribute(ExifInterface.JPEG_INTERCHANGE_FORMAT_TAG.name);
        String jpegInterchangeFormatLengthString = this.getAttribute(ExifInterface.JPEG_INTERCHANGE_FORMAT_LENGTH_TAG.name);
        if (jpegInterchangeFormatString != null && jpegInterchangeFormatLengthString != null) {
            try {
                int jpegInterchangeFormat = Integer.parseInt(jpegInterchangeFormatString);
                int jpegInterchangeFormatLength = Integer.parseInt(jpegInterchangeFormatLengthString);
                jpegInterchangeFormatLength = Math.min(jpegInterchangeFormat + jpegInterchangeFormatLength, exifBytes.length) - jpegInterchangeFormat;
                if (jpegInterchangeFormat > 0 && jpegInterchangeFormatLength > 0) {
                    this.mHasThumbnail = true;
                    this.mThumbnailOffset = exifOffsetFromBeginning + jpegInterchangeFormat;
                    this.mThumbnailLength = jpegInterchangeFormatLength;
                    if (this.mFilename == null && this.mAssetInputStream == null && this.mSeekableFileDescriptor == null) {
                        byte[] thumbnailBytes = new byte[jpegInterchangeFormatLength];
                        dataInputStream.seek(jpegInterchangeFormat);
                        dataInputStream.readFully(thumbnailBytes);
                        this.mThumbnailBytes = thumbnailBytes;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private final void $$robo$$android_media_ExifInterface$addDefaultValuesForCompatibility() {
        String valueOfDateTimeOriginal = this.getAttribute("DateTimeOriginal");
        if (valueOfDateTimeOriginal != null) {
            this.mAttributes[0].put("DateTime", ExifAttribute.createString(valueOfDateTimeOriginal));
        }
        if (this.getAttribute("ImageWidth") == null) {
            this.mAttributes[0].put("ImageWidth", ExifAttribute.createULong(0L, this.mExifByteOrder));
        }
        if (this.getAttribute("ImageLength") == null) {
            this.mAttributes[0].put("ImageLength", ExifAttribute.createULong(0L, this.mExifByteOrder));
        }
        if (this.getAttribute("Orientation") == null) {
            this.mAttributes[0].put("Orientation", ExifAttribute.createULong(0L, this.mExifByteOrder));
        }
        if (this.getAttribute("LightSource") == null) {
            this.mAttributes[1].put("LightSource", ExifAttribute.createULong(0L, this.mExifByteOrder));
        }
    }

    private final void $$robo$$android_media_ExifInterface$readImageFileDirectory(ByteOrderAwarenessDataInputStream dataInputStream, int hint) throws IOException {
        long nextIfdOffset;
        if (dataInputStream.peek() + 2L > dataInputStream.mLength) {
            return;
        }
        short numberOfDirectoryEntry = dataInputStream.readShort();
        if (dataInputStream.peek() + (long)(12 * numberOfDirectoryEntry) > dataInputStream.mLength) {
            return;
        }
        for (short i = 0; i < numberOfDirectoryEntry; i = (short)(i + 1)) {
            int innerIfdHint;
            int tagNumber = dataInputStream.readUnsignedShort();
            int dataFormat = dataInputStream.readUnsignedShort();
            int numberOfComponents = dataInputStream.readInt();
            long nextEntryOffset = dataInputStream.peek() + 4L;
            ExifTag tag = (ExifTag)sExifTagMapsForReading[hint].get(tagNumber);
            if (tag == null || dataFormat <= 0 || dataFormat >= IFD_FORMAT_BYTES_PER_FORMAT.length) {
                if (tag == null) {
                    Log.w("ExifInterface", "Skip the tag entry since tag number is not defined: " + tagNumber);
                } else {
                    Log.w("ExifInterface", "Skip the tag entry since data format is invalid: " + dataFormat);
                }
                dataInputStream.seek(nextEntryOffset);
                continue;
            }
            int byteCount = numberOfComponents * IFD_FORMAT_BYTES_PER_FORMAT[dataFormat];
            if (byteCount > 4) {
                long offset = dataInputStream.readUnsignedInt();
                if (offset + (long)byteCount <= dataInputStream.mLength) {
                    dataInputStream.seek(offset);
                } else {
                    Log.w("ExifInterface", "Skip the tag entry since data offset is invalid: " + offset);
                    dataInputStream.seek(nextEntryOffset);
                    continue;
                }
            }
            if ((innerIfdHint = ExifInterface.getIfdHintFromTagNumber(tagNumber)) >= 0) {
                long offset = -1L;
                switch (dataFormat) {
                    case 3: {
                        offset = dataInputStream.readUnsignedShort();
                        break;
                    }
                    case 8: {
                        offset = dataInputStream.readShort();
                        break;
                    }
                    case 4: {
                        offset = dataInputStream.readUnsignedInt();
                        break;
                    }
                    case 9: {
                        offset = dataInputStream.readInt();
                        break;
                    }
                }
                if (offset > 0L && offset < dataInputStream.mLength) {
                    dataInputStream.seek(offset);
                    this.readImageFileDirectory(dataInputStream, innerIfdHint);
                } else {
                    Log.w("ExifInterface", "Skip jump into the IFD since its offset is invalid: " + offset);
                }
                dataInputStream.seek(nextEntryOffset);
                continue;
            }
            byte[] bytes = new byte[numberOfComponents * IFD_FORMAT_BYTES_PER_FORMAT[dataFormat]];
            dataInputStream.readFully(bytes);
            this.mAttributes[hint].put(tag.name, new ExifAttribute(dataFormat, numberOfComponents, bytes));
            if (dataInputStream.peek() == nextEntryOffset) continue;
            dataInputStream.seek(nextEntryOffset);
        }
        if (dataInputStream.peek() + 4L <= dataInputStream.mLength && (nextIfdOffset = dataInputStream.readUnsignedInt()) > 8L && nextIfdOffset < dataInputStream.mLength) {
            dataInputStream.seek(nextIfdOffset);
            this.readImageFileDirectory(dataInputStream, 4);
        }
    }

    private static final int $$robo$$android_media_ExifInterface$getIfdHintFromTagNumber(int tagNumber) {
        for (int i = 0; i < IFD_POINTER_TAG_HINTS.length; ++i) {
            if (ExifInterface.IFD_POINTER_TAGS[i].number != tagNumber) continue;
            return IFD_POINTER_TAG_HINTS[i];
        }
        return -1;
    }

    private final int $$robo$$android_media_ExifInterface$writeExifSegment(ByteOrderAwarenessDataOutputStream dataOutputStream, int exifOffsetFromBeginning) throws IOException {
        int[] ifdOffsets = new int[EXIF_TAGS.length];
        int[] ifdDataSizes = new int[EXIF_TAGS.length];
        for (ExifTag tag : IFD_POINTER_TAGS) {
            this.removeAttribute(tag.name);
        }
        this.removeAttribute(ExifInterface.JPEG_INTERCHANGE_FORMAT_TAG.name);
        this.removeAttribute(ExifInterface.JPEG_INTERCHANGE_FORMAT_LENGTH_TAG.name);
        for (int hint = 0; hint < EXIF_TAGS.length; ++hint) {
            for (Object obj : this.mAttributes[hint].entrySet().toArray()) {
                Map.Entry entry = (Map.Entry)obj;
                if (entry.getValue() != null) continue;
                this.mAttributes[hint].remove(entry.getKey());
            }
        }
        if (!this.mAttributes[3].isEmpty()) {
            this.mAttributes[1].put(ExifInterface.IFD_POINTER_TAGS[2].name, ExifAttribute.createULong(0L, this.mExifByteOrder));
        }
        if (!this.mAttributes[1].isEmpty()) {
            this.mAttributes[0].put(ExifInterface.IFD_POINTER_TAGS[0].name, ExifAttribute.createULong(0L, this.mExifByteOrder));
        }
        if (!this.mAttributes[2].isEmpty()) {
            this.mAttributes[0].put(ExifInterface.IFD_POINTER_TAGS[1].name, ExifAttribute.createULong(0L, this.mExifByteOrder));
        }
        if (this.mHasThumbnail) {
            this.mAttributes[0].put(ExifInterface.JPEG_INTERCHANGE_FORMAT_TAG.name, ExifAttribute.createULong(0L, this.mExifByteOrder));
            this.mAttributes[0].put(ExifInterface.JPEG_INTERCHANGE_FORMAT_LENGTH_TAG.name, ExifAttribute.createULong(this.mThumbnailLength, this.mExifByteOrder));
        }
        int i = 0;
        while (i < EXIF_TAGS.length) {
            int sum = 0;
            for (Map.Entry entry : this.mAttributes[i].entrySet()) {
                ExifAttribute exifAttribute = (ExifAttribute)entry.getValue();
                int size = exifAttribute.size();
                if (size <= 4) continue;
                sum += size;
            }
            int n = i++;
            ifdDataSizes[n] = ifdDataSizes[n] + sum;
        }
        int position = 8;
        for (int hint = 0; hint < EXIF_TAGS.length; ++hint) {
            if (this.mAttributes[hint].isEmpty()) continue;
            ifdOffsets[hint] = position;
            position += 2 + this.mAttributes[hint].size() * 12 + 4 + ifdDataSizes[hint];
        }
        if (this.mHasThumbnail) {
            int thumbnailOffset = position;
            this.mAttributes[0].put(ExifInterface.JPEG_INTERCHANGE_FORMAT_TAG.name, ExifAttribute.createULong(thumbnailOffset, this.mExifByteOrder));
            this.mThumbnailOffset = exifOffsetFromBeginning + thumbnailOffset;
            position += this.mThumbnailLength;
        }
        int totalSize = position + 8;
        if (!this.mAttributes[1].isEmpty()) {
            this.mAttributes[0].put(ExifInterface.IFD_POINTER_TAGS[0].name, ExifAttribute.createULong(ifdOffsets[1], this.mExifByteOrder));
        }
        if (!this.mAttributes[2].isEmpty()) {
            this.mAttributes[0].put(ExifInterface.IFD_POINTER_TAGS[1].name, ExifAttribute.createULong(ifdOffsets[2], this.mExifByteOrder));
        }
        if (!this.mAttributes[3].isEmpty()) {
            this.mAttributes[1].put(ExifInterface.IFD_POINTER_TAGS[2].name, ExifAttribute.createULong(ifdOffsets[3], this.mExifByteOrder));
        }
        dataOutputStream.writeUnsignedShort(totalSize);
        dataOutputStream.write(IDENTIFIER_EXIF_APP1);
        dataOutputStream.writeShort(this.mExifByteOrder == ByteOrder.BIG_ENDIAN ? (short)19789 : 18761);
        dataOutputStream.setByteOrder(this.mExifByteOrder);
        dataOutputStream.writeUnsignedShort(42);
        dataOutputStream.writeUnsignedInt(8L);
        for (int hint = 0; hint < EXIF_TAGS.length; ++hint) {
            if (this.mAttributes[hint].isEmpty()) continue;
            dataOutputStream.writeUnsignedShort(this.mAttributes[hint].size());
            int dataOffset = ifdOffsets[hint] + 2 + this.mAttributes[hint].size() * 12 + 4;
            for (Map.Entry entry : this.mAttributes[hint].entrySet()) {
                ExifTag tag = (ExifTag)sExifTagMapsForWriting[hint].get(entry.getKey());
                int tagNumber = tag.number;
                ExifAttribute attribute = (ExifAttribute)entry.getValue();
                int size = attribute.size();
                dataOutputStream.writeUnsignedShort(tagNumber);
                dataOutputStream.writeUnsignedShort(attribute.format);
                dataOutputStream.writeInt(attribute.numberOfComponents);
                if (size > 4) {
                    dataOutputStream.writeUnsignedInt(dataOffset);
                    dataOffset += size;
                    continue;
                }
                dataOutputStream.write(attribute.bytes);
                if (size >= 4) continue;
                for (int i2 = size; i2 < 4; ++i2) {
                    dataOutputStream.writeByte(0);
                }
            }
            if (hint == 0 && !this.mAttributes[4].isEmpty()) {
                dataOutputStream.writeUnsignedInt(ifdOffsets[4]);
            } else {
                dataOutputStream.writeUnsignedInt(0L);
            }
            for (Map.Entry entry : this.mAttributes[hint].entrySet()) {
                ExifAttribute attribute = (ExifAttribute)entry.getValue();
                if (attribute.bytes.length <= 4) continue;
                dataOutputStream.write(attribute.bytes, 0, attribute.bytes.length);
            }
        }
        if (this.mHasThumbnail) {
            dataOutputStream.write(this.getThumbnail());
        }
        dataOutputStream.setByteOrder(ByteOrder.BIG_ENDIAN);
        return totalSize;
    }

    private static final Pair<Integer, Integer> $$robo$$android_media_ExifInterface$guessDataFormat(String entryValue) {
        if (entryValue.contains(",")) {
            String[] entryValues = entryValue.split(",");
            Pair<Integer, Integer> dataFormat = ExifInterface.guessDataFormat(entryValues[0]);
            if ((Integer)dataFormat.first == 2) {
                return dataFormat;
            }
            for (int i = 1; i < entryValues.length; ++i) {
                Pair<Integer, Integer> guessDataFormat = ExifInterface.guessDataFormat(entryValues[i]);
                int first = -1;
                int second = -1;
                if (guessDataFormat.first == dataFormat.first || guessDataFormat.second == dataFormat.first) {
                    first = (Integer)dataFormat.first;
                }
                if ((Integer)dataFormat.second != -1 && (guessDataFormat.first == dataFormat.second || guessDataFormat.second == dataFormat.second)) {
                    second = (Integer)dataFormat.second;
                }
                if (first == -1 && second == -1) {
                    return new Pair<Integer, Integer>(2, -1);
                }
                if (first == -1) {
                    dataFormat = new Pair<Integer, Integer>(second, -1);
                    continue;
                }
                if (second != -1) continue;
                dataFormat = new Pair<Integer, Integer>(first, -1);
            }
            return dataFormat;
        }
        if (entryValue.contains("/")) {
            String[] rationalNumber = entryValue.split("/");
            if (rationalNumber.length == 2) {
                try {
                    long numerator = Long.parseLong(rationalNumber[0]);
                    long denominator = Long.parseLong(rationalNumber[1]);
                    if (numerator < 0L || denominator < 0L) {
                        return new Pair<Integer, Integer>(10, -1);
                    }
                    if (numerator > Integer.MAX_VALUE || denominator > Integer.MAX_VALUE) {
                        return new Pair<Integer, Integer>(5, -1);
                    }
                    return new Pair<Integer, Integer>(10, 5);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return new Pair<Integer, Integer>(2, -1);
        }
        try {
            Long longValue = Long.parseLong(entryValue);
            if (longValue >= 0L && longValue <= 65535L) {
                return new Pair<Integer, Integer>(3, 4);
            }
            if (longValue < 0L) {
                return new Pair<Integer, Integer>(9, -1);
            }
            return new Pair<Integer, Integer>(4, -1);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Double.parseDouble(entryValue);
                return new Pair<Integer, Integer>(12, -1);
            }
            catch (NumberFormatException numberFormatException2) {
                return new Pair<Integer, Integer>(2, -1);
            }
        }
    }

    private static final void $$robo$$android_media_ExifInterface$nativeInitRaw() {
    }

    private static final byte[] $$robo$$android_media_ExifInterface$nativeGetThumbnailFromAsset(long l, int n, int n2) {
        return null;
    }

    private static final HashMap $$robo$$android_media_ExifInterface$nativeGetRawAttributesFromAsset(long l) {
        return null;
    }

    private static final HashMap $$robo$$android_media_ExifInterface$nativeGetRawAttributesFromFileDescriptor(FileDescriptor fileDescriptor) {
        return null;
    }

    private static final HashMap $$robo$$android_media_ExifInterface$nativeGetRawAttributesFromInputStream(InputStream inputStream) {
        return null;
    }

    static void __staticInitializer__() {
        JPEG_SIGNATURE = new byte[]{-1, -40, -1};
        IFD_FORMAT_NAMES = new String[]{"", "BYTE", "STRING", "USHORT", "ULONG", "URATIONAL", "SBYTE", "UNDEFINED", "SSHORT", "SLONG", "SRATIONAL", "SINGLE", "DOUBLE"};
        IFD_FORMAT_BYTES_PER_FORMAT = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};
        EXIF_ASCII_PREFIX = new byte[]{65, 83, 67, 73, 73, 0, 0, 0};
        IFD_TIFF_TAGS = new ExifTag[]{new ExifTag("ImageWidth", 256, 3, 4), new ExifTag("ImageLength", 257, 3, 4), new ExifTag("BitsPerSample", 258, 3), new ExifTag("Compression", 259, 3), new ExifTag("PhotometricInterpretation", 262, 3), new ExifTag("ImageDescription", 270, 2), new ExifTag("Make", 271, 2), new ExifTag("Model", 272, 2), new ExifTag("StripOffsets", 273, 3, 4), new ExifTag("Orientation", 274, 3), new ExifTag("SamplesPerPixel", 277, 3), new ExifTag("RowsPerStrip", 278, 3, 4), new ExifTag("StripByteCounts", 279, 3, 4), new ExifTag("XResolution", 282, 5), new ExifTag("YResolution", 283, 5), new ExifTag("PlanarConfiguration", 284, 3), new ExifTag("ResolutionUnit", 296, 3), new ExifTag("TransferFunction", 301, 3), new ExifTag("Software", 305, 2), new ExifTag("DateTime", 306, 2), new ExifTag("Artist", 315, 2), new ExifTag("WhitePoint", 318, 5), new ExifTag("PrimaryChromaticities", 319, 5), new ExifTag("JPEGInterchangeFormat", 513, 4), new ExifTag("JPEGInterchangeFormatLength", 514, 4), new ExifTag("YCbCrCoefficients", 529, 5), new ExifTag("YCbCrSubSampling", 530, 3), new ExifTag("YCbCrPositioning", 531, 3), new ExifTag("ReferenceBlackWhite", 532, 5), new ExifTag("Copyright", 33432, 2), new ExifTag("ExifIFDPointer", 34665, 4), new ExifTag("GPSInfoIFDPointer", 34853, 4)};
        IFD_EXIF_TAGS = new ExifTag[]{new ExifTag("ExposureTime", 33434, 5), new ExifTag("FNumber", 33437, 5), new ExifTag("ExposureProgram", 34850, 3), new ExifTag("SpectralSensitivity", 34852, 2), new ExifTag("ISOSpeedRatings", 34855, 3), new ExifTag("OECF", 34856, 7), new ExifTag("ExifVersion", 36864, 2), new ExifTag("DateTimeOriginal", 36867, 2), new ExifTag("DateTimeDigitized", 36868, 2), new ExifTag("ComponentsConfiguration", 37121, 7), new ExifTag("CompressedBitsPerPixel", 37122, 5), new ExifTag("ShutterSpeedValue", 37377, 10), new ExifTag("ApertureValue", 37378, 5), new ExifTag("BrightnessValue", 37379, 10), new ExifTag("ExposureBiasValue", 37380, 10), new ExifTag("MaxApertureValue", 37381, 5), new ExifTag("SubjectDistance", 37382, 5), new ExifTag("MeteringMode", 37383, 3), new ExifTag("LightSource", 37384, 3), new ExifTag("Flash", 37385, 3), new ExifTag("FocalLength", 37386, 5), new ExifTag("SubjectArea", 37396, 3), new ExifTag("MakerNote", 37500, 7), new ExifTag("UserComment", 37510, 7), new ExifTag("SubSecTime", 37520, 2), new ExifTag("SubSecTimeOriginal", 37521, 2), new ExifTag("SubSecTimeDigitized", 37522, 2), new ExifTag("FlashpixVersion", 40960, 7), new ExifTag("ColorSpace", 40961, 3), new ExifTag("PixelXDimension", 40962, 3, 4), new ExifTag("PixelYDimension", 40963, 3, 4), new ExifTag("RelatedSoundFile", 40964, 2), new ExifTag("InteroperabilityIFDPointer", 40965, 4), new ExifTag("FlashEnergy", 41483, 5), new ExifTag("SpatialFrequencyResponse", 41484, 7), new ExifTag("FocalPlaneXResolution", 41486, 5), new ExifTag("FocalPlaneYResolution", 41487, 5), new ExifTag("FocalPlaneResolutionUnit", 41488, 3), new ExifTag("SubjectLocation", 41492, 3), new ExifTag("ExposureIndex", 41493, 5), new ExifTag("SensingMethod", 41495, 3), new ExifTag("FileSource", 41728, 7), new ExifTag("SceneType", 41729, 7), new ExifTag("CFAPattern", 41730, 7), new ExifTag("CustomRendered", 41985, 3), new ExifTag("ExposureMode", 41986, 3), new ExifTag("WhiteBalance", 41987, 3), new ExifTag("DigitalZoomRatio", 41988, 5), new ExifTag("FocalLengthIn35mmFilm", 41989, 3), new ExifTag("SceneCaptureType", 41990, 3), new ExifTag("GainControl", 41991, 3), new ExifTag("Contrast", 41992, 3), new ExifTag("Saturation", 41993, 3), new ExifTag("Sharpness", 41994, 3), new ExifTag("DeviceSettingDescription", 41995, 7), new ExifTag("SubjectDistanceRange", 41996, 3), new ExifTag("ImageUniqueID", 42016, 2)};
        IFD_GPS_TAGS = new ExifTag[]{new ExifTag("GPSVersionID", 0, 1), new ExifTag("GPSLatitudeRef", 1, 2), new ExifTag("GPSLatitude", 2, 5), new ExifTag("GPSLongitudeRef", 3, 2), new ExifTag("GPSLongitude", 4, 5), new ExifTag("GPSAltitudeRef", 5, 1), new ExifTag("GPSAltitude", 6, 5), new ExifTag("GPSTimeStamp", 7, 5), new ExifTag("GPSSatellites", 8, 2), new ExifTag("GPSStatus", 9, 2), new ExifTag("GPSMeasureMode", 10, 2), new ExifTag("GPSDOP", 11, 5), new ExifTag("GPSSpeedRef", 12, 2), new ExifTag("GPSSpeed", 13, 5), new ExifTag("GPSTrackRef", 14, 2), new ExifTag("GPSTrack", 15, 5), new ExifTag("GPSImgDirectionRef", 16, 2), new ExifTag("GPSImgDirection", 17, 5), new ExifTag("GPSMapDatum", 18, 2), new ExifTag("GPSDestLatitudeRef", 19, 2), new ExifTag("GPSDestLatitude", 20, 5), new ExifTag("GPSDestLongitudeRef", 21, 2), new ExifTag("GPSDestLongitude", 22, 5), new ExifTag("GPSDestBearingRef", 23, 2), new ExifTag("GPSDestBearing", 24, 5), new ExifTag("GPSDestDistanceRef", 25, 2), new ExifTag("GPSDestDistance", 26, 5), new ExifTag("GPSProcessingMethod", 27, 7), new ExifTag("GPSAreaInformation", 28, 7), new ExifTag("GPSDateStamp", 29, 2), new ExifTag("GPSDifferential", 30, 3)};
        IFD_INTEROPERABILITY_TAGS = new ExifTag[]{new ExifTag("InteroperabilityIndex", 1, 2)};
        IFD_THUMBNAIL_TAGS = new ExifTag[]{new ExifTag("ThumbnailImageWidth", 256, 3, 4), new ExifTag("ThumbnailImageLength", 257, 3, 4), new ExifTag("BitsPerSample", 258, 3), new ExifTag("Compression", 259, 3), new ExifTag("PhotometricInterpretation", 262, 3), new ExifTag("ImageDescription", 270, 2), new ExifTag("Make", 271, 2), new ExifTag("Model", 272, 2), new ExifTag("StripOffsets", 3, 4), new ExifTag("Orientation", 274, 3), new ExifTag("SamplesPerPixel", 277, 3), new ExifTag("RowsPerStrip", 278, 3, 4), new ExifTag("StripByteCounts", 279, 3, 4), new ExifTag("XResolution", 282, 5), new ExifTag("YResolution", 283, 5), new ExifTag("PlanarConfiguration", 284, 3), new ExifTag("ResolutionUnit", 296, 3), new ExifTag("TransferFunction", 301, 3), new ExifTag("Software", 305, 2), new ExifTag("DateTime", 306, 2), new ExifTag("Artist", 315, 2), new ExifTag("WhitePoint", 318, 5), new ExifTag("PrimaryChromaticities", 319, 5), new ExifTag("JPEGInterchangeFormat", 513, 4), new ExifTag("JPEGInterchangeFormatLength", 514, 4), new ExifTag("YCbCrCoefficients", 529, 5), new ExifTag("YCbCrSubSampling", 530, 3), new ExifTag("YCbCrPositioning", 531, 3), new ExifTag("ReferenceBlackWhite", 532, 5), new ExifTag("Copyright", 33432, 2), new ExifTag("ExifIFDPointer", 34665, 4), new ExifTag("GPSInfoIFDPointer", 34853, 4)};
        EXIF_TAGS = new ExifTag[][]{IFD_TIFF_TAGS, IFD_EXIF_TAGS, IFD_GPS_TAGS, IFD_INTEROPERABILITY_TAGS, IFD_THUMBNAIL_TAGS};
        IFD_POINTER_TAGS = new ExifTag[]{new ExifTag("ExifIFDPointer", 34665, 4), new ExifTag("GPSInfoIFDPointer", 34853, 4), new ExifTag("InteroperabilityIFDPointer", 40965, 4)};
        IFD_POINTER_TAG_HINTS = new int[]{1, 2, 3};
        JPEG_INTERCHANGE_FORMAT_TAG = new ExifTag("JPEGInterchangeFormat", 513, 4);
        JPEG_INTERCHANGE_FORMAT_LENGTH_TAG = new ExifTag("JPEGInterchangeFormatLength", 514, 4);
        sExifTagMapsForReading = new HashMap[EXIF_TAGS.length];
        sExifTagMapsForWriting = new HashMap[EXIF_TAGS.length];
        sTagSetForCompatibility = new HashSet<String>(Arrays.asList("FNumber", "DigitalZoomRatio", "ExposureTime", "SubjectDistance", "GPSTimeStamp"));
        ASCII = Charset.forName("US-ASCII");
        IDENTIFIER_EXIF_APP1 = "Exif\u0000\u0000".getBytes(ASCII);
        InvokeDynamicSupport.bootstrapIntrinsic("loadLibrary", "java.lang.System", (String)"media_jni");
        ExifInterface.nativeInitRaw();
        sFormatter = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
        sFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        for (int hint = 0; hint < EXIF_TAGS.length; ++hint) {
            ExifInterface.sExifTagMapsForReading[hint] = new HashMap();
            ExifInterface.sExifTagMapsForWriting[hint] = new HashMap();
            for (ExifTag tag : EXIF_TAGS[hint]) {
                sExifTagMapsForReading[hint].put(tag.number, tag);
                sExifTagMapsForWriting[hint].put(tag.name, tag);
            }
        }
        sNonZeroTimePattern = Pattern.compile(".*[1-9].*");
        sGpsTimestampPattern = Pattern.compile("^([0-9][0-9]):([0-9][0-9]):([0-9][0-9])$");
    }

    private void __constructor__(String string2) throws IOException {
        this.$$robo$$android_media_ExifInterface$__constructor__(string2);
    }

    public ExifInterface(String string2) throws IOException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_ExifInterface$__constructor__(java.lang.String ), 0, this, string2);
    }

    private void __constructor__(FileDescriptor fileDescriptor) throws IOException {
        this.$$robo$$android_media_ExifInterface$__constructor__(fileDescriptor);
    }

    public ExifInterface(FileDescriptor fileDescriptor) throws IOException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_ExifInterface$__constructor__(java.io.FileDescriptor ), 0, this, fileDescriptor);
    }

    private void __constructor__(InputStream inputStream) throws IOException {
        this.$$robo$$android_media_ExifInterface$__constructor__(inputStream);
    }

    public ExifInterface(InputStream inputStream) throws IOException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_ExifInterface$__constructor__(java.io.InputStream ), 0, this, inputStream);
    }

    private ExifAttribute getExifAttribute(String string2) {
        return InvokeDynamicSupport.bootstrap("getExifAttribute", $$robo$$android_media_ExifInterface$getExifAttribute(java.lang.String ), 0, this, string2);
    }

    public String getAttribute(String string2) {
        return InvokeDynamicSupport.bootstrap("getAttribute", $$robo$$android_media_ExifInterface$getAttribute(java.lang.String ), 0, this, string2);
    }

    public int getAttributeInt(String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrap("getAttributeInt", $$robo$$android_media_ExifInterface$getAttributeInt(java.lang.String int ), 0, this, string2, n);
    }

    public double getAttributeDouble(String string2, double d) {
        return (double)InvokeDynamicSupport.bootstrap("getAttributeDouble", $$robo$$android_media_ExifInterface$getAttributeDouble(java.lang.String double ), 0, this, string2, d);
    }

    public void setAttribute(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("setAttribute", $$robo$$android_media_ExifInterface$setAttribute(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    private boolean updateAttribute(String string2, ExifAttribute exifAttribute) {
        return (boolean)InvokeDynamicSupport.bootstrap("updateAttribute", $$robo$$android_media_ExifInterface$updateAttribute(java.lang.String android.media.ExifInterface$ExifAttribute ), 0, this, string2, exifAttribute);
    }

    private void removeAttribute(String string2) {
        InvokeDynamicSupport.bootstrap("removeAttribute", $$robo$$android_media_ExifInterface$removeAttribute(java.lang.String ), 0, this, string2);
    }

    private void loadAttributes(InputStream inputStream) throws IOException {
        InvokeDynamicSupport.bootstrap("loadAttributes", $$robo$$android_media_ExifInterface$loadAttributes(java.io.InputStream ), 0, this, inputStream);
    }

    private static boolean isJpegInputStream(BufferedInputStream bufferedInputStream) throws IOException {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isJpegInputStream", $$robo$$android_media_ExifInterface$isJpegInputStream(java.io.BufferedInputStream ), 0, (BufferedInputStream)bufferedInputStream);
    }

    private boolean handleRawResult(HashMap hashMap) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleRawResult", $$robo$$android_media_ExifInterface$handleRawResult(java.util.HashMap ), 0, this, hashMap);
    }

    private static boolean isSeekableFD(FileDescriptor fileDescriptor) throws IOException {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSeekableFD", $$robo$$android_media_ExifInterface$isSeekableFD(java.io.FileDescriptor ), 0, (FileDescriptor)fileDescriptor);
    }

    private void printAttributes() {
        InvokeDynamicSupport.bootstrap("printAttributes", $$robo$$android_media_ExifInterface$printAttributes(), 0, this);
    }

    public void saveAttributes() throws IOException {
        InvokeDynamicSupport.bootstrap("saveAttributes", $$robo$$android_media_ExifInterface$saveAttributes(), 0, this);
    }

    public boolean hasThumbnail() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasThumbnail", $$robo$$android_media_ExifInterface$hasThumbnail(), 0, this);
    }

    public byte[] getThumbnail() {
        return InvokeDynamicSupport.bootstrap("getThumbnail", $$robo$$android_media_ExifInterface$getThumbnail(), 0, this);
    }

    public long[] getThumbnailRange() {
        return InvokeDynamicSupport.bootstrap("getThumbnailRange", $$robo$$android_media_ExifInterface$getThumbnailRange(), 0, this);
    }

    public boolean getLatLong(float[] fArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("getLatLong", $$robo$$android_media_ExifInterface$getLatLong(float[] ), 0, this, fArray);
    }

    public double getAltitude(double d) {
        return (double)InvokeDynamicSupport.bootstrap("getAltitude", $$robo$$android_media_ExifInterface$getAltitude(double ), 0, this, d);
    }

    public long getDateTime() {
        return (long)InvokeDynamicSupport.bootstrap("getDateTime", $$robo$$android_media_ExifInterface$getDateTime(), 0, this);
    }

    public long getGpsDateTime() {
        return (long)InvokeDynamicSupport.bootstrap("getGpsDateTime", $$robo$$android_media_ExifInterface$getGpsDateTime(), 0, this);
    }

    private static float convertRationalLatLonToFloat(String string2, String string3) {
        return (float)InvokeDynamicSupport.bootstrapStatic("convertRationalLatLonToFloat", $$robo$$android_media_ExifInterface$convertRationalLatLonToFloat(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    private void getJpegAttributes(InputStream inputStream) throws IOException {
        InvokeDynamicSupport.bootstrap("getJpegAttributes", $$robo$$android_media_ExifInterface$getJpegAttributes(java.io.InputStream ), 0, this, inputStream);
    }

    private void saveJpegAttributes(InputStream inputStream, OutputStream outputStream) throws IOException {
        InvokeDynamicSupport.bootstrap("saveJpegAttributes", $$robo$$android_media_ExifInterface$saveJpegAttributes(java.io.InputStream java.io.OutputStream ), 0, this, inputStream, outputStream);
    }

    private void readExifSegment(byte[] byArray, int n) throws IOException {
        InvokeDynamicSupport.bootstrap("readExifSegment", $$robo$$android_media_ExifInterface$readExifSegment(byte[] int ), 0, this, byArray, n);
    }

    private void addDefaultValuesForCompatibility() {
        InvokeDynamicSupport.bootstrap("addDefaultValuesForCompatibility", $$robo$$android_media_ExifInterface$addDefaultValuesForCompatibility(), 0, this);
    }

    private void readImageFileDirectory(ByteOrderAwarenessDataInputStream byteOrderAwarenessDataInputStream, int n) throws IOException {
        InvokeDynamicSupport.bootstrap("readImageFileDirectory", $$robo$$android_media_ExifInterface$readImageFileDirectory(android.media.ExifInterface$ByteOrderAwarenessDataInputStream int ), 0, this, byteOrderAwarenessDataInputStream, n);
    }

    private static int getIfdHintFromTagNumber(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getIfdHintFromTagNumber", $$robo$$android_media_ExifInterface$getIfdHintFromTagNumber(int ), 0, (int)n);
    }

    private int writeExifSegment(ByteOrderAwarenessDataOutputStream byteOrderAwarenessDataOutputStream, int n) throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("writeExifSegment", $$robo$$android_media_ExifInterface$writeExifSegment(android.media.ExifInterface$ByteOrderAwarenessDataOutputStream int ), 0, this, byteOrderAwarenessDataOutputStream, n);
    }

    private static Pair<Integer, Integer> guessDataFormat(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("guessDataFormat", $$robo$$android_media_ExifInterface$guessDataFormat(java.lang.String ), 0, (String)string2);
    }

    private static final native /* synthetic */ void $$robo$$nativeInitRaw$nativeBinding();

    private static void nativeInitRaw() {
        InvokeDynamicSupport.bootstrapStatic("nativeInitRaw", $$robo$$android_media_ExifInterface$nativeInitRaw(), 1);
    }

    private static final native /* synthetic */ byte[] $$robo$$nativeGetThumbnailFromAsset$nativeBinding(long var0, int var2, int var3);

    private static byte[] nativeGetThumbnailFromAsset(long l, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("nativeGetThumbnailFromAsset", $$robo$$android_media_ExifInterface$nativeGetThumbnailFromAsset(long int int ), 1, (long)l, (int)n, (int)n2);
    }

    private static final native /* synthetic */ HashMap $$robo$$nativeGetRawAttributesFromAsset$nativeBinding(long var0);

    private static HashMap nativeGetRawAttributesFromAsset(long l) {
        return InvokeDynamicSupport.bootstrapStatic("nativeGetRawAttributesFromAsset", $$robo$$android_media_ExifInterface$nativeGetRawAttributesFromAsset(long ), 1, (long)l);
    }

    private static final native /* synthetic */ HashMap $$robo$$nativeGetRawAttributesFromFileDescriptor$nativeBinding(FileDescriptor var0);

    private static HashMap nativeGetRawAttributesFromFileDescriptor(FileDescriptor fileDescriptor) {
        return InvokeDynamicSupport.bootstrapStatic("nativeGetRawAttributesFromFileDescriptor", $$robo$$android_media_ExifInterface$nativeGetRawAttributesFromFileDescriptor(java.io.FileDescriptor ), 1, (FileDescriptor)fileDescriptor);
    }

    private static final native /* synthetic */ HashMap $$robo$$nativeGetRawAttributesFromInputStream$nativeBinding(InputStream var0);

    private static HashMap nativeGetRawAttributesFromInputStream(InputStream inputStream) {
        return InvokeDynamicSupport.bootstrapStatic("nativeGetRawAttributesFromInputStream", $$robo$$android_media_ExifInterface$nativeGetRawAttributesFromInputStream(java.io.InputStream ), 1, (InputStream)inputStream);
    }

    static {
        RobolectricInternals.classInitializing(ExifInterface.class);
    }

    public /* synthetic */ ExifInterface() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ExifInterface)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class ByteOrderAwarenessDataOutputStream
    extends FilterOutputStream
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private OutputStream mOutputStream;
        private ByteOrder mByteOrder;

        private void $$robo$$android_media_ExifInterface_ByteOrderAwarenessDataOutputStream$__constructor__(OutputStream out, ByteOrder byteOrder) {
            this.mOutputStream = out;
            this.mByteOrder = byteOrder;
        }

        private final void $$robo$$android_media_ExifInterface_ByteOrderAwarenessDataOutputStream$setByteOrder(ByteOrder byteOrder) {
            this.mByteOrder = byteOrder;
        }

        private final void $$robo$$android_media_ExifInterface_ByteOrderAwarenessDataOutputStream$write(byte[] bytes) throws IOException {
            this.mOutputStream.write(bytes);
        }

        private final void $$robo$$android_media_ExifInterface_ByteOrderAwarenessDataOutputStream$write(byte[] bytes, int offset, int length) throws IOException {
            this.mOutputStream.write(bytes, offset, length);
        }

        private final void $$robo$$android_media_ExifInterface_ByteOrderAwarenessDataOutputStream$writeByte(int val) throws IOException {
            this.mOutputStream.write(val);
        }

        private final void $$robo$$android_media_ExifInterface_ByteOrderAwarenessDataOutputStream$writeShort(short val) throws IOException {
            if (this.mByteOrder == ByteOrder.LITTLE_ENDIAN) {
                this.mOutputStream.write(val >>> 0 & 0xFF);
                this.mOutputStream.write(val >>> 8 & 0xFF);
            } else if (this.mByteOrder == ByteOrder.BIG_ENDIAN) {
                this.mOutputStream.write(val >>> 8 & 0xFF);
                this.mOutputStream.write(val >>> 0 & 0xFF);
            }
        }

        private final void $$robo$$android_media_ExifInterface_ByteOrderAwarenessDataOutputStream$writeInt(int val) throws IOException {
            if (this.mByteOrder == ByteOrder.LITTLE_ENDIAN) {
                this.mOutputStream.write(val >>> 0 & 0xFF);
                this.mOutputStream.write(val >>> 8 & 0xFF);
                this.mOutputStream.write(val >>> 16 & 0xFF);
                this.mOutputStream.write(val >>> 24 & 0xFF);
            } else if (this.mByteOrder == ByteOrder.BIG_ENDIAN) {
                this.mOutputStream.write(val >>> 24 & 0xFF);
                this.mOutputStream.write(val >>> 16 & 0xFF);
                this.mOutputStream.write(val >>> 8 & 0xFF);
                this.mOutputStream.write(val >>> 0 & 0xFF);
            }
        }

        private final void $$robo$$android_media_ExifInterface_ByteOrderAwarenessDataOutputStream$writeUnsignedShort(int val) throws IOException {
            this.writeShort((short)val);
        }

        private final void $$robo$$android_media_ExifInterface_ByteOrderAwarenessDataOutputStream$writeUnsignedInt(long val) throws IOException {
            this.writeInt((int)val);
        }

        private void __constructor__(OutputStream outputStream, ByteOrder byteOrder) {
            this.$$robo$$android_media_ExifInterface_ByteOrderAwarenessDataOutputStream$__constructor__(outputStream, byteOrder);
        }

        public ByteOrderAwarenessDataOutputStream(OutputStream outputStream, ByteOrder byteOrder) {
            super(outputStream);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_ExifInterface_ByteOrderAwarenessDataOutputStream$__constructor__(java.io.OutputStream java.nio.ByteOrder ), 0, this, outputStream, byteOrder);
        }

        public void setByteOrder(ByteOrder byteOrder) {
            InvokeDynamicSupport.bootstrap("setByteOrder", $$robo$$android_media_ExifInterface_ByteOrderAwarenessDataOutputStream$setByteOrder(java.nio.ByteOrder ), 0, this, byteOrder);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            InvokeDynamicSupport.bootstrap("write", $$robo$$android_media_ExifInterface_ByteOrderAwarenessDataOutputStream$write(byte[] ), 0, this, byArray);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            InvokeDynamicSupport.bootstrap("write", $$robo$$android_media_ExifInterface_ByteOrderAwarenessDataOutputStream$write(byte[] int int ), 0, this, byArray, n, n2);
        }

        public void writeByte(int n) throws IOException {
            InvokeDynamicSupport.bootstrap("writeByte", $$robo$$android_media_ExifInterface_ByteOrderAwarenessDataOutputStream$writeByte(int ), 0, this, n);
        }

        public void writeShort(short s) throws IOException {
            InvokeDynamicSupport.bootstrap("writeShort", $$robo$$android_media_ExifInterface_ByteOrderAwarenessDataOutputStream$writeShort(short ), 0, this, s);
        }

        public void writeInt(int n) throws IOException {
            InvokeDynamicSupport.bootstrap("writeInt", $$robo$$android_media_ExifInterface_ByteOrderAwarenessDataOutputStream$writeInt(int ), 0, this, n);
        }

        public void writeUnsignedShort(int n) throws IOException {
            InvokeDynamicSupport.bootstrap("writeUnsignedShort", $$robo$$android_media_ExifInterface_ByteOrderAwarenessDataOutputStream$writeUnsignedShort(int ), 0, this, n);
        }

        public void writeUnsignedInt(long l) throws IOException {
            InvokeDynamicSupport.bootstrap("writeUnsignedInt", $$robo$$android_media_ExifInterface_ByteOrderAwarenessDataOutputStream$writeUnsignedInt(long ), 0, this, l);
        }

        public /* synthetic */ ByteOrderAwarenessDataOutputStream() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ByteOrderAwarenessDataOutputStream)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class ByteOrderAwarenessDataInputStream
    extends ByteArrayInputStream
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static ByteOrder LITTLE_ENDIAN;
        private static ByteOrder BIG_ENDIAN;
        private ByteOrder mByteOrder;
        private long mLength;
        private long mPosition;

        private void $$robo$$android_media_ExifInterface_ByteOrderAwarenessDataInputStream$__constructor__(byte[] bytes) {
            this.mByteOrder = ByteOrder.BIG_ENDIAN;
            this.mLength = bytes.length;
            this.mPosition = 0L;
        }

        private final void $$robo$$android_media_ExifInterface_ByteOrderAwarenessDataInputStream$setByteOrder(ByteOrder byteOrder) {
            this.mByteOrder = byteOrder;
        }

        private final void $$robo$$android_media_ExifInterface_ByteOrderAwarenessDataInputStream$seek(long byteCount) throws IOException {
            this.mPosition = 0L;
            this.reset();
            if (this.skip(byteCount) != byteCount) {
                throw new IOException("Couldn't seek up to the byteCount");
            }
        }

        private final long $$robo$$android_media_ExifInterface_ByteOrderAwarenessDataInputStream$peek() {
            return this.mPosition;
        }

        private final void $$robo$$android_media_ExifInterface_ByteOrderAwarenessDataInputStream$readFully(byte[] buffer) throws IOException {
            this.mPosition += (long)buffer.length;
            if (this.mPosition > this.mLength) {
                throw new EOFException();
            }
            if (super.read(buffer, 0, buffer.length) != buffer.length) {
                throw new IOException("Couldn't read up to the length of buffer");
            }
        }

        private final byte $$robo$$android_media_ExifInterface_ByteOrderAwarenessDataInputStream$readByte() throws IOException {
            ++this.mPosition;
            if (this.mPosition > this.mLength) {
                throw new EOFException();
            }
            int ch = super.read();
            if (ch < 0) {
                throw new EOFException();
            }
            return (byte)ch;
        }

        private final short $$robo$$android_media_ExifInterface_ByteOrderAwarenessDataInputStream$readShort() throws IOException {
            int ch2;
            this.mPosition += 2L;
            if (this.mPosition > this.mLength) {
                throw new EOFException();
            }
            int ch1 = super.read();
            if ((ch1 | (ch2 = super.read())) < 0) {
                throw new EOFException();
            }
            if (this.mByteOrder == LITTLE_ENDIAN) {
                return (short)((ch2 << 8) + ch1);
            }
            if (this.mByteOrder == BIG_ENDIAN) {
                return (short)((ch1 << 8) + ch2);
            }
            throw new IOException("Invalid byte order: " + this.mByteOrder);
        }

        private final int $$robo$$android_media_ExifInterface_ByteOrderAwarenessDataInputStream$readInt() throws IOException {
            int ch4;
            int ch3;
            int ch2;
            this.mPosition += 4L;
            if (this.mPosition > this.mLength) {
                throw new EOFException();
            }
            int ch1 = super.read();
            if ((ch1 | (ch2 = super.read()) | (ch3 = super.read()) | (ch4 = super.read())) < 0) {
                throw new EOFException();
            }
            if (this.mByteOrder == LITTLE_ENDIAN) {
                return (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + ch1;
            }
            if (this.mByteOrder == BIG_ENDIAN) {
                return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
            }
            throw new IOException("Invalid byte order: " + this.mByteOrder);
        }

        private final long $$robo$$android_media_ExifInterface_ByteOrderAwarenessDataInputStream$skip(long byteCount) {
            long skipped = super.skip(Math.min(byteCount, this.mLength - this.mPosition));
            this.mPosition += skipped;
            return skipped;
        }

        private final int $$robo$$android_media_ExifInterface_ByteOrderAwarenessDataInputStream$readUnsignedShort() throws IOException {
            int ch2;
            this.mPosition += 2L;
            if (this.mPosition > this.mLength) {
                throw new EOFException();
            }
            int ch1 = super.read();
            if ((ch1 | (ch2 = super.read())) < 0) {
                throw new EOFException();
            }
            if (this.mByteOrder == LITTLE_ENDIAN) {
                return (ch2 << 8) + ch1;
            }
            if (this.mByteOrder == BIG_ENDIAN) {
                return (ch1 << 8) + ch2;
            }
            throw new IOException("Invalid byte order: " + this.mByteOrder);
        }

        private final long $$robo$$android_media_ExifInterface_ByteOrderAwarenessDataInputStream$readUnsignedInt() throws IOException {
            return (long)this.readInt() & 0xFFFFFFFFL;
        }

        private final long $$robo$$android_media_ExifInterface_ByteOrderAwarenessDataInputStream$readLong() throws IOException {
            int ch8;
            int ch7;
            int ch6;
            int ch5;
            int ch4;
            int ch3;
            int ch2;
            this.mPosition += 8L;
            if (this.mPosition > this.mLength) {
                throw new EOFException();
            }
            int ch1 = super.read();
            if ((ch1 | (ch2 = super.read()) | (ch3 = super.read()) | (ch4 = super.read()) | (ch5 = super.read()) | (ch6 = super.read()) | (ch7 = super.read()) | (ch8 = super.read())) < 0) {
                throw new EOFException();
            }
            if (this.mByteOrder == LITTLE_ENDIAN) {
                return ((long)ch8 << 56) + ((long)ch7 << 48) + ((long)ch6 << 40) + ((long)ch5 << 32) + ((long)ch4 << 24) + ((long)ch3 << 16) + ((long)ch2 << 8) + (long)ch1;
            }
            if (this.mByteOrder == BIG_ENDIAN) {
                return ((long)ch1 << 56) + ((long)ch2 << 48) + ((long)ch3 << 40) + ((long)ch4 << 32) + ((long)ch5 << 24) + ((long)ch6 << 16) + ((long)ch7 << 8) + (long)ch8;
            }
            throw new IOException("Invalid byte order: " + this.mByteOrder);
        }

        private final float $$robo$$android_media_ExifInterface_ByteOrderAwarenessDataInputStream$readFloat() throws IOException {
            return Float.intBitsToFloat(this.readInt());
        }

        private final double $$robo$$android_media_ExifInterface_ByteOrderAwarenessDataInputStream$readDouble() throws IOException {
            return Double.longBitsToDouble(this.readLong());
        }

        static void __staticInitializer__() {
            LITTLE_ENDIAN = ByteOrder.LITTLE_ENDIAN;
            BIG_ENDIAN = ByteOrder.BIG_ENDIAN;
        }

        private void __constructor__(byte[] byArray) {
            this.$$robo$$android_media_ExifInterface_ByteOrderAwarenessDataInputStream$__constructor__(byArray);
        }

        public ByteOrderAwarenessDataInputStream(byte[] byArray) {
            super(byArray);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_ExifInterface_ByteOrderAwarenessDataInputStream$__constructor__(byte[] ), 0, this, byArray);
        }

        public void setByteOrder(ByteOrder byteOrder) {
            InvokeDynamicSupport.bootstrap("setByteOrder", $$robo$$android_media_ExifInterface_ByteOrderAwarenessDataInputStream$setByteOrder(java.nio.ByteOrder ), 0, this, byteOrder);
        }

        public void seek(long l) throws IOException {
            InvokeDynamicSupport.bootstrap("seek", $$robo$$android_media_ExifInterface_ByteOrderAwarenessDataInputStream$seek(long ), 0, this, l);
        }

        public long peek() {
            return (long)InvokeDynamicSupport.bootstrap("peek", $$robo$$android_media_ExifInterface_ByteOrderAwarenessDataInputStream$peek(), 0, this);
        }

        public void readFully(byte[] byArray) throws IOException {
            InvokeDynamicSupport.bootstrap("readFully", $$robo$$android_media_ExifInterface_ByteOrderAwarenessDataInputStream$readFully(byte[] ), 0, this, byArray);
        }

        public byte readByte() throws IOException {
            return (byte)InvokeDynamicSupport.bootstrap("readByte", $$robo$$android_media_ExifInterface_ByteOrderAwarenessDataInputStream$readByte(), 0, this);
        }

        public short readShort() throws IOException {
            return (short)InvokeDynamicSupport.bootstrap("readShort", $$robo$$android_media_ExifInterface_ByteOrderAwarenessDataInputStream$readShort(), 0, this);
        }

        public int readInt() throws IOException {
            return (int)InvokeDynamicSupport.bootstrap("readInt", $$robo$$android_media_ExifInterface_ByteOrderAwarenessDataInputStream$readInt(), 0, this);
        }

        @Override
        public long skip(long l) {
            return (long)InvokeDynamicSupport.bootstrap("skip", $$robo$$android_media_ExifInterface_ByteOrderAwarenessDataInputStream$skip(long ), 0, this, l);
        }

        public int readUnsignedShort() throws IOException {
            return (int)InvokeDynamicSupport.bootstrap("readUnsignedShort", $$robo$$android_media_ExifInterface_ByteOrderAwarenessDataInputStream$readUnsignedShort(), 0, this);
        }

        public long readUnsignedInt() throws IOException {
            return (long)InvokeDynamicSupport.bootstrap("readUnsignedInt", $$robo$$android_media_ExifInterface_ByteOrderAwarenessDataInputStream$readUnsignedInt(), 0, this);
        }

        public long readLong() throws IOException {
            return (long)InvokeDynamicSupport.bootstrap("readLong", $$robo$$android_media_ExifInterface_ByteOrderAwarenessDataInputStream$readLong(), 0, this);
        }

        public float readFloat() throws IOException {
            return (float)InvokeDynamicSupport.bootstrap("readFloat", $$robo$$android_media_ExifInterface_ByteOrderAwarenessDataInputStream$readFloat(), 0, this);
        }

        public double readDouble() throws IOException {
            return (double)InvokeDynamicSupport.bootstrap("readDouble", $$robo$$android_media_ExifInterface_ByteOrderAwarenessDataInputStream$readDouble(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(ByteOrderAwarenessDataInputStream.class);
        }

        public /* synthetic */ ByteOrderAwarenessDataInputStream() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ByteOrderAwarenessDataInputStream)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class ExifTag
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int number;
        public String name;
        public int primaryFormat;
        public int secondaryFormat;

        private void $$robo$$android_media_ExifInterface_ExifTag$__constructor__(String name, int number, int format) {
            this.name = name;
            this.number = number;
            this.primaryFormat = format;
            this.secondaryFormat = -1;
        }

        private void $$robo$$android_media_ExifInterface_ExifTag$__constructor__(String name, int number, int primaryFormat, int secondaryFormat) {
            this.name = name;
            this.number = number;
            this.primaryFormat = primaryFormat;
            this.secondaryFormat = secondaryFormat;
        }

        private /* synthetic */ void $$robo$$android_media_ExifInterface_ExifTag$__constructor__(String x0, int x1, int x2, int x3, 1 x4) {
        }

        private /* synthetic */ void $$robo$$android_media_ExifInterface_ExifTag$__constructor__(String x0, int x1, int x2, 1 x3) {
        }

        private void __constructor__(String string2, int n, int n2) {
            this.$$robo$$android_media_ExifInterface_ExifTag$__constructor__(string2, n, n2);
        }

        private ExifTag(String string2, int n, int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_ExifInterface_ExifTag$__constructor__(java.lang.String int int ), 0, this, string2, n, n2);
        }

        private void __constructor__(String string2, int n, int n2, int n3) {
            this.$$robo$$android_media_ExifInterface_ExifTag$__constructor__(string2, n, n2, n3);
        }

        private ExifTag(String string2, int n, int n2, int n3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_ExifInterface_ExifTag$__constructor__(java.lang.String int int int ), 0, this, string2, n, n2, n3);
        }

        private /* synthetic */ void __constructor__(String string2, int n, int n2, int n3, 1 var5_5) {
            this.$$robo$$android_media_ExifInterface_ExifTag$__constructor__(string2, n, n2, n3, var5_5);
        }

        private /* synthetic */ void __constructor__(String string2, int n, int n2, 1 var4_4) {
            this.$$robo$$android_media_ExifInterface_ExifTag$__constructor__(string2, n, n2, var4_4);
        }

        public /* synthetic */ ExifTag() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ExifTag)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class ExifAttribute
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int format;
        public int numberOfComponents;
        public byte[] bytes;

        private void $$robo$$android_media_ExifInterface_ExifAttribute$__constructor__(int format, int numberOfComponents, byte[] bytes) {
            this.format = format;
            this.numberOfComponents = numberOfComponents;
            this.bytes = bytes;
        }

        private static final ExifAttribute $$robo$$android_media_ExifInterface_ExifAttribute$createUShort(int[] values, ByteOrder byteOrder) {
            ByteBuffer buffer = ByteBuffer.wrap(new byte[IFD_FORMAT_BYTES_PER_FORMAT[3] * values.length]);
            buffer.order(byteOrder);
            for (int value : values) {
                buffer.putShort((short)value);
            }
            return new ExifAttribute(3, values.length, buffer.array());
        }

        private static final ExifAttribute $$robo$$android_media_ExifInterface_ExifAttribute$createUShort(int value, ByteOrder byteOrder) {
            return ExifAttribute.createUShort(new int[]{value}, byteOrder);
        }

        private static final ExifAttribute $$robo$$android_media_ExifInterface_ExifAttribute$createULong(long[] values, ByteOrder byteOrder) {
            ByteBuffer buffer = ByteBuffer.wrap(new byte[IFD_FORMAT_BYTES_PER_FORMAT[4] * values.length]);
            buffer.order(byteOrder);
            for (long value : values) {
                buffer.putInt((int)value);
            }
            return new ExifAttribute(4, values.length, buffer.array());
        }

        private static final ExifAttribute $$robo$$android_media_ExifInterface_ExifAttribute$createULong(long value, ByteOrder byteOrder) {
            return ExifAttribute.createULong(new long[]{value}, byteOrder);
        }

        private static final ExifAttribute $$robo$$android_media_ExifInterface_ExifAttribute$createSLong(int[] values, ByteOrder byteOrder) {
            ByteBuffer buffer = ByteBuffer.wrap(new byte[IFD_FORMAT_BYTES_PER_FORMAT[9] * values.length]);
            buffer.order(byteOrder);
            for (int value : values) {
                buffer.putInt(value);
            }
            return new ExifAttribute(9, values.length, buffer.array());
        }

        private static final ExifAttribute $$robo$$android_media_ExifInterface_ExifAttribute$createSLong(int value, ByteOrder byteOrder) {
            return ExifAttribute.createSLong(new int[]{value}, byteOrder);
        }

        private static final ExifAttribute $$robo$$android_media_ExifInterface_ExifAttribute$createByte(String value) {
            if (value.length() == 1 && value.charAt(0) >= '0' && value.charAt(0) <= '1') {
                byte[] bytes = new byte[]{(byte)(value.charAt(0) - 48)};
                return new ExifAttribute(1, bytes.length, bytes);
            }
            byte[] ascii = value.getBytes(ASCII);
            return new ExifAttribute(1, ascii.length, ascii);
        }

        private static final ExifAttribute $$robo$$android_media_ExifInterface_ExifAttribute$createString(String value) {
            byte[] ascii = (value + '\u0000').getBytes(ASCII);
            return new ExifAttribute(2, ascii.length, ascii);
        }

        private static final ExifAttribute $$robo$$android_media_ExifInterface_ExifAttribute$createURational(Rational[] values, ByteOrder byteOrder) {
            ByteBuffer buffer = ByteBuffer.wrap(new byte[IFD_FORMAT_BYTES_PER_FORMAT[5] * values.length]);
            buffer.order(byteOrder);
            for (Rational value : values) {
                buffer.putInt((int)value.numerator);
                buffer.putInt((int)value.denominator);
            }
            return new ExifAttribute(5, values.length, buffer.array());
        }

        private static final ExifAttribute $$robo$$android_media_ExifInterface_ExifAttribute$createURational(Rational value, ByteOrder byteOrder) {
            return ExifAttribute.createURational(new Rational[]{value}, byteOrder);
        }

        private static final ExifAttribute $$robo$$android_media_ExifInterface_ExifAttribute$createSRational(Rational[] values, ByteOrder byteOrder) {
            ByteBuffer buffer = ByteBuffer.wrap(new byte[IFD_FORMAT_BYTES_PER_FORMAT[10] * values.length]);
            buffer.order(byteOrder);
            for (Rational value : values) {
                buffer.putInt((int)value.numerator);
                buffer.putInt((int)value.denominator);
            }
            return new ExifAttribute(10, values.length, buffer.array());
        }

        private static final ExifAttribute $$robo$$android_media_ExifInterface_ExifAttribute$createSRational(Rational value, ByteOrder byteOrder) {
            return ExifAttribute.createSRational(new Rational[]{value}, byteOrder);
        }

        private static final ExifAttribute $$robo$$android_media_ExifInterface_ExifAttribute$createDouble(double[] values, ByteOrder byteOrder) {
            ByteBuffer buffer = ByteBuffer.wrap(new byte[IFD_FORMAT_BYTES_PER_FORMAT[12] * values.length]);
            buffer.order(byteOrder);
            for (double value : values) {
                buffer.putDouble(value);
            }
            return new ExifAttribute(12, values.length, buffer.array());
        }

        private static final ExifAttribute $$robo$$android_media_ExifInterface_ExifAttribute$createDouble(double value, ByteOrder byteOrder) {
            return ExifAttribute.createDouble(new double[]{value}, byteOrder);
        }

        private final String $$robo$$android_media_ExifInterface_ExifAttribute$toString() {
            return "(" + IFD_FORMAT_NAMES[this.format] + ", data length:" + this.bytes.length + ")";
        }

        private final Object $$robo$$android_media_ExifInterface_ExifAttribute$getValue(ByteOrder byteOrder) {
            try {
                ByteOrderAwarenessDataInputStream inputStream = new ByteOrderAwarenessDataInputStream(this.bytes);
                inputStream.setByteOrder(byteOrder);
                switch (this.format) {
                    case 1: 
                    case 6: {
                        if (this.bytes.length == 1 && this.bytes[0] >= 0 && this.bytes[0] <= 1) {
                            return new String(new char[]{(char)(this.bytes[0] + 48)});
                        }
                        return new String(this.bytes, ASCII);
                    }
                    case 2: 
                    case 7: {
                        byte ch;
                        int index = 0;
                        if (this.numberOfComponents >= EXIF_ASCII_PREFIX.length) {
                            boolean same = true;
                            for (int i = 0; i < EXIF_ASCII_PREFIX.length; ++i) {
                                if (this.bytes[i] == EXIF_ASCII_PREFIX[i]) continue;
                                same = false;
                                break;
                            }
                            if (same) {
                                index = EXIF_ASCII_PREFIX.length;
                            }
                        }
                        StringBuilder stringBuilder = new StringBuilder();
                        while (index < this.numberOfComponents && (ch = this.bytes[index]) != 0) {
                            if (ch >= 32) {
                                stringBuilder.append((char)ch);
                            } else {
                                stringBuilder.append('?');
                            }
                            ++index;
                        }
                        return stringBuilder.toString();
                    }
                    case 3: {
                        int[] values = new int[this.numberOfComponents];
                        for (int i = 0; i < this.numberOfComponents; ++i) {
                            values[i] = inputStream.readUnsignedShort();
                        }
                        return values;
                    }
                    case 4: {
                        long[] values = new long[this.numberOfComponents];
                        for (int i = 0; i < this.numberOfComponents; ++i) {
                            values[i] = inputStream.readUnsignedInt();
                        }
                        return values;
                    }
                    case 5: {
                        Rational[] values = new Rational[this.numberOfComponents];
                        for (int i = 0; i < this.numberOfComponents; ++i) {
                            long numerator = inputStream.readUnsignedInt();
                            long denominator = inputStream.readUnsignedInt();
                            values[i] = new Rational(numerator, denominator);
                        }
                        return values;
                    }
                    case 8: {
                        int[] values = new int[this.numberOfComponents];
                        for (int i = 0; i < this.numberOfComponents; ++i) {
                            values[i] = inputStream.readShort();
                        }
                        return values;
                    }
                    case 9: {
                        int[] values = new int[this.numberOfComponents];
                        for (int i = 0; i < this.numberOfComponents; ++i) {
                            values[i] = inputStream.readInt();
                        }
                        return values;
                    }
                    case 10: {
                        Rational[] values = new Rational[this.numberOfComponents];
                        for (int i = 0; i < this.numberOfComponents; ++i) {
                            long numerator = inputStream.readInt();
                            long denominator = inputStream.readInt();
                            values[i] = new Rational(numerator, denominator);
                        }
                        return values;
                    }
                    case 11: {
                        double[] values = new double[this.numberOfComponents];
                        for (int i = 0; i < this.numberOfComponents; ++i) {
                            values[i] = inputStream.readFloat();
                        }
                        return values;
                    }
                    case 12: {
                        double[] values = new double[this.numberOfComponents];
                        for (int i = 0; i < this.numberOfComponents; ++i) {
                            values[i] = inputStream.readDouble();
                        }
                        return values;
                    }
                }
                return null;
            }
            catch (IOException e) {
                Log.w("ExifInterface", "IOException occurred during reading a value", e);
                return null;
            }
        }

        private final double $$robo$$android_media_ExifInterface_ExifAttribute$getDoubleValue(ByteOrder byteOrder) {
            Object value = this.getValue(byteOrder);
            if (value == null) {
                throw new NumberFormatException("NULL can't be converted to a double value");
            }
            if (value instanceof String) {
                return Double.parseDouble((String)value);
            }
            if (value instanceof long[]) {
                long[] array2 = (long[])value;
                if (array2.length == 1) {
                    return array2[0];
                }
                throw new NumberFormatException("There are more than one component");
            }
            if (value instanceof int[]) {
                int[] array3 = (int[])value;
                if (array3.length == 1) {
                    return array3[0];
                }
                throw new NumberFormatException("There are more than one component");
            }
            if (value instanceof double[]) {
                double[] array4 = (double[])value;
                if (array4.length == 1) {
                    return array4[0];
                }
                throw new NumberFormatException("There are more than one component");
            }
            if (value instanceof Rational[]) {
                Rational[] array5 = (Rational[])value;
                if (array5.length == 1) {
                    return array5[0].calculate();
                }
                throw new NumberFormatException("There are more than one component");
            }
            throw new NumberFormatException("Couldn't find a double value");
        }

        private final int $$robo$$android_media_ExifInterface_ExifAttribute$getIntValue(ByteOrder byteOrder) {
            Object value = this.getValue(byteOrder);
            if (value == null) {
                throw new NumberFormatException("NULL can't be converted to a integer value");
            }
            if (value instanceof String) {
                return Integer.parseInt((String)value);
            }
            if (value instanceof long[]) {
                long[] array2 = (long[])value;
                if (array2.length == 1) {
                    return (int)array2[0];
                }
                throw new NumberFormatException("There are more than one component");
            }
            if (value instanceof int[]) {
                int[] array3 = (int[])value;
                if (array3.length == 1) {
                    return array3[0];
                }
                throw new NumberFormatException("There are more than one component");
            }
            throw new NumberFormatException("Couldn't find a integer value");
        }

        private final String $$robo$$android_media_ExifInterface_ExifAttribute$getStringValue(ByteOrder byteOrder) {
            Object value = this.getValue(byteOrder);
            if (value == null) {
                return null;
            }
            if (value instanceof String) {
                return (String)value;
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (value instanceof long[]) {
                long[] array2 = (long[])value;
                for (int i = 0; i < array2.length; ++i) {
                    stringBuilder.append(array2[i]);
                    if (i + 1 == array2.length) continue;
                    stringBuilder.append(",");
                }
                return stringBuilder.toString();
            }
            if (value instanceof int[]) {
                int[] array3 = (int[])value;
                for (int i = 0; i < array3.length; ++i) {
                    stringBuilder.append(array3[i]);
                    if (i + 1 == array3.length) continue;
                    stringBuilder.append(",");
                }
                return stringBuilder.toString();
            }
            if (value instanceof double[]) {
                double[] array4 = (double[])value;
                for (int i = 0; i < array4.length; ++i) {
                    stringBuilder.append(array4[i]);
                    if (i + 1 == array4.length) continue;
                    stringBuilder.append(",");
                }
                return stringBuilder.toString();
            }
            if (value instanceof Rational[]) {
                Rational[] array5 = (Rational[])value;
                for (int i = 0; i < array5.length; ++i) {
                    stringBuilder.append(array5[i].numerator);
                    stringBuilder.append('/');
                    stringBuilder.append(array5[i].denominator);
                    if (i + 1 == array5.length) continue;
                    stringBuilder.append(",");
                }
                return stringBuilder.toString();
            }
            return null;
        }

        private final int $$robo$$android_media_ExifInterface_ExifAttribute$size() {
            return IFD_FORMAT_BYTES_PER_FORMAT[this.format] * this.numberOfComponents;
        }

        private /* synthetic */ void $$robo$$android_media_ExifInterface_ExifAttribute$__constructor__(int x0, int x1, byte[] x2, 1 x3) {
        }

        private void __constructor__(int n, int n2, byte[] byArray) {
            this.$$robo$$android_media_ExifInterface_ExifAttribute$__constructor__(n, n2, byArray);
        }

        private ExifAttribute(int n, int n2, byte[] byArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_ExifInterface_ExifAttribute$__constructor__(int int byte[] ), 0, this, n, n2, byArray);
        }

        public static ExifAttribute createUShort(int[] nArray, ByteOrder byteOrder) {
            return InvokeDynamicSupport.bootstrapStatic("createUShort", $$robo$$android_media_ExifInterface_ExifAttribute$createUShort(int[] java.nio.ByteOrder ), 0, (int[])nArray, (ByteOrder)byteOrder);
        }

        public static ExifAttribute createUShort(int n, ByteOrder byteOrder) {
            return InvokeDynamicSupport.bootstrapStatic("createUShort", $$robo$$android_media_ExifInterface_ExifAttribute$createUShort(int java.nio.ByteOrder ), 0, (int)n, (ByteOrder)byteOrder);
        }

        public static ExifAttribute createULong(long[] lArray, ByteOrder byteOrder) {
            return InvokeDynamicSupport.bootstrapStatic("createULong", $$robo$$android_media_ExifInterface_ExifAttribute$createULong(long[] java.nio.ByteOrder ), 0, (long[])lArray, (ByteOrder)byteOrder);
        }

        public static ExifAttribute createULong(long l, ByteOrder byteOrder) {
            return InvokeDynamicSupport.bootstrapStatic("createULong", $$robo$$android_media_ExifInterface_ExifAttribute$createULong(long java.nio.ByteOrder ), 0, (long)l, (ByteOrder)byteOrder);
        }

        public static ExifAttribute createSLong(int[] nArray, ByteOrder byteOrder) {
            return InvokeDynamicSupport.bootstrapStatic("createSLong", $$robo$$android_media_ExifInterface_ExifAttribute$createSLong(int[] java.nio.ByteOrder ), 0, (int[])nArray, (ByteOrder)byteOrder);
        }

        public static ExifAttribute createSLong(int n, ByteOrder byteOrder) {
            return InvokeDynamicSupport.bootstrapStatic("createSLong", $$robo$$android_media_ExifInterface_ExifAttribute$createSLong(int java.nio.ByteOrder ), 0, (int)n, (ByteOrder)byteOrder);
        }

        public static ExifAttribute createByte(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("createByte", $$robo$$android_media_ExifInterface_ExifAttribute$createByte(java.lang.String ), 0, (String)string2);
        }

        public static ExifAttribute createString(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("createString", $$robo$$android_media_ExifInterface_ExifAttribute$createString(java.lang.String ), 0, (String)string2);
        }

        public static ExifAttribute createURational(Rational[] rationalArray, ByteOrder byteOrder) {
            return InvokeDynamicSupport.bootstrapStatic("createURational", $$robo$$android_media_ExifInterface_ExifAttribute$createURational(android.media.ExifInterface$Rational[] java.nio.ByteOrder ), 0, (Rational[])rationalArray, (ByteOrder)byteOrder);
        }

        public static ExifAttribute createURational(Rational rational, ByteOrder byteOrder) {
            return InvokeDynamicSupport.bootstrapStatic("createURational", $$robo$$android_media_ExifInterface_ExifAttribute$createURational(android.media.ExifInterface$Rational java.nio.ByteOrder ), 0, (Rational)rational, (ByteOrder)byteOrder);
        }

        public static ExifAttribute createSRational(Rational[] rationalArray, ByteOrder byteOrder) {
            return InvokeDynamicSupport.bootstrapStatic("createSRational", $$robo$$android_media_ExifInterface_ExifAttribute$createSRational(android.media.ExifInterface$Rational[] java.nio.ByteOrder ), 0, (Rational[])rationalArray, (ByteOrder)byteOrder);
        }

        public static ExifAttribute createSRational(Rational rational, ByteOrder byteOrder) {
            return InvokeDynamicSupport.bootstrapStatic("createSRational", $$robo$$android_media_ExifInterface_ExifAttribute$createSRational(android.media.ExifInterface$Rational java.nio.ByteOrder ), 0, (Rational)rational, (ByteOrder)byteOrder);
        }

        public static ExifAttribute createDouble(double[] dArray, ByteOrder byteOrder) {
            return InvokeDynamicSupport.bootstrapStatic("createDouble", $$robo$$android_media_ExifInterface_ExifAttribute$createDouble(double[] java.nio.ByteOrder ), 0, (double[])dArray, (ByteOrder)byteOrder);
        }

        public static ExifAttribute createDouble(double d, ByteOrder byteOrder) {
            return InvokeDynamicSupport.bootstrapStatic("createDouble", $$robo$$android_media_ExifInterface_ExifAttribute$createDouble(double java.nio.ByteOrder ), 0, (double)d, (ByteOrder)byteOrder);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_media_ExifInterface_ExifAttribute$toString(), 0, this);
        }

        private Object getValue(ByteOrder byteOrder) {
            return InvokeDynamicSupport.bootstrap("getValue", $$robo$$android_media_ExifInterface_ExifAttribute$getValue(java.nio.ByteOrder ), 0, this, byteOrder);
        }

        public double getDoubleValue(ByteOrder byteOrder) {
            return (double)InvokeDynamicSupport.bootstrap("getDoubleValue", $$robo$$android_media_ExifInterface_ExifAttribute$getDoubleValue(java.nio.ByteOrder ), 0, this, byteOrder);
        }

        public int getIntValue(ByteOrder byteOrder) {
            return (int)InvokeDynamicSupport.bootstrap("getIntValue", $$robo$$android_media_ExifInterface_ExifAttribute$getIntValue(java.nio.ByteOrder ), 0, this, byteOrder);
        }

        public String getStringValue(ByteOrder byteOrder) {
            return InvokeDynamicSupport.bootstrap("getStringValue", $$robo$$android_media_ExifInterface_ExifAttribute$getStringValue(java.nio.ByteOrder ), 0, this, byteOrder);
        }

        public int size() {
            return (int)InvokeDynamicSupport.bootstrap("size", $$robo$$android_media_ExifInterface_ExifAttribute$size(), 0, this);
        }

        private /* synthetic */ void __constructor__(int n, int n2, byte[] byArray, 1 var4_4) {
            this.$$robo$$android_media_ExifInterface_ExifAttribute$__constructor__(n, n2, byArray, var4_4);
        }

        public /* synthetic */ ExifAttribute() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ExifAttribute)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class Rational
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public long numerator;
        public long denominator;

        private void $$robo$$android_media_ExifInterface_Rational$__constructor__(long numerator, long denominator) {
            if (denominator == 0L) {
                this.numerator = 0L;
                this.denominator = 1L;
                return;
            }
            this.numerator = numerator;
            this.denominator = denominator;
        }

        private final String $$robo$$android_media_ExifInterface_Rational$toString() {
            return this.numerator + "/" + this.denominator;
        }

        private final double $$robo$$android_media_ExifInterface_Rational$calculate() {
            return (double)this.numerator / (double)this.denominator;
        }

        private /* synthetic */ void $$robo$$android_media_ExifInterface_Rational$__constructor__(long x0, long x1, 1 x2) {
        }

        private void __constructor__(long l, long l2) {
            this.$$robo$$android_media_ExifInterface_Rational$__constructor__(l, l2);
        }

        private Rational(long l, long l2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_ExifInterface_Rational$__constructor__(long long ), 0, this, l, l2);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_media_ExifInterface_Rational$toString(), 0, this);
        }

        public double calculate() {
            return (double)InvokeDynamicSupport.bootstrap("calculate", $$robo$$android_media_ExifInterface_Rational$calculate(), 0, this);
        }

        private /* synthetic */ void __constructor__(long l, long l2, 1 var5_3) {
            this.$$robo$$android_media_ExifInterface_Rational$__constructor__(l, l2, var5_3);
        }

        public /* synthetic */ Rational() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Rational)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

