/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.Printer;
import android.util.TimeUtils;
import java.text.DecimalFormat;
import java.util.StringTokenizer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Location
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int FORMAT_DEGREES = 0;
    public static int FORMAT_MINUTES = 1;
    public static int FORMAT_SECONDS = 2;
    public static String EXTRA_COARSE_LOCATION = "coarseLocation";
    public static String EXTRA_NO_GPS_LOCATION = "noGPSLocation";
    private static byte HAS_ALTITUDE_MASK = 1;
    private static byte HAS_SPEED_MASK = 2;
    private static byte HAS_BEARING_MASK = 4;
    private static byte HAS_ACCURACY_MASK = 8;
    private static byte HAS_MOCK_PROVIDER_MASK = 16;
    private static ThreadLocal<BearingDistanceCache> sBearingDistanceCache;
    private String mProvider;
    private long mTime;
    private long mElapsedRealtimeNanos;
    private double mLatitude;
    private double mLongitude;
    private double mAltitude;
    private float mSpeed;
    private float mBearing;
    private float mAccuracy;
    private Bundle mExtras;
    private byte mFieldsMask;
    public static Parcelable.Creator<Location> CREATOR;

    private void $$robo$$android_location_Location$__constructor__(String provider) {
        this.mTime = 0L;
        this.mElapsedRealtimeNanos = 0L;
        this.mLatitude = 0.0;
        this.mLongitude = 0.0;
        this.mAltitude = 0.0;
        this.mSpeed = 0.0f;
        this.mBearing = 0.0f;
        this.mAccuracy = 0.0f;
        this.mExtras = null;
        this.mFieldsMask = 0;
        this.mProvider = provider;
    }

    private void $$robo$$android_location_Location$__constructor__(Location l) {
        this.mTime = 0L;
        this.mElapsedRealtimeNanos = 0L;
        this.mLatitude = 0.0;
        this.mLongitude = 0.0;
        this.mAltitude = 0.0;
        this.mSpeed = 0.0f;
        this.mBearing = 0.0f;
        this.mAccuracy = 0.0f;
        this.mExtras = null;
        this.mFieldsMask = 0;
        this.set(l);
    }

    private final void $$robo$$android_location_Location$set(Location l) {
        this.mProvider = l.mProvider;
        this.mTime = l.mTime;
        this.mElapsedRealtimeNanos = l.mElapsedRealtimeNanos;
        this.mFieldsMask = l.mFieldsMask;
        this.mLatitude = l.mLatitude;
        this.mLongitude = l.mLongitude;
        this.mAltitude = l.mAltitude;
        this.mSpeed = l.mSpeed;
        this.mBearing = l.mBearing;
        this.mAccuracy = l.mAccuracy;
        this.mExtras = l.mExtras == null ? null : new Bundle(l.mExtras);
    }

    private final void $$robo$$android_location_Location$reset() {
        this.mProvider = null;
        this.mTime = 0L;
        this.mElapsedRealtimeNanos = 0L;
        this.mFieldsMask = 0;
        this.mLatitude = 0.0;
        this.mLongitude = 0.0;
        this.mAltitude = 0.0;
        this.mSpeed = 0.0f;
        this.mBearing = 0.0f;
        this.mAccuracy = 0.0f;
        this.mExtras = null;
    }

    private static final String $$robo$$android_location_Location$convert(double coordinate, int outputType) {
        if (coordinate < -180.0 || coordinate > 180.0 || Double.isNaN(coordinate)) {
            throw new IllegalArgumentException("coordinate=" + coordinate);
        }
        if (outputType != 0 && outputType != 1 && outputType != 2) {
            throw new IllegalArgumentException("outputType=" + outputType);
        }
        StringBuilder sb = new StringBuilder();
        if (coordinate < 0.0) {
            sb.append('-');
            coordinate = -coordinate;
        }
        DecimalFormat df = new DecimalFormat("###.#####");
        if (outputType == 1 || outputType == 2) {
            int degrees = (int)Math.floor(coordinate);
            sb.append(degrees);
            sb.append(':');
            coordinate -= (double)degrees;
            coordinate *= 60.0;
            if (outputType == 2) {
                int minutes = (int)Math.floor(coordinate);
                sb.append(minutes);
                sb.append(':');
                coordinate -= (double)minutes;
                coordinate *= 60.0;
            }
        }
        sb.append(df.format(coordinate));
        return sb.toString();
    }

    private static final double $$robo$$android_location_Location$convert(String coordinate) {
        StringTokenizer st;
        int tokens;
        if (coordinate == null) {
            throw new NullPointerException("coordinate");
        }
        boolean negative = false;
        if (coordinate.charAt(0) == '-') {
            coordinate = coordinate.substring(1);
            negative = true;
        }
        if ((tokens = (st = new StringTokenizer(coordinate, ":")).countTokens()) < 1) {
            throw new IllegalArgumentException("coordinate=" + coordinate);
        }
        try {
            boolean isNegative180;
            double min;
            String degrees = st.nextToken();
            if (tokens == 1) {
                double val = Double.parseDouble(degrees);
                return negative ? -val : val;
            }
            String minutes = st.nextToken();
            int deg = Integer.parseInt(degrees);
            double sec = 0.0;
            boolean secPresent = false;
            if (st.hasMoreTokens()) {
                min = Integer.parseInt(minutes);
                String seconds = st.nextToken();
                sec = Double.parseDouble(seconds);
                secPresent = true;
            } else {
                min = Double.parseDouble(minutes);
            }
            boolean bl = isNegative180 = negative && deg == 180 && min == 0.0 && sec == 0.0;
            if ((double)deg < 0.0 || deg > 179 && !isNegative180) {
                throw new IllegalArgumentException("coordinate=" + coordinate);
            }
            if (min < 0.0 || min >= 60.0 || secPresent && min > 59.0) {
                throw new IllegalArgumentException("coordinate=" + coordinate);
            }
            if (sec < 0.0 || sec >= 60.0) {
                throw new IllegalArgumentException("coordinate=" + coordinate);
            }
            double val = (double)deg * 3600.0 + min * 60.0 + sec;
            return negative ? -val : (val /= 3600.0);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("coordinate=" + coordinate);
        }
    }

    private static final void $$robo$$android_location_Location$computeDistanceAndBearing(double lat1, double lon1, double lat2, double lon2, BearingDistanceCache results) {
        int MAXITERS = 20;
        lat1 *= Math.PI / 180;
        lat2 *= Math.PI / 180;
        double a = 6378137.0;
        double b = 6356752.3142;
        double f = (a - b) / a;
        double aSqMinusBSqOverBSq = (a * a - b * b) / (b * b);
        double L = (lon2 *= Math.PI / 180) - (lon1 *= Math.PI / 180);
        double A = 0.0;
        double U1 = Math.atan((1.0 - f) * Math.tan(lat1));
        double U2 = Math.atan((1.0 - f) * Math.tan(lat2));
        double cosU1 = Math.cos(U1);
        double cosU2 = Math.cos(U2);
        double sinU1 = Math.sin(U1);
        double sinU2 = Math.sin(U2);
        double cosU1cosU2 = cosU1 * cosU2;
        double sinU1sinU2 = sinU1 * sinU2;
        double sigma = 0.0;
        double deltaSigma = 0.0;
        double cosSqAlpha = 0.0;
        double cos2SM = 0.0;
        double cosSigma = 0.0;
        double sinSigma = 0.0;
        double cosLambda = 0.0;
        double sinLambda = 0.0;
        double lambda = L;
        for (int iter = 0; iter < MAXITERS; ++iter) {
            double lambdaOrig = lambda;
            cosLambda = Math.cos(lambda);
            sinLambda = Math.sin(lambda);
            double t1 = cosU2 * sinLambda;
            double t2 = cosU1 * sinU2 - sinU1 * cosU2 * cosLambda;
            double sinSqSigma = t1 * t1 + t2 * t2;
            sinSigma = Math.sqrt(sinSqSigma);
            cosSigma = sinU1sinU2 + cosU1cosU2 * cosLambda;
            sigma = Math.atan2(sinSigma, cosSigma);
            double sinAlpha = sinSigma == 0.0 ? 0.0 : cosU1cosU2 * sinLambda / sinSigma;
            cosSqAlpha = 1.0 - sinAlpha * sinAlpha;
            cos2SM = cosSqAlpha == 0.0 ? 0.0 : cosSigma - 2.0 * sinU1sinU2 / cosSqAlpha;
            double uSquared = cosSqAlpha * aSqMinusBSqOverBSq;
            A = 1.0 + uSquared / 16384.0 * (4096.0 + uSquared * (-768.0 + uSquared * (320.0 - 175.0 * uSquared)));
            double B = uSquared / 1024.0 * (256.0 + uSquared * (-128.0 + uSquared * (74.0 - 47.0 * uSquared)));
            double C = f / 16.0 * cosSqAlpha * (4.0 + f * (4.0 - 3.0 * cosSqAlpha));
            double cos2SMSq = cos2SM * cos2SM;
            deltaSigma = B * sinSigma * (cos2SM + B / 4.0 * (cosSigma * (-1.0 + 2.0 * cos2SMSq) - B / 6.0 * cos2SM * (-3.0 + 4.0 * sinSigma * sinSigma) * (-3.0 + 4.0 * cos2SMSq)));
            lambda = L + (1.0 - C) * f * sinAlpha * (sigma + C * sinSigma * (cos2SM + C * cosSigma * (-1.0 + 2.0 * cos2SM * cos2SM)));
            double delta = (lambda - lambdaOrig) / lambda;
            if (Math.abs(delta) < 1.0E-12) break;
        }
        float distance = (float)(b * A * (sigma - deltaSigma));
        results.mDistance = distance;
        float initialBearing = (float)Math.atan2(cosU2 * sinLambda, cosU1 * sinU2 - sinU1 * cosU2 * cosLambda);
        initialBearing = (float)((double)initialBearing * 57.29577951308232);
        results.mInitialBearing = initialBearing;
        float finalBearing = (float)Math.atan2(cosU1 * sinLambda, -sinU1 * cosU2 + cosU1 * sinU2 * cosLambda);
        finalBearing = (float)((double)finalBearing * 57.29577951308232);
        results.mFinalBearing = finalBearing;
        results.mLat1 = lat1;
        results.mLat2 = lat2;
        results.mLon1 = lon1;
        results.mLon2 = lon2;
    }

    private static final void $$robo$$android_location_Location$distanceBetween(double startLatitude, double startLongitude, double endLatitude, double endLongitude, float[] results) {
        if (results == null || results.length < 1) {
            throw new IllegalArgumentException("results is null or has length < 1");
        }
        BearingDistanceCache cache = sBearingDistanceCache.get();
        Location.computeDistanceAndBearing(startLatitude, startLongitude, endLatitude, endLongitude, cache);
        results[0] = cache.mDistance;
        if (results.length > 1) {
            results[1] = cache.mInitialBearing;
            if (results.length > 2) {
                results[2] = cache.mFinalBearing;
            }
        }
    }

    private final float $$robo$$android_location_Location$distanceTo(Location dest) {
        BearingDistanceCache cache = sBearingDistanceCache.get();
        if (this.mLatitude != cache.mLat1 || this.mLongitude != cache.mLon1 || dest.mLatitude != cache.mLat2 || dest.mLongitude != cache.mLon2) {
            Location.computeDistanceAndBearing(this.mLatitude, this.mLongitude, dest.mLatitude, dest.mLongitude, cache);
        }
        return cache.mDistance;
    }

    private final float $$robo$$android_location_Location$bearingTo(Location dest) {
        BearingDistanceCache cache = sBearingDistanceCache.get();
        if (this.mLatitude != cache.mLat1 || this.mLongitude != cache.mLon1 || dest.mLatitude != cache.mLat2 || dest.mLongitude != cache.mLon2) {
            Location.computeDistanceAndBearing(this.mLatitude, this.mLongitude, dest.mLatitude, dest.mLongitude, cache);
        }
        return cache.mInitialBearing;
    }

    private final String $$robo$$android_location_Location$getProvider() {
        return this.mProvider;
    }

    private final void $$robo$$android_location_Location$setProvider(String provider) {
        this.mProvider = provider;
    }

    private final long $$robo$$android_location_Location$getTime() {
        return this.mTime;
    }

    private final void $$robo$$android_location_Location$setTime(long time) {
        this.mTime = time;
    }

    private final long $$robo$$android_location_Location$getElapsedRealtimeNanos() {
        return this.mElapsedRealtimeNanos;
    }

    private final void $$robo$$android_location_Location$setElapsedRealtimeNanos(long time) {
        this.mElapsedRealtimeNanos = time;
    }

    private final double $$robo$$android_location_Location$getLatitude() {
        return this.mLatitude;
    }

    private final void $$robo$$android_location_Location$setLatitude(double latitude) {
        this.mLatitude = latitude;
    }

    private final double $$robo$$android_location_Location$getLongitude() {
        return this.mLongitude;
    }

    private final void $$robo$$android_location_Location$setLongitude(double longitude) {
        this.mLongitude = longitude;
    }

    private final boolean $$robo$$android_location_Location$hasAltitude() {
        return (this.mFieldsMask & 1) != 0;
    }

    private final double $$robo$$android_location_Location$getAltitude() {
        return this.mAltitude;
    }

    private final void $$robo$$android_location_Location$setAltitude(double altitude) {
        this.mAltitude = altitude;
        this.mFieldsMask = (byte)(this.mFieldsMask | 1);
    }

    private final void $$robo$$android_location_Location$removeAltitude() {
        this.mAltitude = 0.0;
        this.mFieldsMask = (byte)(this.mFieldsMask & 0xFFFFFFFE);
    }

    private final boolean $$robo$$android_location_Location$hasSpeed() {
        return (this.mFieldsMask & 2) != 0;
    }

    private final float $$robo$$android_location_Location$getSpeed() {
        return this.mSpeed;
    }

    private final void $$robo$$android_location_Location$setSpeed(float speed) {
        this.mSpeed = speed;
        this.mFieldsMask = (byte)(this.mFieldsMask | 2);
    }

    private final void $$robo$$android_location_Location$removeSpeed() {
        this.mSpeed = 0.0f;
        this.mFieldsMask = (byte)(this.mFieldsMask & 0xFFFFFFFD);
    }

    private final boolean $$robo$$android_location_Location$hasBearing() {
        return (this.mFieldsMask & 4) != 0;
    }

    private final float $$robo$$android_location_Location$getBearing() {
        return this.mBearing;
    }

    private final void $$robo$$android_location_Location$setBearing(float bearing) {
        while (bearing < 0.0f) {
            bearing += 360.0f;
        }
        while (bearing >= 360.0f) {
            bearing -= 360.0f;
        }
        this.mBearing = bearing;
        this.mFieldsMask = (byte)(this.mFieldsMask | 4);
    }

    private final void $$robo$$android_location_Location$removeBearing() {
        this.mBearing = 0.0f;
        this.mFieldsMask = (byte)(this.mFieldsMask & 0xFFFFFFFB);
    }

    private final boolean $$robo$$android_location_Location$hasAccuracy() {
        return (this.mFieldsMask & 8) != 0;
    }

    private final float $$robo$$android_location_Location$getAccuracy() {
        return this.mAccuracy;
    }

    private final void $$robo$$android_location_Location$setAccuracy(float accuracy) {
        this.mAccuracy = accuracy;
        this.mFieldsMask = (byte)(this.mFieldsMask | 8);
    }

    private final void $$robo$$android_location_Location$removeAccuracy() {
        this.mAccuracy = 0.0f;
        this.mFieldsMask = (byte)(this.mFieldsMask & 0xFFFFFFF7);
    }

    private final boolean $$robo$$android_location_Location$isComplete() {
        if (this.mProvider == null) {
            return false;
        }
        if (!this.hasAccuracy()) {
            return false;
        }
        if (this.mTime == 0L) {
            return false;
        }
        return this.mElapsedRealtimeNanos != 0L;
    }

    private final void $$robo$$android_location_Location$makeComplete() {
        if (this.mProvider == null) {
            this.mProvider = "?";
        }
        if (!this.hasAccuracy()) {
            this.mFieldsMask = (byte)(this.mFieldsMask | 8);
            this.mAccuracy = 100.0f;
        }
        if (this.mTime == 0L) {
            this.mTime = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        }
        if (this.mElapsedRealtimeNanos == 0L) {
            this.mElapsedRealtimeNanos = SystemClock.elapsedRealtimeNanos();
        }
    }

    private final Bundle $$robo$$android_location_Location$getExtras() {
        return this.mExtras;
    }

    private final void $$robo$$android_location_Location$setExtras(Bundle extras) {
        this.mExtras = extras == null ? null : new Bundle(extras);
    }

    private final String $$robo$$android_location_Location$toString() {
        StringBuilder s = new StringBuilder();
        s.append("Location[");
        s.append(this.mProvider);
        s.append(String.format(" %.6f,%.6f", this.mLatitude, this.mLongitude));
        if (this.hasAccuracy()) {
            s.append(String.format(" acc=%.0f", Float.valueOf(this.mAccuracy)));
        } else {
            s.append(" acc=???");
        }
        if (this.mTime == 0L) {
            s.append(" t=?!?");
        }
        if (this.mElapsedRealtimeNanos == 0L) {
            s.append(" et=?!?");
        } else {
            s.append(" et=");
            TimeUtils.formatDuration(this.mElapsedRealtimeNanos / 1000000L, s);
        }
        if (this.hasAltitude()) {
            s.append(" alt=").append(this.mAltitude);
        }
        if (this.hasSpeed()) {
            s.append(" vel=").append(this.mSpeed);
        }
        if (this.hasBearing()) {
            s.append(" bear=").append(this.mBearing);
        }
        if (this.isFromMockProvider()) {
            s.append(" mock");
        }
        if (this.mExtras != null) {
            s.append(" {").append(this.mExtras).append('}');
        }
        s.append(']');
        return s.toString();
    }

    private final void $$robo$$android_location_Location$dump(Printer pw, String prefix) {
        pw.println(prefix + this.toString());
    }

    private final int $$robo$$android_location_Location$describeContents() {
        return 0;
    }

    private final void $$robo$$android_location_Location$writeToParcel(Parcel parcel, int flags) {
        parcel.writeString(this.mProvider);
        parcel.writeLong(this.mTime);
        parcel.writeLong(this.mElapsedRealtimeNanos);
        parcel.writeByte(this.mFieldsMask);
        parcel.writeDouble(this.mLatitude);
        parcel.writeDouble(this.mLongitude);
        parcel.writeDouble(this.mAltitude);
        parcel.writeFloat(this.mSpeed);
        parcel.writeFloat(this.mBearing);
        parcel.writeFloat(this.mAccuracy);
        parcel.writeBundle(this.mExtras);
    }

    private final Location $$robo$$android_location_Location$getExtraLocation(String key) {
        Object value;
        if (this.mExtras != null && (value = this.mExtras.getParcelable(key)) instanceof Location) {
            return (Location)value;
        }
        return null;
    }

    private final void $$robo$$android_location_Location$setExtraLocation(String key, Location value) {
        if (this.mExtras == null) {
            this.mExtras = new Bundle();
        }
        this.mExtras.putParcelable(key, value);
    }

    private final boolean $$robo$$android_location_Location$isFromMockProvider() {
        return (this.mFieldsMask & 0x10) != 0;
    }

    private final void $$robo$$android_location_Location$setIsFromMockProvider(boolean isFromMockProvider) {
        this.mFieldsMask = isFromMockProvider ? (byte)(this.mFieldsMask | 0x10) : (byte)(this.mFieldsMask & 0xFFFFFFEF);
    }

    static void __staticInitializer__() {
        sBearingDistanceCache = new ThreadLocal<BearingDistanceCache>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_location_Location_1$__constructor__() {
            }

            private final BearingDistanceCache $$robo$$android_location_Location_1$initialValue() {
                return new BearingDistanceCache();
            }

            private void __constructor__() {
                this.$$robo$$android_location_Location_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_location_Location_1$__constructor__(), 0, this);
            }

            @Override
            protected BearingDistanceCache initialValue() {
                return InvokeDynamicSupport.bootstrap("initialValue", $$robo$$android_location_Location_1$initialValue(), 0, this);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        CREATOR = new Parcelable.Creator<Location>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_location_Location_2$__constructor__() {
            }

            private final Location $$robo$$android_location_Location_2$createFromParcel(Parcel in) {
                String provider = in.readString();
                Location l = new Location(provider);
                l.mTime = in.readLong();
                l.mElapsedRealtimeNanos = in.readLong();
                l.mFieldsMask = in.readByte();
                l.mLatitude = in.readDouble();
                l.mLongitude = in.readDouble();
                l.mAltitude = in.readDouble();
                l.mSpeed = in.readFloat();
                l.mBearing = in.readFloat();
                l.mAccuracy = in.readFloat();
                l.mExtras = Bundle.setDefusable(in.readBundle(), true);
                return l;
            }

            private final Location[] $$robo$$android_location_Location_2$newArray(int size) {
                return new Location[size];
            }

            private void __constructor__() {
                this.$$robo$$android_location_Location_2$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_location_Location_2$__constructor__(), 0, this);
            }

            @Override
            public Location createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_location_Location_2$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public Location[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_location_Location_2$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_location_Location$__constructor__(string2);
    }

    public Location(String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_location_Location$__constructor__(java.lang.String ), 0, this, string2);
    }

    private void __constructor__(Location location) {
        this.$$robo$$android_location_Location$__constructor__(location);
    }

    public Location(Location location) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_location_Location$__constructor__(android.location.Location ), 0, this, location);
    }

    public void set(Location location) {
        InvokeDynamicSupport.bootstrap("set", $$robo$$android_location_Location$set(android.location.Location ), 0, this, location);
    }

    public void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$android_location_Location$reset(), 0, this);
    }

    public static String convert(double d, int n) {
        return InvokeDynamicSupport.bootstrapStatic("convert", $$robo$$android_location_Location$convert(double int ), 0, (double)d, (int)n);
    }

    public static double convert(String string2) {
        return (double)InvokeDynamicSupport.bootstrapStatic("convert", $$robo$$android_location_Location$convert(java.lang.String ), 0, (String)string2);
    }

    private static void computeDistanceAndBearing(double d, double d2, double d3, double d4, BearingDistanceCache bearingDistanceCache) {
        InvokeDynamicSupport.bootstrapStatic("computeDistanceAndBearing", $$robo$$android_location_Location$computeDistanceAndBearing(double double double double android.location.Location$BearingDistanceCache ), 0, (double)d, (double)d2, (double)d3, (double)d4, (BearingDistanceCache)bearingDistanceCache);
    }

    public static void distanceBetween(double d, double d2, double d3, double d4, float[] fArray) {
        InvokeDynamicSupport.bootstrapStatic("distanceBetween", $$robo$$android_location_Location$distanceBetween(double double double double float[] ), 0, (double)d, (double)d2, (double)d3, (double)d4, (float[])fArray);
    }

    public float distanceTo(Location location) {
        return (float)InvokeDynamicSupport.bootstrap("distanceTo", $$robo$$android_location_Location$distanceTo(android.location.Location ), 0, this, location);
    }

    public float bearingTo(Location location) {
        return (float)InvokeDynamicSupport.bootstrap("bearingTo", $$robo$$android_location_Location$bearingTo(android.location.Location ), 0, this, location);
    }

    public String getProvider() {
        return InvokeDynamicSupport.bootstrap("getProvider", $$robo$$android_location_Location$getProvider(), 0, this);
    }

    public void setProvider(String string2) {
        InvokeDynamicSupport.bootstrap("setProvider", $$robo$$android_location_Location$setProvider(java.lang.String ), 0, this, string2);
    }

    public long getTime() {
        return (long)InvokeDynamicSupport.bootstrap("getTime", $$robo$$android_location_Location$getTime(), 0, this);
    }

    public void setTime(long l) {
        InvokeDynamicSupport.bootstrap("setTime", $$robo$$android_location_Location$setTime(long ), 0, this, l);
    }

    public long getElapsedRealtimeNanos() {
        return (long)InvokeDynamicSupport.bootstrap("getElapsedRealtimeNanos", $$robo$$android_location_Location$getElapsedRealtimeNanos(), 0, this);
    }

    public void setElapsedRealtimeNanos(long l) {
        InvokeDynamicSupport.bootstrap("setElapsedRealtimeNanos", $$robo$$android_location_Location$setElapsedRealtimeNanos(long ), 0, this, l);
    }

    public double getLatitude() {
        return (double)InvokeDynamicSupport.bootstrap("getLatitude", $$robo$$android_location_Location$getLatitude(), 0, this);
    }

    public void setLatitude(double d) {
        InvokeDynamicSupport.bootstrap("setLatitude", $$robo$$android_location_Location$setLatitude(double ), 0, this, d);
    }

    public double getLongitude() {
        return (double)InvokeDynamicSupport.bootstrap("getLongitude", $$robo$$android_location_Location$getLongitude(), 0, this);
    }

    public void setLongitude(double d) {
        InvokeDynamicSupport.bootstrap("setLongitude", $$robo$$android_location_Location$setLongitude(double ), 0, this, d);
    }

    public boolean hasAltitude() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasAltitude", $$robo$$android_location_Location$hasAltitude(), 0, this);
    }

    public double getAltitude() {
        return (double)InvokeDynamicSupport.bootstrap("getAltitude", $$robo$$android_location_Location$getAltitude(), 0, this);
    }

    public void setAltitude(double d) {
        InvokeDynamicSupport.bootstrap("setAltitude", $$robo$$android_location_Location$setAltitude(double ), 0, this, d);
    }

    public void removeAltitude() {
        InvokeDynamicSupport.bootstrap("removeAltitude", $$robo$$android_location_Location$removeAltitude(), 0, this);
    }

    public boolean hasSpeed() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasSpeed", $$robo$$android_location_Location$hasSpeed(), 0, this);
    }

    public float getSpeed() {
        return (float)InvokeDynamicSupport.bootstrap("getSpeed", $$robo$$android_location_Location$getSpeed(), 0, this);
    }

    public void setSpeed(float f) {
        InvokeDynamicSupport.bootstrap("setSpeed", $$robo$$android_location_Location$setSpeed(float ), 0, this, f);
    }

    public void removeSpeed() {
        InvokeDynamicSupport.bootstrap("removeSpeed", $$robo$$android_location_Location$removeSpeed(), 0, this);
    }

    public boolean hasBearing() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasBearing", $$robo$$android_location_Location$hasBearing(), 0, this);
    }

    public float getBearing() {
        return (float)InvokeDynamicSupport.bootstrap("getBearing", $$robo$$android_location_Location$getBearing(), 0, this);
    }

    public void setBearing(float f) {
        InvokeDynamicSupport.bootstrap("setBearing", $$robo$$android_location_Location$setBearing(float ), 0, this, f);
    }

    public void removeBearing() {
        InvokeDynamicSupport.bootstrap("removeBearing", $$robo$$android_location_Location$removeBearing(), 0, this);
    }

    public boolean hasAccuracy() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasAccuracy", $$robo$$android_location_Location$hasAccuracy(), 0, this);
    }

    public float getAccuracy() {
        return (float)InvokeDynamicSupport.bootstrap("getAccuracy", $$robo$$android_location_Location$getAccuracy(), 0, this);
    }

    public void setAccuracy(float f) {
        InvokeDynamicSupport.bootstrap("setAccuracy", $$robo$$android_location_Location$setAccuracy(float ), 0, this, f);
    }

    public void removeAccuracy() {
        InvokeDynamicSupport.bootstrap("removeAccuracy", $$robo$$android_location_Location$removeAccuracy(), 0, this);
    }

    public boolean isComplete() {
        return (boolean)InvokeDynamicSupport.bootstrap("isComplete", $$robo$$android_location_Location$isComplete(), 0, this);
    }

    public void makeComplete() {
        InvokeDynamicSupport.bootstrap("makeComplete", $$robo$$android_location_Location$makeComplete(), 0, this);
    }

    public Bundle getExtras() {
        return InvokeDynamicSupport.bootstrap("getExtras", $$robo$$android_location_Location$getExtras(), 0, this);
    }

    public void setExtras(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("setExtras", $$robo$$android_location_Location$setExtras(android.os.Bundle ), 0, this, bundle);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_location_Location$toString(), 0, this);
    }

    public void dump(Printer printer, String string2) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_location_Location$dump(android.util.Printer java.lang.String ), 0, this, printer, string2);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_location_Location$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_location_Location$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public Location getExtraLocation(String string2) {
        return InvokeDynamicSupport.bootstrap("getExtraLocation", $$robo$$android_location_Location$getExtraLocation(java.lang.String ), 0, this, string2);
    }

    public void setExtraLocation(String string2, Location location) {
        InvokeDynamicSupport.bootstrap("setExtraLocation", $$robo$$android_location_Location$setExtraLocation(java.lang.String android.location.Location ), 0, this, string2, location);
    }

    public boolean isFromMockProvider() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFromMockProvider", $$robo$$android_location_Location$isFromMockProvider(), 0, this);
    }

    public void setIsFromMockProvider(boolean bl) {
        InvokeDynamicSupport.bootstrap("setIsFromMockProvider", $$robo$$android_location_Location$setIsFromMockProvider(boolean ), 0, this, bl);
    }

    static {
        RobolectricInternals.classInitializing(Location.class);
    }

    public /* synthetic */ Location() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Location)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class BearingDistanceCache
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private double mLat1;
        private double mLon1;
        private double mLat2;
        private double mLon2;
        private float mDistance;
        private float mInitialBearing;
        private float mFinalBearing;

        private void $$robo$$android_location_Location_BearingDistanceCache$__constructor__() {
            this.mLat1 = 0.0;
            this.mLon1 = 0.0;
            this.mLat2 = 0.0;
            this.mLon2 = 0.0;
            this.mDistance = 0.0f;
            this.mInitialBearing = 0.0f;
            this.mFinalBearing = 0.0f;
        }

        private /* synthetic */ void $$robo$$android_location_Location_BearingDistanceCache$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_location_Location_BearingDistanceCache$__constructor__();
        }

        private BearingDistanceCache() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_location_Location_BearingDistanceCache$__constructor__(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_location_Location_BearingDistanceCache$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BearingDistanceCache)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

