/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.content.Context;
import android.os.Handler;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;

public abstract class LocalListenerHelper<TListener> {
    public transient /* synthetic */ Object __robo_data__;
    private HashMap<TListener, Handler> mListeners;
    private String mTag;
    private Context mContext;

    private void $$robo$$android_location_LocalListenerHelper$__constructor__(Context context, String name) {
        this.mListeners = new HashMap();
        Preconditions.checkNotNull(name);
        this.mContext = context;
        this.mTag = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_location_LocalListenerHelper$add(TListener listener, Handler handler) {
        Preconditions.checkNotNull(listener);
        HashMap<TListener, Handler> hashMap = this.mListeners;
        synchronized (hashMap) {
            if (this.mListeners.isEmpty()) {
                boolean registeredWithService;
                try {
                    registeredWithService = this.registerWithServer();
                }
                catch (RemoteException e) {
                    Log.e(this.mTag, "Error handling first listener.", e);
                    return false;
                }
                if (!registeredWithService) {
                    Log.e(this.mTag, "Unable to register listener transport.");
                    return false;
                }
            }
            if (this.mListeners.containsKey(listener)) {
                return true;
            }
            this.mListeners.put(listener, handler);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_location_LocalListenerHelper$remove(TListener listener) {
        Preconditions.checkNotNull(listener);
        HashMap<TListener, Handler> hashMap = this.mListeners;
        synchronized (hashMap) {
            boolean isLastRemoved;
            boolean removed = this.mListeners.containsKey(listener);
            this.mListeners.remove(listener);
            boolean bl = isLastRemoved = removed && this.mListeners.isEmpty();
            if (isLastRemoved) {
                try {
                    this.unregisterFromServer();
                }
                catch (RemoteException e) {
                    Log.v(this.mTag, "Error handling last listener removal", e);
                }
            }
        }
    }

    protected abstract boolean registerWithServer() throws RemoteException;

    protected abstract void unregisterFromServer() throws RemoteException;

    private final Context $$robo$$android_location_LocalListenerHelper$getContext() {
        return this.mContext;
    }

    private final void $$robo$$android_location_LocalListenerHelper$executeOperation(ListenerOperation<TListener> operation, TListener listener) {
        try {
            operation.execute(listener);
        }
        catch (RemoteException e) {
            Log.e(this.mTag, "Error in monitored listener.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_location_LocalListenerHelper$foreach(ListenerOperation<TListener> operation) {
        ArrayList<Map.Entry<TListener, Handler>> listeners;
        HashMap<TListener, Handler> hashMap = this.mListeners;
        synchronized (hashMap) {
            listeners = new ArrayList<Map.Entry<TListener, Handler>>(this.mListeners.entrySet());
        }
        for (Map.Entry entry : listeners) {
            if (entry.getValue() == null) {
                this.executeOperation(operation, entry.getKey());
                continue;
            }
            ((Handler)entry.getValue()).post(new Runnable(this, operation, entry){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ ListenerOperation val$operation;
                /* synthetic */ Map.Entry val$listener;
                /* synthetic */ LocalListenerHelper this$0;

                private void $$robo$$android_location_LocalListenerHelper_1$__constructor__(LocalListenerHelper this$0, ListenerOperation listenerOperation, Map.Entry entry) {
                }

                private final void $$robo$$android_location_LocalListenerHelper_1$run() {
                    this.this$0.executeOperation(this.val$operation, this.val$listener.getKey());
                }

                private void __constructor__(LocalListenerHelper localListenerHelper, ListenerOperation listenerOperation, Map.Entry entry) {
                    this.$$robo$$android_location_LocalListenerHelper_1$__constructor__(localListenerHelper, listenerOperation, entry);
                }
                {
                    this.this$0 = localListenerHelper;
                    this.val$operation = listenerOperation;
                    this.val$listener = entry;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_location_LocalListenerHelper_1$__constructor__(android.location.LocalListenerHelper android.location.LocalListenerHelper$ListenerOperation java.util.Map$Entry ), 0, this, localListenerHelper, listenerOperation, entry);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_location_LocalListenerHelper_1$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
    }

    private void __constructor__(Context context, String string2) {
        this.$$robo$$android_location_LocalListenerHelper$__constructor__(context, string2);
    }

    protected LocalListenerHelper(Context context, String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_location_LocalListenerHelper$__constructor__(android.content.Context java.lang.String ), 0, this, context, string2);
    }

    public boolean add(TListener TListener, Handler handler) {
        return (boolean)InvokeDynamicSupport.bootstrap("add", $$robo$$android_location_LocalListenerHelper$add(TListener android.os.Handler ), 0, this, TListener, handler);
    }

    public void remove(TListener TListener) {
        InvokeDynamicSupport.bootstrap("remove", $$robo$$android_location_LocalListenerHelper$remove(TListener ), 0, this, TListener);
    }

    protected Context getContext() {
        return InvokeDynamicSupport.bootstrap("getContext", $$robo$$android_location_LocalListenerHelper$getContext(), 0, this);
    }

    private void executeOperation(ListenerOperation<TListener> listenerOperation, TListener TListener) {
        InvokeDynamicSupport.bootstrap("executeOperation", $$robo$$android_location_LocalListenerHelper$executeOperation(android.location.LocalListenerHelper$ListenerOperation<TListener> TListener ), 0, this, listenerOperation, TListener);
    }

    protected void foreach(ListenerOperation<TListener> listenerOperation) {
        InvokeDynamicSupport.bootstrap("foreach", $$robo$$android_location_LocalListenerHelper$foreach(android.location.LocalListenerHelper$ListenerOperation<TListener> ), 0, this, listenerOperation);
    }

    public /* synthetic */ LocalListenerHelper() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LocalListenerHelper)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    protected static interface ListenerOperation<TListener> {
        public void execute(TListener var1) throws RemoteException;
    }
}

