/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.app.PendingIntent;
import android.location.Address;
import android.location.Criteria;
import android.location.GeocoderParams;
import android.location.Geofence;
import android.location.IGnssMeasurementsListener;
import android.location.IGnssNavigationMessageListener;
import android.location.IGnssStatusListener;
import android.location.ILocationListener;
import android.location.Location;
import android.location.LocationRequest;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.android.internal.location.ProviderProperties;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public interface ILocationManager
extends IInterface,
InstrumentedInterface {
    public void requestLocationUpdates(LocationRequest var1, ILocationListener var2, PendingIntent var3, String var4) throws RemoteException;

    public void removeUpdates(ILocationListener var1, PendingIntent var2, String var3) throws RemoteException;

    public void requestGeofence(LocationRequest var1, Geofence var2, PendingIntent var3, String var4) throws RemoteException;

    public void removeGeofence(Geofence var1, PendingIntent var2, String var3) throws RemoteException;

    public Location getLastLocation(LocationRequest var1, String var2) throws RemoteException;

    public boolean registerGnssStatusCallback(IGnssStatusListener var1, String var2) throws RemoteException;

    public void unregisterGnssStatusCallback(IGnssStatusListener var1) throws RemoteException;

    public boolean geocoderIsPresent() throws RemoteException;

    public String getFromLocation(double var1, double var3, int var5, GeocoderParams var6, List<Address> var7) throws RemoteException;

    public String getFromLocationName(String var1, double var2, double var4, double var6, double var8, int var10, GeocoderParams var11, List<Address> var12) throws RemoteException;

    public boolean sendNiResponse(int var1, int var2) throws RemoteException;

    public boolean addGnssMeasurementsListener(IGnssMeasurementsListener var1, String var2) throws RemoteException;

    public void removeGnssMeasurementsListener(IGnssMeasurementsListener var1) throws RemoteException;

    public boolean addGnssNavigationMessageListener(IGnssNavigationMessageListener var1, String var2) throws RemoteException;

    public void removeGnssNavigationMessageListener(IGnssNavigationMessageListener var1) throws RemoteException;

    public int getGnssYearOfHardware() throws RemoteException;

    public List<String> getAllProviders() throws RemoteException;

    public List<String> getProviders(Criteria var1, boolean var2) throws RemoteException;

    public String getBestProvider(Criteria var1, boolean var2) throws RemoteException;

    public boolean providerMeetsCriteria(String var1, Criteria var2) throws RemoteException;

    public ProviderProperties getProviderProperties(String var1) throws RemoteException;

    public String getNetworkProviderPackage() throws RemoteException;

    public boolean isProviderEnabled(String var1) throws RemoteException;

    public void addTestProvider(String var1, ProviderProperties var2, String var3) throws RemoteException;

    public void removeTestProvider(String var1, String var2) throws RemoteException;

    public void setTestProviderLocation(String var1, Location var2, String var3) throws RemoteException;

    public void clearTestProviderLocation(String var1, String var2) throws RemoteException;

    public void setTestProviderEnabled(String var1, boolean var2, String var3) throws RemoteException;

    public void clearTestProviderEnabled(String var1, String var2) throws RemoteException;

    public void setTestProviderStatus(String var1, int var2, Bundle var3, long var4, String var6) throws RemoteException;

    public void clearTestProviderStatus(String var1, String var2) throws RemoteException;

    public boolean sendExtraCommand(String var1, String var2, Bundle var3) throws RemoteException;

    public void reportLocation(Location var1, boolean var2) throws RemoteException;

    public void locationCallbackFinished(ILocationListener var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ILocationManager,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static String DESCRIPTOR = "android.location.ILocationManager";
        static int TRANSACTION_requestLocationUpdates = 1;
        static int TRANSACTION_removeUpdates = 2;
        static int TRANSACTION_requestGeofence = 3;
        static int TRANSACTION_removeGeofence = 4;
        static int TRANSACTION_getLastLocation = 5;
        static int TRANSACTION_registerGnssStatusCallback = 6;
        static int TRANSACTION_unregisterGnssStatusCallback = 7;
        static int TRANSACTION_geocoderIsPresent = 8;
        static int TRANSACTION_getFromLocation = 9;
        static int TRANSACTION_getFromLocationName = 10;
        static int TRANSACTION_sendNiResponse = 11;
        static int TRANSACTION_addGnssMeasurementsListener = 12;
        static int TRANSACTION_removeGnssMeasurementsListener = 13;
        static int TRANSACTION_addGnssNavigationMessageListener = 14;
        static int TRANSACTION_removeGnssNavigationMessageListener = 15;
        static int TRANSACTION_getGnssYearOfHardware = 16;
        static int TRANSACTION_getAllProviders = 17;
        static int TRANSACTION_getProviders = 18;
        static int TRANSACTION_getBestProvider = 19;
        static int TRANSACTION_providerMeetsCriteria = 20;
        static int TRANSACTION_getProviderProperties = 21;
        static int TRANSACTION_getNetworkProviderPackage = 22;
        static int TRANSACTION_isProviderEnabled = 23;
        static int TRANSACTION_addTestProvider = 24;
        static int TRANSACTION_removeTestProvider = 25;
        static int TRANSACTION_setTestProviderLocation = 26;
        static int TRANSACTION_clearTestProviderLocation = 27;
        static int TRANSACTION_setTestProviderEnabled = 28;
        static int TRANSACTION_clearTestProviderEnabled = 29;
        static int TRANSACTION_setTestProviderStatus = 30;
        static int TRANSACTION_clearTestProviderStatus = 31;
        static int TRANSACTION_sendExtraCommand = 32;
        static int TRANSACTION_reportLocation = 33;
        static int TRANSACTION_locationCallbackFinished = 34;

        private void $$robo$$android_location_ILocationManager_Stub$__constructor__() {
            this.attachInterface(this, "android.location.ILocationManager");
        }

        private static final ILocationManager $$robo$$android_location_ILocationManager_Stub$asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface("android.location.ILocationManager");
            if (iin != null && iin instanceof ILocationManager) {
                return (ILocationManager)iin;
            }
            return new Proxy(obj);
        }

        private final IBinder $$robo$$android_location_ILocationManager_Stub$asBinder() {
            return this;
        }

        private final boolean $$robo$$android_location_ILocationManager_Stub$onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString("android.location.ILocationManager");
                    return true;
                }
                case 1: {
                    data.enforceInterface("android.location.ILocationManager");
                    LocationRequest _arg0 = 0 != data.readInt() ? LocationRequest.CREATOR.createFromParcel(data) : null;
                    ILocationListener _arg1 = ILocationListener.Stub.asInterface(data.readStrongBinder());
                    PendingIntent _arg2 = 0 != data.readInt() ? PendingIntent.CREATOR.createFromParcel(data) : null;
                    String _arg3 = data.readString();
                    this.requestLocationUpdates(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 2: {
                    data.enforceInterface("android.location.ILocationManager");
                    ILocationListener _arg0 = ILocationListener.Stub.asInterface(data.readStrongBinder());
                    PendingIntent _arg1 = 0 != data.readInt() ? PendingIntent.CREATOR.createFromParcel(data) : null;
                    String _arg2 = data.readString();
                    this.removeUpdates(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 3: {
                    data.enforceInterface("android.location.ILocationManager");
                    LocationRequest _arg0 = 0 != data.readInt() ? LocationRequest.CREATOR.createFromParcel(data) : null;
                    Geofence _arg1 = 0 != data.readInt() ? Geofence.CREATOR.createFromParcel(data) : null;
                    PendingIntent _arg2 = 0 != data.readInt() ? PendingIntent.CREATOR.createFromParcel(data) : null;
                    String _arg3 = data.readString();
                    this.requestGeofence(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 4: {
                    data.enforceInterface("android.location.ILocationManager");
                    Geofence _arg0 = 0 != data.readInt() ? Geofence.CREATOR.createFromParcel(data) : null;
                    PendingIntent _arg1 = 0 != data.readInt() ? PendingIntent.CREATOR.createFromParcel(data) : null;
                    String _arg2 = data.readString();
                    this.removeGeofence(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 5: {
                    data.enforceInterface("android.location.ILocationManager");
                    LocationRequest _arg0 = 0 != data.readInt() ? LocationRequest.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    Location _result = this.getLastLocation(_arg0, _arg1);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 6: {
                    data.enforceInterface("android.location.ILocationManager");
                    IGnssStatusListener _arg0 = IGnssStatusListener.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    boolean _result = this.registerGnssStatusCallback(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 7: {
                    data.enforceInterface("android.location.ILocationManager");
                    IGnssStatusListener _arg0 = IGnssStatusListener.Stub.asInterface(data.readStrongBinder());
                    this.unregisterGnssStatusCallback(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 8: {
                    data.enforceInterface("android.location.ILocationManager");
                    boolean _result = this.geocoderIsPresent();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 9: {
                    data.enforceInterface("android.location.ILocationManager");
                    double _arg0 = data.readDouble();
                    double _arg1 = data.readDouble();
                    int _arg2 = data.readInt();
                    GeocoderParams _arg3 = 0 != data.readInt() ? GeocoderParams.CREATOR.createFromParcel(data) : null;
                    ArrayList _arg4 = new ArrayList();
                    String _result = this.getFromLocation(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeString(_result);
                    reply.writeTypedList(_arg4);
                    return true;
                }
                case 10: {
                    data.enforceInterface("android.location.ILocationManager");
                    String _arg0 = data.readString();
                    double _arg1 = data.readDouble();
                    double _arg2 = data.readDouble();
                    double _arg3 = data.readDouble();
                    double _arg4 = data.readDouble();
                    int _arg5 = data.readInt();
                    GeocoderParams _arg6 = 0 != data.readInt() ? GeocoderParams.CREATOR.createFromParcel(data) : null;
                    ArrayList _arg7 = new ArrayList();
                    String _result = this.getFromLocationName(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7);
                    reply.writeNoException();
                    reply.writeString(_result);
                    reply.writeTypedList(_arg7);
                    return true;
                }
                case 11: {
                    data.enforceInterface("android.location.ILocationManager");
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    boolean _result = this.sendNiResponse(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 12: {
                    data.enforceInterface("android.location.ILocationManager");
                    IGnssMeasurementsListener _arg0 = IGnssMeasurementsListener.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    boolean _result = this.addGnssMeasurementsListener(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 13: {
                    data.enforceInterface("android.location.ILocationManager");
                    IGnssMeasurementsListener _arg0 = IGnssMeasurementsListener.Stub.asInterface(data.readStrongBinder());
                    this.removeGnssMeasurementsListener(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 14: {
                    data.enforceInterface("android.location.ILocationManager");
                    IGnssNavigationMessageListener _arg0 = IGnssNavigationMessageListener.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    boolean _result = this.addGnssNavigationMessageListener(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 15: {
                    data.enforceInterface("android.location.ILocationManager");
                    IGnssNavigationMessageListener _arg0 = IGnssNavigationMessageListener.Stub.asInterface(data.readStrongBinder());
                    this.removeGnssNavigationMessageListener(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 16: {
                    data.enforceInterface("android.location.ILocationManager");
                    int _result = this.getGnssYearOfHardware();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 17: {
                    data.enforceInterface("android.location.ILocationManager");
                    List _result = this.getAllProviders();
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    return true;
                }
                case 18: {
                    data.enforceInterface("android.location.ILocationManager");
                    Criteria _arg0 = 0 != data.readInt() ? Criteria.CREATOR.createFromParcel(data) : null;
                    boolean _arg1 = 0 != data.readInt();
                    List _result = this.getProviders(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    return true;
                }
                case 19: {
                    data.enforceInterface("android.location.ILocationManager");
                    Criteria _arg0 = 0 != data.readInt() ? Criteria.CREATOR.createFromParcel(data) : null;
                    boolean _arg1 = 0 != data.readInt();
                    String _result = this.getBestProvider(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 20: {
                    data.enforceInterface("android.location.ILocationManager");
                    String _arg0 = data.readString();
                    Criteria _arg1 = 0 != data.readInt() ? Criteria.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.providerMeetsCriteria(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 21: {
                    data.enforceInterface("android.location.ILocationManager");
                    String _arg0 = data.readString();
                    ProviderProperties _result = this.getProviderProperties(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 22: {
                    data.enforceInterface("android.location.ILocationManager");
                    String _result = this.getNetworkProviderPackage();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 23: {
                    data.enforceInterface("android.location.ILocationManager");
                    String _arg0 = data.readString();
                    boolean _result = this.isProviderEnabled(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 24: {
                    data.enforceInterface("android.location.ILocationManager");
                    String _arg0 = data.readString();
                    ProviderProperties _arg1 = 0 != data.readInt() ? ProviderProperties.CREATOR.createFromParcel(data) : null;
                    String _arg2 = data.readString();
                    this.addTestProvider(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 25: {
                    data.enforceInterface("android.location.ILocationManager");
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    this.removeTestProvider(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 26: {
                    data.enforceInterface("android.location.ILocationManager");
                    String _arg0 = data.readString();
                    Location _arg1 = 0 != data.readInt() ? Location.CREATOR.createFromParcel(data) : null;
                    String _arg2 = data.readString();
                    this.setTestProviderLocation(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 27: {
                    data.enforceInterface("android.location.ILocationManager");
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    this.clearTestProviderLocation(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 28: {
                    data.enforceInterface("android.location.ILocationManager");
                    String _arg0 = data.readString();
                    boolean _arg1 = 0 != data.readInt();
                    String _arg2 = data.readString();
                    this.setTestProviderEnabled(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 29: {
                    data.enforceInterface("android.location.ILocationManager");
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    this.clearTestProviderEnabled(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 30: {
                    data.enforceInterface("android.location.ILocationManager");
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    Bundle _arg2 = 0 != data.readInt() ? Bundle.CREATOR.createFromParcel(data) : null;
                    long _arg3 = data.readLong();
                    String _arg4 = data.readString();
                    this.setTestProviderStatus(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    return true;
                }
                case 31: {
                    data.enforceInterface("android.location.ILocationManager");
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    this.clearTestProviderStatus(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 32: {
                    data.enforceInterface("android.location.ILocationManager");
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    Bundle _arg2 = 0 != data.readInt() ? Bundle.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.sendExtraCommand(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    if (_arg2 != null) {
                        reply.writeInt(1);
                        _arg2.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 33: {
                    data.enforceInterface("android.location.ILocationManager");
                    Location _arg0 = 0 != data.readInt() ? Location.CREATOR.createFromParcel(data) : null;
                    boolean _arg1 = 0 != data.readInt();
                    this.reportLocation(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 34: {
                    data.enforceInterface("android.location.ILocationManager");
                    ILocationListener _arg0 = ILocationListener.Stub.asInterface(data.readStrongBinder());
                    this.locationCallbackFinished(_arg0);
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private void __constructor__() {
            this.$$robo$$android_location_ILocationManager_Stub$__constructor__();
        }

        public Stub() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_location_ILocationManager_Stub$__constructor__(), 0, this);
        }

        public static ILocationManager asInterface(IBinder iBinder) {
            return InvokeDynamicSupport.bootstrapStatic("asInterface", $$robo$$android_location_ILocationManager_Stub$asInterface(android.os.IBinder ), 0, (IBinder)iBinder);
        }

        @Override
        public IBinder asBinder() {
            return InvokeDynamicSupport.bootstrap("asBinder", $$robo$$android_location_ILocationManager_Stub$asBinder(), 0, this);
        }

        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            return (boolean)InvokeDynamicSupport.bootstrap("onTransact", $$robo$$android_location_ILocationManager_Stub$onTransact(int android.os.Parcel android.os.Parcel int ), 0, this, n, parcel, parcel2, n2);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Stub)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private static class Proxy
        implements ILocationManager,
        ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            private IBinder mRemote;

            private void $$robo$$android_location_ILocationManager_Stub_Proxy$__constructor__(IBinder remote) {
                this.mRemote = remote;
            }

            private final IBinder $$robo$$android_location_ILocationManager_Stub_Proxy$asBinder() {
                return this.mRemote;
            }

            private final String $$robo$$android_location_ILocationManager_Stub_Proxy$getInterfaceDescriptor() {
                return "android.location.ILocationManager";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_location_ILocationManager_Stub_Proxy$requestLocationUpdates(LocationRequest request, ILocationListener listener, PendingIntent intent, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.location.ILocationManager");
                    if (request != null) {
                        _data.writeInt(1);
                        request.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    if (intent != null) {
                        _data.writeInt(1);
                        intent.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(packageName);
                    this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_location_ILocationManager_Stub_Proxy$removeUpdates(ILocationListener listener, PendingIntent intent, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.location.ILocationManager");
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    if (intent != null) {
                        _data.writeInt(1);
                        intent.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(packageName);
                    this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_location_ILocationManager_Stub_Proxy$requestGeofence(LocationRequest request, Geofence geofence, PendingIntent intent, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.location.ILocationManager");
                    if (request != null) {
                        _data.writeInt(1);
                        request.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (geofence != null) {
                        _data.writeInt(1);
                        geofence.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (intent != null) {
                        _data.writeInt(1);
                        intent.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(packageName);
                    this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_location_ILocationManager_Stub_Proxy$removeGeofence(Geofence fence, PendingIntent intent, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.location.ILocationManager");
                    if (fence != null) {
                        _data.writeInt(1);
                        fence.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (intent != null) {
                        _data.writeInt(1);
                        intent.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(packageName);
                    this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final Location $$robo$$android_location_ILocationManager_Stub_Proxy$getLastLocation(LocationRequest request, String packageName) throws RemoteException {
                Location _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.location.ILocationManager");
                    if (request != null) {
                        _data.writeInt(1);
                        request.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(packageName);
                    this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? Location.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_location_ILocationManager_Stub_Proxy$registerGnssStatusCallback(IGnssStatusListener callback, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.location.ILocationManager");
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    _data.writeString(packageName);
                    this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_location_ILocationManager_Stub_Proxy$unregisterGnssStatusCallback(IGnssStatusListener callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.location.ILocationManager");
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_location_ILocationManager_Stub_Proxy$geocoderIsPresent() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.location.ILocationManager");
                    this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final String $$robo$$android_location_ILocationManager_Stub_Proxy$getFromLocation(double latitude, double longitude, int maxResults, GeocoderParams params, List<Address> addrs) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.location.ILocationManager");
                    _data.writeDouble(latitude);
                    _data.writeDouble(longitude);
                    _data.writeInt(maxResults);
                    if (params != null) {
                        _data.writeInt(1);
                        params.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                    _reply.readTypedList(addrs, Address.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final String $$robo$$android_location_ILocationManager_Stub_Proxy$getFromLocationName(String locationName, double lowerLeftLatitude, double lowerLeftLongitude, double upperRightLatitude, double upperRightLongitude, int maxResults, GeocoderParams params, List<Address> addrs) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.location.ILocationManager");
                    _data.writeString(locationName);
                    _data.writeDouble(lowerLeftLatitude);
                    _data.writeDouble(lowerLeftLongitude);
                    _data.writeDouble(upperRightLatitude);
                    _data.writeDouble(upperRightLongitude);
                    _data.writeInt(maxResults);
                    if (params != null) {
                        _data.writeInt(1);
                        params.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                    _reply.readTypedList(addrs, Address.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_location_ILocationManager_Stub_Proxy$sendNiResponse(int notifId, int userResponse) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.location.ILocationManager");
                    _data.writeInt(notifId);
                    _data.writeInt(userResponse);
                    this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_location_ILocationManager_Stub_Proxy$addGnssMeasurementsListener(IGnssMeasurementsListener listener, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.location.ILocationManager");
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    _data.writeString(packageName);
                    this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_location_ILocationManager_Stub_Proxy$removeGnssMeasurementsListener(IGnssMeasurementsListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.location.ILocationManager");
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_location_ILocationManager_Stub_Proxy$addGnssNavigationMessageListener(IGnssNavigationMessageListener listener, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.location.ILocationManager");
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    _data.writeString(packageName);
                    this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_location_ILocationManager_Stub_Proxy$removeGnssNavigationMessageListener(IGnssNavigationMessageListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.location.ILocationManager");
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_location_ILocationManager_Stub_Proxy$getGnssYearOfHardware() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.location.ILocationManager");
                    this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final List<String> $$robo$$android_location_ILocationManager_Stub_Proxy$getAllProviders() throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.location.ILocationManager");
                    this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final List<String> $$robo$$android_location_ILocationManager_Stub_Proxy$getProviders(Criteria criteria, boolean enabledOnly) throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.location.ILocationManager");
                    if (criteria != null) {
                        _data.writeInt(1);
                        criteria.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(enabledOnly ? 1 : 0);
                    this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final String $$robo$$android_location_ILocationManager_Stub_Proxy$getBestProvider(Criteria criteria, boolean enabledOnly) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.location.ILocationManager");
                    if (criteria != null) {
                        _data.writeInt(1);
                        criteria.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(enabledOnly ? 1 : 0);
                    this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_location_ILocationManager_Stub_Proxy$providerMeetsCriteria(String provider, Criteria criteria) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.location.ILocationManager");
                    _data.writeString(provider);
                    if (criteria != null) {
                        _data.writeInt(1);
                        criteria.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final ProviderProperties $$robo$$android_location_ILocationManager_Stub_Proxy$getProviderProperties(String provider) throws RemoteException {
                ProviderProperties _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.location.ILocationManager");
                    _data.writeString(provider);
                    this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? ProviderProperties.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final String $$robo$$android_location_ILocationManager_Stub_Proxy$getNetworkProviderPackage() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.location.ILocationManager");
                    this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_location_ILocationManager_Stub_Proxy$isProviderEnabled(String provider) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.location.ILocationManager");
                    _data.writeString(provider);
                    this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_location_ILocationManager_Stub_Proxy$addTestProvider(String name, ProviderProperties properties, String opPackageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.location.ILocationManager");
                    _data.writeString(name);
                    if (properties != null) {
                        _data.writeInt(1);
                        properties.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(opPackageName);
                    this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_location_ILocationManager_Stub_Proxy$removeTestProvider(String provider, String opPackageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.location.ILocationManager");
                    _data.writeString(provider);
                    _data.writeString(opPackageName);
                    this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_location_ILocationManager_Stub_Proxy$setTestProviderLocation(String provider, Location loc, String opPackageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.location.ILocationManager");
                    _data.writeString(provider);
                    if (loc != null) {
                        _data.writeInt(1);
                        loc.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(opPackageName);
                    this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_location_ILocationManager_Stub_Proxy$clearTestProviderLocation(String provider, String opPackageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.location.ILocationManager");
                    _data.writeString(provider);
                    _data.writeString(opPackageName);
                    this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_location_ILocationManager_Stub_Proxy$setTestProviderEnabled(String provider, boolean enabled, String opPackageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.location.ILocationManager");
                    _data.writeString(provider);
                    _data.writeInt(enabled ? 1 : 0);
                    _data.writeString(opPackageName);
                    this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_location_ILocationManager_Stub_Proxy$clearTestProviderEnabled(String provider, String opPackageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.location.ILocationManager");
                    _data.writeString(provider);
                    _data.writeString(opPackageName);
                    this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_location_ILocationManager_Stub_Proxy$setTestProviderStatus(String provider, int status, Bundle extras, long updateTime, String opPackageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.location.ILocationManager");
                    _data.writeString(provider);
                    _data.writeInt(status);
                    if (extras != null) {
                        _data.writeInt(1);
                        extras.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeLong(updateTime);
                    _data.writeString(opPackageName);
                    this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_location_ILocationManager_Stub_Proxy$clearTestProviderStatus(String provider, String opPackageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.location.ILocationManager");
                    _data.writeString(provider);
                    _data.writeString(opPackageName);
                    this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_location_ILocationManager_Stub_Proxy$sendExtraCommand(String provider, String command, Bundle extras) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.location.ILocationManager");
                    _data.writeString(provider);
                    _data.writeString(command);
                    if (extras != null) {
                        _data.writeInt(1);
                        extras.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                    boolean bl = _result = 0 != _reply.readInt();
                    if (0 != _reply.readInt()) {
                        extras.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_location_ILocationManager_Stub_Proxy$reportLocation(Location location, boolean passive) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.location.ILocationManager");
                    if (location != null) {
                        _data.writeInt(1);
                        location.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(passive ? 1 : 0);
                    this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_location_ILocationManager_Stub_Proxy$locationCallbackFinished(ILocationListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.location.ILocationManager");
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            private void __constructor__(IBinder iBinder) {
                this.$$robo$$android_location_ILocationManager_Stub_Proxy$__constructor__(iBinder);
            }

            Proxy(IBinder iBinder) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_location_ILocationManager_Stub_Proxy$__constructor__(android.os.IBinder ), 0, this, iBinder);
            }

            @Override
            public IBinder asBinder() {
                return InvokeDynamicSupport.bootstrap("asBinder", $$robo$$android_location_ILocationManager_Stub_Proxy$asBinder(), 0, this);
            }

            public String getInterfaceDescriptor() {
                return InvokeDynamicSupport.bootstrap("getInterfaceDescriptor", $$robo$$android_location_ILocationManager_Stub_Proxy$getInterfaceDescriptor(), 0, this);
            }

            @Override
            public void requestLocationUpdates(LocationRequest locationRequest, ILocationListener iLocationListener, PendingIntent pendingIntent, String string2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("requestLocationUpdates", $$robo$$android_location_ILocationManager_Stub_Proxy$requestLocationUpdates(android.location.LocationRequest android.location.ILocationListener android.app.PendingIntent java.lang.String ), 0, this, locationRequest, iLocationListener, pendingIntent, string2);
            }

            @Override
            public void removeUpdates(ILocationListener iLocationListener, PendingIntent pendingIntent, String string2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("removeUpdates", $$robo$$android_location_ILocationManager_Stub_Proxy$removeUpdates(android.location.ILocationListener android.app.PendingIntent java.lang.String ), 0, this, iLocationListener, pendingIntent, string2);
            }

            @Override
            public void requestGeofence(LocationRequest locationRequest, Geofence geofence, PendingIntent pendingIntent, String string2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("requestGeofence", $$robo$$android_location_ILocationManager_Stub_Proxy$requestGeofence(android.location.LocationRequest android.location.Geofence android.app.PendingIntent java.lang.String ), 0, this, locationRequest, geofence, pendingIntent, string2);
            }

            @Override
            public void removeGeofence(Geofence geofence, PendingIntent pendingIntent, String string2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("removeGeofence", $$robo$$android_location_ILocationManager_Stub_Proxy$removeGeofence(android.location.Geofence android.app.PendingIntent java.lang.String ), 0, this, geofence, pendingIntent, string2);
            }

            @Override
            public Location getLastLocation(LocationRequest locationRequest, String string2) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getLastLocation", $$robo$$android_location_ILocationManager_Stub_Proxy$getLastLocation(android.location.LocationRequest java.lang.String ), 0, this, locationRequest, string2);
            }

            @Override
            public boolean registerGnssStatusCallback(IGnssStatusListener iGnssStatusListener, String string2) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("registerGnssStatusCallback", $$robo$$android_location_ILocationManager_Stub_Proxy$registerGnssStatusCallback(android.location.IGnssStatusListener java.lang.String ), 0, this, iGnssStatusListener, string2);
            }

            @Override
            public void unregisterGnssStatusCallback(IGnssStatusListener iGnssStatusListener) throws RemoteException {
                InvokeDynamicSupport.bootstrap("unregisterGnssStatusCallback", $$robo$$android_location_ILocationManager_Stub_Proxy$unregisterGnssStatusCallback(android.location.IGnssStatusListener ), 0, this, iGnssStatusListener);
            }

            @Override
            public boolean geocoderIsPresent() throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("geocoderIsPresent", $$robo$$android_location_ILocationManager_Stub_Proxy$geocoderIsPresent(), 0, this);
            }

            @Override
            public String getFromLocation(double d, double d2, int n, GeocoderParams geocoderParams, List<Address> list) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getFromLocation", $$robo$$android_location_ILocationManager_Stub_Proxy$getFromLocation(double double int android.location.GeocoderParams java.util.List<android.location.Address> ), 0, this, d, d2, n, geocoderParams, list);
            }

            @Override
            public String getFromLocationName(String string2, double d, double d2, double d3, double d4, int n, GeocoderParams geocoderParams, List<Address> list) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getFromLocationName", $$robo$$android_location_ILocationManager_Stub_Proxy$getFromLocationName(java.lang.String double double double double int android.location.GeocoderParams java.util.List<android.location.Address> ), 0, this, string2, d, d2, d3, d4, n, geocoderParams, list);
            }

            @Override
            public boolean sendNiResponse(int n, int n2) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("sendNiResponse", $$robo$$android_location_ILocationManager_Stub_Proxy$sendNiResponse(int int ), 0, this, n, n2);
            }

            @Override
            public boolean addGnssMeasurementsListener(IGnssMeasurementsListener iGnssMeasurementsListener, String string2) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("addGnssMeasurementsListener", $$robo$$android_location_ILocationManager_Stub_Proxy$addGnssMeasurementsListener(android.location.IGnssMeasurementsListener java.lang.String ), 0, this, iGnssMeasurementsListener, string2);
            }

            @Override
            public void removeGnssMeasurementsListener(IGnssMeasurementsListener iGnssMeasurementsListener) throws RemoteException {
                InvokeDynamicSupport.bootstrap("removeGnssMeasurementsListener", $$robo$$android_location_ILocationManager_Stub_Proxy$removeGnssMeasurementsListener(android.location.IGnssMeasurementsListener ), 0, this, iGnssMeasurementsListener);
            }

            @Override
            public boolean addGnssNavigationMessageListener(IGnssNavigationMessageListener iGnssNavigationMessageListener, String string2) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("addGnssNavigationMessageListener", $$robo$$android_location_ILocationManager_Stub_Proxy$addGnssNavigationMessageListener(android.location.IGnssNavigationMessageListener java.lang.String ), 0, this, iGnssNavigationMessageListener, string2);
            }

            @Override
            public void removeGnssNavigationMessageListener(IGnssNavigationMessageListener iGnssNavigationMessageListener) throws RemoteException {
                InvokeDynamicSupport.bootstrap("removeGnssNavigationMessageListener", $$robo$$android_location_ILocationManager_Stub_Proxy$removeGnssNavigationMessageListener(android.location.IGnssNavigationMessageListener ), 0, this, iGnssNavigationMessageListener);
            }

            @Override
            public int getGnssYearOfHardware() throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("getGnssYearOfHardware", $$robo$$android_location_ILocationManager_Stub_Proxy$getGnssYearOfHardware(), 0, this);
            }

            @Override
            public List<String> getAllProviders() throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getAllProviders", $$robo$$android_location_ILocationManager_Stub_Proxy$getAllProviders(), 0, this);
            }

            @Override
            public List<String> getProviders(Criteria criteria, boolean bl) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getProviders", $$robo$$android_location_ILocationManager_Stub_Proxy$getProviders(android.location.Criteria boolean ), 0, this, criteria, bl);
            }

            @Override
            public String getBestProvider(Criteria criteria, boolean bl) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getBestProvider", $$robo$$android_location_ILocationManager_Stub_Proxy$getBestProvider(android.location.Criteria boolean ), 0, this, criteria, bl);
            }

            @Override
            public boolean providerMeetsCriteria(String string2, Criteria criteria) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("providerMeetsCriteria", $$robo$$android_location_ILocationManager_Stub_Proxy$providerMeetsCriteria(java.lang.String android.location.Criteria ), 0, this, string2, criteria);
            }

            @Override
            public ProviderProperties getProviderProperties(String string2) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getProviderProperties", $$robo$$android_location_ILocationManager_Stub_Proxy$getProviderProperties(java.lang.String ), 0, this, string2);
            }

            @Override
            public String getNetworkProviderPackage() throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getNetworkProviderPackage", $$robo$$android_location_ILocationManager_Stub_Proxy$getNetworkProviderPackage(), 0, this);
            }

            @Override
            public boolean isProviderEnabled(String string2) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("isProviderEnabled", $$robo$$android_location_ILocationManager_Stub_Proxy$isProviderEnabled(java.lang.String ), 0, this, string2);
            }

            @Override
            public void addTestProvider(String string2, ProviderProperties providerProperties, String string3) throws RemoteException {
                InvokeDynamicSupport.bootstrap("addTestProvider", $$robo$$android_location_ILocationManager_Stub_Proxy$addTestProvider(java.lang.String com.android.internal.location.ProviderProperties java.lang.String ), 0, this, string2, providerProperties, string3);
            }

            @Override
            public void removeTestProvider(String string2, String string3) throws RemoteException {
                InvokeDynamicSupport.bootstrap("removeTestProvider", $$robo$$android_location_ILocationManager_Stub_Proxy$removeTestProvider(java.lang.String java.lang.String ), 0, this, string2, string3);
            }

            @Override
            public void setTestProviderLocation(String string2, Location location, String string3) throws RemoteException {
                InvokeDynamicSupport.bootstrap("setTestProviderLocation", $$robo$$android_location_ILocationManager_Stub_Proxy$setTestProviderLocation(java.lang.String android.location.Location java.lang.String ), 0, this, string2, location, string3);
            }

            @Override
            public void clearTestProviderLocation(String string2, String string3) throws RemoteException {
                InvokeDynamicSupport.bootstrap("clearTestProviderLocation", $$robo$$android_location_ILocationManager_Stub_Proxy$clearTestProviderLocation(java.lang.String java.lang.String ), 0, this, string2, string3);
            }

            @Override
            public void setTestProviderEnabled(String string2, boolean bl, String string3) throws RemoteException {
                InvokeDynamicSupport.bootstrap("setTestProviderEnabled", $$robo$$android_location_ILocationManager_Stub_Proxy$setTestProviderEnabled(java.lang.String boolean java.lang.String ), 0, this, string2, bl, string3);
            }

            @Override
            public void clearTestProviderEnabled(String string2, String string3) throws RemoteException {
                InvokeDynamicSupport.bootstrap("clearTestProviderEnabled", $$robo$$android_location_ILocationManager_Stub_Proxy$clearTestProviderEnabled(java.lang.String java.lang.String ), 0, this, string2, string3);
            }

            @Override
            public void setTestProviderStatus(String string2, int n, Bundle bundle, long l, String string3) throws RemoteException {
                InvokeDynamicSupport.bootstrap("setTestProviderStatus", $$robo$$android_location_ILocationManager_Stub_Proxy$setTestProviderStatus(java.lang.String int android.os.Bundle long java.lang.String ), 0, this, string2, n, bundle, l, string3);
            }

            @Override
            public void clearTestProviderStatus(String string2, String string3) throws RemoteException {
                InvokeDynamicSupport.bootstrap("clearTestProviderStatus", $$robo$$android_location_ILocationManager_Stub_Proxy$clearTestProviderStatus(java.lang.String java.lang.String ), 0, this, string2, string3);
            }

            @Override
            public boolean sendExtraCommand(String string2, String string3, Bundle bundle) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("sendExtraCommand", $$robo$$android_location_ILocationManager_Stub_Proxy$sendExtraCommand(java.lang.String java.lang.String android.os.Bundle ), 0, this, string2, string3, bundle);
            }

            @Override
            public void reportLocation(Location location, boolean bl) throws RemoteException {
                InvokeDynamicSupport.bootstrap("reportLocation", $$robo$$android_location_ILocationManager_Stub_Proxy$reportLocation(android.location.Location boolean ), 0, this, location, bl);
            }

            @Override
            public void locationCallbackFinished(ILocationListener iLocationListener) throws RemoteException {
                InvokeDynamicSupport.bootstrap("locationCallbackFinished", $$robo$$android_location_ILocationManager_Stub_Proxy$locationCallbackFinished(android.location.ILocationListener ), 0, this, iLocationListener);
            }

            public /* synthetic */ Proxy() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Proxy)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }
}

