/*
 * Decompiled with CFR 0.152.
 */
package android.icu.util;

import android.icu.math.BigDecimal;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class UniversalTimeScale
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int JAVA_TIME = 0;
    public static int UNIX_TIME = 1;
    public static int ICU4C_TIME = 2;
    public static int WINDOWS_FILE_TIME = 3;
    public static int DOTNET_DATE_TIME = 4;
    public static int MAC_OLD_TIME = 5;
    public static int MAC_TIME = 6;
    public static int EXCEL_TIME = 7;
    public static int DB2_TIME = 8;
    public static int UNIX_MICROSECONDS_TIME = 9;
    public static int MAX_SCALE = 10;
    public static int UNITS_VALUE = 0;
    public static int EPOCH_OFFSET_VALUE = 1;
    public static int FROM_MIN_VALUE = 2;
    public static int FROM_MAX_VALUE = 3;
    public static int TO_MIN_VALUE = 4;
    public static int TO_MAX_VALUE = 5;
    public static int EPOCH_OFFSET_PLUS_1_VALUE = 6;
    @Deprecated
    public static int EPOCH_OFFSET_MINUS_1_VALUE = 7;
    @Deprecated
    public static int UNITS_ROUND_VALUE = 8;
    @Deprecated
    public static int MIN_ROUND_VALUE = 9;
    @Deprecated
    public static int MAX_ROUND_VALUE = 10;
    @Deprecated
    public static int MAX_SCALE_VALUE = 11;
    private static long ticks = 1L;
    private static long microseconds = 10L;
    private static long milliseconds = 10000L;
    private static long seconds = 10000000L;
    private static long minutes = 600000000L;
    private static long hours = 36000000000L;
    private static long days = 864000000000L;
    private static TimeScaleData[] timeScaleTable;

    private void $$robo$$android_icu_util_UniversalTimeScale$__constructor__() {
    }

    private static final long $$robo$$android_icu_util_UniversalTimeScale$from(long otherTime, int timeScale) {
        TimeScaleData data = UniversalTimeScale.fromRangeCheck(otherTime, timeScale);
        return (otherTime + data.epochOffset) * data.units;
    }

    private static final BigDecimal $$robo$$android_icu_util_UniversalTimeScale$bigDecimalFrom(double otherTime, int timeScale) {
        TimeScaleData data = UniversalTimeScale.getTimeScaleData(timeScale);
        BigDecimal other = new BigDecimal(String.valueOf(otherTime));
        BigDecimal units = new BigDecimal(data.units);
        BigDecimal epochOffset = new BigDecimal(data.epochOffset);
        return other.add(epochOffset).multiply(units);
    }

    private static final BigDecimal $$robo$$android_icu_util_UniversalTimeScale$bigDecimalFrom(long otherTime, int timeScale) {
        TimeScaleData data = UniversalTimeScale.getTimeScaleData(timeScale);
        BigDecimal other = new BigDecimal(otherTime);
        BigDecimal units = new BigDecimal(data.units);
        BigDecimal epochOffset = new BigDecimal(data.epochOffset);
        return other.add(epochOffset).multiply(units);
    }

    private static final BigDecimal $$robo$$android_icu_util_UniversalTimeScale$bigDecimalFrom(BigDecimal otherTime, int timeScale) {
        TimeScaleData data = UniversalTimeScale.getTimeScaleData(timeScale);
        BigDecimal units = new BigDecimal(data.units);
        BigDecimal epochOffset = new BigDecimal(data.epochOffset);
        return otherTime.add(epochOffset).multiply(units);
    }

    private static final long $$robo$$android_icu_util_UniversalTimeScale$toLong(long universalTime, int timeScale) {
        TimeScaleData data = UniversalTimeScale.toRangeCheck(universalTime, timeScale);
        if (universalTime < 0L) {
            if (universalTime < data.minRound) {
                return (universalTime + data.unitsRound) / data.units - data.epochOffsetP1;
            }
            return (universalTime - data.unitsRound) / data.units - data.epochOffset;
        }
        if (universalTime > data.maxRound) {
            return (universalTime - data.unitsRound) / data.units - data.epochOffsetM1;
        }
        return (universalTime + data.unitsRound) / data.units - data.epochOffset;
    }

    private static final BigDecimal $$robo$$android_icu_util_UniversalTimeScale$toBigDecimal(long universalTime, int timeScale) {
        TimeScaleData data = UniversalTimeScale.getTimeScaleData(timeScale);
        BigDecimal universal = new BigDecimal(universalTime);
        BigDecimal units = new BigDecimal(data.units);
        BigDecimal epochOffset = new BigDecimal(data.epochOffset);
        return universal.divide(units, 4).subtract(epochOffset);
    }

    private static final BigDecimal $$robo$$android_icu_util_UniversalTimeScale$toBigDecimal(BigDecimal universalTime, int timeScale) {
        TimeScaleData data = UniversalTimeScale.getTimeScaleData(timeScale);
        BigDecimal units = new BigDecimal(data.units);
        BigDecimal epochOffset = new BigDecimal(data.epochOffset);
        return universalTime.divide(units, 4).subtract(epochOffset);
    }

    private static final TimeScaleData $$robo$$android_icu_util_UniversalTimeScale$getTimeScaleData(int scale) {
        if (scale < 0 || scale >= 10) {
            throw new IllegalArgumentException("scale out of range: " + scale);
        }
        return timeScaleTable[scale];
    }

    private static final long $$robo$$android_icu_util_UniversalTimeScale$getTimeScaleValue(int scale, int value) {
        TimeScaleData data = UniversalTimeScale.getTimeScaleData(scale);
        switch (value) {
            case 0: {
                return data.units;
            }
            case 1: {
                return data.epochOffset;
            }
            case 2: {
                return data.fromMin;
            }
            case 3: {
                return data.fromMax;
            }
            case 4: {
                return data.toMin;
            }
            case 5: {
                return data.toMax;
            }
            case 6: {
                return data.epochOffsetP1;
            }
            case 7: {
                return data.epochOffsetM1;
            }
            case 8: {
                return data.unitsRound;
            }
            case 9: {
                return data.minRound;
            }
            case 10: {
                return data.maxRound;
            }
        }
        throw new IllegalArgumentException("value out of range: " + value);
    }

    private static final TimeScaleData $$robo$$android_icu_util_UniversalTimeScale$toRangeCheck(long universalTime, int scale) {
        TimeScaleData data = UniversalTimeScale.getTimeScaleData(scale);
        if (universalTime >= data.toMin && universalTime <= data.toMax) {
            return data;
        }
        throw new IllegalArgumentException("universalTime out of range:" + universalTime);
    }

    private static final TimeScaleData $$robo$$android_icu_util_UniversalTimeScale$fromRangeCheck(long otherTime, int scale) {
        TimeScaleData data = UniversalTimeScale.getTimeScaleData(scale);
        if (otherTime >= data.fromMin && otherTime <= data.fromMax) {
            return data;
        }
        throw new IllegalArgumentException("otherTime out of range:" + otherTime);
    }

    @Deprecated
    private static final BigDecimal $$robo$$android_icu_util_UniversalTimeScale$toBigDecimalTrunc(BigDecimal universalTime, int timeScale) {
        TimeScaleData data = UniversalTimeScale.getTimeScaleData(timeScale);
        BigDecimal units = new BigDecimal(data.units);
        BigDecimal epochOffset = new BigDecimal(data.epochOffset);
        return universalTime.divide(units, 1).subtract(epochOffset);
    }

    static void __staticInitializer__() {
        timeScaleTable = new TimeScaleData[]{new TimeScaleData(10000L, 621355968000000000L, -9223372036854774999L, 9223372036854774999L, -984472800485477L, 860201606885477L), new TimeScaleData(10000000L, 621355968000000000L, Long.MIN_VALUE, Long.MAX_VALUE, -984472800485L, 860201606885L), new TimeScaleData(10000L, 621355968000000000L, -9223372036854774999L, 9223372036854774999L, -984472800485477L, 860201606885477L), new TimeScaleData(1L, 504911232000000000L, -8718460804854775808L, Long.MAX_VALUE, Long.MIN_VALUE, 8718460804854775807L), new TimeScaleData(1L, 0L, Long.MIN_VALUE, Long.MAX_VALUE, Long.MIN_VALUE, Long.MAX_VALUE), new TimeScaleData(10000000L, 600527520000000000L, Long.MIN_VALUE, Long.MAX_VALUE, -982389955685L, 862284451685L), new TimeScaleData(10000000L, 631139040000000000L, Long.MIN_VALUE, Long.MAX_VALUE, -985451107685L, 859223299685L), new TimeScaleData(864000000000L, 599265216000000000L, Long.MIN_VALUE, Long.MAX_VALUE, -11368793L, 9981605L), new TimeScaleData(864000000000L, 599265216000000000L, Long.MIN_VALUE, Long.MAX_VALUE, -11368793L, 9981605L), new TimeScaleData(10L, 621355968000000000L, -9223372036854775804L, 0x7FFFFFFFFFFFFFFCL, -984472800485477580L, 860201606885477580L)};
    }

    private void __constructor__() {
        this.$$robo$$android_icu_util_UniversalTimeScale$__constructor__();
    }

    private UniversalTimeScale() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_UniversalTimeScale$__constructor__(), 0, this);
    }

    public static long from(long l, int n) {
        return (long)InvokeDynamicSupport.bootstrapStatic("from", $$robo$$android_icu_util_UniversalTimeScale$from(long int ), 0, (long)l, (int)n);
    }

    public static BigDecimal bigDecimalFrom(double d, int n) {
        return InvokeDynamicSupport.bootstrapStatic("bigDecimalFrom", $$robo$$android_icu_util_UniversalTimeScale$bigDecimalFrom(double int ), 0, (double)d, (int)n);
    }

    public static BigDecimal bigDecimalFrom(long l, int n) {
        return InvokeDynamicSupport.bootstrapStatic("bigDecimalFrom", $$robo$$android_icu_util_UniversalTimeScale$bigDecimalFrom(long int ), 0, (long)l, (int)n);
    }

    public static BigDecimal bigDecimalFrom(BigDecimal bigDecimal, int n) {
        return InvokeDynamicSupport.bootstrapStatic("bigDecimalFrom", $$robo$$android_icu_util_UniversalTimeScale$bigDecimalFrom(android.icu.math.BigDecimal int ), 0, (BigDecimal)bigDecimal, (int)n);
    }

    public static long toLong(long l, int n) {
        return (long)InvokeDynamicSupport.bootstrapStatic("toLong", $$robo$$android_icu_util_UniversalTimeScale$toLong(long int ), 0, (long)l, (int)n);
    }

    public static BigDecimal toBigDecimal(long l, int n) {
        return InvokeDynamicSupport.bootstrapStatic("toBigDecimal", $$robo$$android_icu_util_UniversalTimeScale$toBigDecimal(long int ), 0, (long)l, (int)n);
    }

    public static BigDecimal toBigDecimal(BigDecimal bigDecimal, int n) {
        return InvokeDynamicSupport.bootstrapStatic("toBigDecimal", $$robo$$android_icu_util_UniversalTimeScale$toBigDecimal(android.icu.math.BigDecimal int ), 0, (BigDecimal)bigDecimal, (int)n);
    }

    private static TimeScaleData getTimeScaleData(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getTimeScaleData", $$robo$$android_icu_util_UniversalTimeScale$getTimeScaleData(int ), 0, (int)n);
    }

    public static long getTimeScaleValue(int n, int n2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("getTimeScaleValue", $$robo$$android_icu_util_UniversalTimeScale$getTimeScaleValue(int int ), 0, (int)n, (int)n2);
    }

    private static TimeScaleData toRangeCheck(long l, int n) {
        return InvokeDynamicSupport.bootstrapStatic("toRangeCheck", $$robo$$android_icu_util_UniversalTimeScale$toRangeCheck(long int ), 0, (long)l, (int)n);
    }

    private static TimeScaleData fromRangeCheck(long l, int n) {
        return InvokeDynamicSupport.bootstrapStatic("fromRangeCheck", $$robo$$android_icu_util_UniversalTimeScale$fromRangeCheck(long int ), 0, (long)l, (int)n);
    }

    @Deprecated
    public static BigDecimal toBigDecimalTrunc(BigDecimal bigDecimal, int n) {
        return InvokeDynamicSupport.bootstrapStatic("toBigDecimalTrunc", $$robo$$android_icu_util_UniversalTimeScale$toBigDecimalTrunc(android.icu.math.BigDecimal int ), 0, (BigDecimal)bigDecimal, (int)n);
    }

    static {
        RobolectricInternals.classInitializing(UniversalTimeScale.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UniversalTimeScale)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class TimeScaleData
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        long units;
        long epochOffset;
        long fromMin;
        long fromMax;
        long toMin;
        long toMax;
        long epochOffsetP1;
        long epochOffsetM1;
        long unitsRound;
        long minRound;
        long maxRound;

        private void $$robo$$android_icu_util_UniversalTimeScale_TimeScaleData$__constructor__(long theUnits, long theEpochOffset, long theToMin, long theToMax, long theFromMin, long theFromMax) {
            this.units = theUnits;
            this.unitsRound = theUnits / 2L;
            this.minRound = Long.MIN_VALUE + this.unitsRound;
            this.maxRound = Long.MAX_VALUE - this.unitsRound;
            this.epochOffset = theEpochOffset / theUnits;
            if (theUnits == 1L) {
                this.epochOffsetP1 = this.epochOffsetM1 = this.epochOffset;
            } else {
                this.epochOffsetP1 = this.epochOffset + 1L;
                this.epochOffsetM1 = this.epochOffset - 1L;
            }
            this.toMin = theToMin;
            this.toMax = theToMax;
            this.fromMin = theFromMin;
            this.fromMax = theFromMax;
        }

        private void __constructor__(long l, long l2, long l3, long l4, long l5, long l6) {
            this.$$robo$$android_icu_util_UniversalTimeScale_TimeScaleData$__constructor__(l, l2, l3, l4, l5, l6);
        }

        TimeScaleData(long l, long l2, long l3, long l4, long l5, long l6) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_UniversalTimeScale_TimeScaleData$__constructor__(long long long long long long ), 0, this, l, l2, l3, l4, l5, l6);
        }

        public /* synthetic */ TimeScaleData() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TimeScaleData)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

