/*
 * Decompiled with CFR 0.152.
 */
package android.icu.util;

import android.icu.impl.ICUResourceBundle;
import android.icu.text.UnicodeSet;
import android.icu.util.ULocale;
import android.icu.util.UResourceBundle;
import android.icu.util.VersionInfo;
import com.google.errorprone.annotations.DoNotMock;
import java.util.MissingResourceException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class LocaleData
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String MEASUREMENT_SYSTEM = "MeasurementSystem";
    private static String PAPER_SIZE = "PaperSize";
    private static String LOCALE_DISPLAY_PATTERN = "localeDisplayPattern";
    private static String PATTERN = "pattern";
    private static String SEPARATOR = "separator";
    private boolean noSubstitute;
    private ICUResourceBundle bundle;
    private ICUResourceBundle langBundle;
    public static int ES_STANDARD = 0;
    public static int ES_AUXILIARY = 1;
    public static int ES_INDEX = 2;
    @Deprecated
    public static int ES_CURRENCY = 3;
    public static int ES_PUNCTUATION = 4;
    public static int ES_COUNT = 5;
    public static int QUOTATION_START = 0;
    public static int QUOTATION_END = 1;
    public static int ALT_QUOTATION_START = 2;
    public static int ALT_QUOTATION_END = 3;
    public static int DELIMITER_COUNT = 4;
    private static String[] DELIMITER_TYPES;
    private static VersionInfo gCLDRVersion;

    private void $$robo$$android_icu_util_LocaleData$__constructor__() {
    }

    private static final UnicodeSet $$robo$$android_icu_util_LocaleData$getExemplarSet(ULocale locale, int options) {
        return LocaleData.getInstance(locale).getExemplarSet(options, 0);
    }

    private static final UnicodeSet $$robo$$android_icu_util_LocaleData$getExemplarSet(ULocale locale, int options, int extype) {
        return LocaleData.getInstance(locale).getExemplarSet(options, extype);
    }

    private final UnicodeSet $$robo$$android_icu_util_LocaleData$getExemplarSet(int options, int extype) {
        String[] exemplarSetTypes = new String[]{"ExemplarCharacters", "AuxExemplarCharacters", "ExemplarCharactersIndex", "ExemplarCharactersCurrency", "ExemplarCharactersPunctuation"};
        if (extype == 3) {
            return this.noSubstitute ? null : UnicodeSet.EMPTY;
        }
        try {
            String aKey = exemplarSetTypes[extype];
            ICUResourceBundle stringBundle = (ICUResourceBundle)this.bundle.get(aKey);
            if (this.noSubstitute && stringBundle.getLoadingStatus() == 2) {
                return null;
            }
            String unicodeSetPattern = stringBundle.getString();
            return new UnicodeSet(unicodeSetPattern, 1 | options);
        }
        catch (ArrayIndexOutOfBoundsException aiooe) {
            throw new IllegalArgumentException(aiooe);
        }
        catch (Exception ex) {
            return this.noSubstitute ? null : UnicodeSet.EMPTY;
        }
    }

    private static final LocaleData $$robo$$android_icu_util_LocaleData$getInstance(ULocale locale) {
        LocaleData ld = new LocaleData();
        ld.bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("android/icu/impl/data/icudt56b", locale);
        ld.langBundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("android/icu/impl/data/icudt56b/lang", locale);
        ld.noSubstitute = false;
        return ld;
    }

    private static final LocaleData $$robo$$android_icu_util_LocaleData$getInstance() {
        return LocaleData.getInstance(ULocale.getDefault(ULocale.Category.FORMAT));
    }

    private final void $$robo$$android_icu_util_LocaleData$setNoSubstitute(boolean setting) {
        this.noSubstitute = setting;
    }

    private final boolean $$robo$$android_icu_util_LocaleData$getNoSubstitute() {
        return this.noSubstitute;
    }

    private final String $$robo$$android_icu_util_LocaleData$getDelimiter(int type) {
        ICUResourceBundle delimitersBundle = (ICUResourceBundle)this.bundle.get("delimiters");
        ICUResourceBundle stringBundle = delimitersBundle.getWithFallback(DELIMITER_TYPES[type]);
        if (this.noSubstitute && stringBundle.getLoadingStatus() == 2) {
            return null;
        }
        return stringBundle.getString();
    }

    private static final UResourceBundle $$robo$$android_icu_util_LocaleData$measurementTypeBundleForLocale(ULocale locale, String measurementType) {
        UResourceBundle measTypeBundle = null;
        ULocale fullLoc = ULocale.addLikelySubtags(locale);
        String region = fullLoc.getCountry();
        try {
            UResourceBundle rb = UResourceBundle.getBundleInstance("android/icu/impl/data/icudt56b", "supplementalData", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
            UResourceBundle measurementData = rb.get("measurementData");
            UResourceBundle measDataBundle = null;
            try {
                measDataBundle = measurementData.get(region);
                measTypeBundle = measDataBundle.get(measurementType);
            }
            catch (MissingResourceException mre) {
                measDataBundle = measurementData.get("001");
                measTypeBundle = measDataBundle.get(measurementType);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return measTypeBundle;
    }

    private static final MeasurementSystem $$robo$$android_icu_util_LocaleData$getMeasurementSystem(ULocale locale) {
        UResourceBundle sysBundle = LocaleData.measurementTypeBundleForLocale(locale, "MeasurementSystem");
        int system = sysBundle.getInt();
        if (MeasurementSystem.US.equals(system)) {
            return MeasurementSystem.US;
        }
        if (MeasurementSystem.UK.equals(system)) {
            return MeasurementSystem.UK;
        }
        if (MeasurementSystem.SI.equals(system)) {
            return MeasurementSystem.SI;
        }
        return null;
    }

    private static final PaperSize $$robo$$android_icu_util_LocaleData$getPaperSize(ULocale locale) {
        UResourceBundle obj = LocaleData.measurementTypeBundleForLocale(locale, "PaperSize");
        int[] size = obj.getIntVector();
        return new PaperSize(size[0], size[1]);
    }

    private final String $$robo$$android_icu_util_LocaleData$getLocaleDisplayPattern() {
        ICUResourceBundle locDispBundle = (ICUResourceBundle)this.langBundle.get("localeDisplayPattern");
        String localeDisplayPattern = locDispBundle.getStringWithFallback("pattern");
        return localeDisplayPattern;
    }

    private final String $$robo$$android_icu_util_LocaleData$getLocaleSeparator() {
        String sub0 = "{0}";
        String sub1 = "{1}";
        ICUResourceBundle locDispBundle = (ICUResourceBundle)this.langBundle.get("localeDisplayPattern");
        String localeSeparator = locDispBundle.getStringWithFallback("separator");
        int index0 = localeSeparator.indexOf(sub0);
        int index1 = localeSeparator.indexOf(sub1);
        if (index0 >= 0 && index1 >= 0 && index0 <= index1) {
            return localeSeparator.substring(index0 + sub0.length(), index1);
        }
        return localeSeparator;
    }

    private static final VersionInfo $$robo$$android_icu_util_LocaleData$getCLDRVersion() {
        if (gCLDRVersion == null) {
            UResourceBundle supplementalDataBundle = UResourceBundle.getBundleInstance("android/icu/impl/data/icudt56b", "supplementalData", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
            UResourceBundle cldrVersionBundle = supplementalDataBundle.get("cldrVersion");
            gCLDRVersion = VersionInfo.getInstance(cldrVersionBundle.getString());
        }
        return gCLDRVersion;
    }

    static void __staticInitializer__() {
        DELIMITER_TYPES = new String[]{"quotationStart", "quotationEnd", "alternateQuotationStart", "alternateQuotationEnd"};
        gCLDRVersion = null;
    }

    private void __constructor__() {
        this.$$robo$$android_icu_util_LocaleData$__constructor__();
    }

    private LocaleData() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_LocaleData$__constructor__(), 0, this);
    }

    public static UnicodeSet getExemplarSet(ULocale uLocale, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getExemplarSet", $$robo$$android_icu_util_LocaleData$getExemplarSet(android.icu.util.ULocale int ), 0, (ULocale)uLocale, (int)n);
    }

    public static UnicodeSet getExemplarSet(ULocale uLocale, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("getExemplarSet", $$robo$$android_icu_util_LocaleData$getExemplarSet(android.icu.util.ULocale int int ), 0, (ULocale)uLocale, (int)n, (int)n2);
    }

    public UnicodeSet getExemplarSet(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getExemplarSet", $$robo$$android_icu_util_LocaleData$getExemplarSet(int int ), 0, this, n, n2);
    }

    public static LocaleData getInstance(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_util_LocaleData$getInstance(android.icu.util.ULocale ), 0, (ULocale)uLocale);
    }

    public static LocaleData getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_util_LocaleData$getInstance(), 0);
    }

    public void setNoSubstitute(boolean bl) {
        InvokeDynamicSupport.bootstrap("setNoSubstitute", $$robo$$android_icu_util_LocaleData$setNoSubstitute(boolean ), 0, this, bl);
    }

    public boolean getNoSubstitute() {
        return (boolean)InvokeDynamicSupport.bootstrap("getNoSubstitute", $$robo$$android_icu_util_LocaleData$getNoSubstitute(), 0, this);
    }

    public String getDelimiter(int n) {
        return InvokeDynamicSupport.bootstrap("getDelimiter", $$robo$$android_icu_util_LocaleData$getDelimiter(int ), 0, this, n);
    }

    private static UResourceBundle measurementTypeBundleForLocale(ULocale uLocale, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("measurementTypeBundleForLocale", $$robo$$android_icu_util_LocaleData$measurementTypeBundleForLocale(android.icu.util.ULocale java.lang.String ), 0, (ULocale)uLocale, (String)string2);
    }

    public static MeasurementSystem getMeasurementSystem(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getMeasurementSystem", $$robo$$android_icu_util_LocaleData$getMeasurementSystem(android.icu.util.ULocale ), 0, (ULocale)uLocale);
    }

    public static PaperSize getPaperSize(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getPaperSize", $$robo$$android_icu_util_LocaleData$getPaperSize(android.icu.util.ULocale ), 0, (ULocale)uLocale);
    }

    public String getLocaleDisplayPattern() {
        return InvokeDynamicSupport.bootstrap("getLocaleDisplayPattern", $$robo$$android_icu_util_LocaleData$getLocaleDisplayPattern(), 0, this);
    }

    public String getLocaleSeparator() {
        return InvokeDynamicSupport.bootstrap("getLocaleSeparator", $$robo$$android_icu_util_LocaleData$getLocaleSeparator(), 0, this);
    }

    public static VersionInfo getCLDRVersion() {
        return InvokeDynamicSupport.bootstrapStatic("getCLDRVersion", $$robo$$android_icu_util_LocaleData$getCLDRVersion(), 0);
    }

    static {
        RobolectricInternals.classInitializing(LocaleData.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LocaleData)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class PaperSize
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int height;
        private int width;

        private void $$robo$$android_icu_util_LocaleData_PaperSize$__constructor__(int h, int w) {
            this.height = h;
            this.width = w;
        }

        private final int $$robo$$android_icu_util_LocaleData_PaperSize$getHeight() {
            return this.height;
        }

        private final int $$robo$$android_icu_util_LocaleData_PaperSize$getWidth() {
            return this.width;
        }

        private /* synthetic */ void $$robo$$android_icu_util_LocaleData_PaperSize$__constructor__(int x0, int x1, 1 x2) {
        }

        private void __constructor__(int n, int n2) {
            this.$$robo$$android_icu_util_LocaleData_PaperSize$__constructor__(n, n2);
        }

        private PaperSize(int n, int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_LocaleData_PaperSize$__constructor__(int int ), 0, this, n, n2);
        }

        public int getHeight() {
            return (int)InvokeDynamicSupport.bootstrap("getHeight", $$robo$$android_icu_util_LocaleData_PaperSize$getHeight(), 0, this);
        }

        public int getWidth() {
            return (int)InvokeDynamicSupport.bootstrap("getWidth", $$robo$$android_icu_util_LocaleData_PaperSize$getWidth(), 0, this);
        }

        private /* synthetic */ void __constructor__(int n, int n2, 1 var3_3) {
            this.$$robo$$android_icu_util_LocaleData_PaperSize$__constructor__(n, n2, var3_3);
        }

        public /* synthetic */ PaperSize() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PaperSize)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class MeasurementSystem
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static MeasurementSystem SI;
        public static MeasurementSystem US;
        public static MeasurementSystem UK;
        private int systemID;

        private void $$robo$$android_icu_util_LocaleData_MeasurementSystem$__constructor__(int id2) {
            this.systemID = id2;
        }

        private final boolean $$robo$$android_icu_util_LocaleData_MeasurementSystem$equals(int id2) {
            return this.systemID == id2;
        }

        static void __staticInitializer__() {
            SI = new MeasurementSystem(0);
            US = new MeasurementSystem(1);
            UK = new MeasurementSystem(2);
        }

        private void __constructor__(int n) {
            this.$$robo$$android_icu_util_LocaleData_MeasurementSystem$__constructor__(n);
        }

        private MeasurementSystem(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_LocaleData_MeasurementSystem$__constructor__(int ), 0, this, n);
        }

        private boolean equals(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_util_LocaleData_MeasurementSystem$equals(int ), 0, this, n);
        }

        static {
            RobolectricInternals.classInitializing(MeasurementSystem.class);
        }

        public /* synthetic */ MeasurementSystem() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MeasurementSystem)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

