/*
 * Decompiled with CFR 0.152.
 */
package android.icu.util;

import android.icu.util.ICUUncheckedIOException;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class BytesTrie
implements Cloneable,
Iterable<Entry> {
    public transient /* synthetic */ Object __robo_data__;
    private static Result[] valueResults_;
    static int kMaxBranchLinearSubNodeLength = 5;
    static int kMinLinearMatch = 16;
    static int kMaxLinearMatchLength = 16;
    static int kMinValueLead = 32;
    private static int kValueIsFinal = 1;
    static int kMinOneByteValueLead = 16;
    static int kMaxOneByteValue = 64;
    static int kMinTwoByteValueLead = 81;
    static int kMaxTwoByteValue = 6911;
    static int kMinThreeByteValueLead = 108;
    static int kFourByteValueLead = 126;
    static int kMaxThreeByteValue = 0x11FFFF;
    static int kFiveByteValueLead = 127;
    static int kMaxOneByteDelta = 191;
    static int kMinTwoByteDeltaLead = 192;
    static int kMinThreeByteDeltaLead = 240;
    static int kFourByteDeltaLead = 254;
    static int kFiveByteDeltaLead = 255;
    static int kMaxTwoByteDelta = 12287;
    static int kMaxThreeByteDelta = 917503;
    private byte[] bytes_;
    private int root_;
    private int pos_;
    private int remainingMatchLength_;
    static /* synthetic */ boolean $assertionsDisabled;

    private void $$robo$$android_icu_util_BytesTrie$__constructor__(byte[] trieBytes, int offset) {
        this.bytes_ = trieBytes;
        this.pos_ = this.root_ = offset;
        this.remainingMatchLength_ = -1;
    }

    private final Object $$robo$$android_icu_util_BytesTrie$clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private final BytesTrie $$robo$$android_icu_util_BytesTrie$reset() {
        this.pos_ = this.root_;
        this.remainingMatchLength_ = -1;
        return this;
    }

    private final BytesTrie $$robo$$android_icu_util_BytesTrie$saveState(State state) {
        State.access$002(state, this.bytes_);
        state.root = this.root_;
        state.pos = this.pos_;
        state.remainingMatchLength = this.remainingMatchLength_;
        return this;
    }

    private final BytesTrie $$robo$$android_icu_util_BytesTrie$resetToState(State state) {
        if (this.bytes_ != state.bytes || this.bytes_ == null || this.root_ != state.root) {
            throw new IllegalArgumentException("incompatible trie state");
        }
        this.pos_ = state.pos;
        this.remainingMatchLength_ = state.remainingMatchLength;
        return this;
    }

    private final Result $$robo$$android_icu_util_BytesTrie$current() {
        int node;
        int pos = this.pos_;
        if (pos < 0) {
            return Result.NO_MATCH;
        }
        return this.remainingMatchLength_ < 0 && (node = this.bytes_[pos] & 0xFF) >= 32 ? valueResults_[node & 1] : Result.NO_VALUE;
    }

    private final Result $$robo$$android_icu_util_BytesTrie$first(int inByte) {
        this.remainingMatchLength_ = -1;
        if (inByte < 0) {
            inByte += 256;
        }
        return this.nextImpl(this.root_, inByte);
    }

    private final Result $$robo$$android_icu_util_BytesTrie$next(int inByte) {
        int length;
        int pos = this.pos_;
        if (pos < 0) {
            return Result.NO_MATCH;
        }
        if (inByte < 0) {
            inByte += 256;
        }
        if ((length = this.remainingMatchLength_) >= 0) {
            if (inByte == (this.bytes_[pos++] & 0xFF)) {
                int node;
                this.remainingMatchLength_ = --length;
                this.pos_ = pos;
                return length < 0 && (node = this.bytes_[pos] & 0xFF) >= 32 ? valueResults_[node & 1] : Result.NO_VALUE;
            }
            this.stop();
            return Result.NO_MATCH;
        }
        return this.nextImpl(pos, inByte);
    }

    private final Result $$robo$$android_icu_util_BytesTrie$next(byte[] s, int sIndex, int sLimit) {
        if (sIndex >= sLimit) {
            return this.current();
        }
        int pos = this.pos_;
        if (pos < 0) {
            return Result.NO_MATCH;
        }
        int length = this.remainingMatchLength_;
        block0: while (true) {
            int node;
            if (sIndex == sLimit) {
                this.remainingMatchLength_ = length;
                this.pos_ = pos;
                return length < 0 && (node = this.bytes_[pos] & 0xFF) >= 32 ? valueResults_[node & 1] : Result.NO_VALUE;
            }
            byte inByte = s[sIndex++];
            if (length >= 0) {
                if (inByte != this.bytes_[pos]) {
                    this.stop();
                    return Result.NO_MATCH;
                }
                ++pos;
                --length;
                continue;
            }
            this.remainingMatchLength_ = length;
            while (true) {
                if ((node = this.bytes_[pos++] & 0xFF) < 16) {
                    Result result = this.branchNext(pos, node, inByte & 0xFF);
                    if (result == Result.NO_MATCH) {
                        return Result.NO_MATCH;
                    }
                    if (sIndex == sLimit) {
                        return result;
                    }
                    if (result == Result.FINAL_VALUE) {
                        this.stop();
                        return Result.NO_MATCH;
                    }
                    inByte = s[sIndex++];
                    pos = this.pos_;
                    continue;
                }
                if (node < 32) {
                    length = node - 16;
                    if (inByte != this.bytes_[pos]) {
                        this.stop();
                        return Result.NO_MATCH;
                    }
                    ++pos;
                    --length;
                    continue block0;
                }
                if ((node & 1) != 0) {
                    this.stop();
                    return Result.NO_MATCH;
                }
                pos = BytesTrie.skipValue(pos, node);
                if (!$assertionsDisabled && (this.bytes_[pos] & 0xFF) >= 32) break block0;
            }
            break;
        }
        throw new AssertionError();
    }

    private final int $$robo$$android_icu_util_BytesTrie$getValue() {
        int pos = this.pos_;
        int leadByte = this.bytes_[pos++] & 0xFF;
        if (!$assertionsDisabled && leadByte < 32) {
            throw new AssertionError();
        }
        return BytesTrie.readValue(this.bytes_, pos, leadByte >> 1);
    }

    private final long $$robo$$android_icu_util_BytesTrie$getUniqueValue() {
        int pos = this.pos_;
        if (pos < 0) {
            return 0L;
        }
        long uniqueValue = BytesTrie.findUniqueValue(this.bytes_, pos + this.remainingMatchLength_ + 1, 0L);
        return uniqueValue << 31 >> 31;
    }

    private final int $$robo$$android_icu_util_BytesTrie$getNextBytes(Appendable out) {
        int node;
        int pos = this.pos_;
        if (pos < 0) {
            return 0;
        }
        if (this.remainingMatchLength_ >= 0) {
            BytesTrie.append(out, this.bytes_[pos] & 0xFF);
            return 1;
        }
        if ((node = this.bytes_[pos++] & 0xFF) >= 32) {
            if ((node & 1) != 0) {
                return 0;
            }
            pos = BytesTrie.skipValue(pos, node);
            node = this.bytes_[pos++] & 0xFF;
            if (!$assertionsDisabled && node >= 32) {
                throw new AssertionError();
            }
        }
        if (node < 16) {
            if (node == 0) {
                node = this.bytes_[pos++] & 0xFF;
            }
            BytesTrie.getNextBranchBytes(this.bytes_, pos, ++node, out);
            return node;
        }
        BytesTrie.append(out, this.bytes_[pos] & 0xFF);
        return 1;
    }

    private final Iterator $$robo$$android_icu_util_BytesTrie$iterator() {
        return new Iterator(this.bytes_, this.pos_, this.remainingMatchLength_, 0);
    }

    private final Iterator $$robo$$android_icu_util_BytesTrie$iterator(int maxStringLength) {
        return new Iterator(this.bytes_, this.pos_, this.remainingMatchLength_, maxStringLength);
    }

    private static final Iterator $$robo$$android_icu_util_BytesTrie$iterator(byte[] trieBytes, int offset, int maxStringLength) {
        return new Iterator(trieBytes, offset, -1, maxStringLength);
    }

    private final void $$robo$$android_icu_util_BytesTrie$stop() {
        this.pos_ = -1;
    }

    private static final int $$robo$$android_icu_util_BytesTrie$readValue(byte[] bytes, int pos, int leadByte) {
        int value = leadByte < 81 ? leadByte - 16 : (leadByte < 108 ? leadByte - 81 << 8 | bytes[pos] & 0xFF : (leadByte < 126 ? leadByte - 108 << 16 | (bytes[pos] & 0xFF) << 8 | bytes[pos + 1] & 0xFF : (leadByte == 126 ? (bytes[pos] & 0xFF) << 16 | (bytes[pos + 1] & 0xFF) << 8 | bytes[pos + 2] & 0xFF : bytes[pos] << 24 | (bytes[pos + 1] & 0xFF) << 16 | (bytes[pos + 2] & 0xFF) << 8 | bytes[pos + 3] & 0xFF)));
        return value;
    }

    private static final int $$robo$$android_icu_util_BytesTrie$skipValue(int pos, int leadByte) {
        if (!$assertionsDisabled && leadByte < 32) {
            throw new AssertionError();
        }
        if (leadByte >= 162) {
            pos = leadByte < 216 ? ++pos : (leadByte < 252 ? (pos += 2) : (pos += 3 + (leadByte >> 1 & 1)));
        }
        return pos;
    }

    private static final int $$robo$$android_icu_util_BytesTrie$skipValue(byte[] bytes, int pos) {
        int leadByte = bytes[pos++] & 0xFF;
        return BytesTrie.skipValue(pos, leadByte);
    }

    private static final int $$robo$$android_icu_util_BytesTrie$jumpByDelta(byte[] bytes, int pos) {
        int delta;
        if ((delta = bytes[pos++] & 0xFF) >= 192) {
            if (delta < 240) {
                delta = delta - 192 << 8 | bytes[pos++] & 0xFF;
            } else if (delta < 254) {
                delta = delta - 240 << 16 | (bytes[pos] & 0xFF) << 8 | bytes[pos + 1] & 0xFF;
                pos += 2;
            } else if (delta == 254) {
                delta = (bytes[pos] & 0xFF) << 16 | (bytes[pos + 1] & 0xFF) << 8 | bytes[pos + 2] & 0xFF;
                pos += 3;
            } else {
                delta = bytes[pos] << 24 | (bytes[pos + 1] & 0xFF) << 16 | (bytes[pos + 2] & 0xFF) << 8 | bytes[pos + 3] & 0xFF;
                pos += 4;
            }
        }
        return pos + delta;
    }

    private static final int $$robo$$android_icu_util_BytesTrie$skipDelta(byte[] bytes, int pos) {
        int delta;
        if ((delta = bytes[pos++] & 0xFF) >= 192) {
            pos = delta < 240 ? ++pos : (delta < 254 ? (pos += 2) : (pos += 3 + (delta & 1)));
        }
        return pos;
    }

    private final Result $$robo$$android_icu_util_BytesTrie$branchNext(int pos, int length, int inByte) {
        if (length == 0) {
            length = this.bytes_[pos++] & 0xFF;
        }
        ++length;
        while (length > 5) {
            if (inByte < (this.bytes_[pos++] & 0xFF)) {
                length >>= 1;
                pos = BytesTrie.jumpByDelta(this.bytes_, pos);
                continue;
            }
            length -= length >> 1;
            pos = BytesTrie.skipDelta(this.bytes_, pos);
        }
        do {
            if (inByte == (this.bytes_[pos++] & 0xFF)) {
                Result result;
                int node = this.bytes_[pos] & 0xFF;
                if (!$assertionsDisabled && node < 32) {
                    throw new AssertionError();
                }
                if ((node & 1) != 0) {
                    result = Result.FINAL_VALUE;
                } else {
                    int delta;
                    ++pos;
                    if ((node >>= 1) < 81) {
                        delta = node - 16;
                    } else if (node < 108) {
                        delta = node - 81 << 8 | this.bytes_[pos++] & 0xFF;
                    } else if (node < 126) {
                        delta = node - 108 << 16 | (this.bytes_[pos] & 0xFF) << 8 | this.bytes_[pos + 1] & 0xFF;
                        pos += 2;
                    } else if (node == 126) {
                        delta = (this.bytes_[pos] & 0xFF) << 16 | (this.bytes_[pos + 1] & 0xFF) << 8 | this.bytes_[pos + 2] & 0xFF;
                        pos += 3;
                    } else {
                        delta = this.bytes_[pos] << 24 | (this.bytes_[pos + 1] & 0xFF) << 16 | (this.bytes_[pos + 2] & 0xFF) << 8 | this.bytes_[pos + 3] & 0xFF;
                        pos += 4;
                    }
                    node = this.bytes_[pos += delta] & 0xFF;
                    result = node >= 32 ? valueResults_[node & 1] : Result.NO_VALUE;
                }
                this.pos_ = pos;
                return result;
            }
            pos = BytesTrie.skipValue(this.bytes_, pos);
        } while (--length > 1);
        if (inByte == (this.bytes_[pos++] & 0xFF)) {
            this.pos_ = pos;
            int node = this.bytes_[pos] & 0xFF;
            return node >= 32 ? valueResults_[node & 1] : Result.NO_VALUE;
        }
        this.stop();
        return Result.NO_MATCH;
    }

    private final Result $$robo$$android_icu_util_BytesTrie$nextImpl(int pos, int inByte) {
        block4: {
            do {
                int node;
                if ((node = this.bytes_[pos++] & 0xFF) < 16) {
                    return this.branchNext(pos, node, inByte);
                }
                if (node < 32) {
                    int length = node - 16;
                    if (inByte == (this.bytes_[pos++] & 0xFF)) {
                        this.remainingMatchLength_ = --length;
                        this.pos_ = pos;
                        return length < 0 && (node = this.bytes_[pos] & 0xFF) >= 32 ? valueResults_[node & 1] : Result.NO_VALUE;
                    }
                    break block4;
                }
                if ((node & 1) != 0) break block4;
                pos = BytesTrie.skipValue(pos, node);
            } while ($assertionsDisabled || (this.bytes_[pos] & 0xFF) < 32);
            throw new AssertionError();
        }
        this.stop();
        return Result.NO_MATCH;
    }

    private static final long $$robo$$android_icu_util_BytesTrie$findUniqueValueFromBranch(byte[] bytes, int pos, int length, long uniqueValue) {
        while (length > 5) {
            if ((uniqueValue = BytesTrie.findUniqueValueFromBranch(bytes, BytesTrie.jumpByDelta(bytes, ++pos), length >> 1, uniqueValue)) == 0L) {
                return 0L;
            }
            length -= length >> 1;
            pos = BytesTrie.skipDelta(bytes, pos);
        }
        do {
            int n = ++pos;
            int node = bytes[n] & 0xFF;
            boolean isFinal = (node & 1) != 0;
            int value = BytesTrie.readValue(bytes, ++pos, node >> 1);
            pos = BytesTrie.skipValue(pos, node);
            if (isFinal) {
                if (uniqueValue != 0L) {
                    if (value == (int)(uniqueValue >> 1)) continue;
                    return 0L;
                }
                uniqueValue = (long)value << 1 | 1L;
                continue;
            }
            if ((uniqueValue = BytesTrie.findUniqueValue(bytes, pos + value, uniqueValue)) != 0L) continue;
            return 0L;
        } while (--length > 1);
        return (long)(pos + 1) << 33 | uniqueValue & 0x1FFFFFFFFL;
    }

    private static final long $$robo$$android_icu_util_BytesTrie$findUniqueValue(byte[] bytes, int pos, long uniqueValue) {
        while (true) {
            int node;
            if ((node = bytes[pos++] & 0xFF) < 16) {
                if (node == 0) {
                    node = bytes[pos++] & 0xFF;
                }
                if ((uniqueValue = BytesTrie.findUniqueValueFromBranch(bytes, pos, node + 1, uniqueValue)) == 0L) {
                    return 0L;
                }
                pos = (int)(uniqueValue >>> 33);
                continue;
            }
            if (node < 32) {
                pos += node - 16 + 1;
                continue;
            }
            boolean isFinal = (node & 1) != 0;
            int value = BytesTrie.readValue(bytes, pos, node >> 1);
            if (uniqueValue != 0L) {
                if (value != (int)(uniqueValue >> 1)) {
                    return 0L;
                }
            } else {
                uniqueValue = (long)value << 1 | 1L;
            }
            if (isFinal) {
                return uniqueValue;
            }
            pos = BytesTrie.skipValue(pos, node);
        }
    }

    private static final void $$robo$$android_icu_util_BytesTrie$getNextBranchBytes(byte[] bytes, int pos, int length, Appendable out) {
        while (length > 5) {
            BytesTrie.getNextBranchBytes(bytes, BytesTrie.jumpByDelta(bytes, ++pos), length >> 1, out);
            length -= length >> 1;
            pos = BytesTrie.skipDelta(bytes, pos);
        }
        do {
            BytesTrie.append(out, bytes[pos++] & 0xFF);
            pos = BytesTrie.skipValue(bytes, pos);
        } while (--length > 1);
        BytesTrie.append(out, bytes[pos] & 0xFF);
    }

    private static final void $$robo$$android_icu_util_BytesTrie$append(Appendable out, int c) {
        try {
            out.append((char)c);
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException(e);
        }
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !BytesTrie.class.desiredAssertionStatus();
        valueResults_ = new Result[]{Result.INTERMEDIATE_VALUE, Result.FINAL_VALUE};
    }

    private void __constructor__(byte[] byArray, int n) {
        this.$$robo$$android_icu_util_BytesTrie$__constructor__(byArray, n);
    }

    public BytesTrie(byte[] byArray, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_BytesTrie$__constructor__(byte[] int ), 0, this, byArray, n);
    }

    public Object clone() throws CloneNotSupportedException {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_icu_util_BytesTrie$clone(), 0, this);
    }

    public BytesTrie reset() {
        return InvokeDynamicSupport.bootstrap("reset", $$robo$$android_icu_util_BytesTrie$reset(), 0, this);
    }

    public BytesTrie saveState(State state) {
        return InvokeDynamicSupport.bootstrap("saveState", $$robo$$android_icu_util_BytesTrie$saveState(android.icu.util.BytesTrie$State ), 0, this, state);
    }

    public BytesTrie resetToState(State state) {
        return InvokeDynamicSupport.bootstrap("resetToState", $$robo$$android_icu_util_BytesTrie$resetToState(android.icu.util.BytesTrie$State ), 0, this, state);
    }

    public Result current() {
        return InvokeDynamicSupport.bootstrap("current", $$robo$$android_icu_util_BytesTrie$current(), 0, this);
    }

    public Result first(int n) {
        return InvokeDynamicSupport.bootstrap("first", $$robo$$android_icu_util_BytesTrie$first(int ), 0, this, n);
    }

    public Result next(int n) {
        return InvokeDynamicSupport.bootstrap("next", $$robo$$android_icu_util_BytesTrie$next(int ), 0, this, n);
    }

    public Result next(byte[] byArray, int n, int n2) {
        return InvokeDynamicSupport.bootstrap("next", $$robo$$android_icu_util_BytesTrie$next(byte[] int int ), 0, this, byArray, n, n2);
    }

    public int getValue() {
        return (int)InvokeDynamicSupport.bootstrap("getValue", $$robo$$android_icu_util_BytesTrie$getValue(), 0, this);
    }

    public long getUniqueValue() {
        return (long)InvokeDynamicSupport.bootstrap("getUniqueValue", $$robo$$android_icu_util_BytesTrie$getUniqueValue(), 0, this);
    }

    public int getNextBytes(Appendable appendable) {
        return (int)InvokeDynamicSupport.bootstrap("getNextBytes", $$robo$$android_icu_util_BytesTrie$getNextBytes(java.lang.Appendable ), 0, this, appendable);
    }

    public Iterator iterator() {
        return InvokeDynamicSupport.bootstrap("iterator", $$robo$$android_icu_util_BytesTrie$iterator(), 0, this);
    }

    public Iterator iterator(int n) {
        return InvokeDynamicSupport.bootstrap("iterator", $$robo$$android_icu_util_BytesTrie$iterator(int ), 0, this, n);
    }

    public static Iterator iterator(byte[] byArray, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("iterator", $$robo$$android_icu_util_BytesTrie$iterator(byte[] int int ), 0, (byte[])byArray, (int)n, (int)n2);
    }

    private void stop() {
        InvokeDynamicSupport.bootstrap("stop", $$robo$$android_icu_util_BytesTrie$stop(), 0, this);
    }

    private static int readValue(byte[] byArray, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("readValue", $$robo$$android_icu_util_BytesTrie$readValue(byte[] int int ), 0, (byte[])byArray, (int)n, (int)n2);
    }

    private static int skipValue(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("skipValue", $$robo$$android_icu_util_BytesTrie$skipValue(int int ), 0, (int)n, (int)n2);
    }

    private static int skipValue(byte[] byArray, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("skipValue", $$robo$$android_icu_util_BytesTrie$skipValue(byte[] int ), 0, (byte[])byArray, (int)n);
    }

    private static int jumpByDelta(byte[] byArray, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("jumpByDelta", $$robo$$android_icu_util_BytesTrie$jumpByDelta(byte[] int ), 0, (byte[])byArray, (int)n);
    }

    private static int skipDelta(byte[] byArray, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("skipDelta", $$robo$$android_icu_util_BytesTrie$skipDelta(byte[] int ), 0, (byte[])byArray, (int)n);
    }

    private Result branchNext(int n, int n2, int n3) {
        return InvokeDynamicSupport.bootstrap("branchNext", $$robo$$android_icu_util_BytesTrie$branchNext(int int int ), 0, this, n, n2, n3);
    }

    private Result nextImpl(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("nextImpl", $$robo$$android_icu_util_BytesTrie$nextImpl(int int ), 0, this, n, n2);
    }

    private static long findUniqueValueFromBranch(byte[] byArray, int n, int n2, long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("findUniqueValueFromBranch", $$robo$$android_icu_util_BytesTrie$findUniqueValueFromBranch(byte[] int int long ), 0, (byte[])byArray, (int)n, (int)n2, (long)l);
    }

    private static long findUniqueValue(byte[] byArray, int n, long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("findUniqueValue", $$robo$$android_icu_util_BytesTrie$findUniqueValue(byte[] int long ), 0, (byte[])byArray, (int)n, (long)l);
    }

    private static void getNextBranchBytes(byte[] byArray, int n, int n2, Appendable appendable) {
        InvokeDynamicSupport.bootstrapStatic("getNextBranchBytes", $$robo$$android_icu_util_BytesTrie$getNextBranchBytes(byte[] int int java.lang.Appendable ), 0, (byte[])byArray, (int)n, (int)n2, (Appendable)appendable);
    }

    private static void append(Appendable appendable, int n) {
        InvokeDynamicSupport.bootstrapStatic("append", $$robo$$android_icu_util_BytesTrie$append(java.lang.Appendable int ), 0, (Appendable)appendable, (int)n);
    }

    static {
        RobolectricInternals.classInitializing(BytesTrie.class);
    }

    public /* synthetic */ BytesTrie() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BytesTrie)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Iterator
    implements java.util.Iterator<Entry> {
        public transient /* synthetic */ Object __robo_data__;
        private byte[] bytes_;
        private int pos_;
        private int initialPos_;
        private int remainingMatchLength_;
        private int initialRemainingMatchLength_;
        private int maxLength_;
        private Entry entry_;
        private ArrayList<Long> stack_;

        private void $$robo$$android_icu_util_BytesTrie_Iterator$__constructor__(byte[] trieBytes, int offset, int remainingMatchLength, int maxStringLength) {
            this.stack_ = new ArrayList();
            this.bytes_ = trieBytes;
            this.pos_ = this.initialPos_ = offset;
            this.remainingMatchLength_ = this.initialRemainingMatchLength_ = remainingMatchLength;
            this.maxLength_ = maxStringLength;
            this.entry_ = new Entry(this.maxLength_ != 0 ? this.maxLength_ : 32);
            int length = this.remainingMatchLength_;
            if (length >= 0) {
                if (this.maxLength_ > 0 && ++length > this.maxLength_) {
                    length = this.maxLength_;
                }
                this.entry_.append(this.bytes_, this.pos_, length);
                this.pos_ += length;
                this.remainingMatchLength_ -= length;
            }
        }

        private final Iterator $$robo$$android_icu_util_BytesTrie_Iterator$reset() {
            this.pos_ = this.initialPos_;
            this.remainingMatchLength_ = this.initialRemainingMatchLength_;
            int length = this.remainingMatchLength_ + 1;
            if (this.maxLength_ > 0 && length > this.maxLength_) {
                length = this.maxLength_;
            }
            this.entry_.truncateString(length);
            this.pos_ += length;
            this.remainingMatchLength_ -= length;
            this.stack_.clear();
            return this;
        }

        private final boolean $$robo$$android_icu_util_BytesTrie_Iterator$hasNext() {
            return this.pos_ >= 0 || !this.stack_.isEmpty();
        }

        private final Entry $$robo$$android_icu_util_BytesTrie_Iterator$next() {
            int pos = this.pos_;
            if (pos < 0) {
                if (this.stack_.isEmpty()) {
                    throw new NoSuchElementException();
                }
                long top = this.stack_.remove(this.stack_.size() - 1);
                int length = (int)top;
                pos = (int)(top >> 32);
                this.entry_.truncateString(length & 0xFFFF);
                if ((length >>>= 16) > 1) {
                    if ((pos = this.branchNext(pos, length)) < 0) {
                        return this.entry_;
                    }
                } else {
                    this.entry_.append(this.bytes_[pos++]);
                }
            }
            if (this.remainingMatchLength_ >= 0) {
                return this.truncateAndStop();
            }
            while (true) {
                int node;
                if ((node = this.bytes_[pos++] & 0xFF) >= 32) {
                    boolean isFinal = (node & 1) != 0;
                    this.entry_.value = BytesTrie.readValue(this.bytes_, pos, node >> 1);
                    this.pos_ = isFinal || this.maxLength_ > 0 && this.entry_.length == this.maxLength_ ? -1 : BytesTrie.skipValue(pos, node);
                    return this.entry_;
                }
                if (this.maxLength_ > 0 && this.entry_.length == this.maxLength_) {
                    return this.truncateAndStop();
                }
                if (node < 16) {
                    if (node == 0) {
                        node = this.bytes_[pos++] & 0xFF;
                    }
                    if ((pos = this.branchNext(pos, node + 1)) >= 0) continue;
                    return this.entry_;
                }
                int length = node - 16 + 1;
                if (this.maxLength_ > 0 && this.entry_.length + length > this.maxLength_) {
                    this.entry_.append(this.bytes_, pos, this.maxLength_ - this.entry_.length);
                    return this.truncateAndStop();
                }
                this.entry_.append(this.bytes_, pos, length);
                pos += length;
            }
        }

        private final void $$robo$$android_icu_util_BytesTrie_Iterator$remove() {
            throw new UnsupportedOperationException();
        }

        private final Entry $$robo$$android_icu_util_BytesTrie_Iterator$truncateAndStop() {
            this.pos_ = -1;
            this.entry_.value = -1;
            return this.entry_;
        }

        private final int $$robo$$android_icu_util_BytesTrie_Iterator$branchNext(int pos, int length) {
            int node;
            while (length > 5) {
                this.stack_.add((long)BytesTrie.skipDelta(this.bytes_, ++pos) << 32 | (long)(length - (length >> 1) << 16) | (long)this.entry_.length);
                length >>= 1;
                pos = BytesTrie.jumpByDelta(this.bytes_, pos);
            }
            byte trieByte = this.bytes_[pos++];
            boolean isFinal = ((node = this.bytes_[pos++] & 0xFF) & 1) != 0;
            int value = BytesTrie.readValue(this.bytes_, pos, node >> 1);
            pos = BytesTrie.skipValue(pos, node);
            this.stack_.add((long)pos << 32 | (long)(length - 1 << 16) | (long)this.entry_.length);
            this.entry_.append(trieByte);
            if (isFinal) {
                this.pos_ = -1;
                this.entry_.value = value;
                return -1;
            }
            return pos + value;
        }

        private /* synthetic */ void $$robo$$android_icu_util_BytesTrie_Iterator$__constructor__(byte[] x0, int x1, int x2, int x3, 1 x4) {
        }

        private void __constructor__(byte[] byArray, int n, int n2, int n3) {
            this.$$robo$$android_icu_util_BytesTrie_Iterator$__constructor__(byArray, n, n2, n3);
        }

        private Iterator(byte[] byArray, int n, int n2, int n3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_BytesTrie_Iterator$__constructor__(byte[] int int int ), 0, this, byArray, n, n2, n3);
        }

        public Iterator reset() {
            return InvokeDynamicSupport.bootstrap("reset", $$robo$$android_icu_util_BytesTrie_Iterator$reset(), 0, this);
        }

        @Override
        public boolean hasNext() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasNext", $$robo$$android_icu_util_BytesTrie_Iterator$hasNext(), 0, this);
        }

        @Override
        public Entry next() {
            return InvokeDynamicSupport.bootstrap("next", $$robo$$android_icu_util_BytesTrie_Iterator$next(), 0, this);
        }

        @Override
        public void remove() {
            InvokeDynamicSupport.bootstrap("remove", $$robo$$android_icu_util_BytesTrie_Iterator$remove(), 0, this);
        }

        private Entry truncateAndStop() {
            return InvokeDynamicSupport.bootstrap("truncateAndStop", $$robo$$android_icu_util_BytesTrie_Iterator$truncateAndStop(), 0, this);
        }

        private int branchNext(int n, int n2) {
            return (int)InvokeDynamicSupport.bootstrap("branchNext", $$robo$$android_icu_util_BytesTrie_Iterator$branchNext(int int ), 0, this, n, n2);
        }

        private /* synthetic */ void __constructor__(byte[] byArray, int n, int n2, int n3, 1 var5_5) {
            this.$$robo$$android_icu_util_BytesTrie_Iterator$__constructor__(byArray, n, n2, n3, var5_5);
        }

        public /* synthetic */ Iterator() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Iterator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Entry
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int value;
        private byte[] bytes;
        private int length;

        private void $$robo$$android_icu_util_BytesTrie_Entry$__constructor__(int capacity) {
            this.bytes = new byte[capacity];
        }

        private final int $$robo$$android_icu_util_BytesTrie_Entry$bytesLength() {
            return this.length;
        }

        private final byte $$robo$$android_icu_util_BytesTrie_Entry$byteAt(int index) {
            return this.bytes[index];
        }

        private final void $$robo$$android_icu_util_BytesTrie_Entry$copyBytesTo(byte[] dest, int destOffset) {
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])this.bytes, (int)0, (byte[])dest, (int)destOffset, (int)this.length);
        }

        private final ByteBuffer $$robo$$android_icu_util_BytesTrie_Entry$bytesAsByteBuffer() {
            return ByteBuffer.wrap(this.bytes, 0, this.length).asReadOnlyBuffer();
        }

        private final void $$robo$$android_icu_util_BytesTrie_Entry$ensureCapacity(int len) {
            if (this.bytes.length < len) {
                byte[] newBytes = new byte[Math.min(2 * this.bytes.length, 2 * len)];
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])this.bytes, (int)0, (byte[])newBytes, (int)0, (int)this.length);
                this.bytes = newBytes;
            }
        }

        private final void $$robo$$android_icu_util_BytesTrie_Entry$append(byte b) {
            this.ensureCapacity(this.length + 1);
            this.bytes[this.length++] = b;
        }

        private final void $$robo$$android_icu_util_BytesTrie_Entry$append(byte[] b, int off, int len) {
            this.ensureCapacity(this.length + len);
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])b, (int)off, (byte[])this.bytes, (int)this.length, (int)len);
            this.length += len;
        }

        private final void $$robo$$android_icu_util_BytesTrie_Entry$truncateString(int newLength) {
            this.length = newLength;
        }

        private /* synthetic */ void $$robo$$android_icu_util_BytesTrie_Entry$__constructor__(int x0, 1 x1) {
        }

        private void __constructor__(int n) {
            this.$$robo$$android_icu_util_BytesTrie_Entry$__constructor__(n);
        }

        private Entry(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_BytesTrie_Entry$__constructor__(int ), 0, this, n);
        }

        public int bytesLength() {
            return (int)InvokeDynamicSupport.bootstrap("bytesLength", $$robo$$android_icu_util_BytesTrie_Entry$bytesLength(), 0, this);
        }

        public byte byteAt(int n) {
            return (byte)InvokeDynamicSupport.bootstrap("byteAt", $$robo$$android_icu_util_BytesTrie_Entry$byteAt(int ), 0, this, n);
        }

        public void copyBytesTo(byte[] byArray, int n) {
            InvokeDynamicSupport.bootstrap("copyBytesTo", $$robo$$android_icu_util_BytesTrie_Entry$copyBytesTo(byte[] int ), 0, this, byArray, n);
        }

        public ByteBuffer bytesAsByteBuffer() {
            return InvokeDynamicSupport.bootstrap("bytesAsByteBuffer", $$robo$$android_icu_util_BytesTrie_Entry$bytesAsByteBuffer(), 0, this);
        }

        private void ensureCapacity(int n) {
            InvokeDynamicSupport.bootstrap("ensureCapacity", $$robo$$android_icu_util_BytesTrie_Entry$ensureCapacity(int ), 0, this, n);
        }

        private void append(byte by) {
            InvokeDynamicSupport.bootstrap("append", $$robo$$android_icu_util_BytesTrie_Entry$append(byte ), 0, this, by);
        }

        private void append(byte[] byArray, int n, int n2) {
            InvokeDynamicSupport.bootstrap("append", $$robo$$android_icu_util_BytesTrie_Entry$append(byte[] int int ), 0, this, byArray, n, n2);
        }

        private void truncateString(int n) {
            InvokeDynamicSupport.bootstrap("truncateString", $$robo$$android_icu_util_BytesTrie_Entry$truncateString(int ), 0, this, n);
        }

        private /* synthetic */ void __constructor__(int n, 1 var2_2) {
            this.$$robo$$android_icu_util_BytesTrie_Entry$__constructor__(n, var2_2);
        }

        public /* synthetic */ Entry() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Entry)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Result
    extends Enum<Result> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ Result NO_MATCH;
        public static /* enum */ Result NO_VALUE;
        public static /* enum */ Result FINAL_VALUE;
        public static /* enum */ Result INTERMEDIATE_VALUE;
        private static /* synthetic */ Result[] $VALUES;

        private static final Result[] $$robo$$android_icu_util_BytesTrie_Result$values() {
            return (Result[])$VALUES.clone();
        }

        private static final Result $$robo$$android_icu_util_BytesTrie_Result$valueOf(String name) {
            return Enum.valueOf(Result.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_util_BytesTrie_Result$__constructor__(String string2, int n) {
        }

        private final boolean $$robo$$android_icu_util_BytesTrie_Result$matches() {
            return this != NO_MATCH;
        }

        private final boolean $$robo$$android_icu_util_BytesTrie_Result$hasValue() {
            return this.ordinal() >= 2;
        }

        private final boolean $$robo$$android_icu_util_BytesTrie_Result$hasNext() {
            return (this.ordinal() & 1) != 0;
        }

        static void __staticInitializer__() {
            NO_MATCH = new Result();
            NO_VALUE = new Result();
            FINAL_VALUE = new Result();
            INTERMEDIATE_VALUE = new Result();
            $VALUES = new Result[]{NO_MATCH, NO_VALUE, FINAL_VALUE, INTERMEDIATE_VALUE};
        }

        public static Result[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_util_BytesTrie_Result$values(), 0);
        }

        public static Result valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_util_BytesTrie_Result$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_util_BytesTrie_Result$__constructor__(string2, n);
        }

        private Result() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_BytesTrie_Result$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        public boolean matches() {
            return (boolean)InvokeDynamicSupport.bootstrap("matches", $$robo$$android_icu_util_BytesTrie_Result$matches(), 0, this);
        }

        public boolean hasValue() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasValue", $$robo$$android_icu_util_BytesTrie_Result$hasValue(), 0, this);
        }

        public boolean hasNext() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasNext", $$robo$$android_icu_util_BytesTrie_Result$hasNext(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(Result.class);
        }

        public /* synthetic */ Result() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Result)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class State
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private byte[] bytes;
        private int root;
        private int pos;
        private int remainingMatchLength;

        private void $$robo$$android_icu_util_BytesTrie_State$__constructor__() {
        }

        static /* synthetic */ byte[] access$002(State x0, byte[] x1) {
            x0.bytes = x1;
            return x1;
        }

        private void __constructor__() {
            this.$$robo$$android_icu_util_BytesTrie_State$__constructor__();
        }

        public State() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_BytesTrie_State$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (State)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

