/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.impl.ICUResourceBundle;
import android.icu.impl.Utility;
import android.icu.text.AnyTransliterator;
import android.icu.text.BreakTransliterator;
import android.icu.text.CaseFoldTransliterator;
import android.icu.text.CompoundTransliterator;
import android.icu.text.EscapeTransliterator;
import android.icu.text.LowercaseTransliterator;
import android.icu.text.NameUnicodeTransliterator;
import android.icu.text.NormalizationTransliterator;
import android.icu.text.NullTransliterator;
import android.icu.text.RemoveTransliterator;
import android.icu.text.Replaceable;
import android.icu.text.ReplaceableString;
import android.icu.text.RuleBasedTransliterator;
import android.icu.text.StringTransform;
import android.icu.text.TitlecaseTransliterator;
import android.icu.text.TransliteratorIDParser;
import android.icu.text.TransliteratorParser;
import android.icu.text.TransliteratorRegistry;
import android.icu.text.UTF16;
import android.icu.text.UnescapeTransliterator;
import android.icu.text.UnicodeFilter;
import android.icu.text.UnicodeNameTransliterator;
import android.icu.text.UnicodeSet;
import android.icu.text.UppercaseTransliterator;
import android.icu.util.CaseInsensitiveString;
import android.icu.util.ULocale;
import android.icu.util.UResourceBundle;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class Transliterator
implements StringTransform,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int FORWARD = 0;
    public static int REVERSE = 1;
    private String ID;
    private UnicodeSet filter;
    private int maximumContextLength;
    private static TransliteratorRegistry registry;
    private static Map<CaseInsensitiveString, String> displayNameCache;
    private static String RB_DISPLAY_NAME_PREFIX = "%Translit%%";
    private static String RB_SCRIPT_DISPLAY_NAME_PREFIX = "%Translit%";
    private static String RB_DISPLAY_NAME_PATTERN = "TransliteratorNamePattern";
    static char ID_DELIM = ';';
    static char ID_SEP = '-';
    static char VARIANT_SEP = '/';
    static boolean DEBUG = false;
    private static String ROOT = "root";
    private static String RB_RULE_BASED_IDS = "RuleBasedTransliteratorIDs";

    private void $$robo$$android_icu_text_Transliterator$__constructor__(String ID, UnicodeFilter filter) {
        this.maximumContextLength = 0;
        if (ID == null) {
            throw new NullPointerException();
        }
        this.ID = ID;
        this.setFilter(filter);
    }

    private final int $$robo$$android_icu_text_Transliterator$transliterate(Replaceable text, int start, int limit) {
        if (start < 0 || limit < start || text.length() < limit) {
            return -1;
        }
        Position pos = new Position(start, limit, start);
        this.filteredTransliterate(text, pos, false, true);
        return pos.limit;
    }

    private final void $$robo$$android_icu_text_Transliterator$transliterate(Replaceable text) {
        this.transliterate(text, 0, text.length());
    }

    private final String $$robo$$android_icu_text_Transliterator$transliterate(String text) {
        ReplaceableString result = new ReplaceableString(text);
        this.transliterate(result);
        return result.toString();
    }

    private final void $$robo$$android_icu_text_Transliterator$transliterate(Replaceable text, Position index, String insertion) {
        index.validate(text.length());
        if (insertion != null) {
            text.replace(index.limit, index.limit, insertion);
            index.limit += insertion.length();
            index.contextLimit += insertion.length();
        }
        if (index.limit > 0 && UTF16.isLeadSurrogate(text.charAt(index.limit - 1))) {
            return;
        }
        this.filteredTransliterate(text, index, true, true);
    }

    private final void $$robo$$android_icu_text_Transliterator$transliterate(Replaceable text, Position index, int insertion) {
        this.transliterate(text, index, UTF16.valueOf(insertion));
    }

    private final void $$robo$$android_icu_text_Transliterator$transliterate(Replaceable text, Position index) {
        this.transliterate(text, index, null);
    }

    private final void $$robo$$android_icu_text_Transliterator$finishTransliteration(Replaceable text, Position index) {
        index.validate(text.length());
        this.filteredTransliterate(text, index, false, true);
    }

    protected abstract void handleTransliterate(Replaceable var1, Position var2, boolean var3);

    private final void $$robo$$android_icu_text_Transliterator$filteredTransliterate(Replaceable text, Position index, boolean incremental, boolean rollback) {
        boolean isIncrementalRun;
        if (this.filter == null && !rollback) {
            this.handleTransliterate(text, index, incremental);
            return;
        }
        int globalLimit = index.limit;
        Object log = null;
        do {
            int delta;
            if (this.filter != null) {
                int c;
                while (index.start < globalLimit && !this.filter.contains(c = text.char32At(index.start))) {
                    index.start += UTF16.getCharCount(c);
                }
                index.limit = index.start;
                while (index.limit < globalLimit && this.filter.contains(c = text.char32At(index.limit))) {
                    index.limit += UTF16.getCharCount(c);
                }
            }
            if (index.start == index.limit) break;
            boolean bl = isIncrementalRun = index.limit < globalLimit ? false : incremental;
            if (rollback && isIncrementalRun) {
                int charLength;
                int runStart = index.start;
                int runLimit = index.limit;
                int runLength = runLimit - runStart;
                int rollbackOrigin = text.length();
                text.copy(runStart, runLimit, rollbackOrigin);
                int passStart = runStart;
                int rollbackStart = rollbackOrigin;
                int passLimit = index.start;
                int uncommittedLength = 0;
                int totalDelta = 0;
                while ((passLimit += (charLength = UTF16.getCharCount(text.char32At(passLimit)))) <= runLimit) {
                    uncommittedLength += charLength;
                    index.limit = passLimit;
                    this.handleTransliterate(text, index, true);
                    delta = index.limit - passLimit;
                    if (index.start != index.limit) {
                        int rs = rollbackStart + delta - (index.limit - passStart);
                        text.replace(passStart, index.limit, "");
                        text.copy(rs, rs + uncommittedLength, passStart);
                        index.start = passStart;
                        index.limit = passLimit;
                        index.contextLimit -= delta;
                        continue;
                    }
                    passStart = passLimit = index.start;
                    rollbackStart += delta + uncommittedLength;
                    uncommittedLength = 0;
                    runLimit += delta;
                    totalDelta += delta;
                }
                globalLimit += totalDelta;
                text.replace(rollbackOrigin += totalDelta, rollbackOrigin + runLength, "");
                index.start = passStart;
                continue;
            }
            int limit = index.limit;
            this.handleTransliterate(text, index, isIncrementalRun);
            delta = index.limit - limit;
            if (!isIncrementalRun && index.start != index.limit) {
                throw new RuntimeException("ERROR: Incomplete non-incremental transliteration by " + this.getID());
            }
            globalLimit += delta;
        } while (this.filter != null && !isIncrementalRun);
        index.limit = globalLimit;
    }

    private final void $$robo$$android_icu_text_Transliterator$filteredTransliterate(Replaceable text, Position index, boolean incremental) {
        this.filteredTransliterate(text, index, incremental, false);
    }

    private final int $$robo$$android_icu_text_Transliterator$getMaximumContextLength() {
        return this.maximumContextLength;
    }

    private final void $$robo$$android_icu_text_Transliterator$setMaximumContextLength(int a) {
        if (a < 0) {
            throw new IllegalArgumentException("Invalid context length " + a);
        }
        this.maximumContextLength = a;
    }

    private final String $$robo$$android_icu_text_Transliterator$getID() {
        return this.ID;
    }

    private final void $$robo$$android_icu_text_Transliterator$setID(String id2) {
        this.ID = id2;
    }

    private static final String $$robo$$android_icu_text_Transliterator$getDisplayName(String ID) {
        return Transliterator.getDisplayName(ID, ULocale.getDefault(ULocale.Category.DISPLAY));
    }

    private static final String $$robo$$android_icu_text_Transliterator$getDisplayName(String id2, Locale inLocale) {
        return Transliterator.getDisplayName(id2, ULocale.forLocale(inLocale));
    }

    private static final String $$robo$$android_icu_text_Transliterator$getDisplayName(String id2, ULocale inLocale) {
        String n;
        ICUResourceBundle bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("android/icu/impl/data/icudt56b/translit", inLocale);
        String[] stv = TransliteratorIDParser.IDtoSTV(id2);
        if (stv == null) {
            return "";
        }
        String ID = stv[0] + '-' + stv[1];
        if (stv[2] != null && stv[2].length() > 0) {
            ID = ID + '/' + stv[2];
        }
        if ((n = displayNameCache.get(new CaseInsensitiveString(ID))) != null) {
            return n;
        }
        try {
            return bundle.getString("%Translit%%" + ID);
        }
        catch (MissingResourceException missingResourceException) {
            try {
                MessageFormat format = new MessageFormat(bundle.getString("TransliteratorNamePattern"));
                Object[] args = new Object[]{2, stv[0], stv[1]};
                for (int j = 1; j <= 2; ++j) {
                    try {
                        args[j] = bundle.getString("%Translit%" + (String)args[j]);
                        continue;
                    }
                    catch (MissingResourceException missingResourceException2) {
                        // empty catch block
                    }
                }
                return stv[2].length() > 0 ? format.format(args) + '/' + stv[2] : format.format(args);
            }
            catch (MissingResourceException missingResourceException3) {
                throw new RuntimeException();
            }
        }
    }

    private final UnicodeFilter $$robo$$android_icu_text_Transliterator$getFilter() {
        return this.filter;
    }

    private final void $$robo$$android_icu_text_Transliterator$setFilter(UnicodeFilter filter) {
        if (filter == null) {
            this.filter = null;
        } else {
            try {
                this.filter = new UnicodeSet((UnicodeSet)filter).freeze();
            }
            catch (Exception e) {
                this.filter = new UnicodeSet();
                filter.addMatchSetTo(this.filter);
                this.filter.freeze();
            }
        }
    }

    private static final Transliterator $$robo$$android_icu_text_Transliterator$getInstance(String ID) {
        return Transliterator.getInstance(ID, 0);
    }

    private static final Transliterator $$robo$$android_icu_text_Transliterator$getInstance(String ID, int dir) {
        StringBuffer canonID = new StringBuffer();
        ArrayList<TransliteratorIDParser.SingleID> list = new ArrayList<TransliteratorIDParser.SingleID>();
        UnicodeSet[] globalFilter = new UnicodeSet[1];
        if (!TransliteratorIDParser.parseCompoundID(ID, dir, canonID, list, globalFilter)) {
            throw new IllegalArgumentException("Invalid ID " + ID);
        }
        List<Transliterator> translits = TransliteratorIDParser.instantiateList(list);
        Transliterator t = null;
        t = list.size() > 1 || canonID.indexOf(";") >= 0 ? new CompoundTransliterator(translits) : translits.get(0);
        t.setID(canonID.toString());
        if (globalFilter[0] != null) {
            t.setFilter(globalFilter[0]);
        }
        return t;
    }

    private static final Transliterator $$robo$$android_icu_text_Transliterator$getBasicInstance(String id2, String canonID) {
        StringBuffer s = new StringBuffer();
        Transliterator t = registry.get(id2, s);
        if (s.length() != 0) {
            t = Transliterator.getInstance(s.toString(), 0);
        }
        if (t != null && canonID != null) {
            t.setID(canonID);
        }
        return t;
    }

    private static final Transliterator $$robo$$android_icu_text_Transliterator$createFromRules(String ID, String rules, int dir) {
        Transliterator t = null;
        TransliteratorParser parser = new TransliteratorParser();
        parser.parse(rules, dir);
        if (parser.idBlockVector.size() == 0 && parser.dataVector.size() == 0) {
            t = new NullTransliterator();
        } else if (parser.idBlockVector.size() == 0 && parser.dataVector.size() == 1) {
            t = new RuleBasedTransliterator(ID, parser.dataVector.get(0), parser.compoundFilter);
        } else if (parser.idBlockVector.size() == 1 && parser.dataVector.size() == 0) {
            t = parser.compoundFilter != null ? Transliterator.getInstance(parser.compoundFilter.toPattern(false) + ";" + parser.idBlockVector.get(0)) : Transliterator.getInstance(parser.idBlockVector.get(0));
            if (t != null) {
                t.setID(ID);
            }
        } else {
            ArrayList<Transliterator> transliterators = new ArrayList<Transliterator>();
            int passNumber = 1;
            int limit = Math.max(parser.idBlockVector.size(), parser.dataVector.size());
            for (int i = 0; i < limit; ++i) {
                Transliterator temp;
                String idBlock;
                if (i < parser.idBlockVector.size() && (idBlock = parser.idBlockVector.get(i)).length() > 0 && !((temp = Transliterator.getInstance(idBlock)) instanceof NullTransliterator)) {
                    transliterators.add(Transliterator.getInstance(idBlock));
                }
                if (i >= parser.dataVector.size()) continue;
                RuleBasedTransliterator.Data data = parser.dataVector.get(i);
                transliterators.add(new RuleBasedTransliterator("%Pass" + passNumber++, data, null));
            }
            t = new CompoundTransliterator(transliterators, passNumber - 1);
            t.setID(ID);
            if (parser.compoundFilter != null) {
                t.setFilter(parser.compoundFilter);
            }
        }
        return t;
    }

    private final String $$robo$$android_icu_text_Transliterator$toRules(boolean escapeUnprintable) {
        return this.baseToRules(escapeUnprintable);
    }

    private final String $$robo$$android_icu_text_Transliterator$baseToRules(boolean escapeUnprintable) {
        if (escapeUnprintable) {
            int c;
            StringBuffer rulesSource = new StringBuffer();
            String id2 = this.getID();
            for (int i = 0; i < id2.length(); i += UTF16.getCharCount(c)) {
                c = UTF16.charAt(id2, i);
                if (Utility.escapeUnprintable(rulesSource, c)) continue;
                UTF16.append(rulesSource, c);
            }
            rulesSource.insert(0, "::");
            rulesSource.append(';');
            return rulesSource.toString();
        }
        return "::" + this.getID() + ';';
    }

    private final Transliterator[] $$robo$$android_icu_text_Transliterator$getElements() {
        Transliterator[] result;
        if (this instanceof CompoundTransliterator) {
            CompoundTransliterator cpd = (CompoundTransliterator)this;
            result = new Transliterator[cpd.getCount()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = cpd.getTransliterator(i);
            }
        } else {
            result = new Transliterator[]{this};
        }
        return result;
    }

    private final UnicodeSet $$robo$$android_icu_text_Transliterator$getSourceSet() {
        UnicodeSet result = new UnicodeSet();
        this.addSourceTargetSet(this.getFilterAsUnicodeSet(UnicodeSet.ALL_CODE_POINTS), result, new UnicodeSet());
        return result;
    }

    private final UnicodeSet $$robo$$android_icu_text_Transliterator$handleGetSourceSet() {
        return new UnicodeSet();
    }

    private final UnicodeSet $$robo$$android_icu_text_Transliterator$getTargetSet() {
        UnicodeSet result = new UnicodeSet();
        this.addSourceTargetSet(this.getFilterAsUnicodeSet(UnicodeSet.ALL_CODE_POINTS), new UnicodeSet(), result);
        return result;
    }

    @Deprecated
    private final void $$robo$$android_icu_text_Transliterator$addSourceTargetSet(UnicodeSet inputFilter, UnicodeSet sourceSet, UnicodeSet targetSet) {
        UnicodeSet myFilter = this.getFilterAsUnicodeSet(inputFilter);
        UnicodeSet temp = new UnicodeSet(this.handleGetSourceSet()).retainAll(myFilter);
        sourceSet.addAll(temp);
        for (String s : temp) {
            String t;
            if (s.equals(t = this.transliterate(s))) continue;
            targetSet.addAll(t);
        }
    }

    @Deprecated
    private final UnicodeSet $$robo$$android_icu_text_Transliterator$getFilterAsUnicodeSet(UnicodeSet externalFilter) {
        UnicodeSet temp;
        if (this.filter == null) {
            return externalFilter;
        }
        UnicodeSet filterSet = new UnicodeSet(externalFilter);
        try {
            temp = this.filter;
        }
        catch (ClassCastException e) {
            temp = new UnicodeSet();
            this.filter.addMatchSetTo(temp);
        }
        return filterSet.retainAll(temp).freeze();
    }

    private final Transliterator $$robo$$android_icu_text_Transliterator$getInverse() {
        return Transliterator.getInstance(this.ID, 1);
    }

    private static final void $$robo$$android_icu_text_Transliterator$registerClass(String ID, Class<? extends Transliterator> transClass, String displayName) {
        registry.put(ID, transClass, true);
        if (displayName != null) {
            displayNameCache.put(new CaseInsensitiveString(ID), displayName);
        }
    }

    private static final void $$robo$$android_icu_text_Transliterator$registerFactory(String ID, Factory factory) {
        registry.put(ID, factory, true);
    }

    private static final void $$robo$$android_icu_text_Transliterator$registerInstance(Transliterator trans) {
        registry.put(trans.getID(), trans, true);
    }

    private static final void $$robo$$android_icu_text_Transliterator$registerInstance(Transliterator trans, boolean visible) {
        registry.put(trans.getID(), trans, visible);
    }

    private static final void $$robo$$android_icu_text_Transliterator$registerAlias(String aliasID, String realID) {
        registry.put(aliasID, realID, true);
    }

    private static final void $$robo$$android_icu_text_Transliterator$registerSpecialInverse(String target, String inverseTarget, boolean bidirectional) {
        TransliteratorIDParser.registerSpecialInverse(target, inverseTarget, bidirectional);
    }

    private static final void $$robo$$android_icu_text_Transliterator$unregister(String ID) {
        displayNameCache.remove(new CaseInsensitiveString(ID));
        registry.remove(ID);
    }

    private static final Enumeration<String> $$robo$$android_icu_text_Transliterator$getAvailableIDs() {
        return registry.getAvailableIDs();
    }

    private static final Enumeration<String> $$robo$$android_icu_text_Transliterator$getAvailableSources() {
        return registry.getAvailableSources();
    }

    private static final Enumeration<String> $$robo$$android_icu_text_Transliterator$getAvailableTargets(String source) {
        return registry.getAvailableTargets(source);
    }

    private static final Enumeration<String> $$robo$$android_icu_text_Transliterator$getAvailableVariants(String source, String target) {
        return registry.getAvailableVariants(source, target);
    }

    @Deprecated
    private static final void $$robo$$android_icu_text_Transliterator$registerAny() {
        AnyTransliterator.register();
    }

    private final String $$robo$$android_icu_text_Transliterator$transform(String source) {
        return this.transliterate(source);
    }

    static void __staticInitializer__() {
        registry = new TransliteratorRegistry();
        displayNameCache = Collections.synchronizedMap(new HashMap());
        UResourceBundle bundle = UResourceBundle.getBundleInstance("android/icu/impl/data/icudt56b/translit", "root");
        UResourceBundle transIDs = bundle.get("RuleBasedTransliteratorIDs");
        int maxRows = transIDs.getSize();
        for (int row = 0; row < maxRows; ++row) {
            String resString;
            UResourceBundle colBund = transIDs.get(row);
            String ID = colBund.getKey();
            UResourceBundle res = colBund.get(0);
            String type = res.getKey();
            if (type.equals("file") || type.equals("internal")) {
                int dir;
                resString = res.getString("resource");
                String direction = res.getString("direction");
                switch (direction.charAt(0)) {
                    case 'F': {
                        dir = 0;
                        break;
                    }
                    case 'R': {
                        dir = 1;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Can't parse direction: " + direction);
                    }
                }
                registry.put(ID, resString, "UTF-16", dir, !type.equals("internal"));
                continue;
            }
            if (type.equals("alias")) {
                resString = res.getString();
                registry.put(ID, resString, true);
                continue;
            }
            throw new RuntimeException("Unknow type: " + type);
        }
        Transliterator.registerSpecialInverse(NullTransliterator.SHORT_ID, NullTransliterator.SHORT_ID, false);
        Transliterator.registerClass(NullTransliterator._ID, NullTransliterator.class, null);
        RemoveTransliterator.register();
        EscapeTransliterator.register();
        UnescapeTransliterator.register();
        LowercaseTransliterator.register();
        UppercaseTransliterator.register();
        TitlecaseTransliterator.register();
        CaseFoldTransliterator.register();
        UnicodeNameTransliterator.register();
        NameUnicodeTransliterator.register();
        NormalizationTransliterator.register();
        BreakTransliterator.register();
        AnyTransliterator.register();
    }

    private void __constructor__(String string2, UnicodeFilter unicodeFilter) {
        this.$$robo$$android_icu_text_Transliterator$__constructor__(string2, unicodeFilter);
    }

    protected Transliterator(String string2, UnicodeFilter unicodeFilter) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_Transliterator$__constructor__(java.lang.String android.icu.text.UnicodeFilter ), 0, this, string2, unicodeFilter);
    }

    public int transliterate(Replaceable replaceable, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("transliterate", $$robo$$android_icu_text_Transliterator$transliterate(android.icu.text.Replaceable int int ), 0, this, replaceable, n, n2);
    }

    public void transliterate(Replaceable replaceable) {
        InvokeDynamicSupport.bootstrap("transliterate", $$robo$$android_icu_text_Transliterator$transliterate(android.icu.text.Replaceable ), 0, this, replaceable);
    }

    public String transliterate(String string2) {
        return InvokeDynamicSupport.bootstrap("transliterate", $$robo$$android_icu_text_Transliterator$transliterate(java.lang.String ), 0, this, string2);
    }

    public void transliterate(Replaceable replaceable, Position position, String string2) {
        InvokeDynamicSupport.bootstrap("transliterate", $$robo$$android_icu_text_Transliterator$transliterate(android.icu.text.Replaceable android.icu.text.Transliterator$Position java.lang.String ), 0, this, replaceable, position, string2);
    }

    public void transliterate(Replaceable replaceable, Position position, int n) {
        InvokeDynamicSupport.bootstrap("transliterate", $$robo$$android_icu_text_Transliterator$transliterate(android.icu.text.Replaceable android.icu.text.Transliterator$Position int ), 0, this, replaceable, position, n);
    }

    public void transliterate(Replaceable replaceable, Position position) {
        InvokeDynamicSupport.bootstrap("transliterate", $$robo$$android_icu_text_Transliterator$transliterate(android.icu.text.Replaceable android.icu.text.Transliterator$Position ), 0, this, replaceable, position);
    }

    public void finishTransliteration(Replaceable replaceable, Position position) {
        InvokeDynamicSupport.bootstrap("finishTransliteration", $$robo$$android_icu_text_Transliterator$finishTransliteration(android.icu.text.Replaceable android.icu.text.Transliterator$Position ), 0, this, replaceable, position);
    }

    private void filteredTransliterate(Replaceable replaceable, Position position, boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("filteredTransliterate", $$robo$$android_icu_text_Transliterator$filteredTransliterate(android.icu.text.Replaceable android.icu.text.Transliterator$Position boolean boolean ), 0, this, replaceable, position, bl, bl2);
    }

    public void filteredTransliterate(Replaceable replaceable, Position position, boolean bl) {
        InvokeDynamicSupport.bootstrap("filteredTransliterate", $$robo$$android_icu_text_Transliterator$filteredTransliterate(android.icu.text.Replaceable android.icu.text.Transliterator$Position boolean ), 0, this, replaceable, position, bl);
    }

    public int getMaximumContextLength() {
        return (int)InvokeDynamicSupport.bootstrap("getMaximumContextLength", $$robo$$android_icu_text_Transliterator$getMaximumContextLength(), 0, this);
    }

    protected void setMaximumContextLength(int n) {
        InvokeDynamicSupport.bootstrap("setMaximumContextLength", $$robo$$android_icu_text_Transliterator$setMaximumContextLength(int ), 0, this, n);
    }

    public String getID() {
        return InvokeDynamicSupport.bootstrap("getID", $$robo$$android_icu_text_Transliterator$getID(), 0, this);
    }

    protected void setID(String string2) {
        InvokeDynamicSupport.bootstrap("setID", $$robo$$android_icu_text_Transliterator$setID(java.lang.String ), 0, this, string2);
    }

    public static String getDisplayName(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayName", $$robo$$android_icu_text_Transliterator$getDisplayName(java.lang.String ), 0, (String)string2);
    }

    public static String getDisplayName(String string2, Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayName", $$robo$$android_icu_text_Transliterator$getDisplayName(java.lang.String java.util.Locale ), 0, (String)string2, (Locale)locale);
    }

    public static String getDisplayName(String string2, ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayName", $$robo$$android_icu_text_Transliterator$getDisplayName(java.lang.String android.icu.util.ULocale ), 0, (String)string2, (ULocale)uLocale);
    }

    public UnicodeFilter getFilter() {
        return InvokeDynamicSupport.bootstrap("getFilter", $$robo$$android_icu_text_Transliterator$getFilter(), 0, this);
    }

    public void setFilter(UnicodeFilter unicodeFilter) {
        InvokeDynamicSupport.bootstrap("setFilter", $$robo$$android_icu_text_Transliterator$setFilter(android.icu.text.UnicodeFilter ), 0, this, unicodeFilter);
    }

    public static Transliterator getInstance(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_Transliterator$getInstance(java.lang.String ), 0, (String)string2);
    }

    public static Transliterator getInstance(String string2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_Transliterator$getInstance(java.lang.String int ), 0, (String)string2, (int)n);
    }

    static Transliterator getBasicInstance(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("getBasicInstance", $$robo$$android_icu_text_Transliterator$getBasicInstance(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public static Transliterator createFromRules(String string2, String string3, int n) {
        return InvokeDynamicSupport.bootstrapStatic("createFromRules", $$robo$$android_icu_text_Transliterator$createFromRules(java.lang.String java.lang.String int ), 0, (String)string2, (String)string3, (int)n);
    }

    public String toRules(boolean bl) {
        return InvokeDynamicSupport.bootstrap("toRules", $$robo$$android_icu_text_Transliterator$toRules(boolean ), 0, this, bl);
    }

    protected String baseToRules(boolean bl) {
        return InvokeDynamicSupport.bootstrap("baseToRules", $$robo$$android_icu_text_Transliterator$baseToRules(boolean ), 0, this, bl);
    }

    public Transliterator[] getElements() {
        return InvokeDynamicSupport.bootstrap("getElements", $$robo$$android_icu_text_Transliterator$getElements(), 0, this);
    }

    public UnicodeSet getSourceSet() {
        return InvokeDynamicSupport.bootstrap("getSourceSet", $$robo$$android_icu_text_Transliterator$getSourceSet(), 0, this);
    }

    protected UnicodeSet handleGetSourceSet() {
        return InvokeDynamicSupport.bootstrap("handleGetSourceSet", $$robo$$android_icu_text_Transliterator$handleGetSourceSet(), 0, this);
    }

    public UnicodeSet getTargetSet() {
        return InvokeDynamicSupport.bootstrap("getTargetSet", $$robo$$android_icu_text_Transliterator$getTargetSet(), 0, this);
    }

    @Deprecated
    public void addSourceTargetSet(UnicodeSet unicodeSet, UnicodeSet unicodeSet2, UnicodeSet unicodeSet3) {
        InvokeDynamicSupport.bootstrap("addSourceTargetSet", $$robo$$android_icu_text_Transliterator$addSourceTargetSet(android.icu.text.UnicodeSet android.icu.text.UnicodeSet android.icu.text.UnicodeSet ), 0, this, unicodeSet, unicodeSet2, unicodeSet3);
    }

    @Deprecated
    public UnicodeSet getFilterAsUnicodeSet(UnicodeSet unicodeSet) {
        return InvokeDynamicSupport.bootstrap("getFilterAsUnicodeSet", $$robo$$android_icu_text_Transliterator$getFilterAsUnicodeSet(android.icu.text.UnicodeSet ), 0, this, unicodeSet);
    }

    public Transliterator getInverse() {
        return InvokeDynamicSupport.bootstrap("getInverse", $$robo$$android_icu_text_Transliterator$getInverse(), 0, this);
    }

    public static void registerClass(String string2, Class<? extends Transliterator> clazz, String string3) {
        InvokeDynamicSupport.bootstrapStatic("registerClass", $$robo$$android_icu_text_Transliterator$registerClass(java.lang.String java.lang.Class<? extends android.icu.text.Transliterator> java.lang.String ), 0, (String)string2, clazz, (String)string3);
    }

    public static void registerFactory(String string2, Factory factory) {
        InvokeDynamicSupport.bootstrapStatic("registerFactory", $$robo$$android_icu_text_Transliterator$registerFactory(java.lang.String android.icu.text.Transliterator$Factory ), 0, (String)string2, (Factory)factory);
    }

    public static void registerInstance(Transliterator transliterator) {
        InvokeDynamicSupport.bootstrapStatic("registerInstance", $$robo$$android_icu_text_Transliterator$registerInstance(android.icu.text.Transliterator ), 0, (Transliterator)transliterator);
    }

    static void registerInstance(Transliterator transliterator, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("registerInstance", $$robo$$android_icu_text_Transliterator$registerInstance(android.icu.text.Transliterator boolean ), 0, (Transliterator)transliterator, (boolean)bl);
    }

    public static void registerAlias(String string2, String string3) {
        InvokeDynamicSupport.bootstrapStatic("registerAlias", $$robo$$android_icu_text_Transliterator$registerAlias(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    static void registerSpecialInverse(String string2, String string3, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("registerSpecialInverse", $$robo$$android_icu_text_Transliterator$registerSpecialInverse(java.lang.String java.lang.String boolean ), 0, (String)string2, (String)string3, (boolean)bl);
    }

    public static void unregister(String string2) {
        InvokeDynamicSupport.bootstrapStatic("unregister", $$robo$$android_icu_text_Transliterator$unregister(java.lang.String ), 0, (String)string2);
    }

    public static Enumeration<String> getAvailableIDs() {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableIDs", $$robo$$android_icu_text_Transliterator$getAvailableIDs(), 0);
    }

    public static Enumeration<String> getAvailableSources() {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableSources", $$robo$$android_icu_text_Transliterator$getAvailableSources(), 0);
    }

    public static Enumeration<String> getAvailableTargets(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableTargets", $$robo$$android_icu_text_Transliterator$getAvailableTargets(java.lang.String ), 0, (String)string2);
    }

    public static Enumeration<String> getAvailableVariants(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableVariants", $$robo$$android_icu_text_Transliterator$getAvailableVariants(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    @Deprecated
    public static void registerAny() {
        InvokeDynamicSupport.bootstrapStatic("registerAny", $$robo$$android_icu_text_Transliterator$registerAny(), 0);
    }

    @Override
    public String transform(String string2) {
        return InvokeDynamicSupport.bootstrap("transform", $$robo$$android_icu_text_Transliterator$transform(java.lang.String ), 0, this, string2);
    }

    static {
        RobolectricInternals.classInitializing(Transliterator.class);
    }

    public /* synthetic */ Transliterator() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Transliterator)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface Factory
    extends InstrumentedInterface {
        public Transliterator getInstance(String var1);
    }

    public static class Position
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int contextStart;
        public int contextLimit;
        public int start;
        public int limit;
        static /* synthetic */ boolean $assertionsDisabled;

        private void $$robo$$android_icu_text_Transliterator_Position$__constructor__() {
        }

        private void $$robo$$android_icu_text_Transliterator_Position$__constructor__(int contextStart, int contextLimit, int start) {
        }

        private void $$robo$$android_icu_text_Transliterator_Position$__constructor__(int contextStart, int contextLimit, int start, int limit) {
            this.contextStart = contextStart;
            this.contextLimit = contextLimit;
            this.start = start;
            this.limit = limit;
        }

        private void $$robo$$android_icu_text_Transliterator_Position$__constructor__(Position pos) {
            this.set(pos);
        }

        private final void $$robo$$android_icu_text_Transliterator_Position$set(Position pos) {
            this.contextStart = pos.contextStart;
            this.contextLimit = pos.contextLimit;
            this.start = pos.start;
            this.limit = pos.limit;
        }

        private final boolean $$robo$$android_icu_text_Transliterator_Position$equals(Object obj) {
            if (obj instanceof Position) {
                Position pos = (Position)obj;
                return this.contextStart == pos.contextStart && this.contextLimit == pos.contextLimit && this.start == pos.start && this.limit == pos.limit;
            }
            return false;
        }

        @Deprecated
        private final int $$robo$$android_icu_text_Transliterator_Position$hashCode() {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"hashCode not designed");
            }
            return 42;
        }

        private final String $$robo$$android_icu_text_Transliterator_Position$toString() {
            return "[cs=" + this.contextStart + ", s=" + this.start + ", l=" + this.limit + ", cl=" + this.contextLimit + "]";
        }

        private final void $$robo$$android_icu_text_Transliterator_Position$validate(int length) {
            if (this.contextStart < 0 || this.start < this.contextStart || this.limit < this.start || this.contextLimit < this.limit || length < this.contextLimit) {
                throw new IllegalArgumentException("Invalid Position {cs=" + this.contextStart + ", s=" + this.start + ", l=" + this.limit + ", cl=" + this.contextLimit + "}, len=" + length);
            }
        }

        static void __staticInitializer__() {
            $assertionsDisabled = !Transliterator.class.desiredAssertionStatus();
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_Transliterator_Position$__constructor__();
        }

        public Position() {
            this(0, 0, 0, 0);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_Transliterator_Position$__constructor__(), 0, this);
        }

        private void __constructor__(int n, int n2, int n3) {
            this.$$robo$$android_icu_text_Transliterator_Position$__constructor__(n, n2, n3);
        }

        public Position(int n, int n2, int n3) {
            this(n, n2, n3, n2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_Transliterator_Position$__constructor__(int int int ), 0, this, n, n2, n3);
        }

        private void __constructor__(int n, int n2, int n3, int n4) {
            this.$$robo$$android_icu_text_Transliterator_Position$__constructor__(n, n2, n3, n4);
        }

        public Position(int n, int n2, int n3, int n4) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_Transliterator_Position$__constructor__(int int int int ), 0, this, n, n2, n3, n4);
        }

        private void __constructor__(Position position) {
            this.$$robo$$android_icu_text_Transliterator_Position$__constructor__(position);
        }

        public Position(Position position) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_Transliterator_Position$__constructor__(android.icu.text.Transliterator$Position ), 0, this, position);
        }

        public void set(Position position) {
            InvokeDynamicSupport.bootstrap("set", $$robo$$android_icu_text_Transliterator_Position$set(android.icu.text.Transliterator$Position ), 0, this, position);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_text_Transliterator_Position$equals(java.lang.Object ), 0, this, object);
        }

        @Deprecated
        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_text_Transliterator_Position$hashCode(), 0, this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_text_Transliterator_Position$toString(), 0, this);
        }

        public void validate(int n) {
            InvokeDynamicSupport.bootstrap("validate", $$robo$$android_icu_text_Transliterator_Position$validate(int ), 0, this, n);
        }

        static {
            RobolectricInternals.classInitializing(Position.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Position)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

