/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.text.Replaceable;
import android.icu.text.TransliterationRule;
import android.icu.text.Transliterator;
import android.icu.text.UTF16;
import android.icu.text.UnicodeSet;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TransliterationRuleSet
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private List<TransliterationRule> ruleVector;
    private int maxContextLength;
    private TransliterationRule[] rules;
    private int[] index;

    private void $$robo$$android_icu_text_TransliterationRuleSet$__constructor__() {
        this.ruleVector = new ArrayList<TransliterationRule>();
        this.maxContextLength = 0;
    }

    private final int $$robo$$android_icu_text_TransliterationRuleSet$getMaximumContextLength() {
        return this.maxContextLength;
    }

    private final void $$robo$$android_icu_text_TransliterationRuleSet$addRule(TransliterationRule rule) {
        this.ruleVector.add(rule);
        int len = rule.getAnteContextLength();
        if (len > this.maxContextLength) {
            this.maxContextLength = len;
        }
        this.rules = null;
    }

    private final void $$robo$$android_icu_text_TransliterationRuleSet$freeze() {
        int n = this.ruleVector.size();
        this.index = new int[257];
        ArrayList<TransliterationRule> v = new ArrayList<TransliterationRule>(2 * n);
        int[] indexValue = new int[n];
        for (int j = 0; j < n; ++j) {
            TransliterationRule r = this.ruleVector.get(j);
            indexValue[j] = r.getIndexValue();
        }
        for (int x = 0; x < 256; ++x) {
            this.index[x] = v.size();
            for (int j = 0; j < n; ++j) {
                if (indexValue[j] >= 0) {
                    if (indexValue[j] != x) continue;
                    v.add(this.ruleVector.get(j));
                    continue;
                }
                TransliterationRule r = this.ruleVector.get(j);
                if (!r.matchesIndexValue(x)) continue;
                v.add(r);
            }
        }
        this.index[256] = v.size();
        this.rules = new TransliterationRule[v.size()];
        v.toArray(this.rules);
        StringBuilder errors = null;
        for (int x = 0; x < 256; ++x) {
            for (int j = this.index[x]; j < this.index[x + 1] - 1; ++j) {
                TransliterationRule r1 = this.rules[j];
                for (int k = j + 1; k < this.index[x + 1]; ++k) {
                    TransliterationRule r2 = this.rules[k];
                    if (!r1.masks(r2)) continue;
                    if (errors == null) {
                        errors = new StringBuilder();
                    } else {
                        errors.append("\n");
                    }
                    errors.append("Rule " + r1 + " masks " + r2);
                }
            }
        }
        if (errors != null) {
            throw new IllegalArgumentException(errors.toString());
        }
    }

    private final boolean $$robo$$android_icu_text_TransliterationRuleSet$transliterate(Replaceable text, Transliterator.Position pos, boolean incremental) {
        int indexByte = text.char32At(pos.start) & 0xFF;
        for (int i = this.index[indexByte]; i < this.index[indexByte + 1]; ++i) {
            int m = this.rules[i].matchAndReplace(text, pos, incremental);
            switch (m) {
                case 2: {
                    return true;
                }
                case 1: {
                    return false;
                }
            }
        }
        pos.start += UTF16.getCharCount(text.char32At(pos.start));
        return true;
    }

    private final String $$robo$$android_icu_text_TransliterationRuleSet$toRules(boolean escapeUnprintable) {
        int count = this.ruleVector.size();
        StringBuilder ruleSource = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            if (i != 0) {
                ruleSource.append('\n');
            }
            TransliterationRule r = this.ruleVector.get(i);
            ruleSource.append(r.toRule(escapeUnprintable));
        }
        return ruleSource.toString();
    }

    private final void $$robo$$android_icu_text_TransliterationRuleSet$addSourceTargetSet(UnicodeSet filter, UnicodeSet sourceSet, UnicodeSet targetSet) {
        UnicodeSet currentFilter = new UnicodeSet(filter);
        UnicodeSet revisiting = new UnicodeSet();
        int count = this.ruleVector.size();
        for (int i = 0; i < count; ++i) {
            TransliterationRule r = this.ruleVector.get(i);
            r.addSourceTargetSet(currentFilter, sourceSet, targetSet, revisiting.clear());
            currentFilter.addAll(revisiting);
        }
    }

    private void __constructor__() {
        this.$$robo$$android_icu_text_TransliterationRuleSet$__constructor__();
    }

    public TransliterationRuleSet() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_TransliterationRuleSet$__constructor__(), 0, this);
    }

    public int getMaximumContextLength() {
        return (int)InvokeDynamicSupport.bootstrap("getMaximumContextLength", $$robo$$android_icu_text_TransliterationRuleSet$getMaximumContextLength(), 0, this);
    }

    public void addRule(TransliterationRule transliterationRule) {
        InvokeDynamicSupport.bootstrap("addRule", $$robo$$android_icu_text_TransliterationRuleSet$addRule(android.icu.text.TransliterationRule ), 0, this, transliterationRule);
    }

    public void freeze() {
        InvokeDynamicSupport.bootstrap("freeze", $$robo$$android_icu_text_TransliterationRuleSet$freeze(), 0, this);
    }

    public boolean transliterate(Replaceable replaceable, Transliterator.Position position, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("transliterate", $$robo$$android_icu_text_TransliterationRuleSet$transliterate(android.icu.text.Replaceable android.icu.text.Transliterator$Position boolean ), 0, this, replaceable, position, bl);
    }

    String toRules(boolean bl) {
        return InvokeDynamicSupport.bootstrap("toRules", $$robo$$android_icu_text_TransliterationRuleSet$toRules(boolean ), 0, this, bl);
    }

    void addSourceTargetSet(UnicodeSet unicodeSet, UnicodeSet unicodeSet2, UnicodeSet unicodeSet3) {
        InvokeDynamicSupport.bootstrap("addSourceTargetSet", $$robo$$android_icu_text_TransliterationRuleSet$addSourceTargetSet(android.icu.text.UnicodeSet android.icu.text.UnicodeSet android.icu.text.UnicodeSet ), 0, this, unicodeSet, unicodeSet2, unicodeSet3);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TransliterationRuleSet)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

